﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" 
    CodeFile="Patients.aspx.cs" Inherits="Patients" Title="MSSR: Patients" %>

<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .filterPanel {
            width: 99%;
            border: 2px solid #333333;
            background-color: #F7F7F7;
        }
    </style>

    <script type="text/javascript">
        function ShowHideMedDdl() {
            //Get dropdown selected value
            var SelectedValue = $('#<%= ddlOnNotOn.ClientID %> option:selected').val();

            if (SelectedValue == 'Any') {
                // disable the Meds dropdown list
                document.getElementById('<%= ddlMeds.ClientID %>').disabled = true;
                document.getElementById('<%= ddlMeds.ClientID %>').selectedIndex = 0;
            }
            else if (SelectedValue == 'On') {
                document.getElementById('<%= ddlMeds.ClientID %>').disabled = false;
            }
            else if (SelectedValue = 'Off') {
                document.getElementById('<%= ddlMeds.ClientID %>').disabled = false;
            }
}
    </script>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <!-- Hidden Variables for Paging -->
    <asp:HiddenField ID="HiddenFieldCurrentPageNumber" runat="server" Value="0" Visible="false" />
    <asp:HiddenField ID="HiddenFieldPageCount" runat="server" Value="0" Visible="false" />
    <asp:HiddenField ID="HiddenFieldTotalRecords" runat="server" Value="0" Visible="false" />
    <asp:HiddenField ID="HiddenFieldSortExpression" runat="server" Value="" Visible="false" />
    <asp:HiddenField ID="HiddenFieldSortDirection" runat="server" Value="" Visible="false" />
    <div class="excludeSaveWarnings" style="background-color: #333333; color: #FFFFFF; width: 99%; font-size: 10.5pt; font-weight: bold; border: 2px solid #333333; border-bottom: 1px solid #333333">
        &nbsp; Filters
                <asp:Button ID="lnkBtnToggleFilters" runat="server" Text="Hide" ToolTip="Click to show/hide filters."
                    OnClick="lnkBtnToggleFilters_OnClick" TabIndex="101" />
    </div>
    <asp:Panel ID="pnlFilterArea" runat="server" CssClass="filterPanel">
        <div class="excludeSaveWarnings">
            <table style="width: 100%; padding: 5px;">
                <tr>
                    <td style="width: 33%;">
                        <asp:Label ID="LabelForPatientNameSSN" runat="server" AssociatedControlID="txtNameSoSeNo" TabIndex="102" CssClass="FilterLabel">Name or SSN4</asp:Label>:
                                <br />
                        <asp:TextBox ID="txtNameSoSeNo" runat="server" ToolTip="Enter patient name or last four of SSN"
                            TabIndex="103"></asp:TextBox>
                    </td>
                    <td style="width: 33%;">
                        <asp:Label ID="LabelForLocation" runat="server" AssociatedControlID="ddlFacility" TabIndex="104" CssClass="FilterLabel">Location</asp:Label>:
                                <br />
                        <asp:DropDownList ID="ddlFacility" runat="server" TabIndex="105" ToolTip="Location or Facility selection" CssClass="FilterNormalText">
                        </asp:DropDownList>
                        <br />
                        <asp:Label ID="lblFacFiltered" Visible="false" runat="server" Font-Size="XX-Small" TabIndex="106"
                            Text="(Facility list has been filtered based on your role.)"></asp:Label>
                    </td>
                    <td style="width: 33%;">
                        <asp:Label ID="LabelForDiagnosis" runat="server" AssociatedControlID="ddlDiagnosis" TabIndex="107" CssClass="FilterLabel">Diagnosis</asp:Label>:
                                <br />
                        <asp:DropDownList ID="ddlDiagnosis" runat="server" TabIndex="108" ToolTip="Diagnosis selection" CssClass="FilterNormalText">
                            <asp:ListItem Selected="True" Value="All">Any Diagnosis</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="MS">Multiple Sclerosis</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="RRMS">Relapsing-Remitting MS</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="SPMS">Secondary Progressive MS</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="PPMS">Primary Progressive MS</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="PRMS">Progressive-Relapsing MS</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="POSSIBLE MS">Possible MS</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="CIS">Clinically Isolated Syndrome</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="NMO">Neuromyelitis (NMO)</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="NOT MS">Determined NOT to have MS</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <asp:Label ID="LabelForDataSource" runat="server" AssociatedControlID="rblSource" TabIndex="109" CssClass="FilterLabel">Source</asp:Label>:<br />
                        <asp:RadioButtonList ID="rblSource" runat="server" RepeatDirection="Horizontal" CssClass="FilterNormalText" ToolTip="Data Source selection" EnableViewState="true"
                            TabIndex="110">
                            <asp:ListItem Value="Culpepper" Selected="False" Enabled="False" Text="Culpepper Alg."></asp:ListItem>
                            <asp:ListItem Value="NonAssessment" Selected="False" Enabled="False" Text="Non-MS Assessment"></asp:ListItem>
                            <asp:ListItem Value="Assessment" Selected="True" Text="MS Assessment" Enabled="False"></asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                    <td>
                        <asp:Label ID="LabelForAssessmentDue" runat="server" AssociatedControlID="ddlAssessmentDue" TabIndex="111" CssClass="FilterLabel">Next Assessment Due</asp:Label>:<br />
                        <asp:DropDownList ID="ddlAssessmentDue" runat="server" TabIndex="112" ToolTip="Next Assessment Due selection" CssClass="FilterNormalText">
                            <asp:ListItem Value="Anytime">Anytime</asp:ListItem>
                            <asp:ListItem Value="Now">Now</asp:ListItem>
                            <asp:ListItem Value="1">In next 30 days</asp:ListItem>
                            <asp:ListItem Value="2">In next 2 months</asp:ListItem>
                            <asp:ListItem Value="3">In next 3 months</asp:ListItem>
                            <asp:ListItem Value="6">In next 6 months</asp:ListItem>
                            <asp:ListItem Value="6Plus">Due > 6 months</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="LabelForGender" runat="server" AssociatedControlID="rblGender" TabIndex="113" CssClass="FilterLabel">Gender</asp:Label>:<br />
                        <asp:RadioButtonList ID="rblGender" runat="server" CssClass="FilterNormalText" RepeatDirection="Horizontal"
                            TabIndex="114" ToolTip="Gender selection">
                            <asp:ListItem Selected="True" Value="All">Any Gender</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="M">Male</asp:ListItem>
                            <asp:ListItem Enabled="True" Value="F">Female</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                    <td>
                        <asp:Label ID="LabelForEdmusScoreBetween" runat="server" AssociatedControlID="ddlMSScore1" TabIndex="115" CssClass="FilterLabel">EDMUS Score between</asp:Label>:<br />
                        <asp:DropDownList ID="ddlMSScore1" runat="server" TabIndex="116" ToolTip="EDMUS Score starting range selection" CssClass="FilterNormalText">
                           <asp:ListItem Value="0">Start</asp:ListItem>
                            <asp:ListItem Value="1">1</asp:ListItem>
                            <asp:ListItem Value="2">2</asp:ListItem>
                            <asp:ListItem Value="3">3</asp:ListItem>
                            <asp:ListItem Value="4">4</asp:ListItem>
                            <asp:ListItem Value="5">5</asp:ListItem>
                            <asp:ListItem Value="6">6</asp:ListItem>
                            <asp:ListItem Value="7">7</asp:ListItem>
                            <asp:ListItem Value="8">8</asp:ListItem>
                            <asp:ListItem Value="9">9</asp:ListItem>
                            <asp:ListItem Value="10">10</asp:ListItem>
                        </asp:DropDownList>
                        and
                                <label for="ddlMSScore2" title="EDMUS Score ending range selection" />
                        <asp:DropDownList ID="ddlMSScore2" runat="server" TabIndex="117" ToolTip="EDMUS Score ending range selection" CssClass="FilterNormalText">
                           <asp:ListItem Value="0">End</asp:ListItem>
                            <asp:ListItem Value="1">1</asp:ListItem>
                            <asp:ListItem Value="2">2</asp:ListItem>
                            <asp:ListItem Value="3">3</asp:ListItem>
                            <asp:ListItem Value="4">4</asp:ListItem>
                            <asp:ListItem Value="5">5</asp:ListItem>
                            <asp:ListItem Value="6">6</asp:ListItem>
                            <asp:ListItem Value="7">7</asp:ListItem>
                            <asp:ListItem Value="8">8</asp:ListItem>
                            <asp:ListItem Value="9">9</asp:ListItem>
                            <asp:ListItem Value="10">10</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:Label ID="LabelForRelapses" runat="server" AssociatedControlID="rblRelapses" TabIndex="118" CssClass="FilterLabel">Relapses Past Year</asp:Label>:<br />
                        <asp:RadioButtonList ID="rblRelapses" runat="server" CssClass="FilterNormalText" RepeatDirection="Horizontal"
                            TabIndex="119" ToolTip="Number of Reported Relapses selection">
                            <asp:ListItem Selected="true" Value="All">Any Number</asp:ListItem>
                            <asp:ListItem Value="0">0</asp:ListItem>
                            <asp:ListItem Value="1">1</asp:ListItem>
                            <asp:ListItem Value="2">>1</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>

            </table>
            <fieldset>
                <legend><strong>DMT MS Medications</strong></legend>
                <table style="width: auto; padding: 5px;">
                    <tr>
                        <td style="width: auto; padding: 5px" >
                            <asp:Label ID="LabelForMedOnNotOn" ToolTip="Medication Status, On or Not On" runat="server" AssociatedControlID="ddlOnNotOn" TabIndex="120" CssClass="FilterLabel">Status</asp:Label>:<br />
                            <asp:DropDownList ID="ddlOnNotOn" runat="server" TabIndex="121" ToolTip="DMT Medications status selection" CssClass="FilterNormalText"
                                onchange="ShowHideMedDdl();">
                                <asp:ListItem Value="Any" Selected="True">Any</asp:ListItem>
                                <asp:ListItem Value="On">On</asp:ListItem>
                                <asp:ListItem Value="NotOn">Not On</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td style="width: auto; padding: 5px">
                            <asp:Label ID="LabelForCurrentEver" ToolTip="Medication Timeframe, Current or Ever" runat="server" AssociatedControlID="ddlMedsCurrentEver" TabIndex="122" CssClass="FilterLabel">Medication Usage Timeframe</asp:Label>:<br />
                            <asp:DropDownList ID="ddlMedsCurrentEver" runat="server" TabIndex="123" ToolTip="DMT Medication timeframe selection" CssClass="FilterNormalText">
                                <asp:ListItem Value="All" Selected="True">Currently</asp:ListItem>
                                <asp:ListItem Value="Ever">Ever</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td style="width: auto; padding: 5px">
                            <asp:Label ID="LabelForMeds" ToolTip="Medications" runat="server" AssociatedControlID="ddlMeds" TabIndex="124" CssClass="FilterLabel">Meds</asp:Label>:<br />
                            <asp:DropDownList ID="ddlMeds" runat="server" TabIndex="125" ToolTip="DMT Medication selection"
                                CssClass="FilterNormalText" Enabled="false">
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </fieldset>
            <table style="width: 100%; padding: 5px;">
                <tr>
                    <td colspan="100%">
                        <asp:Button ID="btnGo" Height="25px" runat="server" Text="View Results" Enabled="true"
                            OnClick="btnGo_Click" ToolTip="View Results" TabIndex="200" />
                        <asp:Button ID="btnClear" Height="25px" runat="server" Text="Reset" Enabled="true"
                            OnClick="btnClear_Click" ToolTip="Clear Filters" TabIndex="201" />
                    </td>
                </tr>
            </table>
        </div>
    </asp:Panel>
    <br />
    <asp:GridView ID="grdMSPatients" AutoGenerateColumns="False" CellPadding="5" Width="99.5%"
        EmptyDataText="Currently, showing no data. Please select filters from above and click the 'View Results' button."
        AllowSorting="true" OnSorting="grdMSPatients_Sorting" runat="server" Height="2px" DataKeyNames="PatientICN, Sta3n"
        Font-Size="Smaller" BorderWidth="2" BorderStyle="Solid" BorderColor="#CCCCCC" Caption="List of Patients."
        OnRowDataBound="grdMSPatients_RowDataBound" OnRowCreated="grdMSPatients_RowCreated"
        TabIndex="202" PageSize="10" CaptionAlign="Left">
        <HeaderStyle CssClass="FrozenHeader" />
        <AlternatingRowStyle BackColor="#F4F4F4" />
        <Columns>
            <asp:TemplateField HeaderText="Create Survey" AccessibleHeaderText="Click to Create Survey." Visible="false">
                <ItemTemplate>                
                    <asp:ImageButton ID="imgBtnCreateSurvey" CommandName="UPDATE" AlternateText="Create Survey" OnCommand="Create_Surveys"
                                     ToolTip="Click to Create Survey." ImageUrl="~/images/create_survey.png" CommandArgument='<%#AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("PatientICN"))) + "," + AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("Sta3n"))) %>'
                                     runat="server" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Edit Survey" AccessibleHeaderText="Click to Review List of Surveys." Visible="false">
                <ItemTemplate>                
                    <asp:ImageButton ID="imgBtnReviewSurveys" CommandName="UPDATE" AlternateText="View AvailableSurveys By Patient ICN" OnCommand="Edit_Surveys"
                                     ToolTip="Click to Review Surveys by Patient ICN." ImageUrl="~/images/EditTableHS.png" CommandArgument='<%#AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("PatientICN"))) %>' 
                                     runat="server" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Patient Name (SSN4)" SortExpression="NameSSN" AccessibleHeaderText="Patient Name and last four of SSN">
                <ItemTemplate>
                    <a href="PatientDetails.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see patient details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NameSSN"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Sta3n" HeaderText="Facility ID" SortExpression="Sta3n" AccessibleHeaderText="Facility ID" />
            <asp:BoundField DataField="VISTANAME" HeaderText="Facility" SortExpression="VISTANAME" AccessibleHeaderText="Facility Name" />
            <asp:BoundField DataField="Age" HeaderText="Age" SortExpression="Age" AccessibleHeaderText="Patient Age" />
            <asp:BoundField DataField="Gender" HeaderText="Gender" SortExpression="Gender" AccessibleHeaderText="Patient Gender" />
            <asp:BoundField DataField="RaceEthnicity" HeaderText="Race/Ethnicity" SortExpression="RaceEthnicity"
                AccessibleHeaderText="Patient Race / Ethnicity" />
            <asp:BoundField DataField="BaselineAssessDate" DataFormatString="{0:MM/dd/yyyy}"
                HeaderText="Baseline" SortExpression="BaselineAssessDate" AccessibleHeaderText="Baseline Assessment Date" />
            <asp:BoundField DataField="LastAssessDate" DataFormatString="{0:MM/dd/yyyy}" HeaderText="Last Assessment"
                SortExpression="LastAssessDate" AccessibleHeaderText="Last Assessment Date" />
            <asp:BoundField DataField="LastSymptomYear" HeaderText="Year of 1st Symptom"
                SortExpression="LastSymptomYear" AccessibleHeaderText="Last Symptom Year" />
            <asp:BoundField DataField="MSDiagnosis" HeaderText="Dx" SortExpression="MSDiagnosis"
                AccessibleHeaderText="MS Diagnosis" />
            <asp:BoundField DataField="LastMSSubType" HeaderText="MS Subtype" SortExpression="LastMSSubType"
                AccessibleHeaderText="MS Subtype" />
            <asp:BoundField DataField="LastRelapses" HeaderText="Relapses past Yr." SortExpression="LastRelapses"
                AccessibleHeaderText="Number of relapses in past year" />
            <asp:BoundField DataField="LastEdumsScore" HeaderText="Current EDMUS Score" SortExpression="LastEdumsScore"
                AccessibleHeaderText="Last EDMUS score" />
            <asp:BoundField DataField="PreviousEdmusScore" HeaderText="Prev. EDMUS" SortExpression="PreviousEdmusScore"
                AccessibleHeaderText="Previous EDMUS score" />
            <asp:BoundField DataField="RxAll" HeaderText="Current Rx" SortExpression="RxAll"
                AccessibleHeaderText="Current Medications" />
            <asp:BoundField DataField="OTHER_DMT_NAME" HeaderText="Current Rx Other" SortExpression="OTHER_DMT_NAME"
                AccessibleHeaderText="Other Medications" />
            <asp:TemplateField Visible="false" HeaderText="No. Of Prosthetics" SortExpression="ProstheticsCount" AccessibleHeaderText="Prosthetics">
                <ItemTemplate>
                    <a href="Prosthetics.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Prosthetics details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("ProstheticsCount"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField Visible="false" HeaderText="No. Of Pharmacy" SortExpression="PharmacyCount" AccessibleHeaderText="Pharmacy">
                <ItemTemplate>
                    <a href="Pharmacy.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Pharmacy details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PharmacyCount"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField Visible="false" HeaderText="No. Of Labs" SortExpression="LabCount" AccessibleHeaderText="Lab">
                <ItemTemplate>
                    <a href="Lab.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Lab details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("LabCount"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField Visible="false" HeaderText="No. Of Radiology" SortExpression="RadioCount" AccessibleHeaderText="Radiology">
                <ItemTemplate>
                    <a href="Radiology.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Radiology details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("RadioCount"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField Visible="false" HeaderText="No. Of Inpatient Fee" SortExpression="NumOfFeeInpatient"
                AccessibleHeaderText="FeeInpatient">
                <ItemTemplate>
                    <a href="FeeInpatient.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Inpatient Fee details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NumOfFeeInpatient"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField Visible="false" HeaderText="No. Of Service Provided" SortExpression="NumOfFeeOutpatient"
                AccessibleHeaderText="FeeOutpatient">
                <ItemTemplate>
                    <a href="FeeServiceProvided.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Outpatient Fee details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NumOfFeeOutpatient"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField Visible="false" HeaderText="No. Of Pharmacy Fee" SortExpression="NumOfFeePharmacy"
                AccessibleHeaderText="FeePharmacy">
                <ItemTemplate>
                    <a href="FeePharmacy.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Pharmacy Fee details">
                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NumOfFeePharmacy"))) %></a>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <br />
    <asp:Panel ID="pnlPagingControls" runat="server">
        <div class="excludeSaveWarnings">
            <table>
                <tr>
                    <td style="vertical-align: middle;">
                        <asp:Button ID="btnFirstPage" runat="server" Text="<<" ToolTip="First Page of Results"
                            OnClick="btnFirstPage_Click" TabIndex="210" />
                        <asp:Button ID="btnPrevPage" runat="server" Text="<" ToolTip="Previous Page of Results"
                            OnClick="btnPrevPage_Click" TabIndex="211" />
                        <asp:Button ID="btnNextPage" runat="server" Text=">" ToolTip="Next Page of Results"
                            OnClick="btnNextPage_Click" TabIndex="212" />
                        <asp:Button ID="btnLastPage" runat="server" Text=">>" ToolTip="Last Page of Results"
                            OnClick="btnLastPage_Click" TabIndex="213" />
                        <asp:Label ID="lblPageStatus" runat="server" ToolTip="Current Page Status" TabIndex="214" />
                    </td>
                    <td style="width: 15px; font-size: 1px;">&nbsp;
                    </td>
                    <td style="vertical-align: middle;">
                        <asp:Label ID="LabelForResultsPerPage" runat="server" AssociatedControlID="ddlPageSize" TabIndex="215">Results per page</asp:Label>:
                                <asp:DropDownList runat="server" ID="ddlPageSize" AutoPostBack="true" TabIndex="216" ToolTip="Page Size Selections">
                                    <asp:ListItem Text="10" Value="10"></asp:ListItem>
                                    <asp:ListItem Text="25" Value="25"></asp:ListItem>
                                    <asp:ListItem Text="50" Value="50"></asp:ListItem>
                                    <asp:ListItem Text="100" Value="100"></asp:ListItem>
                                    <asp:ListItem Text="All" Value="-1"></asp:ListItem>
                                </asp:DropDownList>
                    </td>
                    <td style="width: 15px; font-size: 1px;">&nbsp;
                    </td>
                    <td style="vertical-align: middle;">
                        <asp:ImageButton ID="imgBtnExportToExcel" runat="server" AlternateText="Export Grid to Excel" TabIndex="217"
                            ToolTip="Export Grid to Excel" ImageUrl="~/images/export-icon.gif" OnClick="imgBtnExportToExcel_Click" />
                    </td>
                </tr>
            </table>
        </div>
    </asp:Panel>
    <br />
    <asp:Panel ID="pnlRecordCount" runat="server" Visible="false">
        <asp:Label ID="LabelForRecordCount" runat="server" AssociatedControlID="lblRecordCount" TabIndex="218">Record Total</asp:Label>: 
                <asp:Label ID="lblRecordCount" runat="server" Text="lblRecordCount" TabIndex="219"
                    ToolTip="Record Count in Search Results"></asp:Label>
    </asp:Panel>

</asp:Content>
