﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="PatientDetails.aspx.cs" Inherits="PatientDetails" Title="MSSR: Patient Details" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Charting" Assembly="Telerik.Web.UI" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <Triggers>
            <asp:PostBackTrigger ControlID="imgBtnExportToExcel" />
        </Triggers>
        <ContentTemplate>
            <asp:UpdateProgress ID="UpdateProgress1" runat="server">
                <ProgressTemplate>
                    <div style="padding: 5px;">
                        <img src="images/ajax-loader.gif" alt="Loading Image" />
                        Loading, Please Wait ...
                    </div>
                </ProgressTemplate>
            </asp:UpdateProgress>
            <table style="width: 100%;" cellpadding="5">
                <tr>
                    <td class="patientDetailsHeader">
                        <asp:Label ID="lblPatientName" runat="server" ToolTip="Patient Name and Last 4 of SSN"
                            TabIndex="100">
                            <%=patient.PatientName %> - XXX-XX-<%=patient.PatientSoSeN.Substring(patient.PatientSoSeN.Length - 4) %>
                        </asp:Label>
                    </td>
                    <td style="vertical-align: middle;">
                        <asp:ImageButton ID="imgBtnExportToExcel" runat="server" AlternateText="Export Grid to Excel"
                            TabIndex="101" ToolTip="Export Grid to Excel" ImageUrl="~/images/export-icon.gif"
                            OnClick="imgBtnExportToExcel_Click" />
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient Demographics</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    <asp:Label ID="LabelForDemographicHeader" runat="server" TabIndex="102">
                                        DEMOGRAPHICS
                                    </asp:Label>
                                </th>
                            </tr>
                            <tr>
                                <td style="width: 100px;">
                                    <asp:Label ID="LabelForPCP" runat="server" TabIndex="103" AssociatedControlID="LabelForPCPValue">PCP</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForPCPValue" runat="server" TabIndex="104" ToolTip="PCP Value">Not Available</asp:Label>&nbsp;
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                                <td style="width: 100px;">
                                    <asp:Label ID="LabelForAge" runat="server" TabIndex="105" AssociatedControlID="LabelForAgeValue">
                                        Age
                                    </asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForAgeValue" runat="server" ToolTip="Age Value" TabIndex="106">
                                        <%=patient.Age %>
                                    </asp:Label>
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForPACTRN" runat="server" TabIndex="107" AssociatedControlID="LabelForPACTRNValue">
                                        PACT RN
                                    </asp:Label>
                                    :&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForPACTRNValue" runat="server" TabIndex="108" ToolTip="PACT RN Value">
                                        Not Available
                                    </asp:Label>&nbsp;
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForGender" runat="server" TabIndex="109" AssociatedControlID="LabelForGenderValue">
                                    Gender
                                    </asp:Label>
                                    :&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForGenderValue" runat="server" TabIndex="110" ToolTip="Gender Value">
                                    <%=patient.Gender %>
                                    </asp:Label>&nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForFacility" runat="server" TabIndex="111" AssociatedControlID="LabelForFacilityValue">Facility</asp:Label>:
                                </td>
                                <td>
                                    <asp:Label ID="LabelForFacilityValue" runat="server" TabIndex="112" ToolTip="Facility Value"><%=currentStatus.Sta3n %></asp:Label>&nbsp;
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForRace" runat="server" TabIndex="113" AssociatedControlID="LabelForRaceValue">Race</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForRaceValue" runat="server" TabIndex="114" ToolTip="Race Value"><%=patient.Race %></asp:Label>&nbsp;
                                </td>
                            </tr>
                                                        <tr>
                                <td>
                                    <asp:Label ID="LabelForDOD" runat="server" TabIndex="111" AssociatedControlID="LabelForDODValue">Date Of Death</asp:Label>:
                                </td>
                                <td>
                                    <asp:Label ID="LabelForDODValue" runat="server" TabIndex="112" ToolTip=">Date Of Death Value"><%=patientDOD%></asp:Label>&nbsp;
                                </td>
                                <td>
                                    &nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForCOD" runat="server" TabIndex="113" AssociatedControlID="LabelForCODValue">Cause Of Death</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForCODValue" runat="server" TabIndex="114" ToolTip=">Cause Of Death Value"><%=patient.CauseOfDeath %></asp:Label>&nbsp;
                                </td>
                            </tr>

                        </table>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient MS DIAGNOSIS</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    <asp:Label ID="LabelForMSDx" runat="server" AssociatedControlID="lblMSDiagnosis"
                                        TabIndex="115" ToolTip="MS Diagnosis">MS DIAGNOSIS</asp:Label>
                                    -
                                    <asp:Label ID="lblMSDiagnosis" runat="server" ToolTip="MS Diagnosis" TabIndex="116" />
                                </th>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForYearOfSymptomOnset" runat="server" TabIndex="117" AssociatedControlID="LabelForYearOfSymptomOnsetValue">Year of Symptom Onset</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForYearOfSymptomOnsetValue" runat="server" TabIndex="118" ToolTip="Year of Symptom Onset Value"><%=currentStatus.LastSymptomYear %></asp:Label>&nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForYearofSymptomDiagnosis" runat="server" AssociatedControlID="LabelForYearofSymptomDiagnosisValue">Year of Symptom Diagnosis</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForYearofSymptomDiagnosisValue" runat="server" ToolTip="Year of Symptom Diagnosis"><%=currentStatus.LastDiagnosisYear%></asp:Label>&nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForMsSubtype" runat="server" TabIndex="119" AssociatedControlID="LabelForMSSubtypeValue">MS Subtype</asp:Label>:&nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForMSSubtypeValue" runat="server" TabIndex="120" ToolTip="MS Subtype"><%=currentStatus.LastMSSubType%></asp:Label>&nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label ID="LabelForFamilyHistory" runat="server" TabIndex="121" AssociatedControlID="LabelForFamilyHistoryValue">Family History</asp:Label>:
                                    <!--(if yes, display data, if no - "No", if no assessment "UNK")-->
                                    &nbsp;
                                </td>
                                <td>
                                    <asp:Label ID="LabelForFamilyHistoryValue" runat="server" TabIndex="122" ToolTip="Family History Value"><%=familyHistory %></asp:Label>&nbsp;
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!--<tr>
                    <td style="width:50%; vertical-align:top;" colspan="2">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <tr>
                                <th colspan="100%" class="patientDetailsTableHeader">
                                    APPOINTMENTS
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    Possibly Future - Don't readily have this available.<br />
                                    Last PCP Visit, Next PCP Visit, Last Neurology Visit, Next Neurology Visit, Next Medical Center Appointment: (service  / facility) (date)
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>-->
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient MS/NMO MEDICATIONS</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    MS/NMO MEDICATIONS:
                                    <%=((DateTime)currentStatus.LastAssessDate).ToShortDateString() %>
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    <!-- Grid for Medications -->
                                    <%--Medication, Start Date, Stop Date, # Doses (X, N/A, UNK), ADR
                                    <br />--%>
                                    <asp:GridView ID="gvCurrentMeds" runat="server" AutoGenerateColumns="false" Width="100%" Caption="List of Current Medication."
                                        GridLines="None" TabIndex="123" ToolTip="Current Medication Grid" EmptyDataText="Currently, no medications on record">
                                        <Columns>
                                            <asp:BoundField DataField="Name" HeaderText="Name" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="DispensingPharmacy" HeaderText="Dispensing Pharmacy" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="Current" HeaderText="Current Med" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="ApproxDateStarted" HeaderText="Approx Date Started" DataFormatString="{0:MM/dd/yyyy}" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="ApproxDateStopped" HeaderText="Approx Date Stopped" DataFormatString="{0:MM/dd/yyyy}" HeaderStyle-HorizontalAlign="Left" />
                                        </Columns>
                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" HorizontalAlign="Left" />
                                        <RowStyle CssClass="gridViewRow" HorizontalAlign="Left" />
                                        <HeaderStyle CssClass="gridViewHeaderHC" HorizontalAlign="Left" />
                                    </asp:GridView>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient MS/NMO Medications: Current VA Dispensed</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    MS/NMO Medications: Current VA Dispensed
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    <!-- Grid for Medications -->
                                    <%--Medication, Start Date, Dose, Sig, Last Release (Date)<br />--%>
                                    <asp:GridView ID="gvCurrentVAMeds" runat="server" AutoGenerateColumns="false" Width="100%" Caption="Current VA dispensed medications"
                                        GridLines="None" TabIndex="124" ToolTip="Current VA dispensed medications" EmptyDataText="Currently, no Current VA Medications on record">
                                        <Columns>
                                            <asp:BoundField DataField="Name" HeaderText="Name" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="ApproxDateStarted" HeaderText="Approx Date Started" DataFormatString="{0:MM/dd/yyyy}" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="Schedule" HeaderText="Schedule" HeaderStyle-HorizontalAlign="Left" />
                                            
                                        </Columns>
                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" HorizontalAlign="Left" />
                                        <RowStyle CssClass="gridViewRow" HorizontalAlign="Left" />
                                        <HeaderStyle CssClass="gridViewHeaderHC" HorizontalAlign="Left" />
                                    </asp:GridView>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient MS/NMO Medications: Corticosteroids</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    MS/NMO Medications: Corticosteroids
                                </th>
                            </tr>
                            <tr>
                                <td colspan="50%">
                                    <asp:GridView ID="gvCurrentCORTMeds" runat="server" AutoGenerateColumns="false" Width="100%"
                                        GridLines="None" TabIndex="124" ToolTip="Corticosteroids medications" EmptyDataText="Currently, no Current Corticosteroids Medications on record">
                                        <Columns>
                                            <asp:BoundField DataField="Name" HeaderText="Name" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="DispensingPharmacy" HeaderText="Pharmacy" HeaderStyle-HorizontalAlign="Left" />
											<asp:BoundField DataField="ApproxDateStarted" HeaderText="Date Started" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="ApproxDateStopped" HeaderText="Date Stopped" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="Schedule" HeaderText="Schedule" HeaderStyle-HorizontalAlign="Left" />
                                        </Columns>
                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" HorizontalAlign="Left" />
                                        <RowStyle CssClass="gridViewRow" HorizontalAlign="Left" />
                                        <HeaderStyle CssClass="gridViewHeaderCORTHC" HorizontalAlign="Left" />
                                    </asp:GridView>
                                </td>
                               
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Survey History</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    Survey History
                                </th>
                            </tr>
                            <tr>
                                <td>
                                    <asp:GridView ID="grdViewSurveyHistory" runat="server" AutoGenerateColumns="false" Width="100%"
                                        GridLines="None" TabIndex="124" ToolTip="Survey History" EmptyDataText="No Survey History Available.">
                                        <Columns>
                                            <asp:BoundField DataField="Assessment_Date" AccessibleHeaderText="Assessment Date" HeaderText="Assessment Date" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="Created_By" AccessibleHeaderText="Created By" HeaderText="Created By" HeaderStyle-HorizontalAlign="Left" />
											<asp:BoundField DataField="Survey_ID" AccessibleHeaderText="Survey ID" HeaderText="Survey ID" HeaderStyle-HorizontalAlign="Left" />
                                            <asp:BoundField DataField="Created_Date" AccessibleHeaderText="Created Date" HeaderText="Created Date" HeaderStyle-HorizontalAlign="Left" />
                                            
                                        </Columns>
                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" HorizontalAlign="Left" />
                                        <RowStyle CssClass="gridViewRow" HorizontalAlign="Left" />
                                        <HeaderStyle CssClass="gridViewHeaderCORTHC" HorizontalAlign="Left" />
                                    </asp:GridView>

                                </td>
                            </tr>
                            </table>

                    </td>

                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient EDMUS SCORE</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    EDMUS SCORE
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    <div class="patientDetailsScrollableContentArea">
                                        <table style="width: 100%;">
                                            <tr>
                                                <td style="vertical-align: top;">
                                                    <!-- Grid -->
                                                    <asp:GridView ID="grdEdmusScores" runat="server" Width="100%" AutoGenerateColumns="false" Caption="EDMUS Scores"
                                                        HeaderStyle-HorizontalAlign="Left" TabIndex="125" ToolTip="EDMUS Scores" HorizontalAlign="Left"
                                                        GridLines="None" EmptyDataText="Currently, no EDMUS scores on record">
                                                        <Columns>
                                                            
                                                            <asp:BoundField DataField="AssessmentDateTime" SortExpression="AssessmentDateTime"
                                                                HeaderText="Assessment Date" AccessibleHeaderText="Assessment Date" HeaderStyle-HorizontalAlign="Left" />
                                                            <asp:BoundField DataField="CurrentDisabilityScore" SortExpression="CurrentDisabilityScore"
                                                                HeaderText="Score" AccessibleHeaderText="Current Disability Score" HeaderStyle-HorizontalAlign="Left" />
                                                        </Columns>
                                                        <RowStyle CssClass="gridViewRow" />
                                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" />
                                                    </asp:GridView>
                                                </td>
                                                <%--<td style="vertical-align:top;">
                                                    <!-- Chart -->
                                                </td>--%>
                                            </tr>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient RELAPSES</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    RELAPSES
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    <div class="patientDetailsScrollableContentArea">
                                        <table style="width: 100%;">
                                            <tr>
                                                <td style="vertical-align: top;">
                                                    <asp:GridView ID="grdRelapses" runat="server" Width="100%" AutoGenerateColumns="false"
                                                        HeaderStyle-HorizontalAlign="Left" TabIndex="126" ToolTip="Reported Relapses" Caption="Reported Relapse Score"
                                                        HorizontalAlign="Left" GridLines="None" EmptyDataText="Currently, no relapses on record">
                                                        <Columns>                                                            
                                                            <asp:BoundField DataField="AssessmentDateTime" SortExpression="AssessmentDateTime" HeaderText="Assessment Date"
                                                                AccessibleHeaderText="Assessment Date" HeaderStyle-HorizontalAlign="Left" />
                                                            <asp:BoundField DataField="Relapses" SortExpression="Relapses" HeaderText="Relapses in Past Year"
                                                                AccessibleHeaderText="Relapses in Past Year" HeaderStyle-HorizontalAlign="Left" />
                                                        </Columns>
                                                        <RowStyle CssClass="gridViewRow" />
                                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" />
                                                    </asp:GridView>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="width: 50%; vertical-align: top;">
                        <table width="100%" cellspacing="0" cellpadding="3" class="patientDetailsTable">
                            <caption>Patient LATEST VITAL SIGNS</caption>
                            <tr>
                                <th scope="colgroup" colspan="100%" class="patientDetailsTableHeader">
                                    LATEST VITAL SIGNS
                                    <asp:Label ID="lblLatestVitalDate" runat="server" ToolTip="Date of last vital testing" />
                                </th>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    <div class="patientDetailsScrollableContentArea">
                                        <table style="width: 100%;">
                                            <tr>
                                                <td style="vertical-align: top;">
                                                    <asp:GridView ID="grdVital" runat="server" Width="100%" AutoGenerateColumns="false" Caption="Latest Vital Signs"
                                                        HeaderStyle-HorizontalAlign="Left" TabIndex="127" ToolTip="Latest Vital Signs"
                                                        EmptyDataText="Current, No Vital Signs for Patient" HorizontalAlign="Left" GridLines="None">
                                                        <Columns>
                                                            <asp:BoundField DataField="VitalType" SortExpression="VitalType" HeaderText="Vital Type"
                                                                AccessibleHeaderText="Vital Type" HeaderStyle-HorizontalAlign="Left" />
                                                            <asp:BoundField DataField="Result" SortExpression="Result" HeaderText="Result" AccessibleHeaderText="Result"
                                                                HeaderStyle-HorizontalAlign="Left" />
                                                            <asp:BoundField DataField="Location" SortExpression="Location" HeaderText="Location"
                                                                AccessibleHeaderText="Location" HeaderStyle-HorizontalAlign="Left" />
                                                        </Columns>
                                                        <RowStyle CssClass="gridViewRow" />
                                                        <AlternatingRowStyle CssClass="gridViewAlternatingRow" />
                                                    </asp:GridView>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td style="width: 50%; vertical-align: top;">
                    </td>
                </tr>
                <%--<tr>
                    <td style="width:50%; vertical-align:top;" colspan="2">
                        Additional Info: Tab strip?<br />
                        Possibly show past assessment values, va meds, etc.
                    </td>
                </tr>--%>
            </table>
            <br />
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
