﻿using System;
using System.Web;
using System.Web.UI.WebControls;
using MSSREnh;
using Telerik.Web.UI;
using VeteransAffairs.Registries.BusinessManager;

public partial class NewPatients : BasePage
{
    private readonly UserAccountManager _user = (UserAccountManager) HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsUserAuthorizedToCreateSurvey())
        {
            Logging.WriteLogToFile(string.Format("{0} Create Survey Authorized and NewPatients Page Page Load.",
                _user.UserName));
        }
        else
        {
            Logging.WriteLogToFile(
                "Warning::SURVEY CREATE: Error accessing create survey page – Not Authorized. Redirecting to error page." +
                _user.UserName);
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        if (!Page.IsPostBack)
        {
            var mgr = new PatientViewManager(_user);
            rdListOfNewPatients.DataSource = mgr.GetNewPatients();
            SetBreadCrumb();
        }
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label) Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = " New Patients";
        }
    }

    protected void rdListOfNewPatients_OnItemCommand(object sender, GridCommandEventArgs e)
    {
        Session["patientIcnMsatCreateSurvey"] = null;
        Logging.WriteLogToFile("Create Survey Button Clicked On New Patients Page - Create Survey Start." +
                               _user.UserName);
        if (IsUserAuthorizedToCreateSurvey())
        {
            if (e.CommandName == "Select")
            {
                string patientIcn = ((GridDataItem) e.Item).GetDataKeyValue("PatientICN").ToString();
                string stationId = Convert.ToString(((GridDataItem) e.Item).GetDataKeyValue("Station"));
                Logging.WriteLogToFile(string.Format("New Patients Page - Create Survey loading patient ICN {0}.",
                    patientIcn));
                Session.Add("patientIcnMsatCreateSurvey", Helpers.SerializSessionItemsObj(patientIcn));
                Session.Add("stationIdMsatCreateSurvey", Helpers.SerializSessionItemsObj(stationId));
                Logging.WriteLogToFile(
                    string.Format("New Patients Page - Create Survey Authorized and opening patient ICN {0} .",
                        patientIcn));
                Response.Redirect("CreateSurvey.aspx?patientIcn=" + patientIcn);
            }
        }
        else
        {
            Logging.WriteLogToFile(
                "Warning::SURVEY CREATE: Error opening create survey module – Not Authorized. Redirecting to error page." +
                _user.UserName);
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    private bool IsUserAuthorizedToCreateSurvey()
    {
        bool allowedToEdit = false;
        var editMnger = new SurveyEditUserManager();
        allowedToEdit = editMnger.IsUserAuthozizedToEditSurvey(_user);
        return allowedToEdit;
    }

    #region "BaseMethods"

    public override string TopMenuName()
    {
        return "Administration";
    }

    public override string MenuItemName()
    {
        return "MSSR NEW PATIENTS LIST";
    }

    public override string AppObjectCode()
    {
        return "MSSR NEW PATIENTS LIST";
    }

    protected void PopulateNewPatientGrid(object sender, GridNeedDataSourceEventArgs e)
    {
        var mgr = new PatientViewManager(_user);
        rdListOfNewPatients.DataSource = mgr.GetNewPatients();
    }

    #endregion
}