﻿using System;
using System.Web;
using System.Web.UI;

public partial class MSSR_Instruments_RegistryInstrument : System.Web.UI.MasterPage {
    protected void Page_Load(object sender, EventArgs e) {
        //Sets the correct URL for context sensitive help, based on content page
        HyperLinkHelp.NavigateUrl = GetContextSensitiveHelpURL();

        // If the session is timed out due to inactivity, redirect to the timeout screen

        if (Helpers.DeSerializSessionItems(Session["SessionTimedOut"]) != null)
        {
            if (Helpers.DeSerializSessionItems(Session["SessionTimedOut"]) == "true")
            {
                //    Response.Redirect("InstrumentTimeout.aspx");
            }
        }
    }

    public void SetDirtyFlag(bool flag) {
        dirtyFlag.Value = flag == true ? "1" : "0";
    }

    protected void Page_Init(object Sender, EventArgs e) {
        Response.Cache.SetCacheability(HttpCacheability.NoCache);
        Response.Cache.SetExpires(DateTime.Now.AddSeconds(-1));
        Response.Cache.SetNoStore();
    }

    private string GetContextSensitiveHelpURL() {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html").Replace("tbi_instruments_", "");
    }
}