﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using VeteransAffairs.Registries.BusinessManager.MDWS;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessManager.TBIInstrumentVIAsrv;
using AntiXssEnc = Microsoft.Security.Application;


public partial class MSSR_Instruments_MSAssessmentNoteSummary : BaseMSSRInstrumentPage {

    #region Variable Declarations

    private string note;
    SURVEY survey;
    private bool viewOnly = false;
    //private int _surveyTypeId = 30; // MSAT
    //PatientManager pManager = new PatientManager();
    
    #endregion

    /// <summary>
    /// Page_Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        //base.BaseTBIInstrumentPage_Load(sender, e);
        MSSRServiceTO _mssrServiceTo;

        CancelButton.PostBackUrl = "MSAssessmentTool.aspx";

        try {
            _mssrServiceTo = (MSSRServiceTO)Session["MSSRServiceTO"];
            _mssrInstrumentManager.MssrServiceTo = _mssrServiceTo;
        }
        catch (Exception _ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary Page_Load setting _mssrInstrumentManager.MssrServiceTo: " + _ex.Message);
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _mssrlogerror = HandleMSSRException(_ex, "MSAssessmentNoteSummary.aspx", "100026", "SESSIONENDED");
            Response.Redirect("Warning.aspx?err=2");
        }

        if (!IsPostBack) {
            try {
                //string surveys = (string)Session["survey"];
                survey = Helpers.DeSerializSurvey(Session["survey"]);// SerializerUtil.Deserialize<SURVEY>(surveys);
                //survey = Session["survey"] as SURVEY;

                if (_mssrInstrumentManager.MssrServiceTo != null) {
                    Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                    labelUser.Text = _mssrInstrumentManager.MssrServiceTo.UserName;
                }
            }
            catch (Exception _ex2)
            {
                //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary Page_Load setting labelUser.Text: " + _ex2.Message);
                //Redirect to message that session is ended and need to log back in from CPRS.
                Exception _tbilogerror = HandleMSSRException(_ex2, "MSAssessmentNoteSummary.aspx", "100026", "SESSIONENDED - no survey");
                Response.Redirect("Warning.aspx?err=2");
            }

            try {
                ViewState["Note"] = note;
            }
            catch (Exception _ex3)
            {
                //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary Page_Load setting ViewState[Note]: " + _ex3.Message);
                Exception _mssrlogerror = HandleMSSRException(_ex3, "MSAssessmentNoteSummary.aspx", "100026", "Page_load - STD_SURVEY_TYPE_ID");
            }
        }

        if (_mssrInstrumentManager.MssrServiceTo == null) {
            //TODO post error
        } else {
            LabelPatient.Text = _mssrInstrumentManager.MssrServiceTo.PatientName;
            //LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSSN;
            LabelSSN.Text = _mssrInstrumentManager.MssrServiceTo.PatientSoN.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_mssrInstrumentManager.MssrServiceTo.PatientSoN)) : _mssrInstrumentManager.MssrServiceTo.PatientSoN;
            //LabelFacility.Text = _tbiInstrumentManager.TbiServiceTo.InstitutionName;
        }

        if (Helpers.DeSerializSessionItems(Session["NoteText"]) != null)
        {
            string noteText = Helpers.DeSerializSessionItems(Session["NoteText"]);
            txtNoteText.Text = noteText; //noteText.Replace("\r\n", "<br />").Replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"); //noteText.Replace("\r\n", "<br />").Replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").Replace(" ", "&nbsp;");
        }

        try {
            if (Session["ViewOnly"] != null)
                viewOnly = Convert.ToBoolean(Session["ViewOnly"]);
        }
        catch (Exception _ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary Page_Load setting viewOnly: " + _ex.Message);
            //Display error message to user
            Exception _mssrlogerror = HandleMSSRException(_ex, "MSAssessmentNoteSummary.aspx", "100026", "SESSIONENDED");
            Response.Redirect("Warning.aspx?err=7");
        }

        if (viewOnly) {
            LabelInstructionsText.Visible = false; //Instructions
            CancelButton.Visible = false;
            SubmitNoteButton.Text = "Back";
            SubmitNoteButton.ToolTip = "Back";
        }
    }

    /// <summary>
    /// Submit note to service.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void SubmitNote_Click(object sender, EventArgs e) {
        try {
            
            bool writeToLog = false;
            string sUpdateTimes = "";

            if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
            {
                writeToLog = true;
            }
            
            saveDems();

            if (viewOnly) {
                Session.Remove("ViewOnly");
                Session.Remove("ConfirmedSSN");
                //if (Session["BypassMDWS"] == null) {
                //    Response.Redirect("PatientInstrumentsMain.aspx", false);
                //} else {
                //    Response.Redirect("PatientInstrumentsNoMDWS.aspx", false);
                //}
            } else {

                if (writeToLog)
                    sUpdateTimes += DateTime.Now.ToString() + "\r\nbefore saving current status and HF)\r\n";

                
                saveCurrentStatusEntry(); // save internal MSSR data - CURRENT_STATUS
                saveHF_CondensedEntry();  // save internal MSSR data - HF_Condensed
                

                if (writeToLog)
                    sUpdateTimes += DateTime.Now.ToString() + "before GetMSSRServiceToFromSession)\r\n";

                MSSRServiceTO _mssrServiceTO = GetMSSRServiceToFromSession();
                MSSRInstrumentsManager _mssrInstrumentManager = new MSSRInstrumentsManager();

                AddtoSessionMSSRServiceTo(_mssrServiceTO);

                if (writeToLog)
                    sUpdateTimes += DateTime.Now.ToString() + "after AddtoSessionMSSRServiceTo(_mssrServiceTO))\r\n";

                if (Helpers.DeSerializSessionItems(Session["NoteText"]) != null)
                {
                    _mssrServiceTO.NoteText = Helpers.DeSerializSessionItems(Session["NoteText"]);
                } else {
                    // TODO: what to do on fail.
                }

                if (_mssrServiceTO != null) {
                    
                    // 2 paths from here - MDWS - VIA
                    if (getCurrentServiceToUse() == "VIA") {

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "before _mssrInstrumentManager.LoadMSSR_VIAService(_mssrServiceTO)\r\n";

                        _mssrInstrumentManager.LoadMSSR_VIAService(_mssrServiceTO);

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "before _mssrInstrumentManager.writeNoteWithVIA(_mssrServiceTO\r\n";

                        #region VIA
                        // VIA
                        noteResultTO _result = null;
                        _result = _mssrInstrumentManager.writeNoteWithVIA(_mssrServiceTO);

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "after _mssrInstrumentManager.writeNoteWithVIA(_mssrServiceTO)\r\n";

                        if (_result.fault == null)
                        {
                            Logging.WriteLogToFile("Write to CPRS/VIA Note succeeded: " + _result.id.ToString() + "\r\n");

                            survey = Helpers.DeSerializSurvey(Session["survey"]);// Session["survey"] as SURVEY;

                            if (survey != null)
                            {
                                survey.SetAsChangeTrackingRoot();
                                survey.SURVEY_STATUS = "completed";
                            }                            

                            SURVEY_NOTE note = new SURVEY_NOTE();

                            if (note != null)
                            {
                                note.NOTES_TEXT = _mssrServiceTO.NoteText;
                                note.ENTRY_DATE = DateTime.Today;
                                note.NOTE_DATE = DateTime.Today;
                                note.STD_INSTITUTION_ID = 1000001;
                            }

                            if (survey != null)
                            {
                                survey.SURVEY_NOTEs.Add(note);
                            }
                            

                            if (writeToLog)
                                sUpdateTimes += DateTime.Now.ToString() + "before VIA _mssrInstrumentManager.Update(survey)\r\n";

                            _mssrInstrumentManager.Update(survey, writeToLog);
                            //SubmitNoteButton.Enabled = false;
                            Session.Remove("survey");

                            if (writeToLog)
                            {
                                sUpdateTimes += DateTime.Now.ToString() + "after VIA _mssrInstrumentManager.Update(survey)\r\n";
                                Logging.WriteLogToFile(sUpdateTimes);
                            }

                            string script = "<script language=\"javascript\"  type=\"text/javascript\">window.open('','_self','');window.close();</script>";
                            ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
                        }
                        else
                        {
                            string logErrorString = "Write note to CPRS via VIA failed: ";
                            //logErrorString += "_result.fault.innerMessage: " + _result.fault.innerMessage.ToString();
                            //logErrorString += "  _result.fault.innerStackTrace: " + _result.fault.innerStackTrace.ToString();
                            logErrorString += "  _result.fault.message: " + _result.fault.message.ToString();
                            //logErrorString += "  _result.fault.stackTrace: " + _result.fault.stackTrace.ToString();
                            //logErrorString += "  _result.fault.suggestion: " + _result.fault.suggestion.ToString();
                            Logging.WriteLogToFile(logErrorString);

                            SurveyNoteError.Text = "Error: " + AntiXssEnc.Encoder.HtmlEncode(_result.fault.message) + "<br/><br/>You will need to return to CPRS and click on MS Assessment Tool in order to start again.";
                            ErrorPanel.Visible = true;
                            ButtonsPanel.Visible = false;
                            //SurveyNoteHTML.Visible = false;

                            Logging.WriteLogToFile("MSSR_InstrumentSummary - SubmitNote_click - VIA: _result.fault was not null: " + _result.fault.ToString());
                        }
                        #endregion

                    } else {

                        #region MDWS

                        // MDWS
                        NoteResultTO _result = null;

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "before MDWS: _mssrInstrumentManager.LoadMssrService(_mssrServiceTO)\r\n";

                        _mssrInstrumentManager.LoadMssrService(_mssrServiceTO);

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "before MDWS: writeNote";

                        if (Session["BypassMDWS"] == null) {
                            _result = _mssrInstrumentManager.writeNote(_mssrServiceTO);
                        } else {
                            _result = new NoteResultTO();
                        }

                        if (writeToLog)
                            sUpdateTimes += DateTime.Now.ToString() + "after MDWS: _mssrInstrumentManager.writeNote(_mssrServiceTO)\r\n";

                        if (_result.fault == null) {

                            Logging.WriteLogToFile("Write to CPRS/MDWS Note succeeded: " + _result.id.ToString() + "\r\n");

                            survey = Helpers.DeSerializSurvey(Session["survey"]);// Session["survey"] as SURVEY;

                            if (survey != null)
                            {
                                survey.SetAsChangeTrackingRoot();
                                survey.SURVEY_STATUS = "completed";
                            }                            

                            SURVEY_NOTE note = new SURVEY_NOTE();
                            if (note != null)
                            {
                                note.NOTES_TEXT = _mssrServiceTO.NoteText;
                                note.ENTRY_DATE = DateTime.Today;
                                note.NOTE_DATE = DateTime.Today;
                                note.STD_INSTITUTION_ID = 1000001;
                            }

                            if (survey != null)
                            {
                                survey.SURVEY_NOTEs.Add(note);
                            }
                           

                            if (writeToLog)
                                sUpdateTimes += DateTime.Now.ToString() + "before MDWS: _mssrInstrumentManager.Update(survey)\r\n";

                            _mssrInstrumentManager.Update(survey, writeToLog);
                            //SubmitNoteButton.Enabled = false;
                            Session.Remove("survey");

                            if (writeToLog)
                            {
                                sUpdateTimes += DateTime.Now.ToString() + "after MDWS _mssrInstrumentManager.Update(survey)\r\n";
                                Logging.WriteLogToFile(sUpdateTimes);
                            }

                            string script = "<script language=\"javascript\"  type=\"text/javascript\">window.open('','_self','');window.close();</script>";
                            ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
                        }
                        else
                        {
                            string logErrorString = "Write note to CPRS via MDWS failed: ";
                            //logErrorString += "_result.fault.innerMessage: " + _result.fault.innerMessage.ToString();
                            //logErrorString += "  _result.fault.innerStackTrace: " + _result.fault.innerStackTrace.ToString();
                            logErrorString += "  _result.fault.message: " + _result.fault.message.ToString();
                            //logErrorString += "  _result.fault.stackTrace: " + _result.fault.stackTrace.ToString();
                            //logErrorString += "  _result.fault.suggestion: " + _result.fault.suggestion.ToString();
                            Logging.WriteLogToFile(logErrorString);

                            SurveyNoteError.Text = "Error: " + AntiXssEnc.Encoder.HtmlEncode(_result.fault.message) + "<br/><br/>You will need to return to CPRS and click on MS Assessment Tool in order to start again.";
                            ErrorPanel.Visible = true;
                            ButtonsPanel.Visible = false;
                            //SurveyNoteHTML.Visible = false;

                            Logging.WriteLogToFile("MSSR_InstrumentSummary - SubmitNote_click - MDWS: _result.fault was not null: " + _result.fault.ToString());
                        }

                        #endregion
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentNoteSummary.aspx", "100026", "SubmitNote_Click()");

            SurveyNoteError.Text = "Error: " + ex.Message + "<br/><br/>You will need to return to CPRS and click on MS Assessment Tool in order to start again.";
            ErrorPanel.Visible = true;
            ButtonsPanel.Visible = false;
        }
    }

    /// <summary>
    /// saveCurrentStatusEntry: Finds the mssrCurrentStatus object in Session, and performs insert or update in the MSSR_CURRENT_STATUS table.
    /// </summary>
    private void saveCurrentStatusEntry() {
        try {
            MSSR_CURRENT_STATUS currentStatus = MapCurrentStatusDisplayToCurrentStatus((CurrentStatusDisplay)Session["mssrCurrentStatus"]);

            // TODO: Perform lookup for CURRENT_STATUS_ENTRY for PatientICN ... if null ... PreviousEDMUSScore and PreviousEDMUSDate are NULL ... else
            // (PreviousEdmusScore set to LastEdumsScore) and (PreviousEdmusDate set to previous value from LastAssessDate)

            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
                MSSR_CURRENT_STATUS existingStatus = ctx.MSSR_CURRENT_STATUS.FirstOrDefault(C => C.PatientICN == currentStatus.PatientICN);

                if (existingStatus != null) {

                    // if existing entry has LastEdumsScore, set these values into the PreviousEdmusScore/Date fields
                    if (!String.IsNullOrEmpty(existingStatus.LastEdumsScore)) {
                        existingStatus.PreviousEdmusScore = existingStatus.LastEdumsScore;
                        existingStatus.PreviousEdmusDate = existingStatus.LastAssessDate;
                    }

                    // if current status has a LastEdmusScore, populate LastEdmusScore/Date into existing object for update.
                    if (!String.IsNullOrEmpty(currentStatus.LastEdumsScore)) {
                        existingStatus.LastEdumsScore = currentStatus.LastEdumsScore;
                    }

                    existingStatus.Sta3n = currentStatus.Sta3n;
                    existingStatus.LastAssessType = currentStatus.LastAssessType;
                    existingStatus.LastAssessDate = currentStatus.LastAssessDate;
                    existingStatus.LastMSSubType = currentStatus.LastMSSubType;
                    existingStatus.LastRelapses = currentStatus.LastRelapses;
                    existingStatus.LastSymptomYear = currentStatus.LastSymptomYear;
                    existingStatus.MSDiagnosis = currentStatus.MSDiagnosis;
                    existingStatus.Rx1 = currentStatus.Rx1;
                    existingStatus.Rx2 = currentStatus.Rx2;
                    existingStatus.Rx3 = currentStatus.Rx3;
                    existingStatus.RxAll = currentStatus.RxAll;
                    existingStatus.RxEver1 = currentStatus.RxEver1;
                    existingStatus.RxEver2 = currentStatus.RxEver2;
                    existingStatus.RxEver3 = currentStatus.RxEver3;
                    existingStatus.RxEver4 = currentStatus.RxEver4;
                    existingStatus.RxEver5 = currentStatus.RxEver5;
                    existingStatus.RxEverAll = currentStatus.RxEverAll;
                    existingStatus.URFTemplateID = currentStatus.URFTemplateID;
                    existingStatus.LastDiagnosisYear = currentStatus.LastDiagnosisYear;//Release2

                } else {
                    // insert current.
                    ctx.MSSR_CURRENT_STATUS.InsertOnSubmit(new MSSR_CURRENT_STATUS() { 
                        BaselineAssessDate = currentStatus.BaselineAssessDate, 
                        LastAssessDate = currentStatus.LastAssessDate, 
                        LastAssessType = currentStatus.LastAssessType, 
                        LastEdumsScore = currentStatus.LastEdumsScore, 
                        LastMSSubType = currentStatus.LastMSSubType, 
                        LastRelapses = currentStatus.LastRelapses, 
                        LastSymptomYear = currentStatus.LastSymptomYear, 
                        MSDiagnosis = currentStatus.MSDiagnosis, 
                        PatientICN = currentStatus.PatientICN, 
                        PatientSID = currentStatus.PatientSID, 
                        PreviousEdmusDate = currentStatus.PreviousEdmusDate, 
                        PreviousEdmusScore = currentStatus.PreviousEdmusScore, 
                        Rx1 = currentStatus.Rx1, 
                        Rx2 = currentStatus.Rx2, 
                        Rx3 = currentStatus.Rx3, 
                        RxAll = currentStatus.RxAll, 
                        RxEver1 = currentStatus.RxEver1, 
                        RxEver2 = currentStatus.RxEver2, 
                        RxEver3 = currentStatus.RxEver3, 
                        RxEver4 = currentStatus.RxEver4, 
                        RxEver5 = currentStatus.RxEver5, 
                        RxEverAll = currentStatus.RxEverAll, 
                        Sta3n = currentStatus.Sta3n,
                        URFTemplateID = currentStatus.URFTemplateID,
                        LastDiagnosisYear = currentStatus.LastDiagnosisYear //Release2
                    });
                }

                ctx.SubmitChanges(); // submit changes.
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveCurrentStatusEntry: " + ex.Message);

            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentNoteSummary.aspx", "100026", "saveCurrentStatusEntry");
        }

        //List<SURVEY> surveys = _mssrInstrumentManager.SelectByPatientICNAndSurveyType(_mssrInstrumentManager.MssrServiceTo.PatientICN, _surveyTypeId, true).OrderByDescending(S => S.SURVEY_DATE).ToList();

        //if (surveys.Count > 0) {
        //    //survey
        //}
    }

    /// <summary>
    /// saveDems: Finds the MSSRE_PATIENT_DEM object in Session, and performs insert or update in the MSSRE_PATIENT_DEM table.
    /// </summary>
    private void saveDems()
    {
        try
        {
            MSSRE_PATIENT_DEM patientDem = MapMssrePatientDem((MssrePatientDemDispaly)Session["patientDem"]);
           
            //Insert
            int result = 0;
                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    result = ctx.SP_InsertDemData(patientDem.PatientICN.ToString());                    
                }
            //Update
                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    MSSRE_PATIENT_DEM patient = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(C => C.PatientICN == patientDem.PatientICN);

                    patient.DateOfDeath = (DateTime?)(Session["DateOfDeath"]);
                    patient.CauseOfDeath = patientDem.CauseOfDeath;

                    ctx.SubmitChanges();
                }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveHF_CondensedEntry: " + ex.Message);
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentNoteSummary.aspx", "100026", "saveDems");
        }
    }
    /// <summary>
    /// saveHF_CondensedEntry: Finds the mssrCurrentAssessmentHF object in Session, and performs insert or update in the MSSR_HF_CONDENSED table.
    /// </summary>
    private void saveHF_CondensedEntry() {
        try {
            MssrAssessmentDisplay assessment = (MssrAssessmentDisplay)Session["mssrCurrentAssessmentHF"];

            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
                ctx.MSSR_HF_Condenseds.InsertOnSubmit(new MSSR_HF_Condensed() {
                    AssessmentDateTime = assessment.AssessmentDateTime,
                    AssessmentType = assessment.AssessmentType,
                    CurrentDisabilityScore = assessment.CurrentDisabilityScore,
                    DiagnosisYear = Helpers.getYearFromMonthYear(assessment.DiagnosisYear),
                    Ethnicity = assessment.Ethnicity,
                    MSDiagnosis = assessment.MSDiagnosis,
                    MSInterview = assessment.MSInterview,
                    MSSC = assessment.MSSC,
                    MSSubType = assessment.MSSubType,
                    PatientSID = null,
                    PatientICN = assessment.PatientICN,
                    Relapses = assessment.Relapses,
                    Sta3n = (short)assessment.Sta3n,
                    SymptomYear = Helpers.getYearFromMonthYear(assessment.SymptomYear)
                });

                ctx.SubmitChanges();
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveHF_CondensedEntry: " + ex.Message);
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentNoteSummary.aspx", "100026", "saveHF_CondensedEntry");
        }
    }

    private MSSR_CURRENT_STATUS MapCurrentStatusDisplayToCurrentStatus(CurrentStatusDisplay currentStatus)
    {
        return new MSSR_CURRENT_STATUS
        {
            BaselineAssessDate = currentStatus.BaselineAssessDate,
            LastAssessDate = currentStatus.LastAssessDate,
            LastAssessType = currentStatus.LastAssessType,
            LastEdumsScore = currentStatus.LastEdumsScore,
            LastMSSubType = currentStatus.LastMSSubType,
            LastRelapses = currentStatus.LastRelapses,
            LastSymptomYear = currentStatus.LastSymptomYear,
            MSDiagnosis = currentStatus.MSDiagnosis,
            PatientICN = currentStatus.PatientICN,
            PatientSID = currentStatus.PatientSID,
            PreviousEdmusDate = currentStatus.PreviousEdmusDate,
            PreviousEdmusScore = currentStatus.PreviousEdmusScore,
            Rx1 = currentStatus.Rx1,
            Rx2 = currentStatus.Rx2,
            Rx3 = currentStatus.Rx3,
            RxAll = currentStatus.RxAll,
            RxEver1 = currentStatus.RxEver1,
            RxEver2 = currentStatus.RxEver2,
            RxEver3 = currentStatus.RxEver3,
            RxEver4 = currentStatus.RxEver4,
            RxEver5 = currentStatus.RxEver5,
            RxEverAll = currentStatus.RxEverAll,
            Sta3n = currentStatus.Sta3n,
            URFTemplateID = currentStatus.URFTemplateID,
            LastDiagnosisYear = currentStatus.LastDiagnosisYear
        };
    }
    private MSSRE_PATIENT_DEM MapMssrePatientDem(MssrePatientDemDispaly pntDem)
    {
        return new MSSRE_PATIENT_DEM
        {
            PatientSoSeN = pntDem.PatientSoSeN,
            PatientICN = pntDem.PatientICN,
            PatientFirstName = pntDem.PatientFirstName,
            PatientLastName = pntDem.PatientLastName,
            PatientName = pntDem.PatientName,
            Age = pntDem.Age,
            DateOfBirth = pntDem.DateOfBirth,
            DateOfDeath = pntDem.DateOfDeath,
            CauseOfDeath = pntDem.CauseOfDeath,
            City = pntDem.City,
            State = pntDem.State,
            Gender = pntDem.Gender,
            MaritalStatus = pntDem.MaritalStatus,
            Religion = pntDem.Religion,
            Region = pntDem.Region,
            Race = pntDem.Race,
            Ethnicity = pntDem.Ethnicity
        };
    }
}