﻿<%@ Page Language="C#" MasterPageFile="~/MSSR_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="Default.aspx.cs"
    Inherits="MSSR_Instruments_Default" Title="MSSR Instruments" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ValidationSummary ID="ValidationSummaryPatientInstruments" runat="server" ValidationGroup="OnSave" HeaderText="The page has the following data errors:"
        DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" />
    <asp:Panel ID="PanelPatientConfirm" runat="server">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="MS Assessment Tool > Confirm Patient"></asp:Label>
        </div>
        <div style="padding-top: 5px; padding-left: 5px; width: 800px;">
            <asp:Panel ID="PanelPatient" GroupingText="Patient&nbsp;&nbsp;" runat="server" Width="100%">
                <br />
                &nbsp;&nbsp;<asp:Label ID="LabelPatient" runat="server" SkinID="DataLabel"></asp:Label><br />
                <br />
            </asp:Panel>
            <div style="padding-top: 8px; padding-left: 4px;">
                To begin, verify that the patient name above is correct and enter the patient's SSN to confirm the correct patient is selected.
                <br />
                <asp:Label ID="LabelforTextBoxSSNConfirm" runat="server" AssociatedControlID="TextBoxSSNConfirm" SkinID="DataLabel">
                    Confirm Patient SSN(dashes optional, ###-##-####) *:
                </asp:Label>
                <br />
                <asp:TextBox ID="TextBoxSSNConfirm" runat="server" />
                <asp:RegularExpressionValidator ID="RegularExpressionValidatorTextBoxSSN" ControlToValidate="TextBoxSSNConfirm" Display="Static"
                    runat="server" EnableClientScript="true" ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSN’s."
                    SetFocusOnError="true" ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$">
                </asp:RegularExpressionValidator>
                <asp:RequiredFieldValidator ID="RequiredFieldValidatorSSN" ControlToValidate="TextBoxSSNConfirm" Display="Static" runat="server"
                    EnableClientScript="true" ErrorMessage="SSN is required." SetFocusOnError="true">
                </asp:RequiredFieldValidator>
                <asp:Label ID="LabelWarningNotificationMessage" runat="server" SkinID="DataLabel" Visible="false" Text="">
                </asp:Label>
            </div>
        </div>
    </asp:Panel>
    <asp:Panel ID="PanelInstrumentList" runat="server" Visible="true">
        <div style="padding-left: 7px;">
            <asp:Button ID="btnStartAssessment" runat="server" Text="Continue" ToolTip="Click to start assessment for patient" OnClick="btnStartAssessment_Click" />
        </div>
    </asp:Panel>
    <br />
</asp:Content>
