﻿<%@ Page Language="C#" MasterPageFile="~/MSSR_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="DataEntryTabular.aspx.cs"
    Inherits="MSSR_Instruments_DataEntryTabular" Title="MSSR Instument Data Entry (Tabular View)" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField
        {
            font-weight: bold;
            color: #FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:RadAjaxManager ID="RadAjaxManager1" runat="server">
    </telerik:RadAjaxManager>
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="updatePanelMain" runat="server">
        <ContentTemplate>
            <asp:UpdateProgress ID="updateProgressMain" runat="server">
                <ProgressTemplate>
                    <!-- Modal Popup for Loading -->
                    <div style="padding-left: 3px;">
                        <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                            Processing...Please wait.
                        </div>
                    </div>
                </ProgressTemplate>
            </asp:UpdateProgress>
            <!-- Hidden Field - Survey Type -->
            <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MSAT" />
            <div style="width: 98%; padding: 10px;">
                The data from this survey will be used by the MS Centers of Excellence for maintaining the MS Registry as well as improving
                patient care.
                <br />
                <br />
                <fieldset>
                    <legend>MS Assessment History</legend>
                    <br />
                    <!--Question 1: Type of Assessment (MSCOE MS Assessment Type)-->
                    <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblAssessmentType" SkinID="DataLabel" TabIndex="17">
                    </asp:Label>
                    <span class="requiredField">*</span><br />
                    <asp:RadioButtonList ID="rblAssessmentType" runat="server" RepeatDirection="Vertical" AutoPostBack="true" DataSourceID="ObjectDataSourceQ1"
                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" OnSelectedIndexChanged="rblAssessmentType_SelectedIndexChanged">
                    </asp:RadioButtonList>
                    <!--Question 1 Required Validator-->
                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblAssessmentType" TabIndex="19"
                        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                    <!--Question 1 Object Data Source-->
                    <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                            <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <!--Question 1 : Question Number-->
                    <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                </fieldset>
                <div class="panelAreaMain">
                    <asp:Panel ID="pnlBaseline" runat="server" Visible="false" CssClass="panelContainer">
                        <telerik:RadTabStrip ID="DataEntryTabStrip" MultiPageID="DataEntryPageContent" runat="server" Width="100%" SelectedIndex="0"
                            Skin="Windows7">
                            <Tabs>
                                <telerik:RadTab Text="Core Clinical Questions" Selected="True">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Family History" ToolTip="Biological Family History">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Diagnosis">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Initial MS/NMO symptom">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Service Connection Status">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Current Disability">
                                </telerik:RadTab>
                                <telerik:RadTab Text="Medications">
                                </telerik:RadTab>
                            </Tabs>
                        </telerik:RadTabStrip>
                        <telerik:RadMultiPage ID="DataEntryPageContent" runat="server" SelectedIndex="0" CssClass="panelAreaMain">
                            <telerik:RadPageView ID="pvCoreClinicalQuestions" runat="server">
                                <div class="panelAreaMain">
                                    <br />
                                    <!--Question 2: Interview Completed by-->
                                    <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblBaselineQ2" SkinID="DataLabel" TabIndex="17">
                                    </asp:Label>
                                    <span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblBaselineQ2" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceBaselineQ2"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 2 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorBaselineQ2" runat="server" ControlToValidate="rblBaselineQ2" TabIndex="19"
                                        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <!--Question 2 Object Data Source-->
                                    <asp:ObjectDataSource ID="ObjectDataSourceBaselineQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenBaselineQ2" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <!--Question 2 : Question Number-->
                                    <asp:HiddenField ID="HiddenBaselineQ2" runat="server" Visible="false" Value="2" />
                                    <br />
                                    Race, Ethnicity, MS Diagnosis (This section is only filled out once)<br />
                                    <br />
                                    <strong>Race as defined by VA:
                                        <asp:Label ID="lblRace" runat="server" Text="WHITE" /></strong><!-- TODO: Change - static --><br />
                                    * If VA race different than current response, instruct patient to contact the local Business Office / Eligibility.
                                    <br />
                                    <br />
                                    
                                    <!--Question 3: Race -->
                                    <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblBaselineQ3" SkinID="DataLabel" TabIndex="17">
                                    </asp:Label><span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblBaselineQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceBaselineQ3"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 3 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorBaselineQ3" runat="server" ControlToValidate="rblBaselineQ3" TabIndex="19"
                                        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <!--Question 3 Object Data Source-->
                                    <asp:ObjectDataSource ID="ObjectDataSourceBaselineQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenBaselineQ3" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <!--Question 3 : Question Number-->
                                    <asp:HiddenField ID="HiddenBaselineQ3" runat="server" Visible="false" Value="3" />
                                    <br />
                                    <br />
                                    <!--Question 4: Race -->
                                    <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblBaselineQ4" SkinID="DataLabel" TabIndex="17">
                                    </asp:Label><span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblBaselineQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceBaselineQ4"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 4 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorBaselineQ4" runat="server" ControlToValidate="rblBaselineQ4" TabIndex="19"
                                        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <!--Question 4 Object Data Source-->
                                    <asp:ObjectDataSource ID="ObjectDataSourceBaselineQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenBaselineQ4" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <!--Question 4 : Question Number-->
                                    <asp:HiddenField ID="HiddenBaselineQ4" runat="server" Visible="false" Value="4" />
                                    
                                    <%--Ethnicity as defined by patient:<br />
                                    <asp:RadioButtonList ID="tblPatientEthnicity" runat="server">
                                        <asp:ListItem Text="Hispanic"></asp:ListItem>
                                        <asp:ListItem Text="Not Hispanic"></asp:ListItem>
                                    </asp:RadioButtonList>--%>
                                    <br />
                                    <br />
                                    <asp:Label ID="LabelForGender" runat="server" AssociatedControlID="lblGender" SkinID="DataLabel" Text="Gender" TabIndex="17">
                                    </asp:Label>:
                                    <!-- TODO: Change to patient profile data -->
                                    <asp:Label ID="lblGender" runat="server"></asp:Label>
                                    <br />
                                </div>
                                <br />
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvBiologicalFamilyHistory" runat="server">
                                <div class="panelAreaMain">
                                    <!--Question 5: Interview Completed by-->
                                    <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblBaselineQ5" SkinID="DataLabel" TabIndex="17">
                                    </asp:Label><span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblBaselineQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceBaselineQ5"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 5 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorBaselineQ5" runat="server" ControlToValidate="rblBaselineQ5" TabIndex="19"
                                        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <!--Question 5 Object Data Source-->
                                    <asp:ObjectDataSource ID="ObjectDataSourceBaselineQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenBaselineQ5" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <!--Question 5 : Question Number-->
                                    <asp:HiddenField ID="HiddenBaselineQ5" runat="server" Visible="false" Value="5" />
                                
                                    <%--Biological family history of Multiple Sclerosis?<br />
                                    <asp:RadioButtonList ID="rblFamilyHistoryMS" runat="server">
                                        <asp:ListItem Text="Unknown"></asp:ListItem>
                                        <asp:ListItem Text="None"></asp:ListItem>
                                        <asp:ListItem Text="Yes"></asp:ListItem>
                                    </asp:RadioButtonList>--%>
                                    <br />
                                    Biological family history of Clinically Isolated Syndrome?<br />
                                    <asp:RadioButtonList ID="RadioButtonList1" runat="server">
                                        <asp:ListItem Text="Unknown"></asp:ListItem>
                                        <asp:ListItem Text="None"></asp:ListItem>
                                        <asp:ListItem Text="Yes"></asp:ListItem>
                                    </asp:RadioButtonList>
                                    <br />
                                    Biological family history of Neuromyelitis Optica / Devic's Disease?<br />
                                    <asp:RadioButtonList ID="RadioButtonList2" runat="server">
                                        <asp:ListItem Text="Unknown"></asp:ListItem>
                                        <asp:ListItem Text="None"></asp:ListItem>
                                        <asp:ListItem Text="Yes"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </div>
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvDiagnosis" runat="server">
                                <div class="panelAreaMain">
                                    * Diagnosis History:<br />
                                    <strong>MSCOE MS Diagnosis</strong><br />
                                    <!-- TODO: Is this a repeating field? or are these static? -->
                                    &nbsp;&nbsp;&nbsp;> MSCOE.DX.MS<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.DX.CIS<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.YEAR OF FIRST MS SYMPTOM<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.YEAR OF FIRST MS SYMPTOM<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.YEAR OF MS DIAGNOSIS<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.YEAR OF MS DIAGNOSIS
                                    <br />
                                    <br />
                                    <fieldset>
                                        <asp:RadioButtonList ID="rblBaselineDiagnosis" runat="server">
                                            <asp:ListItem Text="Multiple Sclerosis"></asp:ListItem>
                                            <asp:ListItem Text="Possible Multiple Sclerosis"></asp:ListItem>
                                            <asp:ListItem Text="Clinically Isolated Syndrome (CIS)"></asp:ListItem>
                                            <asp:ListItem Text="Neuromyelitis Optica / Devic's Disease"></asp:ListItem>
                                            <asp:ListItem Text="Determined NOT to have Multiple Sclerosis"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                </div>
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvInitialSymptom" runat="server">
                                <div class="panelAreaMain">
                                    * Initial Symptom History:<br />
                                    <strong>MSCOE MS/NMO Initial Symptom</strong><br />
                                    <asp:CheckBoxList ID="chkListBaselineInitialSymptom" runat="server" RepeatDirection="Vertical">
                                        <asp:ListItem Text="Motor"></asp:ListItem>
                                        <asp:ListItem Text="Sensory"></asp:ListItem>
                                        <asp:ListItem Text="Brainstem"></asp:ListItem>
                                        <asp:ListItem Text="Cerebellar"></asp:ListItem>
                                        <asp:ListItem Text="Optic Neuritis"></asp:ListItem>
                                        <asp:ListItem Text="Cognitive"></asp:ListItem>
                                        <asp:ListItem Text="Bowel/Bladder"></asp:ListItem>
                                        <asp:ListItem Text="Spinal Cord"></asp:ListItem>
                                    </asp:CheckBoxList>
                                    <br />
                                    <strong>Multiple Sclerosis Subtype:</strong><br />
                                    * Subtype History:<br />
                                    <!-- TODO: Make dynamic -->
                                    &nbsp;&nbsp;&nbsp;> MSCOE.SUBTYPE.RRMS (Date)<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.SUBTYPE.SPMS (Date)<br />
                                    &nbsp;&nbsp;&nbsp;> MSCOE.SUBTYPE.SPMS TRANSITION YEAR (Date)<br />
                                    <br />
                                    <fieldset>
                                        <asp:RadioButtonList ID="rblBaselineMSSubtype" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Relapsing-Remitting (RRMS)"></asp:ListItem>
                                            <asp:ListItem Text="Secondary Progressive, (with or without relapses) (SPMS)"></asp:ListItem>
                                            <asp:ListItem Text="Primary Progressive (PPMS)"></asp:ListItem>
                                            <asp:ListItem Text="Progressive-Relapsing (PRMS)"></asp:ListItem>
                                            <asp:ListItem Text="Not applicable (CIS or NMO)"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                </div>
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvServiceConnectionStatus" runat="server">
                                <div class="panelAreaMain">
                                    MS Service Connection Status:<br />
                                    <asp:RadioButtonList ID="rblBaselineMSServiceConnection" runat="server" RepeatDirection="Vertical">
                                        <asp:ListItem Text="Patient is service-connected for MS"></asp:ListItem>
                                        <asp:ListItem Text="Patient is NOT service-connected for MS"></asp:ListItem>
                                    </asp:RadioButtonList>
                                </div>
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvCurrentDisability" runat="server">
                                <div class="panelAreaMain">
                                    * Disability History<br />
                                    <strong>MSCOE MS Current Disability</strong><br />
                                    > MSCOE.EDMUS.03 (Date)<br />
                                    > MSCOE.EDMUS.04 (Date)<br />
                                    > MSCOE.EDMUS.05 (Date)<br />
                                    <br />
                                    Current MS or Neuromyelitis optica (NMO) Disability:<br />
                                    * Amato MP, Grimaud J, Achiti I, Bartolozzi ML, Adeleine P, Hartung H-P, Kappos L, Thompson A, Trojano M, Vukusic S, Confavreux
                                    C for the Evaluation of the EDMUS system (EVALUED) Study Group: European validation of a standardized clinical description
                                    of multiple sclerosis. J. Neurol. 2004; 251: 1472-1480
                                    <br />
                                    <fieldset>
                                        <asp:RadioButtonList ID="rblBaselineCurrentMSDisability" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="1 = No Disability. Minimal signs on neurological examination."></asp:ListItem>
                                            <asp:ListItem Text="2 = Minimal and not ambulation-related disability. Able to run."></asp:ListItem>
                                            <asp:ListItem Text="3 = Unlimited walking distance without rest but unable to run; or a significant not ambulation-related disability."></asp:ListItem>
                                            <asp:ListItem Text="4 = Walks without aid. Limited walked distance, but greater than 500 meters without a rest."></asp:ListItem>
                                            <asp:ListItem Text="5 = Walks without aid. Walking distance less than 500 without rest."></asp:ListItem>
                                            <asp:ListItem Text="6A = Walks with permanent unilateral support. Walking distance less than 100 meters without rest."></asp:ListItem>
                                            <asp:ListItem Text="6B = Walks with permanent bilateral support. Walking distance less than 100 meters without rest."></asp:ListItem>
                                            <asp:ListItem Text="7 = Home restricted. A few steps with wall or furniture assistance. Walking distance less than 20 meters without rest."></asp:ListItem>
                                            <asp:ListItem Text="8 = Chair restricted. Unable to take a step. Some effective use of arms."></asp:ListItem>
                                            <asp:ListItem Text="9 = Bedridden and totally helpless."></asp:ListItem>
                                            <asp:ListItem Text="10 = Death due to MS."></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                    <br />
                                    <br />
                                    <strong>Number of relapses* over the past twelve months:</strong><br />
                                    <fieldset>
                                        <asp:RadioButtonList ID="rblBaselineNumRelapses" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="0"></asp:ListItem>
                                            <asp:ListItem Text="1"></asp:ListItem>
                                            <asp:ListItem Text="2"></asp:ListItem>
                                            <asp:ListItem Text="3"></asp:ListItem>
                                            <asp:ListItem Text="4"></asp:ListItem>
                                            <asp:ListItem Text="5"></asp:ListItem>
                                            <asp:ListItem Text="6"></asp:ListItem>
                                            <asp:ListItem Text="7"></asp:ListItem>
                                            <asp:ListItem Text="8"></asp:ListItem>
                                            <asp:ListItem Text="9"></asp:ListItem>
                                            <asp:ListItem Text="10"></asp:ListItem>
                                        </asp:RadioButtonList>
                                        <br />
                                        * relapse = worsening of neurological symptoms for > 24 hrs that stabilize or resolve.
                                    </fieldset>
                                    <br />
                                    <br />
                                    <asp:CheckBox ID="chkBoxBaselineYearPatientReachedEdmus6" runat="server" Text="(*IF APPLICABLE) Year patient reached an EDMUS disability score of 6 (walks with unilateral or bilateral  support)"
                                        AutoPostBack="true" OnCheckedChanged="chkBoxBaselineYearPatientReachedEdmus6_CheckedChanged" /><br />
                                    <asp:Panel ID="pnlBaselinePatientEdmus6Date" runat="server" Enabled="false">
                                        Date-Year (month if known):
                                        <telerik:RadDatePicker ID="rdpBaselinePatientEdmus6Date" runat="server">
                                        </telerik:RadDatePicker>
                                        <%--<asp:DropDownList ID="ddlBaselineEdmus6Month" runat="server">
                            <asp:ListItem Text=""></asp:ListItem>
                            <asp:ListItem Text="January"></asp:ListItem>
                            <asp:ListItem Text="February"></asp:ListItem>
                            <asp:ListItem Text="March"></asp:ListItem>
                            <asp:ListItem Text="April"></asp:ListItem>
                            <asp:ListItem Text="May"></asp:ListItem>
                            <asp:ListItem Text="June"></asp:ListItem>
                            <asp:ListItem Text="July"></asp:ListItem>
                            <asp:ListItem Text="August"></asp:ListItem>
                            <asp:ListItem Text="September"></asp:ListItem>
                            <asp:ListItem Text="October"></asp:ListItem>
                            <asp:ListItem Text="November"></asp:ListItem>
                            <asp:ListItem Text="December"></asp:ListItem>
                        </asp:DropDownList>--%></asp:Panel>
                                    <br />
                                    <asp:CheckBox ID="chkBoxBaselineYearPatientReachedEdmus8" runat="server" Text="(*IF APPLICABLE) Year patient reached an EDMUS disability score of 8 (restricted to chair)"
                                        AutoPostBack="true" OnCheckedChanged="chkBoxBaselineYearPatientReachedEdmus8_CheckedChanged" /><br />
                                    <asp:Panel ID="pnlBaselinePatientEdmus8Date" runat="server" Enabled="false">
                                        Date-Year (month if known):
                                        <telerik:RadDatePicker ID="rdpBaselinePatientEdmus8Date" runat="server">
                                        </telerik:RadDatePicker>
                                        <%--<asp:DropDownList ID="ddlBaselineEdmus6Month" runat="server">
                            <asp:ListItem Text=""></asp:ListItem>
                            <asp:ListItem Text="January"></asp:ListItem>
                            <asp:ListItem Text="February"></asp:ListItem>
                            <asp:ListItem Text="March"></asp:ListItem>
                            <asp:ListItem Text="April"></asp:ListItem>
                            <asp:ListItem Text="May"></asp:ListItem>
                            <asp:ListItem Text="June"></asp:ListItem>
                            <asp:ListItem Text="July"></asp:ListItem>
                            <asp:ListItem Text="August"></asp:ListItem>
                            <asp:ListItem Text="September"></asp:ListItem>
                            <asp:ListItem Text="October"></asp:ListItem>
                            <asp:ListItem Text="November"></asp:ListItem>
                            <asp:ListItem Text="December"></asp:ListItem>
                        </asp:DropDownList>--%></asp:Panel>
                                </div>
                            </telerik:RadPageView>
                            <telerik:RadPageView ID="pvMsNmoMedications" runat="server">
                                <div class="panelAreaMain">
                                    (For complete baseline medication date, please be sure to enter data for all medications).
                                    <br />
                                    <asp:CheckBox ID="chkBoxBaselineExpandedMSMedicationHistory" runat="server" Text="Click for expanded history of MS medication documentation."
                                        AutoPostBack="true" OnCheckedChanged="chkBoxBaselineExpandedMSMedicationHistory_CheckedChanged" /><br />
                                    <asp:Panel ID="pnlBaselineExpandedMSMedicationHistory" runat="server" Visible="false">
                                        <fieldset>
                                            * Medication History:<br />
                                            <br />
                                            <strong>MSCOE MS MEDICATIONS</strong><br />
                                            > MSCOE.AZATHIOPRINE.NEVER (Date)<br />
                                            > MSCOE.FINGOLIMOD.NEVER (Date)<br />
                                            > MSCOE.OTHER DMT.CURRENT USE (Date)<br />
                                            - testing -
                                            <br />
                                            > MSCOE.OTHER DMT.CURRENT VA (Date)<br />
                                            > MSCOE.OTHER DMT.CURRENT STARTED (Date)
                                        </fieldset>
                                    </asp:Panel>
                                    <br />
                                    <!-- TODO: Medication List Dynamic? -->
                                    <fieldset>
                                        <legend>Azathioprine (Imuran)</legend>
                                        <asp:RadioButtonList ID="rblBaselineMSMedication_Azathioprine" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Never taken"></asp:ListItem>
                                            <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                        </asp:RadioButtonList>
                                        <!-- TODO: checkboxes for Current Therapy and Past Use with dates -->
                                    </fieldset>
                                    <br />
                                    <fieldset>
                                        <legend>Cyclophosphamide (Cytoxan)</legend>
                                        <asp:RadioButtonList ID="rblBaselineMSMedication_Cyclophosphamide" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Never taken"></asp:ListItem>
                                            <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                    <br />
                                    <fieldset>
                                        <legend>Daclizumab (Zenapax)</legend>
                                        <asp:RadioButtonList ID="rblBaselineMSMedication_Daclizumab" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Never taken"></asp:ListItem>
                                            <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                    <br />
                                    <fieldset>
                                        <legend>Fingolimod (Gilenya)</legend>
                                        <asp:RadioButtonList ID="rblBaselineMSMedication_Fingolimod" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Never taken"></asp:ListItem>
                                            <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                    <br />
                                    <fieldset>
                                        <legend>Glatiramer (Copaxone)</legend>
                                        <asp:RadioButtonList ID="rblBaselineMSMedication_Glatiramer" runat="server" RepeatDirection="Vertical">
                                            <asp:ListItem Text="Never taken"></asp:ListItem>
                                            <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </fieldset>
                                    <br />
                                    <fieldset>
                                        <legend>Interferon Group</legend>
                                        <asp:CheckBox ID="chkBoxBaselineNeutralizingInterferonAntibody" runat="server" AutoPostBack="true" Text="Neutralizing Interferon Antibody status:"
                                            OnCheckedChanged="chkBoxBaselineNeutralizingInterferonAntibody_CheckedChanged" /><br />
                                        <asp:Panel ID="pnlBaselineNeutralizingInterferonAntibody" runat="server" Visible="false">
                                            <asp:RadioButtonList ID="rblBaselineNeutralizingInterferonAntibody" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Positive"></asp:ListItem>
                                                <asp:ListItem Text="Negative"></asp:ListItem>
                                                <asp:ListItem Text="Unknown"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </asp:Panel>
                                        <br />
                                        <fieldset>
                                            <legend>Interferon beta-1a</legend>
                                            <fieldset>
                                                <legend>Interferon beta-1a (Avonex)</legend>
                                                <asp:RadioButtonList ID="rblBaselineMSMedication_Interferon1aAvonex" runat="server" RepeatDirection="Vertical">
                                                    <asp:ListItem Text="Never taken"></asp:ListItem>
                                                    <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                                </asp:RadioButtonList>
                                            </fieldset>
                                            <br />
                                            <fieldset>
                                                <legend>Interferon beta-1a (Rebif)</legend>
                                                <asp:RadioButtonList ID="rblBaselineMSMedication_Interferon1aRebif" runat="server" RepeatDirection="Vertical">
                                                    <asp:ListItem Text="Never taken"></asp:ListItem>
                                                    <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                                </asp:RadioButtonList>
                                            </fieldset>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Interferon beta-1b</legend>
                                            <fieldset>
                                                <legend>Interferon beta-1b (Betaseron)</legend>
                                                <asp:RadioButtonList ID="rblBaselineMSMedication_Interferon1b_Betaseron" runat="server" RepeatDirection="Vertical">
                                                    <asp:ListItem Text="Never taken"></asp:ListItem>
                                                    <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                                </asp:RadioButtonList>
                                            </fieldset>
                                            <br />
                                            <fieldset>
                                                <legend>Interferon beta-1b (Extavia)</legend>
                                                <asp:RadioButtonList ID="rblBaselineMSMedication_Interferon1bExtavia" runat="server" RepeatDirection="Vertical">
                                                    <asp:ListItem Text="Never taken"></asp:ListItem>
                                                    <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                                </asp:RadioButtonList>
                                            </fieldset>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Methotrexate (Trexall)</legend>
                                            <asp:RadioButtonList ID="rblBaselineMSMedication_Methotrexate" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Never taken"></asp:ListItem>
                                                <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Mitoxantrone (Novantrone)</legend>
                                            <asp:RadioButtonList ID="rblBaselineMSMedication_Mitoxantrone" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Never taken"></asp:ListItem>
                                                <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Mycophenolate (Cellcept)</legend>
                                            <asp:RadioButtonList ID="rblBaselineMSMedication_Mycophenolate" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Never taken"></asp:ListItem>
                                                <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Natalizumab (Tysabri)</legend>
                                            <asp:RadioButtonList ID="rblBaselineMSMedication_Natalizumab" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Never taken"></asp:ListItem>
                                                <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </fieldset>
                                        <br />
                                        <fieldset>
                                            <legend>Rituximab (Rituxan)</legend>
                                            <asp:RadioButtonList ID="rblBaselineMSMedication_Rituximab" runat="server" RepeatDirection="Vertical">
                                                <asp:ListItem Text="Never taken"></asp:ListItem>
                                                <asp:ListItem Text="Enter historical/current data"></asp:ListItem>
                                            </asp:RadioButtonList>
                                        </fieldset>
                                        <br />
                                        <asp:CheckBox ID="chkBoxBaselineOtherDMTMedications" runat="server" Text="Other DMT Medications" AutoPostBack="true" OnCheckedChanged="chkBoxBaselineOtherDMTMedications_CheckedChanged" /><br />
                                        <asp:CheckBoxList ID="cblBaselineOtherDMTMedications" runat="server" RepeatDirection="Vertical" Enabled="false">
                                            <asp:ListItem Text="Current use of other DMT medication"></asp:ListItem>
                                            <asp:ListItem Text="Past use of other DMT medications"></asp:ListItem>
                                        </asp:CheckBoxList>
                                        <br />
                                        <br />
                                        <asp:CheckBox ID="chkBoxBaselineCorticosteroids" runat="server" Text="Corticosteroids (Only inclue those used for maintenance therapy not relapse therapy)"
                                            AutoPostBack="true" OnCheckedChanged="chkBoxBaselineCorticosteroids_CheckedChanged" /><br />
                                        <asp:CheckBoxList ID="cblBaselineCorticosteroids" runat="server" RepeatDirection="Vertical" Enabled="false">
                                            <asp:ListItem Text="Current Use"></asp:ListItem>
                                            <asp:ListItem Text="Past Use"></asp:ListItem>
                                        </asp:CheckBoxList>
                                    </fieldset>
                                </div>
                            </telerik:RadPageView>
                        </telerik:RadMultiPage>
                    </asp:Panel>
                    <asp:Panel ID="pnlAnnual" runat="server" Visible="false" CssClass="panelContainer">
                        Annual ...
                        <br />
                        <br />
                    </asp:Panel>
                    <asp:Panel ID="pnlInterim" runat="server" Visible="false" CssClass="panelContainer">
                        Interim ...
                        <br />
                        <br />
                    </asp:Panel>
                    <asp:Panel ID="pnlMedicationOnly" runat="server" Visible="false" CssClass="panelContainer">
                        Medication Only ...
                        <br />
                        <br />
                    </asp:Panel>
                </div>
                <asp:Panel ID="pnlNotePreview" runat="server">
                    Note Preview:<br />
                    <table style="width: 100%;">
                        <tr>
                            <td style="vertical-align: top; width: 75px;">
                                <asp:Button ID="btnUpdateNotePreview" runat="server" Text="Update" ToolTip="Update Note Summary Preview" OnClick="btnUpdateNotePreview_Click" />
                            </td>
                            <td style="vertical-align: top;">
                                <asp:TextBox ID="txtNotePreview" runat="server" TextMode="MultiLine" Rows="5" Width="100%"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <asp:Panel ID="pnlHealthFactorPreview" runat="server">
                    Health Factors Preview:<br />
                    <table style="width: 100%;">
                        <tr>
                            <td style="vertical-align: top; width: 75px;">
                                <asp:Button ID="btnUpdateHealthFactors" runat="server" Text="Update" ToolTip="Update Health Factor Preview" OnClick="btnUpdateHealthFactors_Click" />
                            </td>
                            <td style="vertical-align: top;">
                                <asp:TextBox ID="txtHealthFactors" runat="server" TextMode="MultiLine" Rows="5" Width="100%"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
