﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="HealthCareResources.aspx.cs" Inherits="HealthCareResources" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:RadScriptManager ID="RadScriptManager1" runat="server" />
    <telerik:RadAjaxManager ID="radajaxmanagerrpt" runat="server" UpdatePanelsRenderMode="Inline" />
    <telerik:RadSkinManager ID="radSkinManager" Visible="false" runat="server" Skin="Office2007" />
    <telerik:RadAjaxPanel ID="rdajxPanelRpt" runat="server" LoadingPanelID="radAjxLoadingPanelRpt">
        <div id="divl0">
            <fieldset>
                <legend>Manage Health Care Resources </legend>
                <div style="padding-left: 10px; padding-top: 30px; padding-bottom: 30px; background-color: #D6DBE9">
                    <div>
                        <div style="width: 10%; float: left">Facility:</div>
                        <div style="float: left">
                            <telerik:RadComboBox runat="server" ToolTip="facitlity" Width="400px" CheckBoxes="True" ID="ddlFacility" EmptyMessage="-- Select Station --" >
                                <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="Y"></KeyboardNavigationSettings>
                                </telerik:RadComboBox>
                            <asp:Label ID="lblFacFiltered" Visible="false" runat="server" Font-Size="XX-Small" TabIndex="106"
                                Text="(Facility list has been filtered based on your role.)"></asp:Label>
                        </div>
                    </div>
                    <div style="padding-top: 5px; clear: left">
                        <div style="width: 10%; float: left">Visit Date:</div>
                        <div style="width: 15%; float: left">
                            <telerik:RadDatePicker ID="rdpStartDate" ToolTip="Start Date" MinDate="1/1/1900" runat="server" />
                        </div>
                        <div style="width: 15%; float: left">
                            <telerik:RadDatePicker ID="rdpEndDate" ToolTip="End Date" MinDate="1/1/1900" runat="server" />
                        </div>
                    </div>
                    <div style="clear: left; padding-top: 5px;">
                        <div style="width: 10%; float: left">Medication:</div>
                        <div style="width: 10%; float: left">
                            <telerik:RadComboBox runat="server" CssClass="telselect" ID="ddlMeds" EmptyMessage="-- Select Medication --" >
                                <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="M"></KeyboardNavigationSettings>
                            </telerik:RadComboBox>
                        </div>
                    </div>
                    <div style="padding-top: 5px; clear: left; visibility: hidden ">
                        <div style="width: 10%; float: left">Race:</div>
                        <div style="width: 15%; float: left; ">
                            <telerik:RadComboBox runat="server" Visible="False" ToolTip="race" CssClass="telselect" DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT" ID="ddlRace" EmptyMessage="-- Select Race --" />
                        </div>
                    </div>
                    <div style="padding-top: 5px; clear: left; visibility: hidden" >
                        <div style="width: 10%; float: left">Gender:</div>
                        <div style="width: 15%; float: left">

                            <telerik:RadComboBox runat="server" Visible="False"  ToolTip="gender" CssClass="telselect" ID="ddlGender" EmptyMessage="-- Select Gender --">
                                <Items>
                                    <telerik:RadComboBoxItem runat="server" Value="M" Text="Male" />
                                    <telerik:RadComboBoxItem runat="server" Value="F" Text="Female" />
                                </Items>
                            </telerik:RadComboBox>
                        </div>
                    </div>
                    <div style="clear: left; padding-left: 10%; padding-top: 10px;">
                        <telerik:RadButton ID="btnGo" Height="25px" runat="server" Text="View Results" Enabled="true" ToolTip="Click to View Results" TabIndex="200" OnClick="btnGo_Click" />
                    </div>
                </div>
                <fieldset>
                    <div style="padding-left: 5%;  padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="chtMSSubType" Width="80%"  Transitions="false"
                            Skin="Office2007">
                            <ChartTitle Text="MS Sub Type">
                            </ChartTitle>
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="# of Patients" DataFieldY="Count">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Patients:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis DataLabelsField="SourceColumn">
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" />
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 5%;  padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcMsSubTypeByAge" Width="80%" Transitions="false" Skin="Office2007">
                            <ChartTitle Text="Average Age By MS Sub Type">
                            </ChartTitle>
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="Average Age" DataFieldY="Count">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Average Age:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis DataLabelsField="SourceColumn">
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" />
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="Average Age" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 5%;  padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcRaceEthnicity" Width="80%" Transitions="false" Skin="Office2007">
                            <ChartTitle Text="Count of Race/Ethnicity">
                            </ChartTitle>
                            <PlotArea>
                                <Series>
                                    <telerik:BarSeries DataFieldY="Count">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Count of Race/Ethnicity<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:BarSeries>
                                </Series>
                                <XAxis DataLabelsField="SourceColumn" Name="Rx">
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 8%;  padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcPatientGender" Skin="Office2007" Width="60%" Transitions="false">
                            <ChartTitle Text="Patient Gender">
                            </ChartTitle>
                            <Legend>
                                <Appearance BackgroundColor="White" Position="Right"></Appearance>
                            </Legend>
                            <PlotArea>
                                <Series>
                                    <telerik:PieSeries StartAngle="180" Name="Patient Gender" NameField="SourceColumn" DataFieldY="Count">
                                        <LabelsAppearance Position="Center" DataField="Count"></LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'> #=dataItem.SourceColumn# <br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:PieSeries>
                                </Series>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 8%; padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcDmtUsage" Width="70%" Skin="Office2007" Transitions="false">
                            <ChartTitle Text="On Current DMT">
                            </ChartTitle>
                            <Legend>
                                <Appearance BackgroundColor="White" Position="Right"></Appearance>
                            </Legend>
                            <PlotArea>
                                <Series>
                                    <telerik:PieSeries StartAngle="180" Name="Patient Gender" NameField="SourceColumn" DataFieldY="Count">
                                        <LabelsAppearance Position="Center" DataField="Count"></LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'> #=dataItem.SourceColumn# <br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:PieSeries>
                                </Series>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 2%; margin-left: 7%; padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcDmtType" Height="425px" Transitions="false"
                            Skin="Office2007">
                            <ChartTitle Text="DMT Type">
                            </ChartTitle>
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="# of Patients" DataFieldY="Count">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Patients:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis DataLabelsField="SourceColumn">
                                    <LabelsAppearance DataFormatString="{0}" RotationAngle="-45"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" />
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 5%;  padding-top: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcCurrentEdums" Width="80%"  Transitions="false" Skin="Office2007">
                            <ChartTitle Text="Current EDUMS Score">
                            </ChartTitle>
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="# of Patients" DataFieldY="Count">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Patients:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis DataLabelsField="SourceColumn">
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" />
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 5%;  padding-top: 3%; padding-bottom: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="chtHrResourcesSummary" Skin="Office2007" Width="95%" Transitions="false">
                            <ChartTitle Text="Manage Health Care Resources Summary Report" />
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="Values" DataFieldY="value">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Manage Health Care Resources<br /> #=dataItem.sourcecolumn#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis Name="sourcecolumn" DataLabelsField="sourcecolumn">
                                    <LabelsAppearance></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="Values" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>
                    <div style="padding-left: 5%;  padding-top: 3%; padding-bottom: 3%;">
                        <telerik:RadHtmlChart runat="server" ID="rhcOverAllCost" Skin="Office2007" Width="95%" Transitions="false">
                            <ChartTitle Text="Manage Health Care Resources Summary Report - Overall Cost" />
                            <PlotArea>
                                <Series>
                                    <telerik:ColumnSeries Name="Values" DataFieldY="value">
                                        <LabelsAppearance Visible="true">
                                        </LabelsAppearance>
                                        <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Manage Health Care Resources<br /> #=dataItem.sourcecolumn#</div>"></TooltipsAppearance>
                                    </telerik:ColumnSeries>
                                </Series>
                                <XAxis Name="sourcecolumn" DataLabelsField="sourcecolumn">
                                    <LabelsAppearance></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <MajorGridLines Visible="false"></MajorGridLines>
                                </XAxis>
                                <YAxis>
                                    <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                    <MinorGridLines Visible="false"></MinorGridLines>
                                    <TitleAppearance Position="Center" RotationAngle="0" Text="Values" />
                                </YAxis>
                            </PlotArea>
                        </telerik:RadHtmlChart>
                    </div>

                    <telerik:RadGrid ID="rdgrdPatDem" Skin="Office2007"  runat="server" AllowPaging="True" AllowSorting="True" GroupPanelPosition="Top" ToolTip="List of Patients and Demographic Info" OnNeedDataSource="GridViewOnNeedOfDataSource"
                        AllowMultiRowSelection="false" PageSize="20">
                        <SortingSettings SortedBackColor="#ffffff" />
                        <SelectedItemStyle BackColor="#FFE1A4"></SelectedItemStyle>
                        <MasterTableView AllowNaturalSort="true" AllowMultiColumnSorting="true" AllowPaging="True" AllowSorting="True" NoMasterRecordsText="No Records Available for Search Criteria."
                            AutoGenerateColumns="false" ShowHeadersWhenNoRecords="true" CssClass=""
                            PagerStyle-AlwaysVisible="true" TabIndex="0">
                            <Columns>
                                <telerik:GridBoundColumn DataField="PatientICN" DataType="System.String"
                                    HeaderText="Patient ICN" />
                                <telerik:GridBoundColumn DataField="PatientFirstName" DataType="System.String"
                                    HeaderText="First Name" />
                                <telerik:GridBoundColumn DataField="PatientLastName" DataType="System.String"
                                    HeaderText="Last Name" />
                                <telerik:GridBoundColumn DataField="Age" DataType="System.Decimal"
                                    HeaderText="Age" />
                                <telerik:GridBoundColumn DataField="Gender" DataType="System.String"
                                    HeaderText="Gender" />
                                <telerik:GridBoundColumn DataField="Race" DataType="System.String"
                                    HeaderText="Race" />
                                <telerik:GridBoundColumn DataField="Ethnicity" DataType="System.String"
                                    HeaderText="Ethnicity" />
                                <telerik:GridBoundColumn DataField="VISTANAME" DataType="System.String"
                                    HeaderText="Facility" />
                                <telerik:GridBoundColumn DataField="DateOfEDMUS6" DataType="System.String"
                                    HeaderText="Date Of EDMUS6" />
                                <telerik:GridBoundColumn DataField="RxEverAll" DataType="System.String"
                                    HeaderText="Meds" />
                            </Columns>
                        </MasterTableView>
                        <PagerStyle Mode="NumericPages" Position="Bottom" />
                    </telerik:RadGrid>
                </fieldset>
            </fieldset>
            <telerik:RadAjaxLoadingPanel ID="radAjxLoadingPanelRpt" runat="server">
            </telerik:RadAjaxLoadingPanel>
        </div>
    </telerik:RadAjaxPanel>
</asp:Content>

