﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MSSR.Security;
using MSSREnh;
using Telerik.Web.UI;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;

public partial class HealthCareRegulatoryCompliance : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
    protected MSSRInstrumentsManager MssrInstrumentManager = new MSSRInstrumentsManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        //only adminstrator
        if (!IsUserAdmin())
        {
            Logging.WriteLogToFile("WARNING - NOT Authorized. Healthcare Regulatory Compliance aspx - Not authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        if (!Page.IsPostBack)
        {
            SetBreadCrumb();
            PopulateFacilityDropdownList();
            PopulateMedsDropdownList();
            PopulateRaceGenDropdownList();

            PopulateRdgrdPatDem(null, null, null, null, null, null, null, null);
            PopulateReportSummaryChart(null, null, null, null, null, null, null, null);
        }
    }

    private void PopulateRaceGenDropdownList()
    {
        ddlRace.DataSource = MssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("1", "MSAT");
        ddlRace.DataBind();
    }
    private void PopulateRdgrdPatDem(DateTime? startDate, DateTime? endDate, string stationId, int? relpase, string medName, string medNameAdditional, string race, string gender)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetHcrcByFacilityDovMedicationDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional, race, gender);
        rdgrdPatDem.DataBind();

    }
    private void PopulateRdgrdPatDemOnDataSource(DateTime? startDate, DateTime? endDate, string stationId, int? relpase, string medName, string medNameAdditional, string race, string gender)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetHcrcByFacilityDovMedicationDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional, race, gender);


    }
    private bool IsUserAdmin()
    {
        bool isUserAdmin = false;
        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            isUserAdmin = true;
        }
        return isUserAdmin;
    }

    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "HEALTH CARE REGULATORY COMPLIANCE";
    }

    public override string AppObjectCode()
    {
        return "HEALTH CARE REGULATORY COMPLIANCE";
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = " Healthcare Regulatory Compliance ";
        }
    }

    private void PopulateFacilityDropdownList()
    {
        ddlFacility.Items.Clear();
        List<string> limitedStationsList = null;
        if (ShouldLimitResults())
            limitedStationsList = AllowedStations();

        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            //Get distinct list of station IDs that the current status table has results for
            var distinctStations = from stn in ctx.MSSR_CURRENT_STATUS
                                   group stn by stn.Sta3n into g
                                   select new { Key = g.Key, Count = g.Count() };
            //Loop through results, and build list to query institution table
            List<string> distinctStationsList = new List<string>();
            foreach (object currItem in distinctStations)
            {
                if (currItem != null)
                {
                    Type t = currItem.GetType();
                    System.Reflection.PropertyInfo pKey = t.GetProperty("Key");
                    string keyValue = pKey.GetValue(currItem, null).ToString();
                    if (limitedStationsList == null || limitedStationsList.Contains(keyValue))
                    {
                        distinctStationsList.Add(keyValue);
                    }
                }
            }

            var rMgr = new ReportViewManager();
            IEnumerable<GetVisnFacilityListing_Result> facility = rMgr.GetVisnFacilityListing();

            //using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
            //{
            var institutions = (from inst in facility
                                where distinctStationsList.Contains(inst.STATIONNUMBER)
                                //orderby inst.VISTANAME
                                select inst);

            //Get all institution information
            foreach (var inst in institutions)
            {
                if (inst.STATIONNUMBER != null)
                    ddlFacility.Items.Add(new RadComboBoxItem(inst.Name, inst.STATIONNUMBER));
            }

            // Insert 'All' option first
            if (!ShouldLimitResults())
            {
                //ddlFacility.Items.Insert(0, new RadComboBoxItem("Any Location", "All"));
                //lblFacFiltered.Visible = false;

            }
            else
            {
                lblFacFiltered.Visible = true;
            }
            //}
        }
    }

    private bool ShouldLimitResults()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY))
        {
            return true;
        }
        else
        {
            return false;
        }

    }

    private List<string> AllowedStations()
    {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    private void PopulateMedsDropdownList()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            var results = from meds in ctx.MSSR_MEDICATIONs
                          select meds;

            List<ListItem> liList = new List<ListItem>();
            ListItem liItem = null;
            foreach (MSSR_MEDICATION currMed in (results.ToList()))
            {
                liItem = new ListItem();
                liItem.Value = currMed.ID.ToString();
                liItem.Text = currMed.MEDICATION;
                liList.Add(liItem);
            }

            //Manually add Corticosteroids to the drop down,
            //these items are not dynamic so should not need added to
            //without a coding change anyway
            liItem = new ListItem();
            liItem.Text = "Dexamethasone IV (Decadron)";
            liItem.Value = "100000";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone IV (Solumedrol)";
            liItem.Value = "100001";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone PO (Medrol)";
            liItem.Value = "100002";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Prednisone PO";
            liItem.Value = "100003";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "CORTICOSTEROIDS (PREDNISONE) (DEXAMETHASONE)";
            liItem.Value = "PREDNISONE (DEXAMETHASONE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "GLATIRAMER ACETATE";
            liItem.Value = "GLATIRAMER (ACETATE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "TERIFLUNOMIDE";
            liItem.Value = "TERIFLUNOMIDE";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "NO MEDICATION";
            liItem.Value = "NO MEDICATION";
            liList.Add(liItem);

            liList.Sort((a, b) => string.Compare(a.Text, b.Text));

            ddlMeds.DataSource = liList;
            ddlMeds.DataBind();
            ddlMeds.Items.Insert(0, new RadComboBoxItem("Any Medication", ""));
        }
    }

    protected void btnGo_Click(object sender, EventArgs e)
    {
        DateTime? startDate = null;
        DateTime? endDate = null;
        int? stationId = null;
        int? relapse = null;
        string medName = null;
        string race = null;
        string gender = null;
        string tempMed = null;
        string tempMedAdditional = null;
        string listOfStations = null;

        var stationIds = ddlFacility.CheckedItems;
        var ids = new StringBuilder();
        foreach (var item in stationIds)
        {
            ids.Append(item.Value).Append(",");
        }

        if (!string.IsNullOrEmpty(ids.ToString()))
        {
            listOfStations = ids.ToString();
        }



        if (rdpStartDate.SelectedDate.HasValue)
        {
            startDate = rdpStartDate.SelectedDate.Value;
        }
        if (rdpEndDate.SelectedDate.HasValue)
        {
            endDate = rdpEndDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(ddlFacility.SelectedValue))
        {
            stationId = Int32.Parse(ddlFacility.SelectedValue);
        }

        if (ddlRace.SelectedIndex != -1)
        {
            race = ddlRace.SelectedValue;
        }
        if (ddlGender.SelectedIndex != -1)
        {
            gender = ddlGender.SelectedValue;
        }

        if (ddlMeds.SelectedIndex != -1)
        {
            medName = ddlMeds.SelectedValue;
            tempMed = ddlMeds.SelectedValue;
        }

        if (!string.IsNullOrEmpty(medName))
        {
            if (!string.IsNullOrEmpty(tempMed))
            {
                if (tempMed.Contains('(') && tempMed.Contains(')'))
                {
                    tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                    tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
                }
            }

        }
        else
        {
            tempMedAdditional = null;
            tempMed = null;
        }

        listOfStations = !string.IsNullOrEmpty(listOfStations) ? listOfStations.TrimEnd() : null;
        tempMed = !string.IsNullOrEmpty(tempMed) ? tempMed.Trim() : null;
        PopulateRdgrdPatDem(startDate, endDate, listOfStations, null, tempMed, tempMedAdditional, race, gender);
        PopulateReportSummaryChart(startDate, endDate, listOfStations, relapse, tempMed, tempMedAdditional, race, gender);
    }

    protected void GridViewOnNeedOfDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        PopulateGridView();
    }
    protected void PopulateGridView()
    {
        DateTime? startDate = null;
        DateTime? endDate = null;
        int? stationId = null;
        int? relapse = null;
        string medName = null;
        string race = null;
        string gender = null;
        string tempMed = null;
        string tempMedAdditional = null;
        string listOfStations = string.Empty;

        var stationIds = ddlFacility.CheckedItems;
        var ids = new StringBuilder();
        foreach (var item in stationIds)
        {
            ids.Append(item.Value).Append(",");
        }

        listOfStations = ids.ToString();

        if (rdpStartDate.SelectedDate.HasValue)
        {
            startDate = rdpStartDate.SelectedDate.Value;
        }
        if (rdpEndDate.SelectedDate.HasValue)
        {
            endDate = rdpEndDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(ddlFacility.SelectedValue))
        {
            stationId = Int32.Parse(ddlFacility.SelectedValue);
        }

        if (ddlRace.SelectedIndex != -1)
        {
            race = ddlRace.SelectedValue;
        }
        if (ddlGender.SelectedIndex != -1)
        {
            gender = ddlGender.SelectedValue;
        }

        if (ddlMeds.SelectedIndex != -1)
        {
            medName = ddlMeds.SelectedValue;
            tempMed = ddlMeds.SelectedValue;
        }

        if (!string.IsNullOrEmpty(medName))
        {
            if (!string.IsNullOrEmpty(tempMed))
            {
                if (tempMed.Contains('(') && tempMed.Contains(')'))
                {
                    tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                    tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
                }
            }
        }
        if (!string.IsNullOrEmpty(listOfStations))
        {
            listOfStations = listOfStations.TrimEnd();
        }
        listOfStations = !string.IsNullOrEmpty(listOfStations) ? listOfStations.TrimEnd() : null;

        PopulateRdgrdPatDemOnDataSource(startDate, endDate, listOfStations, null, tempMed, tempMedAdditional, race, gender);
        PopulateReportSummaryChart(startDate, endDate, listOfStations, relapse, tempMed, tempMedAdditional, race, gender);

    }

    private void PopulateReportSummaryChart(DateTime? startDate, DateTime? endDate, string stationId, int? relpase, string medName, string medNameAdditional, string race, string gender)
    {

        var rMgr = new ReportViewManager();
        var results =
            rMgr.GetManagerResourcesSummary(startDate, endDate, stationId, relpase, medName, medNameAdditional, race,
                gender).ToList();
        chtHrResourcesSummary.DataSource = results.Where(a => a.groupId != 5);
        chtHrResourcesSummary.DataBind();

        rhcOverAllCost.DataSource = results.Where(a => a.groupId == 5); ;
        rhcOverAllCost.DataBind();
    }
}