﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="HealthCareRegulatoryCompliance.aspx.cs" Inherits="HealthCareRegulatoryCompliance" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:RadScriptManager ID="RadScriptManager1" runat="server" />
    <telerik:RadAjaxManager ID="radajaxmanagerrpt" runat="server" UpdatePanelsRenderMode="Inline" />
    <telerik:RadSkinManager ID="radSkinManager" Visible="false" runat="server" Skin="Office2007" />

    <telerik:RadAjaxPanel ID="rdajxPanelRpt" runat="server" LoadingPanelID="radAjxLoadingPanelRpt">
        <fieldset>
            <legend>Health Care Regulatory Compliance </legend>
            <div style="padding-left: 10px; padding-top: 30px; padding-bottom: 30px; background-color: #D6DBE9">
                <div>
                    <div style="width: 10%; float: left">Facility:</div>
                    <div style="float: left">
                        <telerik:RadComboBox runat="server" ToolTip="facitlity" Width="400px" ID="ddlFacility" CheckBoxes="True" EmptyMessage="-- Select Station --">
                            <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="Y"></KeyboardNavigationSettings>
                        </telerik:RadComboBox>
                        <asp:Label ID="lblFacFiltered" Visible="false" runat="server" Font-Size="XX-Small" TabIndex="106"
                            Text="(Facility list has been filtered based on your role.)"></asp:Label>
                    </div>
                </div>
                <div style="padding-top: 5px; clear: left">
                    <div style="width: 10%; float: left">Visit Date:</div>
                    <div style="width: 15%; float: left">
                        <telerik:RadDatePicker ID="rdpStartDate" ToolTip="Start Date" MinDate="1/1/1900" runat="server" />
                    </div>
                    <div style="width: 15%; float: left">
                        <telerik:RadDatePicker ID="rdpEndDate" ToolTip="End Date" MinDate="1/1/1900" runat="server" />
                    </div>
                </div>
                <div style="clear: left; padding-top: 5px;">
                    <div style="width: 10%; float: left">Medication:</div>
                    <div style="width: 10%; float: left">
                        <telerik:RadComboBox runat="server" CssClass="telselect" ID="ddlMeds" EmptyMessage="-- Select Medication --">
                            <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="M"></KeyboardNavigationSettings>
                        </telerik:RadComboBox>
                    </div>
                </div>
                <div style="padding-top: 5px; clear: left">
                    <div style="width: 10%; float: left">Race:</div>
                    <div style="width: 15%; float: left">
                        <telerik:RadComboBox runat="server" ToolTip="race" CssClass="telselect" DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT" ID="ddlRace" EmptyMessage="-- Select Race --">
                            <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="Q"></KeyboardNavigationSettings>
                        </telerik:RadComboBox>
                    </div>
                </div>
                <div style="padding-top: 5px; clear: left">
                    <div style="width: 10%; float: left">Gender:</div>
                    <div style="width: 15%; float: left">

                        <telerik:RadComboBox runat="server" ToolTip="gender" CssClass="telselect" ID="ddlGender" EmptyMessage="-- Select Gender --">
                            <KeyboardNavigationSettings CommandKey="Ctrl" FocusKey="V"></KeyboardNavigationSettings>
                            <Items>
                                <telerik:RadComboBoxItem runat="server" Value="M" Text="Male" />
                                <telerik:RadComboBoxItem runat="server" Value="F" Text="Female" />
                            </Items>
                        </telerik:RadComboBox>
                    </div>
                </div>
                <div style="clear: left; padding-left: 10%; padding-top: 10px;">
                    <telerik:RadButton ID="btnGo" Height="25px" runat="server" Text="View Results" Enabled="true" ToolTip="Click to View Results" TabIndex="200" OnClick="btnGo_Click" />
                </div>
            </div>
            <fieldset>
                <div style="padding-top: 30px; padding-bottom: 30px; width: 90%;">
                    <telerik:RadHtmlChart runat="server" ID="chtHrResourcesSummary" Transitions="false"
                        Skin="Vista">
                        <ChartTitle Text="Health Care Regulatory Compliance" />
                        <PlotArea>
                            <Series>
                                <telerik:ColumnSeries Name="Values" DataFieldY="value">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Health Care Regulatory Compliance <br /> #=dataItem.sourcecolumn#</div>"></TooltipsAppearance>
                                </telerik:ColumnSeries>
                            </Series>
                            <XAxis Name="sourcecolumn" DataLabelsField="sourcecolumn">
                                <LabelsAppearance></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="Values" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                </div>

                <div style="padding-left: 5%; padding-top: 3%; padding-bottom: 3%;">
                    <telerik:RadHtmlChart runat="server" ID="rhcOverAllCost" Skin="Vista" Width="95%" Transitions="false">
                        <ChartTitle Text="Manage Health Care Resources Summary Report - Overall Cost" />
                        <PlotArea>
                            <Series>
                                <telerik:ColumnSeries Name="Values" DataFieldY="value">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Manage Health Care Resources<br /> #=dataItem.sourcecolumn#</div>"></TooltipsAppearance>
                                </telerik:ColumnSeries>
                            </Series>
                            <XAxis Name="sourcecolumn" DataLabelsField="sourcecolumn">
                                <LabelsAppearance></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="Values" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                </div>

                <telerik:RadGrid ID="rdgrdPatDem" runat="server" AllowPaging="True" AllowSorting="True" GroupPanelPosition="Top" ToolTip="List of Patients and Demographic Info" OnNeedDataSource="GridViewOnNeedOfDataSource"
                    AllowMultiRowSelection="false" PageSize="20">
                    <SortingSettings SortedBackColor="#ffffff" />
                    <SelectedItemStyle BackColor="#FFE1A4"></SelectedItemStyle>
                    <MasterTableView AllowNaturalSort="true" AllowMultiColumnSorting="true" AllowPaging="True" AllowSorting="True" NoMasterRecordsText="No Records Available for Search Criteria."
                        AutoGenerateColumns="false" ShowHeadersWhenNoRecords="true" CssClass=""
                        PagerStyle-AlwaysVisible="true" TabIndex="0">
                        <Columns>
                            <telerik:GridBoundColumn DataField="PatientICN" DataType="System.String"
                                HeaderText="Patient ICN" />
                            <telerik:GridBoundColumn DataField="PatientFirstName" DataType="System.String"
                                HeaderText="First Name" />
                            <telerik:GridBoundColumn DataField="PatientLastName" DataType="System.String"
                                HeaderText="Last Name" />
                            <telerik:GridBoundColumn DataField="Age" DataType="System.Decimal"
                                HeaderText="Age" />
                            <telerik:GridBoundColumn DataField="Gender" DataType="System.String"
                                HeaderText="Gender" />
                            <telerik:GridBoundColumn DataField="Race" DataType="System.String"
                                HeaderText="Race" />
                            <telerik:GridBoundColumn DataField="Ethnicity" DataType="System.String"
                                HeaderText="Ethnicity" />
                            <telerik:GridBoundColumn DataField="VISTANAME" DataType="System.String"
                                HeaderText="Facility" />
                            <telerik:GridBoundColumn DataField="RxEverAll" DataType="System.String"
                                HeaderText="Meds" />
                            <telerik:GridTemplateColumn HeaderTooltip="Click to see Lab details." HeaderText="Num Of Labs">
                                <ItemTemplate>
                                    <a href="Lab.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see Lab details">
                                        <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NumOfLabs"))) %></a>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                    <PagerStyle Mode="NumericPages" Position="Bottom" />
                </telerik:RadGrid>
            </fieldset>
        </fieldset>
        <telerik:RadAjaxLoadingPanel ID="radAjxLoadingPanelRpt" runat="server">
        </telerik:RadAjaxLoadingPanel>
    </telerik:RadAjaxPanel>
</asp:Content>

