﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ExportPatientToExcel.aspx.cs" Inherits="Export_ExportPatientToExcel" EnableEventValidation="false" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
    <asp:GridView ID="grdMSPatients" AutoGenerateColumns="False" CellPadding="5" Width="99.5%" EmptyDataText="Currently, showing no data. Please select filters from above and click the 'View Results' button."
        AllowSorting="false" runat="server" BorderWidth="2"
        BorderStyle="Solid" BorderColor="#CCCCCC" OnRowDataBound="grdMSPatients_RowDataBound" OnRowCreated="grdMSPatients_RowCreated"
        TabIndex="1013" PageSize="10">
        <HeaderStyle CssClass="FrozenHeader" />
        <AlternatingRowStyle BackColor="#F4F4F4" />
        <Columns>
            <asp:TemplateField HeaderText="Patient Name (SSN4)" SortExpression="NameSSN" AccessibleHeaderText="Patient Name and last four of SSN">
                <ItemTemplate>
                    <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("NameSSN"))) %>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="NameSSN" HeaderText="Patient Name (SSN4)" SortExpression="NameSSN" AccessibleHeaderText="Patient Name and last four of SSN" />
            <asp:BoundField DataField="Sta3n" HeaderText="Facility" SortExpression="Sta3n" AccessibleHeaderText="Facility Name" />
            <asp:BoundField DataField="Age" HeaderText="Age" SortExpression="Age" AccessibleHeaderText="Patient Age" />
            <asp:BoundField DataField="Gender" HeaderText="Gender" SortExpression="Gender" AccessibleHeaderText="Patient Gender" />
            <asp:BoundField DataField="RaceEthnicity" HeaderText="Race/Ethnicity" SortExpression="RaceEthnicity" AccessibleHeaderText="Patient Race / Ethnicity" />
            <asp:BoundField DataField="BaselineAssessDate" DataFormatString="{0:MM/dd/yyyy}" HeaderText="Baseline" SortExpression="BaselineAssessDate"
                AccessibleHeaderText="Baseline Assessment Date" />
            <asp:BoundField DataField="LastAssessDate" DataFormatString="{0:MM/dd/yyyy}" HeaderText="Last Assessment" SortExpression="LastAssessDate"
                AccessibleHeaderText="Last Assessment Date" />
            <asp:BoundField DataField="LastSymptomYear" HeaderText="Year of 1st Symptom" SortExpression="LastSymptomYear" AccessibleHeaderText="Last Symptom Year" />
            <asp:BoundField DataField="MSDiagnosis" HeaderText="Dx" SortExpression="MSDiagnosis" AccessibleHeaderText="MS Diagnosis" />
            <asp:BoundField DataField="LastMSSubType" HeaderText="MS Subtype" SortExpression="LastMSSubType" AccessibleHeaderText="MS Subtype" />
            <asp:BoundField DataField="LastRelapses" HeaderText="Relapses past Yr." SortExpression="LastRelapses" AccessibleHeaderText="Number of relapses in past year" />
            <asp:BoundField DataField="LastEdumsScore" HeaderText="EDMUS Score" SortExpression="LastEdumsScore" AccessibleHeaderText="Last EDMUS score" />
            <asp:BoundField DataField="PreviousEdmusScore" HeaderText="Prev. EDMUS" SortExpression="PreviousEdmusScore" AccessibleHeaderText="Previous EDMUS score" />
            <asp:BoundField DataField="RxAll" HeaderText="Current VA" SortExpression="RxAll" AccessibleHeaderText="Current Medications" />
        </Columns>
    </asp:GridView>
    </form>
</body>
</html>
