﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Globalization;
using VeteransAffairs.Registries.BusinessManager;

public partial class Export_ExportAssessmentToExcel : System.Web.UI.Page {

    #region Member Variables

    //private string Location = "";
    //private bool foundRequestVar = false;
    //private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected string patientName; // p1
    protected string patientICN; // p2
    protected string selectedFacility; // p3
    protected string selectedDiagnosis; // p4
    protected string currentEdmusScore; // p5
    protected string interviewCompletedBy; // p6
    protected string relapses; // p7
    protected string sortExpression; // p8
    protected string sortDirection; // p9

    #endregion

    #region Public Overrides

    public override void VerifyRenderingInServerForm(Control control) { }

    #endregion

    protected void Page_Load(object sender, EventArgs e) {
        // get vars
        try {
            patientName = Server.UrlDecode(Request.QueryString.Get("p1"));
            patientICN = Server.UrlDecode(Request.QueryString.Get("p2"));
            selectedFacility = Server.UrlDecode(Request.QueryString.Get("p3"));
            selectedDiagnosis = Server.UrlDecode(Request.QueryString.Get("p4"));
            currentEdmusScore = Server.UrlDecode(Request.QueryString.Get("p5"));
            interviewCompletedBy = Server.UrlDecode(Request.QueryString.Get("p6"));
            relapses = Server.UrlDecode(Request.QueryString.Get("p7"));
            sortExpression = Server.UrlDecode(Request.QueryString.Get("p8"));
            sortDirection = Server.UrlDecode(Request.QueryString.Get("p9"));

            filterData();

            // write response to excel
            Response.Clear();
            Response.Charset = "";
            Response.ContentType = "application/vnd.ms-excel";
            Response.AppendHeader("content-disposition", "attachment; filename=MSSR_AssessmentExport.xls");
            System.IO.StringWriter sw = new System.IO.StringWriter();
            System.Web.UI.HtmlTextWriter hw = new System.Web.UI.HtmlTextWriter(sw);
            grdMSAssessments.RenderControl(hw);
            Response.Write(sw.ToString());
            Response.End();

        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("ExportAssessementToExcel Page_Load: " + ex.Message);

            throw ex;
            //throw new Exception("Unable to parse variables");
        }
    }

    /// <summary>
    /// Fired on row data bound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSAssessments_RowDataBound(object sender, GridViewRowEventArgs e) {
        CultureInfo provider = CultureInfo.InvariantCulture;

        foreach (GridViewRow row in grdMSAssessments.Rows) {
            if (row.RowType == DataControlRowType.DataRow) {
                if (row.RowType == DataControlRowType.Header) {
                    e.Row.CssClass = "locked";
                }
            }
        }
    }

    /// <summary>
    /// Fired on row created - to create merged cells at top of table.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSAssessments_RowCreated(object sender, GridViewRowEventArgs e) {
    }

    /// <summary>
    /// Filter and query performed for data matching filters.
    /// </summary>
    private void filterData() {
        #region Gather Request Variables

        // (Legacy)

        //Get stuff from  lists in Main
        int Sta3n = 0;
        String PatientName = "";
        String PatientICN = "";
        String Diagnosis = "All";
        //String AssessmentType = "All";
        String InterviewCompletedBy = "All";
        String edmusScore = "All";
        String Relapses = "All";

        if (!string.IsNullOrEmpty(selectedFacility)) {
            if (selectedFacility.ToLower() != "all")
                Sta3n = VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(selectedFacility);
        } else {
            Sta3n = -1;
        }

        PatientName = patientName;
        PatientICN = patientICN;

        if (!(selectedDiagnosis == null))
            Diagnosis = selectedDiagnosis;

        if (!(currentEdmusScore == null)) {
            edmusScore = currentEdmusScore;
        }

        //if (!(rblGender.SelectedValue == null))
        //    Gender = rblGender.SelectedValue;
        //AssessmentType = Request.QueryString["AssessmentType"];
        if (!(interviewCompletedBy == null))
            InterviewCompletedBy = interviewCompletedBy;

        if (!(relapses == null))
            Relapses = relapses;

        #endregion

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {

            var pats = from hf in db.MSSR_HF_Condenseds
                       join pat in db.MSSR_PATIENT_DEMs on hf.PatientICN equals pat.PatientICN
                       select new MssrAssessmentDisplay() {
                           PatientSID = hf.PatientSID,
                           AssessmentDateTime = hf.AssessmentDateTime,
                           AssessmentType = hf.AssessmentType,
                           CurrentDisabilityScore = hf.CurrentDisabilityScore,
                           CurrentMedications = "",
                           DiagnosisYear = Helpers.getYearFromMonthYear(hf.DiagnosisYear),
                           Ethnicity = hf.Ethnicity,
                           MSDiagnosis = hf.MSDiagnosis,
                           MSInterview = hf.MSInterview,
                           MSSC = hf.MSSC,
                           MSSubType = hf.MSSubType,
                           PatientICN = hf.PatientICN,
                           PatientName = pat.PatientName,
                           Race = pat.Race,
                           Relapses = hf.Relapses,
                           Sta3n = hf.Sta3n,
                           SymptomYear = Helpers.getYearFromMonthYear(hf.SymptomYear)
                       };

            pats = pats.OrderByDescending(P => P.AssessmentDateTime);

            if (!String.IsNullOrEmpty(PatientName)) {
                pats = pats.AsQueryable().Where(eg => eg.PatientName.Contains(PatientName));
            }

            if (!String.IsNullOrEmpty(PatientICN)) {
                int patIcn = 0;
                Int32.TryParse(PatientICN, out patIcn);

                if (patIcn > 0) {
                    pats = pats.AsQueryable().Where(eg => eg.PatientICN == patIcn);
                }
            }

            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            if (Diagnosis != "All") {
                if (Diagnosis == "RRMS" || Diagnosis == "SPMS" || Diagnosis == "PPMS" || Diagnosis == "PRMS")
                    pats = pats.AsQueryable().Where(eg => eg.MSSubType.Equals(Diagnosis));
                else
                    pats = pats.AsQueryable().Where(eg => eg.MSDiagnosis.Equals(Diagnosis));
            }

            if (Relapses != "All") {
                if (Relapses == "0" || Relapses == "1")
                    pats = pats.AsQueryable().Where(eg => eg.Relapses == Convert.ToInt32(Relapses));
                else
                    pats = pats.AsQueryable().Where(eg => eg.Relapses > 1);
            }

            if (InterviewCompletedBy == "1") {
                // Telephone
                pats = pats.AsQueryable().Where(eg => eg.MSInterview.Contains("phone"));
            } else if (InterviewCompletedBy == "2") {
                // Clinical Video Teleconferencing
                pats = pats.AsQueryable().Where(eg => eg.MSInterview.Contains("video"));
            } else if (InterviewCompletedBy == "3") {
                // In-person Assessment
                pats = pats.AsQueryable().Where(eg => eg.MSInterview.Contains("face"));
            }

            if (edmusScore != "All") {
                pats = pats.AsQueryable().Where(p => p.CurrentDisabilityScore.ToLower() == edmusScore.ToLower());
            }

            if (!String.IsNullOrEmpty(sortExpression) && !String.IsNullOrEmpty(sortDirection)) {
                pats = pats.OrderBy(p => p.PatientName);
               // pats = pats.OrderBy(GetSortExpression(sortExpression, sortDirection));    
               /* Removed: looking into better alternative implementation....*/
            }

            grdMSAssessments.DataSource = pats;
            grdMSAssessments.DataBind();
        }
    }
   
}
