﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;
using MSSR.Security;
using System.IO;
using System.Web.UI.HtmlControls;

public partial class DataElementsExport : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
    #region Public Overrides

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string MenuItemName()
    {
        return "Data Export";
    }

    public override string AppObjectCode()
    {
        return "DATA EXPORT";
    }

    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        setBreadCrumb();
        if (IsUserAllowed())
        {
            pnlMSSRDataExport.Enabled = true;
            pnlMSSRDataExport.Visible = true;
        }
    }

    private void setBreadCrumb()
    {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "Data Export";
    }

    private bool IsUserAllowed()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    protected void btnExportCurrentStatus_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start Current Staus Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {               
                var currentStatus = from cstatus in dtx.VW_MSSR_CURRENT_STATUS_EXPORTs
                                    select cstatus;
                GridView currentStatusGrdVw = new GridView();
                currentStatusGrdVw.DataSource = currentStatus;
                currentStatusGrdVw.DataBind();
                ExportToExcel(currentStatusGrdVw, "current_status_export");                
            }
            Logging.WriteLogToFile("Complete Current Status Export - {0}", _user.UserName.ToString());
        }
        catch (Exception)
        {
           Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "current_status_export", _user.UserName.ToString()));
        }
            
           

    }
    protected void btnExportPntDemog_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start Patient Demographics Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {
                var patdemographic = from patdem in dtx.VW_MSSR_PATIENT_DEMOMGRAPHICS_EXPORTs
                                     select patdem;
                GridView patdemgridview = new GridView();
                patdemgridview.DataSource = patdemographic;
                patdemgridview.DataBind();
                ExportToExcel(patdemgridview, "patient_demographics_export");
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "patient_demographics_export", _user.UserName.ToString()));
        }
            
        
    }
    protected void btnExportPatMed_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start Patient Medication Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {
                var patmeds = from patmed in dtx.VW_MSSR_PATIENT_MEDICATION_EXPORTs
                              select patmed;
                GridView patmedsGrdv = new GridView();
                patmedsGrdv.DataSource = patmeds;
                patmedsGrdv.DataBind();
                ExportToExcel(patmedsGrdv, "patient_medication_export");
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "patient_medication_export", _user.UserName.ToString()));
        }         
        
    }
    protected void btnExportInpatMed_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start INPatient PHARMACY Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {
                var patinptPharmacyMeds = from patInpPharmacymed in dtx.VW_MSSRE_DSS_INPATIENT_PHARMACY_MEDICATION_EXPORTs
                                          select patInpPharmacymed;

                GridView patinptPharmacyMedsGrdv = new GridView();
                patinptPharmacyMedsGrdv.DataSource = patinptPharmacyMeds.Take(100);
                patinptPharmacyMedsGrdv.DataBind();
                ExportToExcel(patinptPharmacyMedsGrdv, "inpatient_pharmacy_export");
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "inpatient_pharmacy_export", _user.UserName.ToString()));
        }       
            
    }
    protected void btnExportOutPntPha_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start OUTPatient PHARMACY Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {
                var patoutPharmacy = from patOutPharmacy in dtx.VW_MSSRE_DSS_OUTPATIENT_PHARMACY_EXPORTs
                                     select patOutPharmacy;
                GridView patoutPharmacyGrdv = new GridView();
                patoutPharmacyGrdv.DataSource = patoutPharmacy;//.Take(500);
                patoutPharmacyGrdv.DataBind();
                ExportToExcel(patoutPharmacyGrdv, "outpatient_pharmacy_export");
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "outpatient_pharmacy_export", _user.UserName.ToString()));
        }       
    }

    
    protected void btnMSSREPatientDem_Click(object sender, EventArgs e)
    {
        try
        {
            Logging.WriteLogToFile("Start MSSRE patient_demographics Export - {0}", _user.UserName.ToString());
            using (MSSRDataClassesDataContext dtx = new MSSRDataClassesDataContext())
            {
                var patdemogmssres = from patdemogmssre in dtx.VW_MSSRE_PATIENT_DEMOMGRAPHICS_EXPORTs
                                     select patdemogmssre;

                GridView patdemmssreGrdv = new GridView();
                patdemmssreGrdv.DataSource = patdemogmssres;//.Take(500);
                patdemmssreGrdv.DataBind();
                ExportToExcel(patdemmssreGrdv, "patient_demographics_export");

            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error Exporting - {0}", string.Concat("File Name:{0} For User: {1}", "patient_demographics_export", _user.UserName.ToString()));           
        }       
    }

    private void ExportToExcel(GridView GridView1, string filename)
    {       
            if (IsUserAllowed())
            {
                Logging.WriteLogToFile("Exporting - {0}",string.Concat("File Name:{0} For User: {1}",filename, _user.UserName.ToString()));
                PrepareGridViewForExport(GridView1);

                string attachment = "attachment; filename=" + filename + ".xls";
                Response.ClearContent();
                Response.AddHeader("content-disposition", attachment);
                Response.ContentType = "application/ms-excel";
                StringWriter sw = new StringWriter();
                HtmlTextWriter htw = new HtmlTextWriter(sw);

                GridView1.RenderControl(htw);

                //style to format numbers to string
                string style = @"<style> .textmode { mso-number-format:\@; } </style>";
                Response.Write(style);
                Response.Write(sw.ToString());
                Response.Flush();
                Response.End();
            }      

    }
}