﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="CreateSurvey.aspx.cs" Inherits="CreateSurvey" %>


<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="MSSR" TagName="MedicationSelection" Src="~/controls/Medications.ascx" %>
<%@ Register TagPrefix="MSSR" TagName="MonthYearSelector" Src="~/controls/MonthYearSelector.ascx" %>
<%@ Register TagPrefix="MSSR" TagName="CorticosteroidsMedicationSelection" Src="~/controls/CorticosteroidsMedication.ascx" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MSAT" />
    <telerik:RadScriptManager ID="RadScriptManager1" runat="server" />
    <telerik:RadAjaxManager ID="radajaxmanagermsat" runat="server" UpdatePanelsRenderMode="Inline" />
    <telerik:RadSkinManager ID="radSkinManager" Visible="false" runat="server" Skin="WebBlue" />
    <telerik:RadAjaxPanel ID="rdajxPanelSurveyEdit" runat="server" LoadingPanelID="radAjxLoadingPanelSurveyEdit">
        <div style="padding-left: 15px; height: 20px; background-color: #1E2E50; color: whitesmoke">
            <asp:Label ID="lblPatNameLast4" runat="server"></asp:Label>
        </div>
        <div style="padding-left: 20px; border: solid; border-width: 1px; border-color: #5D7B94">
            <asp:CustomValidator ID="msatEditCustomValidator" ValidationGroup="OnSave" OnServerValidate="msatEditCustomValidator_ServerValidate" runat="server" />
            <asp:ValidationSummary ID="ValidationSummarySurveyEdit" DisplayMode="BulletList" ValidationGroup="OnSave" HeaderText="Please enter the following values:-" runat="server" />
            <div>
                <asp:Panel ID="pnlNotification" runat="server" Visible="false" BackColor="#FFD57D">
                    <div style="width: 100%; padding-top: 10px; padding-bottom: 10px">
                        <div style="font-weight: 600">
                            <asp:Label ID="LabelNotificationTitle" runat="server"> </asp:Label>
                        </div>
                        <asp:Label ID="LabelNotificationMessage" runat="server" Text=""></asp:Label>
                    </div>
                </asp:Panel>
            </div>
        </div>
        <div style="padding-top: 10px">
            <telerik:RadTabStrip ID="rtsTabStrip" runat="server"  MultiPageID="rmpTabContent" ClickSelectedTab="true" CausesValidation="False"  >
                <KeyboardNavigationSettings CommandKey="Alt" FocusKey="J" ></KeyboardNavigationSettings>
                <Tabs>
                    <telerik:RadTab Value="1" Text="Patient Information"  PageViewID="rpvGeneralContent" ToolTip="Patient Information" SelectedCssClass="teltab"></telerik:RadTab>
                    <telerik:RadTab Value="2" Text="MS Information" PageViewID="rpvMSInformation" ToolTip="MS Information" SelectedCssClass="teltab"></telerik:RadTab>
                    <telerik:RadTab Value="3" Text="DMT Medications" PageViewID="rpvListMedContent" ToolTip="DMT Medications" SelectedCssClass="teltab"></telerik:RadTab>
                    <telerik:RadTab Value="4" Text="Corticosteroids " PageViewID="rpvCorticosteroidMedContent" ToolTip="Corticosteroids" SelectedCssClass="teltab"></telerik:RadTab>
                    <telerik:RadTab Value="5" Text="Antibody Status" PageViewID="rpvInterferonGroup" ToolTip="Antibody Status" SelectedCssClass="teltab"></telerik:RadTab>
                </Tabs>
            </telerik:RadTabStrip>
            <div>
                <asp:Panel runat="server" ID="pnlMainContent">
                    <telerik:RadMultiPage runat="server" ID="rmpTabContent">
                        <telerik:RadPageView ID="rpvGeneralContent" Selected="true" runat="server">
                            <div id="divGenInfo">
                                <div>
                                    <div style="float: left">
                                        <asp:Label ID="LabelForLast4" runat="server" AssociatedControlID="lblLast4"
                                            ></asp:Label>
                                        <asp:Label ID="lblLast4" runat="server"  />
                                    </div>
                                    <br />
                                </div>
                                <div style="float: left; clear: both; width: 100%; padding-bottom: 40px; padding-top: 0px">
                                    <div style="float: left; width: 35%">

                                        <div style="float: left; padding-top: 5px;">
                                            <div style="float: left; width: 150px">
                                                <asp:Label ID="LabelForAssessmentDate" runat="server" Text="Assessment Date" AssociatedControlID="dpDate1"
                                                    ></asp:Label><span title="required" class="requiredField"> *</span>
                                            </div>
                                            <div style="float: right;">
                                                <telerik:RadDatePicker ID="dpDate1" runat="server" Width="200px" >
                                                    <Calendar ID="calDate1" runat="server"></Calendar>
                                                </telerik:RadDatePicker>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1"
                                                     ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assessment Date is required and must not be in the future."></asp:RequiredFieldValidator>
                                            </div>
                                        </div>
                                        <!--Date picker-->
                                        <div>
                                        <div style="clear: both; float: left; padding-top: 5px;">
                                            <div style="float: left; width: 150px">
                                                <asp:Label ID="LabelForDateOfDeathDem" runat="server" Text="Date of Death: "
                                                    Visible="true"></asp:Label>
                                            </div>
                                            <!--Date-->
                                            <div style="float: right;">
                                                <asp:Label ID="lblDateOfDeath" runat="server" Text=""  Visible="true" />
                                                <telerik:RadDatePicker ID="dpDate2" runat="server" Width="200px" >
                                                    <Calendar ID="calDate2" runat="server"></Calendar>
                                                </telerik:RadDatePicker>
                                            </div>
                                        </div>
                                        <div style="clear: both; float: left; padding-top: 5px;">
                                            <div style="float: left; width: 150px">
                                                <asp:Label ID="LabelForCOD" runat="server" AssociatedControlID="ddlCauseOfDeathType" Text="Cause of Death"
                                                    SkinID="DataLabel" >
                                                </asp:Label>
                                            </div>
                                            <div style="float: right;">
                                                <asp:DropDownList ID="ddlCauseOfDeathType" runat="server" RepeatDirection="Vertical" Width="170px"
                                                     DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" AppendDataBoundItems="true"
                                                    CssClass="" ValidationGroup="OnSave">
                                                    <asp:ListItem Text="Select Cause of Death" Value=""></asp:ListItem>
                                                </asp:DropDownList>
                                            </div>
                                        </div>
                                            </div>
                                    </div>
                                    <div style="float: left; width: 25%">
                                        <asp:Label ID="LabelForQAT" runat="server" AssociatedControlID="rblAssessmentType" Text="Assessment Type"
                                            SkinID="DataLabel" >
                                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                        <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                        <div class="questionstop">
                                            <asp:RadioButtonList ID="rblAssessmentType" runat="server" RepeatDirection="Vertical"
                                                 DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                ValidationGroup="OnSave">
                                            </asp:RadioButtonList>
                                        </div>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQAT" runat="server" ControlToValidate="rblAssessmentType"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assessment Type is required."></asp:RequiredFieldValidator>
                                    </div>
                                    <div style="float: left">
                                        <asp:Label ID="LabelForQIC" runat="server" AssociatedControlID="rblQIC" SkinID="DataLabel" Text="Interview Completed By"
                                            >
                                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                        <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                        <div class="questionstop">
                                            <asp:RadioButtonList ID="rblQIC" runat="server" RepeatDirection="Vertical" 
                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                ValidationGroup="OnSave">
                                            </asp:RadioButtonList>
                                        </div>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQIC" runat="server" ControlToValidate="rblQIC"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* 'Interview Completed By' is required."></asp:RequiredFieldValidator>
                                    </div>
                                </div>
                                <div>
                                    <!--Question 1: Race, as defined by patient (Tab Index start 160)-->
                                    1.
                        <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1"
                            >
                        </asp:Label><span class="requiredField" title="required"> *</span><div class="questionsmid">
                            <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" AutoPostBack="False"
                                 DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                CssClass="" ValidationGroup="OnSave" OnClick="ShowHideOtherDescription('ctl00_ContentPlaceHolder_pnlQ1OtherDescription', 'ctl00$ContentPlaceHolder$rblQ1', 
                                 'ctl00_ContentPlaceHolder_rblQ1_5', 'ctl00_ContentPlaceHolder_txtQ1Other', 'ctl00_ContentPlaceHolder_pnlQ1Error')">
                            </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1"
                                 ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 1: Race selection is required."></asp:RequiredFieldValidator><br />
                            <div class="msatOtherSec">
                                <asp:Panel ID="pnlQ1OtherDescription" runat="server">
                                    <asp:Label ID="LabelQ1OtherDescription" runat="server" AssociatedControlID="txtQ1Other"
                                        SkinID="DataLabel" >
                        Other Description:
                                    </asp:Label><asp:TextBox ID="txtQ1Other" runat="server"  MaxLength="25" /><span
                                        class="requiredField" title="required"> *</span>
                                    <asp:Label ID="txtQ1OtherSize" runat="server" Font-Italic="true" Font-Size="Smaller"
                                        >
                        &nbsp;&nbsp;(25 chars max)</asp:Label>
                                </asp:Panel>
                                <asp:Panel ID="pnlQ1Error" runat="server">
                                    <asp:Label ID="lblQ1Error" runat="server" Font-Bold="true" ForeColor="Red"  />
                                </asp:Panel>
                            </div>
                        </div>
                                </div>
                                <div>
                                    <!--Question 2: Ethnicity, as defined by patient (Tab Index start 210)-->
                                    2.
                        <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2"
                            >
                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 2: Ethnicity selection is required."></asp:RequiredFieldValidator>
                                    </div>
                                    <br />
                                </div>
                                <div>
                                    3.
                        <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel"
                            >
                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 3: Gender selection is required."></asp:RequiredFieldValidator>
                                    </div>
                                </div>
                            </div>
                        </telerik:RadPageView>
                        <telerik:RadPageView ID="rpvMSInformation" runat="server">
                            <div id="divMsInfo">
                                <div>
                                    <!--Question 4: Biological family history of Multiple Sclerosis? (Tab Index start 270)-->
                                    4.
                        <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel"
                            >
                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ4Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ4a',  
                        'ctl00_ContentPlaceHolder_pnlQ4aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ4', 
                                                       'ctl00_ContentPlaceHolder_rblQ4a', 'ctl00_ContentPlaceHolder_rblQ4_0','ctl00_ContentPlaceHolder_rblQ4_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ4UnknownComment', 'ctl00_ContentPlaceHolder_txtQ4aOther', 'ctl00_ContentPlaceHolder_pnlQ4Error')">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4"
                                            ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 4: Biological Family History of MS selection is required."></asp:RequiredFieldValidator><asp:Panel ID="pnlQ4Unknown" runat="server">
                                                <div style="padding: 5px; padding-left: 15px;">
                                                    <asp:Label ID="LabelQ4UnknownComment" runat="server" AssociatedControlID="txtQ4UnknownComment" SkinID="DataLabel" >
Comment:                                                </asp:Label><asp:TextBox ID="txtQ4UnknownComment" runat="server" MaxLength="25"  /><asp:Label ID="Label2" runat="server" Font-Italic="true" Font-Size="Smaller" >
(25 chars max)</asp:Label><br />
                                                </div>
                                            </asp:Panel>
                                        <!-- Unknown Comment Area -->
                                        <asp:Panel ID="pnlQ4a" runat="server">
                                            <div style="padding: 5px; padding-left: 15px;">
                                                <asp:CheckBoxList ID="rblQ4a" runat="server" CssClass="" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ4aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ4a', 
                                                                  'ctl00_ContentPlaceHolder_rblQ4a_6', 'ctl00_ContentPlaceHolder_txtQ4aOther', 'ctl00_ContentPlaceHolder_pnlQ4Error')"
                                                    RepeatDirection="Vertical"  ValidationGroup="OnSave">
                                                </asp:CheckBoxList><!-- Yes Other Comment Area --><!-- Other Text for Q4a --><asp:Panel ID="pnlQ4aOtherDescription" runat="server">
                                                    <asp:Label ID="LabelForQ4aOther" runat="server" AssociatedControlID="txtQ4aOther" SkinID="DataLabel" >
                            Other Description:
                                                    </asp:Label><asp:TextBox ID="txtQ4aOther" runat="server" MaxLength="75"  /><span title="required" class="requiredField"> *</span>
                                                    <asp:Label ID="Label1" runat="server" Font-Italic="true" Font-Size="Smaller" ForeColor="Black" >
(75 chars max)</asp:Label><br />
                                                </asp:Panel>
                                            </div>
                                        </asp:Panel>
                                        <asp:Panel ID="pnlQ4Error" runat="server">
                                            <asp:Label ID="lblQ4Error" runat="server" Font-Bold="true" ForeColor="Red"  />
                                        </asp:Panel>
                                    </div>
                                </div>
                                <div>
                                    5.
                        <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" >

                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                    <!--Question 5: Biological family history of Clinically Isolated Syndrome? (Tab Index start 380)-->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ5Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ5a',  
                        'ctl00_ContentPlaceHolder_pnlQ5aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ5', 
                                                       'ctl00_ContentPlaceHolder_rblQ5a', 'ctl00_ContentPlaceHolder_rblQ5_0','ctl00_ContentPlaceHolder_rblQ5_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ5UnknownComment', 'ctl00_ContentPlaceHolder_txtQ5aOther', 'ctl00_ContentPlaceHolder_pnlQ5Error')">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 5: Biological Family History of CIS selection is required."></asp:RequiredFieldValidator><asp:Panel ID="pnlQ5Unknown" runat="server">
                                                <div style="padding: 5px; padding-left: 15px;">
                                                    <asp:Label ID="LabelQ5UnknownComment" runat="server" AssociatedControlID="txtQ5UnknownComment" SkinID="DataLabel" >
                            Comment:
                                                    </asp:Label><asp:TextBox ID="txtQ5UnknownComment" runat="server" MaxLength="25"  /><asp:Label ID="Label3" runat="server" Font-Italic="true" Font-Size="Smaller" >
(25 chars max)</asp:Label><br />
                                                </div>
                                            </asp:Panel>
                                        <!-- Unknown Comment Area -->
                                        <asp:Panel ID="pnlQ5a" runat="server">
                                            <div style="padding: 5px; padding-left: 15px;">
                                                <asp:CheckBoxList ID="rblQ5a" runat="server" CssClass="" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ5aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ5a', 
                                                                  'ctl00_ContentPlaceHolder_rblQ5a_6', 'ctl00_ContentPlaceHolder_txtQ5aOther', 'ctl00_ContentPlaceHolder_pnlQ5Error')"
                                                    RepeatDirection="Vertical"  ValidationGroup="OnSave">
                                                </asp:CheckBoxList><!--Question 5a Required Validator--><asp:Label ID="rblQ5aError" runat="server" Font-Bold="true" ForeColor="Red"  Visible="false" /><!-- Yes Other Comment Area --><!-- Other Text for Q5a --><asp:Panel ID="pnlQ5aOtherDescription" runat="server">
                                                    <asp:Label ID="LabelForQ5aOther" runat="server" AssociatedControlID="txtQ5aOther" SkinID="DataLabel" >

                            Other Description:

                                                    </asp:Label><asp:TextBox ID="txtQ5aOther" runat="server" MaxLength="75"  /><span class="requiredField" title="required"> *</span>
                                                    <asp:Label ID="Label4" runat="server" Font-Italic="true" Font-Size="Smaller" ForeColor="Black" >
(75 chars max)</asp:Label><br />
                                                </asp:Panel>
                                            </div>
                                        </asp:Panel>
                                        <asp:Panel ID="pnlQ5Error" runat="server">
                                            <asp:Label ID="lblQ5Error" runat="server" Font-Bold="true" ForeColor="Red"  />
                                        </asp:Panel>
                                    </div>
                                </div>
                                <div>
                                    <!--Question 6: Biological family history of Neuromyelitis Optica/Devic's Disease? (Tab Index start 490)-->
                                    6.
                        <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel"
                            >

                        </asp:Label><span class="requiredField" title="required"> *</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ6Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ6a',  
                        'ctl00_ContentPlaceHolder_pnlQ6aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ6', 
                                                       'ctl00_ContentPlaceHolder_rblQ6a', 'ctl00_ContentPlaceHolder_rblQ6_0','ctl00_ContentPlaceHolder_rblQ6_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ6UnknownComment', 'ctl00_ContentPlaceHolder_txtQ6aOther', 'ctl00_ContentPlaceHolder_pnlQ6Error')">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 6: Biological Family History of NMO selection is required."></asp:RequiredFieldValidator><asp:Panel ID="pnlQ6Unknown" runat="server">
                                                <div style="padding: 5px; padding-left: 15px;">
                                                    <asp:Label ID="LabelQ6UnknownComment" runat="server" AssociatedControlID="txtQ6UnknownComment" SkinID="DataLabel" >

                            Comment:

                                                    </asp:Label><asp:TextBox ID="txtQ6UnknownComment" runat="server" MaxLength="25"  /><asp:Label ID="Label5" runat="server" Font-Italic="true" Font-Size="Smaller" >

                            &nbsp;&nbsp;(25 chars max)</asp:Label><br />
                                                </div>
                                            </asp:Panel>
                                        <!-- Unknown Comment Area -->
                                        <asp:Panel ID="pnlQ6a" runat="server">
                                            <div style="padding: 5px; padding-left: 15px;">
                                                <asp:CheckBoxList ID="rblQ6a" runat="server" CssClass="" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ6aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ6a','ctl00_ContentPlaceHolder_rblQ6a_6', 
                                                                    'ctl00_ContentPlaceHolder_txtQ6aOther', 'ctl00_ContentPlaceHolder_pnlQ6Error')"
                                                    RepeatDirection="Vertical"  ValidationGroup="OnSave">
                                                </asp:CheckBoxList><!-- Yes Other Comment Area --><!-- Other Text for Q6a --><asp:Panel ID="pnlQ6aOtherDescription" runat="server">
                                                    <div style="padding: 5px; padding-left: 15px;">
                                                        <asp:Label ID="LabelForQ6aOther" runat="server" AssociatedControlID="txtQ6aOther" SkinID="DataLabel" >
                                Other Description:

                                                        </asp:Label><asp:TextBox ID="txtQ6aOther" runat="server" MaxLength="75"  /><span class="requiredField" title="required">*</span>
                                                        <asp:Label ID="Label6" runat="server" Font-Italic="true" Font-Size="Smaller" ForeColor="Black" >
(75 chars max)</asp:Label><br />
                                                    </div>
                                                </asp:Panel>
                                            </div>
                                        </asp:Panel>
                                        <asp:Panel ID="pnlQ6Error" runat="server">
                                            <asp:Label ID="lblQ6Error" runat="server" Font-Bold="true" ForeColor="Red"  />
                                        </asp:Panel>
                                    </div>
                                </div>
                                <div>
                                    <!--Question 7: Diagnosis History (Tab Index start 600)-->
                                    7.
                        <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel"
                            >

                        </asp:Label><span class="requiredField" title="required">*</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideQuestion7()">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 7: Diagnosis History selection is required."></asp:RequiredFieldValidator><asp:Panel ID="pnlQ7MS" runat="server">

                                                <div style="padding-left: 25px;">
                                                    <MSSR:MonthYearSelector ID="mysQ7MSDateFirst" runat="server" />
                                                    <asp:Panel ID="pnlQ7MSDateFirstError" runat="server">
                                                        <asp:Label ID="lblQ7MSDateFirstError" runat="server" Font-Bold="true" ForeColor="Red"  />
                                                    </asp:Panel>

                                                    <MSSR:MonthYearSelector ID="mysQ7MSDateDx" runat="server" />
                                                </div>
                                            </asp:Panel>
                                        <!-- 7MS sub questions -->
                                        <asp:Panel ID="pnlQ7CIS" runat="server">

                                            <div style="padding-left: 25px;">
                                                <MSSR:MonthYearSelector ID="mysQ7CISDateFirst" runat="server"></MSSR:MonthYearSelector>
                                                <asp:Panel ID="pnlQ7CISDateFirstError" runat="server">
                                                    <asp:Label ID="lblQ7CISDateFirstError" runat="server" Font-Bold="true" ForeColor="Red"
                                                         />
                                                </asp:Panel>
                                            </div>
                                        </asp:Panel>
                                        <asp:Panel ID="pnlQ7RIS" runat="server">

                                            <div style="padding-left: 25px;">
                                                <MSSR:MonthYearSelector ID="mysQ7RISDateFirst" runat="server" />
                                            </div>
                                        </asp:Panel>
                                        <!-- 7CIS sub questions -->
                                        <asp:Panel ID="pnlQ7NMO" runat="server">

                                            <div style="padding: 5px; padding-left: 25px;">
                                                <MSSR:MonthYearSelector ID="mysQ7NMODateFirst" runat="server"></MSSR:MonthYearSelector>
                                                <asp:Panel ID="pnlQ7NMODateFirstError" runat="server">
                                                    <asp:Label ID="lblQ7NMODateFirstError" runat="server" Font-Bold="true" ForeColor="Red"
                                                         />
                                                </asp:Panel>
                                                <MSSR:MonthYearSelector ID="mysQ7NMODx" runat="server" />

                                            </div>
                                        </asp:Panel>
                                        <asp:Panel ID="pnlQ7NOMS" runat="server">

                                            <div style="padding: 5px; padding-left: 25px;">
                                                <asp:Label ID="LabelForQ7NOMS" runat="server" AssociatedControlID="txtQ7NOMS" SkinID="DataLabel" >
                                                </asp:Label><br />
                                                <asp:TextBox ID="txtQ7NOMS" runat="server"  /><span class="requiredField" title="required">*</span>
                                                <asp:Label ID="Label7" runat="server" Font-Italic="true" Font-Size="Smaller" >
(25 chars max)</asp:Label><!--Question Q7NOMS Required Validator--><asp:Panel ID="pnlQ7NOMSError" runat="server">
    <asp:Label ID="lblQ7NOMSError" runat="server" Font-Bold="true" ForeColor="Red"  />
                                                </asp:Panel>
                                            </div>
                                        </asp:Panel>
                                    </div>
                                </div>
                                <div>
                                    <!--Question 8: Type of initial MS/NMO symptom (check all that apply) (Tab Index start 760)-->
                                    8.
                        <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="cblQ8" SkinID="DataLabel"
                            >

                        </asp:Label><span class="requiredField" title="required">*</span>
                                    <br />
                                    <!-- Question 8 Choice List -->
                                    <div class="questionsmid">
                                        <asp:CheckBoxList ID="cblQ8" runat="server" RepeatColumns="3" Width="600px" DataTextField="CHOICE_TEXT"
                                            DataValueField="STD_QUESTION_CHOICE_ID" >
                                        </asp:CheckBoxList><asp:Label ID="lblQ8Error" runat="server" Font-Bold="true" ForeColor="Red" Visible="false"
                                             />
                                    </div>
                                </div>
                                <div>
                                    <!--Question 9: Multiple Sclerosis Subtype (Tab Index start 790)-->
                                    9.
                        <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel"
                            >
                        </asp:Label><span class="requiredField" title="required">*</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideQuestion9()">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 9: MS Subtype selection is required."></asp:RequiredFieldValidator><asp:Panel ID="pnlQ9DateTran" runat="server">
                                                <br />
                                                <div style="padding: 5px; padding-left: 25px;">
                                                    <MSSR:MonthYearSelector ID="mysQ9DateTran" runat="server"></MSSR:MonthYearSelector>
                                                    <asp:Panel ID="pnlQ9DateTranError" runat="server">
                                                        <asp:Label ID="lblQ9DateTranError" runat="server" Font-Bold="true" ForeColor="Red"
                                                             />
                                                    </asp:Panel>
                                                </div>
                                            </asp:Panel>
                                    </div>
                                </div>
                                <div>
                                    <!--Question 10: MS Service-Connection Status (Tab Index start 850)-->
                                    10.
                        <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel"
                            >
                        </asp:Label><span class="requiredField" title="required">*</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10"
                                             ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 10: Service Connected Status selection is required."></asp:RequiredFieldValidator>
                                    </div>
                                    <br />
                                </div>
                                <div>
                                    <!--Question 11: Current MS or NMO Disability (Tab Index start 880)-->
                                    11.
                        <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel"
                            >
                        </asp:Label><span class="requiredField" title="required">*</span><br />
                                    <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                    <div class="questionsmid">
                                        <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Vertical" 
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                            ValidationGroup="OnSave" OnClick="ShowHideQuestion11()">
                                        </asp:RadioButtonList><asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11"
                                            ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 11: 'Current MS or NMO Disability' is required"></asp:RequiredFieldValidator><asp:Panel ID="pnlQ11_6A" runat="server">
                                                <br />
                                                <div style="padding: 5px; padding-left: 25px;">
                                                    <asp:Label ID="LabelForQ11_6A" runat="server" AssociatedControlID="mysQ11_6A" SkinID="DataLabel"  /><br />
                                                    <MSSR:MonthYearSelector ID="mysQ11_6A" runat="server" />
                                                </div>
                                            </asp:Panel>
                                        <!-- Question 11_6A -->
                                        <asp:Panel ID="pnlQ11_8" runat="server">
                                            <br />
                                            <div style="padding: 5px; padding-left: 25px;">
                                                <asp:Label ID="LabelForQ11_8" runat="server" AssociatedControlID="mysQ11_8" SkinID="DataLabel"
                                                    >
                                                </asp:Label><br />
                                                <MSSR:MonthYearSelector ID="mysQ11_8" runat="server"></MSSR:MonthYearSelector>
                                            </div>
                                        </asp:Panel>
                                        <br />
                                    </div>
                                </div>
                                <div>
                                    <!--Question 12: Number of relapses* over the past twelve months (Tab Index start 950)-->
                                    12.
                        <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="txtQ12" SkinID="DataLabel"
                            >

                        </asp:Label><span class="requiredField" title="required">*</span><br />
                                    &nbsp;
                        <div class="questionsmid">
                            <asp:TextBox ID="txtQ12" runat="server" MaxLength="4" Width="50px" 
                                Text="0"></asp:TextBox>&nbsp;*relapse = worsening neurological symptoms for &gt; 24hrs that stabilize or resolve
                            
                           
                                <MSSR:MonthYearSelector ID="mysQ12A" runat="server"></MSSR:MonthYearSelector>
                        
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorTrial1Time" runat="server"
                                ControlToValidate="txtQ12" ValidationGroup="OnSave"  Display="Dynamic"
                                ErrorMessage="* Question 12: Number of relapses entry is required."></asp:RequiredFieldValidator><asp:RangeValidator ID="rvtxtQ12" runat="server" ControlToValidate="txtQ12" ErrorMessage="Question 12: Number of relapses must be greater than or equal to 0"
                                     MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave"
                                    Type="Integer" Display="Dynamic">
                                </asp:RangeValidator><br />
                        </div>
                                    <br />
                                </div>
                            </div>
                        </telerik:RadPageView>
                        <telerik:RadPageView ID="rpvListMedContent" runat="server">
                            <div class="divMedInfo">
                                <telerik:RadGrid ID="rdgListOfMedsPerSurvey" runat="server" CssClass="medstab" AllowPaging="True" AllowSorting="True" grouppanelposition="Top" OnItemCommand="imgBtnUpdateMedications_Command"
                                    AllowMultiRowSelection="false" PageSize="20">
                                    <SelectedItemStyle BackColor="#FFE1A4"></SelectedItemStyle>
                                    <MasterTableView Caption="Regular Medications" DataKeyNames="MedicationName, HealthFactor, ID, PatientMedId" AutoGenerateColumns="false" PagerStyle-AlwaysVisible="true" >
                                        <NoRecordsTemplate>
                                            <table>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="Label5" runat="server">
                                No Medication avialable for this Survey.
                                                        </asp:Label></td>
                                                </tr>
                                            </table>
                                        </NoRecordsTemplate>
                                        <Columns>
                                            <telerik:GridButtonColumn CommandName="Select" Text="Select" Visible="False" UniqueName="Select"></telerik:GridButtonColumn>
                                            <telerik:GridTemplateColumn HeaderText="Update Medication">
                                                <ItemTemplate>
                                                    <asp:ImageButton ID="imgBtnUpdateMedication" CommandName="Select" AlternateText="Update button..."
                                                        ToolTip="Click to Update Medication." ImageUrl="~/images/EditTableHS.png"
                                                        runat="server" />
                                                </ItemTemplate>
                                            </telerik:GridTemplateColumn>
                                            <telerik:GridTemplateColumn HeaderText="Delete Medication">
                                                <ItemTemplate>
                                                    <asp:ImageButton ID="imgBtnRemoveMedication" CommandName="DELETE" AlternateText="Remove Medication" OnClientClick=" return confirm('Deleting medication - Please confirm.')"
                                                        ToolTip="Click to Remove Medication." ImageUrl="~/images/DeleteHS.png"
                                                        runat="server" />
                                                </ItemTemplate>
                                            </telerik:GridTemplateColumn>
                                            <telerik:GridBoundColumn DataField="MedicationName" DataType="System.String"
                                                HeaderText="Med Name" ReadOnly="True" SortExpression="MedicationName" />
                                            <telerik:GridBoundColumn DataField="PastUseCurrentUse" DataType="System.String"
                                                HeaderText="Current Use / Past Use" />
                                            <telerik:GridBoundColumn DataField="DispensingPharmacy" DataType="System.String"
                                                HeaderText="Dispensing Pharmacy" ReadOnly="True" />
                                            <telerik:GridBoundColumn DataField="ID" DataType="System.Int32" Visible="false"
                                                HeaderText="ID" />
                                            <telerik:GridBoundColumn DataField="HealthFactor" DataType="System.String"
                                                HeaderText="Health Factor" />
                                            <telerik:GridBoundColumn DataField="PatientMedId" DataType="System.Guid" Visible="False" />
                                        </Columns>
                                    </MasterTableView><ClientSettings></ClientSettings>
                                </telerik:RadGrid>
                                <div class="msatMedSec">
                                    <asp:Panel runat="server" ID="pnlMedSecAddMed">
                                        <div style="padding-left: 10px">
                                            <label style="font: inherit">Medications: </label>
                                            <telerik:RadComboBox runat="server" ID="rdcListOfRegMedications" Width="300px" DataValueField="ID" DataTextField="Medication" AppendDataBoundItems="True"
                                                ToolTip="Select List Of Regular Medication" EmptyMessage="-- Select Medicaton --">
                                                <KeyboardNavigationSettings CommandKey="Alt" FocusKey="K" ></KeyboardNavigationSettings>
                                                <Items>
                                                
                                                    </Items>
                                            </telerik:RadComboBox>
                                            <telerik:RadButton ID="rdButtonAddMeds" runat="server" Text="Add" ToolTip="" OnClick="rdButtonAddMeds_Click" ValidationGroup="OnMedAdd"
                                                 />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="rdcListOfRegMedications" ValidationGroup="OnMedAdd" ErrorMessage="* Select Medication." />
                                        </div>
                                    </asp:Panel>
                                    <div class="msatMeds">
                                        <asp:Panel runat="server" ID="pnlMedicationSection">
                                            <MSSR:MedicationSelection ID="MedicationSelection1" runat="server" />
                                            <div style="padding-left: 10px">
                                                <telerik:RadButton runat="server" ID="rdbUpdateMedication" CausesValidation="true" ValidationGroup="OnMedAddUpdate" Text="Update" Enabled="false" OnClick="rdbUpdateMedication_UpdateMedication"></telerik:RadButton>
                                                <telerik:RadButton runat="server" ID="rdbAddMedication" Text="Add" CausesValidation="true" ValidationGroup="OnMedAddUpdate" Enabled="false" OnClick="rdbAddMedication_Click"></telerik:RadButton>
                                            </div>
                                        </asp:Panel>
                                    </div>
                                </div>
                            </div>
                        </telerik:RadPageView>
                        <telerik:RadPageView ID="rpvCorticosteroidMedContent" runat="server">
                            <div class="corticotab">
                                <MSSR:CorticosteroidsMedicationSelection ID="ctrlCorticosteroidsSelection" StartTabIndex="3000"
                                    runat="server" />
                            </div>
                        </telerik:RadPageView>
                        <telerik:RadPageView runat="server" ID="rpvInterferonGroup">
                            <div id="divIntrf">
                                <div style="padding-left: 10px; padding-top: 10px">
                                    <div style="padding-left: 10px">
                                        <asp:Label ID="LabelForQIG" runat="server" AssociatedControlID="rblQIG" Font-Bold="True"
                                            SkinID="DataLabel" >
                                        </asp:Label>
                                        <br />
                                        <div>
                                            <div style="float: left; width: 30%; padding-left: 10px; font-weight: normal">
                                                <asp:RadioButtonList ID="rblQIG" runat="server" RepeatDirection="Vertical" 
                                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="msatInt"
                                                    ValidationGroup="OnSave" OnClick="ShowHideQuestionQIG()">
                                                </asp:RadioButtonList>
                                            </div>
                                        </div>
                                        <!--Question IG Object Data Source-->
                                        <asp:ObjectDataSource ID="ObjectDataSourceQIG" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                            TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode"
                                                    Type="String" />
                                                <asp:ControlParameter ControlID="HiddenQIG" Direction="Input" Name="questionNumber"
                                                    Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                    </div>
                                    <!--Question IG : Question Number-->
                                    <asp:HiddenField ID="HiddenQIG" runat="server" Visible="false" Value="IG" />
                                    <br />
                                    <!-- Positive Date Text for QIG -->
                                    <div style="clear: left"></div>
                                    <asp:Panel ID="pnlQIDPositive" runat="server">
                                        <div style="padding-left: 35px; padding-top: 5px">
                                            <MSSR:MonthYearSelector ID="mysQIDPositive" runat="server"></MSSR:MonthYearSelector>
                                        </div>
                                        <br />
                                    </asp:Panel>
                                    <!-- Negative Date Text for QIG -->
                                    <asp:Panel ID="pnlQIDNegative" runat="server">
                                        <div style="padding: 5px; padding-left: 35px;">
                                            <MSSR:MonthYearSelector ID="mysQIDNegative" runat="server"></MSSR:MonthYearSelector>
                                        </div>
                                        <br />
                                    </asp:Panel>
                                    <!-- SJC -->
                                    <asp:Panel ID="pnlSJC" runat="server" Style="margin-left: 10px; padding-top: 10px">
                                        <asp:Label ID="LabelForQSJC" runat="server" AssociatedControlID="rblQSJC" Font-Bold="True" SkinID="DataLabel">
                                        </asp:Label>
                                        <br />
                                        <div style="padding-left: 10px;">
                                            <asp:RadioButtonList ID="rblQSJC" runat="server" RepeatDirection="Vertical" Font-Bold="False"
                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="msatInt"
                                                ValidationGroup="OnSave" OnClick="ShowHideQuestionQSJC()">
                                            </asp:RadioButtonList>
                                        </div>
                                        <!--Question SJC Object Data Source-->
                                        <asp:ObjectDataSource ID="ObjectDataSourceQSJC" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                            TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode"
                                                    Type="String" />
                                                <asp:ControlParameter ControlID="HiddenQSJC" Direction="Input" Name="questionNumber"
                                                    Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <!--Question SJC : Question Number-->
                                        <asp:HiddenField ID="HiddenQSJC" runat="server" Visible="false" Value="SJC" />
                                        <br />
                                        <!-- Positive Date Text for QSJC -->
                                        <asp:Panel ID="pnlQSJCPositive" runat="server">
                                            <div style="padding: 5px; padding-left: 25px;">
                                                <MSSR:MonthYearSelector ID="mysQSJCPositive" runat="server"></MSSR:MonthYearSelector>
                                            </div>
                                            <br />
                                        </asp:Panel>
                                        <!-- Negative Date Text for QSJC -->
                                        <asp:Panel ID="pnlQSJCNegative" runat="server">
                                            <div style="padding: 5px; padding-left: 25px;">
                                                <MSSR:MonthYearSelector ID="mysQSJCNegative" runat="server"></MSSR:MonthYearSelector>
                                            </div>
                                            <br />
                                        </asp:Panel>
                                    </asp:Panel>
                                    <!-- SJC End -->
                                </div>
                            </div>
                        </telerik:RadPageView>
                    </telerik:RadMultiPage>
                </asp:Panel>
            </div>
            <asp:Panel runat="server" ID="pnlNoteAndHFSection">
                <fieldset>
                    <legend>Survey Notes</legend>
                    <div class="divNotesHF">
                        <asp:TextBox ID="txtNotePreview" runat="server" BackColor="#FFF0DF" TextMode="MultiLine" ReadOnly="true"
                            Rows="6" Width="100%" ></asp:TextBox>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Health Factors</legend>
                    <div class="divNotesHF">
                        <asp:TextBox ID="txtHealthFactors" runat="server" TextMode="MultiLine" BackColor="#FFF0DF" ReadOnly="true"
                            Rows="6" Width="100%" ></asp:TextBox>
                    </div>
                </fieldset>
            </asp:Panel>
            <div style="background-color: #DAE2E8; width: 100%; height: 60px">
                <div style="padding-left: 30px; padding-top: 10px">
                    <asp:Button runat="server" ID="rdButtonProcessAssessment" Enabled="False" CausesValidation="true" OnClick="btnUpdateNotePreview_Click" ValidationGroup="OnSave" CssClass="msatBtn" Height="40px" Text="Process Notes and Health Factors"></asp:Button>
                    <asp:Button runat="server" ID="rdButtonUpdateSurvey" Enabled="False" CausesValidation="true" OnClick="rdButtonUpdateSurvey_OnClick" ValidationGroup="OnSave" CssClass="msatBtn" Width="100px" Height="40px" Text="Create Survey"></asp:Button>

                </div>
            </div>
        </div>
        <telerik:RadAjaxLoadingPanel ID="radAjxLoadingPanelSurveyEdit" runat="server"></telerik:RadAjaxLoadingPanel>
    </telerik:RadAjaxPanel>
    <telerik:RadCodeBlock runat="server" ID="rcb122">
        <script type="text/javascript" src="../scripts/msatedit.js"></script>
    </telerik:RadCodeBlock>
</asp:Content>




