﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="Assessments.aspx.cs" Inherits="Assessments" Title="MSSR: Assessments" %>

<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .filterPanel
        {
            width: 99%;
            border: 2px solid #333333;
            background-color: #F7F7F7;
        }
        /*
        .filterPanel td 
        {
        	padding-bottom:7px;
        }
        */</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <%--<asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <Triggers>
            <asp:PostBackTrigger ControlID="imgBtnExportToExcel" />
        </Triggers>
        <ContentTemplate>
            <asp:UpdateProgress ID="UpdateProgress1" runat="server">
                <ProgressTemplate>
                    <div style="padding: 5px;">
                        <img src="images/ajax-loader.gif" alt="Loading Image" />
                        Loading, Please Wait ...
                    </div>
                </ProgressTemplate>
            </asp:UpdateProgress>--%>
            <!-- Hidden Variables for Paging -->
            <asp:HiddenField ID="HiddenFieldCurrentPageNumber" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldPageCount" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldTotalRecords" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldSortExpression" runat="server" Value="" Visible="false" />
            <asp:HiddenField ID="HiddenFieldSortDirection" runat="server" Value="" Visible="false" />
            <div class="excludeSaveWarnings" style="background-color: #333333; color: #FFFFFF; width: 99%; font-size: 10.5pt;
                font-weight: bold; border: 2px solid #333333; border-bottom: 1px solid #333333;">
                &nbsp; Filters
                <asp:Button ID="lnkBtnToggleFilters" runat="server" Text="Hide" ToolTip="Click to show/hide filters."
                    OnClick="lnkBtnToggleFilters_OnClick" TabIndex="101" />
            </div>
            <asp:Panel ID="pnlFilterArea" runat="server" CssClass="filterPanel">
                <div class="excludeSaveWarnings">
                <table style="width: 100%; padding: 5px;">
                    <tr>
                        <td style="width: 33%;">
                            <asp:Label ID="LabelForPatientName" runat="server" AssociatedControlID="txtPatientName" TabIndex="102" CssClass="FilterLabel">
                                Patient Name
                            </asp:Label>:
                            <br />
                            <asp:TextBox ID="txtPatientName" runat="server" ToolTip="Enter patient name" TabIndex="103"></asp:TextBox>
                        </td>
                        <td style="width: 33%;">
                            <asp:Label ID="LabelForPatientICN" runat="server" AssociatedControlID="txtPatientICN" TabIndex="104" CssClass="FilterLabel">
                                Patient ICN
                            </asp:Label>:
                            <br />
                            <asp:TextBox ID="txtPatientICN" runat="server" ToolTip="Enter Patient ICN" TabIndex="105"></asp:TextBox>
                        </td>
                        <td style="width: 33%;">
                            <asp:Label ID="LabelForLocation" runat="server" AssociatedControlID="ddlFacility" TabIndex="106" CssClass="FilterLabel">
                                Location
                            </asp:Label>:
                            <br />
                            <asp:DropDownList ID="ddlFacility" runat="server" TabIndex="107" ToolTip="Location or Facility selection">
                            </asp:DropDownList>
                            <br />
                            <asp:Label ID="lblFacFiltered" Visible="false" runat="server" Font-Size="XX-Small"
                                Text="(Facility list has been filtered based on your role.)" TabIndex="108"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelForDiagnosis" runat="server" AssociatedControlID="ddlDiagnosis" TabIndex="109" CssClass="FilterLabel">
                                Diagnosis
                            </asp:Label>:
                            <br />
                            <asp:DropDownList ID="ddlDiagnosis" runat="server" TabIndex="110" ToolTip="Diagnosis selection" CssClass="FilterNormalText">
                                <asp:ListItem Selected="True" Value="All">Any Diagnosis</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="MS">Multiple Sclerosis</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="RRMS">Relapsing-Remitting MS</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="SPMS">Secondary Progressive MS</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="PPMS">Primary Progressive MS</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="PRMS">Progressive-Relapsing MS</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="POSSIBLE MS">Possible MS</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="CIS">Clinically Isolated Syndrome</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="NMO">Neuromyelitis (NMO)</asp:ListItem>
                                <asp:ListItem Enabled="True" Value="NOT MS">Determined NOT to have MS</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td>
                            <asp:Label ID="LabelForEdmusScore" runat="server" AssociatedControlID="ddlCurrentEdmusScore" TabIndex="111" CssClass="FilterLabel">
                                EDMUS Score
                            </asp:Label>
                            :<br />
                            <asp:DropDownList ID="ddlCurrentEdmusScore" runat="server" TabIndex="112" ToolTip="Current EDMUS Score" CssClass="FilterNormalText">
                                <asp:ListItem Value="All">All</asp:ListItem>
                                <asp:ListItem Value="1">1</asp:ListItem>
                                <asp:ListItem Value="2">2</asp:ListItem>
                                <asp:ListItem Value="3">3</asp:ListItem>
                                <asp:ListItem Value="4">4</asp:ListItem>
                                <asp:ListItem Value="5">5</asp:ListItem>
                                <asp:ListItem Value="6a">6a</asp:ListItem>
                                <asp:ListItem Value="6b">6b</asp:ListItem>
                                <asp:ListItem Value="7">7</asp:ListItem>
                                <asp:ListItem Value="8">8</asp:ListItem>
                                <asp:ListItem Value="9">9</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td>
                            <asp:Label ID="LabelForInterviewCompletedBy" runat="server" AssociatedControlID="ddlInterviewCompletedBy" TabIndex="113" CssClass="FilterLabel">
                                Interview Completed by
                            </asp:Label>
                            :<br />
                            <asp:DropDownList ID="ddlInterviewCompletedBy" runat="server" TabIndex="114" ToolTip="Interview Completed by selection" CssClass="FilterNormalText">
                                <asp:ListItem Value="All">All</asp:ListItem>
                                <asp:ListItem Value="1">Telephone</asp:ListItem>
                                <asp:ListItem Value="2">Clinical Video Teleconferencing</asp:ListItem>
                                <asp:ListItem Value="3">In-person Assessment</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelForRelapses" runat="server" AssociatedControlID="rblRelapses" TabIndex="115" CssClass="FilterLabel">
                                Reported relapses
                            </asp:Label>
                            :<br />
                            <asp:RadioButtonList ID="rblRelapses" runat="server" CssClass="FilterNormalText" RepeatDirection="Horizontal"
                                TabIndex="116" ToolTip="Number of Reported Relapses selection">
                                <asp:ListItem Selected="true" Value="All">Any Number</asp:ListItem>
                                <asp:ListItem Value="0">0</asp:ListItem>
                                <asp:ListItem Value="1">1</asp:ListItem>
                                <asp:ListItem Value="2">>1</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                        <td>
                        </td>
                        <td>
                        </td>
                    </tr>
                </table>
             
                <table style="width: 100%; padding: 5px;">
                    <tr>
                        <td colspan="100%">
                            <asp:Button ID="btnGo" Height="25px" runat="server" Text="View Results" Enabled="true"
                                OnClick="btnGo_Click" ToolTip="View Results" TabIndex="120" />
                            <asp:Button ID="btnClear" Height="25px" runat="server" Text="Reset" Enabled="true"
                                OnClick="btnClear_Click" ToolTip="Clear Filters" TabIndex="121" />
                        </td>
                    </tr>
                </table>
                </div>
            </asp:Panel>
            <br />
            <!-- Assessment Grid -->
            <asp:GridView ID="grdMSAssessments" CellPadding="5" Width="99.5%"  Caption="List of Assessments."
                EmptyDataText="Currently, showing no data. Please select filters from above and click the 'View Results' button."
                AllowSorting="true" OnSorting="grdMSAssessments_Sorting" runat="server" Height="2px"
                Font-Size="Smaller" BorderWidth="2" BorderStyle="Solid" BorderColor="#CCCCCC"
                OnRowDataBound="grdMSAssessments_RowDataBound" OnRowCreated="grdMSAssessments_RowCreated"
                
                AutoGenerateColumns="false" ageSize="10" TabIndex="122">
                <HeaderStyle CssClass="FrozenHeader" />
                <AlternatingRowStyle BackColor="#F4F4F4" />
                <Columns>
                   <asp:TemplateField HeaderText="Name" SortExpression="PatientName" AccessibleHeaderText="Patient Name">
                        <ItemTemplate>
                            <a href="PatientDetails.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see patient details">
                                <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientName")))%></a>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="PatientICN" HeaderText="PatientICN" SortExpression="PatientICN"
                        AccessibleHeaderText="PatientICN" />
                    <asp:BoundField DataField="Sta3n" HeaderText="Facility" SortExpression="Sta3n" AccessibleHeaderText="Facility Name" />
                    <asp:BoundField DataField="AssessmentDateTime" HeaderText="AssessmentDateTime" SortExpression="AssessmentDateTime"
                        AccessibleHeaderText="AssessmentDateTime" />
                    <asp:BoundField DataField="AssessmentType" HeaderText="AssessmentType" SortExpression="AssessmentType"
                        AccessibleHeaderText="AssessmentType" />
                    <asp:BoundField DataField="CurrentDisabilityScore" HeaderText="CurrentDisabilityScore"
                        SortExpression="CurrentDisabilityScore" AccessibleHeaderText="CurrentDisabilityScore" />
                    <asp:BoundField DataField="MSDiagnosis" HeaderText="MSDiagnosis" SortExpression="MSDiagnosis"
                        AccessibleHeaderText="MSDiagnosis" />
                    <asp:BoundField DataField="DiagnosisYear" HeaderText="DiagnosisYear" SortExpression="DiagnosisYear"
                        AccessibleHeaderText="DiagnosisYear" />
                    <asp:BoundField DataField="SymptomYear" HeaderText="SymptomYear" SortExpression="SymptomYear"
                        AccessibleHeaderText="SymptomYear" />
                    <asp:BoundField DataField="Ethnicity" HeaderText="Ethnicity" SortExpression="Ethnicity"
                        AccessibleHeaderText="Ethnicity" />
                    <asp:BoundField DataField="Race" HeaderText="Race" SortExpression="Race" AccessibleHeaderText="Race" />
                    <asp:BoundField DataField="MSInterview" HeaderText="MSInterview" SortExpression="MSInterview"
                        AccessibleHeaderText="MSInterview" />
                    <asp:BoundField DataField="Relapses" HeaderText="Relapses" SortExpression="Relapses"
                        AccessibleHeaderText="Relapses" />
                    <asp:BoundField DataField="MSSC" HeaderText="MSSC" SortExpression="MSSC" AccessibleHeaderText="MSSC" />
                    <asp:BoundField DataField="MSSubType" HeaderText="MSSubType" SortExpression="MSSubType"
                        AccessibleHeaderText="MSSubType" />
                    <%--<asp:BoundField DataField="CurrentMedications" HeaderText="Current Meds" AccessibleHeaderText="Current Meds" SortExpression="CurrentMedications" />--%>
                </Columns>
            </asp:GridView>
            <br />
            <asp:Panel ID="pnlPagingControls" runat="server">
                <div class="excludeSaveWarnings">
                    <table>
                        <tr>
                            <td style="vertical-align:middle;">
                                <asp:Button ID="btnFirstPage" runat="server" Text="<<" ToolTip="First Page of Results"
                                    OnClick="btnFirstPage_Click" TabIndex="1000" />
                                <asp:Button ID="btnPrevPage" runat="server" Text="<" ToolTip="Previous Page of Results"
                                    OnClick="btnPrevPage_Click" TabIndex="1001" />
                                <asp:Button ID="btnNextPage" runat="server" Text=">" ToolTip="Next Page of Results"
                                    OnClick="btnNextPage_Click" TabIndex="1002" />
                                <asp:Button ID="btnLastPage" runat="server" Text=">>" ToolTip="Last Page of Results"
                                    OnClick="btnLastPage_Click" TabIndex="1003" />
                                <asp:Label ID="lblPageStatus" runat="server" TabIndex="1004" />
                            </td>
                            <td style="width:15px; font-size:1px;">
                                &nbsp;
                            </td>
                            <td style="vertical-align:middle;">
                                <asp:Label ID="LabelForResultsPerPage" runat="server" AssociatedControlID="ddlPageSize" TabIndex="1005">
                                    Results per page
                                </asp:Label>:
                                <asp:DropDownList runat="server" ID="ddlPageSize" AutoPostBack="true" TabIndex="1006">
                                    <asp:ListItem Text="10" Value="10"></asp:ListItem>
                                    <asp:ListItem Text="25" Value="25"></asp:ListItem>
                                    <asp:ListItem Text="50" Value="50"></asp:ListItem>
                                    <asp:ListItem Text="100" Value="100"></asp:ListItem>
                                    <asp:ListItem Text="All" Value="-1"></asp:ListItem>
                                </asp:DropDownList>
                            </td>
                            <td style="width:15px; font-size:1px;">
                                &nbsp;
                            </td>
                            <td style="vertical-align:middle;">
                                <asp:ImageButton ID="imgBtnExportToExcel" runat="server" AlternateText="Export Grid to Excel" TabIndex="1007"
                                    ToolTip="Export Grid to Excel" ImageUrl="~/images/export-icon.gif" onclick="imgBtnExportToExcel_Click" />
                            </td>
                        </tr>
                    </table>    
                </div>
            </asp:Panel>
            
            <br />
            <asp:Panel ID="pnlRecordCount" runat="server" Visible="false">
                <asp:Label ID="LabelForRecordCount" runat="server" AssociatedControlID="lblRecordCount" TabIndex="1008">
                    Record Total
                </asp:Label>:
                <asp:Label ID="lblRecordCount" runat="server" Text="lblRecordCount" TabIndex="1009"
                    ToolTip="Record Count in Search Results"></asp:Label>
            </asp:Panel>
        <%--</ContentTemplate>
    </asp:UpdatePanel>--%>
</asp:Content>