﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

/// <summary>
/// Summary description for MSSRPatientManager
/// </summary>
public class MSSRPatientManager {

    public MSSRPatientManager() {
    }

    /// <summary>
    /// DoesPatientExist: Accepts a PatientICN and returns true/false if patient exists in MSSR_PATIENT_DEMS table.
    /// </summary>
    /// <param name="patientIcn"></param>
    /// <returns></returns>
    public static bool DoesPatientExist(int patientIcn) {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
            if (ctx.MSSR_PATIENT_DEMs.Count(P => P.PatientICN == patientIcn) > 0) {
                return true;
            }

            return false;
        }
    }

    /// <summary>
    /// GetPatientByPatientICN: returns the full MSSR_PATIENT_DEM object for the patient with the passed ICN
    /// </summary>
    /// <param name="patientIcn"></param>
    /// <returns></returns>
    public static MSSR_PATIENT_DEM GetPatientByPatientICN(int patientIcn) {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
            return ctx.MSSR_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == patientIcn);
        }
    }

    /// <summary>
    /// InsertPatientDem: If patient doesn't exist, insert into MSSR_PATIENT_DEM table.
    /// </summary>
    /// <param name="patient"></param>
    public static void InsertPatientDem(MSSR_PATIENT_DEM patient) {
        try {
            if (patient != null) {
                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
                    ctx.MSSR_PATIENT_DEMs.InsertOnSubmit(patient);
                    ctx.SubmitChanges();
                }
            }
        } catch (Exception ex) {

            Logging.WriteLogToFile("Failure in InsertPatientDem: " + ex.Message);

            // TODO: Log error ... 
            //Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "processAssessment() - Question HF");
        }
    }
}