﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace MSSREnh
{
    /// <summary>
    /// Summary description for SurveyViewManager
    /// </summary>
    public class SurveyViewManager : BaseViewManager
    {
        public SurveyViewManager(UserAccountManager currentUser)
            : base(currentUser) { }
        public SurveyViewModel GetSurveyViewModel(string patientIcn, int surveyId)
        {
            IEnumerable<GetSurveyResultsBySurveyID_Result>  surveyResults = DataAccessManager.GetSurveyResultBySurveyIDandPatientIcn(surveyId, patientIcn);
            SURVEY survey = DataAccessManager.GetSurveyBySurveyId(patientIcn, surveyId);
            IEnumerable<GetMedicationsUsedBySurveyAndPatientICN_Result> listOfMeds = DataAccessManager.GetListOfMedicationsForSurvey(patientIcn, surveyId);

            return new SurveyViewModel()
            {
                SurveyResults = surveyResults.Select(MapToSurveyResult),
                Survey = survey,
                ListOfMeds = listOfMeds.Select(MapToSurveySummary)    
            };
        }

        public SurveyViewModel GetInprocessSurveyViewModel(string patientIcn, int surveyId)
        {
            IEnumerable<GetSurveyResultsBySurveyID_Result> surveyResults = DataAccessManager.GetSurveyResultBySurveyIDandPatientIcn(surveyId, patientIcn);
            SURVEY survey = DataAccessManager.GetInprocessSurveyBySurveyId(patientIcn, surveyId);
            IEnumerable<GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result> listOfMeds = DataAccessManager.GetListOfMedicationsForCreateSurvey(patientIcn, surveyId);

            return new SurveyViewModel()
            {
                SurveyResults = surveyResults.Select(MapToSurveyResult),
                Survey = survey,
                ListOfMeds = listOfMeds.Select(MapToSurveySummary)
            };
        }

        public GetInprocessSurvey_Result GetInprocessSurvey(string patientIcn, string currentUser)
        {
            return DataAccessManager.GetInprocessSurveyByPatientIcn(patientIcn, currentUser);
        }

        public void UpdateSurveyNoteBySurveyId(string surveyNoteText, int surveyId )
        {
            var surveyNote = new SURVEY_NOTE
            {
                SURVEYS_ID = surveyId,
                NOTES_TEXT = surveyNoteText,
                NOTE_DATE = DateTime.Today,
                UPDATEDBY = CurrentUser.UserName,
                UPDATED = DateTime.Today
            };
            DataAccessManager.UpdateSurveyNoteBySurveyId(surveyNote);        
        }

        public void InsertSurveyNoteBySurveyId(string surveyNoteText, int surveyId, int stationId)
        {
            var surveyNote = new SURVEY_NOTE
            {
                SURVEYS_ID = surveyId,
                NOTES_TEXT = surveyNoteText,
                NOTE_DATE = DateTime.Today,
                UPDATEDBY = CurrentUser.UserName,
                UPDATED = DateTime.Today,
                CREATEDBY = CurrentUser.UserName,
                STD_INSTITUTION_ID = stationId
            };
            DataAccessManager.InsertSurveyNoteBySurveyId(surveyNote);
        }

        public void SaveHfCondensedEntry(MssrAssessmentDisplay mssrCurrentAssessmentHf)
        {
            DataAccessManager.SaveHF_CondensedEntry(mssrCurrentAssessmentHf);
        }

        public void SavePatientDemographics(MssrePatientDemDispaly pntDem)
        {
            DataAccessManager.SaveDems(MapMssrePatientDem(pntDem));
        }

        public void SaveCurrentStatus(CurrentStatusDisplay mssrCurrentStatus)
        {
            DataAccessManager.SaveCurrentStatusEntry(MapCurrentStatusDisplayToCurrentStatus(mssrCurrentStatus));
        }

        public void UpdateSurveyEditLog(int surveyId, string editMessage)
        {
            DataAccessManager.InsertSurveyEditLog(surveyId, editMessage);        
        }

        public string GetPatinetSnumByPatientIcn(string patientIcn)
        {
            string resultSnum = DataAccessManager.GetSumByPatientIcn(patientIcn);
            return resultSnum;
        }

        public string GetStationIdByInstId(int? institutionId)
        {
            string stationId = DataAccessManager.GetStationIdByInstitutionId(institutionId);
            return stationId;
        }

        public int GetStationIdByStationNumber(string stationNumber)
        {
            return DataAccessManager.GetStationIdByStationNumber(stationNumber);
        }
        /** Survet Results Sync**/
        public void UpdateLatestSurveysAndResults(List<SurveyResults> surveyResults, string patientIcn, int surveyId, DateTime assessmentDate)
        {
            DataAccessManager.UpdateSurveyResults(surveyResults, patientIcn, surveyId, assessmentDate);
        }

        public int? CreateNewSurvey(SURVEY newSurvey)
        {
            return DataAccessManager.CreateNewSurvey(newSurvey.SURVEY_DATE, newSurvey.SURVEY_STATUS, newSurvey.STD_SURVEY_TYPE_ID, newSurvey.CREATEDBY,
                newSurvey.UPDATEDBY, newSurvey.CREATED, newSurvey.UPDATED, newSurvey.patient_ICN, newSurvey.STD_INSTITUTION_ID, newSurvey.PROVIDER_ID, newSurvey.PROVIDER_DUZ, newSurvey.AUTHOR_ID, newSurvey.PROVIDER_DUZ);           
        }

        public void CreateNewPatientSurveyLog(int surveyId)
        {
             DataAccessManager.CreateNewPatientSurveyLog(surveyId);
        }

        public void UpdateSurveyAndNewPatientStatus(string patientIcn, int surveyId)
        {
            DataAccessManager.UpdateSurveyAndNewPatientStatus(patientIcn, surveyId);
        }

        private SurveyResults MapToSurveyResult(GetSurveyResultsBySurveyID_Result surveyResult)
        {
            return new SurveyResults()
            {
                SurveyResultId = surveyResult.SURVEY_RESULT_ID,
                SurveysId = surveyResult.SURVEYS_ID,
                StdQuestionChoiceId = surveyResult.STD_QUESTION_CHOICE_ID,
                ResultText = surveyResult.RESULT_TEXT,
                CreatedBy = surveyResult.CREATEDBY,
                UpdatedBy = surveyResult.UPDATEDBY,
                Created = surveyResult.CREATED,
                Updated = surveyResult.UPDATED

            };
        }

        private MedSummary MapToSurveySummary(GetMedicationsUsedBySurveyAndPatientICN_Result medsum)
        {
            return new MedSummary()
            {
                SurveyId = medsum.SURVEYS_ID,
                PatientIcn = medsum.patient_ICN,
                MedicationName = medsum.MedicationName,
                DispensingPharmacy = medsum.DispensingPharmacy,
                CurrentUse = medsum.CURRENT_THERAPY,
                PastUse = medsum.PastUse,
                PastUseCurrentUse = medsum.PastUseCurrentUse,
                HealthFactor = medsum.HEALTH_FACTOR,
                ID = medsum.ID,
                PatientMedId = medsum.PATIENT_MED_ID

            };
        }

        private MedSummary MapToSurveySummary(GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result medsum)
        {
            return new MedSummary()
            {
                SurveyId = medsum.SURVEYS_ID,
                PatientIcn = medsum.patient_ICN,
                MedicationName = medsum.MedicationName,
                DispensingPharmacy = medsum.DispensingPharmacy,
                CurrentUse = medsum.CURRENT_THERAPY,
                PastUse = medsum.PastUse,
                PastUseCurrentUse = medsum.PastUseCurrentUse,
                HealthFactor = medsum.HEALTH_FACTOR,
                ID = medsum.ID,
                PatientMedId = medsum.PATIENT_MED_ID

            };
        }

        private MSSR_CURRENT_STATUS MapCurrentStatusDisplayToCurrentStatus(CurrentStatusDisplay currentStatus)
        {
            return new MSSR_CURRENT_STATUS
            {
                BaselineAssessDate = currentStatus.BaselineAssessDate,
                LastAssessDate = currentStatus.LastAssessDate,
                LastAssessType = currentStatus.LastAssessType,
                LastEdumsScore = currentStatus.LastEdumsScore,
                LastMSSubType = currentStatus.LastMSSubType,
                LastRelapses = currentStatus.LastRelapses,
                LastSymptomYear = currentStatus.LastSymptomYear,
                MSDiagnosis = currentStatus.MSDiagnosis,
                PatientICN = currentStatus.PatientICN,
                PatientSID = currentStatus.PatientSID,
                PreviousEdmusDate = currentStatus.PreviousEdmusDate,
                PreviousEdmusScore = currentStatus.PreviousEdmusScore,
                Rx1 = currentStatus.Rx1,
                Rx2 = currentStatus.Rx2,
                Rx3 = currentStatus.Rx3,
                RxAll = currentStatus.RxAll,
                RxEver1 = currentStatus.RxEver1,
                RxEver2 = currentStatus.RxEver2,
                RxEver3 = currentStatus.RxEver3,
                RxEver4 = currentStatus.RxEver4,
                RxEver5 = currentStatus.RxEver5,
                RxEverAll = currentStatus.RxEverAll,
                Sta3n = currentStatus.Sta3n,
                URFTemplateID = currentStatus.URFTemplateID,
                LastDiagnosisYear = currentStatus.LastDiagnosisYear            
            };
        }

        private MSSRE_PATIENT_DEM MapMssrePatientDem(MssrePatientDemDispaly pntDem)
        {
            return new MSSRE_PATIENT_DEM {
                PatientSoSeN = pntDem.PatientSoSeN,	
                PatientICN = pntDem.PatientICN,	
                PatientFirstName = pntDem.PatientFirstName,	
                PatientLastName = pntDem.PatientLastName,	
                PatientName = pntDem.PatientName,	
                Age = pntDem.Age,	
                DateOfBirth = pntDem.DateOfBirth,	
                DateOfDeath = pntDem.DateOfDeath,	
                CauseOfDeath = pntDem.CauseOfDeath,
                City = pntDem.City,
                State = pntDem.State,	
                Gender = pntDem.Gender,
                MaritalStatus = pntDem.MaritalStatus,	
                Religion = pntDem.Religion,
                Region = pntDem.Region,	
                Race = pntDem.Race,	
                Ethnicity = pntDem.Ethnicity
            };
        }
    }
}