﻿using System.Collections.Generic;
using System.Linq;
using MSSREnh;
using System;

/// <summary>
///     Summary description for MedsViewManager
/// </summary>
public class MedsViewManager : BaseViewManager
{
    public MedsViewModel GetMedsViewModel(string patientIcn, int surveyId)
    {
        IEnumerable<GetMedicationsUsedBySurveyAndPatientICN_Result> _listOfMeds = DataAccessManager.GetListOfMedicationsForSurvey(patientIcn, surveyId);
        IEnumerable<GetMedicationNotUsedBySurvey_Result> _availableMeds = DataAccessManager.GetAvailableMedicationForSurvey(surveyId);        
           
        return new MedsViewModel
        {
            ListOfMeds = _listOfMeds.Select(MapToSurveySummary),
            AvailablePatientMedications = _availableMeds
        };
    }
    public MedsViewModel GetInprocessMedsViewModel(string patientIcn, int surveyId)
    {
        IEnumerable<GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result> _listOfMeds = DataAccessManager.GetListOfMedicationsForCreateSurvey(patientIcn, surveyId);
        IEnumerable<GetMedicationNotUsedBySurvey_Result> _availableMeds = DataAccessManager.GetAvailableMedicationForSurvey(surveyId);

        return new MedsViewModel
        {
            ListOfMeds = _listOfMeds.Select(MapToSurveySummary),
            AvailablePatientMedications = _availableMeds
        };
    }
    public void UpdateMedication(MssrPatientMedication medication)
    {
        DataAccessManager.UpdateMedicationBySurveyIdAndMedicationId(MapPatMedsToMedsDisplay(medication));
    }
    public void AddMedication(MssrPatientMedication medication)
    {
        DataAccessManager.AddMedicationToSurvey(MapPatMedsToMedsDisplay(medication));
    }
    public void DeleteMedication(int surveyId, int medicationId, Guid id)
    {
       DataAccessManager.DeleteMedicationFromSurvey(surveyId, medicationId, id);    
    }

    public IEnumerable<MSSR_PATIENT_MEDICATION> GetListOfMedsBySurveyId(int surveyId)
    {
        var patientMeds = DataAccessManager.GetPatientMedicationBySurveyId(surveyId);

        return patientMeds;
    }
  
    private MedSummary MapToSurveySummary(GetMedicationsUsedBySurveyAndPatientICN_Result medsum)
    {
        return new MedSummary
        {
            SurveyId = medsum.SURVEYS_ID,
            PatientIcn = medsum.patient_ICN,
            MedicationName = medsum.MedicationName,
            DispensingPharmacy = medsum.DispensingPharmacy,
            CurrentUse = medsum.CURRENT_THERAPY,
            PastUse = medsum.PastUse,
            PastUseCurrentUse = medsum.PastUseCurrentUse,
            HealthFactor = medsum.HEALTH_FACTOR,
            ID = medsum.ID,
            PatientMedId = medsum.PATIENT_MED_ID
        };
    }
    private MedSummary MapToSurveySummary(GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result medsum)
    {
        return new MedSummary
        {
            SurveyId = medsum.SURVEYS_ID,
            PatientIcn = medsum.patient_ICN,
            MedicationName = medsum.MedicationName,
            DispensingPharmacy = medsum.DispensingPharmacy,
            CurrentUse = medsum.CURRENT_THERAPY,
            PastUse = medsum.PastUse,
            PastUseCurrentUse = medsum.PastUseCurrentUse,
            HealthFactor = medsum.HEALTH_FACTOR,
            ID = medsum.ID,
            PatientMedId = medsum.PATIENT_MED_ID
        };
    }
    private MSSR_PATIENT_MEDICATION MapPatMedsToMedsDisplay(MssrPatientMedication PatientMedication)
    {
        return new MSSR_PATIENT_MEDICATION
        {
            ID = PatientMedication.ID,
            SURVEY_ID = PatientMedication.SURVEY_ID,
            MEDICATION_ID = PatientMedication.MEDICATION_ID,
            OTHER_DMT_NAME = PatientMedication.OTHER_DMT_NAME,
            CURRENT_THERAPY = PatientMedication.CURRENT_THERAPY,
            CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED = PatientMedication.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED,
            CurrentNumberOfDosesTaken = PatientMedication.CurrentNumberOfDosesTaken,
            CURRENT_THERAPY_DISPENSING_PHARMACY = PatientMedication.CURRENT_THERAPY_DISPENSING_PHARMACY,
            MEDICATION_USED = PatientMedication.MEDICATION_USED,
            PAST_USE = PatientMedication.PAST_USE,
            PAST_USE_APPROXIMATE_YEAR_STARTED = PatientMedication.PAST_USE_APPROXIMATE_YEAR_STARTED,
            PAST_USE_APPROXIMATE_YEAR_STOPPED = PatientMedication.PAST_USE_APPROXIMATE_YEAR_STOPPED,
            PastNumberOfDosesTaken = PatientMedication.PastNumberOfDosesTaken,
            PAST_USE_DISPENSING_PHARMACY = PatientMedication.PAST_USE_DISPENSING_PHARMACY,
            PAST_USE_REASON_STOPPED = PatientMedication.PAST_USE_REASON_STOPPED,
            PAST_USE_REASON_STOPPED_OTHER = PatientMedication.PAST_USE_REASON_STOPPED_OTHER,
            SigEventOther = PatientMedication.SigEventOther,
            ADVERSE_EVENT = PatientMedication.ADVERSE_EVENT,
            ADVERSE_EVENTS = PatientMedication.ADVERSE_EVENTS,
            ADVERSE_EVENTS_DESCRIPTION = PatientMedication.ADVERSE_EVENTS_DESCRIPTION,
            TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS = PatientMedication.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS
        };
    }

    //Health Factor and Note section.

    public HealthFactorModel GetMedsHealthFactor(int surveyId)
    {
        IEnumerable<GetMedsForHealthFactor_Result> _medswithHealthFactor = DataAccessManager.GetMedsForHealthFactor(surveyId);
        return new HealthFactorModel { MedsUsedWithHealthFactor = _medswithHealthFactor };
    }
   
}