﻿using System;
using MSSREnh;
using System.Collections.Generic;
using System.Linq;




/// <summary>
/// Summary description for MSATEditViewManager
/// </summary>
public class MSATEditViewManager : BaseViewManager
{
   IEnumerable<GetListOfSurveysByPatientICN2_Result> _listOfCompletedSurveys =
                new GetListOfSurveysByPatientICN2_Result[0];
    GetPatientDetails_Result _patientDetails = new GetPatientDetails_Result();
    
    public MSATEditViewModel GetMsatEditViewModel(string patientIcn)   {

        _listOfCompletedSurveys = DataAccessManager.GetCompletedSurveysByPatientIcn(patientIcn);
        _patientDetails = DataAccessManager.GetPatientDetails(Int32.Parse(patientIcn));
        return new MSATEditViewModel()
        {
            ListOfSurveys = _listOfCompletedSurveys.Select(MapToSurveySummary),
            PatientDetails = MapToPatientDetails(_patientDetails)
        };
    }

    public MSATEditViewModel GetPatientDetails(string patientIcn)
    {
        _patientDetails = DataAccessManager.GetPatientDetails(Int32.Parse(patientIcn));
        return new MSATEditViewModel(){
            PatientDetails = MapToPatientDetails(_patientDetails)
            };  
    }

    private SurveySummary MapToSurveySummary(GetListOfSurveysByPatientICN2_Result survey)
    {
        return new SurveySummary()
        {
            CreatedBy = survey.CREATEDBY,
            SurveyId = survey.SURVEYS_ID,
            AssessmentDate = survey.AssessmentDateTime,
            AssessmentType = survey.AssessmentType,
            CreatedDate = survey.SURVEY_DATE,
            Station = survey.VISTANAME,
            PatientIcn = survey.patient_ICN,
            IsSurveyTheLatest = survey.IsSurveyTheLatest
        };
    }

    private PatientDetails MapToPatientDetails(GetPatientDetails_Result details)
    {
        return new PatientDetails()
        {
            PatientFullName = details.patientName,
            PatientIcn = details.patientIcn.ToString(),
            PatientLastFour = details.LastFour
        };
    }


}