﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.MSSR;


namespace MSSREnh
{
    /// <summary>
    ///     Summary description for DataAccessManager
    /// </summary>
    public class DataAccessManager
    {
        //DataAccessManager() { }
        public DataAccessManager(string currentUser)
        {
            this._currentUser = currentUser;
        }

        public DataAccessManager()
        {
            // TODO: Complete member initialization
        }
        private readonly string _currentUser;

        private readonly MSSRInstrumentsManager _mssrInstrumentManager = new MSSRInstrumentsManager();
        internal IEnumerable<GetListOfSurveysByPatientICN2_Result> GetCompletedSurveysByPatientIcn(string patientIcn)
        {
            IEnumerable<GetListOfSurveysByPatientICN2_Result> results =
                new GetListOfSurveysByPatientICN2_Result[0];
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    results = ctx.GetListOfSurveysByPatientICN2(patientIcn).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return results;
        }
        internal IEnumerable<GetMedsForHealthFactor_Result> GetMedsForHealthFactor(int surveyId)
        {
            IEnumerable<GetMedsForHealthFactor_Result> results =
                new GetMedsForHealthFactor_Result[0];
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    results = ctx.GetMedsForHealthFactor(surveyId).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return results;
        }
        internal IEnumerable<GetMedicationsUsedBySurveyAndPatientICN_Result> GetListOfMedicationsForSurvey(
            string patientIcn, int surveyId)
        {
            IEnumerable<GetMedicationsUsedBySurveyAndPatientICN_Result> results =
                new GetMedicationsUsedBySurveyAndPatientICN_Result[0];

            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    results = ctx.GetMedicationsUsedBySurveyAndPatientICN(patientIcn, surveyId).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return results;
        }
        internal IEnumerable<GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result> GetListOfMedicationsForCreateSurvey(
            string patientIcn, int surveyId)
        {
            IEnumerable<GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result> results =
                new GetMedicationsUsedBySurveyAndPatientICNSurveyCreate_Result[0];

            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    results = ctx.GetMedicationsUsedBySurveyAndPatientICNSurveyCreate(patientIcn, surveyId).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return results;
        }
        internal IEnumerable<GetSurveyResultsBySurveyID_Result> GetSurveyResultBySurveyIDandPatientIcn(int surveyId,
            string patientIcn)
        {
            IEnumerable<GetSurveyResultsBySurveyID_Result> surveyResults =
                new GetSurveyResultsBySurveyID_Result[0];
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    surveyResults = ctx.GetSurveyResultsBySurveyID(surveyId).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return surveyResults;
        }
        internal SURVEY GetSurveyBySurveyId(string patientIcn, int surveyId)
        {
            var survey =
                _mssrInstrumentManager.SelectSurveyCompletedByPatientICNAndSurveyType(patientIcn, 30, surveyId);

            return survey;
        }
        internal SURVEY GetInprocessSurveyBySurveyId(string patientIcn, int surveyId)
        {
            var survey =
                _mssrInstrumentManager.GetInprocessSurveyByPatientIcnAndSurveyType(patientIcn, surveyId, 30);

            return survey;
        }
        internal GetInprocessSurvey_Result GetInprocessSurveyByPatientIcn(string patientIcn, string userName)
        {
            var result = new GetInprocessSurvey_Result();
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    result = ctx.GetInprocessSurvey(patientIcn, userName).SingleOrDefault();
                }
            };
            DatabaseCall(dbAction);
            return result;
        }
        internal GetPatientDetails_Result GetPatientDetails(int patientIcn)
        {
            GetPatientDetails_Result result = new GetPatientDetails_Result();

            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    result = ctx.GetPatientDetails(patientIcn).FirstOrDefault();
                }
            };
            DatabaseCall(dbAction);
            return result;
        }
        internal void UpdateMedicationBySurveyIdAndMedicationId(MSSR_PATIENT_MEDICATION medication)
        {
            Action dbAction = () =>
           {
               using (var ctx = new MSSREntities())
               {
                   ctx.UpdatePatientMedication(medication.ID, medication.SURVEY_ID, medication.MEDICATION_ID,
                       medication.MEDICATION_USED, medication.CURRENT_THERAPY,
                       medication.CURRENT_THERAPY_DISPENSING_PHARMACY,
                       medication.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED, medication.PAST_USE,
                       medication.PAST_USE_DISPENSING_PHARMACY,
                       medication.PAST_USE_APPROXIMATE_YEAR_STARTED, medication.PAST_USE_APPROXIMATE_YEAR_STOPPED,
                       medication.PAST_USE_REASON_STOPPED,
                       medication.PAST_USE_REASON_STOPPED_OTHER, medication.CurrentNumberOfDosesTaken,
                       medication.PastNumberOfDosesTaken, medication.ADVERSE_EVENTS,
                       medication.ADVERSE_EVENTS_DESCRIPTION, medication.ADVERSE_EVENT, medication.OTHER_DMT_NAME,
                       medication.SigEventOther,
                       medication.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS);
               }
           };

            DatabaseCall(dbAction);

        }
        internal void AddMedicationToSurvey(MSSR_PATIENT_MEDICATION medication)
        {
            Action dbAction = () =>
           {
               using (var ctx = new MSSREntities())
               {
                   ctx.AddMedicationToSurvey(medication.ID,
                                              medication.SURVEY_ID,
                                              medication.MEDICATION_ID,
                                              medication.MEDICATION_USED,
                                              medication.CURRENT_THERAPY,
                                              medication.CURRENT_THERAPY_DISPENSING_PHARMACY,
                                              medication.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED,
                                              medication.PAST_USE,
                                              medication.PAST_USE_DISPENSING_PHARMACY,
                                              medication.PAST_USE_APPROXIMATE_YEAR_STARTED,
                                              medication.PAST_USE_APPROXIMATE_YEAR_STOPPED,
                                              medication.PAST_USE_REASON_STOPPED,
                                              medication.PAST_USE_REASON_STOPPED_OTHER,
                                              medication.CurrentNumberOfDosesTaken,
                                              medication.PastNumberOfDosesTaken,
                                              medication.ADVERSE_EVENTS,
                                              medication.ADVERSE_EVENTS_DESCRIPTION,
                                              medication.ADVERSE_EVENT,
                                              medication.OTHER_DMT_NAME,
                                              medication.SigEventOther,
                                              medication.TOTAL_LIFETIME_EXPOSURE_TO_THIS_THERAPY_IN_MONTHS);
               }
           };

            DatabaseCall(dbAction);

        }
        internal void DeleteMedicationFromSurvey(int surveyId, int medicationId, Guid id)
        {
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    ctx.DeleteMedicationFromSurvey(id, surveyId, medicationId);
                }
            };
            DatabaseCall(dbAction);
        }
        internal IEnumerable<GetMedicationNotUsedBySurvey_Result> GetAvailableMedicationForSurvey(int surveyId)
        {
            IEnumerable<GetMedicationNotUsedBySurvey_Result> medResults =
                new GetMedicationNotUsedBySurvey_Result[0];
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    medResults = ctx.GetMedicationNotUsedBySurvey(surveyId).ToArray();
                }
            };

            DatabaseCall(dbAction);
            return medResults;
        }
        internal void UpdateSurveyNoteBySurveyId(SURVEY_NOTE surveyNote)
        {
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    ctx.UpdateSurveyNote(surveyNote.SURVEYS_ID,
                        surveyNote.NOTE_DATE,
                        surveyNote.NOTES_TEXT,
                        surveyNote.UPDATEDBY,
                        surveyNote.UPDATED
                        );
                }
            };

            DatabaseCall(dbAction);

        }
        internal void InsertSurveyNoteBySurveyId(SURVEY_NOTE surveyNote)
        {

            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    ctx.InsertSurveyNote(surveyNote.SURVEYS_ID,
                        surveyNote.NOTE_DATE,
                        DateTime.Now,
                        surveyNote.STD_INSTITUTION_ID,
                        surveyNote.NOTES_TEXT,
                        surveyNote.CREATEDBY,
                        surveyNote.UPDATEDBY,
                        DateTime.Now,
                        DateTime.Now
                        );
                    
                }
            };

            DatabaseCall(dbAction);

        }
        internal void InsertSurveyEditLog(int surveyId, string editMessage)
        {
            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    ctx.InsertSurveyEditLog(surveyId, DateTime.Now, DateTime.Now, editMessage, _currentUser, _currentUser);
                }
            };

            DatabaseCall(dbAction);
        }
        internal void SaveHF_CondensedEntry(MssrAssessmentDisplay mssrCurrentAssessmentHF)
        {

            try
            {
                MssrAssessmentDisplay assessment = mssrCurrentAssessmentHF;

                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    ctx.MSSR_HF_Condenseds.InsertOnSubmit(new MSSR_HF_Condensed()
                    {
                        AssessmentDateTime = assessment.AssessmentDateTime,
                        AssessmentType = assessment.AssessmentType,
                        CurrentDisabilityScore = assessment.CurrentDisabilityScore,
                        DiagnosisYear = Helpers.getYearFromMonthYear(assessment.DiagnosisYear),
                        Ethnicity = assessment.Ethnicity,
                        MSDiagnosis = assessment.MSDiagnosis,
                        MSInterview = assessment.MSInterview,
                        MSSC = assessment.MSSC,
                        MSSubType = assessment.MSSubType,
                        PatientSID = null,
                        PatientICN = assessment.PatientICN,
                        Relapses = assessment.Relapses,
                        Sta3n = (short)assessment.Sta3n,
                        SymptomYear = Helpers.getYearFromMonthYear(assessment.SymptomYear)
                    });

                    ctx.SubmitChanges();
                }
            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveHF_CondensedEntry: " + ex.Message);
            }

        }
        internal void SaveDems(MSSRE_PATIENT_DEM pntDem)
        {
            try
            {
                MSSRE_PATIENT_DEM patientDem = pntDem;

                //Insert
                int result = 0;
                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    result = ctx.SP_InsertDemData(patientDem.PatientICN.ToString());
                }
                //Update
                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    MSSRE_PATIENT_DEM patient = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(C => C.PatientICN == patientDem.PatientICN);

                    patient.DateOfDeath = pntDem.DateOfDeath;
                    patient.CauseOfDeath = patientDem.CauseOfDeath;

                    ctx.SubmitChanges();
                }
            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveHF_CondensedEntry: " + ex.Message);
            }

        }
        internal void SaveCurrentStatusEntry(MSSR_CURRENT_STATUS mssrCurrentStatus)
        {
            try
            {
                MSSR_CURRENT_STATUS currentStatus = mssrCurrentStatus;

                // TODO: Perform lookup for CURRENT_STATUS_ENTRY for PatientICN ... if null ... PreviousEDMUSScore and PreviousEDMUSDate are NULL ... else
                // (PreviousEdmusScore set to LastEdumsScore) and (PreviousEdmusDate set to previous value from LastAssessDate)

                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    MSSR_CURRENT_STATUS existingStatus = ctx.MSSR_CURRENT_STATUS.FirstOrDefault(C => C.PatientICN == currentStatus.PatientICN);

                    if (existingStatus != null)
                    {

                        // if existing entry has LastEdumsScore, set these values into the PreviousEdmusScore/Date fields
                        if (!String.IsNullOrEmpty(existingStatus.LastEdumsScore))
                        {
                            existingStatus.PreviousEdmusScore = existingStatus.LastEdumsScore;
                            existingStatus.PreviousEdmusDate = existingStatus.LastAssessDate;
                        }

                        // if current status has a LastEdmusScore, populate LastEdmusScore/Date into existing object for update.
                        if (!String.IsNullOrEmpty(currentStatus.LastEdumsScore))
                        {
                            existingStatus.LastEdumsScore = currentStatus.LastEdumsScore;
                        }

                        existingStatus.Sta3n = currentStatus.Sta3n;
                        existingStatus.LastAssessType = currentStatus.LastAssessType;
                        existingStatus.LastAssessDate = currentStatus.LastAssessDate;
                        existingStatus.LastMSSubType = currentStatus.LastMSSubType;
                        existingStatus.LastRelapses = currentStatus.LastRelapses;
                        existingStatus.LastSymptomYear = currentStatus.LastSymptomYear;
                        existingStatus.MSDiagnosis = currentStatus.MSDiagnosis;
                        existingStatus.Rx1 = currentStatus.Rx1;
                        existingStatus.Rx2 = currentStatus.Rx2;
                        existingStatus.Rx3 = currentStatus.Rx3;
                        existingStatus.RxAll = currentStatus.RxAll;
                        existingStatus.RxEver1 = currentStatus.RxEver1;
                        existingStatus.RxEver2 = currentStatus.RxEver2;
                        existingStatus.RxEver3 = currentStatus.RxEver3;
                        existingStatus.RxEver4 = currentStatus.RxEver4;
                        existingStatus.RxEver5 = currentStatus.RxEver5;
                        existingStatus.RxEverAll = currentStatus.RxEverAll;
                        existingStatus.URFTemplateID = currentStatus.URFTemplateID;
                        existingStatus.LastDiagnosisYear = currentStatus.LastDiagnosisYear;//Release2

                    }
                    else
                    {
                        // insert current.
                        ctx.MSSR_CURRENT_STATUS.InsertOnSubmit(new MSSR_CURRENT_STATUS()
                        {
                            BaselineAssessDate = currentStatus.BaselineAssessDate,
                            LastAssessDate = currentStatus.LastAssessDate,
                            LastAssessType = currentStatus.LastAssessType,
                            LastEdumsScore = currentStatus.LastEdumsScore,
                            LastMSSubType = currentStatus.LastMSSubType,
                            LastRelapses = currentStatus.LastRelapses,
                            LastSymptomYear = currentStatus.LastSymptomYear,
                            MSDiagnosis = currentStatus.MSDiagnosis,
                            PatientICN = currentStatus.PatientICN,
                            PatientSID = currentStatus.PatientSID,
                            PreviousEdmusDate = currentStatus.PreviousEdmusDate,
                            PreviousEdmusScore = currentStatus.PreviousEdmusScore,
                            Rx1 = currentStatus.Rx1,
                            Rx2 = currentStatus.Rx2,
                            Rx3 = currentStatus.Rx3,
                            RxAll = currentStatus.RxAll,
                            RxEver1 = currentStatus.RxEver1,
                            RxEver2 = currentStatus.RxEver2,
                            RxEver3 = currentStatus.RxEver3,
                            RxEver4 = currentStatus.RxEver4,
                            RxEver5 = currentStatus.RxEver5,
                            RxEverAll = currentStatus.RxEverAll,
                            Sta3n = currentStatus.Sta3n,
                            URFTemplateID = currentStatus.URFTemplateID,
                            LastDiagnosisYear = currentStatus.LastDiagnosisYear //Release2
                        });
                    }

                    ctx.SubmitChanges(); // submit changes.
                }
            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile("Failure in MSAssessmentNoteSummary saveCurrentStatusEntry: " + ex.Message);
            }


        }
        internal string GetSumByPatientIcn(string patientIcn)
        {
            string snumResult = string.Empty;

            Action dbAction = () =>
            {
                using (var ctx = new MSSREntities())
                {
                    snumResult = ctx.GetSnumByPatientIcn(patientIcn).FirstOrDefault();
                }
            };
            DatabaseCall(dbAction);
            return snumResult;

        }
        internal string GetStationIdByInstitutionId(int? instId)
        {
            string stationId = string.Empty;
            stationId = _mssrInstrumentManager.GetStationIdByInstitutionId(instId);
            return stationId;
        }
        internal int GetStationIdByStationNumber(string stationNumber)
        {
            return _mssrInstrumentManager.GetStationIdByStationNumber(stationNumber);

        }
        internal IEnumerable<MSSR_PATIENT_MEDICATION> GetPatientMedicationBySurveyId(int surveyId)
        {
            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                DataLoadOptions lo = new DataLoadOptions();

                lo.LoadWith<MSSR_PATIENT_MEDICATION>(m => m.MSSR_MEDICATION);
                ctx.LoadOptions = lo;
                ctx.DeferredLoadingEnabled = false;
                var patientMedsList = from md in ctx.MSSR_PATIENT_MEDICATIONs
                                      where md.SURVEY_ID == surveyId
                                      select md;

                return patientMedsList.ToList();
            }
        }
        internal void UpdateSurveyResults(List<SurveyResults> surveyResults, string patientIcn, int surveyId, DateTime assessmentDate)
        {
            //get list of survyes...
            IEnumerable<SURVEY> latestSurveys = _mssrInstrumentManager.GetLatestSurveys(patientIcn, 30, assessmentDate);

            foreach (var latestSurvey in latestSurveys)
            {
                UpdateSurveyResult(latestSurvey, surveyResults, surveyId, assessmentDate, patientIcn);
            }
        }
        internal void UpdateSurveyResult(SURVEY surveyToUpdate, List<SurveyResults> surveyResults, int sourceSurveyId, DateTime assessmentDate, string patientIcn)
        {
            foreach (var surveyResult in surveyResults)
            {
                var questionChoiceId = surveyResult.StdQuestionChoiceId;
                var surveyResultText = surveyResult.ResultText;
                var questionCode = surveyResult.QuestionCode;
                Action dbAction = () =>
                {
                    using (var ctx = new MSSREntities())
                    {
                        ctx.UpdateSurveyResult(surveyResultText, questionChoiceId, surveyToUpdate.SURVEYS_ID, _currentUser, DateTime.Now, questionCode);
                    }
                };
                DatabaseCall(dbAction);
                Logging.WriteLogToFile(
            string.Format(
                "AutoForward Survey results. Base Survey Id {0} Patient Icn {1} and Base assessment Date {2} - Updating Survey Id {3} Question Choice {4}", sourceSurveyId,
                patientIcn, assessmentDate, surveyToUpdate.SURVEYS_ID, questionChoiceId));
            }
        }
        internal void AddNewPatientToSurveyPatient(
                                                    string patientIcn, string stdInstitutionId, string patientSsn, string firstName, string middleName, string lastName,
                                                    DateTime? dateofBirth, string gender, string sta6N, string dfn, DateTime created, DateTime updated, string createdby,
                                                    string updatedby
            )
        {
            int stationId = 0;
            if (!string.IsNullOrEmpty(stdInstitutionId))
                Int32.TryParse(stdInstitutionId, out stationId);

            using (var ctx = new MSSREntities())
            {
                ctx.AddNewPatientToSurveyPatient(patientIcn, stationId, patientSsn, firstName, middleName, lastName,
                                                     dateofBirth, gender, sta6N, dfn, created, updated, createdby, updatedby);
            }
        }
        internal void AddNewPatientToPatientDems(
                                                string patientSsn, string patientSid, string patientIcn, string patientFirstName,
                                                string patientLastName, string patientFullName, int age, DateTime? dateOfBirth, DateTime? dateOfDeath,
                                                string city, string state, string gender, string maritalStatus, string religion, string region, string race,
                                                string ethnicity, DateTime created, string createdBy, string station, string stationName
                                                )
        {
            int? patientSid2 = patientSid != null ? Int32.Parse(patientSid) : (int?) null;
            int region2 = 0; int.TryParse(region, out region2);
            int patientIcn2 = int.Parse(patientIcn);//okay to throw exception

            using (var ctx = new MSSREntities())
            {
                ctx.AddNewPatientToMssrPatientDems(
                                                    patientSsn, patientSid2,
                                                    patientIcn2, patientFirstName, patientLastName,
                                                    patientFullName, age, dateOfBirth,
                                                    dateOfDeath, city, state, gender, maritalStatus,
                                                    religion, region2, race, ethnicity, created, createdBy, "NEW", "MSSR-NEW PATIENT", station, stationName
                                                    );
                
            }
        }
        internal void AddNewPatientToMssrePatientDems(
                                            string patientSsn, string patientSid, string patientIcn, string patientFirstName,
                                            string patientLastName, string patientFullName, int age, DateTime? dateOfBirth, DateTime? dateOfDeath,
                                            string causeOfDeath, string city, string state, string gender, string maritalStatus, string religion, string region,
                                            string race, string ethnicity, DateTime created, string createdBy
                                                )
        {
            int region2 = 0; int.TryParse(region, out region2);
            int patientIcn2 = int.Parse(patientIcn);//okay to throw exception

            using (var ctx = new MSSREntities())
            {
                ctx.AddNewPatientToMssrePatientDems(patientSsn, patientIcn2, patientFirstName, patientLastName,
                    patientFullName, age, dateOfBirth, dateOfDeath, causeOfDeath, city, state, gender, maritalStatus,
                    religion, region2, race, ethnicity, "NEW", "MSSR-NEW PATIENT");
            }
        }
        internal List<string> CheckIfPatientExistsInMssr(string patientSsn, string patientIcn)
        {
            List<string> patient;
            using (var ctx = new MSSREntities())
            {
                patient = ctx.ConfirmPatientExistsInMssr(patientSsn, patientIcn).ToList();
            }
            return patient;
        }
        internal IEnumerable<MSSR_PATIENT_DEM> GetListOfNewPatients()
        {
            IEnumerable<MSSR_PATIENT_DEM> newPatients;
            using (var ctx = new MSSRDataClassesDataContext())
            {
                 newPatients = (from pats in ctx.MSSR_PATIENT_DEMs
                                  where pats.Status == "NEW" && pats.CreatedVia == "MSSR-NEW PATIENT"
                                  select pats).ToList();
            }
            return newPatients.OrderByDescending(np => np.CREATED);
        }
        internal SearchAndLoadPatientIcnAndDetails_Result FindNewPatientDetails(string ssn)
        {
            SearchAndLoadPatientIcnAndDetails_Result newPatient;

            using (var ctx = new MSSREntities())
            {
                newPatient = ctx.SearchAndLoadPatientIcnAndDetails(ssn).SingleOrDefault();
            }
            return newPatient;
        }
        internal int? CreateNewSurvey(DateTime surveyDate,string surveyStatus,int stdSurveyTypeId,string createdBy,string updatedBy,
	                        DateTime created, DateTime updated, string patientIcn,int? stdInstitutionId,int? providerId,string providerDurz,int? authorId,string authorDuz)
        {
            int? newSurveyId;
            using (var ctx = new MSSREntities())
            {
                newSurveyId = ctx.CreateNewInprocessSurvey(surveyDate, surveyStatus, stdSurveyTypeId,
                    createdBy, updatedBy,created, updated, patientIcn, stdInstitutionId, providerId, providerDurz, authorId, authorDuz).SingleOrDefault();
            }

            return newSurveyId;
        }
        internal void CreateNewPatientSurveyLog(int surveyId)
        {
            using (var ctx = new MSSRDataClassesDataContext())
            {
                ctx.MSSR_NEW_PATTIENTs.InsertOnSubmit(new MSSR_NEW_PATTIENT()
                {
                    SURVEYS_ID = surveyId,STATUS = "new patient",CREATEDBY = _currentUser,UPDATEDBY = _currentUser,CREATED = DateTime.Now,UPDATED = DateTime.Now,SURVEY_CREATED = false
                });
                ctx.SubmitChanges();
            }
        }
        internal void UpdateSurveyAndNewPatientStatus(string patientIcn, int surveyId)
        {
            _mssrInstrumentManager.UpdateSurveyAndNewPatientStatus(patientIcn, surveyId);
            UpdateMssrPatientDemNewPatientStatus(patientIcn);

        }
        internal void UpdateMssrPatientDemNewPatientStatus(string patientIcn)
        {
            int pIcn;
            int.TryParse(patientIcn, out pIcn);
            using (var ctx = new MSSRDataClassesDataContext())
            {
                MSSR_PATIENT_DEM pat = ctx.MSSR_PATIENT_DEMs.FirstOrDefault(pd => pd.PatientICN == pIcn);
                if (pat != null)
                {
                    pat.Status = "SURVEY CREATED";
                    pat.IsSurveyCreated = true;
                }
                ctx.SubmitChanges(); 
            }
        }
        
        internal IEnumerable<GetMangeResourcesByFacilityDovMedication_Result> GetMangeResourcesByFacilityDovMedicationRpt(
            DateTime? startDate, DateTime? endDate, string stationId, int? relapse, string medName, string medNameAdditional, string race, string gender)
        {
           IEnumerable<GetMangeResourcesByFacilityDovMedication_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetMangeResourcesByFacilityDovMedication(startDate, endDate, stationId, relapse, medName, medNameAdditional, race, gender).ToList();
            }
            
            return result;
        }
        //
        internal IEnumerable<GetHealthRegulatorComplianceDetails_Result> GetHealthRegulatroComplianceSummaryRpt(
            DateTime? startDate, DateTime? endDate, string stationId, int? relapse, string medName, string medNameAdditional, string race, string gender)
        {
            IEnumerable<GetHealthRegulatorComplianceDetails_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetHealthRegulatorComplianceDetails(startDate, endDate, stationId, relapse, medName, medNameAdditional, race, gender).ToList();
            }
            
            return result;
        }
        internal IEnumerable<GetHCRCByFacilityDovMedicationDetails_Result> GetHcrcByFacilityDovMedicationDetailsFacilityDovMedicationRpt(
           DateTime? startDate, DateTime? endDate, string stationId, int? relapse, string medName, string medNameAdditional, string race, string gender)
        {
            IEnumerable<GetHCRCByFacilityDovMedicationDetails_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetHCRCByFacilityDovMedicationDetails(startDate, endDate, stationId, relapse, medName, medNameAdditional, race, gender).ToList();
            }

            return result;
        }

        internal IEnumerable<GetMangeResourcesByFacilityDovMedicationDetails_Result>
            GetMangeResourcesByFacilityDovMedicationDetailsRpt(DateTime? startDate, DateTime? endDate, string stationId, int? relapse,
                string medName, string medNameAdditional, string race, string gender)
        {
            IEnumerable<GetMangeResourcesByFacilityDovMedicationDetails_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetMangeResourcesByFacilityDovMedicationDetails(startDate, endDate, stationId, relapse, medName, medNameAdditional, race, gender).ToList();
            }

            return result;
        }
        public IEnumerable<GetQPMByFacilityDovMedicationDetails_Result> GetQpmByFacilityDovMedicationDetailsFacilityDovMedicationRpt(DateTime? startDate, 
            DateTime? endDate, string stationId, string relapse, string medName, string medNameAdditional, string icdCptCode, string edmusScore)
        {
            IEnumerable<GetQPMByFacilityDovMedicationDetails_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetQPMByFacilityDovMedicationDetails(startDate, endDate, stationId, relapse, medName, medNameAdditional, icdCptCode, edmusScore).ToList();
            }

            return result;
        }

        internal IEnumerable<GetQualityPerformanceMetricsSummary_Result> GetQualityPerformanceMetricsSummary(
           DateTime? startDate, DateTime? endDate, string stationId,  string medName, string medNameAdditional)
        {
            IEnumerable<GetQualityPerformanceMetricsSummary_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetQualityPerformanceMetricsSummary(startDate, endDate, stationId,  medName, medNameAdditional).ToList();
            }

            return result;
        }

        internal IEnumerable<GetMangeResourcesByFacilityDovMedicationDetailsCharts_Result> GetMangeResourcesByFacilityDovMedicationDetailsCharts(
          DateTime? startDate, DateTime? endDate, string stationId, int? relapse, string medName, string medNameAdditional, string race, string gender)
        {
            IEnumerable<GetMangeResourcesByFacilityDovMedicationDetailsCharts_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetMangeResourcesByFacilityDovMedicationDetailsCharts(startDate, endDate, stationId, relapse, medName, medNameAdditional, race, gender).ToList();
            }

            return result;
        }






        public IEnumerable<GetVisnFacilityListing_Result> GetVisnFacilityListingRpt()
        {
            IEnumerable<GetVisnFacilityListing_Result> result;
            using (var ctx = new MSSREntities())
            {
                result = ctx.GetVisnFacilityListing().ToList();
            }

            return result;
        }


        private void DatabaseCall(Action dbAction)
        {
            try
            {
                dbAction();
            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile(_currentUser, ex.Message);
            }
        }

       
    }
}