﻿using BitFactory.Logging;
using System.Configuration;
using System;
using System.Linq;
using System.Web;
using VeteransAffairs.Registries.Business;


public class Logging
{
    public static void WriteLogToFile(string LoginUserID, Exception ex)
    {
        string message = "Login UserId: " + LoginUserID + ":::Error: " +
                         ex.ToString();

        WriteLogToFile(message);
    }

    public static void WriteLogToFile(string LoginUserID, string error)
    {
        string message = "UserId: " + LoginUserID + ":::Error: " + error;

        WriteLogToFile(message);
    }

    public static void WriteLogToFile(string message)
    {
        string userName;
        string comments;
        try
        {
            userName = HttpContext.Current.User.Identity.Name;
            comments = String.Format("Client IP: {0}:: Session ID: {1}", HttpContext.Current.Request.UserHostAddress, HttpContext.Current.Session.SessionID);
        }
        catch
        {
            userName = "UNKNOWN";
            comments = "";
        }
        message = "UserId: " + userName + ":: " + message;
        
        string path = GetLogLocation();

        Logger l = new FileLogger(path);

        l.LogInfo(message); 

        RegistriesLinqDataContext dc = new RegistriesLinqDataContext();
        int stdRegistryId = 0;

        var setting = (from s in dc.STD_REGISTRies
                        where s.CODE == "MSSR"
                        select s.ID).SingleOrDefault();

        if (setting != null)
        {
            stdRegistryId = Convert.ToInt32(setting);
        }

        if (ConfigurationManager.AppSettings["LogToDB"].ToString().Trim() == "true" &&
            stdRegistryId > 0)
        {
            var numReferrals = SqlProvider.ExecuteScalar(
                            "MSSRConnectionString", "CRS_SP_INS_CRSDBLOG",
                            new object[] { stdRegistryId, 0, "MSSR Logger", message, "", "MSSR Logger" });
        }
    }

    public static string GetLogLocation()
    {
        //Global g = new Global();
        return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + "_MSSR.log";
    }
}


