﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using VeteransAffairs.Registries.BusinessManager;

/// <summary>
/// Summary description for BasePage
/// </summary>
public abstract class BaseMSSRInstrumentPage : Page {
    //Default values
    private string msgSaveSuccess = "Save Successful.";
    private string msgSaveFail = "Save Failed.";

    #region Constructor

    public BaseMSSRInstrumentPage(bool errorOnSavedReceived) {
        //Manager Save Notification Event Handler
        //_tbiInstrumentManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

        _errorOnSavedReceived = errorOnSavedReceived;
        SuppressSaveMessage = true;
    }

    public BaseMSSRInstrumentPage() {
        //Manager Save Notification Event Handler
        //_tbiInstrumentManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

        SuppressSaveMessage = true;
    }

    public string SaveSuccessMessage {
        get {
            //return "Save Successful.";
            return msgSaveSuccess;
        }

        set {
            msgSaveSuccess = value;
        }
    }

    public string SaveFailMessage {
        get {
            //return "Save Failed.";
            return msgSaveFail;
        }

        set {
            msgSaveFail = value;
        }
    }

    /// <summary>
    /// Base Page_Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void BaseMSSRInstrumentPage_Load(object sender, EventArgs e) {
        CheckNeedStationDivision();
        bool _isCPRSLaunced = false;

        Response.Cache.SetExpires(DateTime.Now);
        //Based on comment below and since MSAT is using VIA created a type to suffice fortify requirements. 
        if (sender.GetType().BaseType == typeof(PatientInstrumentsNoMDWS)) {
            // TODO: I DON'T BELIEVE THIS WILL BE HIT FOR MSAT ... WE NEED THE CONNECTION

            MSSRServiceTO _mssrServiceTo = GetMSSRServiceToFromSession();

            if (_mssrServiceTo != null) {
                _mssrInstrumentManager.MssrServiceTo = _mssrServiceTo;

                _mssrInstrumentManager.MssrServiceTo.PatientName = "Last, First Middle";
                _mssrInstrumentManager.MssrServiceTo.PatientDOB = "01/02/1970";
                _mssrInstrumentManager.MssrServiceTo.PatientGender = "";
                _mssrInstrumentManager.MssrServiceTo.PatientSoN = "123456789";
                _mssrInstrumentManager.MssrServiceTo.PatientICN = "123456789";
                _mssrInstrumentManager.MssrServiceTo.PatientDFN = "1316";
                _mssrInstrumentManager.MssrServiceTo.STA6N = "";
                _mssrInstrumentManager.MssrServiceTo.UserName = "Test Doctor";
                _mssrInstrumentManager.MssrServiceTo.PatientAdmintTimeStamp = "";

            } else {
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
        } else {
            if (_mssrInstrumentManager != null) {
                // TODO: LOOK AT CONFIG AND DETERMINE WHAT SERVICE IS IN USE
                if (getCurrentServiceToUse() == "MDWS") {
                    _mssrInstrumentManager.DisconnectSite(_mssrInstrumentManager.MssrServiceTo); // Only for MDWS
                }
            }

            MSSRServiceTO _mssrServiceTo = GetMSSRServiceToFromSession();

            if (_mssrServiceTo != null) {
                // TODO: LOOK AT CONFIG AND DETERMINE WHAT SERVICE IS IN USE

                if (getCurrentServiceToUse() == "VIA") {
                    try {
                        _isCPRSLaunced = _mssrInstrumentManager.LoadMSSR_VIAService(_mssrServiceTo); // VIA
                    } catch (Exception ex) {
                        Logging.WriteLogToFile("VIA is not reponding: " + ex.Message);

                        Response.Redirect("Warning.aspx?err=12345"); // VIA not responding
                    }
                } else {
                    _isCPRSLaunced = _mssrInstrumentManager.LoadMssrService(_mssrServiceTo); // MDWS
                }

                if (!_isCPRSLaunced) {
                    if (getCurrentServiceToUse() == "MDWS") {
                        Response.Redirect("MSATNoMDWS.aspx", false); // MDWS
                    } else if (getCurrentServiceToUse() == "VIA") {
                        Response.Redirect("MSATNoVIA.aspx", false); // VIA
                    }
                }
            } else {
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
        }

        if (_mssrInstrumentManager.MssrServiceTo == null) {
            //display error message MDWS could not be accessed
            //    Response.Redirect("Warning.aspx?err=3");
        } else {
            AddtoSessionMSSRServiceTo(_mssrInstrumentManager.MssrServiceTo);
        }

        Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
        if (_mssrInstrumentManager.MssrServiceTo != null) {
            labelUser.Text = _mssrInstrumentManager.MssrServiceTo.UserName;
        }
    }

    #endregion Constructor

    #region Properities

    //private int _displayMode;
    private bool _errorOnSavedReceived;
    private Dictionary<string, string> _OnStartupAlertErrorCollection;

    protected bool _TestingAllowSSNConfirmByPass = false;

    protected MSSRInstrumentsManager _mssrInstrumentManager = new MSSRInstrumentsManager();

    public bool ReadOnly { get; set; }
    public bool AllowInsert { get; set; }
    public bool AllowDelete { get; set; }
    public bool AllowUpdate { get; set; }
    public bool BusinessObjectSaveEventReceived { get; set; }
    public bool IsSaveSuccess { get; set; }
    public bool SuppressSaveMessage { get; set; }


    #endregion Properties

    #region Public Methods

    /// <summary>
    /// Select returns the base application path.
    /// </summary>
    /// <param name="context">Context object</param>
    /// <returns>Returns the base application path.</returns>
    public static string RootPath(HttpContext context) {
        string urlSuffix = context.Request.Url.Authority + context.Request.ApplicationPath;
        return context.Request.Url.Scheme + @"://" + urlSuffix + "/";
    }

    public static NameValueCollection DecryptQueryString(string queryString) {
        NameValueCollection myColl = new NameValueCollection();
        myColl.Add("a", "1");
        return myColl;
    }

    public static string EncryptQueryString(NameValueCollection queryString) {
        string myString = "";
        return myString;
    }

    /// <summary>
    /// You must pass in a string that uses the QueryStringHelper.DELIMITER as the delimiter.
    /// This will also append the "?" to the beginning of the query string.
    /// </summary>
    /// <param name="queryString"></param>
    /// <returns></returns>
    public static string EncryptQueryString(string queryString) {
        string qs = "";
        return qs;
    }

    protected MSSRServiceTO GetMSSRServiceToFromSession() {
        MSSRServiceTO _mssrServiceTo;

        try {
            _mssrServiceTo = (MSSRServiceTO)Session["MSSRServiceTO"];
        } catch {
            return null;
        }

        return _mssrServiceTo;
    }

    protected void AddtoSessionMSSRServiceTo(MSSRServiceTO mssrServiceTo) {
        if (Helpers.DeSerializSessionItems(Session["ConfirmedSSN"]) != null)
        {
            if (Helpers.DeSerializSessionItems(Session["ConfirmedSSN"]) != mssrServiceTo.PatientSoN)
            {
                //corrupted application context display error message to user
                Response.Redirect("Warning.aspx?err=11");
            }
        }

        Session["MSSRServiceTO"] = mssrServiceTo;
    }

    protected void AddtoSessionSSN(string ssn) {
        //This setting is only saved once in a session to be used for preventing cross-instance data sharing
        if (Helpers.DeSerializSessionItems(Session["ConfirmedSSN"]) == null)
        {
            Session["ConfirmedSSN"] = Helpers.SerializSessionItemsObj(ssn);
        }
    }

    /// <summary>
    /// getCurrentServiceToUse: Looks for web.config variable (MSSRServiceToUse).  If null, returns MDWS, else returns either MDWS or VIA
    /// </summary>
    /// <returns></returns>
    protected string getCurrentServiceToUse() {
        string resultStr = "MDWS";

        try
        {
            var setting = Helpers.GetDBConfigEntry("MSSRServiceToUse");

            if (setting != null)
            {
                switch (setting.ToString().ToLower())
                {
                    case "mdws":
                        resultStr = "MDWS";
                        break;
                    case "via":
                        resultStr = "VIA";
                        break;
                    default:
                        resultStr = "MDWS";
                        break;
                }
            }
        }
        catch (Exception e)
        {
            Exception ex = HandleMSSRException(e, "BaseMssrInstrumentPage", "0", "getCurrentServiceToUse()");
            //TODO: Log this error
        }

        return resultStr;
    }

    #region Exception Logging

    protected Exception HandleMSSRException(Exception exception, string screenName, string eventId, string functionname) {

        WriteToLogToFile(exception, screenName, eventId, functionname);

        return exception;
    }

    private void WriteToLogToFile(Exception ex, string _screenName, string _eventId, string _functionname)
    {
        string flatmessage = "MSSR INSTRUMENT ERROR:: " + " :::SCREENNAME= " + _screenName + ":::Function=" + _functionname;

        if (ex != null)
        {
            flatmessage += " ::: EXCEPTION= " + ex.ToString();
        }  

        Logging.WriteLogToFile(flatmessage);
    }

    #endregion

    #endregion Public Methods

    #region Overrides

    protected override void OnPreInit(EventArgs e) {
        //get theme from user profile
        //this.Theme = "TBIInstruments";        
    }

    protected override void OnInit(EventArgs e) {
        base.OnInit(e);

        if (!isQueryStringValid()) {
            //redirect to error handling page
            Response.Redirect("../ErrorPage.aspx?id=qs");
        }

    }

    protected override void OnPreRender(EventArgs e) {
        if (!SuppressSaveMessage) {
            RenderStartUpMessage(IsSaveSuccess);
        }

        base.OnPreRender(e);
    }

    #endregion Overrides

    #region Virtual Methods

    protected virtual void NoAccessToPage() {
        //You do not access to the system.
        //If a page has more than one capability you should override this method because a user could
        //have access to one section but not another so you do not want them to get an error
        Response.Redirect("ErrorPage.aspx?id=100");
        //throw new AccessViolationException("You do not have access to this screen.");
    }

    public virtual void CustomReadOnlyLogic(string capabilityName) {
        //Override this method in a page that has custom logic for non standard controls on the screen.
    }

    /// <summary>
    /// The default implementation will make all controls disabled.
    /// If you have more than one capability associated with a page you should override this method
    /// with the special logic for each capability in the page.
    /// </summary>
    /// <param name="capabilityName"></param>
    /// <param name="controls"></param>
    public virtual void MakeFormReadOnly(string capabilityName, ControlCollection controls) {
        ReadOnly = true;

        SetControlsEnableState(controls, false);

        CustomReadOnlyLogic(capabilityName);
    }

    public virtual void EnableAllControls(ControlCollection controls) {
        SetControlsEnableState(controls, true);
    }

    #endregion Virtual Methods

    #region Private Methods

    private void SetControlsEnableState(ControlCollection controls, bool enabled) {

        foreach (Control c in controls) {
            if (c is TextBox) {
                ((TextBox)c).Enabled = enabled;
            } else if (c is RadioButton) {
                ((RadioButton)c).Enabled = enabled;
            } else if (c is DropDownList) {
                ((DropDownList)c).Enabled = enabled;
            } else if (c is CheckBox) {
                ((CheckBox)c).Enabled = enabled;
            } else if (c is RadioButtonList) {
                ((RadioButtonList)c).Enabled = enabled;
            } else if (c is CheckBoxList) {
                ((CheckBoxList)c).Enabled = enabled;
            } else if (c is RequiredFieldValidator) {
                ((RequiredFieldValidator)c).Enabled = enabled;
            } else {
                //break
            }

            if (c.HasControls()) {
                SetControlsEnableState(c.Controls, enabled);
            }
        }
    }

    private Boolean isQueryStringValid() {
        //this iterates over querysting parameters
        //this will handle known querystring parameters and validate range, if any not valid range throw exception
        //if unknown parameter is found, throw exception

        Boolean _isValid = true;

        NameObjectCollectionBase.KeysCollection qryString = Request.QueryString.Keys;

        foreach (string qryStringKey in qryString) {
            switch (qryStringKey) {
                case "q9gtw0":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "yiicf":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "xqi4z":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "5Sfty21":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "45vlw93":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "jbPI0202":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "27trp":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "patientIcn":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "useSession":
                    return true;
                default:

                    //do something here   
                    _isValid = false;
                    break;
                //throw new Exception("Unknown querystring parameter. " + qryStringKey);
            }

            if (!_isValid) {
                break;
            }
        }

        return _isValid;
    }

    //private SessionFacade _SessionFacade = new SessionFacade();
    private string CreateStartUpMessage(bool isSaveSuccessMessage) {

        string Message = string.Empty;

        if (_OnStartupAlertErrorCollection == null && !SuppressSaveMessage) {
            if (isSaveSuccessMessage) {
                Message = SaveSuccessMessage;
            } else {
                Message = SaveFailMessage;
            }
        } else {
            if (_OnStartupAlertErrorCollection != null) {
                foreach (KeyValuePair<string, string> item in _OnStartupAlertErrorCollection)
                    Message += item.Value + "\\n";
            }

        }

        return Message;
    }
    
    /// <summary>
    /// Renders the massage in javascript alert. Modify if needed for section 508 compliance
    /// </summary>
    private void RenderStartUpMessage(bool IsSaveSuccessMessage) {
        StringBuilder sb = new StringBuilder();
        string Message = CreateStartUpMessage(IsSaveSuccessMessage);

        if (Message != string.Empty) {
            HiddenField HiddenFieldShowSaveMessage = this.Master.FindControl("HiddenFieldShowSaveMessage") as HiddenField;
            if (HiddenFieldShowSaveMessage != null)
            {
                HiddenFieldShowSaveMessage.Value = "1";
            }           

            HiddenField HiddenFieldSaveMessage = this.Master.FindControl("HiddenFieldSaveMessage") as HiddenField;
            if (HiddenFieldSaveMessage != null)
            {
                HiddenFieldSaveMessage.Value = Message;
            }            
        }
    }

    #endregion Private Methods

    protected void manager_BOSaveSuccess(object sender, BaseBO.BOSaveSuccessEventArgs e) {
        if (!_errorOnSavedReceived) {
            BusinessObjectSaveEventReceived = true;
        }
        IsSaveSuccess = (e.SaveStatusArg == BaseBO.SaveStatus.SaveSuccess);
    }

    #region CCOW

    private void CheckNeedStationDivision()
    {
        if (getCurrentServiceToUse() == "VIA" && string.IsNullOrEmpty(StationDivision))
        {
            Response.Redirect("StationDivisionAuthorization.aspx", true);
        }
    }

    protected string StationDivision
    {
        get
        {
            return Helpers.DeSerializSessionItems(Session["StationDivision"]) as string;
        }
        set
        {
            Session["StationDivision"] = Helpers.SerializSessionItemsObj(value);
        }
    }

    #endregion CCOW
}