﻿using System;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using Microsoft.Security.Application;

public partial class AdminSystemAvailability : BasePage {

    #region Member Variables and Overrides

    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    private RegistriesCommonManager _commonManager = new RegistriesCommonManager();
    private APPLICATION_STATUS _applicationStatus = new APPLICATION_STATUS();

    USER userEntry;
    UsersManager usersManager = new UsersManager();

    public override string TopMenuName() {
        return "Administration";
    }

    public override string MenuItemName() {
        return "System Availability";
    }

    public override string AppObjectCode() {
        return "MSSR SYSTEM AVAILABILITY";
    }

    #endregion

    /// <summary>
    /// Page_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        if (!IsPostBack) {
            LoadControlsFromObject();
        }

        if (RadioButtonListProcessFlag.SelectedValue != "0") {
            RequiredFieldValidatorTextBoxWarningMessage.Enabled = true;
        } else {
            RequiredFieldValidatorTextBoxWarningMessage.Enabled = false;
        }

        //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
        int? userID = Convert.ToInt32(Request.QueryString["id"]);
        HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

        //Check if the request is to create a new item
        //a new item page request is signified when the querystring parameter id equals zero or is not present
        if (userID == null || userID == 0) {
            //set userID to zero so that a default linq entity will be instantiated
            userID = 0;
        }

        //Create User Entity object and Set properties to state of form
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
    }

    /// <summary>
    /// gets user entry
    /// </summary>
    /// <param name="id"></param>
    protected void getEntry(int id) {
        userEntry = usersManager.SelectByID(_currentRegistry, id);

        //initial display panels
        PanelNoAccess.Visible = false;
        //PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null) {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id)) {
                PanelNoAccess.Visible = true;
            }
            //} else {
            //    PanelIdNotFound.Visible = true;
            //}
        } else {
            PanelObjectContent.Visible = true;
        }
    }

    #region Object/Form Mapping

    private void LoadControlsFromObject() {
        _applicationStatus = _commonManager.GetApplicationStatus(_currentRegistry);
        if (_applicationStatus != null) {
            RadioButtonListProcessFlag.SelectedValue = _applicationStatus.PROCESS_FLAG.ToString();
            TextBoxWarningMessage.Text = _applicationStatus.MESSAGE;

        }

    }

    private void LoadObjectFromControls() {
        _applicationStatus = _commonManager.GetApplicationStatus(_currentRegistry);
        if (_applicationStatus == null) {
            _applicationStatus = new APPLICATION_STATUS();
            _applicationStatus.PROCESS_FLAG = 0;
            _applicationStatus.STD_REGISTRY_ID = _commonManager.GetRegistryId(_currentRegistry);
            _applicationStatus.SetAsChangeTrackingRoot();
            _applicationStatus.SetAsInsertOnSubmit();
        } else {
            _applicationStatus.SetAsChangeTrackingRoot();
            _applicationStatus.SetAsNoChangeOnSubmit();
        }

        if (_applicationStatus.PROCESS_FLAG.ToString() != RadioButtonListProcessFlag.SelectedValue
            || _applicationStatus.MESSAGE != TextBoxWarningMessage.Text) {
            if (_applicationStatus.LINQEntityState != EntityState.New) {
                _applicationStatus.SetAsUpdateOnSubmit();
            }

            _applicationStatus.PROCESS_FLAG = Convert.ToInt32(RadioButtonListProcessFlag.SelectedValue);
            _applicationStatus.MESSAGE = Encoder.HtmlEncode(TextBoxWarningMessage.Text);

        }
    }

    #endregion

    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e) {
        LoadObjectFromControls();
        int returnStatus = _commonManager.Update(_applicationStatus);
        this.SuppressSaveMessage = false;
        this.IsSaveSuccess = (returnStatus >= 0);
        var master = (RegistryMaster)Master;
        master.SetDirtyFlag(false);

        Session.Remove("SkipWarning");
    }

    protected void ButtonClose_Click(object sender, EventArgs e) {
        Response.Redirect("AdminListUsers.aspx");
    }
    #endregion
}