﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Globalization;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MSSR.Security;
using AntiXssEnc = Microsoft.Security.Application;

public partial class AdminAddEditMedications : BasePage
{
    #region Override Methods

    public override string TopMenuName()
    {
        return "Administration";
    }
    public override string MenuItemName()
    {
        return "MSSR ADMIN EDIT MEDICATIONS";
    }
    public override string AppObjectCode()
    {
        return "MSSR ADMIN EDIT MEDICATIONS";
    }

    #endregion

    public int MedIdtoUpdate { get; set; }
    protected enum Status
    {
        AddSucceeded,
        AddFailed,
        AddDuplicate,
        UpdateSucceeded,
        UpdateFailed,
        UpdateDuplicate,
        MissingMed
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsUserInAdminRole())
        {
            Response.Redirect("error.aspx?id=100");
        }
        if (!IsPostBack)
        {
            InitializeMedicationReasonStoppedGridVw();
        }
    }
    protected void Delete_Medication(object sender, CommandEventArgs e)
    {
        int medId = Int32.Parse(e.CommandArgument.ToString());
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATIONs
                          where m.ID == medId
                          select m).First();
            if (result != null)
            {
                if (!IsMedicationBeingUsed(medId))
                {
                    dcContext.MSSR_MEDICATIONs.DeleteOnSubmit(result);
                    dcContext.MSSR_MEDICATION_TO_REASON_STOPPEDs.DeleteAllOnSubmit(
                        result.MSSR_MEDICATION_TO_REASON_STOPPEDs);
                    try
                    {
                        dcContext.SubmitChanges();
                    }
                    catch (Exception)
                    {
                        lblError.Text = "Deleting medication failed.";
                        lblError.Visible = true;
                    }
                }
            }
        }
        ResetMedSelectionFields();
    }
    protected void Update_Medication(object sender, CommandEventArgs e)
    {
        int medId = Int32.Parse(e.CommandArgument.ToString());
        hdnFldMedId.Value = e.CommandArgument.ToString();
        btnAddNewMedicationAndReasonStopped.Enabled = false;
        btnUpdateMedicationAndReasonStopped.Enabled = true;
        lblError.Text = string.Empty;
        PopulateMedicationFieldsForMedId(medId);
        PopulateMedicationToReasonStopForMedId(medId);
    }
    protected void PopulateMedicationFieldsForMedId(int medId)
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATIONs
                          where m.ID == medId
                          select m).First();
            if (result == null) return;
            txtNewMedicationName.Text = result.MEDICATION;
            txtNewMedicationHealthFactor.Text = result.HEALTH_FACTOR;
            chkBoxNewMedIsInterferonGroup.Checked = result.IS_INTERFERON_GROUP;
            chkBoxNewMedIsOtherGroup.Checked = Convert.ToBoolean(result.IS_OTHER_GROUP);
            chkBoxNewMedNumberOfDoses.Checked = result.ShowNumDosesTaken;
        }
    }
    protected void PopulateMedicationToReasonStopForMedId(int medId)
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATION_TO_REASON_STOPPEDs
                          where m.MSSR_MEDICATION_ID == medId
                          select m);
            foreach (var reasonStopped in result)
            {
                int reasonId = reasonStopped.MSSR_MEDICATION_REASON_STOPPED_ID;
                SetReasonStoppedSelectionFor(reasonId);
            }
        }
    }
    protected void SetReasonStoppedSelectionFor(int reasonId)
    {
        GridView reasonStoppedGridView = GridViewMedReasonStopped;
        foreach (GridViewRow row in reasonStoppedGridView.Rows)
        {
            if (row.RowType == DataControlRowType.DataRow)
            {
                var chkbox = (CheckBox)row.FindControl("chkBoxParentReasonStopped");
                var chkboxValue = (HiddenField)row.FindControl("hdnFldParentReasonStopped");
                var rbtnReasonStoppedSubListIntolerance =
                    (RadioButtonList)row.FindControl("rdbListReasonStoppedSubListIntolerance");
                var checkBoxListAdverse = (CheckBoxList)row.FindControl("chkbxLstReasonStoppedAdverse");
                if (reasonId == Int32.Parse(chkboxValue.Value))
                {
                    chkbox.Checked = true;
                }
                if (chkbox.Checked && ReasonStoppedHasSublist(reasonId))
                {
                    var listOfSubReasonPanel = (Panel)row.FindControl("pnlListOfSubReasonsStopped");
                    listOfSubReasonPanel.Enabled = true;
                    int[] listOfSubReasons = GetListOfSubReasonForMedication();
                    foreach (ListItem item in checkBoxListAdverse.Items)
                    {
                        item.Selected = listOfSubReasons.Contains(Int32.Parse(item.Value));
                    }
                    foreach (ListItem item in rbtnReasonStoppedSubListIntolerance.Items)
                    {
                        item.Selected = listOfSubReasons.Contains(Int32.Parse(item.Value));
                    }
                }
            }
        }
    }
    protected int[] GetListOfSubReasonForMedication()
    {
        int[] listOfSubReasons;
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            listOfSubReasons = (from m in dcContext.MSSR_MEDICATION_TO_REASON_STOPPEDs
                                where m.MSSR_MEDICATION_ID == Int32.Parse(hdnFldMedId.Value)
                                select m.MSSR_MEDICATION_REASON_STOPPED_ID).ToArray();
        }
        return listOfSubReasons;
    }
    protected void btnAddNewMedicationReasonStopped_Click(object sender, EventArgs e)
    {
        Page.Validate();
        if (Page.IsValid)
        {
            List<MSSR_MEDICATION_TO_REASON_STOPPED> mssrMedicationToReasonStoppeds = GetListOfReasonStopped();
            using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
            {
                var result = (from m in dcContext.MSSR_MEDICATIONs
                              where m.MEDICATION.Trim().ToLower() == txtNewMedicationName.Text.Trim().ToLower()
                              select m).FirstOrDefault();
                string medName = txtNewMedicationName.Text.Trim();
                if (result == null)
                {
                    MSSR_MEDICATION med = new MSSR_MEDICATION();
                    med.MEDICATION = txtNewMedicationName.Text.Trim();
                    med.HEALTH_FACTOR = txtNewMedicationHealthFactor.Text.Trim();
                    med.IS_INTERFERON_GROUP = chkBoxNewMedIsInterferonGroup.Checked;
                    med.IS_OTHER_GROUP = chkBoxNewMedIsOtherGroup.Checked;
                    med.ShowNumDosesTaken = chkBoxNewMedNumberOfDoses.Checked;
                    med.MSSR_MEDICATION_TO_REASON_STOPPEDs.AddRange(mssrMedicationToReasonStoppeds);

                    try
                    {
                        dcContext.MSSR_MEDICATIONs.InsertOnSubmit(med);
                        dcContext.SubmitChanges();

                        InitializeMedicationReasonStoppedGridVw();
                        ResetMedSelectionFields();
                        SetErorMsgStatus(medName, Status.AddSucceeded);
                    }
                    catch (Exception)
                    {
                        SetErorMsgStatus(medName, Status.AddFailed);
                    }
                }
                else
                {
                    SetErorMsgStatus(medName, Status.AddDuplicate);
                }
            }
        }
    }
    private void SetErorMsgStatus(string medName, Status msgCode)
    {
        switch (msgCode)
        {
            case Status.AddSucceeded:
                lblError.Text = string.Format("Medication with the name {0} added.", AntiXssEnc.Encoder.HtmlAttributeEncode(medName));
                break;
            case Status.AddFailed:
                lblError.Text = "Adding medication failed.";
                break;
            case Status.AddDuplicate:
                lblError.Text = string.Format("Medication with the name {0} already exists.", AntiXssEnc.Encoder.HtmlAttributeEncode(medName));
                break;
            case Status.UpdateSucceeded:
                lblError.Text = string.Format("Medication with the name {0} updated.", AntiXssEnc.Encoder.HtmlAttributeEncode(medName));
                break;
            case Status.UpdateDuplicate:
                lblError.Text = "Updating medication failed. Duplicate mediation name.";
                break;
            case Status.UpdateFailed:
                lblError.Text = "Updating medication failed.";
                break;
            case Status.MissingMed:
                lblError.Text = string.Format("Unable to find {0} Update failed.", AntiXssEnc.Encoder.HtmlAttributeEncode(medName));
                lblError.Visible = true;
                break;
        }
        lblError.Visible = true;
        lblError.Focus();

    }
    protected void btnUpdateMedicationAndReasonStopped_Click(object sender, EventArgs e)
    {
        Page.Validate();
        if (Page.IsValid)
        {
            List<MSSR_MEDICATION_TO_REASON_STOPPED> mssrMedicationToReasonStoppeds = GetListOfReasonStopped();
            using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
            {
                string medName = txtNewMedicationName.Text.Trim();
                int medId = Int32.Parse(hdnFldMedId.Value);
                var result = (from m in dcContext.MSSR_MEDICATIONs
                              where m.ID == medId
                              select m).First();
                if (result != null)
                {
                    var exists = dcContext.MSSR_MEDICATIONs.Any(m => m.MEDICATION.ToLower() == txtNewMedicationName.Text.Trim().ToLower() && m.ID != medId);
                    if (!exists)
                    {
                        result.MEDICATION = txtNewMedicationName.Text.Trim();
                        result.HEALTH_FACTOR = txtNewMedicationHealthFactor.Text.Trim();
                        result.IS_INTERFERON_GROUP = chkBoxNewMedIsInterferonGroup.Checked;
                        result.IS_OTHER_GROUP = chkBoxNewMedIsOtherGroup.Checked;
                        result.ShowNumDosesTaken = chkBoxNewMedNumberOfDoses.Checked;

                        dcContext.MSSR_MEDICATION_TO_REASON_STOPPEDs.DeleteAllOnSubmit(result.MSSR_MEDICATION_TO_REASON_STOPPEDs);
                        result.MSSR_MEDICATION_TO_REASON_STOPPEDs.AddRange(mssrMedicationToReasonStoppeds);
                        try
                        {
                            dcContext.SubmitChanges();
                            InitializeMedicationReasonStoppedGridVw();
                            ResetMedSelectionFields();
                            btnUpdateMedicationAndReasonStopped.Enabled = false;
                            btnAddNewMedicationAndReasonStopped.Enabled = true;
                            SetErorMsgStatus(medName, Status.UpdateSucceeded);
                        }
                        catch (Exception)
                        {
                            SetErorMsgStatus(medName, Status.UpdateFailed);
                        }
                    }
                    else
                    {
                        SetErorMsgStatus(medName, Status.UpdateDuplicate);
                    }
                }
                else
                {
                    SetErorMsgStatus(medName, Status.MissingMed);
                }
            }
        }
    }
    private bool ReasonStoppedHasSublist(int reasonStoppedId)
    {
        return (reasonStoppedId == 2 || reasonStoppedId == 6);
    }
    private void ResetMedSelectionFields()
    {
        txtNewMedicationHealthFactor.Text = string.Empty;
        txtNewMedicationName.Text = string.Empty;
        chkBoxNewMedIsInterferonGroup.Checked = false;
        chkBoxNewMedIsOtherGroup.Checked = false;
        chkBoxNewMedNumberOfDoses.Checked = false;
        lblError.Text = string.Empty;

        gvMedications.DataBind();
        InitializeMedicationReasonStoppedGridVw();
    }
    protected void GridViewMedReasonStopped_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType != DataControlRowType.DataRow) return;
        var reasonCode = (int)DataBinder.Eval(e.Row.DataItem, "ID");
        var rdbListIntoleranceSubList = (RadioButtonList)e.Row.FindControl("rdbListReasonStoppedSubListIntolerance");
        var chkboxListAdverse = (CheckBoxList)e.Row.FindControl("chkbxLstReasonStoppedAdverse");
        var pnlpnlTitleHeader = (Panel)e.Row.FindControl("pnlTitleHeader");
        var pnlExtensionsTitle = (Panel)e.Row.FindControl("pnlExtensionsTitle");
        if (reasonCode != 2) return;
        SetListOfSubReasonStopByReasonId(reasonCode, rdbListIntoleranceSubList);
        SetListOfSubReasonStopByReasonId(reasonCode, chkboxListAdverse);
        pnlpnlTitleHeader.Visible = true;
        pnlExtensionsTitle.Visible = true;
    }
    protected void SetListOfSubReasonStopByReasonId(int reasonId, CheckBoxList chkBoxListControlToBind)
    {
        if (reasonId != 2) return;
        PopulateIntolerancetoMed(chkBoxListControlToBind);
        if (chkBoxListControlToBind.ID == "chkbxLstReasonStoppedAdverse")
        {
            PopulateReasonStoppedAdverse(chkBoxListControlToBind);
        }
    }
    protected void SetListOfSubReasonStopByReasonId(int reasonId, RadioButtonList rdbListControlToBind)
    {
        PopulateIntolerancetoMed2(rdbListControlToBind);
    }
    protected List<MSSR_MEDICATION_TO_REASON_STOPPED> GetListOfReasonStopped()
    {
        List<MSSR_MEDICATION_TO_REASON_STOPPED> listOfReasonStopped = new List<MSSR_MEDICATION_TO_REASON_STOPPED>();
        var grdViewLisOfReasonStopped = GridViewMedReasonStopped;
        foreach (GridViewRow row in grdViewLisOfReasonStopped.Rows)
        {
            var chkBoxRow = (CheckBox)row.FindControl("chkBoxParentReasonStopped");
            var hdnField = (HiddenField)row.FindControl("hdnFldParentReasonStopped");
            var rbtnListReasonStoppedSubListIntolerance =
                (RadioButtonList)row.FindControl("rdbListReasonStoppedSubListIntolerance");
            var checkBoxListAdverse = (CheckBoxList)row.FindControl("chkbxLstReasonStoppedAdverse");
            if (!chkBoxRow.Checked) continue;
            MSSR_MEDICATION_TO_REASON_STOPPED reasonStoppedParent = new MSSR_MEDICATION_TO_REASON_STOPPED();
            int reasonStoppedId;
            bool isvalid = Int32.TryParse(hdnField.Value.ToString(CultureInfo.InvariantCulture), out reasonStoppedId);
            reasonStoppedParent.MSSR_MEDICATION_REASON_STOPPED_ID = reasonStoppedId;
            listOfReasonStopped.Add(reasonStoppedParent);

            if (!isvalid || !ReasonStoppedHasSublist(reasonStoppedId)) continue;
            foreach (ListItem item in rbtnListReasonStoppedSubListIntolerance.Items)
            {
                if (item.Selected)
                {
                    MSSR_MEDICATION_TO_REASON_STOPPED reasonStoppedSub = new MSSR_MEDICATION_TO_REASON_STOPPED();
                    reasonStoppedSub.MSSR_MEDICATION_REASON_STOPPED_ID = Int32.Parse(item.Value);
                    listOfReasonStopped.Add(reasonStoppedSub);
                }
            }
            foreach (ListItem item in checkBoxListAdverse.Items)
            {
                if (item.Selected)
                {
                    MSSR_MEDICATION_TO_REASON_STOPPED reasonStoppedSub = new MSSR_MEDICATION_TO_REASON_STOPPED();
                    reasonStoppedSub.MSSR_MEDICATION_REASON_STOPPED_ID = Int32.Parse(item.Value);
                    listOfReasonStopped.Add(reasonStoppedSub);
                }
            }
        }
        return listOfReasonStopped;
    }
    protected void InitializeMedicationReasonStoppedGridVw()
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATION_REASON_STOPPEDs
                          where m.PARENT_ID == 0 && m.Extention_Parent_ID == 0
                          select m);
            GridViewMedReasonStopped.DataSource = result;
            GridViewMedReasonStopped.DataBind();
        }
    }
    protected void PopulateIntolerancetoMed(CheckBoxList chkBoxListControlToBind)
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATION_REASON_STOPPEDs
                          where m.Extention_Parent_ID == 2
                          select m);
            chkBoxListControlToBind.DataSource = result;
            chkBoxListControlToBind.DataBind();
        }
    }
    protected void PopulateIntolerancetoMed2(RadioButtonList rblListControlToBind)
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATION_REASON_STOPPEDs
                          where m.Extention_Parent_ID == 2
                          select m);
            rblListControlToBind.DataSource = result;
            rblListControlToBind.DataBind();
        }
    }
    protected void PopulateReasonStoppedAdverse(CheckBoxList chkBoxListControlToBind)
    {
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            var result = (from m in dcContext.MSSR_MEDICATION_REASON_STOPPEDs
                          where m.PARENT_ID == 2
                          select m);
            chkBoxListControlToBind.DataSource = result;
            chkBoxListControlToBind.DataBind();
        }
    }
    protected void ChkBoxParentReasonStopped_OnCheckedChanged(object sender, EventArgs e)
    {
        GridView reasonStoppedGridView = GridViewMedReasonStopped;
        foreach (GridViewRow row in reasonStoppedGridView.Rows)
        {
            if (row.RowType != DataControlRowType.DataRow) continue;
            var chkbox = (CheckBox)row.FindControl("chkBoxParentReasonStopped");
            var chkboxValue = (HiddenField)row.FindControl("hdnFldParentReasonStopped");
            var listOfSubReasonPanel = (Panel)row.FindControl("pnlListOfSubReasonsStopped");
            if (chkboxValue.Value != "2") continue;
            listOfSubReasonPanel.Enabled = chkbox.Checked;

            if (chkboxValue.Value == "2" && chkbox.Checked == false)
            {
                var chkbxRsSbLstAdvrs = (CheckBoxList)row.FindControl("chkbxLstReasonStoppedAdverse");
                foreach (ListItem item in chkbxRsSbLstAdvrs.Items)
                {
                    item.Selected = false;
                }
                var rdbtnRsSbLstIntolerance =
                    (RadioButtonList)row.FindControl("rdbListReasonStoppedSubListIntolerance");
                rdbtnRsSbLstIntolerance.SelectedIndex = -1;
            }
        }
    }
    protected void btnCancelAddUpdate_Click(object sender, EventArgs e)
    {
        if (btnUpdateMedicationAndReasonStopped.Enabled)
        {
            btnUpdateMedicationAndReasonStopped.Enabled = false;
            btnAddNewMedicationAndReasonStopped.Enabled = true;
            ResetMedSelectionFields();
            InitializeMedicationReasonStoppedGridVw();
        }
        else
        {
            ResetMedSelectionFields();
            InitializeMedicationReasonStoppedGridVw();
        }
    }
    protected void IsMedicationDeleteAllowed()
    {
        GridView medGridView = gvMedications;
        foreach (GridViewRow row in medGridView.Rows)
        {
            if (row.RowType != DataControlRowType.DataRow) continue;
            var imgbtnDeleteMed = (ImageButton)row.FindControl("imgBtnDeleteMedications");
            var hdnFldMedIdToDelete = (HiddenField)row.FindControl("MEDICATION_ID");
            int medId = Int32.Parse(hdnFldMedIdToDelete.Value);

            if (!IsMedicationBeingUsed(medId)) continue;
            imgbtnDeleteMed.Enabled = false;
            imgbtnDeleteMed.ToolTip = "Medication is being used and can't be deleted.";
            imgbtnDeleteMed.Style.Add("cursor","not-allowed");
        }

    }
    protected bool IsMedicationBeingUsed(int medId)
    {
        bool isBeingUsed = false;
        using (MSSRDataClassesDataContext dcContext = new MSSRDataClassesDataContext())
        {
            isBeingUsed = dcContext.MSSR_PATIENT_MEDICATIONs.Any(m => m.MEDICATION_ID == medId);
        }
        return isBeingUsed;
    }
    protected void gvMedications_DataBound(object sender, EventArgs e)
    {
        IsMedicationDeleteAllowed();
    }

    private bool IsUserInAdminRole()
    {
        bool isUserInSurveyEditRole = this.CurrentUser.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR);
        return isUserInSurveyEditRole;
    }
}
