﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" MaintainScrollPositionOnPostback="true"
    CodeFile="AdminAddEditMedications.aspx.cs" Inherits="AdminAddEditMedications" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:HiddenField ID="HiddenFieldSortExpression" runat="server" Value="" Visible="false" />
    <asp:HiddenField ID="HiddenFieldSortDirection" runat="server" Value="" Visible="false" />
    <asp:HiddenField ID="hdnFldMedId" runat="server" Value="" Visible="false" />
    <asp:Label runat="server" ForeColor="#FF0000" ID="lblError" />
    <asp:Label runat="server" ForeColor="#FF0000" ID="lblStatus" />
     <div class="excludeSaveWarnings">
        <div style="padding-top: 10px; padding-bottom: 10px; padding-left: 10px">
            <div style="padding-bottom: 10px; height: 20px; width: 60%; background-color: #37539D">
                <div style="padding-left: 10px; padding-top: 5px">
                    <label style="color: #ffffff" title="List of Current Medications.">
                        Current Medications</label>
                </div>
            </div>
            <div>
                <asp:GridView ID="gvMedications" runat="server" AllowSorting="True" AutoGenerateColumns="False" Caption="List of Medications."
                    DataKeyNames="ID" EmptyDataText="No Medications" Width="60%" DataSourceID="LDSMedications"
                    AllowPaging="True" PageSize="20" OnDataBound="gvMedications_DataBound">
                    <AlternatingRowStyle BackColor="#FFFFE8" />
                    <Columns>
                        <asp:BoundField DataField="MEDICATION" HeaderText="MEDICATION" SortExpression="MEDICATION" AccessibleHeaderText="MEDICATION Name"
                            ReadOnly="True" />
                        <asp:BoundField DataField="HEALTH_FACTOR" HeaderText="HEALTH FACTOR" SortExpression="HEALTH_FACTOR" AccessibleHeaderText="HEALTH FACTOR"
                            ReadOnly="True" />
                        <asp:TemplateField HeaderText="INTERFERON GROUP" SortExpression="IS_INTERFERON_GROUP" AccessibleHeaderText="INTERFERON GROUP">
                            <HeaderStyle Width="180" />
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <%# (Boolean.Parse(Eval("IS_INTERFERON_GROUP").ToString())) ? "Yes" : "No"%></ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField>
                            <ItemTemplate>
                                <asp:ImageButton ID="imgBtnDeleteMedications" OnClientClick=" return confirm('Please confirm delete.')"
                                    runat="server" OnCommand="Delete_Medication" ToolTip="Click to Delete Medication."
                                    CommandName="DELETE" CommandArgument='<%#AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("ID"))) %>' ImageUrl="images/DeleteHS.png" />
                                <asp:ImageButton ID="imgBtnUpdateMedications" OnCommand="Update_Medication" CommandName="UPDATE" Enabled="False"
                                    ToolTip="Click to Update Medication.- Medication not updatable" CommandArgument='<%#AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("ID"))) %>' ImageUrl="images/EditTableHS.png"
                                    runat="server" />
                                <asp:HiddenField runat="server" ID="MEDICATION_ID" Value='<%#AntiXssEnc.Encoder.HtmlAttributeEncode(Convert.ToString(Eval("ID"))) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <SelectedRowStyle BackColor="#D7D6D7"></SelectedRowStyle>
                </asp:GridView>
            </div>
        </div>
        <asp:LinqDataSource ID="LDSMedications" runat="server" ContextTypeName="MSSRDataClassesDataContext"
            OrderBy="MEDICATION" TableName="MSSR_MEDICATIONs" EnableDelete="True" EnableUpdate="True">
        </asp:LinqDataSource>
        <div style="padding-left: 10px">
            <div id="divAddReason" style="padding-top: 10px">
                <div style="padding-bottom: 10px; height: 20px; width: 60%; background-color: #37539D">
                    <div style="padding-left: 10px; padding-top: 5px">
                        <label style="color: #ffffff" title="Add New Medication and Reason Stopped Section.">
                            Add New Medication and Reason Stopped</label></div>
                </div>
                <div style="padding-left: 10px; padding-top: 10px">
                    <table>
                        <tr>
                            <td>
                                <label for="txtNewMedicationName">Medication</label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtNewMedicationName" runat="server" Width="200px" ToolTip="Enter Medication Name." />
                                <asp:RequiredFieldValidator ID="RFVMedication" runat="server" ValidationGroup="OnAdd"
                                    Width="175px" ControlToValidate="txtNewMedicationName" ErrorMessage="Medication is required"
                                    TabIndex="5" SetFocusOnError="true"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="txtNewMedicationHealthFactor">Health Factor</label>
                            </td>
                            <td>
                                <asp:TextBox ID="txtNewMedicationHealthFactor" runat="server" Width="200px" ToolTip="Enter Medication Heatlth Factor." />
                                <asp:RequiredFieldValidator ID="RFVHealthFactor" runat="server" ValidationGroup="OnAdd"
                                    Width="175px" ControlToValidate="txtNewMedicationHealthFactor" ErrorMessage="Health Factor is required"
                                    TabIndex="15" SetFocusOnError="true"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="chkBoxNewMedIsInterferonGroup">Is Interferon Group?</label>
                            </td>
                            <td>
                                <asp:CheckBox ID="chkBoxNewMedIsInterferonGroup" ToolTip="Is Interferon Group" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="chkBoxNewMedIsOtherGroup">Is Other Group?</label>
                            </td>
                            <td>
                                <asp:CheckBox ID="chkBoxNewMedIsOtherGroup" ToolTip="Is Other Group" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label for="chkBoxNewMedNumberOfDoses">Show Number of Doses</label>
                            </td>
                            <td>
                                <asp:CheckBox ID="chkBoxNewMedNumberOfDoses" ToolTip="Show Number of Doses" runat="server" />
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div style="padding-bottom: 50px; padding-left: 10px">
                
                <asp:GridView ID="GridViewMedReasonStopped" runat="server" AutoGenerateColumns="false" Caption="Reason Stopped"
                    Width="59%" EmptyDataText="No values available for selection." OnRowDataBound="GridViewMedReasonStopped_RowDataBound">
                    <Columns>
                        <asp:TemplateField ItemStyle-VerticalAlign="Top">
                            <ItemTemplate>
                                <asp:CheckBox ID="chkBoxParentReasonStopped" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Eval("REASON_STOPPED").ToString()) %>'
                                    OnCheckedChanged="ChkBoxParentReasonStopped_OnCheckedChanged" AutoPostBack="True"
                                    runat="server" />
                                <asp:HiddenField ID="hdnFldParentReasonStopped" Value='<%#Eval("ID") %>' runat="server" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField>
                            <ItemTemplate>
                                <asp:Panel ID="pnlListOfSubReasonsStopped" runat="server" Enabled="False">
                                    <span></span>
                                    <asp:Panel runat="server" ID="pnlExtensionsTitle" Visible="False" Enabled="False">
                                        <div style="padding-top: 5px; padding-left: 3px; height: 20px; color: white; background-color: #FFFFE8;
                                            font-size: small; font-family: Verdana">
                                            <asp:Label runat="server" ForeColor="Black" Font-Bold="true" Text="These are “Extensions”" ToolTip="These are Extensions"
                                                ID="lblExtensionsTitle" /></div>
                                    </asp:Panel>
                                    <div style="padding-bottom: 5px; font-weight: normal">
                                        <asp:RadioButtonList ID="rdbListReasonStoppedSubListIntolerance" runat="server" DataTextField="REASON_STOPPED"
                                            DataValueField="ID" />
                                    </div>
                                    <asp:Panel runat="server" ID="pnlTitleHeader" Visible="False" Enabled="False">
                                        <div style="padding-top: 5px; padding-left: 3px; height: 20px; color: white; background-color: #FFFFE8;
                                            font-size: small; font-family: Verdana">
                                            <asp:Label runat="server" ForeColor="Black" Font-Bold="true" Text="Adverse Event" ToolTip="Adverse Event Section"
                                                ID="lblAdverseEvent" /></div>
                                    </asp:Panel>
                                    <div style="padding-bottom: 10px; padding-top: 10px">
                                        <asp:CheckBoxList ID="chkbxLstReasonStoppedAdverse" runat="server" DataTextField="REASON_STOPPED"
                                            DataValueField="ID" />
                                    </div>
                                </asp:Panel>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
            </div>
            <div>
                <asp:Button ID="btnAddNewMedicationAndReasonStopped" ToolTip="Click to Add New Medication"
                    runat="server" CommandName="AddNewMed" Text="Add" OnClick="btnAddNewMedicationReasonStopped_Click" />
                <asp:Button ID="btnUpdateMedicationAndReasonStopped" ToolTip="Click to Update Medication"
                    Enabled="False" runat="server" Text="Update" CommandName="UpdateMed" OnClick="btnUpdateMedicationAndReasonStopped_Click" />
                <asp:Button ID="btnCancelAddUpdate" runat="server" Text="Cancel" ToolTip="Click to Cancel Medication Update"
                    OnClick="btnCancelAddUpdate_Click" />
            </div>
        </div>
    </div>
</asp:Content>
