﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="MedicationSelection.ascx.cs"
    Inherits="controls_MedicationSelection" %>
<%@ Register TagPrefix="MSSR" TagName="MonthYearSelector" Src="~/controls/MonthYearSelector.ascx" %>
<div id="divMedContainer" style="padding-left: 10px;">
    <asp:Label ID="lblMedicationName" runat="server" CssClass="medinputs"></asp:Label>
    <br />
    <!-- Radio Button List: bound to USED_STATUS    OnSelectedIndexChanged="rblUseStatus_SelectedIndexChanged"   -->
    <asp:RadioButtonList ID="rblUseStatus" runat="server" RepeatDirection="Vertical"  Font-Size="5px" Font-Bold="false"
        DataTextField="STATUS" DataValueField="ID" ValidationGroup="OnSave"
        onclick="ShowHideCurrentPastUse(this) ">
    </asp:RadioButtonList>
    <!--Question Use Status Required Validator-->
    <asp:RequiredFieldValidator ID="RequiredFieldValidatorUseStatus" runat="server" ControlToValidate="rblUseStatus"
        ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Use Status Selection is required."></asp:RequiredFieldValidator>
    <asp:CustomValidator ID="RequiredFieldValidatorCurPastUseAdvrs" runat="server" Display="Dynamic"
        ValidationGroup="OnSave" ErrorMessage="Past use, Current use or Adverse event selection
        is required." ControlToValidate="rblUseStatus" OnServerValidate="ValidatePastUseCurrentUseAdverse" />
    <!-- Panel for Current Use sub-questions -->
    <asp:Panel ID="pnlCurrentPastUse" runat="server" GroupingText=" ">
        <br />
        <div style="padding-left: 20px;">
            <asp:Panel ID="pnlOtherDMT" runat="server" Visible="false">
                <asp:Label ID="LabelFortxtOtherDMTName" AssociatedControlID="txtOtherDMTName" runat="server">Name of Medicine:</asp:Label>
                <asp:TextBox ID="txtOtherDMTName" runat="server" />
                <asp:Label ID="Label7" runat="server" Font-Italic="true" Font-Size="Smaller">
                            &nbsp;&nbsp;(50 chars max)</asp:Label><br />
                <br />
            </asp:Panel>
            <!-- Current Use  OnCheckedChanged="chkBoxCurrentUse_CheckedChanged" AutoPostBack="true" -->
            <asp:CheckBox ID="chkBoxCurrentUse" runat="server" Text="Current Therapy" onclick="CurrentUseClicked(this)" /><br />
            <asp:Panel ID="pnlCurrentTherapy" runat="server">
                <div style="padding-left: 20px;">
                    <asp:Label ID="LabelForCurrentDispensingPharmacy" AssociatedControlID="rblCurrentDispensingPharmacy"
                        runat="server">Dispensing Pharmacy:</asp:Label><br />
                    <asp:RadioButtonList ID="rblCurrentDispensingPharmacy" runat="server" RepeatDirection="Vertical"
                        DataTextField="PHARMACY" DataValueField="ID" CssClass="" ValidationGroup="OnSave">
                    </asp:RadioButtonList>
                    <br />
                    <MSSR:MonthYearSelector ID="mysCurrentApproximateDateStarted" runat="server"></MSSR:MonthYearSelector>
                    <br />
                    <br />
                    <asp:Panel ID="pnlCurrentNumberOfDosesTaken" runat="server" Visible="false">
                        <asp:Label ID="LabelFortxtCurrentNumberOfDosesTaken" AssociatedControlID="txtCurrentNumberOfDosesTaken"
                            runat="server">Number of doses taken:</asp:Label>
                        <asp:TextBox ID="txtCurrentNumberOfDosesTaken" runat="server" MaxLength="50" />
                        <asp:Label ID="Label4" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(50 chars max)</asp:Label><br />
                        <br />
                    </asp:Panel>
                </div>
            </asp:Panel>
            <br />
            <!-- Past Use   OnCheckedChanged="chkBoxPastUse_CheckedChanged" AutoPostBack="true" -->
            <asp:CheckBox ID="chkBoxPastUse" runat="server" Text="Past Use" onclick="PastUseClicked(this)" /><br />
            <asp:Panel ID="pnlPastTherapy" runat="server">
                <div style="padding-left: 20px;">
                    <asp:Label ID="LabelForPastDispensingPharmacy" AssociatedControlID="rblPastDispensingPharmacy"
                        runat="server">Dispensing Pharmacy:</asp:Label><br />
                    <asp:RadioButtonList ID="rblPastDispensingPharmacy" runat="server" RepeatDirection="Vertical"
                        DataTextField="PHARMACY" DataValueField="ID" CssClass="" ValidationGroup="OnSave">
                    </asp:RadioButtonList>
                    <br />
                    <div>
                    <div style="padding-left:5px"><MSSR:MonthYearSelector ID="mysPastDateStarted" runat="server"></MSSR:MonthYearSelector></div>
                    
                    <div style="padding-left:5px"><MSSR:MonthYearSelector ID="mysPastDateStopped" runat="server"></MSSR:MonthYearSelector></div>
                        <asp:CustomValidator ID="CustomValidatorMedStartStopDate" OnServerValidate="ValidatePastUseMedStartStopDate" runat="server"></asp:CustomValidator>
</div>
                    <asp:Panel ID="pnlPastNumberOfDosesTaken" runat="server" Visible="false">
                        <br />
                        <asp:Label ID="LabelFortxtPastNumberOfDosesTaken" AssociatedControlID="txtPastNumberOfDosesTaken"
                            runat="server">Number of doses taken:</asp:Label>
                        <asp:TextBox ID="txtPastNumberOfDosesTaken" runat="server" MaxLength="50" />
                        <asp:Label ID="Label3" runat="server" Font-Italic="true" Font-Size="Smaller">
                                    &nbsp;&nbsp;(50 chars max)</asp:Label><br />
                        <br />
                    </asp:Panel>
                    <!-- OnSelectedIndexChanged="rblPastReasonsStopped_SelectedIndexChanged"  -->
                    <asp:Label ID="LabelForPastReasonStopped" AssociatedControlID="rblPastReasonStopped"
                        runat="server">Reason Stopped:</asp:Label><br />
                    <asp:RadioButtonList ID="rblPastReasonStopped" runat="server" RepeatDirection="Vertical"
                        DataTextField="REASON_STOPPED" DataValueField="ID" ValidationGroup="OnSave" onclick="ReasonsStoppedClicked(this)">
                    </asp:RadioButtonList>
                    <asp:Panel ID="pnlSignificantAdverseEventDescription" runat="server">
                        <asp:Label ID="LabelForSignificantAdverseEventDescription" AssociatedControlID="txtSignificantAdverseEventDescription"
                            runat="server">Significant Adverse Event Description:</asp:Label>
                        <asp:TextBox ID="txtSignificantAdverseEventDescription" runat="server" MaxLength="75"
                            Width="350px" />
                        <asp:Label ID="txtSignificantAdverseEventDescriptionSize" runat="server" Font-Italic="true"
                            Font-Size="Smaller">
                                &nbsp;&nbsp;(75 chars max)</asp:Label>
                    </asp:Panel>
                    <asp:Panel ID="pnlOtherReasonStopped" runat="server">
                        <asp:Label ID="lblOtherReasonStopped" AssociatedControlID="txtOtherReasonStoppedDescription"
                            runat="server">Other Reason Stopped Description:</asp:Label>
                        <asp:TextBox ID="txtOtherReasonStoppedDescription" runat="server" MaxLength="75"
                            Width="350px" />
                        <asp:Label ID="Label2" runat="server" Font-Italic="true" Font-Size="Smaller">
                                &nbsp;&nbsp;(75 chars max)</asp:Label>
                    </asp:Panel>
                </div>
            </asp:Panel>
            <br />
            <!-- Adverse Events   OnCheckedChanged="chkBoxAdverseEvents_CheckedChanged" AutoPostBack="true" -->
            <asp:CheckBox ID="chkBoxAdverseEvents" runat="server" Text="Adverse Events" onclick="AdverseEventsClicked(this)" /><br />
            <asp:Panel ID="pnlAdverseEvents" runat="server">
                <div style="padding-left: 20px;">
                    <!-- Adverse events sub list -->
                    <asp:RadioButtonList ID="rblAdverseEvents" runat="server" RepeatDirection="Vertical"
                        DataTextField="REASON_STOPPED" DataValueField="ID" ValidationGroup="OnSave">
                    </asp:RadioButtonList>
                    <asp:Label ID="lblAdverseEvents" AssociatedControlID="txtAdverseEventsDescription"
                        runat="server">Adverse Events Description:</asp:Label>
                    <asp:TextBox ID="txtAdverseEventsDescription" runat="server" MaxLength="75" Width="350px" />
                    <asp:Label ID="txtAdverseEventsDescriptionSize" runat="server" Font-Italic="true"
                        Font-Size="Smaller">
                                &nbsp;&nbsp;(75 chars max)</asp:Label>
                </div>
            </asp:Panel>
            <br />
        </div>
        <!-- SJC -->

        
        <!-- CardioTox -->
        <asp:Panel ID="pnlCardiotox" runat="server" Visible="false" Style="margin-left: 12px;">
            <asp:Label ID="LabelForQCardioTox" runat="server" AssociatedControlID="rblQCardioTox"
                SkinID="DataLabel" TabIndex="2060">
            </asp:Label>
            <asp:RadioButtonList ID="rblQCardioTox" runat="server" RepeatDirection="Vertical"
                DataSourceID="ObjectDataSourceQCardioTox" TabIndex="2070" DataTextField="CHOICE_TEXT"
                DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave"
                OnClick="ShowHideQuestionQCardioTox()">
            </asp:RadioButtonList>
            <!--Question CardioTox Object Data Source-->
            <asp:ObjectDataSource ID="ObjectDataSourceQCardioTox" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode"
                        Type="String" />
                    <asp:ControlParameter ControlID="HiddenQCardioTox" Direction="Input" Name="questionNumber"
                        Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <!--Question CardioTox : Question Number-->
            <asp:HiddenField ID="HiddenQCardioTox" runat="server" Visible="false" Value="CardioTox" />
            <!-- Cardio Date Text for QCardioTox -->
            <asp:Panel ID="pnlQCardioToxYes" runat="server">
                <div style="padding: 5px; padding-left: 25px;">
                    <MSSR:MonthYearSelector ID="mysQCardioToxYes" runat="server"></MSSR:MonthYearSelector>
                    <br />
                    <asp:CheckBox ID="cbQCardioToxDateUnknown" runat="server" OnClick="UnsetQCardioToxDate()"
                        TabIndex="2095" />
                </div>
                <br />
            </asp:Panel>
        </asp:Panel>
    </asp:Panel>
</div>
