﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using ASP;
using MSSREnh;
using Telerik.Web.UI;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Web;
using System.Transactions;




public partial class SurveyEdit : BaseMSSRInstrumentPage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
    //private SurveyViewManager surveyManager = new SurveyViewManager(_user);
    protected MSATEditViewModel MsatEditViewModel;
    private List<STD_QUESTION> _questionList = new List<STD_QUESTION>();
    protected int SurveyTypeId = 30;
    SURVEY _survey;   // the root object in the Survey set
    //SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey
    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();
    //controls_Medications mitoxantroneControl;
    public int MedicationId { get; set; }
    public string HealthFactorName { get; set; }
    public Guid PatientMedicationId { get; set; }
    public UserAccountManager CurrentUser
    {
        get
        {
            return _user;
        }
    }
    public PatientMedicationRequest MedRequest
    {
        get
        {
            if (ViewState["msatMedRequest"] != null)
            {
                return (PatientMedicationRequest)ViewState["msatMedRequest"];
            }
            else
            {
                ViewState["msatMedRequest"] = new PatientMedicationRequest();
                return (PatientMedicationRequest)ViewState["msatMedRequest"];
            }
        }
        set
        {
            if (ViewState["msatMedRequest"] == null)
            {
                ViewState["msatMedRequest"] = new PatientMedicationRequest();
            }
            ViewState["msatMedRequest"] = value;
        }
    }
    public CardioTox CardioToxMed
    {
        get
        {
            if (ViewState["msatCardioToxMed"] != null)
            {
                return (CardioTox)ViewState["msatCardioToxMed"];
            }
            else
            {
                //ViewState["msatCardioToxMed"] = new CardioTox();
                return null;// (CardioTox)ViewState["msatCardioToxMed"];
            }
        }
        set
        {
            //if (ViewState["msatCardioToxMed"] == null)
            //{
            //    ViewState["msatCardioToxMed"] = new CardioTox();
            //}
            ViewState["msatCardioToxMed"] = value;
        }
    }
    public string IsCardioToxChanged
    {
        get
        {
            if (ViewState["msatCardioToxChanged"] != null)
            {
                return ViewState["msatCardioToxChanged"].ToString();
            }
            else
            {
                return string.Empty;
            }

        }
        set
        {
            ViewState["msatCardioToxChanged"] = value;
        }

    }
    public CardioToxSurveyResult CardioToxMedSurResult
    {
        get
        {
            if (ViewState["msatCardioToxSurveyResult"] != null)
            {
                return (CardioToxSurveyResult)ViewState["msatCardioToxSurveyResult"];
            }
            else
            {
                //ViewState["msatCardioToxSurveyResult"] = new CardioToxSurveyResult();
                return null;// (CardioToxSurveyResult)ViewState["msatCardioToxSurveyResult"];
            }
        }
        set
        {
            //if (ViewState["msatCardioToxSurveyResult"] == null)
            //{
            //    ViewState["msatCardioToxSurveyResult"] = new CardioToxSurveyResult();
            //}
            ViewState["msatCardioToxSurveyResult"] = value;
        }
    }
    public List<MssrPatientMedication> PatientMedications
    {
        get
        {
            if (Session["MsatePatientMedications"] != null)
            {
                // string patmeds = (string)Session["MsatePatientMedications"];
                List<MssrPatientMedication> listofMeds = Helpers.DeSerializPatientMedications(Session["MsatePatientMedications"]);
                return listofMeds;
            }
            else
            {
                List<MssrPatientMedication> lstPatMeds = new List<MssrPatientMedication>();
                Session["MsatePatientMedications"] = Helpers.SerializePatientMedications(lstPatMeds);
                return lstPatMeds;
            }
        }

        set
        {
            if (Session["MsatePatientMedications"] == null)
            {
                List<MssrPatientMedication> lstPatMeds = new List<MssrPatientMedication>();
                Session["MsatePatientMedications"] = Helpers.SerializePatientMedications(lstPatMeds);
            }
            Session["MsatePatientMedications"] = Helpers.SerializePatientMedications(value);
        }

    }    
    public string MedicationNameAdd
    {
        get
        {
            if (ViewState["msatCardioToxMedToAdd"] != null)
            {
                return (string)ViewState["msatCardioToxMedToAdd"];
            }
            else
            {
                ViewState["msatCardioToxMedToAdd"] = String.Empty;
                return (string)ViewState["msatCardioToxMedToAdd"];
            }
        }
        set
        {
            ViewState["msatCardioToxMedToAdd"] = value;
        }
    }    

    public CurrentStatusDisplay CurrentStatus
    {
        get
        {
            if (Session["MsatECurrentStatus"] != null)
            {
                return (CurrentStatusDisplay)Session["MsatECurrentStatus"];
            }
            else
            {
                Session["MsatECurrentStatus"] = new CurrentStatusDisplay();
                return (CurrentStatusDisplay)Session["MsatECurrentStatus"];
            }
        }
        set
        {
            if (Session["MsatECurrentStatus"] == null)
            {
                Session["MsatECurrentStatus"] = new CurrentStatusDisplay();
            }
            Session["MsatECurrentStatus"] = value;
        }
    }
    public MssrAssessmentDisplay CurrentAssessmentHF
    {
        get
        {
            if (Session["MsatECurrentAssessmentHF"] != null)
            {
                return (MssrAssessmentDisplay)Session["MsatECurrentAssessmentHF"];
            }
            else
            {
                Session["MsatECurrentAssessmentHF"] = new MssrAssessmentDisplay();
                return (MssrAssessmentDisplay)Session["MsatECurrentAssessmentHF"];
            }
        }
        set
        {
            if (Session["MsatECurrentAssessmentHF"] == null)
            {
                Session["MsatECurrentAssessmentHF"] = new MssrAssessmentDisplay();
            }
            Session["MsatECurrentAssessmentHF"] = value;
        }
    }
    public MssrePatientDemDispaly patientDem
    {
        get
        {
            if (Session["MsatEpatientDem"] != null)
            {
                return (MssrePatientDemDispaly)Session["MsatEpatientDem"];
            }
            else
            {
                Session["MsatEpatientDem"] = new MssrePatientDemDispaly();
                return (MssrePatientDemDispaly)Session["MsatEpatientDem"];
            }
        }
        set
        {
            if (Session["MsatEpatientDem"] == null)
            {
                Session["MsatEpatientDem"] = new MssrePatientDemDispaly();
            }
            Session["MsatEpatientDem"] = value;
        }
    }
    protected string PatientIcn
    {
        get
        {
            if (ViewState["patientIcn"] != null)
            {
                return (string)ViewState["patientIcn"];
            }
            return string.Empty;
        }
        set { ViewState["patientIcn"] = value; }
    }

    protected string IsSurveyTheLatest
    {
        get
        {
            if (ViewState["isSurveyTheLatest"] != null)
            {
                return (string)ViewState["isSurveyTheLatest"];
            }
            return string.Empty;
        }
        set
        {
            ViewState["isSurveyTheLatest"] = value;
        }
    }
    protected int SurveyId
    {
        get
        {
            if (ViewState["surveyId"] != null)
            {
                return (int)ViewState["surveyId"];
            }
            return 0;
        }
        set { ViewState["surveyId"] = value; }
    }
    public List<MedsToRequest> MedsToAdd
    {
        get
        {
            if (ViewState["MsatEmedsToAdd"] != null)
            {
                return (List<MedsToRequest>)ViewState["MsatEmedsToAdd"];
            }
            else
            {
                ViewState["MsatEmedsToAdd"] = new List<MedsToRequest>();
                return (List<MedsToRequest>)ViewState["MsatEmedsToAdd"];
            }
        }
        set
        {
            if (ViewState["MsatEmedsToAdd"] == null)
            {
                ViewState["MsatEmedsToAdd"] = new List<MedsToRequest>();
            }
            ViewState["MsatEmedsToAdd"] = value;
        }
    }
    public List<MedsToRequest> MedsToDelete
    {
        get
        {
            if (ViewState["MsatEmedsToDelete"] != null)
            {
                return (List<MedsToRequest>)ViewState["MsatEmedsToDelete"];
            }
            else
            {
                ViewState["MsatEmedsToDelete"] = new List<MedsToRequest>();
                return (List<MedsToRequest>)ViewState["MsatEmedsToDelete"];
            }
        }
        set
        {
            if (ViewState["MsatEmedsToDelete"] == null)
            {
                ViewState["MsatEmedsToDelete"] = new List<MedsToRequest>();
            }
            ViewState["MsatEmedsToDelete"] = value;
        }
    }
    public List<string> CurrentMeds
    {
        get
        {
            if (ViewState["MsatEcurrentMeds"] != null)
            {
                return (List<string>)ViewState["MsatEcurrentMeds"];
            }
            else
            {
                ViewState["MsatEcurrentMeds"] = new List<string>();
                return (List<string>)ViewState["MsatEcurrentMeds"];
            }
        }
        set
        {
            if (ViewState["MsatEcurrentMeds"] == null)
            {
                ViewState["MsatEcurrentMeds"] = new List<string>();
            }
            ViewState["MsatEcurrentMeds"] = value;
        }
    }

    public List<SurveyResults> ListSurveyResults
    {
        get
        {
            if (ViewState["MsatSurveyResults"] != null)
            {
                return (List<SurveyResults>)ViewState["MsatSurveyResults"];
            }
            else
            {
                ViewState["MsatSurveyResults"] = new List<SurveyResults>();
                return (List<SurveyResults>)ViewState["MsatSurveyResults"];
            }
        }
        set
        {
            if (ViewState["MsatSurveyResults"] == null)
            {
                ViewState["MsatSurveyResults"] = new List<SurveyResults>();
            }
            ViewState["MsatSurveyResults"] = value;
        }
    }


    protected void Page_Load(object sender, EventArgs e)
    {

        //Check Permission.
        if (!IsUserAuthorizedToEditSurvey())
        {
            Logging.WriteLogToFile("WARNING - NOT Authorized. SURVEY EDIT Page Load. Error opening survey edit module – Not authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        //Check Patient ICN Match.
        if (!IsPatientIcnValid())
        {
            Logging.WriteLogToFile("WARNING - Invalid Patient ICN provided. SURVEY EDIT Page Load. Error opening survey edit module – Invalid Patient ICN. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=505");
        }

        _questionList = GetAllQuestionsForSurvey();
        if (!IsPostBack)
        {
            //_user = (UserAccountManager)HttpContext.Current.User;
            ResetFormControls();
            ResetSurveyProperties();
            if (!String.IsNullOrEmpty(Request.QueryString["patientIcn"]))
                PatientIcn = Request.QueryString["patientIcn"]; 
            Logging.WriteLogToFile(string.Format("SURVEY EDIT opening patient ICN {0} on survey edit page.", PatientIcn));
            var myEditManager = new MSATEditViewManager();
            MsatEditViewModel = myEditManager.GetMsatEditViewModel(PatientIcn);
            rgListOfSurveys.DataSource = MsatEditViewModel.ListOfSurveys;
            rgListOfSurveys.DataBind();
            lblPatNameLast4.Text = lblPatientName.Text = MsatEditViewModel.PatientDetails.PatientFullName + ": " + MsatEditViewModel.PatientDetails.PatientLastFour;

            PopulateQuestionControls();
            SetMonthYearSelectorValues();
            PopulateLabelsAndSetDispaly();

            pnlMedicationSection.Visible = false;
            Logging.WriteLogToFile(string.Format("SURVEY EDIT loaded surveys for patient ICN {0} on survey edit page.", PatientIcn));
            PopulateCorticosteroidQuestions();
        }

        
        SetBreadCrumb();
        SetControlsVisibility();
        DisplayNotificationMessage(false, "", "");
        var setting = Helpers.GetDBConfigEntry("MSSRShowDateOfDeath");

        if (setting != null && setting.ToString().ToLower() == "true")
        {
            lblDateOfDeath.Visible = true;
        }
    }

    private bool IsPatientIcnValid()
    {
        bool isPatientIcnValid = false;
        string patientIcnQryString = null;
        string patientIcnSession = null;
        if (!String.IsNullOrEmpty(Request.QueryString["patientIcn"]))
            patientIcnQryString = Request.QueryString["patientIcn"];
        else
        {
            return isPatientIcnValid = false;
        }
        if (Helpers.DeSerializSessionItems(Session["patientIcnMsatEdit"]) != null)
        {
            patientIcnSession = Helpers.DeSerializSessionItems(Session["patientIcnMsatEdit"]).ToString();
        }
        else
        {
            return isPatientIcnValid = false;
        }
        if (string.IsNullOrEmpty(patientIcnQryString) || string.IsNullOrEmpty(patientIcnSession))
        {
            return isPatientIcnValid = false;
        }
        if (patientIcnQryString.Trim() == patientIcnSession.Trim())
        {
            isPatientIcnValid = true;
        }

        return isPatientIcnValid;
    }

    private void ResetSurveyProperties()
    {
        CurrentMeds = null;
        MedsToDelete = null;
        MedsToAdd = null;
        SurveyId = 0;
        PatientIcn = string.Empty;
        MedicationNameAdd = null;
        CardioToxMed = null;
        IsSurveyTheLatest = null;
        IsCardioToxChanged = null;
        CardioToxMedSurResult = null;
        CurrentStatus = null;
        CurrentAssessmentHF = null;
        patientDem = null;
        _survey = null;
        ListSurveyResults = null;
    }

    private void PopulateAddMedsDropDown()
    {
        MedsViewManager medMgr = new MedsViewManager();
        MedsViewModel mdl = medMgr.GetMedsViewModel(PatientIcn, SurveyId);

        rdgListOfMedsPerSurvey.DataSource = mdl.ListOfMeds;
        rdgListOfMedsPerSurvey.DataBind();
        rdcListOfRegMedications.DataSource = mdl.AvailablePatientMedications;
        rdcListOfRegMedications.DataBind();
    }

    protected void rdButtonAddMeds_Click(object sender, EventArgs e)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Started adding medication.",
            PatientIcn, SurveyId.ToString()));

        int medId = 0;
        if (rdcListOfRegMedications.SelectedItem != null)
        {
            medId = int.Parse(rdcListOfRegMedications.SelectedValue);
        }
        var med = _mssrInstrumentManager.GetMedicationByMedicationId(medId);
        if (med != null)
        {
            MedicationNameAdd = med.MEDICATION;
            PatientMedicationRequest medRequest = new PatientMedicationRequest
            {
                MedicationId = med.ID,
                MedicationName = med.MEDICATION,
                HealthFactorName = med.HEALTH_FACTOR
            };
            LoadMedControl(medRequest, TransactionType.Add);
        }
    }

    protected void LoadMedControl(PatientMedicationRequest medRequest, TransactionType tranType)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Load medication for {2} start.",
             PatientIcn, SurveyId.ToString(), tranType.ToString()));

        pnlMedicationSection.Visible = true;
        controls_Medications cntrl = (controls_Medications)pnlMedicationSection.FindControl("MedicationSelection1");

        if (medRequest != null && cntrl != null)
        {
            cntrl.ClearMedicationSelection();
            cntrl.MedicationId = medRequest.MedicationId;
            cntrl.MedicationName = medRequest.MedicationName;
            cntrl.HealthFactorName = medRequest.HealthFactorName;


            var medId = new Guid(medRequest.PatientMedicationId.ToString());
            var patMed = _mssrInstrumentManager.GetPatientMedicationByMedicationId(medId);
            if (cntrl.MedicationName.ToLower().Contains("mitoxantrone"))
            {
                CardioToxRequest cardioToxReq = SetCardiotoxQuestion();
                cntrl.SetupMedicationSelections(patMed, tranType, cardioToxReq, CardioToxMedSurResult);
                IsCardioToxChanged = "Yes";
            }
            else
            {
                cntrl.SetupMedicationSelections(patMed, tranType);
            }

            Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Loaded medication {2} for {3}.",
                PatientIcn, SurveyId.ToString(), medRequest.MedicationName, tranType.ToString()));
        }

        SetCommandControls(tranType);

    }

    private CardioToxRequest SetCardiotoxQuestion()
    {
        CardioToxRequest cardioToxResponse = new CardioToxRequest();
        cardioToxResponse.QuestionTextCardioTox = GetQuestionText("CardioTox");
        cardioToxResponse.QuestionTextCardioToxYes = GetQuestionText("CardioToxYes");
        cardioToxResponse.QuestionTextCardioToxDateUnknown = GetQuestionText("CardioToxDateUnknown");

        return cardioToxResponse;

    }

    private void SetCommandControls(TransactionType tranType)
    {
        if (tranType == TransactionType.Add)
        {
            rdbUpdateMedication.Enabled = false;
            rdbAddMedication.Enabled = true;
        }
        else if (tranType == TransactionType.Update)
        {
            rdbUpdateMedication.Enabled = true;
            rdbAddMedication.Enabled = false;
        }
    }

    protected void PopulateQuestionControls()
    {
        using (var ctx = new MSSRDataClassesDataContext())
        {

            ddlCauseOfDeathType.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("COD", HiddenSurveyType.Value);
            ddlCauseOfDeathType.DataBind();

            rblAssessmentType.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("AT", HiddenSurveyType.Value);
            rblAssessmentType.DataBind();

            rblQIC.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("IC", HiddenSurveyType.Value);
            rblQIC.DataBind();

            rblQ1.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("1", HiddenSurveyType.Value);
            rblQ1.DataBind();

            rblQ2.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("2", HiddenSurveyType.Value);
            rblQ2.DataBind();

            rblQ3.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("3", HiddenSurveyType.Value);
            rblQ3.DataBind();

            rblQ4.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("4", HiddenSurveyType.Value);
            rblQ4.DataBind();

            rblQ4a.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("4a", HiddenSurveyType.Value);
            rblQ4a.DataBind();

            rblQ5.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("5", HiddenSurveyType.Value);
            rblQ5.DataBind();

            rblQ5a.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("5a", HiddenSurveyType.Value);
            rblQ5a.DataBind();

            rblQ6.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("6", HiddenSurveyType.Value);
            rblQ6.DataBind();

            rblQ6a.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("6a", HiddenSurveyType.Value);
            rblQ6a.DataBind();

            rblQ7.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("7", HiddenSurveyType.Value);
            rblQ7.DataBind();

            cblQ8.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("8", HiddenSurveyType.Value);
            cblQ8.DataBind();

            rblQ9.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("9", HiddenSurveyType.Value);
            rblQ9.DataBind();

            rblQ10.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("10", HiddenSurveyType.Value);
            rblQ10.DataBind();

            rblQ11.DataSource =
                _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("11", HiddenSurveyType.Value);
            rblQ11.DataBind();

            rblQIG.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("IG", HiddenSurveyType.Value);
            rblQIG.DataBind();

            rblQSJC.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("SJC", HiddenSurveyType.Value);
            rblQSJC.DataBind();

        }
    }

    private void SetMonthYearSelectorValues()
    {
        mysQ7MSDateFirst.populateDateTimeLists();
        mysQ7MSDateFirst.setRequired(true);
        mysQ7MSDateDx.populateDateTimeLists();
        mysQ7CISDateFirst.populateDateTimeLists();
        mysQ7RISDateFirst.populateDateTimeLists();
        mysQ7CISDateFirst.setRequired(true);
        mysQ7NMODateFirst.populateDateTimeLists();
        mysQ7NMODateFirst.setRequired(true);
        mysQ7NMODx.populateDateTimeLists();

        mysQ9DateTran.populateDateTimeLists();
        mysQ9DateTran.setRequired(true);
        mysQ12A.populateDateTimeLists();
        mysQ11_6A.populateDateTimeLists();
        mysQ11_8.populateDateTimeLists();
        mysQIDPositive.populateDateTimeLists();
        mysQIDNegative.populateDateTimeLists();

        mysQIDPositive.Label = "Positive Date:";
        mysQIDNegative.Label = "Negative Date:";
        mysQSJCPositive.populateDateTimeLists();
        mysQSJCNegative.populateDateTimeLists();


    }

    private void PopulateLabelsAndSetDispaly()
    {
        //dpDate1.MaxDate = DateTime.Now;
        LabelForDateOfDeathDem.Text = GetQuestionText("DOD");
        LabelForCOD.Text = GetQuestionText("COD");
        LabelForQAT.Text = GetQuestionText("AT");
        LabelForQIC.Text = GetQuestionText("IC");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        //LabelForQ4a.Text = GetQuestionText("4a");

        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7.Text = GetQuestionText("7");
        mysQ7MSDateFirst.Label = GetQuestionText("7MSDateFirst");

        mysQ7MSDateDx.Label = GetQuestionText("7MSDateDx");
        mysQ7CISDateFirst.Label = GetQuestionText("7CISDateFirst");
        mysQ7RISDateFirst.Label = GetQuestionText("7RISDateFirst");
        mysQ7NMODateFirst.Label = GetQuestionText("7NMODateFirst");
        mysQ7NMODx.Label = GetQuestionText("7NMODx");
        LabelForQ7NOMS.Text = GetQuestionText("7NOMSComment");

        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        mysQ9DateTran.Label = GetQuestionText("9DateTran");
        mysQ12A.Label = GetQuestionText("DATEOFLASTREALPSE");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ11_6A.Text = GetQuestionText("11_6A");
        LabelForQ11_8.Text = GetQuestionText("11_8");

        LabelForQ12.Text = GetQuestionText("12");
        LabelForQIG.Text = GetQuestionText("IG");

        LabelForQSJC.Text = GetQuestionText("SJC");
        mysQSJCPositive.Label = GetQuestionText("SJCP");
        mysQSJCNegative.Label = GetQuestionText("SJCN");
        QuestionList = GetAllQuestionsForSurvey(); // Get all Questions

        #region Set Corticosteroid Ctrl Vars
        //PopulateCorticosteroidQuestions();
        #endregion
    }

    private void PopulateCorticosteroidQuestions()
    {
        ctrlCorticosteroidsSelection.CORT = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORT");
        ctrlCorticosteroidsSelection.CORTCU = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCU");
        ctrlCorticosteroidsSelection.CORTCUIVDexPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexPharm");
        ctrlCorticosteroidsSelection.CORTCUIVDexSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexSchedule");
        ctrlCorticosteroidsSelection.CORTCUIVDexScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUIVDexApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUIVMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethPharm");
        ctrlCorticosteroidsSelection.CORTCUIVMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethSchedule");
        ctrlCorticosteroidsSelection.CORTCUIVMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUIVMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUOralMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethPharm");
        ctrlCorticosteroidsSelection.CORTCUOralMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethSchedule");
        ctrlCorticosteroidsSelection.CORTCUOralMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUOralMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUOralPredPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredPharm");
        ctrlCorticosteroidsSelection.CORTCUOralPredSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredSchedule");
        ctrlCorticosteroidsSelection.CORTCUOralPredScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUOralPredApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredApproxStarted");

        //Past
        ctrlCorticosteroidsSelection.CORTPU = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPU");
        ctrlCorticosteroidsSelection.CORTPUIVDexPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexPharm");
        ctrlCorticosteroidsSelection.CORTPUIVDexSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexSchedule");
        ctrlCorticosteroidsSelection.CORTPUIVDexScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUIVDexApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUIVMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethPharm");
        ctrlCorticosteroidsSelection.CORTPUIVMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethSchedule");
        ctrlCorticosteroidsSelection.CORTPUIVMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUIVMethApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUOralMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethPharm");
        ctrlCorticosteroidsSelection.CORTPUOralMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethSchedule");
        ctrlCorticosteroidsSelection.CORTPUOralMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUOralMethApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUOralPredPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredPharm");
        ctrlCorticosteroidsSelection.CORTPUOralPredSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredSchedule");
        ctrlCorticosteroidsSelection.CORTPUOralPredScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUOralPredApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredApproxStopped");

        ctrlCorticosteroidsSelection.CORTPUIVDexApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUIVMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUOralMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUOralPredApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredApproxStarted");

        ctrlCorticosteroidsSelection.InitializeData();
    }

    protected string GetQuestionText(string questionId)
    {
        foreach (var ques in _questionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _mssrInstrumentManager.SelectAllQuestions(SurveyTypeId).ToList();
    }

    private void SetControlsVisibility()
    {


        // Q1
        if (rblQ1.SelectedItem != null &&
            (rblQ1.SelectedItem.Text.ToLower().Equals("other")))
        {
            pnlQ1OtherDescription.Style["display"] = "block";
        }
        else
        {
            pnlQ1OtherDescription.Style["display"] = "none";
        }

        // Q4
        if (rblQ4.SelectedItem == null)
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ4.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ4Unknown.Style["display"] = "block";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ4.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "block";

            if (rblQ4a.SelectedIndex > -1 && IsOtherSelected(rblQ4a))
            {
                pnlQ4aOtherDescription.Style["display"] = "block";
            }
            else
            {
                pnlQ4aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }

        // Q5
        if (rblQ5.SelectedItem == null)
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ5.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ5Unknown.Style["display"] = "block";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ5.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "block";

            if (rblQ5a.SelectedIndex > -1 && IsOtherSelected(rblQ5a))
            {
                pnlQ5aOtherDescription.Style["display"] = "block";
            }
            else
            {
                pnlQ5aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }

        // Q6
        if (rblQ6.SelectedItem == null)
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ6.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ6Unknown.Style["display"] = "block";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ6.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "block";

            if (rblQ6a.SelectedIndex > -1 && IsOtherSelected(rblQ6a))
            {
                pnlQ6aOtherDescription.Style["display"] = "block";
            }
            else
            {
                pnlQ6aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }

        // Q7
        if (rblQ7.SelectedItem != null)
        {
            if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "block";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
            {
                pnlQ7MS.Style["display"] = "block";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "block";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "block";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("radiologically isolated syndrome"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "block";
            }
        }
        else
        {
            pnlQ7MS.Style["display"] = "none";
            pnlQ7CIS.Style["display"] = "none";
            pnlQ7NMO.Style["display"] = "none";
            pnlQ7NOMS.Style["display"] = "none";
        }

        // Q9
        if (rblQ9.SelectedItem != null)
        {
            if (rblQ9.SelectedItem.Text.ToLower().Contains("secondary progressive"))
            {
                pnlQ9DateTran.Style["display"] = "block";
            }
            else
            {
                pnlQ9DateTran.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ9DateTran.Style["display"] = "none";
        }

        // Q11
        pnlQ11_6A.Style["display"] = "none";
        pnlQ11_8.Style["display"] = "none";

        if (rblQ11.SelectedItem != null &&
            (rblQ11.SelectedItem.Text.ToLower().Contains("6a =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("6b =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("7 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("10 =")))
        {
            pnlQ11_6A.Style["display"] = "block";

            if (rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
            {
                pnlQ11_8.Style["display"] = "block";
            }
        }

        // QID

        if (rblQIG.SelectedItem != null && rblQIG.SelectedItem.Text.ToLower().Contains("positive"))
        {
            pnlQIDPositive.Style["display"] = "block";
            pnlQIDNegative.Style["display"] = "none";

        }
        else if (rblQIG.SelectedItem != null && rblQIG.SelectedItem.Text.ToLower().Contains("negative"))
        {
            pnlQIDPositive.Style["display"] = "none";
            pnlQIDNegative.Style["display"] = "block";
        }
        else
        {
            pnlQIDPositive.Style["display"] = "none";
            pnlQIDNegative.Style["display"] = "none";
        }

        //SJC
        if (rblQSJC.SelectedItem != null && rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
        {
            pnlQSJCPositive.Style["display"] = "block";
            pnlQSJCNegative.Style["display"] = "none";

        }
        else if (rblQSJC.SelectedItem != null && rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
        {
            pnlQSJCPositive.Style["display"] = "none";
            pnlQSJCNegative.Style["display"] = "block";
        }
        else
        {
            pnlQSJCPositive.Style["display"] = "none";
            pnlQSJCNegative.Style["display"] = "none";
        }

        //Corticosteroid set control visibility.
        ctrlCorticosteroidsSelection.SetControlVisibility();


    }

    private bool IsOtherSelected(CheckBoxList controlId)
    {
        
        bool isOtherSelected = false;
        foreach (ListItem li in controlId.Items)
        {
            if (li.Selected && li.Text.ToLower() == "other")
            {
                isOtherSelected = true;
                break; 
            }          
        }
        return isOtherSelected;
    }

    protected void imgBtnUpdateMedications_Command(object sender, GridCommandEventArgs e)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Start Medication edit-delete.",
            PatientIcn, SurveyId.ToString()));

        PatientMedicationRequest medRequest =
            new PatientMedicationRequest
            {
                MedicationId = (int)((GridDataItem)e.Item).GetDataKeyValue("ID"),
                MedicationName = (string)((GridDataItem)e.Item).GetDataKeyValue("MedicationName"),
                HealthFactorName = (string)((GridDataItem)e.Item).GetDataKeyValue("HealthFactor"),
                PatientMedicationId = (Guid)((GridDataItem)e.Item).GetDataKeyValue("PatientMedId")
            };
        MedRequest = medRequest;
        if (e.CommandName == "Select")
        {
            LoadMedControl(medRequest, TransactionType.Update);
        }

        if (e.CommandName == "DELETE")
        {
            Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Delete medication {2} start.",
             PatientIcn, SurveyId.ToString(), MedRequest.MedicationName));
            MedsToRequest medsToDelete = new MedsToRequest();
            medsToDelete.SurveyId = SurveyId;
            medsToDelete.Id = MedRequest.PatientMedicationId;

            MedsToDelete.Add(medsToDelete);
            //lblListOfMeds.Text = "Before Delete:- " + CurrentMeds;
            if (CurrentMeds.Contains(medsToDelete.Id.ToString()))
            {
                CurrentMeds.Remove(medsToDelete.Id.ToString());
            }

            MedsViewManager mdsMgr = new MedsViewManager();
            mdsMgr.DeleteMedication(SurveyId, MedRequest.MedicationId, MedRequest.PatientMedicationId);

            if (MedRequest.MedicationName.ToLower().Contains("mitoxantrone"))
            {
                CardioToxMed = null;
                CardioToxMedSurResult = null;
                IsCardioToxChanged = "Yes";

            }
            Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Delete medication {2} end.",
             PatientIcn, SurveyId.ToString(), MedRequest.MedicationName));
            pnlMedicationSection.Visible = false;
        }
        PopulateAddMedsDropDown();
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = "<a href=\"Patients.aspx\">Patients</a> > Survey Edit";
        }
    }

    private void LoadSurveyResultsForSurvey(string patientIcn, int surveyId)
    {
        SurveyViewManager SurveyViewManager = new SurveyViewManager(CurrentUser);
        var surveyModel = SurveyViewManager.GetSurveyViewModel(patientIcn, surveyId);
        var survey = surveyModel.Survey;
        
        if (survey != null)
        {
            //if (survey.SURVEY_RESULTs == null || survey.SURVEY_RESULTs.Count == 0)
            //{
            //    DisplayNotificationMessage(true, "Alert", "No Survey Result found for the selected survey");
            //    rdButtonUpdateSurvey.Enabled = false;
            //    pnlMainContent.Enabled = false;

            //    return;
            //}
        }
        
        var surveyMeds = surveyModel.ListOfMeds;
        rdgListOfMedsPerSurvey.DataSource = surveyMeds;
        rdgListOfMedsPerSurvey.DataBind();

        ResetFormControls();
        ctrlCorticosteroidsSelection.SetupCorticosteroidSelections(ref survey);
        PopulateFormControls(survey, true);

    }

    private void ResetFormControls()
    {

        dpDate2.SelectedDate = null;
        ddlCauseOfDeathType.SelectedValue = string.Empty;
        dpDate1.SelectedDate = null;
        rblAssessmentType.SelectedIndex = -1;
        rblQIC.SelectedIndex = -1;
        txtQ1Other.Text = string.Empty;
        rblQ1.SelectedIndex = -1;
        rblQ2.SelectedIndex = -1;
        rblQ3.SelectedIndex = -1;
        txtQ4UnknownComment.Text = string.Empty;
        rblQ4.SelectedIndex = -1;
        rblQ4a.SelectedIndex = -1;
        txtQ4aOther.Text = string.Empty;
        txtQ5UnknownComment.Text = string.Empty;
        rblQ5.SelectedIndex = -1;
        rblQ5a.SelectedIndex = -1;
        txtQ5aOther.Text = string.Empty;
        txtQ6UnknownComment.Text = string.Empty;
        rblQ6.SelectedIndex = -1;
        rblQ6a.SelectedIndex = -1;
        txtQ6aOther.Text = string.Empty;
        rblQ7.SelectedIndex = -1;
        mysQ7MSDateFirst.MonthYearString = string.Empty;
        mysQ7MSDateDx.MonthYearString = string.Empty;
        mysQ7CISDateFirst.MonthYearString = string.Empty;
        mysQ7NMODateFirst.MonthYearString = string.Empty;
        mysQ7RISDateFirst.MonthYearString = string.Empty;
        mysQ7NMODx.MonthYearString = string.Empty;
        txtQ7NOMS.Text = string.Empty;
        cblQ8.SelectedIndex = -1;
        rblQ9.SelectedIndex = -1;
        mysQ9DateTran.MonthYearString = string.Empty;
        rblQ10.SelectedIndex = -1;
        rblQIG.SelectedIndex = -1;
        rblQSJC.SelectedIndex = -1;
        mysQIDPositive.MonthYearString = string.Empty;
        mysQIDNegative.MonthYearString = string.Empty;
        mysQSJCPositive.MonthYearString = string.Empty;
        mysQSJCNegative.MonthYearString = string.Empty;
        txtHealthFactors.Text = string.Empty;
        txtNotePreview.Text = string.Empty;
        rblQ11.SelectedIndex = -1;
        mysQ11_6A.MonthYearString = string.Empty;
        mysQ11_8.MonthYearString = string.Empty;
        txtQ12.Text = string.Empty;
        mysQ12A.MonthYearString = string.Empty;

        //reset medication.
        ctrlCorticosteroidsSelection.ResetControlFields();
        MedicationSelection1.ClearMedicationSelection();
        pnlMedicationSection.Visible = false;
        txtSurveyUpdateComment.Text = string.Empty;

    }

    private void PopulateFormControls(SURVEY survey, bool past)
    {
        CardioToxSurveyResult cardioToxSurveyResult = new CardioToxSurveyResult();
        foreach (var sResult in survey.SURVEY_RESULTs)
        {
            switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
            {
                case "DOD":

                    #region Question DOD

                    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                    {
                        DateTime temp;
                        if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                        {
                            dpDate2.SelectedDate = temp;
                        }
                    }

                    #endregion

                    break;
                case "COD":

                    #region Question COD

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        ddlCauseOfDeathType.SelectedValue =
                            sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        ddlCauseOfDeathType.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "D":

                    #region Question D

                    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                    {
                        DateTime temp;
                        if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                        {
                            dpDate1.SelectedDate = temp;
                        }
                    }

                    #endregion

                    break;
                case "AT":

                    #region Question AT

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblAssessmentType.SelectedValue =
                            sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblAssessmentType.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "IC":

                    #region Question IC

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQIC.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQIC.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "1":

                    #region Question 1

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                        {
                            txtQ1Other.Text = sResult.RESULT_TEXT;
                        }
                        else
                        {
                            txtQ1Other.Text = "";
                        }
                    }
                    else
                    {
                        rblQ1.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "2":

                    #region Question 2

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ2.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "3":

                    #region Question 3

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ3.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "4":

                    #region Question 4

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ4UnknownComment.Text = sResult.RESULT_TEXT;
                        }
                    }
                    else
                    {
                        rblQ4.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "4a":

                    #region Question 4a

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        if (rblQ4a.Items == null || rblQ4a.Items.Count == 0)
                        {
                            rblQ4a.DataBind();
                        }
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ4a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            pnlQ4aOtherDescription.Style["Display"] = "block";
                        }
                        else
                        {
                            txtQ4aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ4a.SelectedIndex = -1;
                    }


                    #endregion

                    break;
                case "4aBioFamHisMsOtherComment":

                    #region 4aBioFamHisMsOtherComment

                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ4aOtherDescription.Style["Display"] = "block";
                        txtQ4aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ4aOtherDescription.Style["Display"] = "none";
                        txtQ4aOther.Text = string.Empty;
                    }
                    break;

                    #endregion

                case "5":

                    #region Question 5

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ5UnknownComment.Text = sResult.RESULT_TEXT;

                        }
                        else
                        {
                            txtQ5UnknownComment.Text = "";
                        }
                    }
                    else
                    {
                        rblQ5.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "5a":

                    #region Question 5a

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        pnlQ5a.Enabled = pnlQ5a.Visible = true;
                        if (rblQ5a.Items == null || rblQ5a.Items.Count == 0)
                        {
                            rblQ5a.DataBind();
                        }
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ5a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            //pnlQ5aOtherDescription.Style["Display"] = "block";
                            //txtQ5aOther.Text = sResult.RESULT_TEXT; //TODO: add a call to other description text.
                        }
                        else
                        {
                            txtQ5aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ5a.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "5aBioFamHisMsOtherComment":

                    #region 5aBioFamHisMsOtherComment

                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ5aOtherDescription.Style["Display"] = "block";
                        txtQ5aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ5aOtherDescription.Style["Display"] = "none";
                        txtQ5aOther.Text = string.Empty;
                    }
                    break;

                    #endregion

                case "6":

                    #region Question 6

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ6UnknownComment.Text = sResult.RESULT_TEXT;

                        }
                        else
                        {
                            txtQ6UnknownComment.Text = "";
                        }
                    }
                    else
                    {
                        rblQ6.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "6a":

                    #region Question 6a


                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        pnlQ6a.Enabled = pnlQ6a.Visible = true;
                        if (rblQ6a.Items == null || rblQ6a.Items.Count == 0)
                        {
                            rblQ6a.DataBind();
                        }
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ6a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            pnlQ6aOtherDescription.Style["Display"] = "block";
                            //txtQ6aOther.Text = sResult.RESULT_TEXT; //TODO: add a call to other description text.
                        }
                        else
                        {
                            txtQ6aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ6a.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "6aBioFamHisMsOtherComment":

                    #region 6aBioFamHisMsOtherComment

                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ6aOtherDescription.Style["Display"] = "block";
                        txtQ6aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ6aOtherDescription.Style["Display"] = "none";
                        txtQ6aOther.Text = string.Empty;
                    }
                    break;

                    #endregion

                case "7":

                    #region Question 7

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ7.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "7MSDateFirst":

                    #region Question 7MSDateFirst

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7MSDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "7MSDateDx":

                    #region Question 7MSDateDx

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7MSDateDx.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "7CISDateFirst":

                    #region Question 7CISDateFirst

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7CISDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "7RISDateFirst":
                    #region Question 7RISDateFirst
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7RISDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7NMODateFirst":

                    #region Question 7NMODateFirst

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7NMODateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "7NMODx":

                    #region Question 7NMODx

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7NMODx.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "7NOMSComment":

                    #region Question 7NOMSComment

                    if (sResult.RESULT_TEXT != null)
                    {
                        txtQ7NOMS.Text = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "8":

                    #region Question 8

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        // get result text ... split into array
                        string[] symptomArray = sResult.RESULT_TEXT.Split(',');

                        foreach (string s in symptomArray)
                        {
                            foreach (ListItem li in cblQ8.Items)
                            {
                                if (s.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    break;
                                }
                            }
                        }
                    }

                    #endregion

                    break;
                case "9":

                    #region Question 9

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ9.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "9DateTran":

                    #region Question 9DateTran

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ9DateTran.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "10":

                    #region Question 10

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ10.SelectedIndex = -1;
                    }

                    #endregion

                    break;

                case "11":
                    #region Question 11
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ11.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "11_6A":
                    #region Question 11_6A
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ11_6A.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "11_8":
                    #region Question 11_8
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ11_8.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;

                case "12":
                    #region Question 12
                    if (sResult.RESULT_TEXT != null)
                    {
                        txtQ12.Text = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "DATEOFLASTREALPSE":
                    #region Question 12 a
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ12A.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "13":

                    #region Question 13 - Medications

                    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                    {
                        CurrentMeds = sResult.RESULT_TEXT.Split(',').ToList<string>();
                    }

                    #endregion

                    break;
                case "IG":

                    #region Question IG

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQIG.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQIG.SelectedIndex = -1;
                    }

                    #endregion

                    break;
                case "IGP":

                    #region Question IGP

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQIDPositive.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "IGN":

                    #region Question IGN

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQIDNegative.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "CardioTox":

                    #region Question CardioTox

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        cardioToxSurveyResult.CardioTox = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();//sResult.RESULT_TEXT;
                        cardioToxSurveyResult.CardioToxResultText = sResult.RESULT_TEXT;
                        // mitoxantroneControl.setRbQCardioTox(sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString());
                    }
                    else
                    {
                        cardioToxSurveyResult.CardioTox = string.Empty;
                        cardioToxSurveyResult.CardioToxResultText = string.Empty;
                        //mitoxantroneControl.setRbQCardioTox("");
                    }

                    #endregion

                    break;
                case "CardioToxYes":

                    #region Question CardioToxYes

                    if (sResult.RESULT_TEXT != null)
                    {
                        cardioToxSurveyResult.CardioToxYes = sResult.RESULT_TEXT.ToString();
                        //mitoxantroneControl.setTxtQCardioToxDate(sResult.RESULT_TEXT.ToString());
                    }

                    #endregion

                    break;
                case "CardioToxDateUnknown":

                    #region Question CardioToxDateUnknown

                    if (sResult.RESULT_TEXT != null)
                    {
                        cardioToxSurveyResult.CardioToxDateUnknown = sResult.RESULT_TEXT.ToString();
                        //mitoxantroneControl.setCbQCardioToxDateUnknown(sResult.RESULT_TEXT.ToString());
                    }

                    #endregion

                    break;
                case "SJC":

                    #region Question SJC

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        setRblQSJCSelectedValue(sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString());
                    }
                    else
                    {
                        setRblQSJCSelectedValue("");
                    }

                    #endregion

                    break;
                case "SJCP":

                    #region Question SJCP

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQSJCPositive.MonthYearString = sResult.RESULT_TEXT.ToString(); 
                    }

                    #endregion

                    break;
                case "SJCN":

                    #region Question SJCN

                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQSJCNegative.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                case "HF":

                    #region Question HF

                    if (sResult.RESULT_TEXT != null)
                    {
                        txtHealthFactors.Text = sResult.RESULT_TEXT.ToString();
                    }

                    #endregion

                    break;
                default:
                    break;
            }
        }

        CardioToxMedSurResult = cardioToxSurveyResult;
        IsCardioToxChanged = "No";


    }

    protected void rgListOfSurveys_OnItemCommand(object sender, GridCommandEventArgs e)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT loading patient ICN {0} and started survey edit.", PatientIcn));
        if (e.CommandName == "Select")
        {
            pnlMainContent.Enabled = true;
            ResetSurveyProperties();
            ResetFormControls();

            SurveyId = (int)((GridDataItem)e.Item).GetDataKeyValue("surveyid");
            PatientIcn = (string)((GridDataItem)e.Item).GetDataKeyValue("PatientIcn");
            IsSurveyTheLatest = (string)((GridDataItem)e.Item).GetDataKeyValue("IsSurveyTheLatest");
            Logging.WriteLogToFile(string.Format("SURVEY EDIT loading patient ICN {0} and survey id {1} for edit on survey edit page.", PatientIcn, SurveyId.ToString()));
            LoadSurveyResultsForSurvey(PatientIcn, SurveyId);
            SetControlsVisibility();
            PopulateAddMedsDropDown();


            rdButtonUpdateSurvey.Enabled = true;
            Logging.WriteLogToFile(string.Format("SURVEY EDIT loaded patient ICN {0} and survey id {1} for edit on survey edit page.", PatientIcn, SurveyId.ToString()));

        }
    }

    private string SaveCompleteSurvey(bool writeTimeToLog, bool isSurveyDraft)
    {
        _survey = _mssrInstrumentManager.SelectSurveyByPatientIcnAndSurveyType(PatientIcn, SurveyId, SurveyTypeId);
        _survey.SetAsChangeTrackingRoot(); 
        string errorMessage = "";

        if (writeTimeToLog)
        {
            Logging.WriteLogToFile("SaveCompleteSurvey: Starting");
            writeTimeToLog = true;
        }
        bool validateInitialSymptomCountNotNeeded = isSurveyDraft ? true : getTypeInitialSymptomCount() > 0;
        if (Page.IsValid && validateInitialSymptomCountNotNeeded)
        {
            string patientICN = String.Empty;
            string refrdPatientIcn = string.Empty;
            if (Helpers.DeSerializSessionItems(Session["patientIcnMsatEdit"]) != null)
            {
                refrdPatientIcn = Helpers.DeSerializSessionItems(Session["patientIcnMsatEdit"]).ToString();
            }
            //Retrieve patient's ICN from the session variable
            patientICN = ValidatePatienIcnForSaveCompleteSurvey(patientICN, refrdPatientIcn);

            if (_survey != null)
            {
                // Not sure if we bail if this fails or not ...
                errorMessage = SaveSurvey(ref _survey);
               
                try
                {
                    _survey.SetAsUpdateOnSubmit();
                    if (writeTimeToLog)
                        Logging.WriteLogToFile("SaveCompleteSurvey: After _survey.SetAsUpdateOnSubmit()");
                }
                catch (Exception ex)
                {
                    Exception exc = HandleMSSRException(ex, "MSAssessmentTool", "0", "SaveCompleteSurvey()");
                    errorMessage = ex.Message;
                }

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }
                
                errorMessage = _mssrInstrumentManager.SurveyEditUpdateSurvey(_survey, writeTimeToLog);
                if (writeTimeToLog)
                    Logging.WriteLogToFile("SaveCompleteSurvey: After _mssrInstrumentManager.Update(_survey) 2nd");

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }
                var master = this.Master as RegistryMaster;
                if (master != null)
                {
                    master.SetDirtyFlag(false);
                }
                
                if (writeTimeToLog)
                    Logging.WriteLogToFile("SaveCompleteSurvey: After RefreshSurvey(patientICN)");
                SuppressSaveMessage = false;
            }
        }

        if (!Page.IsValid)
        {
            errorMessage = "There are validation errors on the page. Please correct the errors before saving:";
            List<IValidator> errored = this.Validators.Cast<IValidator>().Where(v => !v.IsValid).ToList();
            foreach (IValidator error in errored)
            {
                errorMessage += "\r\n" + error.ErrorMessage;
            }

        }       

        return errorMessage;
    }

    private string ValidatePatienIcnForSaveCompleteSurvey(string patientICN, string refrdPatientIcn)
    {
        if (ViewState["patientIcn"] != null)
        {
            patientICN = ViewState["patientIcn"].ToString();
            if (String.IsNullOrEmpty(patientICN.Trim()))
            {
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2", false);
            }
            else if (patientICN != refrdPatientIcn)
            {
                Response.Redirect("Warning.aspx?err=2", false);
            }
        }
        else
        {
            //Lost state. Redirect to message that need to log back in from CPRS.
            Response.Redirect("Warning.aspx?err=2");
        }
        return patientICN;
    }

    private string ValidateFormFields(bool isSurveyDraft, string errorMessage)
    {
        ClearErrorHandlers();
        if (!isSurveyDraft)
        {
            // Question 1 error handling
            if (rblQ1.SelectedItem.Text.ToLower().Equals("other") &&
                txtQ1Other.Text.Trim().Length == 0)
            {
                pnlQ1Error.Style["display"] = "block";
                lblQ1Error.Text = "* Question 1: Other Description Field is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ1Error.Text;
            }

            // Question 4 error handling

            if (rblQ4.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ4a.SelectedIndex == -1)
                {
                    pnlQ4Error.Style["display"] = "block";
                    lblQ4Error.Text = "* Question 4: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ4Error.Text;
                }
                else if (rblQ4a.SelectedItem.Text.ToLower().Equals(("other")) &&
                         txtQ4aOther.Text.Trim().Length == 0)
                {
                    pnlQ4Error.Style["display"] = "block";
                    lblQ4Error.Text = "* Question 4: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ4Error.Text;
                }
            }

            // Question 5 error handling

            if (rblQ5.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ5a.SelectedIndex == -1)
                {
                    pnlQ5Error.Style["display"] = "block";
                    lblQ5Error.Text = "* Question 5: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ5Error.Text;
                }
                else if (rblQ5a.SelectedItem.Text.ToLower().Equals(("other")) &&
                         txtQ5aOther.Text.Trim().Length == 0)
                {
                    pnlQ5Error.Style["display"] = "block";
                    lblQ5Error.Text = "* Question 5: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ5Error.Text;
                }
            }

            // Question 6 error handling

            if (rblQ6.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ6a.SelectedIndex == -1)
                {
                    pnlQ6Error.Style["display"] = "block";
                    lblQ6Error.Text = "* Question 6: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ6Error.Text;
                }
                else if (rblQ6a.SelectedItem.Text.ToLower().Equals(("other")) &&
                         txtQ6aOther.Text.Trim().Length == 0)
                {
                    pnlQ6Error.Style["display"] = "block";
                    lblQ6Error.Text = "* Question 6: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ6Error.Text;
                }
            }

            // Question 7 error handling

            if (rblQ7.SelectedItem.Text.ToLower().Equals(("multiple sclerosis")) &&
                mysQ7MSDateFirst.MonthYearString == "")
            {
                pnlQ7MSDateFirstError.Style["display"] = "block";
                lblQ7MSDateFirstError.Text = "* Question 7: Date of first neurological sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7MSDateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("clinically isolated syndrome ")) &&
                     mysQ7CISDateFirst.MonthYearString == "")
            {
                pnlQ7CISDateFirstError.Style["display"] = "block";
                lblQ7CISDateFirstError.Text = "* Question 7: Date of first sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7CISDateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("neuromyelitis")) &&
                     mysQ7NMODateFirst.MonthYearString == "")
            {
                pnlQ7NMODateFirstError.Style["display"] = "block";
                lblQ7NMODateFirstError.Text = "* Question 7: Date of first neurological sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7NMODateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("not to have")) &&
                     txtQ7NOMS.Text.Trim() == "")
            {
                pnlQ7NOMSError.Style["display"] = "block";
                lblQ7NOMSError.Text = "* Question 7: Description is required for 'Comment' field.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7NOMSError.Text;
            }

            // Question 8 error handling

            if (getTypeInitialSymptomCount() <= 0)
            {
                lblQ8Error.Style["display"] = "block";
                lblQ8Error.Text = "* Question 8: Type of initial MS/NMO symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ8Error.Text;
            }
            // Question 9 error handling

            if (rblQ9.SelectedItem.Text.ToLower().Contains(("secondary progressive")) &&
                mysQ9DateTran.MonthYearString == "")
            {
                pnlQ9DateTranError.Style["display"] = "block";
                lblQ9DateTranError.Text = "* Question 9: Date Transitioned is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ9DateTranError.Text;
            }

        }
        // Corticosteroids
        errorMessage += ctrlCorticosteroidsSelection.ValidateData();
        return errorMessage;
    }

    private void ClearErrorHandlers()
    {
        pnlQ1Error.Style["display"] = "none";
        lblQ1Error.Text = "";

        pnlQ4Error.Style["display"] = "none";
        lblQ4Error.Text = "";

        pnlQ5Error.Style["display"] = "none";
        lblQ5Error.Text = "";

        pnlQ6Error.Style["display"] = "none";
        lblQ6Error.Text = "";

        pnlQ7MSDateFirstError.Style["display"] = "none";
        lblQ7MSDateFirstError.Text = "";
        pnlQ7CISDateFirstError.Style["display"] = "none";
        lblQ7CISDateFirstError.Text = "";
        pnlQ7NMODateFirstError.Style["display"] = "none";
        lblQ7NMODateFirstError.Text = "";
        pnlQ7NOMSError.Style["display"] = "none";
        lblQ7NOMSError.Text = "";

        lblQ8Error.Style["display"] = "none"; //rehide and do validation
        lblQ8Error.Text = "";

        pnlQ9DateTranError.Style["display"] = "none";
        lblQ9DateTranError.Text = "";
    }

    private string SaveSurvey(ref SURVEY survey)
    {
        SURVEY_RESULT _surveyResult;
        string errorMessage = "";
        bool writeTimeToLog = false;

        List<STD_QUESTION> questions = PopulateStdQuestionsListForSetUpSurvey(survey, ref writeTimeToLog);
        //Delete all the survey results from database if there are any.

        //Add into a TRAN
        //using (TransactionScope tranScope = new TransactionScope())
        //{
        //    tranScope.Complete();
        //}

        SURVEY surveyWithResults = _mssrInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after _mssrInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID)");
        _mssrInstrumentManager.DeleteAllSurveyResults(surveyWithResults);

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after _mssrInstrumentManager.DeleteAllSurveyResults(surveyWithResults)");
        //End TRAN
        processAssessment(); // generate the health factors

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after processAssessment()");

        LogSelectionsForDebugging();


        #region Question DOD

        // Question DOD
        _surveyResult = new SURVEY_RESULT();

        if (dpDate2.SelectedDate != null)
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "DOD");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate2.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);

                patientDem.DateOfDeath = (DateTime)dpDate2.SelectedDate;
                //Session["DateOfDeath"] = (DateTime)dpDate2.SelectedDate;

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question DOD");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question COD

        // Question COD
        _surveyResult = new SURVEY_RESULT();

        if (ddlCauseOfDeathType.SelectedValue != "")
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "COD");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ddlCauseOfDeathType.SelectedValue);
                _surveyResult.RESULT_TEXT = ((String)ddlCauseOfDeathType.SelectedItem.Text);
                survey.SURVEY_RESULTs.Add(_surveyResult);
                //save COD
                patientDem.CauseOfDeath = ((String)ddlCauseOfDeathType.SelectedItem.Text);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question COD");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question D

        // Question D
        _surveyResult = new SURVEY_RESULT();

        if (dpDate1.SelectedDate != null)
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentStatus.LastAssessDate = (DateTime)dpDate1.SelectedDate;
                CurrentAssessmentHF.AssessmentDateTime = (DateTime)dpDate1.SelectedDate;
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question D");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question AT

        // Question AT
        if (rblAssessmentType.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question AT choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblAssessmentType.SelectedValue);
                _surveyResult.RESULT_TEXT = rblAssessmentType.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (rblAssessmentType.SelectedItem.Text.ToLower().Contains("baseline"))
                {
                    CurrentStatus.BaselineAssessDate = (DateTime)dpDate1.SelectedDate;
                }

                CurrentStatus.LastAssessType = rblAssessmentType.SelectedItem.Text.ToUpper();
                CurrentAssessmentHF.AssessmentType = rblAssessmentType.SelectedItem.Text.ToUpper();
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question AT");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question IC

        // Question IC
        if (rblQIC.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IC choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQIC.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQIC.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                // 
                switch (rblQIC.SelectedItem.Text.ToLower())
                {
                    case "telephone":
                        CurrentAssessmentHF.MSInterview = "TELEPHONE";
                        break;
                    case "clinical video teleconferencing":
                        CurrentAssessmentHF.MSInterview = "VIDEO CONFERENCE";
                        break;
                    case "in-person assessment":
                        CurrentAssessmentHF.MSInterview = "FACE TO FACE";
                        break;
                    default:
                        break;
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IC");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 1 - Race

        // Question 1 - Race
        
        if (rblQ1.SelectedIndex > -1)
        {
            var resultRace = new SurveyResults();
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                // is selection "Other", if yes, populate RESULT_TEXT with text from other field - else like below

                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ1.SelectedValue);
                
                if (rblQ1.SelectedItem.Text.ToLower() == "other")
                {
                    _surveyResult.RESULT_TEXT = txtQ1Other.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ1.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
                resultRace.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultRace.ResultText = _surveyResult.RESULT_TEXT;
                resultRace.QuestionCode = "RACE";
                ListSurveyResults.Add(resultRace);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 1");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 2 - Ethnicity

        // Question 2 - Ethnicity
        if (rblQ2.SelectedIndex > -1)
        {
            var resultEthnicity = new SurveyResults();
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.Ethnicity = rblQ2.SelectedItem.Text.ToUpper();

                resultEthnicity.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultEthnicity.ResultText = _surveyResult.RESULT_TEXT;
                resultEthnicity.QuestionCode = "Ethnicity";
                ListSurveyResults.Add(resultEthnicity);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 2");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Get Patient Dem reference

        try
        {
            MSSRE_PATIENT_DEM patDem;

            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                patDem = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == Convert.ToInt32(Helpers.DeSerializSessionItems(Session["patientIcnMsatEdit"])));

                string race = (rblQ1.SelectedItem != null) ? rblQ1.SelectedItem.Text : "";
                string ethnic = (rblQ2.SelectedItem != null) ? rblQ2.SelectedItem.Text : "";

                if (patDem != null)
                {
                    patDem.Race = (rblQ1.SelectedItem != null) ? rblQ1.SelectedItem.Text.ToUpper() : "";

                    switch (race.ToLower())
                    {
                        case "asian":
                            patDem.Race = "ASIAN/PI";
                            break;
                        case "native hawaiian or other pacific islander":
                            patDem.Race = "ASIAN/PI";
                            break;
                        case "black or african american":
                            patDem.Race = "BLACK";
                            break;
                        case "american indian or alaskan native":
                            patDem.Race = "INDIAN";
                            break;
                        case "other":
                            patDem.Race = "OTHER";
                            break;
                        case "white":
                            patDem.Race = "WHITE";
                            break;
                        default:
                            break;
                    }

                    switch (ethnic.ToLower())
                    {
                        case "not hispanic":
                            patDem.Ethnicity = "NH";
                            break;
                        case "hispanic":
                            patDem.Ethnicity = "H";
                            break;
                        default:
                            patDem.Ethnicity = "";
                            break;
                    }

                    ctx.SubmitChanges();
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "Update Patient Dem reference");
            errorMessage += ex.Message.ToString() + "\r\n";
            Logging.WriteLogToFile(errorMessage);
            errorMessage = string.Empty;
        }

        #endregion

        #region Question 3 - Gender

        // Question 3 - Gender
        if (rblQ3.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();
            var resultGender = new SurveyResults();
            try
            {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                resultGender.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultGender.ResultText = _surveyResult.RESULT_TEXT;
                resultGender.QuestionCode = "Gender";
                ListSurveyResults.Add(resultGender);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 3");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 4 - Biological familiy history of Multiple Sclerosis?

        // Question 4 - Biological familiy history of Multiple Sclerosis?
        if (rblQ4.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();
            var resultBfhms = new SurveyResults();
            try
            {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);

                // if selection = unknown = store txtQ4UnknownComment.Text in RESULT_TEXT, else store rblQ4.SelectedItem.Text
                if (rblQ4.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ4UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
                resultBfhms.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultBfhms.ResultText = _surveyResult.RESULT_TEXT;
                resultBfhms.QuestionCode = "BIOLOGICAL FAM HX MS";
                ListSurveyResults.Add(resultBfhms);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 4");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 4a - Question 4 Details

        if (getBioFamHisMsCount(rblQ4a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            var resultBfhms4a = new SurveyResults();
            STD_QUESTION question4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "4a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";

                foreach (ListItem li in rblQ4a.Items)
                {
                    if (li.Selected)
                    {

                        choiceStr += li.Text + ",";

                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                        //or iterate and add items here...
                        /*
                         
                        _surveyResult.STD_QUESTION_CHOICE_ID = Int32.Parse(li.Value);
                        _surveyResult.RESULT_TEXT = choiceStr;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                         
                         */
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                // Add Question 4a choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question4.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = choiceStr;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                resultBfhms4a.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultBfhms4a.ResultText = _surveyResult.RESULT_TEXT;
                resultBfhms4a.QuestionCode = "4a";
                ListSurveyResults.Add(resultBfhms4a);
                if (otherSelected)
                {
                    STD_QUESTION question4aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "4aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    var resultBfhms4aBioFamHisMsOtherComment = new SurveyResults();
                    _surveyResult.STD_QUESTION_CHOICE_ID = question4aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = txtQ4aOther.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);

                    resultBfhms4aBioFamHisMsOtherComment.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                    resultBfhms4aBioFamHisMsOtherComment.ResultText = _surveyResult.RESULT_TEXT;
                    resultBfhms4aBioFamHisMsOtherComment.QuestionCode = "4aBioFamHisMsOtherComment";
                    ListSurveyResults.Add(resultBfhms4aBioFamHisMsOtherComment);

                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question4a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 5 - Biological family history of Clinically Isolated Syndrome?

        // Question 5 - Biological family history of Clinically Isolated Syndrome?
        if (rblQ5.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();
            var resultBiologicalFamCis = new SurveyResults();
            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);

                // if selection = unknown = store txtQ5UnknownComment.Text in RESULT_TEXT, else store rblQ5.SelectedItem.Text
                if (rblQ5.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ5UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
                resultBiologicalFamCis.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                resultBiologicalFamCis.ResultText = _surveyResult.RESULT_TEXT;
                resultBiologicalFamCis.QuestionCode = "BIOLOGICAL FAM HIS CIS";
                ListSurveyResults.Add(resultBiologicalFamCis);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 5");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 5a - Question 5 Details


        if (getBioFamHisMsCount(rblQ5a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            var resultBiologicalFamCis5a = new SurveyResults();
            STD_QUESTION question5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "5a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";
                foreach (ListItem li in rblQ5a.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                if (question5 != null)
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = question5.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = choiceStr;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                    resultBiologicalFamCis5a.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                    resultBiologicalFamCis5a.ResultText = _surveyResult.RESULT_TEXT;
                    resultBiologicalFamCis5a.QuestionCode = "5a";
                    ListSurveyResults.Add(resultBiologicalFamCis5a);
                }
                if (otherSelected)
                {
                    STD_QUESTION question5aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "5aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    var resultBiologicalFamCis5aOtherComment = new SurveyResults();
                    if (question5aOther != null)
                    {
                        _surveyResult.STD_QUESTION_CHOICE_ID = question5aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        _surveyResult.RESULT_TEXT = txtQ5aOther.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);

                        resultBiologicalFamCis5aOtherComment.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                        resultBiologicalFamCis5aOtherComment.ResultText = _surveyResult.RESULT_TEXT;
                        resultBiologicalFamCis5aOtherComment.QuestionCode = "5aBioFamHisMsOtherComment";
                        ListSurveyResults.Add(resultBiologicalFamCis5aOtherComment);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question5a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 6 - Biological family history of Neuromyelitis Optica/Devic's Disease?

        // Question 6 - Biological family history of Neuromyelitis Optica/Devic's Disease?
        if (rblQ6.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();
            var result6BiologicalFamHisNmo = new SurveyResults();
            try
            {
                // Add Question 6 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);

                // if selection = unknown = store txtQ6UnknownComment.Text in RESULT_TEXT, else store rblQ6.SelectedItem.Text
                if (rblQ6.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ6UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);



                result6BiologicalFamHisNmo.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                result6BiologicalFamHisNmo.ResultText = _surveyResult.RESULT_TEXT;
                result6BiologicalFamHisNmo.QuestionCode = "6";
                ListSurveyResults.Add(result6BiologicalFamHisNmo);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 6");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 6a - Question 6 Details


        if (getBioFamHisMsCount(rblQ6a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            var result6aBiologicalFamHisNmo = new SurveyResults();
            STD_QUESTION question6 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "6a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";
                foreach (ListItem li in rblQ6a.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                if (question6 != null)
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = question6.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = choiceStr;
                    survey.SURVEY_RESULTs.Add(_surveyResult);

                    result6aBiologicalFamHisNmo.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                    result6aBiologicalFamHisNmo.ResultText = _surveyResult.RESULT_TEXT;
                    result6aBiologicalFamHisNmo.QuestionCode = "6a";
                    ListSurveyResults.Add(result6aBiologicalFamHisNmo);
                }
                if (otherSelected)
                {
                    STD_QUESTION question6aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "6aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    var result6aBioFamHisMsOtherComment = new SurveyResults();
                    if (question6aOther != null)
                    {
                        _surveyResult.STD_QUESTION_CHOICE_ID = question6aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        _surveyResult.RESULT_TEXT = txtQ6aOther.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);

                        result6aBioFamHisMsOtherComment.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                        result6aBioFamHisMsOtherComment.ResultText = _surveyResult.RESULT_TEXT;
                        result6aBioFamHisMsOtherComment.QuestionCode = "6aBioFamHisMsOtherComment";
                        ListSurveyResults.Add(result6aBioFamHisMsOtherComment);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - question6a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7 - Diagnosis History

        // Question 7 - Diagnosis History
        if (rblQ7.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();
            var result7Dh = new SurveyResults();
            try
            {
                // Add Question 7 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ7.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                result7Dh.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                result7Dh.ResultText = _surveyResult.RESULT_TEXT;
                result7Dh.QuestionCode = "7";
                ListSurveyResults.Add(result7Dh);

                if (rblQ7.SelectedItem != null)
                {
                    if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
                    {
                        CurrentStatus.MSDiagnosis = "POSSIBLE";
                        CurrentAssessmentHF.MSDiagnosis = "POSSIBLE";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
                    {
                        CurrentStatus.MSDiagnosis = "NOT MS";
                        CurrentAssessmentHF.MSDiagnosis = "NOT MS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
                    {
                        CurrentStatus.MSDiagnosis = "MS";
                        CurrentAssessmentHF.MSDiagnosis = "MS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
                    {
                        CurrentStatus.MSDiagnosis = "CIS";
                        CurrentAssessmentHF.MSDiagnosis = "CIS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
                    {
                        CurrentStatus.MSDiagnosis = "NMO";
                        CurrentAssessmentHF.MSDiagnosis = "NMO";
                    }
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7MSDateFirst - Date of first neurological sign/symptom (if known)

        // Question 7MSDateFirst - Date of first neurological sign/symptom (if known)
        if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
        {
            STD_QUESTION question7MSDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7MSDateFirst");
            _surveyResult = new SURVEY_RESULT();
            var result7MsDateFirst = new SurveyResults();
            try
            {
                // Add Question 7MSDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7MSDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7MSDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                result7MsDateFirst.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                result7MsDateFirst.ResultText = _surveyResult.RESULT_TEXT;
                result7MsDateFirst.QuestionCode = "7MSDateFirst";
                ListSurveyResults.Add(result7MsDateFirst);

                CurrentAssessmentHF.SymptomYear = mysQ7MSDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7MSDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                    CurrentStatus.LastDiagnosisYear = symptomYear; //mysQ7MSDateFirst.YearString;//Relase-2
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7MSDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7MSDateDx - Date of MS diagnosis

        // Question 7MSDateDx - Date of MS diagnosis
        if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
        {
            STD_QUESTION question7MSDateDx = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7MSDateDx");
            _surveyResult = new SURVEY_RESULT();
            var result77MsDateDx = new SurveyResults();
            try
            {
                // Add Question 7MSDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7MSDateDx.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7MSDateDx.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                result77MsDateDx.StdQuestionChoiceId = _surveyResult.STD_QUESTION_CHOICE_ID;
                result77MsDateDx.ResultText = _surveyResult.RESULT_TEXT;
                result77MsDateDx.QuestionCode = "7MSDateDx";
                ListSurveyResults.Add(result77MsDateDx);

                CurrentAssessmentHF.DiagnosisYear = mysQ7MSDateDx.MonthYearString;

                int diagnosisYear;
                Int32.TryParse(mysQ7MSDateDx.YearString, out diagnosisYear);
                if (diagnosisYear > 0)
                {
                    CurrentStatus.LastDiagnosisYear = diagnosisYear;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7MSDateDx");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7CISDateFirst - Date of first sign/symptom

        // Question 7CISDateFirst - Date of first sign/symptom
        if (!String.IsNullOrEmpty(mysQ7CISDateFirst.MonthYearString))
        {
            STD_QUESTION question7CISDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7CISDateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7CISDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7CISDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7CISDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.SymptomYear = mysQ7CISDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7CISDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7CISDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7RISDateFirst - Date of first sign/symptom
        //Question 7RISDateFirst - Date of first sign/symptom
        if (!String.IsNullOrEmpty(mysQ7RISDateFirst.MonthYearString))
        {
            STD_QUESTION question7RISDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7RISDateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {

                // Add Question 7RISDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7RISDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7RISDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.RISDiagnosisYear = mysQ7RISDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7RISDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.RISDiagnosisYear = symptomYear;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7RISDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7NMODateFirst - Date of first neurological sign/symptom (if known)

        // Question 7NMODateFirst - Date of first neurological sign/symptom (if known)
        if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
        {
            STD_QUESTION question7NMODateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NMODateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NMODateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NMODateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7NMODateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.SymptomYear = mysQ7NMODateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7NMODateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NMODateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7NMODx - Date of NMO diagnosis

        // Question 7NMODx - Date of NMO diagnosis
        if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
        {
            STD_QUESTION question7NMODx = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NMODx");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NMODx choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NMODx.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7NMODx.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.DiagnosisYear = mysQ7NMODx.MonthYearString;

                int diagnosisYear;
                Int32.TryParse(mysQ7NMODx.YearString, out diagnosisYear);
                if (diagnosisYear > 0)
                {
                    CurrentStatus.LastDiagnosisYear = diagnosisYear;
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NMODx");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 7NOMSComment - Comment

        // Question 7NOMSComment - Comment
        if (!String.IsNullOrEmpty(txtQ7NOMS.Text))
        {
            STD_QUESTION question7NOMSComment = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NOMSComment");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NOMSComment choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NOMSComment.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ7NOMS.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NOMSComment");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 8 - Type of initial MS/NMO symptom (check all that apply)

        // Question 8 - Type of initial MS/NMO symptom (check all that apply)
        if (getMsNmoSymptomCount() > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            STD_QUESTION question8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "8");

            try
            {
                string choiceStr = "";

                foreach (ListItem li in cblQ8.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                // Add Question 8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question8.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = choiceStr;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question8");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 9 - Multiple Sclerosis Subtype

        // Question 9 - Multiple Sclerosis Subtype
        if (rblQ9.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                //Relapsing-Remitting (RRMS)
                //Secondary Progressive (with or without relapses; SPMS)
                //Primary Progressive (PPMS)
                //Progressive-Relapsing (PRMS)
                //Not applicable (CIS or NMO)

                if (rblQ9.SelectedItem.Text.Contains("RRMS"))
                {
                    CurrentStatus.LastMSSubType = "RRMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("SPMS"))
                {
                    CurrentStatus.LastMSSubType = "SPMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("PPMS"))
                {
                    CurrentStatus.LastMSSubType = "PPMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("PRMS"))
                {
                    CurrentStatus.LastMSSubType = "PRMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("CIS"))
                {
                    CurrentStatus.LastMSSubType = "CIS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("NMO"))
                {
                    CurrentStatus.LastMSSubType = "NMO";
                }

                CurrentAssessmentHF.MSSubType = CurrentStatus.LastMSSubType;

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 9");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 9DateTran - Date transitioned

        // Question 9DateTran - Date transitioned
        if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
        {
            STD_QUESTION question9DateTran = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "9DateTran");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 9DateTran choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question9DateTran.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ9DateTran.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 9DateTran");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 10 - MS Service-Connection Status

        // Question 10 - MS Service-Connection Status
        if (rblQ10.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ10.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 10");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 11 - Current MS or NMO Disability

        // Question 11 - Current MS or NMO Disability
        if (rblQ11.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentStatus.LastEdumsScore = rblQ11.SelectedItem.Text.Substring(0, rblQ11.SelectedItem.Text.IndexOf(" ="));
                CurrentAssessmentHF.CurrentDisabilityScore = rblQ11.SelectedItem.Text.Substring(0, rblQ11.SelectedItem.Text.IndexOf(" ="));

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 11_6A - If applicable, year patient reached an EDMUS disability score of 6 (walks with unilateral or bilateral support)

        // Question 11_6A - If applicable, year patient reached an EDMUS disability score of 6 (walks with unilateral or bilateral support)
        if (!String.IsNullOrEmpty(mysQ11_6A.MonthYearString))
        {
            STD_QUESTION question11_6A = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "11_6A");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11_6A choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question11_6A.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ11_6A.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11_6A");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 11_8 - If applicable, year patient reached an EDMUS disability score of 8 (restricted to chair)

        // Question 11_8 - If applicable, year patient reached an EDMUS disability score of 8 (restricted to chair)
        if (!String.IsNullOrEmpty(mysQ11_8.MonthYearString))
        {
            STD_QUESTION question11_8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "11_8");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11_8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question11_8.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ11_8.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11_8");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 12 - Number of relapses* over the past twelve months

        // Question 12 - Number of relapses* over the past twelve months
        if (!String.IsNullOrEmpty(txtQ12.Text))
        {
            STD_QUESTION question12 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "12");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question12.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ12.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (!String.IsNullOrEmpty(txtQ12.Text))
                {
                    CurrentStatus.LastRelapses = Convert.ToInt32(txtQ12.Text);
                    CurrentAssessmentHF.Relapses = Convert.ToInt32(txtQ12.Text);
                }
                else
                {
                    CurrentStatus.LastRelapses = null;
                    CurrentAssessmentHF.Relapses = null;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 12");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 12A - Date of last relapse

        if (!String.IsNullOrEmpty(mysQ12A.MonthYearString))
        {
            STD_QUESTION question12aDateofRelapse = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "DATEOFLASTREALPSE");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DATEOFLASTREALPSE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question12aDateofRelapse.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ12A.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question Date of last relapse.");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }

        #endregion

        #region Question IG - Neutralizing Interferon Antibody status

        // Question IG - Neutralizing Interferon Antibody status
        if (rblQIG.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IG choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQIG.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQIG.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IG");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question IGP - Positive Date

        // Question IGP - Positive Date
        if (!String.IsNullOrEmpty(mysQIDPositive.MonthYearString))
        {
            STD_QUESTION questionIGP = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "IGP");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGP choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionIGP.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQIDPositive.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IGP");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question IGN - Negative Date

        // Question IGN - Negative Date
        if (!String.IsNullOrEmpty(mysQIDNegative.MonthYearString))
        {
            STD_QUESTION questionIGN = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "IGN");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGN choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionIGN.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQIDNegative.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IGN");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region CardioTox Monitored New Survey Result
        if (CardioToxMed != null && IsCardioToxChanged.ToLower() == "yes")
        {
            #region Question CardioTox - Is Patient being monitored for cardiotoxicity?

            // Question CardioTox - Is Patient being monitored for cardiotoxicity?            
            if (!string.IsNullOrEmpty(CardioToxMed.CardioToxMonitored))
            {
                _surveyResult = new SURVEY_RESULT();

                try
                {
                    // Add Question CardioTox choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(CardioToxMed.CardioToxQuestionChoiceId);
                    _surveyResult.RESULT_TEXT = CardioToxMed.CardioToxMonitored;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioTox");
                    errorMessage += surveyEx.Message.ToString() + "\r\n";
                    Logging.WriteLogToFile(errorMessage);
                    errorMessage = string.Empty;
                }
            }


            #endregion

            #region Question CardioToxYes - Date of most recent cardiac MUGA or Echocardiogram

            if (!String.IsNullOrEmpty(CardioToxMed.CardioToxYesDate))
            {
                STD_QUESTION questionCardioToxYes = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxYes");
                _surveyResult = new SURVEY_RESULT();

                try
                {
                    // Add Question CardioToxYes choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxYes.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;//CardioToxMed.CardioToxYesDateQuestionChoiceId;
                    _surveyResult.RESULT_TEXT = CardioToxMed.CardioToxYesDate;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxYes");
                    errorMessage += surveyEx.Message.ToString() + "\r\n";
                    Logging.WriteLogToFile(errorMessage);
                    errorMessage = string.Empty;
                }
            }

            #endregion

            #region Question CardioToxYes Date Unknown checkbox

            if (!string.IsNullOrEmpty(CardioToxMed.CardioToxDateUnknown))
            {
                STD_QUESTION questionCardioToxDateUnknown = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxDateUnknown");
                _surveyResult = new SURVEY_RESULT();

                try
                {
                    // Add Question CardioToxYes choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxDateUnknown.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;//CardioToxMed.CardioToxDateUnknownQuestionChoiceId;
                    _surveyResult.RESULT_TEXT = CardioToxMed.CardioToxDateUnknown;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxDateUnknown");
                    errorMessage += surveyEx.Message.ToString() + "\r\n";
                    Logging.WriteLogToFile(errorMessage);
                    errorMessage = string.Empty;
                }
            }


            #endregion
        }
        #endregion

        #region CardioTox Monitored Previous Survey Result

        if (CardioToxMedSurResult != null && !string.IsNullOrEmpty(IsCardioToxChanged))
        {
            if (IsCardioToxChanged.ToLower() == "no")
            {
                #region Question CardioTox - Is Patient being monitored for cardiotoxicity?

                // Question CardioTox - Is Patient being monitored for cardiotoxicity?            
                if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioTox))
                {
                    _surveyResult = new SURVEY_RESULT();

                    try
                    {
                        // Add Question CardioTox choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(CardioToxMedSurResult.CardioTox);
                        _surveyResult.RESULT_TEXT = CardioToxMedSurResult.CardioToxResultText;//CardioToxMed.CardioToxMonitored;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioTox");
                        errorMessage += surveyEx.Message.ToString() + "\r\n";
                        Logging.WriteLogToFile(errorMessage);
                        errorMessage = string.Empty;
                    }
                }


                #endregion

                #region Question CardioToxYes - Date of most recent cardiac MUGA or Echocardiogram

                if (!String.IsNullOrEmpty(CardioToxMedSurResult.CardioToxYes))
                {
                    STD_QUESTION questionCardioToxYes = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxYes");
                    _surveyResult = new SURVEY_RESULT();

                    try
                    {
                        // Add Question CardioToxYes choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxYes.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;//CardioToxMed.CardioToxYesDateQuestionChoiceId;
                        _surveyResult.RESULT_TEXT = CardioToxMedSurResult.CardioToxYes;// CardioToxMed.CardioToxYesDate;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxYes");
                        errorMessage += surveyEx.Message.ToString() + "\r\n";
                        Logging.WriteLogToFile(errorMessage);
                        errorMessage = string.Empty;
                    }
                }

                #endregion

                #region Question CardioToxYes Date Unknown checkbox

                if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioToxDateUnknown))
                {
                    STD_QUESTION questionCardioToxDateUnknown = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxDateUnknown");
                    _surveyResult = new SURVEY_RESULT();

                    try
                    {
                        // Add Question CardioToxYes choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxDateUnknown.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;//CardioToxMed.CardioToxDateUnknownQuestionChoiceId;
                        _surveyResult.RESULT_TEXT = CardioToxMedSurResult.CardioToxDateUnknown;//CardioToxMed.CardioToxDateUnknown;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxDateUnknown");
                        errorMessage += surveyEx.Message.ToString() + "\r\n";
                        Logging.WriteLogToFile(errorMessage);
                        errorMessage = string.Empty;
                    }
                }


                #endregion
            }
        }

        #endregion

        #region Question SJC - Neutralizing Interferon Antibody status

        // Question SJC - Neutralizing Interferon Antibody status

        if (rblQSJC.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question SJC choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQSJC.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQSJC.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJC");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question SJCP - Positive Date

        // Question SJCP - Positive Date
        if (!String.IsNullOrEmpty(mysQSJCPositive.MonthYearString))
        {
            STD_QUESTION questionSJCP = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "SJCP");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGP choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionSJCP.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQSJCPositive.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJCP");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question SJCN - Negative Date

        // Question SJCN - Negative Date
        if (!String.IsNullOrEmpty(mysQSJCNegative.MonthYearString))
        {
            STD_QUESTION questionSJCN = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "SJCN");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGN choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionSJCN.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQSJCNegative.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJCN");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
                Logging.WriteLogToFile(errorMessage);
                errorMessage = string.Empty;
            }
        }
        #endregion

        #region Question 13 - Medications

        try
        {
            // create string list for result text ... Question 13
            UpdateCurrentStatusRxWithMedSelection();
            if (CurrentMeds != null)
            {
                AddAndRemoveMedications();
                string medsStr = "";

                foreach (string mpm in CurrentMeds)
                {
                    medsStr += mpm + ",";
                }
                if (medsStr.EndsWith(","))
                {
                    medsStr = medsStr.Substring(0, medsStr.Length - 1);
                }

                STD_QUESTION question13 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "13");
                _surveyResult = new SURVEY_RESULT();

                try
                {
                    // Add Question 13 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = question13.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = medsStr; // store ',' delimited string or MSSR_PATIENT_MEDICATION IDs
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "Question 13");
                    errorMessage += surveyEx.Message.ToString() + "\r\n";
                    Logging.WriteLogToFile(errorMessage);
                    errorMessage = string.Empty;
                }
            }
        }
        catch (Exception ex)
        {
            HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question Patient Medication");
            errorMessage += ex.Message.ToString() + "\r\n";
            Logging.WriteLogToFile(errorMessage);
            errorMessage = string.Empty;
        }

        #endregion

        #region Corticosteroids


        // Call UpdateSurveyWithCorticosteroidSelections to update passed SURVEY object.            
        ctrlCorticosteroidsSelection.UpdateSurveyWithCorticosteroidSelections(ref _survey);

        string currentMedCort = ctrlCorticosteroidsSelection.GetCorticosteroidCurrentMeds();
        string pastMedCort = ctrlCorticosteroidsSelection.GetCorticosteroidPastMeds();



        if (!String.IsNullOrEmpty(CurrentStatus.RxAll) && !String.IsNullOrEmpty(currentMedCort))
        {
            CurrentStatus.RxAll += ", " + currentMedCort;
        }
        else if (String.IsNullOrEmpty(CurrentStatus.RxAll) && !String.IsNullOrEmpty(currentMedCort))
        {
            CurrentStatus.RxAll = currentMedCort;
        }

        if (!String.IsNullOrEmpty(CurrentStatus.RxEverAll) && !String.IsNullOrEmpty(pastMedCort))
        {
            CurrentStatus.RxEverAll += ", " + pastMedCort;
        }
        else if (String.IsNullOrEmpty(CurrentStatus.RxEverAll) && !String.IsNullOrEmpty(pastMedCort))
        {
            CurrentStatus.RxEverAll = pastMedCort;
        }


        #endregion

        #region Question HF - store health factors

        // Question HF - store health factors
        if (!String.IsNullOrEmpty(txtHealthFactors.Text))
        {
            STD_QUESTION questionHF = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "HF");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question HF choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionHF.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtHealthFactors.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "saveSurvey() - Question HF");
            }
        }

        #endregion

        #region Store Health Factors - separate table
        string stationNumber = GetStationNumberByInstitutionId(survey.STD_INSTITUTION_ID);

        if (!String.IsNullOrEmpty(txtHealthFactors.Text))
        {
            try
            {
                List<MSSR_HEALTH_FACTOR> healthFactorList = new List<MSSR_HEALTH_FACTOR>();
                string[] hfList = txtHealthFactors.Text.Split(',');


                foreach (string hf in hfList)
                {
                    healthFactorList.Add(new MSSR_HEALTH_FACTOR() { ID = Guid.NewGuid(), HEALTH_FACTOR_TYPE = hf.Trim(), PATIENT_ICN = this.PatientIcn, STA3N = Convert.ToInt16(VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(stationNumber)), SURVEY_ID = survey.SURVEYS_ID, CREATED = DateTime.Now });
                }

                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    int surveyId = survey.SURVEYS_ID;
                    ctx.MSSR_HEALTH_FACTORs.DeleteAllOnSubmit(ctx.MSSR_HEALTH_FACTORs.Where(M => M.SURVEY_ID == surveyId && M.PATIENT_ICN == this.PatientIcn));
                    ctx.SubmitChanges();

                    ctx.MSSR_HEALTH_FACTORs.InsertAllOnSubmit(healthFactorList);
                    ctx.SubmitChanges();
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Store Health Factors");
            }
        }

        #endregion

        CurrentStatus.PatientICN = Convert.ToInt32(PatientIcn);
        CurrentAssessmentHF.PatientICN = Convert.ToInt32(PatientIcn);
        CurrentStatus.Sta3n = (!String.IsNullOrEmpty(stationNumber) ? (int?)VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(stationNumber) : null);
        CurrentAssessmentHF.Sta3n = Convert.ToInt16(VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(stationNumber));

        patientDem.PatientICN = Convert.ToInt32(PatientIcn);
        patientDem.PatientSoSeN = GetPaientSnumByPatientIcn(); 


        Logging.WriteLogToFile("SaveSurvey: end");

        return errorMessage;

    }

    private string GetStationNumberByInstitutionId(int? institutionId)
    {
        string stationId = string.Empty;
        var surveyManager = new SurveyViewManager(CurrentUser);
        stationId = surveyManager.GetStationIdByInstId(institutionId);
        return stationId;
    }

    private void UpdateCurrentStatusRxWithMedSelection()
    {
        // Get top 3 meds for CURRENT_STATUS and then all ... 
        int currentCount = 0;
        int pastCount = 0;
        string currentMeds = "";
        string pastMeds = "";
        MedsViewManager mdManager = new MedsViewManager();
        var patientMedsList = mdManager.GetListOfMedsBySurveyId(this.SurveyId);
        foreach (MSSR_PATIENT_MEDICATION med in patientMedsList)
        {
            if (med.CURRENT_THERAPY != null && (bool)med.CURRENT_THERAPY)
            {
                currentCount++;

                if (currentCount == 1)
                {
                    CurrentStatus.Rx1 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (currentCount == 2)
                {
                    CurrentStatus.Rx2 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (currentCount == 3)
                {
                    CurrentStatus.Rx3 = med.MSSR_MEDICATION.MEDICATION;
                }

                currentMeds += med.MSSR_MEDICATION.MEDICATION + ", ";

            }
            else if (med.PAST_USE != null && (bool)med.PAST_USE)
            {
                pastCount++;

                if (pastCount == 1)
                {
                    CurrentStatus.RxEver1 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (pastCount == 2)
                {
                    CurrentStatus.RxEver2 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (pastCount == 3)
                {
                    CurrentStatus.RxEver3 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (pastCount == 4)
                {
                    CurrentStatus.RxEver4 = med.MSSR_MEDICATION.MEDICATION;
                }
                else if (pastCount == 5)
                {
                    CurrentStatus.RxEver5 = med.MSSR_MEDICATION.MEDICATION;
                }

                pastMeds += med.MSSR_MEDICATION.MEDICATION + ", ";
            }
        }

        if (true)
            Logging.WriteLogToFile("SaveSurvey: after foreach (MSSR_PATIENT_MEDICATION med in patientMedsList)");

        if (!String.IsNullOrEmpty(currentMeds))
        {
            if (currentMeds.EndsWith(", "))
            {
                currentMeds = currentMeds.Substring(0, currentMeds.Length - 2).ToUpper();
            }
        }

        CurrentStatus.RxAll = currentMeds;

        if (!String.IsNullOrEmpty(pastMeds))
        {
            if (pastMeds.EndsWith(", "))
            {
                pastMeds = pastMeds.Substring(0, pastMeds.Length - 2).ToUpper();
            }
        }

        CurrentStatus.RxEverAll = pastMeds;
    }

    private void LogSelectionsForDebugging()
    {
        try
        {
            // Log the selections before save for debugging purposes
            var setting = Helpers.GetDBConfigEntry("MSSRLogSelectionsBeforeSave");

            if (setting != null)
            {
                if (setting.ToString().ToLower().Contains("yes"))
                {
                    Logging.WriteLogToFile(txtNotePreview.Text);
                    Logging.WriteLogToFile(txtHealthFactors.Text);
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SaveSurvey Failed writing Note and HF to log");
        }
    }

    private List<STD_QUESTION> PopulateStdQuestionsListForSetUpSurvey(SURVEY survey, ref bool writeTimeToLog)
    {
        if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
        {
            string surveysId = "unset";

            if (survey.SURVEYS_ID != null)
                surveysId = survey.SURVEYS_ID.ToString();

            Logging.WriteLogToFile("SaveSurvey: Starting - survey id: " + surveysId);
            writeTimeToLog = true;
        }

        List<STD_QUESTION> questions;
        if (QuestionList == null || QuestionList.Count == 0)
        {
            questions = GetAllQuestionsForSurvey();

            if (writeTimeToLog)
                Logging.WriteLogToFile("SaveSurvey: after GetAllQuestionsForSummary()");
        }
        else
        {
            questions = QuestionList;
        }
        return questions;
    }

    private string GetPaientSnumByPatientIcn()
    {
        string resultSnum = string.Empty;
        SurveyViewManager mgr = new SurveyViewManager(this.CurrentUser);
        resultSnum = mgr.GetPatinetSnumByPatientIcn(PatientIcn);

        return resultSnum;

    }

    private void AddAndRemoveMedications()
    {
        foreach (var med in MedsToDelete)
        {
            if (med.SurveyId == SurveyId)
            {
                CurrentMeds.Remove(med.Id.ToString());
            }
        }
        foreach (var med in MedsToAdd)
        {
            if (med.SurveyId == SurveyId)
            {
                CurrentMeds.Add(med.Id.ToString());
            }
        }

    }

    private int getBioFamHisMsCount(CheckBoxList source)
    {
        int selectedItems = 0;

        foreach (ListItem li in source.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }

    private int getTypeInitialSymptomCount()
    {
        int selectedItems = 0;

        foreach (ListItem li in cblQ8.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }

    private string processAssessment()
    {
        string errorString = "";

        //errorString = setMedicationControls();

        #region Variable Declaration

        StringBuilder healthFactorString = new StringBuilder(); // to store string of heath factors. (comma separated values)
        StringBuilder msAssessmentNoteString = new StringBuilder(); // to store note summary.

        try
        {

            List<STD_QUESTION> questions = (QuestionList == null || QuestionList.Count == 0) ? GetAllQuestionsForSurvey() : QuestionList;

            string selectedItem = rblAssessmentType.SelectedItem.Text.ToLower();

        #endregion




            #region Health Factor Creation

            #region Assessment Date

            if (dpDate1.SelectedDate != null)
            {
                msAssessmentNoteString.Append("Assessment Date \r\n");
                msAssessmentNoteString.Append("\t" + ((DateTime)dpDate1.SelectedDate).ToShortDateString() + "\r\n");
            }

            #endregion

            #region Process Assessment Type

            if (rblAssessmentType.SelectedItem != null)
            {
                string assessmentTypeHF = getAssessmentTypeHealthFactor(rblAssessmentType.SelectedItem.Text.ToLower());
                healthFactorString.Append(assessmentTypeHF);

                msAssessmentNoteString.Append(GetQuestionText("AT") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblAssessmentType.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Interview Type - MSCOE.INTERVIEW.FACE TO FACE, MSCOE.INTERVIEW.TELEPHONE, MSCOE.INTERVIEW.VIDEO CONFERENCE

            if (rblQIC.SelectedItem != null)
            {
                string interviewTypeHF = getInterviewTypeHealthFactor(rblQIC.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(interviewTypeHF))
                {
                    interviewTypeHF = ", " + interviewTypeHF;
                }
                healthFactorString.Append(interviewTypeHF);

                msAssessmentNoteString.Append(GetQuestionText("IC") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQIC.SelectedItem.Text + "\r\n");
            }

            #endregion
            #region DOD

            if (dpDate2.SelectedDate != null)
            {
                msAssessmentNoteString.Append("Date Of Death \r\n");
                msAssessmentNoteString.Append("\t" + ((DateTime)dpDate2.SelectedDate).ToShortDateString() + "\r\n");
            }

            #endregion

            #region COD

            if (ddlCauseOfDeathType.SelectedValue != "")
            {
                msAssessmentNoteString.Append("Cause Of Death \r\n");
                msAssessmentNoteString.Append("\t" + ddlCauseOfDeathType.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Race as defined by patient - Question 1 - MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE / MSCOE.RACE.ASIAN / MSCOE.RACE.BLACK/AFRICAN AMERICAN / MSCOE.RACE.OTHER / MSCOE.RACE.PACIFIC ISLANDER / MSCOE.RACE.WHITE

            if (rblQ1.SelectedItem != null)
            {
                string raceHF = getRaceHealthFactor(rblQ1.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(raceHF))
                {
                    raceHF = ", " + raceHF;
                }
                healthFactorString.Append(raceHF);

                msAssessmentNoteString.Append("Question 1: " + GetQuestionText("1") + "\r\n");

                if (rblQ1.SelectedItem.Text.ToLower() == "other")
                {
                    msAssessmentNoteString.Append("\t" + rblQ1.SelectedItem.Text + (!String.IsNullOrEmpty(txtQ1Other.Text) ? (" - " + txtQ1Other.Text) : "") + "\r\n");
                }
                else
                {
                    msAssessmentNoteString.Append("\t" + rblQ1.SelectedItem.Text + "\r\n");
                }
            }

            #endregion

            #region Determine Ethnicity as defined by patient - MSCOE.ETHNICITY.HISPANIC / MSCOE.ETHNICITY.NON HISPANIC - Question 2

            if (rblQ2.SelectedItem != null)
            {
                string ethnicityHF = getEthnicityHealthFactor(rblQ2.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(ethnicityHF))
                {
                    ethnicityHF = ", " + ethnicityHF;
                }
                healthFactorString.Append(ethnicityHF);

                msAssessmentNoteString.Append("Question 2: " + GetQuestionText("2") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ2.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Gender - Question 3

            if (rblQ3.SelectedItem != null)
            {
                // Note
                msAssessmentNoteString.Append("Question 3: " + GetQuestionText("3") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ3.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Family History MS - Question 4


            if (rblQ4.SelectedItem != null)
            {
                string familyHistoryMSConfirmed = null;
                string familyHistoryMSHF = string.Empty;
                bool familyHistoryMSHFOther = false;
                string famHistoryMSText = string.Empty;

                if (rblQ4.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ4.SelectedItem.Text))
                    {
                        familyHistoryMSConfirmed = rblQ4.SelectedItem.Text.ToLower();
                        famHistoryMSText = rblQ4.SelectedItem.Text;
                    }
                }
                if (!string.IsNullOrEmpty(familyHistoryMSHF))
                {
                    familyHistoryMSHF += ", ";
                }
                if (familyHistoryMSConfirmed == "yes" && getBioFamHisMsCount(rblQ4a) > 0)
                {
                    familyHistoryMSHF = ", MSCOE.FMX.MS CONFIRMED";
                    foreach (ListItem li in rblQ4a.Items)
                    {
                        if (li.Selected)
                        {
                            familyHistoryMSHF += getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), li.Text.ToLower());
                            famHistoryMSText += " - " + li.Text.ToLower();
                            if (li.Text.ToLower() == "other")
                            {
                                familyHistoryMSHFOther = true;
                            }
                        }
                    }
                }
                else
                {
                    familyHistoryMSHF += getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), familyHistoryMSConfirmed);
                }
                healthFactorString.Append(familyHistoryMSHF);
                msAssessmentNoteString.Append("Question 4: " + GetQuestionText("4") + "\r\n");
                if (rblQ4a.SelectedIndex > -1)
                {
                    if (familyHistoryMSHFOther)
                    {
                        famHistoryMSText += " - " + " (" + txtQ4aOther.Text + ")";
                    }
                    else
                    {
                        famHistoryMSText += "";
                    }
                }
                else if (rblQ4.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryMSText += " - " + txtQ4UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryMSText + "\r\n");
            }

            #endregion

            #region Determine Family History CIS - Question 5
            if (rblQ5.SelectedItem != null)
            {
                string familyHistoryCISConfirmed = null;
                string familyHistoryCISHF = string.Empty;
                bool familyHistoryCISHFOther = false;
                string famHistoryCISText = string.Empty;
                if (rblQ5.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ5.SelectedItem.Text))
                    {
                        familyHistoryCISConfirmed = rblQ5.SelectedItem.Text.ToLower();
                        famHistoryCISText = rblQ5.SelectedItem.Text;
                    }
                }
                if (!string.IsNullOrEmpty(familyHistoryCISHF))
                {
                    familyHistoryCISHF += ", ";
                }
                if (familyHistoryCISConfirmed == "yes" && getBioFamHisMsCount(rblQ5a) > 0)
                {
                    familyHistoryCISHF = ", MSCOE.FMX.CIS CONFIRMED";
                    foreach (ListItem li in rblQ5a.Items)
                    {
                        if (li.Selected)
                        {
                            familyHistoryCISHF += getFamilyHistoryCISHealthFactor(rblQ5.SelectedItem.Text.ToLower(), li.Text.ToLower());
                            famHistoryCISText += " - " + li.Text.ToLower();
                            if (li.Text.ToLower() == "other")
                            {
                                familyHistoryCISHFOther = true;
                            }
                        }
                    }
                }
                else
                {
                    familyHistoryCISHF += getFamilyHistoryCISHealthFactor(rblQ5.SelectedItem.Text.ToLower(), familyHistoryCISConfirmed);
                }

                healthFactorString.Append(familyHistoryCISHF);
                msAssessmentNoteString.Append("Question 5: " + GetQuestionText("5") + "\r\n");

                if (rblQ5a.SelectedIndex > -1)
                {
                    if (familyHistoryCISHFOther)
                    {
                        famHistoryCISText += " - " + " (" + txtQ5aOther.Text + ")";
                    }
                    else
                    {
                        famHistoryCISText += "";
                    }
                }
                else if (rblQ5.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryCISText += " - " + txtQ5UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryCISText + "\r\n");
            }

            #endregion

            #region Determine Family History NMO - Question 6
            if (rblQ6.SelectedItem != null)
            {
                string familyHistoryNMOConfirmed = null;
                string familyHistoryNMOHF = string.Empty;
                bool familyHistoryNMOHFOther = false;
                string famHistoryNMOText = string.Empty;

                if (rblQ6.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ6.SelectedItem.Text))
                    {
                        familyHistoryNMOConfirmed = rblQ6.SelectedItem.Text.ToLower();
                        famHistoryNMOText = rblQ6.SelectedItem.Text;
                    }
                }
                if (!String.IsNullOrEmpty(familyHistoryNMOHF))
                {
                    familyHistoryNMOHF = ", " + familyHistoryNMOHF;
                }
                if (familyHistoryNMOConfirmed == "yes" && getBioFamHisMsCount(rblQ6a) > 0)
                {
                    familyHistoryNMOHF = ", MSCOE.FMX.NMO CONFIRMED";
                    foreach (ListItem li in rblQ6a.Items)
                    {
                        if (li.Selected)
                        {
                            familyHistoryNMOHF += getFamilyHistoryNMOHealthFactor(rblQ6.SelectedItem.Text.ToLower(), li.Text.ToLower());
                            famHistoryNMOText += " - " + li.Text.ToLower();
                            if (li.Text.ToLower() == "other")
                            {
                                familyHistoryNMOHFOther = true;
                            }
                        }
                    }
                }
                else
                {
                    familyHistoryNMOHF += getFamilyHistoryNMOHealthFactor(rblQ6.SelectedItem.Text.ToLower(), familyHistoryNMOConfirmed);
                }

                healthFactorString.Append(familyHistoryNMOHF);
                msAssessmentNoteString.Append("Question 6: " + GetQuestionText("6") + "\r\n");

                if (rblQ6a.SelectedIndex > -1)
                {
                    if (familyHistoryNMOHFOther)
                    {
                        famHistoryNMOText += " - " + " (" + txtQ6aOther.Text + ")";
                    }
                    else
                    {
                        famHistoryNMOText += "";
                    }
                }
                else if (rblQ6.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryNMOText += " - " + txtQ6UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryNMOText + "\r\n");
            }

            #endregion

            #region Determine Diagnosis History - Question 7

            if (rblQ7.SelectedItem != null)
            {
                string diagnosisHistory = getDiagnosisHistory(rblQ7.SelectedItem.Text.ToLower());
                healthFactorString.Append(diagnosisHistory);

                // Note
                msAssessmentNoteString.Append("Question 7: " + GetQuestionText("7") + "\r\n");
                string diagnosisHistoryText = rblQ7.SelectedItem.Text;
                msAssessmentNoteString.Append("\t" + diagnosisHistoryText + "\r\n");

                #region Question 7 sub-areas

                if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
                {
                    // nothing

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
                {
                    if (!String.IsNullOrEmpty(txtQ7NOMS.Text))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NOMSComment") + "\r\n");
                        msAssessmentNoteString.Append("\t" + txtQ7NOMS.Text + "\r\n");
                    }

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
                {

                    //MSCOE.YEAR OF FIRST MS SYMPTOM
                    if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7MSDateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7MSDateFirst.MonthYearString + "\r\n");
                    }

                    //MSCOE.YEAR OF MS DIAGNOSIS
                    if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7MSDateDx") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7MSDateDx.MonthYearString + "\r\n");
                    }

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
                {
                    // nothing

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
                {

                    //MSCOE.YEAR OF FIRST NMO SYMPTOM
                    if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NMODateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7NMODateFirst.MonthYearString + "\r\n");
                    }

                    //MSCOE.YEAR OF NMO DIAGNOSIS
                    if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NMODx") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7NMODx.MonthYearString + "\r\n");
                    }
                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("radiologically isolated syndrome"))
                {
                    if (!String.IsNullOrEmpty(mysQ7RISDateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7RISDateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7RISDateFirst.MonthYearString + "\r\n");
                    }

                }

                #endregion
            }

            #endregion

            #region Determine Type of Initial Symptoms - Question 8

            //getMsNmoInitialSymptoms
            if (getMsNmoSymptomCount() > 0)
            {
                string symptomHF = "";
                string symptomNoteString = "";
                foreach (ListItem li in cblQ8.Items)
                {
                    if (li.Selected)
                    {
                        if (!String.IsNullOrEmpty(symptomHF))
                        {
                            symptomHF += ", ";
                        }
                        symptomHF += getMsNmoInitialSymptoms(li.Text.ToLower());

                        if (!String.IsNullOrEmpty(symptomNoteString))
                        {
                            symptomNoteString += ", ";
                        }
                        symptomNoteString += li.Text;
                    }
                }

                if (!String.IsNullOrEmpty(symptomHF))
                {
                    symptomHF = ", " + symptomHF;
                }
                healthFactorString.Append(symptomHF);

                msAssessmentNoteString.Append("Question 8: " + GetQuestionText("8") + "\r\n");
                msAssessmentNoteString.Append("\t" + symptomNoteString + "\r\n");
            }

            #endregion

            #region Determine Multiple Sclerosis Subtype - Question 9

            if (rblQ9.SelectedItem != null)
            {
                string msSubtypeHF = getMsSubtypeHealthFactor(rblQ9.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(msSubtypeHF))
                {
                    msSubtypeHF = ", " + msSubtypeHF;
                }

                healthFactorString.Append(msSubtypeHF);

                msAssessmentNoteString.Append("Question 9: " + GetQuestionText("9") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ9.SelectedItem.Text + "\r\n");

                if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("9DateTran") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ9DateTran.MonthYearString + "\r\n");
                }

            }

            #endregion

            #region Determine MS Service-Connection Status - Question 10

            if (rblQ10.SelectedItem != null)
            {
                string serviceConnectedStatusHF = getServiceConnectedStatusHealthFactor(rblQ10.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(serviceConnectedStatusHF))
                {
                    serviceConnectedStatusHF = ", " + serviceConnectedStatusHF;
                }

                healthFactorString.Append(serviceConnectedStatusHF);

                msAssessmentNoteString.Append("Question 10: " + GetQuestionText("10") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ10.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Current MS or NMO Disability - Question 11

            if (rblQ11.SelectedItem != null)
            {
                string currentMsOrNmoDisabilityHF = getCurrentMsNmoDisability(rblQ11.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(currentMsOrNmoDisabilityHF))
                {
                    currentMsOrNmoDisabilityHF = ", " + currentMsOrNmoDisabilityHF;
                }

                healthFactorString.Append(currentMsOrNmoDisabilityHF);

                msAssessmentNoteString.Append("Question 11: " + GetQuestionText("11") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ11.SelectedItem.Text + "\r\n");

                if (rblQ11.SelectedItem.Text.ToLower().Contains("6a =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("6b =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("7 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("11_6A") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ11_6A.MonthYearString + "\r\n");
                }

                if (rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("11_8") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ11_8.MonthYearString + "\r\n");
                }
            }

            #endregion

            #region Detemine Number of Relapses - Question 12

            // Question 12 - num relapses ...
            if (!String.IsNullOrEmpty(txtQ12.Text))
            {
                int numRelapses = 0;
                if (Int32.TryParse(txtQ12.Text, out numRelapses))
                {
                    msAssessmentNoteString.Append("Question 12: " + GetQuestionText("12") + "\r\n");
                    msAssessmentNoteString.Append("\t" + txtQ12.Text + "\r\n");
                }
            }

            #endregion

            #region
            if (!string.IsNullOrEmpty(mysQ12A.MonthYearString))
            {
                msAssessmentNoteString.Append("Question 12A: " + GetQuestionText("DATEOFLASTREALPSE") + "\r\n");
                msAssessmentNoteString.Append("  - " + GetQuestionText("DATEOFLASTREALPSE") + "\r\n");
                msAssessmentNoteString.Append("\t" + mysQ12A.MonthYearString + "\r\n");
            }

            #endregion


            #region Determine Serum anti-JC virus antibody status - Question SJC

            //MSCOE.ANTI-JC VIRUS.NEGATIVE
            //MSCOE.ANTI-JC VIRUS.POSITIVE
            //MSCOE.ANTI-JC VIRUS.UNKNOWN

            string sjcSelectedItem = getRblQSJCSelectedItem();

            string sjcHF = getSJCHealthFactor(sjcSelectedItem.ToLower());

            if (!String.IsNullOrEmpty(sjcHF))
            {
                sjcHF = ", " + sjcHF;
            }

            healthFactorString.Append(sjcHF);

            #endregion

            #region Determine Medication Health Factors


            StringBuilder medicationHFs = new StringBuilder();
            StringBuilder medicationNoteSummary = new StringBuilder();

            #region loop through rptMedication

            msAssessmentNoteString.Append("\r\nMedication History\r\n");
            msAssessmentNoteString.Append("\r\nNon-Interferon Group Medications:\r\n");

            NoteSummaryHealthFactorsResponse noteSummaryAndHealthFactors = GetMedicationNoteSummaryHealthFactors();

            if (noteSummaryAndHealthFactors != null)
            {
                healthFactorString.Append(noteSummaryAndHealthFactors.HealthFactors);
                msAssessmentNoteString.Append(noteSummaryAndHealthFactors.NoteSummary);
            }


            msAssessmentNoteString.Append(medicationNoteSummary.ToString());
            medicationNoteSummary.Remove(0, medicationNoteSummary.Length);
            #endregion

            #region loop through rptInterferonGroupMedication

            msAssessmentNoteString.Append("\r\nInterferon Group Medications:\r\n\r\n");

            #region Neutralizing Interferon Antibody Status - Question IG

            //MSCOE.NIAB.NEGATIVE
            //MSCOE.NIAB.POSITIVE
            //MSCOE.NIAB.UNKNOWN

            if (rblQIG.SelectedItem != null)
            {
                string niabHF = getIGHealthFactor(rblQIG.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(niabHF))
                {
                    niabHF = ", " + niabHF;
                }

                healthFactorString.Append(niabHF);

                msAssessmentNoteString.Append("-  " + GetQuestionText("IG") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQIG.SelectedItem.Text + "\r\n");

                if (!string.IsNullOrEmpty(niabHF) && niabHF.ToUpper().EndsWith("POSITIVE"))
                {
                    msAssessmentNoteString.Append("\t" + mysQIDPositive.Label + " " + mysQIDPositive.MonthYearString + "\r\n\r\n");
                }
                if (!string.IsNullOrEmpty(niabHF) && niabHF.ToUpper().EndsWith("NEGATIVE"))
                {
                    msAssessmentNoteString.Append("\t" + mysQIDNegative.Label + " " + mysQIDNegative.MonthYearString + "\r\n\r\n");
                }
            }

            #endregion

            #region SJC
            if (rblQSJC.SelectedItem != null)
            {
                msAssessmentNoteString.Append("-  " + GetQuestionText("SJC") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQSJC.SelectedItem.Text + "\r\n");

                if (rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
                {
                    msAssessmentNoteString.Append("\t" + mysQSJCNegative.Label);

                    if (mysQSJCNegative.MonthYearString.Length > 0)
                    {
                        msAssessmentNoteString.Append(" " + mysQSJCNegative.MonthYearString + "\r\n");
                    }
                    else
                    {
                        msAssessmentNoteString.Append("\t\tDATE UNKNOWN\r\n");
                    }
                }
                else if (rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
                {
                    msAssessmentNoteString.Append("\t" + mysQSJCPositive.Label);

                    if (mysQSJCPositive.MonthYearString.Length > 0)//                           
                    {
                        msAssessmentNoteString.Append(" " + mysQSJCPositive.MonthYearString + "\r\n");
                    }
                    else
                    {
                        msAssessmentNoteString.Append("\t\tDATE UNKNOWN\r\n");
                    }
                }
            }

            #endregion


            #endregion



            msAssessmentNoteString.Append(medicationNoteSummary.ToString());
            medicationNoteSummary.Remove(0, medicationNoteSummary.Length);
            #endregion

            #region Determine Other Medication Health Factors



            #endregion

            #region Determine Corticosteroids

            string corticosteroidHF = ctrlCorticosteroidsSelection.GetCorticosteroidHealthFactors();

            if (!String.IsNullOrEmpty(corticosteroidHF))
            {
                corticosteroidHF = ", " + corticosteroidHF;
            }

            healthFactorString.Append(corticosteroidHF);

            // note summary
            msAssessmentNoteString.Append(ctrlCorticosteroidsSelection.GetCorticosteroidNoteSummary());

            #endregion

            #endregion

            // Write Note Preview in textbox.
            txtNotePreview.Text = msAssessmentNoteString.ToString();

            // Write Health Factor Preview in textbox.
            txtHealthFactors.Text = healthFactorString.ToString();

            System.Diagnostics.StackTrace stackTrace = new System.Diagnostics.StackTrace();
            System.Reflection.MethodBase methodBase = stackTrace.GetFrame(1).GetMethod();
            string callerName = methodBase.Name;
        }
        catch (Exception ex)
        {
            HandleMSSRException(ex, "MSAssessmentTool.aspx", "0", "processAssessment");

            errorString += ex.Message;
        }

        return errorString;
    }

    private NoteSummaryHealthFactorsResponse GetMedicationNoteSummaryHealthFactors()
    {
        MedsViewManager mdsMgr = new MedsViewManager();
        HealthFactorModel mdsHf = mdsMgr.GetMedsHealthFactor(SurveyId);
        NoteSummaryHealthFactorsResponse noteHfResponse = GetHealthFactorsForMedication(mdsHf.MedsUsedWithHealthFactor);


        return noteHfResponse;
    }

    private string getDiagnosisHistory(string selectedText)
    {
        string returnStr = "";

        //MSCOE.DX.CIS
        //MSCOE.DX.MS
        //MSCOE.DX.NMO
        //MSCOE.DX.NOT MS
        //MSCOE.DX.POSSIBLE MS

        if (selectedText.Contains("possible multiple"))
        {
            returnStr = ", MSCOE.DX.POSSIBLE MS";

        }
        else if (selectedText.Contains("determined not"))
        {
            returnStr = ", MSCOE.DX.NOT MS";

        }
        else if (selectedText.Contains("multiple sclerosis"))
        {
            returnStr = ", MSCOE.DX.MS";

            //MSCOE.YEAR OF FIRST MS SYMPTOM
            if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF FIRST MS SYMPTOM";
            }

            //MSCOE.YEAR OF MS DIAGNOSIS
            if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF MS DIAGNOSIS";
            }

        }
        else if (selectedText.Contains("clinically isolated"))
        {
            returnStr = "MSCOE.DX.CIS";

        }
        else if (selectedText.Contains("neuromyelitis optica"))
        {
            returnStr = "MSCOE.DX.NMO";

            //MSCOE.YEAR OF FIRST NMO SYMPTOM
            if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF FIRST NMO SYMPTOM";
            }

            //MSCOE.YEAR OF NMO DIAGNOSIS
            if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF NMO DIAGNOSIS";
            }
        }

        return returnStr;
    }

    private string getFamilyHistoryMSHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.MS CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.MS BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.MS DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.MS FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.MS MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.MS OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.MS SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.MS SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.MS NEGATIVE";
        }
        else // UNKNOWN
        {
            return ", MSCOE.FMX.MS UNKNOWN";
        }
    }

    private string getFamilyHistoryCISHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.CIS CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.CIS BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.CIS DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.CIS FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.CIS MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.CIS OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.CIS SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.CIS SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.CIS NEGATIVE";
        }
        else
        {
            return ", MSCOE.FMX.CIS UNKNOWN";
        }
    }

    private string getAssessmentTypeHealthFactor(string selectedText)
    {
        if (selectedText.Contains("baseline"))
        {
            return "MSCOE.BASELINE ASSESSMENT";
        }
        else if (selectedText.Contains("annual"))
        {
            return "MSCOE.ANNUAL ASSESSMENT";
        }
        else if (selectedText.Contains("interim"))
        {
            return "MSCOE.INTERIM ASSESSMENT";
        }
        else if (selectedText.Contains("medications only"))
        {
            return "MSCOE.MEDICATIONS ONLY ASSESSMENT";
        }
        else
        {
            return "";
        }
    }

    private string getCurrentMsNmoDisability(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("1 ="))
        {
            returnStr = "MSCOE.EDMUS.01";

        }
        else if (selectedText.Contains("2 ="))
        {
            returnStr = "MSCOE.EDMUS.02";

        }
        else if (selectedText.Contains("3 ="))
        {
            returnStr = "MSCOE.EDMUS.03";

        }
        else if (selectedText.Contains("4 ="))
        {
            returnStr = "MSCOE.EDMUS.04";

        }
        else if (selectedText.Contains("5 ="))
        {
            returnStr = "MSCOE.EDMUS.05";

        }
        else if (selectedText.Contains("6a ="))
        {
            returnStr = "MSCOE.EDMUS.06A";

        }
        else if (selectedText.Contains("6b ="))
        {
            returnStr = "MSCOE.EDMUS.06B";

        }
        else if (selectedText.Contains("7 ="))
        {
            returnStr = "MSCOE.EDMUS.07";

        }
        else if (selectedText.Contains("8 ="))
        {
            returnStr = "MSCOE.EDMUS.08";

        }
        else if (selectedText.Contains("9 ="))
        {
            returnStr = "MSCOE.EDMUS.09";

        }
        else if (selectedText.Contains("10 ="))
        {
            returnStr = "MSCOE.EDMUS.10";

        }

        // Question 12 - num relapses ...
        if (!String.IsNullOrEmpty(txtQ12.Text))
        {
            int numRelapses = 0;
            if (Int32.TryParse(txtQ12.Text, out numRelapses))
            {
                returnStr += ", MSCOE.RELAPSE.IN PREVIOUS YEAR";
            }
        }

        return returnStr;
    }

    private string getEthnicityHealthFactor(string selectedText)
    {
        if (selectedText.Contains("not hispanic"))
        {
            return "MSCOE.ETHNICITY.NON HISPANIC";
        }
        else if (selectedText.Contains("hispanic"))
        {
            return "MSCOE.ETHNICITY.HISPANIC";
        }
        else
        {
            return "";
        }
    }

    private string getSJCHealthFactor(string selectedText)
    {
        //MSCOE.ANTI-JC VIRUS.NEGATIVE, MSCOE.ANTI-JC VIRUS.POSITIVE, MSCOE.ANTI-JC VIRUS.UNKNOWN
        string returnStr = "";

        if (selectedText.Contains("negative"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.NEGATIVE";

        }
        else if (selectedText.Contains("positive"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.POSITIVE";

        }
        else if (selectedText.Contains("unknown"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.UNKNOWN";

        }

        return returnStr;
    }

    private string getFamilyHistoryNMOHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.NMO CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.NMO BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.NMO DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.NMO FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.NMO MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.NMO OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.NMO SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.NMO SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.NMO NEGATIVE";
        }
        else
        {
            return ", MSCOE.FMX.NMO UNKNOWN";
        }
    }

    private string getServiceConnectedStatusHealthFactor(string selectedText)
    {
        //MSCOE.MS SC.NO, MSCOE.MS SC.YES
        string returnStr = "";

        if (selectedText.Contains("patient is not service"))
        {
            returnStr = "MSCOE.MS SC.NO";

        }
        else if (selectedText.Contains("patient is service"))
        {
            returnStr = "MSCOE.MS SC.YES";

        }

        return returnStr;
    }

    public string getRblQSJCSelectedItem()
    {
        string val = "";

        if (rblQSJC.SelectedItem != null)
            val = rblQSJC.SelectedItem.Text;

        return val;
    }

    private string getRaceHealthFactor(string selectedText)
    {
        if (selectedText.Contains("white"))
        {
            return "MSCOE.RACE.WHITE";
        }
        else if (selectedText.Contains("black"))
        {
            return "MSCOE.RACE.BLACK/AFRICAN AMERICAN";
        }
        else if (selectedText.Contains("pacific islander"))
        {
            return "MSCOE.RACE.PACIFIC ISLANDER";
        }
        else if (selectedText.Contains("alaska native"))
        {
            return "MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE";
        }
        else if (selectedText.Contains("asian"))
        {
            return "MSCOE.RACE.ASIAN";
        }
        else if (selectedText.Contains("other"))
        {
            return "MSCOE.RACE.OTHER";
        }
        else
        {
            return "";
        }
    }

    private string getIGHealthFactor(string selectedText)
    {
        //MSCOE.NIAB.NEGATIVE, MSCOE.NIAB.POSITIVE, MSCOE.NIAB.UNKNOWN
        string returnStr = "";

        if (selectedText.Contains("negative"))
        {
            returnStr = "MSCOE.NIAB.NEGATIVE";

        }
        else if (selectedText.Contains("positive"))
        {
            returnStr = "MSCOE.NIAB.POSITIVE";

        }
        else if (selectedText.Contains("unknown"))
        {
            returnStr = "MSCOE.NIAB.UNKNOWN";

        }

        return returnStr;
    }

    private string getInterviewTypeHealthFactor(string selectedText)
    {
        if (selectedText.Contains("telephone"))
        {
            return "MSCOE.INTERVIEW.TELEPHONE";
        }
        else if (selectedText.Contains("video"))
        {
            return "MSCOE.INTERVIEW.VIDEO CONFERENCE";
        }
        else if (selectedText.Contains("person"))
        {
            return "MSCOE.INTERVIEW.FACE TO FACE";
        }
        else
        {
            return "";
        }
    }

    private string getMsNmoInitialSymptoms(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("bowel/bladder"))
        {
            //MSCOE.ISX.BOWEL/BLADDER - bowel/bladder
            returnStr = "MSCOE.ISX.BOWEL/BLADDER";

        }
        else if (selectedText.Contains("brainstem"))
        {
            //MSCOE.ISX.BRAINSTEM - brainstem
            returnStr = "MSCOE.ISX.BRAINSTEM";

        }
        else if (selectedText.Contains("cerebellar"))
        {
            //MSCOE.ISX.CEREBELLAR - cerebellar
            returnStr = "MSCOE.ISX.CEREBELLAR";

        }
        else if (selectedText.Contains("cognitive"))
        {
            //MSCOE.ISX.COGNITIVE - cognitive
            returnStr = "MSCOE.ISX.COGNITIVE";

        }
        else if (selectedText.Contains("motor"))
        {
            //MSCOE.ISX.MOTOR - motor
            returnStr = "MSCOE.ISX.MOTOR";

        }
        else if (selectedText.Contains("optic neuritis"))
        {
            //MSCOE.ISX.OPTIC NEURITIS - optic neuritis
            returnStr = "MSCOE.ISX.OPTIC NEURITIS";

        }
        else if (selectedText.Contains("sensory"))
        {
            //MSCOE.ISX.SENSORY - sensory
            returnStr = "MSCOE.ISX.SENSORY";

        }
        else if (selectedText.Contains("spinal cord"))
        {
            //MSCOE.ISX.SPINAL CORD - spinal cord
            returnStr = "MSCOE.ISX.SPINAL CORD";

        }

        return returnStr;
    }

    private int getMsNmoSymptomCount()
    {
        int selectedItems = 0;

        foreach (ListItem li in cblQ8.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }

    private string getMsSubtypeHealthFactor(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("not applicable"))
        {
            returnStr = "MSCOE.SUBTYPE.CIS OR NMO";

        }
        else if (selectedText.Contains("ppms"))
        {
            returnStr = "MSCOE.SUBTYPE.PPMS";

        }
        else if (selectedText.Contains("prms"))
        {
            returnStr = "MSCOE.SUBTYPE.PRMS";

        }
        else if (selectedText.Contains("rrms"))
        {
            returnStr = "MSCOE.SUBTYPE.RRMS";

        }
        else if (selectedText.Contains("spms"))
        {
            returnStr = "MSCOE.SUBTYPE.SPMS";

            if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
            {
                returnStr += ", MSCOE.SUBTYPE.SPMS TRANSITION YEAR";
            }
        }

        return returnStr;
    }

    protected void rdButtonUpdateSurvey_OnClick(object sender, EventArgs e)
    {
        Page.Validate("OnSave");
        if (Page.IsValid)
        {
            Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Update button clicked - start.",
                 PatientIcn, SurveyId.ToString()));
            string errorMessage = "";

            DateTime dtStart = DateTime.Now;
            bool writeTimeToLog = false;
            bool isSurveyDraft = false;

            Logging.WriteLogToFile("btnSubmit_Click: Starting");
            writeTimeToLog = true;
            SaveFailMessage = "Update Failed. Please press " + rdButtonUpdateSurvey.Text + " button again to avoid data loss.";

            if (IsPatientIcnValid())
            {
                //Validate Page, Survey
                errorMessage = SaveCompleteSurvey(writeTimeToLog, isSurveyDraft);
                Logging.WriteLogToFile("btnSubmit_Click: After SaveCompletedSurvey, before updating Note, HF, Current status.");

                if (errorMessage.Length == 0)
                {
                    UpdateSurveyNote(txtNotePreview.Text, SurveyId);
                    AddSurveyEditLog(SurveyId, txtSurveyUpdateComment.Text);

                    if (CurrentStatus.LastAssessDate == null)
                    {
                        CurrentStatus.LastAssessDate = (DateTime)dpDate1.SelectedDate;
                    }

                    if (CurrentAssessmentHF.AssessmentDateTime == null)
                    {
                        CurrentAssessmentHF.AssessmentDateTime = (DateTime)dpDate1.SelectedDate;
                    }

                    /* if survey is the latest apply survey changes to common tables. */
                    if (!string.IsNullOrEmpty(IsSurveyTheLatest) && IsSurveyTheLatest.ToLower() == "yes")
                    {
                        SaveHfCondesedEntry();
                        SavePatientDemographics();
                        SaveCurrentStatusEntry();
                    }

                    /* sync survey results*/
                    SyncAutoForwardSurveyResults(ListSurveyResults);
                    DisplayNotificationMessage(true, "Notification", "The assessment was successfully updated.");
                    rdButtonUpdateSurvey.Enabled = false;
                    pnlMainContent.Enabled = false;
                }
            }
            else
            {
                Logging.WriteLogToFile("WARNING - Invalid Patient ICN provided. SURVEY EDIT Page Load. Error opening survey edit module – Invalid Patient ICN. Redirecting to error page.");
                Response.Redirect("ErrorPage.aspx?id=505");
            }
        }
        else
        {
            Logging.WriteLogToFile("ERROR - Validation Failed");
        }

    }

    private void SyncAutoForwardSurveyResults(List<SurveyResults> surveyResultses)
    {
        var surveyDate = new DateTime();  
        if (dpDate1.SelectedDate != null)
        {
             surveyDate = (DateTime) dpDate1.SelectedDate;
        }
        var surveyViewManager = new SurveyViewManager(CurrentUser);
        Logging.WriteLogToFile(
            string.Format(
                "AutoForward Survey results start. Base Survey Id {0} Patient Icn {1} and Assessment Date {2}", SurveyId,
                PatientIcn, surveyDate));
        surveyViewManager.UpdateLatestSurveysAndResults(surveyResultses, PatientIcn, SurveyId, surveyDate);
       
    }

    private void UpdateSurveyNote(string surveyNote, int surveyId)
    {
        var surveyNoteMgr = new SurveyViewManager(CurrentUser);
        surveyNoteMgr.UpdateSurveyNoteBySurveyId(surveyNote, surveyId);
    }

    private void SaveHfCondesedEntry()
    {
        var surveyManagerHf = new SurveyViewManager(CurrentUser);
        if (CurrentAssessmentHF != null)
        {
            surveyManagerHf.SaveHfCondensedEntry(CurrentAssessmentHF);
        }
    }

    private void SavePatientDemographics()
    {
        var surveyManagerDem = new SurveyViewManager(CurrentUser);
        if (patientDem != null)
        {
            surveyManagerDem.SavePatientDemographics(patientDem);
        }
    }

    private void SaveCurrentStatusEntry()
    {
        var surveyManagerCs = new SurveyViewManager(CurrentUser);
        if (CurrentStatus != null)
        {
            surveyManagerCs.SaveCurrentStatus(CurrentStatus);
        }
    }

    private void AddSurveyEditLog(int surveyId, string surveyEditMessage)
    {
        var surveyManagerEditLog = new SurveyViewManager(CurrentUser);
        surveyManagerEditLog.UpdateSurveyEditLog(surveyId, surveyEditMessage);
    }

    private void DisplayNotificationMessage(bool setMessage, string sHeader, string sErrorMessage)
    {
        if (setMessage)
        {
            pnlNotification.Visible = true;
            LabelNotificationTitle.Text = sHeader;
            LabelNotificationMessage.Text = sErrorMessage;
        }
        else
        {
            pnlNotification.Visible = false;
            LabelNotificationTitle.Text = "";
            LabelNotificationMessage.Text = "";
        }
    }

    protected void rdbUpdateMedication_UpdateMedication(object sender, EventArgs e)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Update medication start.",
            PatientIcn, SurveyId.ToString()));
        controls_Medications medcntrl = (controls_Medications)pnlMedicationSection.FindControl("MedicationSelection1");
        var tempMed = medcntrl.GetPatientMedication(this._user);

        var med = _mssrInstrumentManager.GetMedicationByMedicationId(tempMed.MEDICATION_ID);
        MedicationNameAdd = med.MEDICATION;

        tempMed.SURVEY_ID = SurveyId;
        tempMed.ID = MedRequest.PatientMedicationId;
        PatientMedications.Add(tempMed);

        MedsViewManager medMgr = new MedsViewManager();
        medMgr.UpdateMedication(tempMed);

        if (tempMed != null && tempMed.MEDICATION_USED == 2 && !string.IsNullOrEmpty(MedicationNameAdd))
        {
            if (MedicationNameAdd.ToLower().Contains("mitoxantrone"))
            {
                AddMitoxantroneToSession(medcntrl);
            }
        }
        SetChangeIndicator(true);
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Updated medication {2}.",
            PatientIcn, SurveyId.ToString(), tempMed.MEDICATION_ID));
        pnlMedicationSection.Visible = false;
        PopulateAddMedsDropDown();

    }

    private void SetChangeIndicator(bool flag)
    {
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(flag);
        }
    }

    public void setRblQSJCSelectedValue(string val)
    {

        if (!String.IsNullOrEmpty(val))
        {
            rblQSJC.SelectedValue = val;

            if (rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
            {
                pnlQSJCNegative.Style["display"] = "block";
                pnlQSJCPositive.Style["display"] = "none";
                mysQSJCPositive.MonthYearString = "";

            }
            else if (rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
            {
                pnlQSJCPositive.Style["display"] = "block";
                pnlQSJCNegative.Style["display"] = "none";
                mysQSJCNegative.MonthYearString = "";
            }
            else
            {

                pnlQSJCPositive.Style["display"] = "none";
                pnlQSJCNegative.Style["display"] = "none";
                mysQSJCPositive.MonthYearString = mysQSJCNegative.MonthYearString = ""; // clear selection
            }
        }
        else
        {
            pnlQSJCNegative.Style["display"] = "none";
            pnlQSJCPositive.Style["display"] = "none";
            mysQSJCPositive.MonthYearString = mysQSJCNegative.MonthYearString = "";
        }

    }

    protected void rdbAddMedication_Click(object sender, EventArgs e)
    {
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Add medication start.",
            PatientIcn, SurveyId.ToString()));
        controls_Medications medcntrl = (controls_Medications)pnlMedicationSection.FindControl("MedicationSelection1");
        var tempMed = medcntrl.GetPatientMedication(this._user);

        MedsToRequest medsToAdd = new MedsToRequest();


        medsToAdd.SurveyId = tempMed.SURVEY_ID = SurveyId;
        medsToAdd.Id = tempMed.ID = Guid.NewGuid();

        MedsToAdd.Add(medsToAdd);
        PatientMedications.Add(tempMed);

        MedsViewManager medMgr = new MedsViewManager();
        medMgr.AddMedication(tempMed);

        //if mitoxantrone 
        if (tempMed != null && tempMed.MEDICATION_USED == 2 && !string.IsNullOrEmpty(MedicationNameAdd))
        {
            if (MedicationNameAdd.ToLower().Contains("mitoxantrone"))
            {
                AddMitoxantroneToSession(medcntrl);
            }
        }
        Logging.WriteLogToFile(string.Format("SURVEY EDIT updating patient ICN {0} and survey id {1} on survey edit page. Added medication id {2}.",
            PatientIcn, SurveyId.ToString(), tempMed.ID));

        rdcListOfRegMedications.SelectedValue = "";
        MedicationNameAdd = string.Empty;
        MedicationSelection1.ClearMedicationSelection();
        pnlMedicationSection.Visible = false;

        PopulateAddMedsDropDown();
    }

    private void AddMitoxantroneToSession(controls_Medications medcntrl)
    {
        CardioTox cardioTox = new CardioTox();

        // Question CardioTox - Is Patient being monitored for cardiotoxicity?
        cardioTox.CardioToxMonitored = medcntrl.getRbQCardioToxSelectedItem();
        cardioTox.CardioToxQuestionChoiceId = medcntrl.getRbQCardioToxSelectedValue();

        //Question CardioToxYes - Date of most recent cardiac MUGA or Echocardiogram
        STD_QUESTION questionCardioToxYes = _questionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxYes");
        cardioTox.CardioToxYesDateQuestionChoiceId = questionCardioToxYes.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
        cardioTox.CardioToxYesDate = medcntrl.getTxtQCardioToxDateText();

        //Question CardioToxYes Date Unknown checkbox        
        STD_QUESTION questionCardioToxDateUnknown = _questionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxDateUnknown");
        cardioTox.CardioToxDateUnknownQuestionChoiceId = questionCardioToxDateUnknown.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
        cardioTox.CardioToxDateUnknown = medcntrl.getCbQCardioToxDateUnknown();

        CardioToxMed = cardioTox;
        IsCardioToxChanged = "Yes";
        CardioToxMedSurResult = null;
    }

    public NoteSummaryHealthFactorsResponse GetHealthFactorsForMedication(IEnumerable<GetMedsForHealthFactor_Result> patientMed)
    {
        NoteSummaryHealthFactorsResponse noteHfResponse = new NoteSummaryHealthFactorsResponse();
        string hfResult = "";
        StringBuilder noteSummaryResult = new StringBuilder();

        foreach (var medhf in patientMed)
        {
            if (medhf.MEDICATION_USED.HasValue)
            {
                if (medhf.MEDICATION_USED == 2)
                {
                    noteSummaryResult.Append("\r\n - " + medhf.MEDICATION + " Usage Status\r\n");
                    // current or past use selected
                    if (medhf.MEDICATION.ToLower().Contains("other"))
                    {
                        //noteSummaryResult.Append("\tOther DMT Medicine Name: " + medhf.MEDICATION.ToString() + "\r\n");
                        if (!string.IsNullOrEmpty(medhf.OTHER_DMT_NAME))
                        {
                            noteSummaryResult.Append("\tOther DMT Medicine Name: " + medhf.OTHER_DMT_NAME.ToString() + "\r\n");
                        }
                    }
                    else if (medhf.MEDICATION.ToLower().Contains("mitoxantrone"))
                    {
                        noteSummaryResult.Append(writeMitoxantroneData());
                        hfResult += GetMitoxantroneHF();
                    }

                    if ((bool)medhf.CURRENT_THERAPY)
                    {
                        noteSummaryResult.Append("  - Current:\r\n");
                        // currently used - MSCOE.AZATHIOPRINE.CURRENT USE
                        hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".CURRENT USE, ";

                        #region check dispensing pharm type

                        if (medhf.CURRENT_THERAPY_DISPENSING_PHARMACY.HasValue)
                        {
                            if (medhf.CURRENT_THERAPY_DISPENSING_PHARMACY == 2)
                            {
                                noteSummaryResult.Append("\tDispensing Pharmacy: " + "Non-VA Pharmacy" + "\r\n");
                                //MSCOE.AZATHIOPRINE.CURRENT NONVA
                                hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".CURRENT NONVA, ";

                            }
                            else
                            {
                                //MSCOE.AZATHIOPRINE.CURRENT VA
                                hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".CURRENT VA, ";
                                noteSummaryResult.Append("\tDispensing Pharmacy: " + "VA Pharmacy" + "\r\n");

                            }
                        }

                        #endregion

                        #region check current date started

                        if (!String.IsNullOrEmpty(medhf.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED))
                        {
                            hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".CURRENT STARTED, ";
                            noteSummaryResult.Append("\tApproximate date started: " + medhf.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED.ToString() + "\r\n");
                        }
                        if (!string.IsNullOrEmpty(medhf.CurrentNumberOfDosesTaken))
                        {
                            noteSummaryResult.Append("\tCurrent number of doses taken: " + medhf.CurrentNumberOfDosesTaken.ToString() + "\r\n");
                        }
                        #endregion
                    }

                    if (medhf.PAST_USE.HasValue)
                    {
                        if ((bool)medhf.PAST_USE)
                        {
                            noteSummaryResult.Append("  - Past:\r\n");
                            // used in past. - MSCOE.AZATHIOPRINE.PAST USE
                            hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".PAST USE, ";

                            #region check dispensing pharm type

                            if (medhf.PAST_USE_DISPENSING_PHARMACY.HasValue)
                            {
                                if (medhf.PAST_USE_DISPENSING_PHARMACY == 2) //medhf.PAST_USE_DISPENSING_PHARMACY.ToLower().Contains("non")
                                {
                                    //MSCOE.AZATHIOPRINE.PAST NONVA
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".PAST NONVA, ";
                                    noteSummaryResult.Append("\tDispensing Pharmacy: " + "Non-VA Pharmacy" + "\r\n");
                                }
                                else
                                {
                                    //MSCOE.AZATHIOPRINE.PAST VA
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".PAST VA, ";
                                    noteSummaryResult.Append("\tDispensing Pharmacy: " + "VA Pharmacy" + "\r\n");
                                }
                            }

                            #endregion

                            #region check past date started

                            if (!String.IsNullOrEmpty(medhf.PAST_USE_APPROXIMATE_YEAR_STARTED))
                            {
                                noteSummaryResult.Append("\tApproximate date started: " + medhf.PAST_USE_APPROXIMATE_YEAR_STARTED.ToString() + "\r\n");
                                hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".PAST STARTED, ";
                            }

                            #endregion



                            #region check past date stopped

                            if (!String.IsNullOrEmpty(medhf.PAST_USE_APPROXIMATE_YEAR_STOPPED))
                            {
                                noteSummaryResult.Append("\tApproximate date stopped: " + medhf.PAST_USE_APPROXIMATE_YEAR_STOPPED.ToString() + "\r\n");
                                hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".PAST STOPPED, ";
                            }

                            #endregion

                            #region number of doses taken
                            if (!string.IsNullOrEmpty(medhf.PastNumberOfDosesTaken))
                            {
                                noteSummaryResult.Append("\tPast number of doses taken: " + medhf.PastNumberOfDosesTaken.ToString() + "\r\n");
                            }

                            #endregion

                            #region check reason stopped

                            if (medhf.PAST_USE_REASON_STOPPED.HasValue)
                            {
                                if (medhf.PAST_USE_REASON_STOPPED == 6) //medhf.PAST_USE_REASON_STOPPED.ToLower().Contains("adverse")
                                {
                                    //MSCOE.AZATHIOPRINE.RSTOP.ADVERSE SE
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".RSTOP.ADVERSE SE, ";
                                    noteSummaryResult.Append("\tReason Stopped: " + "Significant adverse event" + "\r\n");
                                    if (!string.IsNullOrEmpty(medhf.SigEventOther))
                                    {
                                        noteSummaryResult.Append("\tSignificant Adverse Event Description: " + medhf.SigEventOther.ToString() + "\r\n");
                                    }
                                }
                                else if (medhf.PAST_USE_REASON_STOPPED == 1)//medhf.PAST_USE_REASON_STOPPED.ToLower().Contains("ineffective")
                                {
                                    //MSCOE.AZATHIOPRINE.RSTOP.INEFFECTIVE
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".RSTOP.INEFFECTIVE, ";
                                    noteSummaryResult.Append("\tReason Stopped: " + "Ineffective" + "\r\n");

                                }
                                else if (medhf.PAST_USE_REASON_STOPPED == 2)//medhf.PAST_USE_REASON_STOPPED.ToLower().Contains("intolerant")
                                {
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".RSTOP.INTOLERANT, ";
                                    noteSummaryResult.Append("\tReason Stopped: " + "Intolerance to medication" + "\r\n");

                                }
                                else if (medhf.PAST_USE_REASON_STOPPED == 4)//medhf.PAST_USE_REASON_STOPPED.ToLower().Contains("maximum")
                                {
                                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".RSTOP.MAX DOSE, ";
                                    noteSummaryResult.Append("\tReason Stopped: " + "Maximum dose reached" + "\r\n");
                                }
                                else if (medhf.PAST_USE_REASON_STOPPED == 22)//medhf.PAST_USE_REASON_STOPPED.ToLower().Contains("maximum")
                                {
                                    if (!string.IsNullOrEmpty(medhf.PAST_USE_REASON_STOPPED_OTHER))
                                    {
                                        noteSummaryResult.Append("\tOther Reason Stopped Descripton: " + medhf.PAST_USE_REASON_STOPPED_OTHER.ToString() + "\r\n");
                                    }
                                }
                            }

                            #endregion
                        }

                    }
                    if (medhf.ADVERSE_EVENTS.HasValue)
                    {
                        if ((bool)medhf.ADVERSE_EVENTS)
                        {
                            //
                            noteSummaryResult.Append("  - Adverse Event:\r\n");
                            if (medhf.ADVERSE_EVENT.HasValue)
                            {
                                string adverseEventDesc = GetAdverseEventDescription(medhf.ADVERSE_EVENT);
                                if (!string.IsNullOrEmpty(adverseEventDesc))
                                {
                                    if (adverseEventDesc.ToLower().Equals("blood count abnormal")) //7	Blood count abnormal
                                    {
                                        noteSummaryResult.Append("\tAdverse Event: " + "Blood count abnormal" + "\r\n");
                                    }
                                    if (adverseEventDesc.ToLower().Equals("rash/allergic reaction")) //8 Rash/Allergic reaction
                                    {
                                        noteSummaryResult.Append("\tAdverse Event: " + "Rash/Allergic reaction" + "\r\n");
                                    }
                                    if (adverseEventDesc.ToLower().Equals("immunosupression-related complication")) //9	Immunosupression-related complication
                                    {
                                        noteSummaryResult.Append("\tAdverse Event: " +
                                                                 "Immunosupression-related complication" + "\r\n");
                                    }
                                    if (adverseEventDesc.ToLower().Equals("other significant adverse event")) //21	Other significant adverse event
                                    {
                                        noteSummaryResult.Append("\tAdverse Event: " + "Other significant adverse event" +
                                                                 "\r\n");
                                        //if (!String.IsNullOrEmpty(medhf.ADVERSE_EVENTS_DESCRIPTION))
                                        //{
                                        //    noteSummaryResult.Append("\tAdverse Event Description: " +
                                        //                             medhf.ADVERSE_EVENTS_DESCRIPTION + "\r\n");
                                        //}
                                    }
                                }
                                
                            }
                            if (!String.IsNullOrEmpty(medhf.ADVERSE_EVENTS_DESCRIPTION))
                            {
                                noteSummaryResult.Append("\tAdverse Event: " + "Other significant adverse event" + "\r\n");
                                noteSummaryResult.Append("\tAdverse Event Description: " +
                                                         medhf.ADVERSE_EVENTS_DESCRIPTION +
                                                         "\r\n");
                            }



                            //
                        }

                    }

                }
                else
                {
                    // never ... selected
                    noteSummaryResult.Append("\r\n - " + medhf.MEDICATION + " Usage Status\r\n");
                    if (medhf.MEDICATION.ToLower().Contains("mitoxantrone"))
                    {
                        noteSummaryResult.Append("");//writeMitoxantroneData()
                    }
                    noteSummaryResult.Append("\t" + "Never Taken" + "\r\n");

                    hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".NEVER, ";
                }
            }
            else
            {
                noteSummaryResult.Append("\r\n - " + medhf.MEDICATION + " Usage Status\r\n");
                noteSummaryResult.Append("\tN/A\r\n");
                hfResult += "MSCOE." + medhf.HEALTH_FACTOR + ".NEVER, ";
            }




        }
        if (hfResult.EndsWith(", "))
        {
            hfResult = hfResult.Substring(0, hfResult.Length - 2);
        }

        // Is medication used ... 

        noteHfResponse.HealthFactors = hfResult;
        noteHfResponse.NoteSummary = noteSummaryResult.ToString();
        return noteHfResponse;
        //return hfResult;
    }

    private string GetMitoxantroneHF()
    {
        String hfResult = string.Empty;
        if (CardioToxMed != null && IsCardioToxChanged.ToLower() == "yes")
        {
            if (!string.IsNullOrEmpty(CardioToxMed.CardioToxMonitored))
            {
                if (CardioToxMed.CardioToxMonitored.ToLower().Contains("yes"))
                {
                    hfResult = "MSCOE.MITOXANTRONE.MONITOR CARDIOTOX,";
                }
            }
        }
        else if (CardioToxMedSurResult != null && !string.IsNullOrEmpty(IsCardioToxChanged))
        {
            if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioTox))
            {
                if (CardioToxMedSurResult.CardioToxResultText.ToLower().Contains("yes"))
                {
                    hfResult = "MSCOE.MITOXANTRONE.MONITOR CARDIOTOX,";
                }
            }
        }

        return hfResult;
    }

    private string GetAdverseEventDescription(int? pMedId)
    {
        int medId = 0;
        if (pMedId.HasValue)
        {
            medId = pMedId.Value;
        }
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            string adverseEvents = (from mrs in ctx.MSSR_MEDICATION_REASON_STOPPEDs where mrs.ID == medId select mrs.REASON_STOPPED).FirstOrDefault();
            return adverseEvents;
        }
        
    }

    private StringBuilder writeMitoxantroneData()
    {
        StringBuilder noteSummaryResult = new StringBuilder();
        if (CardioToxMed != null && IsCardioToxChanged.ToLower() == "yes")
        {
            noteSummaryResult.Append("\t" + "Is Patient being monitored for cardiotoxicity?" + "\r\n");
            //noteSummaryResult.Append("\t\t" + CardioToxMed.CardioToxMonitored + "\r\n");

            if (CardioToxMed.CardioToxMonitored.ToLower().Contains("yes") &&
                (!string.IsNullOrEmpty(CardioToxMed.CardioToxYesDate) || !string.IsNullOrEmpty(CardioToxMed.CardioToxDateUnknown)))
            {
                noteSummaryResult.Append("\t" + CardioToxMed.CardioToxMonitored + "\r\n");

                if (!string.IsNullOrEmpty(CardioToxMed.CardioToxYesDate))
                {
                    noteSummaryResult.Append("\t\t" + CardioToxMed.CardioToxYesDate + "\r\n");
                }
                else if (!string.IsNullOrEmpty(CardioToxMed.CardioToxDateUnknown))
                {
                    noteSummaryResult.Append("\t\t" + CardioToxMed.CardioToxDateUnknown + "\r\n");
                }
            }
        }
        else if (CardioToxMedSurResult != null && !string.IsNullOrEmpty(IsCardioToxChanged))
        {

            noteSummaryResult.Append("\t" + "Is Patient being monitored for cardiotoxicity?" + "\r\n");
            noteSummaryResult.Append("\t\t" + CardioToxMedSurResult.CardioToxResultText + "\r\n");

            //if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioTox))
            //{
            if (CardioToxMedSurResult.CardioToxResultText.ToLower().Contains("yes"))
                {
                    //noteSummaryResult.Append("\t" + CardioToxMedSurResult.CardioToxResultText + "\r\n");

                    if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioToxYes))
                    {
                        noteSummaryResult.Append("\t\t" + CardioToxMedSurResult.CardioToxYes + "\r\n");
                    }
                    else if (!string.IsNullOrEmpty(CardioToxMedSurResult.CardioToxDateUnknown))
                    {
                        noteSummaryResult.Append("\t\t" + CardioToxMedSurResult.CardioToxDateUnknown + "\r\n");
                    }
                }
            //}
            

        }

        return noteSummaryResult;

    }

    private bool IsUserAuthorizedToEditSurvey()
    {
        bool allowedToEdit = false;

        SurveyEditUserManager editMnger = new SurveyEditUserManager();
        allowedToEdit = editMnger.IsUserAuthozizedToEditSurvey(_user);

        return allowedToEdit;
    }

    protected void msatEditCustomValidator_ServerValidate(object source, ServerValidateEventArgs args)
    {
        string errorMessage = string.Empty;

        errorMessage = ValidateFormFields(false, string.Empty);

        if (errorMessage.Length > 0)
        {
            args.IsValid = false;
            ValidationSummarySurveyEdit.Visible = false;
            msatEditCustomValidator.IsValid = false;
            //msatEditCustomValidator.ErrorMessage = string.Empty;
            msatEditCustomValidator.ErrorMessage = "Please enter the following values:- " + errorMessage;            
        }
    }

    protected void rgListOfSurveys_SortCommand(object sender, GridSortCommandEventArgs e)
    {
        if (e.Item.OwnerTableView.SortExpressions.ContainsExpression(e.SortExpression))
        {
            GridSortExpression sortExpr = new GridSortExpression();
            sortExpr.FieldName = e.SortExpression;
            sortExpr.SortOrder = GridSortOrder.Ascending;

            e.Item.OwnerTableView.SortExpressions.AddSortExpression(sortExpr);

        }
    }

    protected void rgListOfSurveys_NeedDataSource(object sender, GridNeedDataSourceEventArgs e)
    {
        var myEditManager = new MSATEditViewManager();
        MsatEditViewModel = myEditManager.GetMsatEditViewModel(PatientIcn);
        rgListOfSurveys.DataSource = MsatEditViewModel.ListOfSurveys;        

    }
}