﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Linq.Dynamic;

using MSSR.Security;
using VeteransAffairs.Registries.BusinessManager;
using System.Web;

using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.IO;
using System.Drawing;

public partial class Radiology : BasePage {

    #region Member Variables

    //private string Location = "";
    private bool foundRequestVar = false;
    
    private String PatientName = "";
    private String PatientICN = "";
    private String TypeOfImaging = "";
    private String ExamDateFrom = "";
    private String ExamDateTo = "";
    //private int Sta3n = 0;
    

    //private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    #endregion

    #region Public Overrides

    public override string TopMenuName() {
        return "Patients";
    }

    public override string MenuItemName() {
        return "Radiology";
    }  
    public override string AppObjectCode() {
        return "MSSR Radiology";
    }

    #endregion


   

    #region Protected Methods

    /// <summary>
    /// Page_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {

        try {
            var master = this.Master as RegistryMaster;
            if (master != null)
            {
                master.SetDirtyFlag(false);
            }
            //(this.Master as RegistryMaster).SetDirtyFlag(false);
        } catch (Exception ex) {
            Logging.WriteLogToFile("Failure in Radiology Page_Load: " + ex.Message);
        }

        grdMSRadiology.PageSize = (ddlPageSize.SelectedItem.Value == "-1" ? int.MaxValue : int.Parse(ddlPageSize.SelectedItem.Value));
        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.

        #region Gather Request Variables
        if (!String.IsNullOrEmpty(Request.QueryString["patientIcn"]))
        {
            this.PatientICN = Request.QueryString["patientIcn"];
            txtPatientICN.Text = this.PatientICN;
            txtPatientName.Text = this.PatientName;
            foundRequestVar = true;
        }
        #endregion
        
        //Post back or not
        if (!IsPostBack) {
            pnlPagingControls.Visible = false;

            grdMSRadiology.DataSource = null;
            grdMSRadiology.DataBind();

            setBreadCrumb();
            filterData();
        }
        else
        {
            setBreadCrumb();
            filterData();
        }
        //fill all the fields      

    }

        /// <summary>
    /// Called right before Render, after Page_Load.
    /// </summary>
    /// <param name="e"></param>
    protected override void OnPreRender(EventArgs e)
    {
        if (foundRequestVar)
        {
            ////Location filter
            //if (!String.IsNullOrEmpty(Location))
            //{
            //    ddlFacility.SelectedIndex = -1;
            //    foreach (ListItem li in ddlFacility.Items)
            //    {
            //        if (li.Text.ToLower().Contains(Location.ToLower()))
            //        {
            //            li.Selected = true;
            //            break;
            //        }
            //    }
            //}
        }
        //filterData(); // call filter with passed variables.
        base.OnPreRender(e);
    }

    protected void btnShowAll_Click(object sender, EventArgs e)
    {
        Response.Redirect("Radiology.aspx");
    }


    /// <summary>
    /// Event Handler for btnGo click.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnGo_Click(object sender, EventArgs e) {
        //Get stuff from  lists in Main
        if (!(calExamDateFrom.Text.Trim() == ""))
            this.ExamDateFrom = calExamDateFrom.Text.Trim();

        if (!(calExamDateTo.Text.Trim() == ""))
            this.ExamDateTo = calExamDateTo.Text.Trim();

        if (!(txtTypeOfImaging.Text.Trim() == ""))
            this.TypeOfImaging = txtTypeOfImaging.Text.Trim();

        if (!string.IsNullOrEmpty(txtPatientName.Text.Trim()))
            this.PatientName = txtPatientName.Text.Trim();

        if (!string.IsNullOrEmpty(txtPatientICN.Text.Trim()))
            this.PatientICN = txtPatientICN.Text.Trim();
        
        if (Request.QueryString.Get("PatientICN") != null)
        {
            this.PatientICN = Request.QueryString.Get("PatientICN");
        }
        HiddenFieldCurrentPageNumber.Value = "0";

        filterData();
    }

    /// <summary>
    /// Clears filter choices
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnClear_Click(object sender, EventArgs e) {        
        txtTypeOfImaging.Text = "";
        txtPatientICN.Text = "";
        calExamDateFrom.Text = "";
        calExamDateTo.Text = "";
        filterData();
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleFilters_OnClick(object sender, EventArgs e) {
        if (pnlFilterArea.Visible) {
            pnlFilterArea.Visible = false;
            lnkBtnToggleFilters.Text = "Show";
        } else {
            pnlFilterArea.Visible = true;
            lnkBtnToggleFilters.Text = "Hide";
        }
    }

    #region Export To Excel Overide Function
    /// <summary>
    /// Export To Excel Overide Function
    /// </summary>
    /// <param name="GridView1"></param>
    /// <param name="filename"></param>
    private void ExportToExcel(GridView GridView1, string filename)
    {
        PrepareGridViewForExport(GridView1);

        string attachment = "attachment; filename=" + filename;
        Response.ClearContent();
        Response.AddHeader("content-disposition", attachment);
        Response.ContentType = "application/ms-excel";
        StringWriter sw = new StringWriter();
        HtmlTextWriter htw = new HtmlTextWriter(sw);

        // Create a form to contain the grid
        HtmlForm frm = new HtmlForm();
        GridView1.Parent.Controls.Add(frm);
        frm.Attributes["runat"] = "server";
        frm.Controls.Add(GridView1);
        frm.RenderControl(htw);

        //style to format numbers to string
        string style = @"<style> .textmode { mso-number-format:\@; } </style>";
        Response.Write(style);
        Response.Write(sw.ToString());
        Response.Flush();
        Response.End();

    }
    /// <summary>
    /// Button click to export grid to Excel.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>

    protected void imgBtnExportToExcel_Click(object sender, System.Web.UI.ImageClickEventArgs e)
    {

        string fileName = "Radiology_Export_" + DateTime.Now.ToLocalTime() + ".xls";
        ExportToExcel(grdMSRadiology, fileName);

    }
    #endregion

    /// <summary>
    /// Fired when columns are sorted.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSRadiology_Sorting(object sender, GridViewSortEventArgs e) {

        #region get members

        if (!(calExamDateFrom.Text.Trim() == ""))
            this.ExamDateFrom = calExamDateFrom.Text.Trim();

        if (!(calExamDateTo.Text.Trim() == ""))
            this.ExamDateTo = calExamDateTo.Text.Trim();

        if (!(txtTypeOfImaging.Text.Trim() == ""))
            this.TypeOfImaging = txtTypeOfImaging.Text.Trim();

        if (!string.IsNullOrEmpty(txtPatientName.Text.Trim()))
            this.PatientName = txtPatientName.Text.Trim();

        if (!string.IsNullOrEmpty(txtPatientICN.Text.Trim()))
            this.PatientICN = txtPatientICN.Text.Trim();

        if (Request.QueryString.Get("PatientICN") != null)
        {
            this.PatientICN = Request.QueryString.Get("PatientICN");
        }


        #endregion

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {

            #region query

            var pats = from hf in db.VW_RADIOLOGies
                       //join pat in db.MSSRE_PATIENT_DEMs on hf.PatientICN equals pat.PatientICN
                       select new MssrRadiologysDisplay
                       {                           
                           Age = return0ForNullValDec(hf.Age),
                           Ethnicity = hf.Ethnicity,
                           Gender = Convert.ToString(hf.Gender),
                           PatientICN = hf.PatientICN,
                           PatientName = hf.PatientName,
                           Race = hf.Race,
                           Sta3n = return0ForNullValInt(hf.Sta3n),

                           ExamDate = (DateTime?)hf.ExamDateTime,
                           VerifyingPhysician = hf.VerifyingPhysician,
                           RequestingPhysician = hf.RequestingPhysician,
                           ProcedureName = hf.ProcedureName,
                           ImpressionText = hf.ImpressionText,
                           CPT = (Int32?)(return0ForNullValDec(hf.CPT)),
                           TypeOfImaging = hf.TypeOfImaging,
                           InOut = hf.InOut
                       };

            pats = pats.OrderBy(P => P.PatientName);


            //Type of imaging or procedure name
            if (!String.IsNullOrEmpty(this.TypeOfImaging.Trim()))
            {
                pats = pats.AsQueryable().Where(x => x.TypeOfImaging.ToLower().Contains(this.TypeOfImaging.Trim().ToLower())
                                                        || x.ProcedureName.ToLower().Contains(this.TypeOfImaging.Trim().ToLower()));
            }
            //Issue Date
            if ((this.ExamDateFrom != "") && (this.ExamDateTo != ""))
            {
                DateTime dtExamDateFrom = Convert.ToDateTime(this.ExamDateFrom);
                DateTime dtExamDateTo = Convert.ToDateTime(this.ExamDateTo);

                pats = pats.AsQueryable().Where(eg => eg.ExamDate >= dtExamDateFrom && eg.ExamDate <= dtExamDateTo);

            }

            //Patient Name
            if (!String.IsNullOrEmpty(this.PatientName))
            {
                pats = pats.AsQueryable().Where(eg => eg.PatientName.Contains(this.PatientName));
            }
            //Patient ICN
            if (!String.IsNullOrEmpty(this.PatientICN))
            {
                int patIcn = 0;
                Int32.TryParse(this.PatientICN, out patIcn);

                if (patIcn > 0)
                {
                    pats = pats.AsQueryable().Where(eg => eg.PatientICN == patIcn);
                }
            }


            SortDirection direction = e.SortDirection;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value)) {
                if (e.SortExpression == HiddenFieldSortExpression.Value) {
                    if (HiddenFieldSortDirection.Value == "ASC") {
                        HiddenFieldSortDirection.Value = "DESC";
                        direction = SortDirection.Descending;
                    } else {
                        HiddenFieldSortDirection.Value = "ASC";
                        direction = SortDirection.Ascending;
                    }
                } else {
                    HiddenFieldSortDirection.Value = "ASC";
                    direction = SortDirection.Ascending;
                }
            } else {
                HiddenFieldSortDirection.Value = (e.SortDirection == SortDirection.Ascending) ? "ASC" : "DESC";
            }

            var pats2 = pats.OrderBy(e.SortExpression + " " + HiddenFieldSortDirection.Value);
            HiddenFieldSortExpression.Value = e.SortExpression;

            int totalRecords = pats2.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSRadiology.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSRadiology.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSRadiology.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSRadiology.PageSize)) + ")";

            //    if (CurrentEver == "Ever")
            //        grdMSRadiology.Columns[13].HeaderText = "VA Ever";

            grdMSRadiology.RowDataBound += new GridViewRowEventHandler(this.grdMSRadiology_RowDataBound);

            grdMSRadiology.DataSource = pats2.Skip(Convert.ToInt32(return0ForNullValInt(HiddenFieldCurrentPageNumber.Value)) * grdMSRadiology.PageSize).Take(grdMSRadiology.PageSize);
            grdMSRadiology.DataBind();

            setEnabledStatusOfPagingControls();

            pnlPagingControls.Visible = true;
        }
    }

    /// <summary>
    /// Fired on row data bound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSRadiology_RowDataBound(object sender, GridViewRowEventArgs e) {
        CultureInfo provider = CultureInfo.InvariantCulture;

        foreach (GridViewRow row in grdMSRadiology.Rows) {
            if (row.RowType == DataControlRowType.DataRow) {
                if (row.RowType == DataControlRowType.Header) {
                    e.Row.CssClass = "locked";
                }
            }
        }
    }

    /// <summary>
    /// Fired on row created - to create merged cells at top of table.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSRadiology_RowCreated(object sender, GridViewRowEventArgs e) {
        //if (e.Row.RowType == DataControlRowType.Header) {
        //    #region Object creation

        //    //Creating a gridview object            
        //    GridView objGridView = (GridView)sender;

        //    //Creating a gridview row object
        //    GridViewRow objgridviewrow = new GridViewRow(1, 0, DataControlRowType.Header, DataControlRowState.Insert);

        //    //Creating a table cell object
        //    TableCell objtablecell = new TableCell();
        //    #endregion

        //    #region Merge cells
        //    //Add a blank cell at the first two cell headers(i.e. User Id & Name)
        //    //This can be achieved by making the colspan property of the table cell object as 2
        //    // and the text property of the table cell object will be blank
        //    //Henceforth, add the table cell object to the grid view row object

        //    AddMergedCells(objgridviewrow, objtablecell, 5, "PATIENT");
        //    AddMergedCells(objgridviewrow, objtablecell, 8, "MS ASSESSMENT");
        //    AddMergedCells(objgridviewrow, objtablecell, 1, "MS/NMO MEDS");

        //    objGridView.Controls[0].Controls.AddAt(0, objgridviewrow);
        //    #endregion
        //}
    }

    /// <summary>
    /// Returns patient name for the given ICN
    /// </summary>
    /// <param name="patientIcn"></param>
    /// <returns></returns>
    protected string GetPatientName(object patientIcn) {
        if (patientIcn != null) {
            int patIcn = Convert.ToInt32(patientIcn);
            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {
                MSSR_PATIENT_DEM pat = ctx.MSSR_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == patIcn);

                if (pat != null) {
                    return pat.PatientName;
                }
            }
        }
        return "";
    }

    #endregion

    #region Private Methods

    private Int32 return0ForNullValInt (object x)
    {
        if (x == null)
            return 0;
        else
            return Convert.ToInt32(x);
    }
    private Decimal return0ForNullValDec(object x)
    {
        if (x == null)
            return 0;
        else
            return Convert.ToDecimal(x);
    }
    /// <summary>
    /// Filter and query performed for data matching filters.
    /// </summary>
    private void filterData() {

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext())
        {

            var pats = from hf in db.VW_RADIOLOGies
                       //join pat in db.MSSRE_PATIENT_DEMs on hf.PatientICN equals pat.PatientICN
                       select new MssrRadiologysDisplay
                       {
                           Age = return0ForNullValDec(hf.Age),
                           Ethnicity = hf.Ethnicity,
                           Gender = Convert.ToString(hf.Gender),
                           PatientICN = hf.PatientICN,
                           PatientName = hf.PatientName,
                           Race = hf.Race,
                           Sta3n = return0ForNullValInt(hf.Sta3n),

                           ExamDate = (DateTime?)hf.ExamDateTime,
                           VerifyingPhysician = hf.VerifyingPhysician,
                           RequestingPhysician = hf.RequestingPhysician,
                           ProcedureName = hf.ProcedureName,
                           ImpressionText = hf.ImpressionText,
                           CPT = (Int32?)(return0ForNullValDec(hf.CPT)),
                           TypeOfImaging = hf.TypeOfImaging,
                           InOut = hf.InOut
                       };
                                          

            //Type of imaging or procedure name
            if (!String.IsNullOrEmpty(this.TypeOfImaging.Trim()))
            {
                pats = pats.AsQueryable().Where(x => x.TypeOfImaging.ToLower().Contains(this.TypeOfImaging.Trim().ToLower())
                                                        || x.ProcedureName.ToLower().Contains(this.TypeOfImaging.Trim().ToLower()));
            }
            //Issue Date
            if ((this.ExamDateFrom != "") && (this.ExamDateTo != ""))
            {
                DateTime dtExamDateFrom = Convert.ToDateTime(this.ExamDateFrom);
                DateTime dtExamDateTo = Convert.ToDateTime(this.ExamDateTo);

                pats = pats.AsQueryable().Where(eg => eg.ExamDate >= dtExamDateFrom && eg.ExamDate <= dtExamDateTo);

            }

            //Patient Name
            if (!String.IsNullOrEmpty(this.PatientName))
            {
                pats = pats.AsQueryable().Where(eg => eg.PatientName.Contains(this.PatientName));
            }
            //Patient ICN
            if (!String.IsNullOrEmpty(this.PatientICN))
            {
                int patIcn = 0;
                Int32.TryParse(this.PatientICN, out patIcn);

                if (patIcn > 0)
                {
                    pats = pats.AsQueryable().Where(eg => eg.PatientICN == patIcn);
                }
            }
            //Facility (Station)
            //if (Sta3n > 0 || Sta3n == -1)
            //    pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            int totalRecords = pats.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSRadiology.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value)) {
                pats = pats.OrderBy(HiddenFieldSortExpression.Value + " " + HiddenFieldSortDirection.Value);
            }

            grdMSRadiology.DataSource = pats.Skip(Convert.ToInt32(return0ForNullValInt(HiddenFieldCurrentPageNumber.Value)) * grdMSRadiology.PageSize).Take(grdMSRadiology.PageSize);
            grdMSRadiology.DataBind();

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSRadiology.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSRadiology.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSRadiology.PageSize)) + ")";
        }

        setEnabledStatusOfPagingControls();

        pnlPagingControls.Visible = true;
    }

    /// <summary>
    /// getMedicationsUsedString: used for legacy HF_Condensed entries, this method looks at the medication columns for the record
    /// and determines which ones to return in the string
    /// </summary>
    /// <param name="hf"></param>
    /// <returns></returns>
    //private string getMedicationsUsedString(MSSR_HF_Condensed hf) {
    //    //TODO: hf.
    //}

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb() {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "MSSR Radiology";
    }

    /// <summary>
    /// Determines based on the current users role whether
    /// or not the data they see on this screen needs to be filtered down
    /// </summary>
    /// <returns></returns>
    //private bool shouldLimitResults() {
    //    int[] currentUserRoles = _user.GetRoles();
    //    if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
    //        currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
    //        currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY)) {
    //        return true;
    //    } else {
    //        return false;
    //    }

    //}

    /// <summary>
    /// Returns a list of allowed station ids for users who need
    /// the data on this page to be filtered down
    /// </summary>
    /// <returns></returns>
    //private List<string> allowedStations() {
    //    int[] institutionIDs = _user.GetInstitutions();
    //    using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext()) {
    //        var institutions = (from inst in bctx.STD_INSTITUTIONs
    //                            where institutionIDs.Contains(inst.ID)
    //                            select inst.STATIONNUMBER);

    //        return institutions.ToList();
    //    }

    //}

    
   
    #endregion

    #region Paging Control Methods

    /// <summary>
    /// Fired on clicking First Page.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnFirstPage_Click(object sender, EventArgs e) {
        HiddenFieldCurrentPageNumber.Value = "0";
        filterData();
    }

    /// <summary>
    /// Fired when clicking Previous Page button.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnPrevPage_Click(object sender, EventArgs e) {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber > 0) {
            currentPageNumber = currentPageNumber - 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

    /// <summary>
    /// Fired when clicking Next button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnNextPage_Click(object sender, EventArgs e) {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber < Convert.ToInt32(HiddenFieldPageCount.Value)) {
            currentPageNumber = currentPageNumber + 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

    /// <summary>
    /// Fired when clicking Last button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnLastPage_Click(object sender, EventArgs e) {
        int lastPage = Convert.ToInt32(HiddenFieldPageCount.Value);
        lastPage = lastPage - 1;
        HiddenFieldCurrentPageNumber.Value = lastPage.ToString();
        filterData();
    }

    /// <summary>
    /// setEnabledStatusOfPagingControls: determines if buttons should be enabled or disabled based on the page.
    /// </summary>
    private void setEnabledStatusOfPagingControls() {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        int lastPageNumber = Convert.ToInt32(HiddenFieldPageCount.Value) - 1;

        if (currentPageNumber == 0 && lastPageNumber > 0) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        } else if (currentPageNumber == 0 && lastPageNumber == 0) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        } else if (currentPageNumber == 1 && lastPageNumber == 1) {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        } else if (currentPageNumber > 0 && currentPageNumber < lastPageNumber) {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        } else if (currentPageNumber > 0 && currentPageNumber == lastPageNumber) {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        }
    }

    #endregion
}
    #endregion