﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using System.Web.Security.AntiXss;


public partial class PatientDetails : BasePage {

    #region Member Variables

    //private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
    private string _patientIcn;
    protected MSSRE_PATIENT_DEM patient;
    protected MSSR_CURRENT_STATUS currentStatus = new MSSR_CURRENT_STATUS();
    protected string familyHistory;
    protected List<MSSR_HF_Condensed> assessmentList;
    protected DateTime? lastAssessDate = null;
    protected readonly string exportDestination = "Export/ExportPatientDetailsToExcel.aspx?patientIcn=";

    //private MSSRPatientManager _mssrPatientManager;
    private MSSRInstrumentsManager _mssrInstrumentManager;
    
    protected String patientDOD = "";
    
    #endregion

    #region Public Overrides

    public override string TopMenuName() {
        return "Patients";
    }

    public override string MenuItemName() {
        return "Patient Details";
    }

    public override string AppObjectCode() {
        return "MSSR PATIENT_DETAIL";
    }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Page_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {

        //if (!IsPostBack) {

            #region Gather Request Variables

            if (!String.IsNullOrEmpty(Request.QueryString["patientIcn"])) {
                _patientIcn = Request.QueryString["patientIcn"];
                int patIcn = 0;

                Int32.TryParse(_patientIcn, out patIcn);

                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext()) {

                    #region Initial Grid bindings to ensure empty text displays when no data present

                    gvCurrentMeds.DataSource = null;
                    gvCurrentMeds.DataBind();

                    gvCurrentVAMeds.DataSource = null;
                    gvCurrentVAMeds.DataBind();

                    grdEdmusScores.DataSource = null;
                    grdEdmusScores.DataBind();

                    grdRelapses.DataSource = null;
                    grdRelapses.DataBind();

                    grdVital.DataSource = null;
                    grdVital.DataBind();

                    #endregion

                    if (patIcn > 0) {
                        patient = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == patIcn);
                        if (patient != null) {
                            // nothing.

							if (patient.MSSR_CURRENT_STATUS !=null)
                            {
                            	currentStatus = patient.MSSR_CURRENT_STATUS;
                            	lastAssessDate = (DateTime?)currentStatus.LastAssessDate;                            
							}
							if (patient.DateOfDeath != null)
                                patientDOD = patient.DateOfDeath.Value.ToShortDateString();
                                
							assessmentList = patient.MSSR_HF_Condenseds.ToList();
                            if (!String.IsNullOrEmpty(currentStatus.MSDiagnosis)) {
                                lblMSDiagnosis.Text = currentStatus.MSDiagnosis;

                                //if (!String.IsNullOrEmpty(currentStatus.LastMSSubType)) {
                                //    lblMSDiagnosis.Text += " (" + currentStatus.LastMSSubType + ")";
                                //} AssessmentDateTime, Relapses
                            }

                            if (assessmentList != null && assessmentList.Count > 0) {

                                var edmusRelapseResult = (from ed in ctx.vwGetEdmusRelapseScores
                                                          select new
                                                          {
                                                              AssessmentDateTime = ed.Assessment_Date,
                                                              CurrentDisabilityScore = ed.edmusscore,
                                                              Relapses = ed.relapsescore,
                                                              PatientIcn = ed.patient_ICN

                                                          }).Where(t => t.PatientIcn == patIcn.ToString());

                                grdRelapses.DataSource = edmusRelapseResult.Where(relpase => relpase.Relapses != null).OrderByDescending(r => r.AssessmentDateTime);
                                grdRelapses.DataBind();

                                grdEdmusScores.DataSource = edmusRelapseResult.Where(edmus => edmus.CurrentDisabilityScore != null).OrderByDescending(ed => ed.AssessmentDateTime);
                                grdEdmusScores.DataBind();

                                // get latest survey
                                _mssrInstrumentManager = new MSSRInstrumentsManager();

                                SURVEY survey = _mssrInstrumentManager.SelectLatestCompletedByPatientICNAndSurveyType(_patientIcn, 30);
                                string status = String.Empty;

                                // ONLY works for patients that have web forms ... I can't find data on Family History in the old tables.

                                if (survey != null) {
                                    SURVEY_RESULT Q4_Result = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "4"); // get question for Family History
                                    SURVEY_RESULT Q5_Result = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "5"); // get question for Family History
                                    SURVEY_RESULT Q6_Result = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "6"); // get question for Family History

                                    if (Q4_Result != null && Q5_Result != null && Q6_Result != null)
                                    {
                                        if (Q4_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("yes") ||
                                            Q5_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("yes") ||
                                            Q6_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("yes"))
                                        {
                                            familyHistory = "Yes";
                                        }
                                        else if (Q4_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("unknown") ||
                                            Q5_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("unknown") ||
                                            Q6_Result.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("unknown"))
                                        {
                                            // display UNK
                                            familyHistory = "UNK";
                                        }
                                        else 
                                        {
                                            // display No
                                            familyHistory = "No";
                                        }
                                    }
                                    //Get parent question.                                  

                                    // bind meds
                                    List<MSSR_PATIENT_MEDICATION> medList = ctx.MSSR_PATIENT_MEDICATIONs.Where(M => M.SURVEY_ID == survey.SURVEYS_ID).ToList();
                                    List<MssrCorticosteroidDisplay> currentCorticosteroidList = new List<MssrCorticosteroidDisplay>();
                                    List<MssrMedicationDisplay> currentStatusMedList = new List<MssrMedicationDisplay>();
                                    MssrMedicationDisplay newMedDisplay = null;
                                    foreach (MSSR_PATIENT_MEDICATION med in medList) {

                                        if (med.CURRENT_THERAPY != null) {
                                            if ((bool)med.CURRENT_THERAPY) {
                                                newMedDisplay = new MssrMedicationDisplay();
                                                newMedDisplay.Current = "Yes";// true;
                                                if (!string.IsNullOrEmpty(med.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED))
                                                    newMedDisplay.ApproxDateStarted = med.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED;
                                                if (med.MSSR_DISPENSING_PHARMACY != null && !string.IsNullOrEmpty(med.MSSR_DISPENSING_PHARMACY.PHARMACY))
                                                    newMedDisplay.DispensingPharmacy = med.MSSR_DISPENSING_PHARMACY.PHARMACY;
                                                if (med.MSSR_MEDICATION != null && !string.IsNullOrEmpty(med.MSSR_MEDICATION.MEDICATION))
                                                    newMedDisplay.Name = med.MSSR_MEDICATION.MEDICATION;
                                                currentStatusMedList.Add(newMedDisplay);
                                                //currentStatusMedList.Add(new MssrMedicationDisplay() { ApproxDateStarted = med.CURRENT_THERAPY_APPROXIMATE_YEAR_STARTED, Current = true, DispensingPharmacy = med.MSSR_DISPENSING_PHARMACY.PHARMACY, Name = med.MSSR_MEDICATION.MEDICATION });
                                            }
                                        }

                                        if (med.PAST_USE != null) {
                                            if ((bool)med.PAST_USE) {
                                                newMedDisplay = new MssrMedicationDisplay();
                                                newMedDisplay.Current = "Not Current";// false;
                                                if (!string.IsNullOrEmpty(med.PAST_USE_APPROXIMATE_YEAR_STARTED))
                                                    newMedDisplay.ApproxDateStarted = med.PAST_USE_APPROXIMATE_YEAR_STARTED;
                                                if (!string.IsNullOrEmpty(med.PAST_USE_APPROXIMATE_YEAR_STOPPED))
                                                    newMedDisplay.ApproxDateStopped = med.PAST_USE_APPROXIMATE_YEAR_STOPPED;
                                                if (med.MSSR_DISPENSING_PHARMACY1 != null && !string.IsNullOrEmpty(med.MSSR_DISPENSING_PHARMACY1.PHARMACY))
                                                    newMedDisplay.DispensingPharmacy = med.MSSR_DISPENSING_PHARMACY1.PHARMACY;
                                                if (med.MSSR_MEDICATION != null && !string.IsNullOrEmpty(med.MSSR_MEDICATION.MEDICATION))
                                                    newMedDisplay.Name = med.MSSR_MEDICATION.MEDICATION;
                                                currentStatusMedList.Add(newMedDisplay);
                                                //currentStatusMedList.Add(new MssrMedicationDisplay() { ApproxDateStarted = med.PAST_USE_APPROXIMATE_YEAR_STARTED, ApproxDateStopped = med.PAST_USE_APPROXIMATE_YEAR_STOPPED, Current = false, DispensingPharmacy = med.MSSR_DISPENSING_PHARMACY1.PHARMACY, Name = med.MSSR_MEDICATION.MEDICATION });
                                            }
                                        }
                                    }

                                    #region Legacy Corticosteroid Section
                                    //Determine corticosteroid use
                                    SURVEY_RESULT cortResult = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORT");
                                    if (cortResult != null) {
                                        if (cortResult.STD_QUESTION_CHOICE.CHOICE_NAME == "2") {
                                            // current or past use
                                            SURVEY_RESULT cortCurrentResult = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCU");
                                            if (cortCurrentResult != null) {
                                                // currently use corts
                                                #region Get Current Corticosteroid Use

                                                // CORT IV - DEX
                                                MssrCorticosteroidDisplay cortIVDex = new MssrCorticosteroidDisplay();
                                                SURVEY_RESULT temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVDexPharm");
                                                if (temp != null) {
                                                    cortIVDex.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVDexSchedule");
                                                if (temp != null) {
                                                    cortIVDex.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVDexApproxStarted");
                                                if (temp != null) {
                                                    cortIVDex.ApproxDateStarted = temp.RESULT_TEXT;
                                                }

                                                cortIVDex.Name = "Dexamethasone IV (Decadron)";

                                                if (!String.IsNullOrEmpty(cortIVDex.Schedule) && !String.IsNullOrEmpty(cortIVDex.DispensingPharmacy) && !String.IsNullOrEmpty(cortIVDex.ApproxDateStarted)) {
                                                    currentCorticosteroidList.Add(cortIVDex);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortIVDex.Name, DispensingPharmacy = cortIVDex.DispensingPharmacy, Current = true, ApproxDateStarted = cortIVDex.ApproxDateStarted, Schedule = cortIVDex.Schedule });
                                                }

                                                // CORT IV - METH
                                                MssrCorticosteroidDisplay cortIVMeth = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVMethPharm");
                                                if (temp != null) {
                                                    cortIVMeth.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVMethSchedule");
                                                if (temp != null) {
                                                    cortIVMeth.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUIVMethApproxStarted");
                                                if (temp != null) {
                                                    cortIVMeth.ApproxDateStarted = temp.RESULT_TEXT;
                                                }

                                                cortIVMeth.Name = "Methylprednisolone IV (Solumedrol)";

                                                if (!String.IsNullOrEmpty(cortIVMeth.Schedule) && !String.IsNullOrEmpty(cortIVMeth.DispensingPharmacy) && !String.IsNullOrEmpty(cortIVMeth.ApproxDateStarted)) {
                                                    currentCorticosteroidList.Add(cortIVMeth);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortIVMeth.Name, DispensingPharmacy = cortIVMeth.DispensingPharmacy, Current = true, ApproxDateStarted = cortIVMeth.ApproxDateStarted, Schedule = cortIVMeth.Schedule });
                                                }

                                                // CORT ORAL - METH
                                                MssrCorticosteroidDisplay cortOralMeth = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralMethPharm");
                                                if (temp != null) {
                                                    cortOralMeth.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralMethSchedule");
                                                if (temp != null) {
                                                    cortOralMeth.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralMethApproxStarted");
                                                if (temp != null) {
                                                    cortOralMeth.ApproxDateStarted = temp.RESULT_TEXT;
                                                }

                                                cortOralMeth.Name = "Methylprednisolone PO (Medrol)";

                                                if (!String.IsNullOrEmpty(cortOralMeth.Schedule) && !String.IsNullOrEmpty(cortOralMeth.DispensingPharmacy) && !String.IsNullOrEmpty(cortOralMeth.ApproxDateStarted)) {
                                                    currentCorticosteroidList.Add(cortOralMeth);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortOralMeth.Name, DispensingPharmacy = cortOralMeth.DispensingPharmacy, Current = true, ApproxDateStarted = cortOralMeth.ApproxDateStarted, Schedule = cortOralMeth.Schedule });
                                                }

                                                // CORT ORAL - PRED
                                                MssrCorticosteroidDisplay cortOralPred = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralPredPharm");
                                                if (temp != null) {
                                                    cortOralPred.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralPredSchedule");
                                                if (temp != null) {
                                                    cortOralPred.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTCUOralPredApproxStarted");
                                                if (temp != null) {
                                                    cortOralPred.ApproxDateStarted = temp.RESULT_TEXT;
                                                }

                                                cortOralPred.Name = "Prednisone PO";

                                                if (!String.IsNullOrEmpty(cortOralPred.Schedule) && !String.IsNullOrEmpty(cortOralPred.DispensingPharmacy) && !String.IsNullOrEmpty(cortOralPred.ApproxDateStarted)) {
                                                    currentCorticosteroidList.Add(cortOralPred);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortOralPred.Name, DispensingPharmacy = cortOralPred.DispensingPharmacy, Current = true, ApproxDateStarted = cortOralPred.ApproxDateStarted, Schedule = cortOralPred.Schedule });
                                                }

                                                #endregion
                                            }

                                            SURVEY_RESULT cortPastResult = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPU");
                                            if (cortPastResult != null) {
                                                // past use corts
                                                #region Get Past Corticosteroid Use

                                                // CORT IV - DEX
                                                MssrCorticosteroidDisplay cortPUIVDex = new MssrCorticosteroidDisplay();
                                                SURVEY_RESULT temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVDexPharm");
                                                if (temp != null) {
                                                    cortPUIVDex.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVDexSchedule");
                                                if (temp != null) {
                                                    cortPUIVDex.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVDexApproxStopped");
                                                if (temp != null) {
                                                    cortPUIVDex.ApproxDateStopped = temp.RESULT_TEXT;
                                                }
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVDexApproxStarted");
                                                if (temp != null)
                                                {
                                                    cortPUIVDex.ApproxDateStarted = temp.RESULT_TEXT;
                                                } 
                                                cortPUIVDex.Name = "Dexamethasone IV (Decadron)";

                                                if (!String.IsNullOrEmpty(cortPUIVDex.Schedule) && !String.IsNullOrEmpty(cortPUIVDex.DispensingPharmacy) && !String.IsNullOrEmpty(cortPUIVDex.ApproxDateStopped)) {
                                                    currentCorticosteroidList.Add(cortPUIVDex);
                                                   // currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortPUIVDex.Name, DispensingPharmacy = cortPUIVDex.DispensingPharmacy, Current = false, ApproxDateStopped = cortPUIVDex.ApproxDateStopped, Schedule = cortPUIVDex.Schedule });
                                                }

                                                // CORT IV - METH
                                                MssrCorticosteroidDisplay cortPUIVMeth = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVMethPharm");
                                                if (temp != null) {
                                                    cortPUIVMeth.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVMethSchedule");
                                                if (temp != null) {
                                                    cortPUIVMeth.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVMethApproxStopped");
                                                if (temp != null) {
                                                    cortPUIVMeth.ApproxDateStopped = temp.RESULT_TEXT;
                                                }
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUIVMethApproxStarted");
                                                if (temp != null)
                                                {
                                                    cortPUIVMeth.ApproxDateStarted = temp.RESULT_TEXT;
                                                } 
                                                cortPUIVMeth.Name = "Methylprednisolone IV (Solumedrol)";

                                                if (!String.IsNullOrEmpty(cortPUIVMeth.Schedule) && !String.IsNullOrEmpty(cortPUIVMeth.DispensingPharmacy) && !String.IsNullOrEmpty(cortPUIVMeth.ApproxDateStopped)) {
                                                    currentCorticosteroidList.Add(cortPUIVMeth);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortPUIVMeth.Name, DispensingPharmacy = cortPUIVMeth.DispensingPharmacy, Current = false, ApproxDateStopped = cortPUIVMeth.ApproxDateStopped, Schedule = cortPUIVMeth.Schedule });
                                                }

                                                // CORT ORAL - METH
                                                MssrCorticosteroidDisplay cortPUOralMeth = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralMethPharm");
                                                if (temp != null) {
                                                    cortPUOralMeth.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralMethSchedule");
                                                if (temp != null) {
                                                    cortPUOralMeth.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralMethApproxStopped");
                                                if (temp != null) {
                                                    cortPUOralMeth.ApproxDateStopped = temp.RESULT_TEXT;
                                                }
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralMethApproxStarted");
                                                if (temp != null)
                                                {
                                                    cortPUOralMeth.ApproxDateStarted = temp.RESULT_TEXT;
                                                } 
                                                cortPUOralMeth.Name = "Methylprednisolone PO (Medrol)";

                                                if (!String.IsNullOrEmpty(cortPUOralMeth.Schedule) && !String.IsNullOrEmpty(cortPUOralMeth.DispensingPharmacy) && !String.IsNullOrEmpty(cortPUOralMeth.ApproxDateStopped)) {
                                                    currentCorticosteroidList.Add(cortPUOralMeth);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortPUOralMeth.Name, DispensingPharmacy = cortPUOralMeth.DispensingPharmacy, Current = false, ApproxDateStopped = cortPUOralMeth.ApproxDateStopped, Schedule = cortPUOralMeth.Schedule });
                                                }

                                                // CORT ORAL - PRED
                                                MssrCorticosteroidDisplay cortPUOralPred = new MssrCorticosteroidDisplay();
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralPredPharm");
                                                if (temp != null) {
                                                    cortPUOralPred.DispensingPharmacy = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralPredSchedule");
                                                if (temp != null) {
                                                    cortPUOralPred.Schedule = temp.RESULT_TEXT;
                                                }

                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralPredApproxStopped");
                                                if (temp != null) {
                                                    cortPUOralPred.ApproxDateStopped = temp.RESULT_TEXT;
                                                }
                                                temp = survey.SURVEY_RESULTs.FirstOrDefault(R => R.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER == "CORTPUOralPredApproxStarted");
                                                if (temp != null)
                                                {
                                                    cortPUOralPred.ApproxDateStarted = temp.RESULT_TEXT;
                                                }
                                                cortPUOralPred.Name = "Prednisone PO";

                                                if (!String.IsNullOrEmpty(cortPUOralPred.Schedule) && !String.IsNullOrEmpty(cortPUOralPred.DispensingPharmacy) && !String.IsNullOrEmpty(cortPUOralPred.ApproxDateStopped)) {
                                                    currentCorticosteroidList.Add(cortPUOralPred);
                                                    //currentStatusMedList.Add(new MssrMedicationDisplay() { Name = cortPUOralPred.Name, DispensingPharmacy = cortPUOralPred.DispensingPharmacy, Current = false, ApproxDateStopped = cortPUOralPred.ApproxDateStopped, Schedule = cortPUOralPred.Schedule });
                                                }

                                                #endregion
                                            }
                                        }
                                    }
                                    #endregion

                                    // bind meds ... 
                                    gvCurrentMeds.DataSource = currentStatusMedList.OrderByDescending(M => M.Current).ThenByDescending(a => a.ApproxDateStarted);
                                    gvCurrentMeds.DataBind();

                                    gvCurrentVAMeds.DataSource = currentStatusMedList.Where(M => M.Current == "Yes" && M.DispensingPharmacy != null && M.DispensingPharmacy.ToLower() == "va pharmacy").OrderByDescending(a => a.ApproxDateStarted);
                                    gvCurrentVAMeds.DataBind();

                                    gvCurrentCORTMeds.DataSource = currentCorticosteroidList;
                                    gvCurrentCORTMeds.DataBind();
                                }
                            }

                            // populate latest vital signs
                            var latestVitalSigns = from v in ctx.MSSR_VITAL_SIGNs
                                                   where patIcn == v.PatientICN && v.VitalSignTakenDateTime == 
                                                        (from d in ctx.MSSR_VITAL_SIGNs 
                                                         where d.PatientICN == patIcn
                                                         select d.VitalSignTakenDateTime).Max()
                                                   select v;

                            if (latestVitalSigns != null) {
                                grdVital.DataSource = latestVitalSigns.ToList();
                                grdVital.DataBind();

                                try {
                                    if (latestVitalSigns.ToList().Count > 0)
                                    {
                                        lblLatestVitalDate.Text = "( " + ((DateTime)latestVitalSigns.FirstOrDefault().VitalSignTakenDateTime).ToString() + " )";
                                    }
                                } catch (Exception ex) {

                                    Logging.WriteLogToFile("Failure in PatientDetails Page_Load: " + ex.Message);
                                }
                            }

                            //populate survey History                           
                                var surveyHistory = ctx.GetListOfUsersCreatedSurveyByPatientICN(patIcn.ToString()).ToList();
                                grdViewSurveyHistory.DataSource = surveyHistory;
                                grdViewSurveyHistory.DataBind();
                          
                            

                        } else {
                            // PATIENT NOT FOUND - SHOW ERROR
                        }
                    }
                }
            }

            #endregion
        //}

        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        setBreadCrumb();
    }

    private string FormatDateTime(DateTime? pDateTime)
    {
        if (pDateTime.HasValue)
        {
            return ((DateTime)pDateTime).ToShortDateString();
        }
        else
        {
            return string.Empty;
        }      
       
    }

    //private DateTime? ConvertToDate(string pDate)
    //{
    //    DateTime? returnDate = null;
    //    DateTime tempDate;
    //    if (pDate.Length > 4)
    //    {
    //        bool result = DateTime.TryParse(pDate, out tempDate);
    //        if (result)
    //        {
    //            returnDate = tempDate;            
    //        }
    //    }
    //    else
    //    {
            
    //    }
        

    //    return returnDate;
    //}

    /// <summary>
    /// Button click to export grid to Excel.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void imgBtnExportToExcel_Click(object sender, System.Web.UI.ImageClickEventArgs e)
    {
             
            string destinationUrl = string.Concat(exportDestination, _patientIcn);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                Server.Transfer(destinationUrl, false);
            }      
        
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb() {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "<a href=\"Patients.aspx\">Patients</a> > MSSR Patient Details";
    }

    #endregion

    protected class MssrMedicationDisplay {
        public string Name { get; set; }
        public string DispensingPharmacy { get; set; } // VA Pharmacy, Non-VA Pharmacy
        public string Current { get; set; }
        public string ApproxDateStarted { get; set; }
        public string ApproxDateStopped { get; set; }
        public string Schedule { get; set; }
    }

    protected class MssrCorticosteroidDisplay {
        public string Name { get; set; } // Dexamethasone IV (Decadron), Methylprednisolone IV (Solumedrol), Methylprednisolone PO (Medrol), Prednisone PO
        public string DispensingPharmacy { get; set; } // VA Pharmacy, Non-VA Pharmacy
        public string Schedule { get; set; } // Monthly schedule, Other schedule
        public string ApproxDateStarted { get; set; }
        public string ApproxDateStopped { get; set; }
    }
}