﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="NewPatients.aspx.cs" Inherits="NewPatients" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:RadScriptManager ID="RadScriptManager1" runat="server" />
    <div>
        <div style="padding-left: 15px; height: 20px; background-color: #1E2E50; color: whitesmoke">
            <asp:Label ID="lblPatNameLast4" runat="server"></asp:Label>
        </div>
        <telerik:RadGrid ID="rdListOfNewPatients" runat="server" AllowPaging="True" AllowSorting="True" grouppanelposition="Top" ToolTip="List of New Patients"
            OnItemCommand="rdListOfNewPatients_OnItemCommand" OnNeedDataSource="PopulateNewPatientGrid"
            AllowMultiRowSelection="false" PageSize="20">
            <SortingSettings SortedBackColor="#ffffff" />
            <SelectedItemStyle BackColor="#FFE1A4"></SelectedItemStyle>
            <MasterTableView Caption="" AllowNaturalSort="true" AllowMultiColumnSorting="true" AllowPaging="True" AllowSorting="True"
                AutoGenerateColumns="false" ShowHeadersWhenNoRecords="true" CssClass="" DataKeyNames="PatientICN, Station"
                PagerStyle-AlwaysVisible="true" TabIndex="0">
                <NoRecordsTemplate>
                    <table>
                        <tr>
                            <td>
                                <asp:Label ID="lblNoRecords" runat="server" Style="color: #000000; font-size: 10pt; font-weight: normal;" TabIndex="0">
                                No New Patients Available.
                                </asp:Label>
                            </td>
                        </tr>
                    </table>
                </NoRecordsTemplate>
                <Columns>
                    <telerik:GridTemplateColumn HeaderText="Create Survey">
                        <ItemTemplate>
                            <asp:ImageButton ID="imgBtnReviewSurveys" CommandName="Select" AlternateText="Click to Create Survey"
                                ToolTip="Click to Create Survey." ImageUrl="images/create_survey.png"
                                runat="server" />
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridBoundColumn DataField="PatientSSN" DataType="System.String"
                        HeaderText="Patient SSN" />
                    <telerik:GridBoundColumn DataField="PatientICN" DataType="System.String"
                        HeaderText="Patient ICN" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="PatientLastName" DataType="System.String"
                        HeaderText="Last Name" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="PatientFirstName" DataType="System.String"
                        HeaderText="First Name" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="Age" DataType="System.String"
                        HeaderText="Age" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="DateOfBirth" DataType="System.DateTime"
                        HeaderText="Date Of Birth">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="City" DataType="System.String"
                        HeaderText="City" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="State" DataType="System.String"
                        HeaderText="State" ReadOnly="True">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="Station" DataType="System.String"
                        HeaderText="Station" ReadOnly="True" />
                </Columns>
            </MasterTableView>
            <PagerStyle Mode="NumericPages" Position="Bottom" />
        </telerik:RadGrid>
    </div>
</asp:Content>

