﻿using System;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class MSSR_Instruments_ProgressNoteSetup : BaseMSSRInstrumentPage
{

    #region Public Methods

    //SURVEY survey;

    public MSSR_Instruments_ProgressNoteSetup()
    {
    }

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        base.BaseMSSRInstrumentPage_Load(sender, e);

        if (!IsPostBack)
        {
            if (_mssrInstrumentManager.MssrServiceTo != null)
            {
                if (_mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType == null)
                {
                    //if instrument type is not selected page was accessed incorrectly
                    //redirect to warning message
                    Response.Redirect("Warning.aspx?err=4", false);

                }

                if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientLocationId))
                {
                    LocationIdField.Value = _mssrInstrumentManager.MssrServiceTo.PatientLocationId;
                }
                else
                {
                    LocationIdField.Value = "0";
                }

                if (_mssrInstrumentManager.MssrServiceTo.CprsSentMSSREvaluationNoteId != 0
                    &&
                    _mssrInstrumentManager.MssrServiceTo.CprsSentMSSRFollowUpNoteId != 0
                    )
                {
                    tableRowInstrumentTypeLabel.Visible = false;
                    tableRowInstrumentTypeDropDown.Visible = false;

                    if (_mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType.Id == 2)
                    {
                        _mssrInstrumentManager.MssrServiceTo.SelectedNoteTitleId = _mssrInstrumentManager.MssrServiceTo.CprsSentMSSREvaluationNoteId.ToString();
                    }
                    else
                    {
                        _mssrInstrumentManager.MssrServiceTo.SelectedNoteTitleId = _mssrInstrumentManager.MssrServiceTo.CprsSentMSSRFollowUpNoteId.ToString();
                    }

                }

                LabelInstrumentType.Text = _mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType.Name;
            }

            RadioButtonListEncounterType.SelectedIndex = -1;
            TableRowClinicAppointment.Visible = false;
            TableRowHospitalAdmission.Visible = false;
            TableRowUnscheduledNewVisitLocation.Visible = false;
            TableRowCosigner.Visible = false;

            //populate consult drop down list 
            string errorMessage;

            try
            {

                //populate note title drop down list
                object titles;
                if (_mssrInstrumentManager != null)
                {
                    if (txtNoteSearchFilter.Text == "")
                    {
                        if (getCurrentServiceToUse() == "VIA")
                        {
                            titles = _mssrInstrumentManager.getNoteTitlesFromVIA("MULTIPLE SCLEROSIS", "", out errorMessage);
                        }
                        else
                        {
                            titles = _mssrInstrumentManager.getNoteTitles("MULTIPLE SCLEROSIS", "", out errorMessage);
                        }
                    }
                    else
                    {
                        if (getCurrentServiceToUse() == "VIA")
                        {
                            titles = _mssrInstrumentManager.getNoteTitlesFromVIA("" + txtNoteSearchFilter.Text + "", "", out errorMessage);
                        }
                        else
                        {
                            titles = _mssrInstrumentManager.getNoteTitles("" + txtNoteSearchFilter.Text + "", "", out errorMessage);
                        }
                    }

                    if (errorMessage == "SUCCESS")
                    {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage))
                    {
                        DropDownListNoteTitleId.DataSource = titles;
                        DropDownListNoteTitleId.DataBind();
                    }
                    else
                    {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                        return;
                    }
                }
                else
                {
                    titles = null;
                }

                int _consultCount = 0;
                object consults;
                if (_mssrInstrumentManager != null)
                {
                    if (getCurrentServiceToUse() == "VIA")
                    {
                        consults = _mssrInstrumentManager.getConsultsFromVIA(out errorMessage);//try passing noteid as paramter
                        _consultCount = _mssrInstrumentManager.getConsultsFromVIA(out errorMessage).Count;
                    }
                    else
                    {
                        consults = _mssrInstrumentManager.getConsults(out errorMessage);//try passing noteid as paramter
                        _consultCount = _mssrInstrumentManager.getConsults(out errorMessage).Count;
                    }

                    if (errorMessage == "SUCCESS")
                    {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage))
                    {
                        DropDownListConsult.DataSource = consults;
                        DropDownListConsult.DataBind();
                    }
                    else
                    {
                        //display error message and stop porcessing
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                        return;
                    }

                    if (_consultCount == 0)
                    {
                        LabelforDropDownListConsult.Visible = false;
                        DropDownListConsult.Visible = false;
                        RequiredFieldValidatorDropDownListConsult.Enabled = false;
                    }
                    else
                    {
                        LabelforDropDownListConsult.Visible = true;
                        DropDownListConsult.Visible = true;
                        RequiredFieldValidatorDropDownListConsult.Enabled = true;
                        LabelforDropDownListConsult.Text = "Link to Consult:";
                        LabelforDropDownListConsult.Font.Bold = true;
                    }
                }
                else
                {
                    consults = null;
                }

            }
            catch (Exception ex)
            {
                Logging.WriteLogToFile("Failure in MSAssessmentTool Page_Load: " + ex.Message);
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;
                Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "Page_load()");
                MDWSCallError.Text = ex.Message;
            }
        }

        if (_mssrInstrumentManager.MssrServiceTo != null)
        {
            LabelPatient.Text = _mssrInstrumentManager.MssrServiceTo.PatientName;
            LabelInstrumentType.Text = _mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType.Name;
        }
    }

    protected void ButtonContinue_Click(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListCosigner.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedCosignerID = DropDownListCosigner.SelectedValue;
            }

            if (DropDownListNoteTitleId.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;
            }

            if (DropDownListConsult.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedConsultId = DropDownListConsult.SelectedValue;
            }

            if (DropDownListScheduledClinicAppointment.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedVisitId = DropDownListScheduledClinicAppointment.SelectedValue;
            }

            if (DropDownListHospitalAdmission.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedHospitalAdmissionId = DropDownListHospitalAdmission.SelectedValue;
            }

            if (DropDownListUnscheduleNewVisitLocation.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedLocationID = DropDownListUnscheduleNewVisitLocation.SelectedValue;
            }

            _mssrInstrumentManager.MssrServiceTo.isHistorical = CheckBoxUnscheduledNewVisitHistorical.Checked;

            if (RadioButtonListEncounterType.SelectedIndex != -1)
            {
                NoteType _SelectedNoteType = new NoteType();
                _SelectedNoteType.Id = RadioButtonListEncounterType.SelectedIndex;

                _mssrInstrumentManager.MssrServiceTo.SelectedNoteType = _SelectedNoteType;
            }

            AddtoSessionMSSRServiceTo(_mssrInstrumentManager.MssrServiceTo);

            Response.Redirect("MSAssessmentTool.aspx", false);
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentTool ButtonContinue_Click: " + ex.Message);
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "ButtonContinue_Click()");
        }
    }

    protected void RadioButtonListEncounterType_SelectedIndexChanged(object sender, EventArgs e)
    {
        ButtonContinue.Visible = false;

        TableRowClinicAppointment.Visible = false;
        TableRowHospitalAdmission.Visible = false;
        TableRowUnscheduledNewVisitLocation.Visible = false;

        int encounterTypeSelected =
        Helpers.getIntFromString(RadioButtonListEncounterType.SelectedValue);

        string errorMessage;

        if (encounterTypeSelected != (int)NoteTypeEnum.ScheduledClinicAppointment)
        {
            TextBoxAppointmentSearchDateStart.Text = "";
            TextBoxAppointmentSearchDateEnd.Text = "";
        }
        
        switch (encounterTypeSelected)
        {
            case (int)NoteTypeEnum.ScheduledClinicAppointment:  //Scheduled Clinic Appointment
                TableRowClinicAppointment.Visible = true;

                FilterAndBindVisits();

                break;

            case (int)NoteTypeEnum.HospitalAdmission:  //Hospital Admission
                TableRowHospitalAdmission.Visible = true;

                //populate hospital admission drop down list
                //DropDownListHospitalAdmission.DataSource = _mssrInstrumentManager.getHospitalAdmissions(out errorMassage);
                try
                {
                    List<KeyValuePair<string, string>> admissions = new List<KeyValuePair<string, string>>();

                    if (getCurrentServiceToUse() == "VIA")
                    {
                        admissions = _mssrInstrumentManager.getHospitalAdmissionsFromVIA(out errorMessage);
                    }
                    else
                    {
                        admissions = _mssrInstrumentManager.getHospitalAdmissions(out errorMessage);
                    }

                    if (errorMessage == "SUCCESS")
                    {
                        errorMessage = null;
                    }

                    if (String.IsNullOrEmpty(errorMessage))
                    {
                        DropDownListHospitalAdmission.DataSource = admissions;
                        DropDownListHospitalAdmission.DataBind();

                    }
                    else
                    {
                        PanelObjectContent.Visible = false;
                        ErrorPanel.Visible = true;

                        MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                        return;

                    }
                }
                catch (Exception ex)
                {
                    Logging.WriteLogToFile("Failure in MSAssessmentTool RadioButtonListEncounterType admission: " + ex.Message);
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;
                    Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "RadioButtonListEncounterType_SelectedIndexChanged() - HospitalAdmission");

                    MDWSCallError.Text = ex.Message;
                }
                break;

            case (int)NoteTypeEnum.CurrentStay:  //Current Stay
                //do nothing
                break;

            case (int)NoteTypeEnum.UnscheduledOrNewVisit: //Unscheduled or New Visit
                TableRowUnscheduledNewVisitLocation.Visible = true;

                FilterAndBindLocations();

                break;

        }

        ButtonContinue.Visible = true;
    }

    protected void Filter_NoteSearch(object sender, EventArgs e)
    {
        //Get the text from text box

        //Preview the text and show it in Div
        string errorMessage;
        try
        {
            if (IsPostBack)
            {
                object titles;

                string filter_text = null;
                if (_mssrInstrumentManager != null)
                {
                    filter_text = ((TextBox)sender).Text;
                    if (filter_text != null)
                    {
                        if (DropDownListNoteTitleId.Items.Count > 0)
                        {
                            DropDownListNoteTitleId.Items.Clear();
                            DropDownListNoteTitleId.Items.Add(new ListItem("-- Select a Value --", "0"));
                        }

                        if (getCurrentServiceToUse() == "VIA")
                        {
                            titles = _mssrInstrumentManager.getNoteTitlesFromVIA("" + filter_text + "", "", out errorMessage);
                        }
                        else
                        {
                            titles = _mssrInstrumentManager.getNoteTitles("" + filter_text + "", "", out errorMessage);
                        }

                        if (errorMessage == "SUCCESS")
                        {
                            errorMessage = null;
                        }

                        if (String.IsNullOrEmpty(errorMessage))
                        {
                            DropDownListNoteTitleId.DataSource = titles;
                            DropDownListNoteTitleId.DataBind();
                        }
                        else
                        {
                            PanelObjectContent.Visible = false;
                            ErrorPanel.Visible = true;

                            MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                            return;
                        }
                    }
                }
                else
                {
                    titles = null;
                }
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentTool Filter_NoteSearch: " + ex.Message);
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "Filter_NoteSearch()");
        }
    }

    protected void DropDownListNoteTitleId_SelectedIndexChanged(object sender, EventArgs e)
    {
        string errorMessage;
        string _notetitle = "";
        bool _isconsultnotetitle = false;

        try
        {

            if (DropDownListNoteTitleId.SelectedValue != "0")
            {
                _mssrInstrumentManager.MssrServiceTo.SelectedNoteTitleId = DropDownListNoteTitleId.SelectedValue;

                bool needCosigner;

                if (getCurrentServiceToUse() == "VIA")
                {
                    needCosigner = _mssrInstrumentManager.isCosignerRequiredVIA(_mssrInstrumentManager.MssrServiceTo, out errorMessage);
                }
                else
                {
                    needCosigner = _mssrInstrumentManager.isCosignerRequired(_mssrInstrumentManager.MssrServiceTo, out errorMessage);
                }

                if (errorMessage == "SUCCESS")
                {
                    errorMessage = null;
                }

                if (String.IsNullOrEmpty(errorMessage))
                {
                    if (DropDownListNoteTitleId.SelectedItem != null)
                    {
                        _notetitle = DropDownListNoteTitleId.SelectedItem.Text.ToString().ToUpper();
                        _isconsultnotetitle = _notetitle.Contains("CONSULT");
                    }

                    if (needCosigner)
                    {
                        ButtonContinue.Visible = false;
                        TableRowCosigner.Visible = true;
                        FilterAndBindCosigners();
                        ButtonContinue.Visible = true;
                    }
                    else
                    {
                        TableRowCosigner.Visible = false;
                    }

                    if (_isconsultnotetitle == true)
                    {
                        LabelforDropDownListConsult.Visible = true;
                        DropDownListConsult.Visible = true;
                        LabelforDropDownListConsult.Text = "Link to Consult *:";
                        LabelforDropDownListConsult.Font.Bold = true;
                        DropDownListConsult.SelectedIndex = 0;
                        RequiredFieldValidatorDropDownListConsult.Enabled = true;
                    }
                    else
                    {
                        LabelforDropDownListConsult.Visible = false;
                        DropDownListConsult.Visible = false;
                        RequiredFieldValidatorDropDownListConsult.Enabled = false;
                    }
                }
                else
                {
                    PanelObjectContent.Visible = false;
                    ErrorPanel.Visible = true;

                    MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                }
            }
            else
            {
                TableRowCosigner.Visible = false;
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in MSAssessmentTool DropDownListNoteTitleId_SelectedIndexChanged: " + ex.Message);
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "DropDownListNoteTitleId_SelectedIndexChanged()");
        }
    }

    protected void ButtonFilterAppointments_Click(object sender, EventArgs e)
    {
        FilterAndBindVisits();
    }

    protected void ButtonGetLocations_Click(object sender, EventArgs e)
    {
        FilterAndBindLocations();
    }

    protected void ButtonGetCPRSUsers_Click(object sender, EventArgs e)
    {
        FilterAndBindCosigners();
    }

    #endregion

    #region Private Methods

    private void FilterAndBindLocations()
    {
        string errorMessage;
        List<KeyValuePair<string, string>> locations = new List<KeyValuePair<string, string>>();

        if (getCurrentServiceToUse() == "VIA")
        {
            locations = _mssrInstrumentManager.getLocationsFromVIA(TextBoxLocationSearchString.Text, "MULTIPLE SCLEROSIS", "1", out errorMessage);
        }
        else
        {
            locations = _mssrInstrumentManager.getLocations(TextBoxLocationSearchString.Text, "MULTIPLE SCLEROSIS", "1", out errorMessage);
        }

        if (errorMessage == "SUCCESS")
        {
            errorMessage = null;
        }

        try
        {
            if (String.IsNullOrEmpty(errorMessage))
            {
                DropDownListUnscheduleNewVisitLocation.ClearSelection();
                DropDownListUnscheduleNewVisitLocation.Items.Clear();
                DropDownListUnscheduleNewVisitLocation.Items.Add(new ListItem("-- Select a Value --", "0"));

                DropDownListUnscheduleNewVisitLocation.DataSource = locations;
                DropDownListUnscheduleNewVisitLocation.DataBind();

            }
            else
            {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                return;

            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in MSAssessmentTool FilterAndBindLocations: " + ex.Message);
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "FilterAndBindLocations()");
            MDWSCallError.Text = ex.Message;
        }
    }

    private void FilterAndBindVisits()
    {
        //populate Appointments drop down list
        DateTime toDate = new DateTime();
        DateTime fromDate = new DateTime();
        string errorMessage;

        if (TextBoxAppointmentSearchDateStart.Text != "")
        {
            fromDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text);
        }
        else
        {
            //if user does not enter a date then default to 30 days prior
            if (TextBoxAppointmentSearchDateEnd.Text == "")
            {
                fromDate = System.DateTime.Now.AddDays(-30);
            }
            else
            {
                fromDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text).AddDays(-30);
            }
        }

        if (TextBoxAppointmentSearchDateEnd.Text != "")
        {
            toDate = DateTime.Parse(TextBoxAppointmentSearchDateEnd.Text);
        }
        else
        {
            //if user does not enter a date then default to 30 in future
            if (TextBoxAppointmentSearchDateStart.Text == "")
            {
                toDate = System.DateTime.Now.AddDays(30);
            }
            else
            {
                toDate = DateTime.Parse(TextBoxAppointmentSearchDateStart.Text).AddDays(30);
            }
        }

        try
        {
            List<KeyValuePair<string, string>> visits = new List<KeyValuePair<string, string>>();

            if (getCurrentServiceToUse() == "VIA")
            {
                visits = _mssrInstrumentManager.getVisitsFromVIA(fromDate, toDate, out errorMessage);
            }
            else
            {
                visits = _mssrInstrumentManager.getVisits(fromDate, toDate, out errorMessage);
            }

            if (errorMessage == "SUCCESS")
            {
                errorMessage = null;
            }

            if (String.IsNullOrEmpty(errorMessage))
            {
                DropDownListScheduledClinicAppointment.ClearSelection();
                DropDownListScheduledClinicAppointment.Items.Clear();
                DropDownListScheduledClinicAppointment.Items.Add(new ListItem("-- Select a Value --", "0"));

                //DropDownListScheduledClinicAppointment.DataSource = _mssrInstrumentManager.getVisits(fromDate.GetValueOrDefault(), toDate.GetValueOrDefault());
                DropDownListScheduledClinicAppointment.DataSource = visits;

                DropDownListScheduledClinicAppointment.DataBind();
            }
            else
            {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);
                return;
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in MSAssessmentTool FilterAndBindVisits: " + ex.Message);
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "FilterAndBindVisits()");

            MDWSCallError.Text = ex.Message;
        }
    }

    private void FilterAndBindCosigners()
    {
        //populate Cosigners drop down list
        string errorMessage;
        List<KeyValuePair<string, string>> cosigners = new List<KeyValuePair<string, string>>();

        if (getCurrentServiceToUse() == "VIA")
        {
            cosigners = _mssrInstrumentManager.cprsUserLookupFromVIA(TextBoxCosignerSearch.Text, out errorMessage);
        }
        else
        {
            cosigners = _mssrInstrumentManager.cprsUserLookup(TextBoxCosignerSearch.Text, out errorMessage);
        }

        if (errorMessage == "SUCCESS")
        {
            errorMessage = null;
        }

        try
        {
            if (String.IsNullOrEmpty(errorMessage))
            {
                DropDownListCosigner.ClearSelection();
                DropDownListCosigner.Items.Clear();
                DropDownListCosigner.Items.Add(new ListItem("-- Select a Value --", "0"));

                DropDownListCosigner.DataSource = cosigners;
                DropDownListCosigner.DataBind();
            }
            else
            {
                PanelObjectContent.Visible = false;
                ErrorPanel.Visible = true;

                MDWSCallError.Text = AntiXssEnc.Encoder.HtmlEncode(errorMessage);

                return;
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in MSAssessmentTool FilterAndBindCosigners: " + ex.Message);
            PanelObjectContent.Visible = false;
            ErrorPanel.Visible = true;
            Exception _tbilogerror = HandleMSSRException(ex, "ProgressNoteSetup.aspx", "100031", "FilterAndBindCosigners()");

            MDWSCallError.Text = ex.Message;
        }

    }

    #endregion
}