﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using VeteransAffairs.Registries.BusinessManager.MDWS;
using System.Globalization;

public partial class MSSR_Instruments_MSAssessmentTool : BaseMSSRInstrumentPage
{

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    //VeteransAffairs.Registries.BusinessManager.MSSR.InstrumentType instrumentType = new VeteransAffairs.Registries.BusinessManager.MSSR.InstrumentType();

    protected int _surveyTypeId = 30; // Database Id for Instrument

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    controls_MedicationSelection mitoxantroneControl;
    //controls_MedicationSelection natalizumabControl;
    
    //paitent demographic to store in session for database 
    public MssrePatientDemDispaly patientDem
    {
        get
        {
            if (Session["patientDem"] != null)
            {
                return (MssrePatientDemDispaly)Session["patientDem"];
            }
            else
            {
                Session["patientDem"] = new MssrePatientDemDispaly();
                return new MssrePatientDemDispaly();
            }
        }
        set
        {
            if (Session["patientDem"] == null)
            {
                Session["patientDem"] = new MssrePatientDemDispaly();
            }
            Session["patientDem"] = value;
        }
    }
    // current_status object to store in session for database.
    public CurrentStatusDisplay CurrentStatus
    {
        get
        {
            if (Session["mssrCurrentStatus"] != null)
            {
                return (CurrentStatusDisplay)Session["mssrCurrentStatus"];
            }
            else
            {
                Session["mssrCurrentStatus"] = new CurrentStatusDisplay();
                return new CurrentStatusDisplay();
            }
        }
        set
        {
            if (Session["mssrCurrentStatus"] == null)
            {
                Session["mssrCurrentStatus"] = new CurrentStatusDisplay();
            }
            Session["mssrCurrentStatus"] = value;
        }
    }

    // MSSR_HF_Condensed object to store in session for database
    public MssrAssessmentDisplay CurrentAssessmentHF
    {
        get
        {
            if (Session["mssrCurrentAssessmentHF"] != null)
            {
                return (MssrAssessmentDisplay)Session["mssrCurrentAssessmentHF"];
            }
            else
            {
                Session["mssrCurrentAssessmentHF"] = new MssrAssessmentDisplay();
                return new MssrAssessmentDisplay();
            }
        }
        set
        {
            if (Session["mssrCurrentAssessmentHF"] == null)
            {
                Session["mssrCurrentAssessmentHF"] = new MssrAssessmentDisplay();
            }
            Session["mssrCurrentAssessmentHF"] = value;
        }
    }

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    private int _medicationTabIndexer = 975;
    private int _medicationTabIndexer2 = 2135;

    #endregion

    #region Public Methods

    public int MedTabIndexer
    {
        get
        {
            _medicationTabIndexer += 25;
            return _medicationTabIndexer;
        }
    }

    public int MedTabIndexer2
    {
        get
        {
            _medicationTabIndexer2 += 25;
            return _medicationTabIndexer2;
        }
    }

    /// <summary>
    /// Default Constructor
    /// </summary>
    public MSSR_Instruments_MSAssessmentTool()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Page_Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //Set default value for DOD 
            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                try
                {
                    MSSRE_PATIENT_DEM patientTemp = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(C => C.PatientICN == patientDem.PatientICN);
                    if (patientTemp != null)
                    {
                        if (patientTemp.DateOfDeath != null)
                        {
                            Session["CurrDateOfDeath"] = Helpers.SerializSessionItemsObj(patientTemp.DateOfDeath.ToString());
                            DateTime incDate;
                            string incDateStr = Helpers.DeSerializSessionItems(Session["CurrDateOfDeath"]);
                            DateTime.TryParse(incDateStr, out incDate);
                            if (incDate != null)
                            {
                                dpDate2.SelectedDate = incDate;
                            }                            
                        }                        
                    }                    
                }
                catch (Exception)
                {
                    Logging.WriteLogToFile("Failed setting default DoD from DB. ");                    
                }             

            }

            // Set the timeout interval on the page

            string timeout = Helpers.GetDBConfigEntry("MssrMsatPageTimeout");

            try
            {
                int newTimeout = 0;
                int.TryParse(timeout, out newTimeout);

                if (newTimeout > 0)
                {
                    InactiveTimer.Interval = newTimeout;
                    Logging.WriteLogToFile("Set timeout from DB: " + newTimeout.ToString());
                }
                else
                {
                    Logging.WriteLogToFile("Failed getting newTimeout from DB: " + newTimeout.ToString());
                }
            }
            catch (Exception ex)
            {
                // Just ignore, we have the default
                Logging.WriteLogToFile("Failed setting MssrMsatPageTimeout from DB: " + ex.Message);
            }



            setMonthYearSelectorValues();

            var setting = Helpers.GetDBConfigEntry("MSSRShowDateOfDeath");

            if (setting != null && setting.ToString().ToLower() == "true")
            {
                //LabelForDateOfDeath.Visible = true;
                lblDateOfDeath.Visible = true;
            }
        }

        setLogTimeSetting();
        string errorString = "";

        // Clear any past error/warning displays
        DisplayNotificationMessage(false, "", "");

        MSSRServiceTO _mssrServiceTo;

        QuestionList = GetAllQuestionsForSurvey();

        try
        {
            _mssrServiceTo = (MSSRServiceTO)Session["MSSRServiceTO"];
            _mssrInstrumentManager.MssrServiceTo = _mssrServiceTo;
            Session.Remove("NoteText");

            _mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType = _mssrInstrumentManager.GetInstrumentByID(_surveyTypeId);
            string instTitle = _mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType.Name;

            if (_mssrInstrumentManager.MssrServiceTo != null)
            {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = _mssrInstrumentManager.MssrServiceTo.UserName;

                if (lblDateOfDeath.Visible)
                {
                    try
                    {
                        if (_mssrInstrumentManager.MssrServiceTo.PatientDOD != null)
                        {
                            CultureInfo provider = CultureInfo.InvariantCulture;

                            lblDateOfDeath.Text = formatDate(_mssrInstrumentManager.MssrServiceTo.PatientDOD);

                            string fullDateVal = _mssrInstrumentManager.MssrServiceTo.PatientDOD;
                            string Year = fullDateVal.Substring(0, 4);
                            string Month = fullDateVal.Substring(4, 2);
                            string Day = fullDateVal.Substring(6, 2);
                            dpDate2.SelectedDate = Convert.ToDateTime(Month.Trim() + "/" + Day.Trim() + "/" + Year.Trim());


                            if (lblDateOfDeath.Text.Trim().Length == 0)
                            {
                                //LabelForDateOfDeath.Visible = false;
                                lblDateOfDeath.Visible = false;
                            }
                        }
                        else
                        {
                            lblDateOfDeath.Visible = false;
                            //LabelForDateOfDeath.Visible = false;
                        }
                    }
                    catch (Exception ex1)
                    {
                        Exception _mssrlogerror = HandleMSSRException(ex1, "MSAssessmentTool.aspx", "100027", "DateOfDeath");
                    }
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        #region Set Corticosteroid Ctrl Vars

        ctrlCorticosteroidsSelection.CORT = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORT");
        ctrlCorticosteroidsSelection.CORTCU = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCU");
        ctrlCorticosteroidsSelection.CORTCUIVDexPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexPharm");
        ctrlCorticosteroidsSelection.CORTCUIVDexSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexSchedule");
        ctrlCorticosteroidsSelection.CORTCUIVDexScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUIVDexApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVDexApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUIVMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethPharm");
        ctrlCorticosteroidsSelection.CORTCUIVMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethSchedule");
        ctrlCorticosteroidsSelection.CORTCUIVMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUIVMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUIVMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUOralMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethPharm");
        ctrlCorticosteroidsSelection.CORTCUOralMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethSchedule");
        ctrlCorticosteroidsSelection.CORTCUOralMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUOralMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTCUOralPredPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredPharm");
        ctrlCorticosteroidsSelection.CORTCUOralPredSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredSchedule");
        ctrlCorticosteroidsSelection.CORTCUOralPredScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredScheduleOther");
        ctrlCorticosteroidsSelection.CORTCUOralPredApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTCUOralPredApproxStarted");

        //Past
        ctrlCorticosteroidsSelection.CORTPU = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPU");
        ctrlCorticosteroidsSelection.CORTPUIVDexPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexPharm");
        ctrlCorticosteroidsSelection.CORTPUIVDexSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexSchedule");
        ctrlCorticosteroidsSelection.CORTPUIVDexScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUIVDexApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUIVMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethPharm");
        ctrlCorticosteroidsSelection.CORTPUIVMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethSchedule");
        ctrlCorticosteroidsSelection.CORTPUIVMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUIVMethApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUOralMethPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethPharm");
        ctrlCorticosteroidsSelection.CORTPUOralMethSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethSchedule");
        ctrlCorticosteroidsSelection.CORTPUOralMethScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUOralMethApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethApproxStopped");
        ctrlCorticosteroidsSelection.CORTPUOralPredPharm = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredPharm");
        ctrlCorticosteroidsSelection.CORTPUOralPredSchedule = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredSchedule");
        ctrlCorticosteroidsSelection.CORTPUOralPredScheduleOther = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredScheduleOther");
        ctrlCorticosteroidsSelection.CORTPUOralPredApproxStopped = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredApproxStopped");

        ctrlCorticosteroidsSelection.CORTPUIVDexApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVDexApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUIVMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUIVMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUOralMethApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralMethApproxStarted");
        ctrlCorticosteroidsSelection.CORTPUOralPredApproxStarted = QuestionList.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CORTPUOralPredApproxStarted");



        #endregion

        if (!IsPostBack)
        {
            // populate and bind medication lists and initial symptoms.
            populateQuestionControls();
            ctrlCorticosteroidsSelection.InitializeData();
            string _snum = "";
            if (_mssrInstrumentManager.MssrServiceTo != null)
            {
                _snum = _mssrInstrumentManager.MssrServiceTo.PatientSoN;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN))
                {
                    ViewState["PatientICN"] = patICN;
                    errorString = RefreshSurvey(patICN);
                }
                else
                {
                    //Logging.WriteLogToFile("Could not find ICN for SSN: " + _ssn);
                    //throw new ArgumentException("Patient with this SSN does not exist.");

                    Response.Redirect("Warning.aspx?err=12");
                }

                string referrer = "";
                if (Request.UrlReferrer != null)
                {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;

                if (errorString.Length > 0)
                {
                    DisplayNotificationMessage(true, "Error loading page", errorString);
                }
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_mssrInstrumentManager.MssrServiceTo == null)
            {
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }
            else
            {
                lblPatientName.Text = _mssrInstrumentManager.MssrServiceTo.PatientName;
                lblLast4.Text = _mssrInstrumentManager.MssrServiceTo.PatientSoN.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_mssrInstrumentManager.MssrServiceTo.PatientSoN)) : _mssrInstrumentManager.MssrServiceTo.PatientSoN;
                if (lblLast4.Text.Length > 4)
                {
                    lblLast4.Text = lblLast4.Text.Substring(lblLast4.Text.Length - 4);
                }
                //LabelFacility.Text = _tbiInstrumentManager.TbiServiceTo.InstitutionName;
            }
        }

        #region Set Labels and Questions

        dpDate1.MaxDate = DateTime.Now;
        LabelForDateOfDeathDem.Text = GetQuestionText("DOD");
        LabelForCOD.Text = GetQuestionText("COD");

        LabelForQAT.Text = GetQuestionText("AT");
        LabelForQIC.Text = GetQuestionText("IC");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        //LabelForQ4a.Text = GetQuestionText("4a");

        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");

        LabelForQ7.Text = GetQuestionText("7");
        mysQ7MSDateFirst.Label = GetQuestionText("7MSDateFirst");

        mysQ7MSDateDx.Label = GetQuestionText("7MSDateDx");
        mysQ7CISDateFirst.Label = GetQuestionText("7CISDateFirst");
        mysQ7RISDateFirst.Label = GetQuestionText("7RISDateFirst");
        mysQ7NMODateFirst.Label = GetQuestionText("7NMODateFirst");
        mysQ7NMODx.Label = GetQuestionText("7NMODx");
        LabelForQ7NOMS.Text = GetQuestionText("7NOMSComment");

        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        mysQ9DateTran.Label = GetQuestionText("9DateTran");
        mysQ12A.Label = GetQuestionText("DATEOFLASTREALPSE");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ11_6A.Text = GetQuestionText("11_6A");
        LabelForQ11_8.Text = GetQuestionText("11_8");

        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");

        LabelForQIG.Text = GetQuestionText("IG");

        LabelForQSJC.Text = GetQuestionText("SJC");
        mysQSJCPositive.Label = GetQuestionText("SJCP");
        mysQSJCNegative.Label = GetQuestionText("SJCN");

        QuestionList = GetAllQuestionsForSurvey(); // Get all Questions

        #region setVisibilityClientSide Objects

        // Q1
        if (rblQ1.SelectedItem != null &&
            (rblQ1.SelectedItem.Text.ToLower().Equals("other")))
        {
            pnlQ1OtherDescription.Style["display"] = "block";
        }
        else
        {
            pnlQ1OtherDescription.Style["display"] = "none";
        }

        // Q4
        if (rblQ4.SelectedItem == null)
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ4.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ4Unknown.Style["display"] = "block";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ4.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "block";

            if (rblQ4a.SelectedIndex > -1 && rblQ4a.SelectedItem.Text.ToLower().Equals("other"))
            {
                pnlQ4aOtherDescription.Style["display"] = "block";
            }
            else
            {
                //pnlQ4aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ4Unknown.Style["display"] = "none";
            pnlQ4a.Style["display"] = "none";
            pnlQ4aOtherDescription.Style["display"] = "none";
        }

        // Q5
        if (rblQ5.SelectedItem == null)
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ5.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ5Unknown.Style["display"] = "block";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ5.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "block";

            if (rblQ5a.SelectedIndex > -1 && rblQ5a.SelectedItem.Text.ToLower().Equals("other"))
            {
                pnlQ5aOtherDescription.Style["display"] = "block";
            }
            else
            {
                //pnlQ5aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ5Unknown.Style["display"] = "none";
            pnlQ5a.Style["display"] = "none";
            pnlQ5aOtherDescription.Style["display"] = "none";
        }

        // Q6
        if (rblQ6.SelectedItem == null)
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ6.SelectedItem.Text.ToLower().Contains("unknown"))
        {
            pnlQ6Unknown.Style["display"] = "block";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }
        else if (rblQ6.SelectedItem.Text.ToLower().Contains("yes"))
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "block";

            if (rblQ6a.SelectedIndex > -1 && rblQ6a.SelectedItem.Text.ToLower().Equals("other"))
            {
                pnlQ6aOtherDescription.Style["display"] = "block";
            }
            else
            {
                //pnlQ6aOtherDescription.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ6Unknown.Style["display"] = "none";
            pnlQ6a.Style["display"] = "none";
            pnlQ6aOtherDescription.Style["display"] = "none";
        }

        // Q7
        if (rblQ7.SelectedItem != null)
        {
            if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "block";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
            {
                pnlQ7MS.Style["display"] = "block";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "block";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "block";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "none";
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains("radiologically isolated syndrome"))
            {
                pnlQ7MS.Style["display"] = "none";
                pnlQ7CIS.Style["display"] = "none";
                pnlQ7NMO.Style["display"] = "none";
                pnlQ7NOMS.Style["display"] = "none";
                pnlQ7RIS.Style["display"] = "block";
            }
        }
        else
        {
            pnlQ7MS.Style["display"] = "none";
            pnlQ7CIS.Style["display"] = "none";
            pnlQ7NMO.Style["display"] = "none";
            pnlQ7NOMS.Style["display"] = "none";
        }

        // Q9
        if (rblQ9.SelectedItem != null)
        {
            if (rblQ9.SelectedItem.Text.ToLower().Contains("secondary progressive"))
            {
                pnlQ9DateTran.Style["display"] = "block";
            }
            else
            {
                pnlQ9DateTran.Style["display"] = "none";
            }
        }
        else
        {
            pnlQ9DateTran.Style["display"] = "none";
        }

        // Q11
        pnlQ11_6A.Style["display"] = "none";
        pnlQ11_8.Style["display"] = "none";

        if (rblQ11.SelectedItem != null &&
            (rblQ11.SelectedItem.Text.ToLower().Contains("6a =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("6b =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("7 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
             rblQ11.SelectedItem.Text.ToLower().Contains("10 =")))
        {
            pnlQ11_6A.Style["display"] = "block";

            if (rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                   rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                   rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
            {
                pnlQ11_8.Style["display"] = "block";
            }
        }

        // QID
        if (rblQIG.SelectedItem != null && rblQIG.SelectedItem.Text.ToLower().Contains("positive"))
        {
            pnlQIDPositive.Style["display"] = "block";
            pnlQIDNegative.Style["display"] = "none";

        }
        else if (rblQIG.SelectedItem != null && rblQIG.SelectedItem.Text.ToLower().Contains("negative"))
        {
            pnlQIDPositive.Style["display"] = "none";
            pnlQIDNegative.Style["display"] = "block";
        }
        else
        {
            pnlQIDPositive.Style["display"] = "none";
            pnlQIDNegative.Style["display"] = "none";
        }

        //SJC
        if (rblQSJC.SelectedItem != null && rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
        {
            pnlQSJCPositive.Style["display"] = "block";
            pnlQSJCNegative.Style["display"] = "none";

        }
        else if (rblQSJC.SelectedItem != null && rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
        {
            pnlQSJCPositive.Style["display"] = "none";
            pnlQSJCNegative.Style["display"] = "block";
        }
        else
        {
            pnlQSJCPositive.Style["display"] = "none";
            pnlQSJCNegative.Style["display"] = "none";
        }

        #endregion

        #endregion
    }

    private string formatDate(string dateString)
    {
        string d = "";
        int iYear;
        int iMonth;
        int iDay;

        string oYear = dateString.Substring(0, 4);
        string oMonth = dateString.Substring(4, 2);
        string oDay = dateString.Substring(6, 2);
        string year = "";
        string month = "";
        string day = "";

        try
        {
            if (int.TryParse(oYear, out iYear))
            {
                if (iYear > 1900 && iYear < DateTime.Now.Year)
                {
                    year = oYear;

                    if (int.TryParse(oMonth, out iMonth))
                    {
                        switch (iMonth)
                        {
                            case 1:
                                month = "Jan. ";
                                break;
                            case 2:
                                month = "Feb. ";
                                break;
                            case 3:
                                month = "Mar. ";
                                break;
                            case 4:
                                month = "Apr. ";
                                break;
                            case 5:
                                month = "May. ";
                                break;
                            case 6:
                                month = "Jun. ";
                                break;
                            case 7:
                                month = "Jul. ";
                                break;
                            case 8:
                                month = "Aug. ";
                                break;
                            case 9:
                                month = "Sep. ";
                                break;
                            case 10:
                                month = "Oct. ";
                                break;
                            case 11:
                                month = "Nov. ";
                                break;
                            case 12:
                                month = "Dec. ";
                                break;
                            default:
                                break;
                        }
                    }

                    if (month.Length > 0)
                    {
                        if (int.TryParse(day, out iDay))
                        {
                            if (iDay > 0 && iDay <= 31)
                            {
                                d = month + iDay + ", " + year;
                            }
                        }
                        else
                        {
                            d = month + year;
                        }
                    }
                    else
                    {
                        d = year;
                    }
                }
            }
        }
        catch (Exception ex1)
        {
            Exception _mssrlogerror = HandleMSSRException(ex1, "MSAssessmentTool.aspx", "", "formatDate Conversion");
        }

        return d;
    }

    private void setLogTimeSetting()
    {
        var setting = Helpers.GetDBConfigEntry("MSSRLogTime");

        if (setting != null && setting.ToString() == "true")
        {
            Session["LogTime"] = Helpers.SerializSessionItemsObj("true");
        }
        else
        {
            Session["LogTime"] = Helpers.SerializSessionItemsObj("false");
        }
    }

    private void setMonthYearSelectorValues()
    {
        mysQ7MSDateFirst.populateDateTimeLists();
        mysQ7MSDateFirst.setRequired(true);
        mysQ7MSDateDx.populateDateTimeLists();
        mysQ7CISDateFirst.populateDateTimeLists();
        mysQ7RISDateFirst.populateDateTimeLists();
        mysQ7CISDateFirst.setRequired(true);
        mysQ7NMODateFirst.populateDateTimeLists();
        mysQ7NMODateFirst.setRequired(true);
        mysQ7NMODx.populateDateTimeLists();
        mysQ9DateTran.populateDateTimeLists();
        mysQ9DateTran.setRequired(true);
        mysQ12A.populateDateTimeLists();
        mysQ11_6A.populateDateTimeLists();
        mysQ11_8.populateDateTimeLists();
        mysQIDPositive.populateDateTimeLists();
        mysQIDNegative.populateDateTimeLists();

        mysQIDPositive.Label = "Positive Date:";
        mysQIDNegative.Label = "Negative Date:";
        mysQSJCPositive.populateDateTimeLists();
        mysQSJCNegative.populateDateTimeLists();

    }

    protected void ScriptManager1_Navigate(object sender, HistoryEventArgs e)
    {
        string test = "";
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);

        // TODO: if survey is null or new ... perform check to see if user has completed survey to pull data from.
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// call to populate medication lists.
    /// </summary>
    protected void populateQuestionControls()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {

            ddlCauseOfDeathType.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("COD", HiddenSurveyType.Value);
            ddlCauseOfDeathType.DataBind();

            rblAssessmentType.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("AT", HiddenSurveyType.Value);
            rblAssessmentType.DataBind();

            rblQIC.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("IC", HiddenSurveyType.Value);
            rblQIC.DataBind();

            rblQ1.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("1", HiddenSurveyType.Value);
            rblQ1.DataBind();

            rblQ2.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("2", HiddenSurveyType.Value);
            rblQ2.DataBind();

            rblQ3.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("3", HiddenSurveyType.Value);
            rblQ3.DataBind();

            rblQ4.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("4", HiddenSurveyType.Value);
            rblQ4.DataBind();

            rblQ4a.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("4a", HiddenSurveyType.Value);
            rblQ4a.DataBind();

            rblQ5.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("5", HiddenSurveyType.Value);
            rblQ5.DataBind();

            rblQ5a.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("5a", HiddenSurveyType.Value);
            rblQ5a.DataBind();

            rblQ6.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("6", HiddenSurveyType.Value);
            rblQ6.DataBind();

            rblQ6a.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("6a", HiddenSurveyType.Value);
            rblQ6a.DataBind();

            rblQ7.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("7", HiddenSurveyType.Value);
            rblQ7.DataBind();

            cblQ8.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("8", HiddenSurveyType.Value);
            cblQ8.DataBind();

            rblQ9.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("9", HiddenSurveyType.Value);
            rblQ9.DataBind();

            rblQ10.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("10", HiddenSurveyType.Value);
            rblQ10.DataBind();

            rblQ11.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("11", HiddenSurveyType.Value);
            rblQ11.DataBind();

            rblQIG.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("IG", HiddenSurveyType.Value);
            rblQIG.DataBind();

            rblQSJC.DataSource = _mssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("SJC", HiddenSurveyType.Value);
            rblQSJC.DataBind();

            rptMedication.DataSource = ctx.MSSR_MEDICATIONs.Where(M => M.IS_INTERFERON_GROUP == false && M.IS_OTHER_GROUP == false).OrderBy(M => M.MEDICATION);
            rptMedication.DataBind();

            rptInterferonGroupMedication.DataSource = ctx.MSSR_MEDICATIONs.Where(M => M.IS_INTERFERON_GROUP == true).OrderBy(M => M.MEDICATION);
            rptInterferonGroupMedication.DataBind();

            rptOtherMedication.DataSource = ctx.MSSR_MEDICATIONs.Where(M => M.IS_OTHER_GROUP == true);
            rptOtherMedication.DataBind();
        }
    }

    protected void btnUpdateNotePreview_Click(object sender, EventArgs e)
    {
        string errorString = processAssessment();

        if (errorString.Length > 0)
        {
            DisplayNotificationMessage(true, "Warning: ", errorString);
        }
        else
        {
            DisplayNotificationMessage(true, "Notification", "The Notes were successfully updated");
        }
    }

    /// <summary>
    /// Update Health Factors clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpdateHealthFactors_Click(object sender, EventArgs e)
    {
        string errorString = processAssessment();

        if (errorString.Length > 0)
        {
            DisplayNotificationMessage(true, "Warning: ", errorString);
        }
        else
        {
            DisplayNotificationMessage(true, "Notification", "The Health Factors were successfully saved");
        }
    }

    /// <summary>
    /// Ensure VA value for Gender is loaded.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblQ3_DataBound(object sender, EventArgs e)
    {
        //SetUpSurvey(_survey);
        if (_mssrInstrumentManager.MssrServiceTo != null)
        {
            if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientGender))
            {
                foreach (ListItem li in rblQ3.Items)
                {
                    if (li.Text.ToLower().StartsWith(_mssrInstrumentManager.MssrServiceTo.PatientGender.ToLower()))
                    {
                        li.Selected = true;
                        break;
                    }
                }
            }
        }
        else {            
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
        }
        
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        DateTime dtStart = DateTime.Now;
        bool writeTimeToLog = false;
        bool isSurveyDraft = true;
        if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
        {
            Logging.WriteLogToFile("btnSaveSurveyDraft_Click: Starting");
            writeTimeToLog = true;
        }

        string errorMessage = "";

        // TODO: do a check to ensure mssrInstrumentManager ... and MssrServiceTo are not null (something happened to the session/service, etc).
        if (_mssrInstrumentManager.MssrServiceTo == null)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Response.Redirect("Warning.aspx?err=2");
        }

        errorMessage = SaveCompleteSurvey(writeTimeToLog, isSurveyDraft);

        if (errorMessage.Length > 0)
        {
            DisplayNotificationMessage(true, "Error Saving Survey", errorMessage);
        }
        else
        {
            DisplayNotificationMessage(true, "Notification", "The assessment was successfully saved");
        }


        DateTime dtEnd = DateTime.Now;
        if (writeTimeToLog)
        {
            string sTotalTime = dtEnd.Subtract(dtStart).TotalSeconds.ToString();
            Logging.WriteLogToFile("btnSaveSurveyDraft_Click: Completed in " + sTotalTime);
        }
        //RefreshSurvey(_mssrInstrumentManager.MssrServiceTo.PatientICN);
        //SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        string errorMessage = "";

        DateTime dtStart = DateTime.Now;
        bool writeTimeToLog = false;
        bool isSurveyDraft = false;

        if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
        {
            Logging.WriteLogToFile("btnSubmit_Click: Starting");
            writeTimeToLog = true;
        }

        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";

        if (_mssrInstrumentManager.MssrServiceTo == null)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Response.Redirect("Warning.aspx?err=2");
        }

        errorMessage = SaveCompleteSurvey(writeTimeToLog, isSurveyDraft);

        if (writeTimeToLog)
            Logging.WriteLogToFile("btnSubmit_Click: After SaveCompletedSurvey, before redirect");

        if (errorMessage.Length == 0)
        {
            //writeMsatNote();

            if (CurrentStatus.LastAssessDate == null)
            {
                CurrentStatus.LastAssessDate = (DateTime)dpDate1.SelectedDate;
            }

            if (CurrentAssessmentHF.AssessmentDateTime == null)
            {
                CurrentAssessmentHF.AssessmentDateTime = (DateTime)dpDate1.SelectedDate;
            }

            Session["NoteText"] = Helpers.SerializSessionItemsObj(txtNotePreview.Text);
            Session["survey"] = Helpers.SerializeSurvey(_survey);//.Serialize();
            Response.Redirect("MSAssessmentNoteSummary.aspx", false);
        }
        else
        {
            DisplayNotificationMessage(true, "Error Submitting Assessment", errorMessage);

            if (writeTimeToLog)
                Logging.WriteLogToFile("btnSubmit_Click: After failure in SaveCompletedSurvey");

            //RefreshSurvey(_mssrInstrumentManager.MssrServiceTo.PatientICN);
            //SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        string errorMessage = "";
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        bool writeTimeToLog = false;
        bool isSurveyDraft = true;
        if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
        {
            Logging.WriteLogToFile("SaveSurvey: Starting");
            writeTimeToLog = true;
        }

        Page.Validate("OnSaveDraft");

        if (Page.IsValid)
        {
            errorMessage = SaveCompleteSurvey(writeTimeToLog, isSurveyDraft);

            if (errorMessage.Length > 0)
                Logging.WriteLogToFile("MSAssessmentTool - InActiveTimer_Tick - SaveCompletedSurvey() failed: " + errorMessage);

            Response.Redirect("MSAssessmentTool.aspx", false);
        }
        else
        {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");

        string script = "<script language=\"javascript\"  type=\"text/javascript\">window.open('','_self','');window.close();</script>";
        ScriptManager.RegisterStartupScript(Page, this.GetType(), "closePage", script, false);
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Bound list of Non-Interferon Group Medications
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rptMedication_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        controls_MedicationSelection ctrl = ((controls_MedicationSelection)e.Item.FindControl("MedicationSelection1"));
        var ditem = e.Item.DataItem as MSSR_MEDICATION;
        if (ctrl != null)
        {
            if (e.Item.DataItem is MSSR_MEDICATION)
            {
                if (ditem != null)
                {
                    ctrl.MedicationId = ditem.ID;
                    ctrl.MedicationName = ditem.MEDICATION;
                    ctrl.HealthFactorName = ditem.HEALTH_FACTOR;
                }
            }
            if (ditem != null)
            {
                if (ditem.ShowNumDosesTaken)
                {
                    ctrl.enableNumberOfDoses(true);
                }
            }
        }              
    }

    /// <summary>
    /// Bound list of Interferon Group Medications
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rptInterferonGroupMedication_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        controls_MedicationSelection ctrl = ((controls_MedicationSelection)e.Item.FindControl("MedicationSelection1"));
        var ditem = e.Item.DataItem as MSSR_MEDICATION;
        if (ctrl != null)
        {
            if (e.Item.DataItem is MSSR_MEDICATION)
            {
                if (ditem != null)
                {
                    ctrl.MedicationId = ditem.ID;
                    ctrl.MedicationName = ditem.MEDICATION;
                    ctrl.HealthFactorName = ditem.HEALTH_FACTOR;
                }                

                if (ctrl.MedicationName.Contains("Mitoxantrone"))
                {
                    ctrl.enableCardiotoxPanel(true, GetQuestionText("CardioTox"), GetQuestionText("CardioToxYes"),
                                              GetQuestionText("CardioToxDateUnknown"));

                    mitoxantroneControl = ctrl;
                    mitoxantroneControl.hideCardioToxPanel();

                    Session["mitoxantroneUniqueID"] = Helpers.SerializSessionItemsObj(ctrl.UniqueID.ToString());  // So we can get the handle later if needed
                }
                else if (ctrl.MedicationName.Contains("Natalizumab"))
                {
                    /*
                    ctrl.enableSerumPanel(true, GetQuestionText("SJC"), GetQuestionText("SJCP"),
                                                              GetQuestionText("SJCN"));
                    natalizumabControl = ctrl;
                    Session["natalizumabUniqueID"] = ctrl.UniqueID.ToString();  // So we can get the handle later if needed
                     */
                }
                if (ditem != null)
                {
                    if (ditem.ShowNumDosesTaken)
                    {
                        ctrl.enableNumberOfDoses(true);
                    }
                }
                
            }
        }
    }


    protected void rptOtherMedication_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        controls_MedicationSelection ctrl = ((controls_MedicationSelection)e.Item.FindControl("MedicationSelection1"));
        var ditem = e.Item.DataItem as MSSR_MEDICATION;
        if (ctrl != null)
        {
            if (e.Item.DataItem is MSSR_MEDICATION)
            {
                if (ditem != null)
                {
                    ctrl.MedicationId = ditem.ID;
                    ctrl.MedicationName = ditem.MEDICATION;
                    ctrl.HealthFactorName = ditem.HEALTH_FACTOR;
                }

                if (ditem != null)
                {
                    if (ditem.ShowNumDosesTaken)
                    {
                        ctrl.enableNumberOfDoses(true);
                    }
                }                
            }            
        }
        
    }
    #endregion

    #region Private Methods

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _mssrInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private string RefreshSurvey(string patientICN)
    {
        string errorMessage = "";
        Session["IsFirstTimeSurvey"] = null;

        //TODO - something is not right with how this is called with new data ... 
        _survey = _mssrInstrumentManager.SelectInProcessByPatientICNAndSurveyType(patientICN, _surveyTypeId).FirstOrDefault();

        if (_survey != null)
        {
            if (_survey.SURVEY_RESULTs == null || _survey.SURVEY_RESULTs.Count == 0)
            {
                errorMessage = "There was a problem saving the Assessment results. Attempting to load Assessment from the previous version.";
                errorMessage += "\r\nPlease check the Assessment values and save them again";

                HandleMSSRException(new Exception("Survey saved without results"), "MSAssessmentTool.aspx", "100027", "RefreshSurvey()");

                SURVEY temp = _mssrInstrumentManager.SelectLatestCompletedSurvey(patientICN, _surveyTypeId);

                // check to see if user had "past" assessment
                if (temp != null)
                {
                    // load form values from past values
                    LoadSurveyFromPastValues(temp);
                }
            }
            else
            {
                SetUpSurvey(_survey);
            }
        }
        else
        {
            SURVEY temp = _mssrInstrumentManager.SelectLatestByPatientICNAndSurveyType(patientICN, _surveyTypeId);

            // check to see if user had "past" assessment
            if (temp != null)
            {
                // load form values from past values
                LoadSurveyFromPastValues(temp);
            } //if there is no temp assesment setup medications for first time survey.
            else
            {

                Session.Add("IsFirstTimeSurvey", Helpers.SerializSessionItemsObj("Yes"));
            }

            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();

        return errorMessage;
    }

    private void DisplayNotificationMessage(bool setMessage, string sHeader, string sErrorMessage)
    {
        if (setMessage)
        {
            pnlNotification.Visible = true;
            LabelNotificationTitle.Text = sHeader;
            LabelNotificationMessage.Text = sErrorMessage;
        }
        else
        {
            pnlNotification.Visible = false;
            LabelNotificationTitle.Text = "";
            LabelNotificationMessage.Text = "";
        }
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private string SaveCompleteSurvey(bool writeTimeToLog, bool isSurveyDraft)
    {
        string errorMessage = "";

        if (writeTimeToLog)
        {
            Logging.WriteLogToFile("SaveCompleteSurvey: Starting");
            writeTimeToLog = true;
        }
        
        bool validateInitialSymptomCountNotNeeded = isSurveyDraft ? true : getTypeInitialSymptomCount() > 0;

        if (isSurveyDraft)
        {
            Page.Validate("OnSaveDraft");
        }
        else
        {
            Page.Validate();  
        }
       
        if (Page.IsValid && validateInitialSymptomCountNotNeeded)
        {
            string patientICN = String.Empty;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _mssrInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (writeTimeToLog)
                        Logging.WriteLogToFile("SaveCompleteSurvey: After _mssrInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList()");

                    if (surveys.Count > 0)
                    {
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;

                        errorMessage = _mssrInstrumentManager.Update(_survey, writeTimeToLog);

                        if (writeTimeToLog)
                            Logging.WriteLogToFile("SaveCompleteSurvey: After _mssrInstrumentManager.Update(_survey)");

                        SuppressSaveMessage = false;
                    }
                }

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }

                // Not sure if we bail if this fails or not ...
                errorMessage = SaveSurvey(ref _survey);

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }

                try
                {
                    _survey.SetAsUpdateOnSubmit();

                    if (writeTimeToLog)
                        Logging.WriteLogToFile("SaveCompleteSurvey: After _survey.SetAsUpdateOnSubmit()");
                }
                catch (Exception ex)
                {
                    Exception exc = HandleMSSRException(ex, "MSAssessmentTool", "0", "SaveCompleteSurvey()");
                    errorMessage = ex.Message;
                }

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }

                errorMessage = _mssrInstrumentManager.Update(_survey, writeTimeToLog);

                if (writeTimeToLog)
                    Logging.WriteLogToFile("SaveCompleteSurvey: After _mssrInstrumentManager.Update(_survey) 2nd");

                if (errorMessage.Length > 0)
                {
                    return errorMessage;
                }
                var master = this.Master as MSSR_Instruments_RegistryInstrument;
                if (master != null)
                {
                    master.SetDirtyFlag(false);
                }
                //(this.Master as MSSR_Instruments_RegistryInstrument).SetDirtyFlag(false);
                errorMessage = RefreshSurvey(patientICN);

                if (writeTimeToLog)
                    Logging.WriteLogToFile("SaveCompleteSurvey: After RefreshSurvey(patientICN)");

                SuppressSaveMessage = false;
            }
        }

        if (!Page.IsValid)
        {
            errorMessage = "There are validation errors on the page. Please correct the errors before saving:";

            List<IValidator> errored = this.Validators.Cast<IValidator>().Where(v => !v.IsValid).ToList();

            foreach (IValidator error in errored)
            {
                errorMessage += "\r\n" + error.ErrorMessage;
            }
        }

        // Clear error handlers:

        pnlQ1Error.Style["display"] = "none";
        lblQ1Error.Text = "";

        pnlQ4Error.Style["display"] = "none";
        lblQ4Error.Text = "";

        pnlQ5Error.Style["display"] = "none";
        lblQ5Error.Text = "";

        pnlQ6Error.Style["display"] = "none";
        lblQ6Error.Text = "";

        pnlQ7MSDateFirstError.Style["display"] = "none";
        lblQ7MSDateFirstError.Text = "";
        pnlQ7CISDateFirstError.Style["display"] = "none";
        lblQ7CISDateFirstError.Text = "";
        pnlQ7NMODateFirstError.Style["display"] = "none";
        lblQ7NMODateFirstError.Text = "";
        pnlQ7NOMSError.Style["display"] = "none";
        lblQ7NOMSError.Text = "";

        lblQ8Error.Style["display"] = "none"; //rehide and do validation
        lblQ8Error.Text = "";

        pnlQ9DateTranError.Style["display"] = "none";
        lblQ9DateTranError.Text = "";

        
        if (!isSurveyDraft)
        {
            // Question 1 error handling
            if (rblQ1.SelectedItem.Text.ToLower().Equals("other") &&
            txtQ1Other.Text.Trim().Length == 0)
            {
                pnlQ1Error.Style["display"] = "block";
                lblQ1Error.Text = "* Question 1: Other Description Field is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ1Error.Text;
            }

            // Question 4 error handling

            if (rblQ4.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ4a.SelectedIndex == -1)
                {
                    pnlQ4Error.Style["display"] = "block";
                    lblQ4Error.Text = "* Question 4: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ4Error.Text;
                }
                else if (rblQ4a.SelectedItem.Text.ToLower().Equals(("other")) &&
                         txtQ4aOther.Text.Trim().Length == 0)
                {
                    pnlQ4Error.Style["display"] = "block";
                    lblQ4Error.Text = "* Question 4: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ4Error.Text;
                }
            }

            // Question 5 error handling

            if (rblQ5.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ5a.SelectedIndex == -1)
                {
                    pnlQ5Error.Style["display"] = "block";
                    lblQ5Error.Text = "* Question 5: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ5Error.Text;
                }
                else if (rblQ5a.SelectedItem.Text.ToLower().Equals(("other")) &&
                    txtQ5aOther.Text.Trim().Length == 0)
                {
                    pnlQ5Error.Style["display"] = "block";
                    lblQ5Error.Text = "* Question 5: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ5Error.Text;
                }
            }

            // Question 6 error handling

            if (rblQ6.SelectedItem.Text.ToLower().Contains(("yes")))
            {
                if (rblQ6a.SelectedIndex == -1)
                {
                    pnlQ6Error.Style["display"] = "block";
                    lblQ6Error.Text = "* Question 6: Family member selection is required.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ6Error.Text;
                }
                else if (rblQ6a.SelectedItem.Text.ToLower().Equals(("other")) &&
                txtQ6aOther.Text.Trim().Length == 0)
                {
                    pnlQ6Error.Style["display"] = "block";
                    lblQ6Error.Text = "* Question 6: Description is required for 'Other Description' field.";

                    if (errorMessage.Length > 0)
                        errorMessage += "\r\n";

                    errorMessage += lblQ6Error.Text;
                }
            }

            // Question 7 error handling

            if (rblQ7.SelectedItem.Text.ToLower().Equals(("multiple sclerosis")) &&
                mysQ7MSDateFirst.MonthYearString == "")
            {
                pnlQ7MSDateFirstError.Style["display"] = "block";
                lblQ7MSDateFirstError.Text = "* Question 7: Date of first neurological sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7MSDateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("clinically isolated syndrome ")) &&
               mysQ7CISDateFirst.MonthYearString == "")
            {
                pnlQ7CISDateFirstError.Style["display"] = "block";
                lblQ7CISDateFirstError.Text = "* Question 7: Date of first sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7CISDateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("neuromyelitis")) &&
               mysQ7NMODateFirst.MonthYearString == "")
            {
                pnlQ7NMODateFirstError.Style["display"] = "block";
                lblQ7NMODateFirstError.Text = "* Question 7: Date of first neurological sign/symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7NMODateFirstError.Text;
            }
            else if (rblQ7.SelectedItem.Text.ToLower().Contains(("not to have")) &&
               txtQ7NOMS.Text.Trim() == "")
            {
                pnlQ7NOMSError.Style["display"] = "block";
                lblQ7NOMSError.Text = "* Question 7: Description is required for 'Comment' field.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ7NOMSError.Text;
            }

            // Question 8 error handling

            if (getTypeInitialSymptomCount() <= 0)
            {
                lblQ8Error.Style["display"] = "block";
                lblQ8Error.Text = "* Question 8: Type of initial MS/NMO symptom is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ8Error.Text;
            }
            // Question 9 error handling

            if (rblQ9.SelectedItem.Text.ToLower().Contains(("secondary progressive")) &&
                mysQ9DateTran.MonthYearString == "")
            {
                pnlQ9DateTranError.Style["display"] = "block";
                lblQ9DateTranError.Text = "* Question 9: Date Transitioned is required.";

                if (errorMessage.Length > 0)
                    errorMessage += "\r\n";

                errorMessage += lblQ9DateTranError.Text;
            }
            
        }
        // Corticosteroids
        errorMessage += ctrlCorticosteroidsSelection.ValidateData();


        return errorMessage;
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private string SaveSurvey(ref SURVEY survey)
    {
        string errorMessage = "";
        bool writeTimeToLog = false;

        if (Helpers.DeSerializSessionItems(Session["LogTime"]) != null && Helpers.DeSerializSessionItems(Session["LogTime"]) == "true")
        {
            string surveysId = "unset";

            if (survey.SURVEYS_ID != null)
                surveysId = survey.SURVEYS_ID.ToString();

            Logging.WriteLogToFile("SaveSurvey: Starting - survey id: " + surveysId);
            writeTimeToLog = true;
        }

        errorMessage = setMedicationControls();

        if (errorMessage.Length > 0)
            return errorMessage;

        int tempSurveyId = survey.SURVEYS_ID;
        List<STD_QUESTION> questions;

        if (QuestionList == null || QuestionList.Count == 0)
        {
            questions = GetAllQuestionsForSurvey();

            if (writeTimeToLog)
                Logging.WriteLogToFile("SaveSurvey: after GetAllQuestionsForSummary()");
        }
        else
        {
            questions = QuestionList;
        }

        //Delete all the survey results from database if there are any.

        SURVEY surveyWithResults = _mssrInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after _mssrInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID)");

        _mssrInstrumentManager.DeleteAllSurveyResults(surveyWithResults);

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after _mssrInstrumentManager.DeleteAllSurveyResults(surveyWithResults)");

        processAssessment(); // generate the health factors

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: after processAssessment()");

        try
        {
            // Log the selections before save for debugging purposes

            var setting = Helpers.GetDBConfigEntry("MSSRLogSelectionsBeforeSave");

            if (setting != null)
            {
                if (setting.ToString().ToLower().Contains("yes"))
                {
                    Logging.WriteLogToFile(txtNotePreview.Text);
                    Logging.WriteLogToFile(txtHealthFactors.Text);
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SaveSurvey Failed writing Note and HF to log");
        }


        #region Question DOD

        // Question DOD
        _surveyResult = new SURVEY_RESULT();

        if (dpDate2.SelectedDate != null)
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "DOD");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate2.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);

                patientDem.DateOfDeath = (DateTime)dpDate2.SelectedDate;
                Session["DateOfDeath"] = (DateTime)dpDate2.SelectedDate;

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question DOD");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question COD

        // Question COD
        _surveyResult = new SURVEY_RESULT();

        if (ddlCauseOfDeathType.SelectedValue != "")
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "COD");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ddlCauseOfDeathType.SelectedValue);
                _surveyResult.RESULT_TEXT = ((String)ddlCauseOfDeathType.SelectedItem.Text);
                survey.SURVEY_RESULTs.Add(_surveyResult);
                //save COD
                patientDem.CauseOfDeath = ((String)ddlCauseOfDeathType.SelectedItem.Text);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question COD");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question D

        // Question D
        _surveyResult = new SURVEY_RESULT();

        if (dpDate1.SelectedDate != null)
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentStatus.LastAssessDate = (DateTime)dpDate1.SelectedDate;
                CurrentAssessmentHF.AssessmentDateTime = (DateTime)dpDate1.SelectedDate;
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question D");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question AT

        // Question AT
        if (rblAssessmentType.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question AT choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblAssessmentType.SelectedValue);
                _surveyResult.RESULT_TEXT = rblAssessmentType.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (rblAssessmentType.SelectedItem.Text.ToLower().Contains("baseline"))
                {
                    CurrentStatus.BaselineAssessDate = (DateTime)dpDate1.SelectedDate;
                }

                CurrentStatus.LastAssessType = rblAssessmentType.SelectedItem.Text.ToUpper();
                CurrentAssessmentHF.AssessmentType = rblAssessmentType.SelectedItem.Text.ToUpper();
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question AT");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question IC

        // Question IC
        if (rblQIC.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IC choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQIC.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQIC.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                // 
                switch (rblQIC.SelectedItem.Text.ToLower())
                {
                    case "telephone":
                        CurrentAssessmentHF.MSInterview = "TELEPHONE";
                        break;
                    case "clinical video teleconferencing":
                        CurrentAssessmentHF.MSInterview = "VIDEO CONFERENCE";
                        break;
                    case "in-person assessment":
                        CurrentAssessmentHF.MSInterview = "FACE TO FACE";
                        break;
                    default:
                        break;
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IC");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 1 - Race

        // Question 1 - Race
        if (rblQ1.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                // is selection "Other", if yes, populate RESULT_TEXT with text from other field - else like below

                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ1.SelectedValue);

                if (rblQ1.SelectedItem.Text.ToLower() == "other")
                {
                    _surveyResult.RESULT_TEXT = txtQ1Other.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ1.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 1");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 2 - Ethnicity

        // Question 2 - Ethnicity
        if (rblQ2.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.Ethnicity = rblQ2.SelectedItem.Text.ToUpper();

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 2");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Get Patient Dem reference

        try
        {
            MSSRE_PATIENT_DEM patDem;

            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                patDem = ctx.MSSRE_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientICN));

                string race = (rblQ1.SelectedItem != null) ? rblQ1.SelectedItem.Text : "";
                string ethnic = (rblQ2.SelectedItem != null) ? rblQ2.SelectedItem.Text : "";

                if (patDem != null)
                {
                    patDem.Race = (rblQ1.SelectedItem != null) ? rblQ1.SelectedItem.Text.ToUpper() : "";

                    switch (race.ToLower())
                    {
                        case "asian":
                            patDem.Race = "ASIAN/PI";
                            break;
                        case "native hawaiian or other pacific islander":
                            patDem.Race = "ASIAN/PI";
                            break;
                        case "black or african american":
                            patDem.Race = "BLACK";
                            break;
                        case "american indian or alaskan native":
                            patDem.Race = "INDIAN";
                            break;
                        case "other":
                            patDem.Race = "OTHER";
                            break;
                        case "white":
                            patDem.Race = "WHITE";
                            break;
                        default:
                            break;
                    }

                    switch (ethnic.ToLower())
                    {
                        case "not hispanic":
                            patDem.Ethnicity = "NH";
                            break;
                        case "hispanic":
                            patDem.Ethnicity = "H";
                            break;
                        default:
                            patDem.Ethnicity = "";
                            break;
                    }

                    ctx.SubmitChanges();
                }
            }
        }
        catch (Exception ex)
        {
            Exception _mssrlogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "Update Patient Dem reference");
            errorMessage += ex.Message.ToString() + "\r\n";
        }

        #endregion

        #region Question 3 - Gender

        // Question 3 - Gender
        if (rblQ3.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 3");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 4 - Biological familiy history of Multiple Sclerosis?

        // Question 4 - Biological familiy history of Multiple Sclerosis?
        if (rblQ4.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);

                // if selection = unknown = store txtQ4UnknownComment.Text in RESULT_TEXT, else store rblQ4.SelectedItem.Text
                if (rblQ4.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ4UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 4");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 4a - Question 4 Details

        // Question 4a - Question 4 Details
        //if (rblQ4a.SelectedIndex > -1)
        //{
        //    _surveyResult = new SURVEY_RESULT();

        //    try
        //    {
        //        // Add Question 4a choice
        //        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4a.SelectedValue);

        //        // if selection = Other = store txtQ4aOther.Text in RESULT_TEXT, else store rblQ4a.SelectedItem.Text
        //        if (rblQ4a.SelectedItem.Text.ToLower() == "other")
        //        {
        //            _surveyResult.RESULT_TEXT = txtQ4aOther.Text;
        //        }
        //        else
        //        {
        //            _surveyResult.RESULT_TEXT = rblQ4a.SelectedItem.Text;
        //        }

        //        survey.SURVEY_RESULTs.Add(_surveyResult);
        //    }
        //    catch (Exception surveyEx)
        //    {
        //        Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 4a");
        //        errorMessage += surveyEx.Message.ToString() + "\r\n";
        //    }
        //}
        if (getBioFamHisMsCount(rblQ4a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            STD_QUESTION question4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "4a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";

                foreach (ListItem li in rblQ4a.Items)
                {
                    if (li.Selected)
                    {

                        choiceStr += li.Text + ",";

                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                        //or iterate and add items here...
                        /*
                         
                        _surveyResult.STD_QUESTION_CHOICE_ID = Int32.Parse(li.Value);
                        _surveyResult.RESULT_TEXT = choiceStr;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                         
                         */
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                // Add Question 4a choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question4.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = choiceStr;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (otherSelected)
                {
                    STD_QUESTION question4aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "4aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    _surveyResult.STD_QUESTION_CHOICE_ID = question4aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = txtQ4aOther.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);

                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question4a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion


        #region Question 5 - Biological family history of Clinically Isolated Syndrome?

        // Question 5 - Biological family history of Clinically Isolated Syndrome?
        if (rblQ5.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);

                // if selection = unknown = store txtQ5UnknownComment.Text in RESULT_TEXT, else store rblQ5.SelectedItem.Text
                if (rblQ5.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ5UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 5");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 5a - Question 5 Details
 
        if (getBioFamHisMsCount(rblQ5a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            STD_QUESTION question5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "5a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";
                foreach (ListItem li in rblQ5a.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                if (question5 != null)
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = question5.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = choiceStr;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                if (otherSelected)
                {
                    STD_QUESTION question5aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "5aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    if (question5aOther != null)
                    {
                        _surveyResult.STD_QUESTION_CHOICE_ID = question5aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        _surveyResult.RESULT_TEXT = txtQ5aOther.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question5a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 6 - Biological family history of Neuromyelitis Optica/Devic's Disease?

        // Question 6 - Biological family history of Neuromyelitis Optica/Devic's Disease?
        if (rblQ6.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 6 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);

                // if selection = unknown = store txtQ6UnknownComment.Text in RESULT_TEXT, else store rblQ6.SelectedItem.Text
                if (rblQ6.SelectedItem.Text.ToLower() == "unknown")
                {
                    _surveyResult.RESULT_TEXT = txtQ6UnknownComment.Text;
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
                }

                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 6");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 6a - Question 6 Details

        // Question 6a - Question 6 Details
        //if (rblQ6a.SelectedIndex > -1)
        //{
        //    _surveyResult = new SURVEY_RESULT();

        //    try
        //    {
        //        // Add Question 6a choice
        //        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6a.SelectedValue);

        //        // if selection = Other = store txtQ6aOther.Text in RESULT_TEXT, else store rblQ6a.SelectedItem.Text
        //        if (rblQ6a.SelectedItem.Text.ToLower() == "other")
        //        {
        //            _surveyResult.RESULT_TEXT = txtQ6aOther.Text;
        //        }
        //        else
        //        {
        //            _surveyResult.RESULT_TEXT = rblQ6a.SelectedItem.Text;
        //        }

        //        survey.SURVEY_RESULTs.Add(_surveyResult);
        //    }
        //    catch (Exception surveyEx)
        //    {
        //        Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 6a");
        //        errorMessage += surveyEx.Message.ToString() + "\r\n";
        //    }
        //}
        if (getBioFamHisMsCount(rblQ6a) > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            STD_QUESTION question6 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "6a");
            bool otherSelected = false;
            try
            {
                string choiceStr = "";
                foreach (ListItem li in rblQ6a.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                        if (li.Text.ToLower() == "other")
                        {
                            otherSelected = true;
                        }
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                if (question6 != null)
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = question6.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = choiceStr;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                if (otherSelected)
                {
                    STD_QUESTION question6aOther = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "6aBioFamHisMsOtherComment");
                    _surveyResult = new SURVEY_RESULT();
                    if (question6aOther != null)
                    {
                        _surveyResult.STD_QUESTION_CHOICE_ID = question6aOther.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        _surveyResult.RESULT_TEXT = txtQ6aOther.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - question6a");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7 - Diagnosis History

        // Question 7 - Diagnosis History
        if (rblQ7.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ7.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (rblQ7.SelectedItem != null)
                {
                    if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
                    {
                        CurrentStatus.MSDiagnosis = "POSSIBLE";
                        CurrentAssessmentHF.MSDiagnosis = "POSSIBLE";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
                    {
                        CurrentStatus.MSDiagnosis = "NOT MS";
                        CurrentAssessmentHF.MSDiagnosis = "NOT MS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
                    {
                        CurrentStatus.MSDiagnosis = "MS";
                        CurrentAssessmentHF.MSDiagnosis = "MS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
                    {
                        CurrentStatus.MSDiagnosis = "CIS";
                        CurrentAssessmentHF.MSDiagnosis = "CIS";
                    }
                    else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
                    {
                        CurrentStatus.MSDiagnosis = "NMO";
                        CurrentAssessmentHF.MSDiagnosis = "NMO";
                    }
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7MSDateFirst - Date of first neurological sign/symptom (if known)

        // Question 7MSDateFirst - Date of first neurological sign/symptom (if known)
        if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
        {
            STD_QUESTION question7MSDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7MSDateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7MSDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7MSDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7MSDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.SymptomYear = mysQ7MSDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7MSDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                    CurrentStatus.LastDiagnosisYear = symptomYear; //mysQ7MSDateFirst.YearString;//Relase-2
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7MSDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7MSDateDx - Date of MS diagnosis

        // Question 7MSDateDx - Date of MS diagnosis
        if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
        {
            STD_QUESTION question7MSDateDx = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7MSDateDx");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7MSDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7MSDateDx.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7MSDateDx.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.DiagnosisYear = mysQ7MSDateDx.MonthYearString;

                int diagnosisYear;
                Int32.TryParse(mysQ7MSDateDx.YearString, out diagnosisYear);
                if (diagnosisYear > 0)
	            {
                    CurrentStatus.LastDiagnosisYear = diagnosisYear;
	            }               

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7MSDateDx");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7CISDateFirst - Date of first sign/symptom

        // Question 7CISDateFirst - Date of first sign/symptom
        if (!String.IsNullOrEmpty(mysQ7CISDateFirst.MonthYearString))
        {
            STD_QUESTION question7CISDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7CISDateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7CISDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7CISDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7CISDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.SymptomYear = mysQ7CISDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7CISDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7CISDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7RISDateFirst - Date of first sign/symptom
        //Question 7RISDateFirst - Date of first sign/symptom
        if (!String.IsNullOrEmpty(mysQ7RISDateFirst.MonthYearString))
        {
            STD_QUESTION question7RISDateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7RISDateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                
                // Add Question 7RISDateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7RISDateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7RISDateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.RISDiagnosisYear = mysQ7RISDateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7RISDateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.RISDiagnosisYear = symptomYear;
                }
                 
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7RISDateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion
        #region Question 7NMODateFirst - Date of first neurological sign/symptom (if known)

        // Question 7NMODateFirst - Date of first neurological sign/symptom (if known)
        if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
        {
            STD_QUESTION question7NMODateFirst = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NMODateFirst");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NMODateFirst choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NMODateFirst.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7NMODateFirst.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.SymptomYear = mysQ7NMODateFirst.MonthYearString;

                int symptomYear;
                Int32.TryParse(mysQ7NMODateFirst.YearString, out symptomYear);

                if (symptomYear > 0)
                {
                    CurrentStatus.LastSymptomYear = symptomYear;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NMODateFirst");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7NMODx - Date of NMO diagnosis

        // Question 7NMODx - Date of NMO diagnosis
        if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
        {
            STD_QUESTION question7NMODx = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NMODx");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NMODx choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NMODx.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ7NMODx.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentAssessmentHF.DiagnosisYear = mysQ7NMODx.MonthYearString;

                int diagnosisYear;
                Int32.TryParse(mysQ7NMODx.YearString, out diagnosisYear);
                if (diagnosisYear > 0)
	            {
                    CurrentStatus.LastDiagnosisYear = diagnosisYear;
	            }                
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NMODx");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 7NOMSComment - Comment

        // Question 7NOMSComment - Comment
        if (!String.IsNullOrEmpty(txtQ7NOMS.Text))
        {
            STD_QUESTION question7NOMSComment = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7NOMSComment");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 7NOMSComment choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7NOMSComment.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ7NOMS.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 7NOMSComment");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 8 - Type of initial MS/NMO symptom (check all that apply)

        // Question 8 - Type of initial MS/NMO symptom (check all that apply)
        if (getMsNmoSymptomCount() > 0)
        {
            _surveyResult = new SURVEY_RESULT();
            STD_QUESTION question8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "8");

            try
            {
                string choiceStr = "";

                foreach (ListItem li in cblQ8.Items)
                {
                    if (li.Selected)
                    {
                        choiceStr += li.Text + ",";
                    }
                }

                if (!String.IsNullOrEmpty(choiceStr))
                {
                    choiceStr = choiceStr.Substring(0, choiceStr.LastIndexOf(","));
                }

                // Add Question 8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question8.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = choiceStr;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "QUESTInstrument.aspx", "100027", "SaveSurvey() - Question8");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 9 - Multiple Sclerosis Subtype

        // Question 9 - Multiple Sclerosis Subtype
        if (rblQ9.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                //Relapsing-Remitting (RRMS)
                //Secondary Progressive (with or without relapses; SPMS)
                //Primary Progressive (PPMS)
                //Progressive-Relapsing (PRMS)
                //Not applicable (CIS or NMO)

                if (rblQ9.SelectedItem.Text.Contains("RRMS"))
                {
                    CurrentStatus.LastMSSubType = "RRMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("SPMS"))
                {
                    CurrentStatus.LastMSSubType = "SPMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("PPMS"))
                {
                    CurrentStatus.LastMSSubType = "PPMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("PRMS"))
                {
                    CurrentStatus.LastMSSubType = "PRMS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("CIS"))
                {
                    CurrentStatus.LastMSSubType = "CIS";
                }
                else if (rblQ9.SelectedItem.Text.Contains("NMO"))
                {
                    CurrentStatus.LastMSSubType = "NMO";
                }

                CurrentAssessmentHF.MSSubType = CurrentStatus.LastMSSubType;

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 9");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 9DateTran - Date transitioned

        // Question 9DateTran - Date transitioned
        if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
        {
            STD_QUESTION question9DateTran = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "9DateTran");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 9DateTran choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question9DateTran.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ9DateTran.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 9DateTran");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 10 - MS Service-Connection Status

        // Question 10 - MS Service-Connection Status
        if (rblQ10.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ10.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 10");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 11 - Current MS or NMO Disability

        // Question 11 - Current MS or NMO Disability
        if (rblQ11.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                CurrentStatus.LastEdumsScore = rblQ11.SelectedItem.Text.Substring(0, rblQ11.SelectedItem.Text.IndexOf(" ="));
                CurrentAssessmentHF.CurrentDisabilityScore = rblQ11.SelectedItem.Text.Substring(0, rblQ11.SelectedItem.Text.IndexOf(" ="));

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 11_6A - If applicable, year patient reached an EDMUS disability score of 6 (walks with unilateral or bilateral support)

        // Question 11_6A - If applicable, year patient reached an EDMUS disability score of 6 (walks with unilateral or bilateral support)
        if (!String.IsNullOrEmpty(mysQ11_6A.MonthYearString))
        {
            STD_QUESTION question11_6A = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "11_6A");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11_6A choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question11_6A.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ11_6A.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11_6A");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 11_8 - If applicable, year patient reached an EDMUS disability score of 8 (restricted to chair)

        // Question 11_8 - If applicable, year patient reached an EDMUS disability score of 8 (restricted to chair)
        if (!String.IsNullOrEmpty(mysQ11_8.MonthYearString))
        {
            STD_QUESTION question11_8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "11_8");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 11_8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question11_8.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ11_8.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 11_8");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 12 - Number of relapses* over the past twelve months

        // Question 12 - Number of relapses* over the past twelve months
        if (!String.IsNullOrEmpty(txtQ12.Text))
        {
            STD_QUESTION question12 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "12");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question12.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ12.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);

                if (!String.IsNullOrEmpty(txtQ12.Text))
                {
                    CurrentStatus.LastRelapses = Convert.ToInt32(txtQ12.Text);
                    CurrentAssessmentHF.Relapses = Convert.ToInt32(txtQ12.Text);
                }
                else
                {
                    CurrentStatus.LastRelapses = null;
                    CurrentAssessmentHF.Relapses = null;
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question 12");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 12A - Date of last relapse

        if (!String.IsNullOrEmpty(mysQ12A.MonthYearString))
        {
            STD_QUESTION question12aDateofRelapse = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "DATEOFLASTREALPSE");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question DATEOFLASTREALPSE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question12aDateofRelapse.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQ12A.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question Date of last relapse.");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }

        #endregion
        #region Question IG - Neutralizing Interferon Antibody status

        // Question IG - Neutralizing Interferon Antibody status
        if (rblQIG.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IG choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQIG.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQIG.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IG");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question IGP - Positive Date

        // Question IGP - Positive Date
        if (!String.IsNullOrEmpty(mysQIDPositive.MonthYearString))
        {
            STD_QUESTION questionIGP = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "IGP");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGP choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionIGP.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQIDPositive.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IGP");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question IGN - Negative Date

        // Question IGN - Negative Date
        if (!String.IsNullOrEmpty(mysQIDNegative.MonthYearString))
        {
            STD_QUESTION questionIGN = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "IGN");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGN choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionIGN.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQIDNegative.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question IGN");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion


        #region Question CardioTox - Is Patient being monitored for cardiotoxicity?

        // Question CardioTox - Is Patient being monitored for cardiotoxicity?
        if (mitoxantroneControl.getRbQCardioToxSelectedIndex() > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question CardioTox choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(mitoxantroneControl.getRbQCardioToxSelectedValue());
                _surveyResult.RESULT_TEXT = mitoxantroneControl.getRbQCardioToxSelectedItem();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioTox");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question CardioToxYes - Date of most recent cardiac MUGA or Echocardiogram

        if (!String.IsNullOrEmpty(mitoxantroneControl.getTxtQCardioToxDateText()))
        {
            STD_QUESTION questionCardioToxYes = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxYes");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question CardioToxYes choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxYes.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mitoxantroneControl.getTxtQCardioToxDateText();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxYes");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question CardioToxYes Date Unknown checkbox

        STD_QUESTION questionCardioToxDateUnknown = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "CardioToxDateUnknown");
        _surveyResult = new SURVEY_RESULT();

        try
        {
            // Add Question CardioToxYes choice
            _surveyResult.STD_QUESTION_CHOICE_ID = questionCardioToxDateUnknown.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = mitoxantroneControl.getCbQCardioToxDateUnknown();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question CardioToxDateUnknown");
            errorMessage += surveyEx.Message.ToString() + "\r\n";
        }

        #endregion

        #region Question SJC - Neutralizing Interferon Antibody status

        // Question SJC - Neutralizing Interferon Antibody status

        if (rblQSJC.SelectedIndex > -1)
        {
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question SJC choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQSJC.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQSJC.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJC");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question SJCP - Positive Date

        // Question SJCP - Positive Date
        if (!String.IsNullOrEmpty(mysQSJCPositive.MonthYearString))
        {
            STD_QUESTION questionSJCP = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "SJCP");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGP choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionSJCP.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQSJCPositive.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJCP");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question SJCN - Negative Date

        // Question SJCN - Negative Date
        if (!String.IsNullOrEmpty(mysQSJCNegative.MonthYearString))
        {
            STD_QUESTION questionSJCN = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "SJCN");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question IGN choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionSJCN.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = mysQSJCNegative.MonthYearString;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question SJCN");
                errorMessage += surveyEx.Message.ToString() + "\r\n";
            }
        }
        #endregion

        #region Question 13 - Medications

        List<MSSR_PATIENT_MEDICATION> patientMedsList = new List<MSSR_PATIENT_MEDICATION>();

        #region loop through rptMedication

        foreach (Control c in rptMedication.Controls)
        {
            RepeaterItem rptItem = c as RepeaterItem;
            MSSR_PATIENT_MEDICATION tempPatientMed;

            if (rptItem != null)
            {
                foreach (Control child in rptItem.Controls)
                {
                    if (child is controls_MedicationSelection)
                    {
                        var mdCntrl = child as controls_MedicationSelection;
                        if (mdCntrl != null)
                        {
                            tempPatientMed = mdCntrl.GetPatientMedication();
                            if (tempPatientMed != null)
                            {
                                tempPatientMed.SURVEY_ID = tempSurveyId;
                                tempPatientMed.ID = Guid.NewGuid();
                            }
                            patientMedsList.Add(tempPatientMed);
                        }
                        //tempPatientMed = (child as controls_MedicationSelection).GetPatientMedication();
                        //tempPatientMed.SURVEY_ID = tempSurveyId;
                        //tempPatientMed.ID = Guid.NewGuid();
                       // patientMedsList.Add(tempPatientMed);
                    }
                }
            }
            
        }

        #endregion

        #region loop through rptInterferonGroupMedication

        foreach (Control c in rptInterferonGroupMedication.Controls)
        {
            RepeaterItem rptItem = c as RepeaterItem;
            MSSR_PATIENT_MEDICATION tempPatientMed;

            if (rptItem != null)
            {
                foreach (Control child in rptItem.Controls)
                {
                    if (child is controls_MedicationSelection)
                    {
                        var chcntrl = child as controls_MedicationSelection;

                        if (chcntrl != null)
                        {
                            tempPatientMed = chcntrl.GetPatientMedication();
                            if (tempPatientMed != null)
                            {
                                tempPatientMed.SURVEY_ID = tempSurveyId;
                                tempPatientMed.ID = Guid.NewGuid();
                            }
                            if (patientMedsList != null)
                            {
                                patientMedsList.Add(tempPatientMed);
                            }                            
                        }   
                    }
                }
            }
        }

        #endregion

        #region loop through rptInterferonGroupMedication

        foreach (Control c in rptInterferonGroupMedication.Controls)
        {
            RepeaterItem rptItem = c as RepeaterItem;
            MSSR_PATIENT_MEDICATION tempPatientMed;

            if (rptItem != null)
            {
                foreach (Control child in rptItem.Controls)
                {
                    if (child is controls_MedicationSelection)
                    {
                        var chldcntrl = child as controls_MedicationSelection;
                        if (chldcntrl != null)
                        {
                            tempPatientMed = chldcntrl.GetPatientMedication();

                            tempPatientMed.SURVEY_ID = tempSurveyId;
                            tempPatientMed.ID = Guid.NewGuid();
                            patientMedsList.Add(tempPatientMed);
                        }
                    }
                }
                
            }
            
        }

        #endregion

        #region loop through rptOtherMedication

        foreach (Control c in rptOtherMedication.Controls)
        {
            RepeaterItem rptItem = c as RepeaterItem;
            MSSR_PATIENT_MEDICATION tempPatientMed;

            if (rptItem != null)
            {
                foreach (Control child in rptItem.Controls)
                {
                    if (child is controls_MedicationSelection)
                    {
                        var chcntrl = child as controls_MedicationSelection;
                        if (chcntrl != null)
                        {
                            tempPatientMed = chcntrl.GetPatientMedication();
                            if (tempPatientMed != null)
                            {
                                tempPatientMed.SURVEY_ID = tempSurveyId;
                                tempPatientMed.ID = Guid.NewGuid();
                            }
                            patientMedsList.Add(tempPatientMed);
                        }
                    }
                }
            }
            
        }

        #endregion



        try
        {
            // save entries to MSSR_PATIENT_MEDICATION table ...
            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                // need to drop before save ... however, issue - may need entries per survey id ... 
                ctx.MSSR_PATIENT_MEDICATIONs.DeleteAllOnSubmit(ctx.MSSR_PATIENT_MEDICATIONs.Where(M => M.SURVEY_ID == tempSurveyId));
                ctx.SubmitChanges();

                ctx.MSSR_PATIENT_MEDICATIONs.InsertAllOnSubmit(patientMedsList);
                ctx.SubmitChanges();

                #region Populate CurrentStatus Medication Section

                // Get top 3 meds for CURRENT_STATUS and then all ... 
                int currentCount = 0;
                int pastCount = 0;
                string currentMeds = "";
                string pastMeds = "";

                foreach (MSSR_PATIENT_MEDICATION med in patientMedsList)
                {
                    if ((bool)med.CURRENT_THERAPY)
                    {
                        currentCount++;

                        if (currentCount == 1)
                        {
                            CurrentStatus.Rx1 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (currentCount == 2)
                        {
                            CurrentStatus.Rx2 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (currentCount == 3)
                        {
                            CurrentStatus.Rx3 = med.MSSR_MEDICATION.MEDICATION;
                        }

                        currentMeds += med.MSSR_MEDICATION.MEDICATION + ", ";

                    }
                    else if ((bool)med.PAST_USE)
                    {
                        pastCount++;

                        if (pastCount == 1)
                        {
                            CurrentStatus.RxEver1 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (pastCount == 2)
                        {
                            CurrentStatus.RxEver2 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (pastCount == 3)
                        {
                            CurrentStatus.RxEver3 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (pastCount == 4)
                        {
                            CurrentStatus.RxEver4 = med.MSSR_MEDICATION.MEDICATION;
                        }
                        else if (pastCount == 5)
                        {
                            CurrentStatus.RxEver5 = med.MSSR_MEDICATION.MEDICATION;
                        }

                        pastMeds += med.MSSR_MEDICATION.MEDICATION + ", ";
                    }
                }

                if (writeTimeToLog)
                    Logging.WriteLogToFile("SaveSurvey: after foreach (MSSR_PATIENT_MEDICATION med in patientMedsList)");

                if (!String.IsNullOrEmpty(currentMeds))
                {
                    if (currentMeds.EndsWith(", "))
                    {
                        currentMeds = currentMeds.Substring(0, currentMeds.Length - 2).ToUpper();
                    }
                }

                CurrentStatus.RxAll = currentMeds;

                if (!String.IsNullOrEmpty(pastMeds))
                {
                    if (pastMeds.EndsWith(", "))
                    {
                        pastMeds = pastMeds.Substring(0, pastMeds.Length - 2).ToUpper();
                    }
                }

                CurrentStatus.RxEverAll = pastMeds;

                #endregion

            }

            // create string list for result text ... Question 13
            if (patientMedsList.Count > 0)
            {
                string medsStr = "";

                foreach (MSSR_PATIENT_MEDICATION mpm in patientMedsList)
                {
                    medsStr += mpm.ID + ",";
                }

                if (medsStr.EndsWith(","))
                {
                    medsStr = medsStr.Substring(0, medsStr.Length - 1);
                }

                STD_QUESTION question13 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "13");
                _surveyResult = new SURVEY_RESULT();

                try
                {
                    // Add Question 13 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = question13.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = medsStr; // store ',' delimited string or MSSR_PATIENT_MEDICATION IDs
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "Question 13");
                    errorMessage += surveyEx.Message.ToString() + "\r\n";
                }
            }
        }
        catch (Exception ex)
        {
            HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Question Patient Medication");
            errorMessage += ex.Message.ToString() + "\r\n";
        }

        #endregion

        #region Corticosteroids

        // Call UpdateSurveyWithCorticosteroidSelections to update passed SURVEY object.
        ctrlCorticosteroidsSelection.UpdateSurveyWithCorticosteroidSelections(ref _survey);

        string currentMedCort = ctrlCorticosteroidsSelection.GetCorticosteroidCurrentMeds();
        string pastMedCort = ctrlCorticosteroidsSelection.GetCorticosteroidPastMeds();

        if (!String.IsNullOrEmpty(CurrentStatus.RxAll) && !String.IsNullOrEmpty(currentMedCort))
        {
            CurrentStatus.RxAll += ", " + currentMedCort;
        }
        else if (String.IsNullOrEmpty(CurrentStatus.RxAll) && !String.IsNullOrEmpty(currentMedCort))
        {
            CurrentStatus.RxAll = currentMedCort;
        }

        if (!String.IsNullOrEmpty(CurrentStatus.RxEverAll) && !String.IsNullOrEmpty(pastMedCort))
        {
            CurrentStatus.RxEverAll += ", " + pastMedCort;
        }
        else if (String.IsNullOrEmpty(CurrentStatus.RxEverAll) && !String.IsNullOrEmpty(pastMedCort))
        {
            CurrentStatus.RxEverAll = pastMedCort;
        }

        #endregion

        #region Question HF - store health factors

        // Question HF - store health factors
        if (!String.IsNullOrEmpty(txtHealthFactors.Text))
        {
            STD_QUESTION questionHF = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "HF");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question HF choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionHF.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtHealthFactors.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "saveSurvey() - Question HF");
            }
        }

        #endregion

        #region Store Health Factors - separate table

        if (!String.IsNullOrEmpty(txtHealthFactors.Text))
        {
            try
            {
                List<MSSR_HEALTH_FACTOR> healthFactorList = new List<MSSR_HEALTH_FACTOR>();
                string[] hfList = txtHealthFactors.Text.Split(',');

                foreach (string hf in hfList)
                {
                    healthFactorList.Add(new MSSR_HEALTH_FACTOR() { ID = Guid.NewGuid(), HEALTH_FACTOR_TYPE = hf.Trim(), PATIENT_ICN = _mssrInstrumentManager.MssrServiceTo.PatientICN, STA3N = Convert.ToInt16(VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(_mssrInstrumentManager.MssrServiceTo.StationNumber)), SURVEY_ID = survey.SURVEYS_ID, CREATED = DateTime.Now });
                }

                using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                {
                    int surveyId = survey.SURVEYS_ID;
                    ctx.MSSR_HEALTH_FACTORs.DeleteAllOnSubmit(ctx.MSSR_HEALTH_FACTORs.Where(M => M.SURVEY_ID == surveyId && M.PATIENT_ICN == _mssrInstrumentManager.MssrServiceTo.PatientICN));
                    ctx.SubmitChanges();

                    ctx.MSSR_HEALTH_FACTORs.InsertAllOnSubmit(healthFactorList);
                    ctx.SubmitChanges();
                }

            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleMSSRException(surveyEx, "MSAssessmentTool.aspx", "100027", "SaveSurvey() - Store Health Factors");
            }
        }

        #endregion

        CurrentStatus.PatientICN = Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientICN.Trim());
        CurrentAssessmentHF.PatientICN = Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientICN.Trim());
        CurrentStatus.Sta3n = (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.siteCode) ? (int?)VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(_mssrInstrumentManager.MssrServiceTo.siteCode) : null);
        CurrentAssessmentHF.Sta3n = Convert.ToInt16(VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(_mssrInstrumentManager.MssrServiceTo.siteCode));

        patientDem.PatientICN = Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientICN.Trim());
        patientDem.PatientSoSeN = _mssrInstrumentManager.MssrServiceTo.PatientSoN.Trim();
                   

        if (writeTimeToLog)
            Logging.WriteLogToFile("SaveSurvey: end");

        return errorMessage;

    }// END SaveSurvey

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private string SetUpSurvey(SURVEY survey)
    {
        string errorMessage = "";

        try
        {
            errorMessage = setMedicationControls();
            loadSurveyValues(survey, false);

            // setup corticosteroid ctrl
            //ctrlCorticosteroidsSelection.SetValidatorSettings();
            ctrlCorticosteroidsSelection.SetupCorticosteroidSelections(ref survey);

            processAssessment(); // populate health factors and note summary from loaded values.

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "SetUpSurvey()");

            errorMessage = ex.Message;
        }

        return errorMessage;
    }// END SetUpSurvey

    /// <summary>
    /// LoadSurveyFromPastValues: Initialize/setup controls using values from other survey
    /// </summary>
    /// <param name="legacySurvey"></param>
    private string LoadSurveyFromPastValues(SURVEY survey)
    {
        string errorMessage = "";

        try
        {
            errorMessage = setMedicationControls();

            loadSurveyValues(survey, true);

            // setup corticosteroid ctrl
            //ctrlCorticosteroidsSelection.SetValidatorSettings();
            ctrlCorticosteroidsSelection.SetupCorticosteroidSelections(ref survey);

            errorMessage = processAssessment(); // populate health factors and note summary from loaded values.

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleMSSRException(ex, "MSAssessmentTool.aspx", "100027", "LoadSurveyFromPastValues()");

            errorMessage = ex.Message;
        }

        return errorMessage;
    } // END LoadSurveyFromPastValues



    private void loadSurveyValues(SURVEY survey, bool past)
    {
        foreach (var sResult in survey.SURVEY_RESULTs)
        {
            switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
            {
                case "DOD":
                    #region Question DOD
                    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                    {
                        DateTime temp;
                        if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                        {
                            dpDate2.SelectedDate = temp;
                        }
                    }
                    #endregion
                    break;
                case "COD":
                    #region Question COD
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        ddlCauseOfDeathType.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        ddlCauseOfDeathType.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "D":
                    #region Question D
                  
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                        {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                            {
                                dpDate1.SelectedDate = temp;
                            }
                        }
                    #endregion
                    break;
                case "AT":
                    #region Question AT
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblAssessmentType.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblAssessmentType.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "IC":
                    #region Question IC
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQIC.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQIC.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "1":
                    #region Question 1
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                        {
                            txtQ1Other.Text = sResult.RESULT_TEXT;
                        }
                        else
                        {
                            txtQ1Other.Text = "";
                        }
                    }
                    else
                    {
                        rblQ1.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "2":
                    #region Question 2
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ2.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "3":
                    #region Question 3
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ3.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "4":
                    #region Question 4
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ4UnknownComment.Text = sResult.RESULT_TEXT;
                        }
                    }
                    else
                    {
                        rblQ4.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "4a":
                    #region Question 4a
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        if (rblQ4a.Items == null || rblQ4a.Items.Count == 0)
                        {
                            rblQ4a.DataBind();
                        }                        
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ4a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            pnlQ4aOtherDescription.Style["Display"] = "block";                            
                        }
                        else
                        {
                            txtQ4aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ4a.SelectedIndex = -1;
                    }

                    //#region Question 4a
                    //if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    //{

                    //    if (rblQ4a.Items == null || rblQ4a.Items.Count == 0)
                    //    {
                    //        rblQ4a.DataBind();
                    //    }

                    //    rblQ4a.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                    //    if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                    //    {
                    //        txtQ4aOther.Text = sResult.RESULT_TEXT;
                    //    }
                    //    else
                    //    {
                    //        txtQ4aOther.Text = "";
                    //    }
                    //}
                    //else
                    //{
                    //    rblQ4a.SelectedIndex = -1;
                    //}
                    #endregion
                    break;
                case "4aBioFamHisMsOtherComment":
                    #region 4aBioFamHisMsOtherComment
                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ4aOtherDescription.Style["Display"] = "block";
                        txtQ4aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ4aOtherDescription.Style["Display"] = "none";
                        txtQ4aOther.Text = string.Empty;
                    }
                    break;
                    #endregion
                case "5":
                    #region Question 5
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ5UnknownComment.Text = sResult.RESULT_TEXT;

                        }
                        else
                        {
                            txtQ5UnknownComment.Text = "";
                        }
                    }
                    else
                    {
                        rblQ5.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "5a":
                    #region Question 5a
                    //if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    //{
                    //    pnlQ5a.Enabled = pnlQ5a.Visible = true; // if value - show panel

                    //    if (rblQ5a.Items == null || rblQ5a.Items.Count == 0)
                    //    {
                    //        rblQ5a.DataBind();
                    //    }

                    //    rblQ5a.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                    //    if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                    //    {
                    //        txtQ5aOther.Text = sResult.RESULT_TEXT;

                    //    }
                    //    else
                    //    {
                    //        txtQ5aOther.Text = "";
                    //    }
                    //}
                    //else
                    //{
                    //    rblQ5a.SelectedIndex = -1;
                    //}
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        pnlQ5a.Enabled = pnlQ5a.Visible = true;
                        if (rblQ5a.Items == null || rblQ5a.Items.Count == 0)
                        {
                            rblQ5a.DataBind();
                        }
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ5a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            //pnlQ5aOtherDescription.Style["Display"] = "block";
                            //txtQ5aOther.Text = sResult.RESULT_TEXT; //TODO: add a call to other description text.
                        }
                        else
                        {
                            txtQ5aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ5a.SelectedIndex = -1;
                    }

                    #endregion
                    break;
                case "5aBioFamHisMsOtherComment":
                    #region 5aBioFamHisMsOtherComment
                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ5aOtherDescription.Style["Display"] = "block";
                        txtQ5aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ5aOtherDescription.Style["Display"] = "none";
                        txtQ5aOther.Text = string.Empty;
                    }
                    break;
                    #endregion
                case "6":
                    #region Question 6
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                        if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "unknown")
                        {
                            txtQ6UnknownComment.Text = sResult.RESULT_TEXT;

                        }
                        else
                        {
                            txtQ6UnknownComment.Text = "";
                        }
                    }
                    else
                    {
                        rblQ6.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "6a":
                    #region Question 6a
                    //if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    //{
                    //    pnlQ6a.Enabled = pnlQ6a.Visible = true; // if value - show panel

                    //    if (rblQ6a.Items == null || rblQ6a.Items.Count == 0)
                    //    {
                    //        rblQ6a.DataBind();
                    //    }

                    //    rblQ6a.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                    //    if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower() == "other")
                    //    {
                    //        txtQ6aOther.Text = sResult.RESULT_TEXT;

                    //    }
                    //    else
                    //    {
                    //        txtQ6aOther.Text = "";
                    //    }
                    //}
                    //else
                    //{
                    //    rblQ6a.SelectedIndex = -1;
                    //}

                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        pnlQ6a.Enabled = pnlQ6a.Visible = true;
                        if (rblQ6a.Items == null || rblQ6a.Items.Count == 0)
                        {
                            rblQ6a.DataBind();
                        }
                        string[] bioFamHisMs = sResult.RESULT_TEXT.Split(',');
                        bool otherSelected = false;
                        foreach (string item in bioFamHisMs)
                        {
                            foreach (ListItem li in rblQ6a.Items)
                            {
                                if (item.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    if (item.ToLower() == "other")
                                    {
                                        otherSelected = true;
                                    }
                                    break;
                                }
                            }
                        }
                        if (otherSelected)
                        {
                            pnlQ6aOtherDescription.Style["Display"] = "block";
                            //txtQ6aOther.Text = sResult.RESULT_TEXT; //TODO: add a call to other description text.
                        }
                        else
                        {
                            txtQ6aOther.Text = "";
                        }
                    }
                    else
                    {
                        rblQ6a.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "6aBioFamHisMsOtherComment":
                #region 6aBioFamHisMsOtherComment
                    if (sResult.RESULT_TEXT != null)
                    {
                        pnlQ6aOtherDescription.Style["Display"] = "block";
                        txtQ6aOther.Text = sResult.RESULT_TEXT;
                    }
                    else
                    {
                        pnlQ6aOtherDescription.Style["Display"] = "none";
                        txtQ6aOther.Text = string.Empty;
                    }
                    break;
                #endregion
                case "7":
                    #region Question 7
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ7.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "7MSDateFirst":
                    #region Question 7MSDateFirst
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7MSDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7MSDateDx":
                    #region Question 7MSDateDx
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7MSDateDx.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7CISDateFirst":
                    #region Question 7CISDateFirst
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7CISDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7RISDateFirst":
                     #region Question 7RISDateFirst
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7RISDateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7NMODateFirst":
                    #region Question 7NMODateFirst
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7NMODateFirst.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7NMODx":
                    #region Question 7NMODx
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ7NMODx.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "7NOMSComment":
                    #region Question 7NOMSComment
                    if (sResult.RESULT_TEXT != null)
                    {
                        txtQ7NOMS.Text = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "8":
                    #region Question 8
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        // get result text ... split into array
                        string[] symptomArray = sResult.RESULT_TEXT.Split(',');

                        foreach (string s in symptomArray)
                        {
                            foreach (ListItem li in cblQ8.Items)
                            {
                                if (s.ToLower() == li.Text.ToLower())
                                {
                                    li.Selected = true;
                                    break;
                                }
                            }
                        }
                    }
                    #endregion
                    break;
                case "9":
                    #region Question 9
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ9.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "9DateTran":
                    #region Question 9DateTran
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ9DateTran.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "10":
                    #region Question 10
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ10.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                    /*
                case "11":
                    #region Question 11
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQ11.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "11_6A":
                    #region Question 11_6A
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ11_6A.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "11_8":
                    #region Question 11_8
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ11_8.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                    
                case "12":
                    #region Question 12
                    if (sResult.RESULT_TEXT != null)
                    {
                        txtQ12.Text = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "DATEOFLASTREALPSE":
                    #region Question 12 a
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQ12A.MonthYearString = sResult.RESULT_TEXT.ToString();                        
                    }
                    #endregion
                    break;*/
                case "13":
                    #region Question 13 - Medications

                    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                    {
                        string[] patientMedIds = sResult.RESULT_TEXT.Split(',');

                        List<MSSR_PATIENT_MEDICATION> medList = new List<MSSR_PATIENT_MEDICATION>();

                        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                        {
                            foreach (string s in patientMedIds)
                            {
                                Guid sId = new Guid(s);
                                MSSR_PATIENT_MEDICATION tempMed = ctx.MSSR_PATIENT_MEDICATIONs.FirstOrDefault(M => M.ID == sId);
                                if (medList != null && tempMed != null)
                                {
                                    medList.Add(tempMed);
                                }
                            }

                            // for all "non" inteferon group meds
                            foreach (MSSR_PATIENT_MEDICATION med in medList.Where(M => M.MSSR_MEDICATION.IS_INTERFERON_GROUP == false && M.MSSR_MEDICATION.IS_OTHER_GROUP == false))
                            {
                                foreach (Control c in rptMedication.Controls)
                                {
                                    RepeaterItem rptItem = c as RepeaterItem;
                                    if (rptItem != null)
                                    {
                                        foreach (Control child in rptItem.Controls)
                                        {
                                            var chldcntrl = child as controls_MedicationSelection;
                                            if (chldcntrl != null)
                                            {
                                                // check to see if control is bound to medication
                                                if (chldcntrl.MedicationId == med.MEDICATION_ID)
                                                {
                                                    chldcntrl.SetupMedicationSelections(med);
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    
                                }
                            }

                            //for all "Other DMTs"
                            foreach (MSSR_PATIENT_MEDICATION med in medList.Where(M => M.MSSR_MEDICATION.IS_OTHER_GROUP == true))
                            {
                                foreach (Control c in rptOtherMedication.Controls)
                                {
                                    RepeaterItem rptItem = c as RepeaterItem;

                                    if (rptItem != null)
                                    {
                                        foreach (Control child in rptItem.Controls)
                                        {
                                            var chldcntrl = child as controls_MedicationSelection;
                                            if (chldcntrl != null)
                                            {
                                                // check to see if control is bound to medication
                                                if (chldcntrl.MedicationId == med.MEDICATION_ID)
                                                {
                                                    chldcntrl.SetupMedicationSelections(med);
                                                    break;
                                                }
                                            }
                                        }                                        
                                    }                                    
                                }
                            }


                            // for all interferon group meds
                            foreach (MSSR_PATIENT_MEDICATION med in medList.Where(M => M.MSSR_MEDICATION.IS_INTERFERON_GROUP == true))
                            {
                                if (rptInterferonGroupMedication != null)
                                {
                                    foreach (Control c in rptInterferonGroupMedication.Controls)
                                    {
                                        RepeaterItem rptItem = c as RepeaterItem;
                                        if (rptItem != null)
                                        {
                                            foreach (Control child in rptItem.Controls)
                                            {
                                                if (child is controls_MedicationSelection)
                                                {
                                                    var chldctrl = child as controls_MedicationSelection;
                                                    if (chldctrl != null)
                                                    {
                                                        if (chldctrl.MedicationId == med.MEDICATION_ID)
                                                        {
                                                            chldctrl.SetupMedicationSelections(med);
                                                            break;
                                                        }
                                                    }                                                    
                                                }
                                            }
                                        }                                        
                                    }
                                }
                                
                            }
                        }
                    }

                    #endregion
                    break;
                case "IG":
                    #region Question IG
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        rblQIG.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                    }
                    else
                    {
                        rblQIG.SelectedIndex = -1;
                    }
                    #endregion
                    break;
                case "IGP":
                    #region Question IGP
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQIDPositive.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "IGN":
                    #region Question IGN
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQIDNegative.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "CardioTox":
                    #region Question CardioTox
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        mitoxantroneControl.setRbQCardioTox(sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString());
                    }
                    else
                    {
                        mitoxantroneControl.setRbQCardioTox("");
                    }
                    #endregion
                    break;
                case "CardioToxYes":
                    #region Question CardioToxYes
                    if (sResult.RESULT_TEXT != null)
                    {
                        mitoxantroneControl.setTxtQCardioToxDate(sResult.RESULT_TEXT.ToString());
                    }
                    #endregion
                    break;
                case "CardioToxDateUnknown":
                    #region Question CardioToxDateUnknown
                    if (sResult.RESULT_TEXT != null)
                    {
                        mitoxantroneControl.setCbQCardioToxDateUnknown(sResult.RESULT_TEXT.ToString());
                    }
                    #endregion
                    break;
                case "SJC":
                    #region Question SJC
                    if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                    {
                        setRblQSJCSelectedValue(sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString());                        
                    }
                    else
                    {
                        setRblQSJCSelectedValue("");                        
                    }
                    #endregion
                    break;
                case "SJCP":
                    #region Question SJCP
                    if (sResult.RESULT_TEXT != null)
                    {
                       mysQSJCPositive.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "SJCN":
                    #region Question SJCN
                    if (sResult.RESULT_TEXT != null)
                    {
                        mysQSJCNegative.MonthYearString = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                case "HF":
                    #region Question HF
                    if (sResult.RESULT_TEXT != null)
                    {
                        txtHealthFactors.Text = sResult.RESULT_TEXT.ToString();
                    }
                    #endregion
                    break;
                default:
                    break;
            }
        }
    }


    /// <summary>
    /// processAssessment: contains logic to parse the selected values and provide a note summary and health factor summary.
    /// </summary>
    private string processAssessment()
    {
        string errorString = "";

        errorString = setMedicationControls();

        #region Variable Declaration

        StringBuilder healthFactorString = new StringBuilder(); // to store string of heath factors. (comma separated values)
        StringBuilder msAssessmentNoteString = new StringBuilder(); // to store note summary.

        try
        {

            List<STD_QUESTION> questions = (QuestionList == null || QuestionList.Count == 0) ? GetAllQuestionsForSurvey() : QuestionList;

            string selectedItem = rblAssessmentType.SelectedItem.Text.ToLower();

        #endregion


            #region DOD

            if (dpDate2.SelectedDate != null)
            {
                msAssessmentNoteString.Append("Date Of Death \r\n");
                msAssessmentNoteString.Append("\t" + ((DateTime)dpDate2.SelectedDate).ToShortDateString() + "\r\n");
            }

            #endregion

            #region COD

            if (ddlCauseOfDeathType.SelectedValue != "")
            {
                msAssessmentNoteString.Append("Cause Of Death \r\n");
                msAssessmentNoteString.Append("\t" + ddlCauseOfDeathType.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Health Factor Creation

            #region Assessment Date

            if (dpDate1.SelectedDate != null)
            {
                msAssessmentNoteString.Append("Assessment Date \r\n");
                msAssessmentNoteString.Append("\t" + ((DateTime)dpDate1.SelectedDate).ToShortDateString() + "\r\n");
            }

            #endregion

            #region Process Assessment Type

            if (rblAssessmentType.SelectedItem != null)
            {
                string assessmentTypeHF = getAssessmentTypeHealthFactor(rblAssessmentType.SelectedItem.Text.ToLower());
                healthFactorString.Append(assessmentTypeHF);

                msAssessmentNoteString.Append(GetQuestionText("AT") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblAssessmentType.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Interview Type - MSCOE.INTERVIEW.FACE TO FACE, MSCOE.INTERVIEW.TELEPHONE, MSCOE.INTERVIEW.VIDEO CONFERENCE

            if (rblQIC.SelectedItem != null)
            {
                string interviewTypeHF = getInterviewTypeHealthFactor(rblQIC.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(interviewTypeHF))
                {
                    interviewTypeHF = ", " + interviewTypeHF;
                }
                healthFactorString.Append(interviewTypeHF);

                msAssessmentNoteString.Append(GetQuestionText("IC") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQIC.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Race as defined by patient - Question 1 - MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE / MSCOE.RACE.ASIAN / MSCOE.RACE.BLACK/AFRICAN AMERICAN / MSCOE.RACE.OTHER / MSCOE.RACE.PACIFIC ISLANDER / MSCOE.RACE.WHITE

            if (rblQ1.SelectedItem != null)
            {
                string raceHF = getRaceHealthFactor(rblQ1.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(raceHF))
                {
                    raceHF = ", " + raceHF;
                }
                healthFactorString.Append(raceHF);

                msAssessmentNoteString.Append("Question 1: " + GetQuestionText("1") + "\r\n");

                if (rblQ1.SelectedItem.Text.ToLower() == "other")
                {
                    msAssessmentNoteString.Append("\t" + rblQ1.SelectedItem.Text + (!String.IsNullOrEmpty(txtQ1Other.Text) ? (" - " + txtQ1Other.Text) : "") + "\r\n");
                }
                else
                {
                    msAssessmentNoteString.Append("\t" + rblQ1.SelectedItem.Text + "\r\n");
                }
            }

            #endregion

            #region Determine Ethnicity as defined by patient - MSCOE.ETHNICITY.HISPANIC / MSCOE.ETHNICITY.NON HISPANIC - Question 2

            if (rblQ2.SelectedItem != null)
            {
                string ethnicityHF = getEthnicityHealthFactor(rblQ2.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(ethnicityHF))
                {
                    ethnicityHF = ", " + ethnicityHF;
                }
                healthFactorString.Append(ethnicityHF);

                msAssessmentNoteString.Append("Question 2: " + GetQuestionText("2") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ2.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Gender - Question 3

            if (rblQ3.SelectedItem != null)
            {
                // Note
                msAssessmentNoteString.Append("Question 3: " + GetQuestionText("3") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ3.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Family History MS - Question 4

            /*
            if (rblQ4.SelectedItem != null)
            {
                string familyHistoryMSConfirmed = null;
                string familyHistoryMSHF = string.Empty;

                // Determine if "yes" - if there was a selection.  If so, push selection to familyHistoryMSConfirmed variable and pass to getFamilyHistoryMSHealthFactor()
                if (rblQ4a.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ4a.SelectedItem.Text))
                    {
                        familyHistoryMSConfirmed = rblQ4a.SelectedItem.Text.ToLower();//
                    }
                }

                //string familyHistoryMSHF = getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), familyHistoryMSConfirmed);

                foreach (ListItem li in rblQ4a.Items)
                {
                    if (li.Selected)
                    {
                        if (!string.IsNullOrEmpty(familyHistoryMSHF))
                        {
                            familyHistoryMSHF += ", ";
                        }
                        familyHistoryMSHF += getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), familyHistoryMSConfirmed);
                    }
                }
                //if (!String.IsNullOrEmpty(familyHistoryMSHF))
                //{
                //    familyHistoryMSHF = ", " + familyHistoryMSHF;
                //}
                healthFactorString.Append(familyHistoryMSHF);

                // Note
                msAssessmentNoteString.Append("Question 4: " + GetQuestionText("4") + "\r\n");
                string famHistoryMSText = rblQ4.SelectedItem.Text;

                if (rblQ4a.SelectedIndex > -1)
                {
                    if (!String.IsNullOrEmpty(rblQ4a.SelectedItem.Text))
                    {
                        if (rblQ4a.SelectedItem.Text.ToLower() == "other")
                        {
                            famHistoryMSText += " - " + rblQ4a.SelectedItem.Text + " (" + txtQ4aOther.Text + ")";
                        }
                        else
                        {
                            famHistoryMSText += " - " + rblQ4a.SelectedItem.Text;
                        }
                    }
                    else
                    {
                        famHistoryMSText += "";
                    }
                }
                else if (rblQ4.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryMSText += " - " + txtQ4UnknownComment.Text;
                }

                msAssessmentNoteString.Append("\t" + famHistoryMSText + "\r\n");

                //msAssessmentNoteString.Append(GetQuestionText("4a") + ":\r\n");
                //msAssessmentNoteString.Append("\t" + rblQ1.SelectedItem.Text);
            }
            */
            if (rblQ4.SelectedItem != null)
            {
                string familyHistoryMSConfirmed = null;
                string familyHistoryMSHF = string.Empty;
                bool familyHistoryMSHFOther = false;
                string famHistoryMSText = string.Empty;
               
                if (rblQ4.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ4.SelectedItem.Text))
                    {
                        familyHistoryMSConfirmed = rblQ4.SelectedItem.Text.ToLower();
                        famHistoryMSText = rblQ4.SelectedItem.Text;
                    }
                }
                if (!string.IsNullOrEmpty(familyHistoryMSHF))
                {
                    familyHistoryMSHF += ", ";
                }
                if (familyHistoryMSConfirmed == "yes" && getBioFamHisMsCount(rblQ4a) > 0)
                {
                    familyHistoryMSHF = ", MSCOE.FMX.MS CONFIRMED";
                    foreach (ListItem li in rblQ4a.Items)
                    {
                        if (li.Selected)
                        {
                            familyHistoryMSHF += getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), li.Text.ToLower());
                            famHistoryMSText += " - " + li.Text.ToLower();
                            if (li.Text.ToLower() == "other")
                            {
                                familyHistoryMSHFOther = true;
                            }
                        }
                    }                    
                }
                else
                {
                    familyHistoryMSHF += getFamilyHistoryMSHealthFactor(rblQ4.SelectedItem.Text.ToLower(), familyHistoryMSConfirmed);
                }
                healthFactorString.Append(familyHistoryMSHF);
                msAssessmentNoteString.Append("Question 4: " + GetQuestionText("4") + "\r\n");
                if (rblQ4a.SelectedIndex > -1)
                {                    
                    if (familyHistoryMSHFOther)
                    {                        
                            famHistoryMSText += " - " +  " (" + txtQ4aOther.Text + ")";                        
                    }
                    else
                    {
                        famHistoryMSText += "";
                    }
                }
                else if (rblQ4.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryMSText += " - " + txtQ4UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryMSText + "\r\n");
            }

            #endregion

            #region Determine Family History CIS - Question 5
            if (rblQ5.SelectedItem != null)
            {
                string familyHistoryCISConfirmed = null;
                string familyHistoryCISHF = string.Empty;
                bool familyHistoryCISHFOther = false;
                string famHistoryCISText = string.Empty;
                if (rblQ5.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ5.SelectedItem.Text))
                    {
                        familyHistoryCISConfirmed = rblQ5.SelectedItem.Text.ToLower();
                        famHistoryCISText = rblQ5.SelectedItem.Text;
                    }
                }
                if (!string.IsNullOrEmpty(familyHistoryCISHF))
                {
                    familyHistoryCISHF += ", ";
                }
                if (familyHistoryCISConfirmed == "yes" && getBioFamHisMsCount(rblQ5a) > 0)
                {
                    familyHistoryCISHF = ", MSCOE.FMX.CIS CONFIRMED";
                    foreach (ListItem li in rblQ5a.Items)
                    {
                        if (li.Selected)
                        {
                            familyHistoryCISHF += getFamilyHistoryCISHealthFactor(rblQ5.SelectedItem.Text.ToLower(), li.Text.ToLower());
                            famHistoryCISText += " - " + li.Text.ToLower();
                            if (li.Text.ToLower() == "other")
                            {
                                familyHistoryCISHFOther = true;
                            }
                        }
                    }
                }
                else
                {
                    familyHistoryCISHF += getFamilyHistoryCISHealthFactor(rblQ5.SelectedItem.Text.ToLower(), familyHistoryCISConfirmed);
                }

                healthFactorString.Append(familyHistoryCISHF);
                msAssessmentNoteString.Append("Question 5: " + GetQuestionText("5") + "\r\n");

                if (rblQ5a.SelectedIndex > -1)
                {
                    if (familyHistoryCISHFOther)
                    {
                        famHistoryCISText += " - " + " (" + txtQ5aOther.Text + ")";
                    }
                    else
                    {
                        famHistoryCISText += "";
                    }
                }
                else if (rblQ5.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryCISText += " - " + txtQ5UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryCISText + "\r\n");
            }
            /*
            if (rblQ5.SelectedItem != null)
            {
                string familyHistoryCISConfirmed = null;

                // Determine if "yes" - if there was a selection.  If so, push selection to familyHistoryMSConfirmed variable and pass to getFamilyHistoryCISHealthFactor()
                if (rblQ5a.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ5a.SelectedItem.Text))
                    {
                        familyHistoryCISConfirmed = rblQ5a.SelectedItem.Text.ToLower();
                    }
                }

                string familyHistoryCISHF = getFamilyHistoryCISHealthFactor(rblQ5.SelectedItem.Text.ToLower(), familyHistoryCISConfirmed);

                if (!String.IsNullOrEmpty(familyHistoryCISHF))
                {
                    familyHistoryCISHF = ", " + familyHistoryCISHF;
                }
                healthFactorString.Append(familyHistoryCISHF);

                // Note
                msAssessmentNoteString.Append("Question 5: " + GetQuestionText("5") + "\r\n");
                string famHistoryCISText = rblQ5.SelectedItem.Text;

                if (rblQ5a.SelectedIndex > -1)
                {
                    if (!String.IsNullOrEmpty(rblQ5a.SelectedItem.Text))
                    {
                        if (rblQ5a.SelectedItem.Text.ToLower() == "other")
                        {
                            famHistoryCISText += " - " + rblQ5a.SelectedItem.Text + " (" + txtQ5aOther.Text + ")";
                        }
                        else
                        {
                            famHistoryCISText += " - " + rblQ5a.SelectedItem.Text;
                        }
                    }
                    else
                    {
                        famHistoryCISText += "";
                    }
                }
                else if (rblQ5.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryCISText += " - " + txtQ5UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryCISText + "\r\n");
            }
            */
            #endregion

            #region Determine Family History NMO - Question 6
            if (rblQ6.SelectedItem != null)
            {
                string familyHistoryNMOConfirmed = null;
				string familyHistoryNMOHF = string.Empty;
                bool familyHistoryNMOHFOther = false;
                string famHistoryNMOText = string.Empty;
              
                if (rblQ6.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ6.SelectedItem.Text))
                    {
                        familyHistoryNMOConfirmed = rblQ6.SelectedItem.Text.ToLower();
                        famHistoryNMOText = rblQ6.SelectedItem.Text;
                    }
                }                
                if (!String.IsNullOrEmpty(familyHistoryNMOHF))
                {
                    familyHistoryNMOHF = ", " + familyHistoryNMOHF;
                }
				if (familyHistoryNMOConfirmed == "yes" && getBioFamHisMsCount(rblQ6a) > 0)
                {
                    familyHistoryNMOHF = ", MSCOE.FMX.NMO CONFIRMED";
					foreach (ListItem li in rblQ6a.Items)
                    {
                        if (li.Selected)
                        {
							familyHistoryNMOHF += getFamilyHistoryNMOHealthFactor(rblQ6.SelectedItem.Text.ToLower(), li.Text.ToLower());
							famHistoryNMOText += " - " + li.Text.ToLower();
							if (li.Text.ToLower() == "other")
                            {
                                familyHistoryNMOHFOther = true;
                            }
						}
                    }
				}
				else
				{
					familyHistoryNMOHF += getFamilyHistoryNMOHealthFactor(rblQ6.SelectedItem.Text.ToLower(), familyHistoryNMOConfirmed);
				}			

                healthFactorString.Append(familyHistoryNMOHF);                
                msAssessmentNoteString.Append("Question 6: " + GetQuestionText("6") + "\r\n");
                
                if (rblQ6a.SelectedIndex > -1)
                {
                    if (familyHistoryNMOHFOther)
                    {
                       famHistoryNMOText += " - " + " (" + txtQ6aOther.Text + ")";                        
                    }
                    else
                    {
                        famHistoryNMOText += "";
                    }
                }
                else if (rblQ6.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryNMOText += " - " + txtQ6UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryNMOText + "\r\n");
            }
            /*
            if (rblQ6.SelectedItem != null)
            {
                string familyHistoryNMOConfirmed = null;

                // Determine if "yes" - if there was a selection.  If so, push selection to familyHistoryNMOConfirmed variable and pass to getFamilyHistoryNMOHealthFactor()
                if (rblQ6a.SelectedItem != null)
                {
                    if (!String.IsNullOrEmpty(rblQ6a.SelectedItem.Text))
                    {
                        familyHistoryNMOConfirmed = rblQ6a.SelectedItem.Text.ToLower();
                    }
                }

                string familyHistoryNMOHF = getFamilyHistoryNMOHealthFactor(rblQ6.SelectedItem.Text.ToLower(), familyHistoryNMOConfirmed);

                if (!String.IsNullOrEmpty(familyHistoryNMOHF))
                {
                    familyHistoryNMOHF = ", " + familyHistoryNMOHF;
                }
                healthFactorString.Append(familyHistoryNMOHF);

                // Note
                msAssessmentNoteString.Append("Question 6: " + GetQuestionText("6") + "\r\n");
                string famHistoryNMOText = rblQ6.SelectedItem.Text;

                if (rblQ6a.SelectedIndex > -1)
                {
                    if (!String.IsNullOrEmpty(rblQ6a.SelectedItem.Text))
                    {
                        if (rblQ6a.SelectedItem.Text.ToLower() == "other")
                        {
                            famHistoryNMOText += " - " + rblQ6a.SelectedItem.Text + " (" + txtQ6aOther.Text + ")";
                        }
                        else
                        {
                            famHistoryNMOText += " - " + rblQ6a.SelectedItem.Text;
                        }
                    }
                    else
                    {
                        famHistoryNMOText += "";
                    }
                }
                else if (rblQ6.SelectedItem.ToString().ToLower().Contains("unknown"))
                {
                    famHistoryNMOText += " - " + txtQ6UnknownComment.Text;
                }
                msAssessmentNoteString.Append("\t" + famHistoryNMOText + "\r\n");
            }
            */
            #endregion

            #region Determine Diagnosis History - Question 7

            if (rblQ7.SelectedItem != null)
            {
                string diagnosisHistory = getDiagnosisHistory(rblQ7.SelectedItem.Text.ToLower());
                healthFactorString.Append(diagnosisHistory);

                // Note
                msAssessmentNoteString.Append("Question 7: " + GetQuestionText("7") + "\r\n");
                string diagnosisHistoryText = rblQ7.SelectedItem.Text;
                msAssessmentNoteString.Append("\t" + diagnosisHistoryText + "\r\n");

                #region Question 7 sub-areas

                if (rblQ7.SelectedItem.Text.ToLower().Contains("possible multiple"))
                {
                    // nothing

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("determined not"))
                {
                    if (!String.IsNullOrEmpty(txtQ7NOMS.Text))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NOMSComment") + "\r\n");
                        msAssessmentNoteString.Append("\t" + txtQ7NOMS.Text + "\r\n");
                    }

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("multiple sclerosis"))
                {

                    //MSCOE.YEAR OF FIRST MS SYMPTOM
                    if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7MSDateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7MSDateFirst.MonthYearString + "\r\n");
                    }

                    //MSCOE.YEAR OF MS DIAGNOSIS
                    if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7MSDateDx") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7MSDateDx.MonthYearString + "\r\n");
                    }

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("clinically isolated"))
                {
                    // nothing
                    if (!String.IsNullOrEmpty(mysQ7CISDateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7CISDateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7CISDateFirst.MonthYearString + "\r\n");
                    }

                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("neuromyelitis optica"))
                {

                    //MSCOE.YEAR OF FIRST NMO SYMPTOM
                    if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NMODateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7NMODateFirst.MonthYearString + "\r\n");
                    }

                    //MSCOE.YEAR OF NMO DIAGNOSIS
                    if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7NMODx") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7NMODx.MonthYearString + "\r\n");
                    }
                }
                else if (rblQ7.SelectedItem.Text.ToLower().Contains("radiologically isolated syndrome"))
                {
                    if (!String.IsNullOrEmpty(mysQ7RISDateFirst.MonthYearString))
                    {
                        msAssessmentNoteString.Append("  - " + GetQuestionText("7RISDateFirst") + "\r\n");
                        msAssessmentNoteString.Append("\t" + mysQ7RISDateFirst.MonthYearString + "\r\n");
                    }
                
                }

                #endregion
            }

            #endregion

            #region Determine Type of Initial Symptoms - Question 8

            //getMsNmoInitialSymptoms
            if (getMsNmoSymptomCount() > 0)
            {
                string symptomHF = "";
                string symptomNoteString = "";
                foreach (ListItem li in cblQ8.Items)
                {
                    if (li.Selected)
                    {
                        if (!String.IsNullOrEmpty(symptomHF))
                        {
                            symptomHF += ", ";
                        }
                        symptomHF += getMsNmoInitialSymptoms(li.Text.ToLower());

                        if (!String.IsNullOrEmpty(symptomNoteString))
                        {
                            symptomNoteString += ", ";
                        }
                        symptomNoteString += li.Text;
                    }
                }

                if (!String.IsNullOrEmpty(symptomHF))
                {
                    symptomHF = ", " + symptomHF;
                }
                healthFactorString.Append(symptomHF);

                msAssessmentNoteString.Append("Question 8: " + GetQuestionText("8") + "\r\n");
                msAssessmentNoteString.Append("\t" + symptomNoteString + "\r\n");
            }

            #endregion

            #region Determine Multiple Sclerosis Subtype - Question 9

            if (rblQ9.SelectedItem != null)
            {
                string msSubtypeHF = getMsSubtypeHealthFactor(rblQ9.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(msSubtypeHF))
                {
                    msSubtypeHF = ", " + msSubtypeHF;
                }

                healthFactorString.Append(msSubtypeHF);

                msAssessmentNoteString.Append("Question 9: " + GetQuestionText("9") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ9.SelectedItem.Text + "\r\n");

                if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("9DateTran") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ9DateTran.MonthYearString + "\r\n");
                }

            }

            #endregion

            #region Determine MS Service-Connection Status - Question 10

            if (rblQ10.SelectedItem != null)
            {
                string serviceConnectedStatusHF = getServiceConnectedStatusHealthFactor(rblQ10.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(serviceConnectedStatusHF))
                {
                    serviceConnectedStatusHF = ", " + serviceConnectedStatusHF;
                }

                healthFactorString.Append(serviceConnectedStatusHF);

                msAssessmentNoteString.Append("Question 10: " + GetQuestionText("10") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ10.SelectedItem.Text + "\r\n");
            }

            #endregion

            #region Determine Current MS or NMO Disability - Question 11

            if (rblQ11.SelectedItem != null)
            {
                string currentMsOrNmoDisabilityHF = getCurrentMsNmoDisability(rblQ11.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(currentMsOrNmoDisabilityHF))
                {
                    currentMsOrNmoDisabilityHF = ", " + currentMsOrNmoDisabilityHF;
                }

                healthFactorString.Append(currentMsOrNmoDisabilityHF);

                msAssessmentNoteString.Append("Question 11: " + GetQuestionText("11") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQ11.SelectedItem.Text + "\r\n");

                if (rblQ11.SelectedItem.Text.ToLower().Contains("6a =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("6b =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("7 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("11_6A") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ11_6A.MonthYearString + "\r\n");
                }

                if (rblQ11.SelectedItem.Text.ToLower().Contains("8 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("9 =") ||
                    rblQ11.SelectedItem.Text.ToLower().Contains("10 ="))
                {
                    msAssessmentNoteString.Append("  - " + GetQuestionText("11_8") + "\r\n");
                    msAssessmentNoteString.Append("\t" + mysQ11_8.MonthYearString + "\r\n");
                }
            }

            #endregion

            #region Detemine Number of Relapses - Question 12

            // Question 12 - num relapses ...
            if (!String.IsNullOrEmpty(txtQ12.Text))
            {
                int numRelapses = 0;
                if (Int32.TryParse(txtQ12.Text, out numRelapses))
                {
                    msAssessmentNoteString.Append("Question 12: " + GetQuestionText("12") + "\r\n");
                    msAssessmentNoteString.Append("\t" + txtQ12.Text + "\r\n");
                }
            }

            #endregion

            #region
            if (!string.IsNullOrEmpty(mysQ12A.MonthYearString))
            {
                msAssessmentNoteString.Append("Question 12A: " + GetQuestionText("DATEOFLASTREALPSE") + "\r\n");           
                msAssessmentNoteString.Append("  - " + GetQuestionText("DATEOFLASTREALPSE") + "\r\n");
                msAssessmentNoteString.Append("\t" + mysQ12A.MonthYearString + "\r\n");                
            }

            #endregion

            #region Monitoring Cardiotoxicity - Question CardioTox

            //MSCOE.MITOXANTRONE.MONITOR CARDIOTOX

            //For now we add this health factor only if its being monitored since
            //there does not appear to be a "yes" "no" type health factor out there

            if (mitoxantroneControl.getRbQCardioToxSelectedValue().ToLower().Contains("yes"))
            {
                healthFactorString.Append("MSCOE.MITOXANTRONE.MONITOR CARDIOTOX");
            }

            // Move this to the Mitoxantrone medication
            //msAssessmentNoteString.Append(GetQuestionText("CardioTox") + "\r\n");
            ////msAssessmentNoteString.Append("\t" + rblQCardioTox.SelectedItem.Text + "\r\n");

            #endregion

            #region Determine Serum anti-JC virus antibody status - Question SJC

            //MSCOE.ANTI-JC VIRUS.NEGATIVE
            //MSCOE.ANTI-JC VIRUS.POSITIVE
            //MSCOE.ANTI-JC VIRUS.UNKNOWN

            string sjcSelectedItem = getRblQSJCSelectedItem();

            string sjcHF = getSJCHealthFactor(sjcSelectedItem.ToLower());

            if (!String.IsNullOrEmpty(sjcHF))
            {
                sjcHF = ", " + sjcHF;
            }

            healthFactorString.Append(sjcHF);        

            #endregion

            #region Determine Medication Health Factors


            StringBuilder medicationHFs = new StringBuilder();
            StringBuilder medicationNoteSummary = new StringBuilder();

            #region loop through rptMedication

            msAssessmentNoteString.Append("\r\nMedication History\r\n");
            msAssessmentNoteString.Append("\r\nNon-Interferon Group Medications:\r\n");

            if (rptMedication != null)
            {
                foreach (Control c in rptMedication.Controls)
                {
                    RepeaterItem rptItem = c as RepeaterItem;
                    if (rptItem != null)
                    {
                        foreach (Control child in rptItem.Controls)
                        {
                            if (child is controls_MedicationSelection)
                            {
                                var chcntrl = child as controls_MedicationSelection;
                                string medHF = string.Empty;
                                if (chcntrl != null)
                                {
                                    medHF = chcntrl.GetHealthFactorsForMedication();
                                }
                                //string medHF = (child as controls_MedicationSelection).GetHealthFactorsForMedication();
                                if (medicationHFs.Length > 0)
                                {
                                    medicationHFs.Append(", " + medHF);
                                }
                                else
                                {
                                    medicationHFs.Append(medHF);
                                }
                                if (chcntrl != null)
                                {
                                    medicationNoteSummary.Append(chcntrl.GetMedicationNoteSummary());
                                }

                            }
                        }
                    }
                }
            }            

            msAssessmentNoteString.Append(medicationNoteSummary.ToString());
            medicationNoteSummary.Remove(0, medicationNoteSummary.Length);
            #endregion

            #region loop through rptInterferonGroupMedication

            msAssessmentNoteString.Append("\r\nInterferon Group Medications:\r\n\r\n");

            #region Neutralizing Interferon Antibody Status - Question IG

            //MSCOE.NIAB.NEGATIVE
            //MSCOE.NIAB.POSITIVE
            //MSCOE.NIAB.UNKNOWN

            if (rblQIG.SelectedItem != null)
            {
                string niabHF = getIGHealthFactor(rblQIG.SelectedItem.Text.ToLower());

                if (!String.IsNullOrEmpty(niabHF))
                {
                    niabHF = ", " + niabHF;
                }

                healthFactorString.Append(niabHF);

                msAssessmentNoteString.Append("-  " + GetQuestionText("IG") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQIG.SelectedItem.Text + "\r\n");

                if (!string.IsNullOrEmpty(niabHF) && niabHF.ToUpper().EndsWith("POSITIVE"))
                {
                   msAssessmentNoteString.Append("\t" + mysQIDPositive.Label + " " + mysQIDPositive.MonthYearString + "\r\n\r\n");                    
                }
                if (!string.IsNullOrEmpty(niabHF) && niabHF.ToUpper().EndsWith("NEGATIVE"))
                {                   
                    msAssessmentNoteString.Append("\t" + mysQIDNegative.Label + " " + mysQIDNegative.MonthYearString + "\r\n\r\n");                   
                }
            }

            #endregion

            #region SJC
            if (rblQSJC.SelectedItem != null)
            {
                msAssessmentNoteString.Append("-  " + GetQuestionText("SJC") + "\r\n");
                msAssessmentNoteString.Append("\t" + rblQSJC.SelectedItem.Text + "\r\n");

                if (rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
                {
                    msAssessmentNoteString.Append("\t" + mysQSJCNegative.Label );

                    if (mysQSJCNegative.MonthYearString.Length > 0)
                    {
                        msAssessmentNoteString.Append(" " + mysQSJCNegative.MonthYearString + "\r\n");
                    }
                    else
                    {
                        msAssessmentNoteString.Append("\t\tDATE UNKNOWN\r\n");
                    }
                }
                else if (rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
                {
                    msAssessmentNoteString.Append("\t" + mysQSJCPositive.Label);

                    if (mysQSJCPositive.MonthYearString.Length > 0)//                           
                    {
                        msAssessmentNoteString.Append(" " + mysQSJCPositive.MonthYearString + "\r\n");
                    }
                    else
                    {
                        msAssessmentNoteString.Append("\t\tDATE UNKNOWN\r\n");
                    }
                }
            }

            #endregion

            foreach (Control c in rptInterferonGroupMedication.Controls)
            {
                RepeaterItem rptItem = c as RepeaterItem;

                if (rptItem != null)
                {
                    foreach (Control child in rptItem.Controls)
                    {
                        if (child is controls_MedicationSelection)
                        {
                            //string medHF = (child as controls_MedicationSelection).GetHealthFactorsForMedication();
                            string medHF = string.Empty;
                            string medSummary = string.Empty;
                            var chcntrl = child as controls_MedicationSelection;
                            if (chcntrl != null)
                            {
                                medHF = chcntrl.GetHealthFactorsForMedication();
                                medSummary = chcntrl.GetMedicationNoteSummary();
                            }
                            if (medicationHFs.Length > 0)
                            {
                                medicationHFs.Append(", " + medHF);
                            }
                            else
                            {
                                medicationHFs.Append(medHF);
                            }

                            medicationNoteSummary.Append(medSummary);
                        }
                    }
                }
                
            }

            #endregion

           // if (medicationHFs.Length > 0)
           // {
             //   healthFactorString.Append(", " + medicationHFs.ToString());
           // }
            //else
            //{
              //  healthFactorString.Append(medicationHFs.ToString());
           // }

            msAssessmentNoteString.Append(medicationNoteSummary.ToString());
            medicationNoteSummary.Remove(0, medicationNoteSummary.Length);
            #endregion

            #region Determine Other Medication Health Factors
            msAssessmentNoteString.Append("\r\nOther DMTs Group Medications:\r\n");
            if (rptOtherMedication != null)
            {
                foreach (Control c in rptOtherMedication.Controls)
                {
                    RepeaterItem rptItem = c as RepeaterItem;
                    if (rptItem != null)
                    {
                        foreach (Control child in rptItem.Controls)
                        {
                            if (child is controls_MedicationSelection)
                            {
                                //string medHF = (child as controls_MedicationSelection).GetHealthFactorsForMedication();
                                string medHF = string.Empty;
                                string medNS = string.Empty;
                                var chcntrl = child as controls_MedicationSelection;

                                if (chcntrl != null)
                                {
                                    medHF = chcntrl.GetHealthFactorsForMedication();
                                    medNS = chcntrl.GetMedicationNoteSummary();
                                }
                                if (medicationHFs.Length > 0)
                                {
                                    medicationHFs.Append(", " + medHF);
                                }
                                else
                                {
                                    medicationHFs.Append(medHF);
                                }
                                medicationNoteSummary.Append(medNS);
                            }
                        }
                    }

                }
            }
            //end

            if (medicationHFs.Length > 0)
            {
                healthFactorString.Append(", " + medicationHFs.ToString());
            }
            else
            {
                healthFactorString.Append(medicationHFs.ToString());
            }
            msAssessmentNoteString.Append(medicationNoteSummary.ToString());
            medicationNoteSummary.Remove(0, medicationNoteSummary.Length);


            #endregion

            #region Determine Corticosteroids

            string corticosteroidHF = ctrlCorticosteroidsSelection.GetCorticosteroidHealthFactors();

            if (!String.IsNullOrEmpty(corticosteroidHF))
            {
                corticosteroidHF = ", " + corticosteroidHF;
            }

            healthFactorString.Append(corticosteroidHF);

            // note summary
            msAssessmentNoteString.Append(ctrlCorticosteroidsSelection.GetCorticosteroidNoteSummary());

            #endregion

            #endregion

            // Write Note Preview in textbox.
            txtNotePreview.Text = msAssessmentNoteString.ToString();

            // Write Health Factor Preview in textbox.
            txtHealthFactors.Text = healthFactorString.ToString();

            System.Diagnostics.StackTrace stackTrace = new System.Diagnostics.StackTrace();
            System.Reflection.MethodBase methodBase = stackTrace.GetFrame(1).GetMethod();
            string callerName = methodBase.Name;
        }
        catch (Exception ex)
        {
            HandleMSSRException(ex, "MSAssessmentTool.aspx", "0", "processAssessment");

            errorString += ex.Message;
        }

        return errorString;
    }

    /// <summary>
    /// Retrieves count of selected items in Q8
    /// </summary>
    /// <returns></returns>
    private int getTypeInitialSymptomCount()
    {
        int selectedItems = 0;

        foreach (ListItem li in cblQ8.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }

    /// <summary>
    /// Returns the Health Factor String for Assessment Type
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getAssessmentTypeHealthFactor(string selectedText)
    {
        if (selectedText.Contains("baseline"))
        {
            return "MSCOE.BASELINE ASSESSMENT";
        }
        else if (selectedText.Contains("annual"))
        {
            return "MSCOE.ANNUAL ASSESSMENT";
        }
        else if (selectedText.Contains("interim"))
        {
            return "MSCOE.INTERIM ASSESSMENT";
        }
        else if (selectedText.Contains("medications only"))
        {
            return "MSCOE.MEDICATIONS ONLY ASSESSMENT";
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Interview Type
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getInterviewTypeHealthFactor(string selectedText)
    {
        if (selectedText.Contains("telephone"))
        {
            return "MSCOE.INTERVIEW.TELEPHONE";
        }
        else if (selectedText.Contains("video"))
        {
            return "MSCOE.INTERVIEW.VIDEO CONFERENCE";
        }
        else if (selectedText.Contains("person"))
        {
            return "MSCOE.INTERVIEW.FACE TO FACE";
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Race
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getRaceHealthFactor(string selectedText)
    {
        if (selectedText.Contains("white"))
        {
            return "MSCOE.RACE.WHITE";
        }
        else if (selectedText.Contains("black"))
        {
            return "MSCOE.RACE.BLACK/AFRICAN AMERICAN";
        }
        else if (selectedText.Contains("pacific islander"))
        {
            return "MSCOE.RACE.PACIFIC ISLANDER";
        }
        else if (selectedText.Contains("alaska native"))
        {
            return "MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE";
        }
        else if (selectedText.Contains("asian"))
        {
            return "MSCOE.RACE.ASIAN";
        }
        else if (selectedText.Contains("other"))
        {
            return "MSCOE.RACE.OTHER";
        }
        else
        {
            return "";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Ethnicity
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getEthnicityHealthFactor(string selectedText)
    {
        if (selectedText.Contains("not hispanic"))
        {
            return "MSCOE.ETHNICITY.NON HISPANIC";
        }
        else if (selectedText.Contains("hispanic"))
        {
            return "MSCOE.ETHNICITY.HISPANIC";
        }
        else
        {
            return "";
        }
    }


    /// <summary>
    /// Returns the Health Factor String for Family History of MS
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getFamilyHistoryMSHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.MS CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.MS BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.MS DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.MS FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.MS MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.MS OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.MS SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.MS SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.MS NEGATIVE";
        }
        else // UNKNOWN
        {
            return ", MSCOE.FMX.MS UNKNOWN";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Family History of CIS
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getFamilyHistoryCISHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.CIS CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.CIS BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.CIS DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.CIS FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.CIS MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.CIS OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.CIS SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.CIS SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.CIS NEGATIVE";
        }
        else
        {
            return ", MSCOE.FMX.CIS UNKNOWN";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Family History of NMO
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getFamilyHistoryNMOHealthFactor(string selectedText, string confirmedSelectedText)
    {
        // Check - 
        if (selectedText.Contains("yes"))
        {
            //string confirmedText = "MSCOE.FMX.NMO CONFIRMED";
            string confirmedText = string.Empty;
            if (!String.IsNullOrEmpty(confirmedSelectedText))
            {
                if (confirmedSelectedText.Contains("brother"))
                {
                    confirmedText += ", MSCOE.FMX.NMO BROTHER";
                }
                else if (confirmedSelectedText.Contains("daughter"))
                {
                    confirmedText += ", MSCOE.FMX.NMO DAUGHTER";
                }
                else if (confirmedSelectedText.Contains("father"))
                {
                    confirmedText += ", MSCOE.FMX.NMO FATHER";
                }
                else if (confirmedSelectedText.Contains("mother"))
                {
                    confirmedText += ", MSCOE.FMX.NMO MOTHER";
                }
                else if (confirmedSelectedText.Contains("other"))
                {
                    confirmedText += ", MSCOE.FMX.NMO OTHER";
                }
                else if (confirmedSelectedText.Contains("sister"))
                {
                    confirmedText += ", MSCOE.FMX.NMO SISTER";
                }
                else if (confirmedSelectedText.Contains("son"))
                {
                    confirmedText += ", MSCOE.FMX.NMO SON";
                }
            }

            return confirmedText;

        }
        else if (selectedText.Contains("none"))
        {
            return ", MSCOE.FMX.NMO NEGATIVE";
        }
        else
        {
            return ", MSCOE.FMX.NMO UNKNOWN";
        }
    }

    /// <summary>
    /// Returns the Health Factor string for Dianosis history
    /// </summary>
    /// <param name="?"></param>
    /// <returns></returns>
    private string getDiagnosisHistory(string selectedText)
    {
        string returnStr = "";

        //MSCOE.DX.CIS
        //MSCOE.DX.MS
        //MSCOE.DX.NMO
        //MSCOE.DX.NOT MS
        //MSCOE.DX.POSSIBLE MS

        if (selectedText.Contains("possible multiple"))
        {
            returnStr = ", MSCOE.DX.POSSIBLE MS";

        }
        else if (selectedText.Contains("determined not"))
        {
            returnStr = ", MSCOE.DX.NOT MS";

        }
        else if (selectedText.Contains("multiple sclerosis"))
        {
            returnStr = ", MSCOE.DX.MS";

            //MSCOE.YEAR OF FIRST MS SYMPTOM
            if (!String.IsNullOrEmpty(mysQ7MSDateFirst.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF FIRST MS SYMPTOM";
            }

            //MSCOE.YEAR OF MS DIAGNOSIS
            if (!String.IsNullOrEmpty(mysQ7MSDateDx.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF MS DIAGNOSIS";
            }

        }
        else if (selectedText.Contains("clinically isolated"))
        {
            returnStr = "MSCOE.DX.CIS";

        }
        else if (selectedText.Contains("neuromyelitis optica"))
        {
            returnStr = "MSCOE.DX.NMO";

            //MSCOE.YEAR OF FIRST NMO SYMPTOM
            if (!String.IsNullOrEmpty(mysQ7NMODateFirst.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF FIRST NMO SYMPTOM";
            }

            //MSCOE.YEAR OF NMO DIAGNOSIS
            if (!String.IsNullOrEmpty(mysQ7NMODx.MonthYearString))
            {
                returnStr += ", MSCOE.YEAR OF NMO DIAGNOSIS";
            }
        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for MS / NMO Initial Symptoms
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getMsNmoInitialSymptoms(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("bowel/bladder"))
        {
            //MSCOE.ISX.BOWEL/BLADDER - bowel/bladder
            returnStr = "MSCOE.ISX.BOWEL/BLADDER";

        }
        else if (selectedText.Contains("brainstem"))
        {
            //MSCOE.ISX.BRAINSTEM - brainstem
            returnStr = "MSCOE.ISX.BRAINSTEM";

        }
        else if (selectedText.Contains("cerebellar"))
        {
            //MSCOE.ISX.CEREBELLAR - cerebellar
            returnStr = "MSCOE.ISX.CEREBELLAR";

        }
        else if (selectedText.Contains("cognitive"))
        {
            //MSCOE.ISX.COGNITIVE - cognitive
            returnStr = "MSCOE.ISX.COGNITIVE";

        }
        else if (selectedText.Contains("motor"))
        {
            //MSCOE.ISX.MOTOR - motor
            returnStr = "MSCOE.ISX.MOTOR";

        }
        else if (selectedText.Contains("optic neuritis"))
        {
            //MSCOE.ISX.OPTIC NEURITIS - optic neuritis
            returnStr = "MSCOE.ISX.OPTIC NEURITIS";

        }
        else if (selectedText.Contains("sensory"))
        {
            //MSCOE.ISX.SENSORY - sensory
            returnStr = "MSCOE.ISX.SENSORY";

        }
        else if (selectedText.Contains("spinal cord"))
        {
            //MSCOE.ISX.SPINAL CORD - spinal cord
            returnStr = "MSCOE.ISX.SPINAL CORD";

        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for MS Subtype
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getMsSubtypeHealthFactor(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("not applicable"))
        {
            returnStr = "MSCOE.SUBTYPE.CIS OR NMO";

        }
        else if (selectedText.Contains("ppms"))
        {
            returnStr = "MSCOE.SUBTYPE.PPMS";

        }
        else if (selectedText.Contains("prms"))
        {
            returnStr = "MSCOE.SUBTYPE.PRMS";

        }
        else if (selectedText.Contains("rrms"))
        {
            returnStr = "MSCOE.SUBTYPE.RRMS";

        }
        else if (selectedText.Contains("spms"))
        {
            returnStr = "MSCOE.SUBTYPE.SPMS";

            if (!String.IsNullOrEmpty(mysQ9DateTran.MonthYearString))
            {
                returnStr += ", MSCOE.SUBTYPE.SPMS TRANSITION YEAR";
            }
        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for Service Connected Status
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getServiceConnectedStatusHealthFactor(string selectedText)
    {
        //MSCOE.MS SC.NO, MSCOE.MS SC.YES
        string returnStr = "";

        if (selectedText.Contains("patient is not service"))
        {
            returnStr = "MSCOE.MS SC.NO";

        }
        else if (selectedText.Contains("patient is service"))
        {
            returnStr = "MSCOE.MS SC.YES";

        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for Neutralizing Interferon Antibody Status
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getIGHealthFactor(string selectedText)
    {
        //MSCOE.NIAB.NEGATIVE, MSCOE.NIAB.POSITIVE, MSCOE.NIAB.UNKNOWN
        string returnStr = "";

        if (selectedText.Contains("negative"))
        {
            returnStr = "MSCOE.NIAB.NEGATIVE";

        }
        else if (selectedText.Contains("positive"))
        {
            returnStr = "MSCOE.NIAB.POSITIVE";

        }
        else if (selectedText.Contains("unknown"))
        {
            returnStr = "MSCOE.NIAB.UNKNOWN";

        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for Serum anti-JC virus antibody status
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getSJCHealthFactor(string selectedText)
    {
        //MSCOE.ANTI-JC VIRUS.NEGATIVE, MSCOE.ANTI-JC VIRUS.POSITIVE, MSCOE.ANTI-JC VIRUS.UNKNOWN
        string returnStr = "";

        if (selectedText.Contains("negative"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.NEGATIVE";

        }
        else if (selectedText.Contains("positive"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.POSITIVE";

        }
        else if (selectedText.Contains("unknown"))
        {
            returnStr = "MSCOE.ANTI-JC VIRUS.UNKNOWN";

        }

        return returnStr;
    }

    /// <summary>
    /// Returns the Health Factor string for Current MS or NMO Disability
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getCurrentMsNmoDisability(string selectedText)
    {
        string returnStr = "";

        if (selectedText.Contains("1 ="))
        {
            returnStr = "MSCOE.EDMUS.01";

        }
        else if (selectedText.Contains("2 ="))
        {
            returnStr = "MSCOE.EDMUS.02";

        }
        else if (selectedText.Contains("3 ="))
        {
            returnStr = "MSCOE.EDMUS.03";

        }
        else if (selectedText.Contains("4 ="))
        {
            returnStr = "MSCOE.EDMUS.04";

        }
        else if (selectedText.Contains("5 ="))
        {
            returnStr = "MSCOE.EDMUS.05";

        }
        else if (selectedText.Contains("6a ="))
        {
            returnStr = "MSCOE.EDMUS.06A";

        }
        else if (selectedText.Contains("6b ="))
        {
            returnStr = "MSCOE.EDMUS.06B";

        }
        else if (selectedText.Contains("7 ="))
        {
            returnStr = "MSCOE.EDMUS.07";

        }
        else if (selectedText.Contains("8 ="))
        {
            returnStr = "MSCOE.EDMUS.08";

        }
        else if (selectedText.Contains("9 ="))
        {
            returnStr = "MSCOE.EDMUS.09";

        }
        else if (selectedText.Contains("10 ="))
        {
            returnStr = "MSCOE.EDMUS.10";

        }

        // Question 12 - num relapses ...
        if (!String.IsNullOrEmpty(txtQ12.Text))
        {
            int numRelapses = 0;
            if (Int32.TryParse(txtQ12.Text, out numRelapses))
            {
                returnStr += ", MSCOE.RELAPSE.IN PREVIOUS YEAR";
            }
        }

        return returnStr;
    }

    /// <summary>
    /// Retrieves count of selected items in cblQ8
    /// </summary>
    /// <returns></returns>
    private int getMsNmoSymptomCount()
    {
        int selectedItems = 0;

        foreach (ListItem li in cblQ8.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }


    private int getBioFamHisMsCount(CheckBoxList source)
    {
        int selectedItems = 0;

        foreach (ListItem li in source.Items)
        {
            if (li.Selected)
            {
                selectedItems++;
            }
        }

        return selectedItems;
    }
    private string setMedicationControls()
    {
        string errorMessage = "";

        try
        {
            if (mitoxantroneControl == null)
            {
                mitoxantroneControl = (controls_MedicationSelection)FindControl(Helpers.DeSerializSessionItems(Session["mitoxantroneUniqueID"]));
            }           
        }
        catch (Exception ex)
        {
            Exception exc = HandleMSSRException(ex, "MSAssessmentTool", "0", "setMedicationControls()");
            errorMessage = ex.Message;

        }

        return errorMessage;
    }



    public void AddErrorStatusMessage(string Message)
    {
        this.Page.Validators.Add(new CustomError() { ErrorMessage = Message });
    }


    private class CustomError : IValidator
    {
        public string ErrorMessage
        {
            get;
            set;
        }


        public bool IsValid
        {
            get
            {
                return false;
            }
            set
            {
                return; // by design
            }
        }

        public void Validate()
        {
            ; // by design
        }
    }

    private partial class PatientMedPlusError : MSSR_PATIENT_MEDICATION
    {
        public string error
        {
            get;
            set;
        }
    }

    public void setRblQSJCSelectedValue(string val)
    {
        
        if (!String.IsNullOrEmpty(val))
        {
            rblQSJC.SelectedValue = val;

            if (rblQSJC.SelectedItem.Text.ToLower().Contains("negative"))
            {
                pnlQSJCNegative.Style["display"] = "block";
                pnlQSJCPositive.Style["display"] = "none";
                mysQSJCPositive.MonthYearString = "";

            }
            else if (rblQSJC.SelectedItem.Text.ToLower().Contains("positive"))
            {
                pnlQSJCPositive.Style["display"] = "block";
                pnlQSJCNegative.Style["display"] = "none";
                mysQSJCNegative.MonthYearString = "";
            }
            else
            {

                pnlQSJCPositive.Style["display"] = "none";
                pnlQSJCNegative.Style["display"] = "none";
                mysQSJCPositive.MonthYearString = mysQSJCNegative.MonthYearString = ""; // clear selection
            }
        }
        else
        {
            //rblQSJC.SelectedIndex = -1;
            pnlQSJCNegative.Style["display"] = "none";
            pnlQSJCPositive.Style["display"] = "none";
            mysQSJCPositive.MonthYearString = mysQSJCNegative.MonthYearString = "";
        }
        
    }


    public string getRblQSJCSelectedItem()
    {
        string val = "";

        if (rblQSJC.SelectedItem != null)
        val = rblQSJC.SelectedItem.Text;

        return val;
    }
    #endregion
}