﻿<%@ Page Language="C#" MasterPageFile="~/MSSR_Instruments/RegistryInstrument.master"
    AutoEventWireup="true" CodeFile="MSAssessmentTool.aspx.cs" Inherits="MSSR_Instruments_MSAssessmentTool"
    Title="MS Assessment Tool" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="MSSR" TagName="MedicationSelection" Src="~/controls/MedicationSelection.ascx" %>
<%@ Register TagPrefix="MSSR" TagName="CorticosteroidsMedicationSelection" Src="~/controls/CorticosteroidsMedicationSelection.ascx" %>
<%@ Register TagPrefix="MSSR" TagName="MonthYearSelector" Src="~/controls/MonthYearSelector.ascx" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }

        .detailTable {
            border: 0px;
            background-color: #FFFFFF;
        }

            .detailTable td {
                border: 0px;
                background-color: #FFFFFF;
            }

        .requiredField {
            font-weight: bold;
            color: #FF0000;
        }

        #overlay {
            display: block; /* ensures it’s invisible until it’s called */
            position: fixed;
            left: 40%; /* positions the div half way horizontally */
            top: 25%; /* positions the div half way vertically */
            padding: 10px;
            border: 2px solid black;
            background-color: #ffffff;
            width: 20%;
            height: 85px;
            font-size: 11pt;
            z-index: 100; /* makes the div the top layer, so it’ll lay on top of the other content */
            text-align: center;
        }

        #fade {
            display: block; /* ensures it’s invisible until it’s called */
            position: fixed; /* makes the div go into a position that’s absolute to the browser viewing area */
            left: 0%; /* makes the div span all the way across the viewing area */
            top: 0%; /* makes the div span all the way across the viewing area */
            background-color: black;
            -moz-opacity: 0.7; /* makes the div transparent, so you have a cool overlay effect */
            opacity: .70;
            filter: alpha(opacity=70);
            width: 100%;
            height: 100%;
            z-index: 90; /* makes the div the second most top layer, so it’ll lay on top of everything else EXCEPT for divs with a higher z-index (meaning the #overlay ruleset) */
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server" AsyncPostBackTimeout="750"
        OnNavigate="ScriptManager1_Navigate">
    </asp:ScriptManager>

    <script type="text/javascript">
        Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
        Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

        var storedScrollPos;

        function startRequest(sender, e) {
            //disable button during the AJAX call
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;

            storedScrollPos = $(document).scrollTop();
        }
        function endRequest(sender, e) {
            //re-enable button once the AJAX call has completed
            document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
            document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
            document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;

            $(document).scrollTop(storedScrollPos);
        }

        ///////////////////////////////////////////
        //
        //  MSAssessmentTool.aspx javascript
        //
        ///////////////////////////////////////////




        function clearFamilyHistorySelection(rblYesName) {
            var chkbxList = document.getElementById(rblYesName);
            var options = chkbxList.getElementsByTagName('input');
            if (chkbxList != null) {
                for (var x = 0; x < options.length; x++) {
                    options[x].checked = false;
                }
            }

        }
        function ShowHideOtherDescription2(panelId, cblName, rblOtherId, txtBoxId, pnlError) {
            var panel = document.getElementById(panelId);
            var pnlError = document.getElementById(pnlError);


            //ResetPageTimer();

            // Clear the error
            if (pnlError != null)
                pnlError.style.display = "none";

            if (panel != null) {

                var checkedItem = "";

                var chkbxList = document.getElementById(cblName);
                var options = chkbxList.getElementsByTagName('input');


                //var chbxButtons = document.getElementsByName(cblName);

                if (chkbxList != null) {

                    for (var x = 0; x < options.length; x++) {
                        if (options[x].checked) {
                            checkedItem = options[x].id;
                        }
                    }
                    if (checkedItem == rblOtherId) {
                        panel.style.display = "block";
                    } else {
                        panel.style.display = "none";
                        document.getElementById(txtBoxId).value = "";
                    }
                } else {
                    alert("chbxButtons is null");
                }
            } else {
                alert("Panel is null");
            }
        }
        function ShowHideOtherDescription(panelId, rblName, rblOtherId, txtBoxId, pnlError) {
            var panel = document.getElementById(panelId);
            var pnlError = document.getElementById(pnlError);

            //ResetPageTimer();

            // Clear the error
            if (pnlError != null)
                pnlError.style.display = "none";

            if (panel != null) {

                var checkedItem = "";
                var radioButtons = document.getElementsByName(rblName);

                if (radioButtons != null) {

                    for (var x = 0; x < radioButtons.length; x++) {
                        if (radioButtons[x].checked) {
                            checkedItem = radioButtons[x].id;
                        }
                    }

                    if (checkedItem == rblOtherId) {

                        panel.style.display = "block";

                    } else {

                        panel.style.display = "none";

                        document.getElementById(txtBoxId).value = "";
                    }
                } else {

                    alert("RadioButtons is null");
                }

            } else {

                alert("Panel is null");
            }
        }

        function ShowHideFamilyHistory(unkPanelId, yesPanelId, yesOtherPanelId, rblName, rblYesName, rblUnknownId,
                                           rblYesId, txtBoxId, txtYesOtherId, pnlError) {
            var unkPanel = document.getElementById(unkPanelId);
            var yesPanel = document.getElementById(yesPanelId);
            var yesOtherPanel = document.getElementById(yesOtherPanelId);
            var pnlError = document.getElementById(pnlError);

            // Clear the error
            pnlError.style.display = "none";

            if (unkPanel != null) {

                var checkedItem = "";
                var radioButtons = document.getElementsByName(rblName);
                var radioButtonsYes = document.getElementsByName(rblYesName);

                if (radioButtons != null) {

                    for (var x = 0; x < radioButtons.length; x++) {
                        if (radioButtons[x].checked) {
                            checkedItem = radioButtons[x].id;
                        }
                    }

                    if (checkedItem == rblUnknownId) {

                        unkPanel.style.display = "block";
                        yesPanel.style.display = "none";

                        document.getElementById(txtBoxId).value = "";

                        // Uncheck anything in child rbl that will be hidden
                        for (var x = 0; x < radioButtonsYes.length; x++) {
                            radioButtonsYes[x].checked = false;
                        }
                        //uncheck all yes, selection and set other text to empty.

                        clearFamilyHistorySelection(rblYesName);

                        document.getElementById(txtYesOtherId).value = "";
                        yesOtherPanel.style.display = "none";

                    } else if (checkedItem == rblYesId) {

                        unkPanel.style.display = "none";
                        document.getElementById(txtBoxId).value = "";
                        yesPanel.style.display = "block";

                    } else {
                        clearFamilyHistorySelection(rblYesName);
                        unkPanel.style.display = "none";
                        document.getElementById(txtBoxId).value = "";
                        yesPanel.style.display = "none";

                        document.getElementById(txtBoxId).value = "";

                        // Uncheck anything in child rbl that will be hidden
                        for (var x = 0; x < radioButtonsYes.length; x++) {
                            radioButtonsYes[x].checked = false;
                        }

                        document.getElementById(txtYesOtherId).value = "";
                        yesOtherPanel.style.display = "none";
                    }
                } else {

                    alert("RadioButtons is null: " + rblId);
                }

            } else {

                alert("Panel is null: " + panelId);
            }
        }

        function ShowHideQuestion7() {
            var pnlQ7MS = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7MS");
            var pnlQ7CIS = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7CIS");
            var pnlQ7NMO = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7NMO");
            var pnlQ7NOMS = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7NOMS");
            var pnlQ7RIS = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7RIS");

            var pnlQ7MSDateFirstError = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7MSDateFirstError");
            if (pnlQ7MSDateFirstError != null)
                pnlQ7MSDateFirstError.style.display = "none";
            var pnlQ7CISDateFirstError = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7CISDateFirstError");
            if (pnlQ7CISDateFirstError != null)
                pnlQ7CISDateFirstError.style.display = "none";
            var pnlQ7NMODateFirstError = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7NMODateFirstError");
            if (pnlQ7NMODateFirstError != null)
                pnlQ7NMODateFirstError.style.display = "none";
            var pnlQ7NOMSError = document.getElementById("ctl00_ContentPlaceHolder_pnlQ7NOMSError");
            if (pnlQ7NOMSError != null)
                pnlQ7NOMSError.style.display = "none";

            var checkedItem = "";
            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rblQ7");

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_0") {
                    // If Multiple Sclerosis:

                    pnlQ7MS.style.display = "block";

                    pnlQ7CIS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlYear').selectedIndex = 0;

                    pnlQ7NOMS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_txtQ7NOMS').value = "";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7RIS.style.display = "none";
                    
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_1") {
                    // Possible MS:

                    pnlQ7MS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlYear').selectedIndex = 0;

                    pnlQ7CIS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlYear').selectedIndex = 0;

                    pnlQ7NOMS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_txtQ7NOMS').value = "";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7RIS.style.display = "none";
                    
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_2") {
                    // Clinically Isolated Syndrome:

                    pnlQ7MS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlYear').selectedIndex = 0;

                    pnlQ7CIS.style.display = "block";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlYear').selectedIndex = 0;

                    pnlQ7NOMS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_txtQ7NOMS').value = "";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7RIS.style.display = "none";
                    
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_3") {
                    // NMO:

                    pnlQ7MS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlYear').selectedIndex = 0;

                    pnlQ7CIS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "block";

                    pnlQ7NOMS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_txtQ7NOMS').value = "";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7RIS.style.display = "none";
                    
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_4") {
                    // NOT MS:

                    pnlQ7MS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlYear').selectedIndex = 0;

                    pnlQ7CIS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlYear').selectedIndex = 0;

                    pnlQ7NOMS.style.display = "block";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7RIS.style.display = "none";
                   
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ7_5")
                {
                    pnlQ7MS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7MSDateDx_ddlYear').selectedIndex = 0;

                    pnlQ7NMO.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODateFirst_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7NMODx_ddlYear').selectedIndex = 0;

                    pnlQ7NOMS.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_txtQ7NOMS').value = "";

                    pnlQ7RIS.style.display = "block";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7RISDateFirst_ddlYear').selectedIndex = 0;
                    
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ7CISDateFirst_ddlYear').selectedIndex = 0;
                    pnlQ7CIS.style.display = "none";
                   
                   

                }
                /*
            else {
                alert("Could not determine checked item: " + checkedItem);
            }*/
            }
        }

        function ShowHideQuestion9() {
            var pnlQ9DateTran = document.getElementById("ctl00_ContentPlaceHolder_pnlQ9DateTran");

            var pnlQ9DateTranError = document.getElementById("ctl00_ContentPlaceHolder_pnlQ9DateTranError");
            if (pnlQ9DateTranError != null)
                pnlQ9DateTranError.style.display = "none";

            var checkedItem = "";
            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rblQ9");

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem != "ctl00_ContentPlaceHolder_rblQ9_1") {
                    // Secondary Progressive (with or without relapses; SPMS)

                    pnlQ9DateTran.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ9DateTran_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ9DateTran_ddlYear').selectedIndex = 0;
                }
                else {
                    pnlQ9DateTran.style.display = "block";
                }
            }
        }

        function ShowHideQuestion11() {
            var pnlQ11_6A = document.getElementById("ctl00_ContentPlaceHolder_pnlQ11_6A");
            var pnlQ11_8 = document.getElementById("ctl00_ContentPlaceHolder_pnlQ11_8");

            var checkedItem = "";
            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rblQ11");

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == "ctl00_ContentPlaceHolder_rblQ11_0" ||
                        checkedItem == "ctl00_ContentPlaceHolder_rblQ11_1" ||
                        checkedItem == "ctl00_ContentPlaceHolder_rblQ11_2" ||
                        checkedItem == "ctl00_ContentPlaceHolder_rblQ11_3" ||
                        checkedItem == "ctl00_ContentPlaceHolder_rblQ11_4") {
                    // < 6a

                    pnlQ11_6A.style.display = "none";
                    pnlQ11_8.style.display = "none";
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ11_6A_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ11_6A_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ11_8_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQ11_8_ddlYear').selectedIndex = 0;
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQ11_5" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_6" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_7" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_8" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_9" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_10") {
                    // >= 6a

                    pnlQ11_6A.style.display = "block";

                    if (checkedItem == "ctl00_ContentPlaceHolder_rblQ11_8" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_9" ||
                            checkedItem == "ctl00_ContentPlaceHolder_rblQ11_10") {

                        pnlQ11_8.style.display = "block";
                    }
                    else {
                        pnlQ11_8.style.display = "none";
                        document.getElementById('ctl00_ContentPlaceHolder_mysQ11_8_ddlMonth').selectedIndex = 0;
                        document.getElementById('ctl00_ContentPlaceHolder_mysQ11_8_ddlYear').selectedIndex = 0;
                    }
                }
            }
        }

        function ShowHideQuestionQIG() {
            var pnlQIDPositive = document.getElementById("ctl00_ContentPlaceHolder_pnlQIDPositive");
            var pnlQIDNegative = document.getElementById("ctl00_ContentPlaceHolder_pnlQIDNegative");

            var checkedItem = "";
            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rblQIG");

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == "ctl00_ContentPlaceHolder_rblQIG_0") {
                    pnlQIDPositive.style.display = "block";
                    pnlQIDNegative.style.display = "none";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDNegative_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDNegative_ddlYear').selectedIndex = 0;
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQIG_1") {
                    pnlQIDPositive.style.display = "none";
                    pnlQIDNegative.style.display = "block";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDPositive_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDPositive_ddlYear').selectedIndex = 0;
                }
                else {
                    pnlQIDPositive.style.display = "none";
                    pnlQIDNegative.style.display = "none";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDNegative_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDNegative_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDPositive_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQIDPositive_ddlYear').selectedIndex = 0;
                }
            }
        }

        ///////////////////////////////////////////
        //
        //  MedicationSelection.ascx javascript
        //
        ///////////////////////////////////////////

        String.prototype.replaceAll = function (search, replace) {
            if (replace === undefined) {
                return this.toString();
            }
            return this.split(search).join(replace);
        }

        String.prototype.contains = function (it) {
            return this.indexOf(it) != -1;
        };

        function ShowHideQuestionQCardioTox() {

            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rptInterferonGroupMedication$ctl05$MedicationSelection1$rblQCardioTox");
            var pnlQCardioToxYes = document.getElementById("ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_pnlQCardioToxYes");

            if (radioButtons != null) {
                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == "ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_rblQCardioTox_0") {
                    pnlQCardioToxYes.style.display = "block";
                }
                else {
                    pnlQCardioToxYes.style.display = "none";

                    document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlYear').selectedIndex = 0;

                    document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_cbQCardioToxDateUnknown').checked = false;
                }
            }
        }

        function UnsetQCardioToxDate() {

            if (document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_cbQCardioToxDateUnknown').checked == true) {

                document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlMonth').selectedIndex = 0;
                document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlYear').selectedIndex = 0;
            }
        }

        function ShowHideQuestionQSJC() {
            var pnlQSJCPositive = document.getElementById("ctl00_ContentPlaceHolder_pnlQSJCPositive");
            var pnlQSJCNegative = document.getElementById("ctl00_ContentPlaceHolder_pnlQSJCNegative");

            var checkedItem = "";
            var radioButtons = document.getElementsByName("ctl00$ContentPlaceHolder$rblQSJC"); 

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == "ctl00_ContentPlaceHolder_rblQSJC_0") {
                    pnlQSJCPositive.style.display = "none";
                    pnlQSJCNegative.style.display = "block";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCNegative_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCNegative_ddlYear').selectedIndex = 0;
                }
                else if (checkedItem == "ctl00_ContentPlaceHolder_rblQSJC_1") {
                    pnlQSJCPositive.style.display = "block";
                    pnlQSJCNegative.style.display = "none";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCPositive_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCPositive_ddlYear').selectedIndex = 0;
                }
                else {
                    pnlQSJCPositive.style.display = "none";
                    pnlQSJCNegative.style.display = "none";

                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCNegative_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCNegative_ddlYear').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCPositive_ddlMonth').selectedIndex = 0;
                    document.getElementById('ctl00_ContentPlaceHolder_mysQSJCPositive_ddlYear').selectedIndex = 0;
                }
            }
        }

        function showHideCurrentTherapy(showHide, rootId) {
            // showHide is either 'show', or 'hide'
            var pnlCurrentTherapyId = rootId + 'pnlCurrentTherapy';
            var pnlCurrentTherapy = document.getElementById(pnlCurrentTherapyId);

            if (showHide == 'hide') {
                if (pnlCurrentTherapy != null) {
                    pnlCurrentTherapy.style.display = "none";
                }
            }
            else {
                if (pnlCurrentTherapy != null) {
                    pnlCurrentTherapy.style.display = "block";
                }
            }
        }

        function clearCurrentTherapy(rootId) {
            var chkBoxCurrentUse = document.getElementById(rootId + 'chkBoxCurrentUse');    //(chkBoxCurrentUseId);
            if (chkBoxCurrentUse !== null)
                chkBoxCurrentUse.checked = false;

            var rblNameString = rootId + 'rblCurrentDispensingPharmacy';
            rblNameString = rblNameString.replaceAll('_', '$');

            var rblCurrentDispensingPharmacy = document.getElementsByName(rblNameString);

            var numDosesTakenText = document.getElementById(rootId + 'txtCurrentNumberOfDosesTaken');
            if (numDosesTakenText != null)
                numDosesTakenText.value = "";

            // clear and disable pharmacy      
            for (var x = 0; x < rblCurrentDispensingPharmacy.length; x++) {
                rblCurrentDispensingPharmacy[x].checked = false;
            }

            document.getElementById(rootId + 'mysCurrentApproximateDateStarted_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mysCurrentApproximateDateStarted_ddlYear').selectedIndex = 0;
        }

        function clearOtherDMTName(rootId) {
            var otherDmtText = document.getElementById(rootId + 'txtOtherDMTName');
            if (otherDmtText != null)
                otherDmtText.value = "";
        }

        function clearCurrentUse(rootId) {

            // Current items

            clearOtherDMTName(rootId);
            clearCurrentTherapy(rootId);
            showHideCurrentTherapy('hide', rootId);
        }

        function CurrentUseClicked(cbCurrentUseElement) {

            var rootId = cbCurrentUseElement.id.replace('chkBoxCurrentUse', '');
            var cbCurrentUse = document.getElementById(cbCurrentUseElement.id);
            var pnlCurrentTherapy = document.getElementById(rootId + 'pnlCurrentTherapy');

            if (cbCurrentUse.checked == true) {
                showHideCurrentTherapy('show', rootId);
            } else {
                clearCurrentTherapy(rootId);
                showHideCurrentTherapy('hide', rootId);
            }
        }

        function showHidePastTherapy(showHide, rootId) {
            // showHide is either 'show', or 'hide'
            var pnlPastTherapy = document.getElementById(rootId + 'pnlPastTherapy');

            if (showHide == 'hide') {
                if (pnlPastTherapy != null) {
                    pnlPastTherapy.style.display = "none";
                }
            }
            else {
                if (pnlPastTherapy != null) {
                    pnlPastTherapy.style.display = "block";
                }
            }
        }

        function clearPastTherapy(rootId) {
            var pnlSignificantAdverseEventDescription = document.getElementById(rootId + 'pnlSignificantAdverseEventDescription');
            var pnlOtherReasonStopped = document.getElementById(rootId + 'pnlOtherReasonStopped');

            var chkBoxPastUse = document.getElementById(rootId + 'chkBoxPastUse');
            if (chkBoxPastUse !== null)
                chkBoxPastUse.checked = false;

            var rblNameString = rootId + 'rblPastDispensingPharmacy';
            rblNameString = rblNameString.replaceAll('_', '$');

            var rblPastDispensingPharmacy = document.getElementsByName(rblNameString);
            for (var x = 0; x < rblPastDispensingPharmacy.length; x++) {
                rblPastDispensingPharmacy[x].checked = false;
            }

            document.getElementById(rootId + 'mysPastDateStarted_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mysPastDateStarted_ddlYear').selectedIndex = 0;
            document.getElementById(rootId + 'mysPastDateStopped_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mysPastDateStopped_ddlYear').selectedIndex = 0;

            var numDosesTakenText = document.getElementById(rootId + 'txtPastNumberOfDosesTaken');
            if (numDosesTakenText != null)
                numDosesTakenText.value = "";

            var rblPastReasonStoppedString = rootId + 'rblPastReasonStopped';
            rblPastReasonStoppedString = rblPastReasonStoppedString.replaceAll('_', '$');

            var rblPastReasonStopped = document.getElementsByName(rblPastReasonStoppedString);
            for (var x = 0; x < rblPastReasonStopped.length; x++) {
                rblPastReasonStopped[x].checked = false;
            }

            var txtSignificantAdverseEventDescription = document.getElementById(rootId + 'txtSignificantAdverseEventDescription');
            if (txtSignificantAdverseEventDescription != null)
                txtSignificantAdverseEventDescription.value = "";

            var txtOtherReasonStoppedDescription = document.getElementById(rootId + 'txtOtherReasonStoppedDescription');
            if (txtOtherReasonStoppedDescription != null)
                txtOtherReasonStoppedDescription.value = "";

            pnlSignificantAdverseEventDescription.style.display = "none";
            pnlOtherReasonStopped.style.display = "none";
        }

        function PastUseClicked(cbPastUseElement) {

            var rootId = cbPastUseElement.id.replace('chkBoxPastUse', '');
            var cbPastUse = document.getElementById(cbPastUseElement.id);
            var pnlPastTherapy = document.getElementById(rootId + 'pnlPastTherapy');

            if (cbPastUse.checked == true) {
                showHidePastTherapy('show', rootId);
            } else {
                clearPastTherapy(rootId);
                showHidePastTherapy('hide', rootId);
            }
        }

        function showHideAdverseEvents(showHide, rootId) {
            // showHide is either 'show', or 'hide'
            var pnlAdverseEvents = document.getElementById(rootId + 'pnlAdverseEvents');

            if (showHide == 'hide') {
                if (pnlAdverseEvents != null) {
                    pnlAdverseEvents.style.display = "none";
                }
            }
            else {
                if (pnlAdverseEvents != null) {
                    pnlAdverseEvents.style.display = "block";
                }
            }
        }

        function clearAdverseEvents(rootId) {
            var chkBoxAdverseEvents = document.getElementById(rootId + 'chkBoxAdverseEvents');
            if (chkBoxAdverseEvents !== null)
                chkBoxAdverseEvents.checked = false;

            var rblNameString = rootId + 'rblAdverseEvents';
            rblNameString = rblNameString.replaceAll('_', '$');

            var rblAdverseEvents = document.getElementsByName(rblNameString);
            for (var x = 0; x < rblAdverseEvents.length; x++) {
                rblAdverseEvents[x].checked = false;
            }

            var txtAdverseEventsDescription = document.getElementById(rootId + 'txtAdverseEventsDescription');
            if (txtAdverseEventsDescription != null)
                txtAdverseEventsDescription.value = "";
        }

        function clearAntiJCSelection(rootId) {
            document.getElementById(rootId + 'mysQSJCNegative_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mysQSJCNegative_ddlYear').selectedIndex = 0;
            document.getElementById(rootId + 'mysQSJCPositive_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mysQSJCPositive_ddlYear').selectedIndex = 0;

            var radioButtonsJC = document.getElementsByName("ctl00$ContentPlaceHolder$rptInterferonGroupMedication$ctl07$MedicationSelection1$rblQSJC");
            if (radioButtonsJC != null) {
                for (var x = 0; x < radioButtonsJC.length; x++) {
                    if (radioButtonsJC[x].checked) {
                        radioButtonsJC[x].checked = false;
                    }
                }
            }
        }
        function clearCardiotoxicitySelection(rootId) {
            document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlMonth').selectedIndex = 0;
            document.getElementById('ctl00_ContentPlaceHolder_rptInterferonGroupMedication_ctl05_MedicationSelection1_mysQCardioToxYes_ddlYear').selectedIndex = 0;
            var radioButtonsCTX = document.getElementsByName('ctl00$ContentPlaceHolder$rptInterferonGroupMedication$ctl05$MedicationSelection1$rblQCardioTox');

            if (radioButtonsCTX != null) {
                for (var x = 0; x < radioButtonsCTX.length; x++) {
                    if (radioButtonsCTX[x].checked) {
                        radioButtonsCTX[x].checked = false;
                    }
                }
            }
        }

        function AdverseEventsClicked(chkBoxAdverseEventsElement) {

            var rootId = chkBoxAdverseEventsElement.id.replace('chkBoxAdverseEvents', '');
            var chkBoxAdverseEvents = document.getElementById(chkBoxAdverseEventsElement.id);
            var pnlAdverseEvents = document.getElementById(rootId + 'pnlAdverseEvents');

            if (chkBoxAdverseEvents.checked == true) {
                showHideAdverseEvents('show', rootId);
            } else {
                clearAdverseEvents(rootId);
                showHideAdverseEvents('hide', rootId);
            }
        }

        function ShowHideCurrentPastUse(rblIdField) {

            var rblId = rblIdField.id;
            var rootId = rblId.replace('rblUseStatus', '');
            var rblName = rblIdField.id.replaceAll('_', '$');
            var pnlCurrentPastUse = document.getElementById(rootId + 'pnlCurrentPastUse');
            var lblMedicationName = document.getElementById(rootId + 'lblMedicationName');

            var checkedItem = "";
            var medName = "";
            var radioButtons = document.getElementsByName(rblName);

            if (lblMedicationName != null) {
                medName = lblMedicationName.innerText;
            }

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == rootId + 'rblUseStatus_0') {
                    pnlCurrentPastUse.style.display = "none";

                    clearOtherDMTName(rootId);
                    clearCurrentTherapy(rootId);
                    showHideCurrentTherapy('hide', rootId);

                    clearPastTherapy(rootId);
                    showHidePastTherapy('hide', rootId);

                    clearAdverseEvents(rootId);
                    showHideAdverseEvents("hide", rootId);

                    if (medName.trim().toLowerCase() == "natalizumab (tysabri)") {
                        clearAntiJCSelection(rootId);
                    }
                    if (medName.trim().toLowerCase() == "mitoxantrone (novantrone)") {
                        clearCardiotoxicitySelection(rootId);
                    }
                }
                else if (checkedItem == rootId + 'rblUseStatus_1') {
                    pnlCurrentPastUse.style.display = "block";
                }
                else {
                    //alert("Could not determine selection: " + checkedItem);
                }
            }
        }

        function ReasonsStoppedClicked(rblIdField) {

            var rblId = rblIdField.id;
            var rootId = rblId.replace('rblPastReasonStopped', '');
            var rblName = rblIdField.id.replaceAll('_', '$');
            var radioButtons = document.getElementsByName(rblName);

            var pnlSignificantAdverseEventDescription = document.getElementById(rootId + 'pnlSignificantAdverseEventDescription');
            var pnlOtherReasonStopped = document.getElementById(rootId + 'pnlOtherReasonStopped');

            var checkedItem = "";

            var labelSelector;
            var labelHtml;
            var labelText;

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;

                        var labelSelector = 'label[for=' + radioButtons[x].id + ']';
                        var labelHtml = document.querySelector(labelSelector);
                        var labelText = labelHtml.innerHTML;
                    }
                }

                if (labelText.toLowerCase().contains('significant adverse event')) {
                    pnlSignificantAdverseEventDescription.style.display = "block";
                    pnlOtherReasonStopped.style.display = "none";

                    document.getElementById(rootId + 'txtOtherReasonStoppedDescription').value = "";
                }
                else if (labelText.toLowerCase().contains('other')) {
                    pnlSignificantAdverseEventDescription.style.display = "none";
                    pnlOtherReasonStopped.style.display = "block";

                    document.getElementById(rootId + 'txtSignificantAdverseEventDescription').value = "";
                }
                else {
                    pnlSignificantAdverseEventDescription.style.display = "none";
                    pnlOtherReasonStopped.style.display = "none";

                    document.getElementById(rootId + 'txtSignificantAdverseEventDescription').value = "";
                    document.getElementById(rootId + 'txtOtherReasonStoppedDescription').value = "";
                }
            }
        }

        ///////////////////////////////////////////
        //
        //  CorticoSteroidMedicationSelection.ascx javascript
        //
        ///////////////////////////////////////////

        function showHideCurrentTherapyCortico(showHide, rootId) {

            // showHide is either 'show', or 'hide'
            var pnlCurrentTherapyId = rootId + 'pnlCurrentTherapy';
            var pnlCurrentTherapy = document.getElementById(pnlCurrentTherapyId);

            if (showHide == 'hide') {
                if (pnlCurrentTherapy != null) {
                    pnlCurrentTherapy.style.display = "none";
                }
            }
            else {
                if (pnlCurrentTherapy != null) {
                    pnlCurrentTherapy.style.display = "block";
                }
            }
        }

        function clearTherapyNodeCortico(rootId, id, startStopString) {
            // Prednisone PO 
            var rblPredPharmString = rootId + 'rbl' + id + 'Pharm';
            rblPredPharmString = rblPredPharmString.replaceAll('_', '$');
            var rblPredPharm = document.getElementsByName(rblPredPharmString);

            // clear and disable pharmacy      
            for (var x = 0; x < rblPredPharm.length; x++) {
                rblPredPharm[x].checked = false;
            }

            var rblPredScheduleString = rootId + 'rbl' + id + 'Schedule';
            rblPredScheduleString = rblPredScheduleString.replaceAll('_', '$');
            var rblPredSchedule = document.getElementsByName(rblPredScheduleString);

            // clear and disable schedule      
            for (var x = 0; x < rblPredSchedule.length; x++) {
                rblPredSchedule[x].checked = false;
            }

            document.getElementById(rootId + 'txt' + id + 'ScheduleOther').value = "";
            document.getElementById(rootId + 'pnl' + id + 'ScheduleOther').style.display = "none";

            document.getElementById(rootId + 'mys' + id + 'Approx' + startStopString + '_ddlMonth').selectedIndex = 0;
            document.getElementById(rootId + 'mys' + id + 'Approx' + startStopString + '_ddlYear').selectedIndex = 0;
        }

        function clearCurrentTherapyCortico(rootId) {
            var chkBoxCurrentUse = document.getElementById(rootId + 'chkBoxCurrentUse');
            if (chkBoxCurrentUse !== null)
                chkBoxCurrentUse.checked = false;

            clearTherapyNodeCortico(rootId, 'CORTCUIVDex', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTCUIVMeth', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTCUOralMeth', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTCUOralPred', 'Started');
        }

        function showHidePastTherapyCortico(showHide, rootId) {
            // showHide is either 'show', or 'hide'
            var pnlPastTherapy = document.getElementById(rootId + 'pnlPastTherapy');

            if (showHide == 'hide') {
                if (pnlPastTherapy != null) {
                    pnlPastTherapy.style.display = "none";
                }
            }
            else {
                if (pnlPastTherapy != null) {
                    pnlPastTherapy.style.display = "block";
                }
            }
        }

        function clearPastTherapyCortico(rootId) {

            var chkBoxPastUse = document.getElementById(rootId + 'chkBoxPastUse');
            if (chkBoxPastUse !== null)
                chkBoxPastUse.checked = false;

            clearTherapyNodeCortico(rootId, 'CORTPUIVDex', 'Stopped');
            clearTherapyNodeCortico(rootId, 'CORTPUIVMeth', 'Stopped');
            clearTherapyNodeCortico(rootId, 'CORTPUOralMeth', 'Stopped');
            clearTherapyNodeCortico(rootId, 'CORTPUOralPred', 'Stopped');
            clearTherapyNodeCortico(rootId, 'CORTPUIVDex', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTPUIVMeth', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTPUOralMeth', 'Started');
            clearTherapyNodeCortico(rootId, 'CORTPUOralPred', 'Started');
        }

        function ShowHideCurrentPastUseCortico(rblIdField) {

            var rblId = rblIdField.id;
            var rootId = rblId.replace('rblCortUseStatus', '');
            var rblName = rblIdField.id.replaceAll('_', '$');
            var pnlCurrentPastUse = document.getElementById(rootId + 'pnlCurrentPastUse');

            var checkedItem = "";
            var radioButtons = document.getElementsByName(rblName);

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;
                    }
                }

                if (checkedItem == rootId + 'rblCortUseStatus_0') {
                    pnlCurrentPastUse.style.display = "none";

                    clearCurrentTherapyCortico(rootId);
                    showHideCurrentTherapyCortico('hide', rootId);

                    clearPastTherapyCortico(rootId);
                    showHidePastTherapyCortico('hide', rootId);

                    clearAdverseEvents(rootId);
                    showHideAdverseEvents("hide", rootId);
                }
                else if (checkedItem == rootId + 'rblCortUseStatus_1') {
                    pnlCurrentPastUse.style.display = "block";
                }
                else {
                    //alert("Could not determine selection: " + checkedItem);
                }
            }
        }

        function CurrentUseClickedCortico(cbCurrentUseElement) {

            var rootId = cbCurrentUseElement.id.replace('chkBoxCurrentUse', '');
            var cbCurrentUse = document.getElementById(cbCurrentUseElement.id);
            //var pnlCurrentTherapy = document.getElementById(rootId + 'pnlCurrentTherapy');

            if (cbCurrentUse.checked == true) {
                showHideCurrentTherapyCortico('show', rootId);
            } else {
                clearCurrentTherapyCortico(rootId);
                showHideCurrentTherapyCortico('hide', rootId);
            }
        }

        function rblScheduleClickedCortico(rblIdField) {
            var rblId = rblIdField.id;
            var root = "";

            if (rblIdField.id.contains('CORTCUIVDexSchedule')) {
                root = 'CORTCUIVDexSchedule';
            } else if (rblIdField.id.contains('CORTCUIVMethSchedule')) {
                root = 'CORTCUIVMethSchedule';
            } else if (rblIdField.id.contains('CORTCUOralMethSchedule')) {
                root = 'CORTCUOralMethSchedule';
            } else if (rblIdField.id.contains('CORTCUOralPredSchedule')) {
                root = 'CORTCUOralPredSchedule';

            } else if (rblIdField.id.contains('CORTPUIVDexSchedule')) {
                root = 'CORTPUIVDexSchedule';
            } else if (rblIdField.id.contains('CORTPUIVMethSchedule')) {
                root = 'CORTPUIVMethSchedule';
            } else if (rblIdField.id.contains('CORTPUOralMethSchedule')) {
                root = 'CORTPUOralMethSchedule';
            } else if (rblIdField.id.contains('CORTPUOralPredSchedule')) {
                root = 'CORTPUOralPredSchedule';
            }

            var rootId = rblId.replace('rbl' + root, '');
            var rblName = rblIdField.id.replaceAll('_', '$');
            var radioButtons = document.getElementsByName(rblName);

            var pnlScheduleOther = document.getElementById(rootId + 'pnl' + root + 'Other');

            var checkedItem = "";

            var labelSelector;
            var labelHtml;
            var labelText;

            if (radioButtons != null) {

                for (var x = 0; x < radioButtons.length; x++) {
                    if (radioButtons[x].checked) {
                        checkedItem = radioButtons[x].id;

                        var labelSelector = 'label[for=' + radioButtons[x].id + ']';
                        var labelHtml = document.querySelector(labelSelector);
                        var labelText = labelHtml.innerHTML;
                    }
                }

                if (labelText.toLowerCase().contains('monthly')) {
                    pnlScheduleOther.style.display = "none";

                    document.getElementById(rootId + 'txt' + root + 'Other').value = "";
                }
                else {
                    pnlScheduleOther.style.display = "block";
                }
            }
        }

        function PastUseClickedCortico(cbPastUseElement) {

            var rootId = cbPastUseElement.id.replace('chkBoxPastUse', '');
            var cbPastUse = document.getElementById(cbPastUseElement.id);
            var pnlPastTherapy = document.getElementById(rootId + 'pnlPastTherapy');

            if (cbPastUse.checked == true) {
                showHidePastTherapyCortico('show', rootId);
            } else {
                clearPastTherapyCortico(rootId);
                showHidePastTherapyCortico('hide', rootId);
            }
        }

        ///////////////////////////////////////////////////////////////////////
        //
        // Need to update the page timer if the user is working on the page
        //
        ///////////////////////////////////////////////////////////////////////

        var startTime = new Date();
        var elapsedTime = 0;

        document.onmousemove = function () {

            elapsed = new Date() - startTime; // elapsed time in ms

            // only fire every 30 seconds, otherwise it messes up mouse movements on the page
            if (elapsed > 30000) {

                var timer = $find('<%= InactiveTimer.ClientID %>');

                timer._stopTimer();
                timer._startTimer();

                startTime = new Date();
            }
        }




    </script>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <asp:UpdatePanel ID="updatePanelMain" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="updateProgressMain" runat="server" DisplayAfter="2000">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div id="overlay">
                            Processing...Please wait.<br />
                            <br />
                            <img src="../images/progress_bar.gif" alt="loading graphic" title="loading graphic" />
                        </div>
                        <div id="fade">
                        </div>

                    </ProgressTemplate>
                </asp:UpdateProgress>
                <!-- Validation Summary Control -->
                <asp:ValidationSummary ID="ValidationSummaryMSAssessment" runat="server" ValidationGroup="OnSave"
                    HeaderText="The page has the following data errors:" DisplayMode="BulletList"
                    ShowSummary="false" ShowMessageBox="true" />
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MSAT" />
                <div id="MSAT_main" style="background-color: #f4f6fa; padding-left: 10%">
                    <div style="min-width: 60%; max-width: 90%; border: 1px; background-color: #fff">
                        <div style="border: 1px solid #efeff2">
                            <div style="width: 100%; text-align: center; font-size: 12pt; font-weight: bold; background-color: #1f2d54; height: 30px; color: white; padding-bottom: 10px; margin-top: 20px;">
                                <div style="padding-top: 9px">Multiple Sclerosis Assessment Tool</div>
                            </div>
                            <!-- Patient Information / Assessment Types Area -->
                            <div id="divtop" style="padding-top: 10px; padding-left: 10px">
                                <table style="width: 100%;">
                                    <tr>
                                        <td style="vertical-align: top;">
                                            <asp:Label ID="LabelForPatientName" runat="server" Text="Name:" AssociatedControlID="lblPatientName"
                                                TabIndex="20"></asp:Label>
                                            <asp:Label ID="lblPatientName" runat="server" Text="Patient Name" TabIndex="30" />

                                            <br />
                                            <asp:Label ID="LabelForLast4" runat="server" Text="Last 4:" AssociatedControlID="lblLast4"
                                                TabIndex="40"></asp:Label>
                                            <asp:Label ID="lblLast4" runat="server" Text="XXXX" TabIndex="50" />
                                            <br />
                                            <br />
                                            <asp:Label ID="LabelForAssessmentDate" runat="server" Text="Assessment Date:" AssociatedControlID="dpDate1"
                                                TabIndex="60"></asp:Label>
                                            <!--Date-->
                                            <span class="requiredField">*</span>
                                            <!--Date picker-->
                                            <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="80">
                                                <Calendar ID="calDate1" runat="server">
                                                </Calendar>
                                            </telerik:RadDatePicker>
                                            <!--Date 1 required field validator (only one required)-->
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1"
                                                TabIndex="90" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assessment Date is required and must not be in the future."></asp:RequiredFieldValidator>
                                            <asp:RequiredFieldValidator ID="rfvdpDate1" runat="server" ControlToValidate="dpDate1"
                                                ValidationGroup="OnSaveDraft" Display="Dynamic" ErrorMessage="* Assessment Date is required and must not be in the future."></asp:RequiredFieldValidator>
                                            <br />
                                            <br />
                                            <asp:Label ID="LabelForDateOfDeathDem" runat="server" Text="Date of Death: " AssociatedControlID="lblLast4"
                                                Visible="true"></asp:Label>
                                            <asp:Label ID="lblDateOfDeath" runat="server" Text="" TabIndex="92" Visible="true" />
                                            <!--Date-->
                                            <!--Date picker-->
                                            <telerik:RadDatePicker ID="dpDate2" runat="server" TabIndex="81">
                                                <Calendar ID="calDate2" runat="server">
                                                </Calendar>
                                            </telerik:RadDatePicker>
                                            <br />
                                            <!--Question AT: CauseOfDeath Type(CauseOfDeath Type) (Tab Index start )-->
                                            <asp:Label ID="LabelForCOD" runat="server" AssociatedControlID="ddlCauseOfDeathType"
                                                SkinID="DataLabel" TabIndex="62">
                                            </asp:Label><br />
                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <asp:DropDownList ID="ddlCauseOfDeathType" runat="server" RepeatDirection="Vertical"
                                                TabIndex="63" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" AppendDataBoundItems="true"
                                                CssClass="" ValidationGroup="OnSave">
                                                <asp:ListItem Text="Select Cause of Death" Value=""></asp:ListItem>
                                            </asp:DropDownList>
                                            <br />
                                        </td>
                                        <td style="vertical-align: top;">
                                            <!--Question AT: Assessment Type(MSCOE MS Assessment Type) (Tab Index start 100)-->

                                            <asp:Label ID="LabelForQAT" runat="server" AssociatedControlID="rblAssessmentType"
                                                SkinID="DataLabel" TabIndex="100">
                                            </asp:Label>
                                            <span class="requiredField">*</span><br />
                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <div class="questionstop">
                                                <asp:RadioButtonList ID="rblAssessmentType" runat="server" RepeatDirection="Vertical"
                                                    TabIndex="110" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                    CssClass="test" ValidationGroup="OnSave">
                                                </asp:RadioButtonList>
                                            </div>
                                            <!--Question AT Required Validator-->
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQAT" runat="server" ControlToValidate="rblAssessmentType"
                                                TabIndex="120" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assessment Type is required."></asp:RequiredFieldValidator>
                                        </td>
                                        <td style="vertical-align: top;">
                                            <!--Question IC: Interview Completed by (Tab Index start 130)-->
                                            <asp:Label ID="LabelForQIC" runat="server" AssociatedControlID="rblQIC" SkinID="DataLabel"
                                                TabIndex="130">
                                            </asp:Label>
                                            <span class="requiredField">*</span><br />
                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <div class="questionstop">
                                                <asp:RadioButtonList ID="rblQIC" runat="server" RepeatDirection="Vertical" TabIndex="140"
                                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                    ValidationGroup="OnSave">
                                                </asp:RadioButtonList>
                                            </div>
                                            <!--Question IC Required Validator-->
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQIC" runat="server" ControlToValidate="rblQIC"
                                                TabIndex="150" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* 'Interview Completed By' is required."></asp:RequiredFieldValidator>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <hr />
                            <div style="padding-left: 10px">
                                <!--Question 1: Race, as defined by patient (Tab Index start 160)-->
                                1.
                    <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel"
                        TabIndex="160">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" AutoPostBack="False"
                                        TabIndex="170" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                        CssClass="" ValidationGroup="OnSave" OnClick="ShowHideOtherDescription('ctl00_ContentPlaceHolder_pnlQ1OtherDescription', 'ctl00$ContentPlaceHolder$rblQ1', 
                                 'ctl00_ContentPlaceHolder_rblQ1_5', 'ctl00_ContentPlaceHolder_txtQ1Other', 'ctl00_ContentPlaceHolder_pnlQ1Error')">
                                    </asp:RadioButtonList>

                                    <!--Question 1 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1"
                                        TabIndex="180" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 1: Race selection is required."></asp:RequiredFieldValidator>
                                    <br />
                                    <!-- Other Text for Q1 -->
                                    <asp:Panel ID="pnlQ1OtherDescription" runat="server">
                                        <asp:Label ID="LabelQ1OtherDescription" runat="server" AssociatedControlID="txtQ1Other"
                                            SkinID="DataLabel" TabIndex="190">
                        Other Description:
                                        </asp:Label>
                                        <asp:TextBox ID="txtQ1Other" runat="server" TabIndex="200" MaxLength="25" /><span
                                            class="requiredField">*</span>
                                        <asp:Label ID="txtQ1OtherSize" runat="server" Font-Italic="true" Font-Size="Smaller"
                                            TabIndex="201">
                        &nbsp;&nbsp;(25 chars max)</asp:Label>
                                        <br />
                                    </asp:Panel>
                                    <asp:Panel ID="pnlQ1Error" runat="server">
                                        <asp:Label ID="lblQ1Error" runat="server" Font-Bold="true" ForeColor="Red" TabIndex="202" />
                                    </asp:Panel>
                                </div>
                                <br />

                                <!--Question 2: Ethnicity, as defined by patient (Tab Index start 210)-->
                                2.
                    <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel"
                        TabIndex="210">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" TabIndex="220"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 2 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2"
                                        TabIndex="230" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 2: Ethnicity selection is required."></asp:RequiredFieldValidator>
                                </div>
                                <br />

                                <!--Question 3: Gender (Tab Index start 240)-->
                                3.
                    <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel"
                        TabIndex="240">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" TabIndex="250"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnDataBound="rblQ3_DataBound">
                                    </asp:RadioButtonList>
                                    <!--Question 3 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3"
                                        TabIndex="260" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 3: Gender selection is required."></asp:RequiredFieldValidator>
                                </div>
                                <br />
                                <br />
                                <!--Question 4: Biological family history of Multiple Sclerosis? (Tab Index start 270)-->
                                4.
                    <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel"
                        TabIndex="270">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" TabIndex="280"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ4Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ4a',  
                        'ctl00_ContentPlaceHolder_pnlQ4aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ4', 
                                                       'ctl00_ContentPlaceHolder_rblQ4a', 'ctl00_ContentPlaceHolder_rblQ4_0','ctl00_ContentPlaceHolder_rblQ4_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ4UnknownComment', 'ctl00_ContentPlaceHolder_txtQ4aOther', 'ctl00_ContentPlaceHolder_pnlQ4Error')">
                                    </asp:RadioButtonList>
                                    <!--Question 4 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4"
                                        TabIndex="290" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 4: Biological Family History of MS selection is required."></asp:RequiredFieldValidator>

                                    <!-- Unknown Comment Area -->
                                    <asp:Panel ID="pnlQ4Unknown" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <asp:Label ID="LabelQ4UnknownComment" runat="server" AssociatedControlID="txtQ4UnknownComment"
                                                SkinID="DataLabel" TabIndex="300">
                            Comment:
                                            </asp:Label>
                                            <asp:TextBox ID="txtQ4UnknownComment" runat="server" TabIndex="310" MaxLength="25" />
                                            <asp:Label ID="Label2" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                                &nbsp;&nbsp;(25 chars max)</asp:Label>
                                            <br />
                                        </div>
                                    </asp:Panel>
                                    <!-- Yes Selection Area - Question 4a -->
                                    <asp:Panel ID="pnlQ4a" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <!-- Question 4a -->

                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <asp:CheckBoxList ID="rblQ4a" runat="server" RepeatDirection="Vertical" TabIndex="330"
                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                ValidationGroup="OnSave" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ4aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ4a', 
                                                                  'ctl00_ContentPlaceHolder_rblQ4a_6', 'ctl00_ContentPlaceHolder_txtQ4aOther', 'ctl00_ContentPlaceHolder_pnlQ4Error')">
                                            </asp:CheckBoxList>
                                            <!-- Yes Other Comment Area -->
                                            <!-- Other Text for Q4a -->
                                            <asp:Panel ID="pnlQ4aOtherDescription" runat="server">
                                                <asp:Label ID="LabelForQ4aOther" runat="server" AssociatedControlID="txtQ4aOther"
                                                    SkinID="DataLabel" TabIndex="350">
                            Other Description:
                                                </asp:Label>
                                                <asp:TextBox ID="txtQ4aOther" runat="server" TabIndex="360" MaxLength="75" /><span
                                                    class="requiredField">*</span>
                                                <asp:Label ID="Label1" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                                &nbsp;&nbsp;(75 chars max)</asp:Label>
                                                <br />
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                    <asp:Panel ID="pnlQ4Error" runat="server">
                                        <asp:Label ID="lblQ4Error" runat="server" Font-Bold="true" ForeColor="Red" TabIndex="202" />
                                    </asp:Panel>
                                </div>
                                <br />
                                <br />
                                <!--Question 5: Biological family history of Clinically Isolated Syndrome? (Tab Index start 380)-->
                                5.
                    <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel"
                        TabIndex="380">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" TabIndex="390"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ5Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ5a',  
                        'ctl00_ContentPlaceHolder_pnlQ5aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ5', 
                                                       'ctl00_ContentPlaceHolder_rblQ5a', 'ctl00_ContentPlaceHolder_rblQ5_0','ctl00_ContentPlaceHolder_rblQ5_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ5UnknownComment', 'ctl00_ContentPlaceHolder_txtQ5aOther', 'ctl00_ContentPlaceHolder_pnlQ5Error')">
                                    </asp:RadioButtonList>
                                    <!--Question 5 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5"
                                        TabIndex="400" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 5: Biological Family History of CIS selection is required."></asp:RequiredFieldValidator>
                                    <!-- Unknown Comment Area -->
                                    <asp:Panel ID="pnlQ5Unknown" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <asp:Label ID="LabelQ5UnknownComment" runat="server" AssociatedControlID="txtQ5UnknownComment"
                                                SkinID="DataLabel" TabIndex="410">
                            Comment:
                                            </asp:Label>
                                            <asp:TextBox ID="txtQ5UnknownComment" runat="server" TabIndex="420" MaxLength="25" />
                                            <asp:Label ID="Label3" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                            &nbsp;&nbsp;(25 chars max)</asp:Label>
                                            <br />
                                        </div>
                                    </asp:Panel>
                                    <!-- Yes Selection Area - Question 5a -->
                                    <asp:Panel ID="pnlQ5a" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <!-- Question 5a -->
                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <asp:CheckBoxList ID="rblQ5a" runat="server" RepeatDirection="Vertical" TabIndex="440"
                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                ValidationGroup="OnSave" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ5aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ5a', 
                                                                  'ctl00_ContentPlaceHolder_rblQ5a_6', 'ctl00_ContentPlaceHolder_txtQ5aOther', 'ctl00_ContentPlaceHolder_pnlQ5Error')">
                                            </asp:CheckBoxList>
                                            <!--Question 5a Required Validator-->
                                            <asp:Label ID="rblQ5aError" runat="server" Font-Bold="true" ForeColor="Red" Visible="false"
                                                TabIndex="202" />
                                            <!-- Yes Other Comment Area -->
                                            <!-- Other Text for Q5a -->
                                            <asp:Panel ID="pnlQ5aOtherDescription" runat="server">
                                                <asp:Label ID="LabelForQ5aOther" runat="server" AssociatedControlID="txtQ5aOther"
                                                    SkinID="DataLabel" TabIndex="460">
                            Other Description:
                                                </asp:Label>
                                                <asp:TextBox ID="txtQ5aOther" runat="server" TabIndex="470" MaxLength="75" /><span
                                                    class="requiredField">*</span>
                                                <asp:Label ID="Label4" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                                &nbsp;&nbsp;(75 chars max)</asp:Label>
                                                <br />
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                    <asp:Panel ID="pnlQ5Error" runat="server">
                                        <asp:Label ID="lblQ5Error" runat="server" Font-Bold="true" ForeColor="Red" TabIndex="202" />
                                    </asp:Panel>
                                </div>
                                <br />
                                <br />
                                <!--Question 6: Biological family history of Neuromyelitis Optica/Devic's Disease? (Tab Index start 490)-->
                                6.
                    <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel"
                        TabIndex="490">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" TabIndex="500"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideFamilyHistory('ctl00_ContentPlaceHolder_pnlQ6Unknown', 
                        'ctl00_ContentPlaceHolder_pnlQ6a',  
                        'ctl00_ContentPlaceHolder_pnlQ6aOtherDescription',
                                                       'ctl00$ContentPlaceHolder$rblQ6', 
                                                       'ctl00_ContentPlaceHolder_rblQ6a', 'ctl00_ContentPlaceHolder_rblQ6_0','ctl00_ContentPlaceHolder_rblQ6_2', 
                                                       'ctl00_ContentPlaceHolder_txtQ6UnknownComment', 'ctl00_ContentPlaceHolder_txtQ6aOther', 'ctl00_ContentPlaceHolder_pnlQ6Error')">
                                    </asp:RadioButtonList>
                                    <!--Question 6 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6"
                                        TabIndex="510" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 6: Biological Family History of NMO selection is required."></asp:RequiredFieldValidator>
                                    <!-- Unknown Comment Area -->
                                    <asp:Panel ID="pnlQ6Unknown" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <asp:Label ID="LabelQ6UnknownComment" runat="server" AssociatedControlID="txtQ6UnknownComment"
                                                SkinID="DataLabel" TabIndex="520">
                            Comment:
                                            </asp:Label>
                                            <asp:TextBox ID="txtQ6UnknownComment" runat="server" TabIndex="530" MaxLength="25" />
                                            <asp:Label ID="Label5" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                            &nbsp;&nbsp;(25 chars max)</asp:Label>
                                            <br />
                                        </div>
                                    </asp:Panel>
                                    <!-- Yes Selection Area - Question 6a -->
                                    <asp:Panel ID="pnlQ6a" runat="server">
                                        <div style="padding: 5px; padding-left: 15px;">
                                            <!-- Question 6a -->

                                            <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                            <asp:CheckBoxList ID="rblQ6a" runat="server" RepeatDirection="Vertical" TabIndex="550"
                                                DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                ValidationGroup="OnSave" OnClick="ShowHideOtherDescription2('ctl00_ContentPlaceHolder_pnlQ6aOtherDescription', 'ctl00_ContentPlaceHolder_rblQ6a','ctl00_ContentPlaceHolder_rblQ6a_6', 
                                                                    'ctl00_ContentPlaceHolder_txtQ6aOther', 'ctl00_ContentPlaceHolder_pnlQ6Error')">
                                            </asp:CheckBoxList>
                                            <!-- Yes Other Comment Area -->
                                            <!-- Other Text for Q6a -->
                                            <asp:Panel ID="pnlQ6aOtherDescription" runat="server">
                                                <div style="padding: 5px; padding-left: 15px;">
                                                    <asp:Label ID="LabelForQ6aOther" runat="server" AssociatedControlID="txtQ6aOther"
                                                        SkinID="DataLabel" TabIndex="570">
                                Other Description:
                                                    </asp:Label>
                                                    <asp:TextBox ID="txtQ6aOther" runat="server" TabIndex="580" MaxLength="75" /><span
                                                        class="requiredField">*</span>
                                                    <asp:Label ID="Label6" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                                        &nbsp;&nbsp;(75 chars max)</asp:Label>
                                                    <br />
                                                </div>
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                    <asp:Panel ID="pnlQ6Error" runat="server">
                                        <asp:Label ID="lblQ6Error" runat="server" Font-Bold="true" ForeColor="Red" TabIndex="202" />
                                    </asp:Panel>
                                </div>
                                <br />
                                <br />
                                <!--Question 7: Diagnosis History (Tab Index start 600)-->
                                7.
                    <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel"
                        TabIndex="600">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Vertical" TabIndex="610"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideQuestion7()">
                                    </asp:RadioButtonList>
                                    <!--Question 7 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7"
                                        TabIndex="620" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 7: Diagnosis History selection is required."></asp:RequiredFieldValidator>
                                    <!-- 7MS sub questions -->
                                    <asp:Panel ID="pnlQ7MS" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <MSSR:MonthYearSelector ID="mysQ7MSDateFirst" runat="server"></MSSR:MonthYearSelector>
                                            <asp:Panel ID="pnlQ7MSDateFirstError" runat="server">
                                                <asp:Label ID="lblQ7MSDateFirstError" runat="server" Font-Bold="true" ForeColor="Red"
                                                    TabIndex="625" />
                                            </asp:Panel>
                                            <br />
                                            <MSSR:MonthYearSelector ID="mysQ7MSDateDx" runat="server"></MSSR:MonthYearSelector>
                                        </div>
                                    </asp:Panel>
                                    <!-- 7CIS sub questions -->
                                    <asp:Panel ID="pnlQ7CIS" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <MSSR:MonthYearSelector ID="mysQ7CISDateFirst" runat="server"></MSSR:MonthYearSelector>
                                            <asp:Panel ID="pnlQ7CISDateFirstError" runat="server">
                                                <asp:Label ID="lblQ7CISDateFirstError" runat="server" Font-Bold="true" ForeColor="Red"
                                                    TabIndex="625" />
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                    <!-- 7RIS sub questions -->
                                    <asp:Panel ID="pnlQ7RIS" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <MSSR:MonthYearSelector ID="mysQ7RISDateFirst" runat="server"></MSSR:MonthYearSelector>                                            
                                        </div>
                                    </asp:Panel>
                                    <!-- 7NMO sub questions -->
                                    <asp:Panel ID="pnlQ7NMO" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <MSSR:MonthYearSelector ID="mysQ7NMODateFirst" runat="server"></MSSR:MonthYearSelector>
                                            <asp:Panel ID="pnlQ7NMODateFirstError" runat="server">
                                                <asp:Label ID="lblQ7NMODateFirstError" runat="server" Font-Bold="true" ForeColor="Red"
                                                    TabIndex="202" />
                                            </asp:Panel>
                                            <br />
                                            <br />
                                            <MSSR:MonthYearSelector ID="mysQ7NMODx" runat="server"></MSSR:MonthYearSelector>
                                            <br />
                                        </div>
                                    </asp:Panel>
                                    <!-- Question 7NOMS: 7NOMS -->
                                    <asp:Panel ID="pnlQ7NOMS" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <asp:Label ID="LabelForQ7NOMS" runat="server" AssociatedControlID="txtQ7NOMS" SkinID="DataLabel"
                                                TabIndex="730">
                                            </asp:Label>
                                            <br />
                                            <asp:TextBox ID="txtQ7NOMS" runat="server" TabIndex="740" /><span class="requiredField">*</span>
                                            <asp:Label ID="Label7" runat="server" Font-Italic="true" Font-Size="Smaller" TabIndex="201">
                            &nbsp;&nbsp;(25 chars max)</asp:Label>
                                            <!--Question Q7NOMS Required Validator-->
                                            <asp:Panel ID="pnlQ7NOMSError" runat="server">
                                                <asp:Label ID="lblQ7NOMSError" runat="server" Font-Bold="true" ForeColor="Red" TabIndex="202" />
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                </div>
                                <br />
                                <br />
                                <!--Question 8: Type of initial MS/NMO symptom (check all that apply) (Tab Index start 760)-->
                                8.
                    <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="cblQ8" SkinID="DataLabel"
                        TabIndex="760">
                    </asp:Label>
                                <span class="requiredField">*</span>
                                <br />
                                <!-- Question 8 Choice List -->
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:CheckBoxList ID="cblQ8" runat="server" RepeatColumns="3" Width="600px" DataTextField="CHOICE_TEXT"
                                        DataValueField="STD_QUESTION_CHOICE_ID" TabIndex="770">
                                    </asp:CheckBoxList>
                                    <!-- Custom Validation Error -->
                                    <asp:Label ID="lblQ8Error" runat="server" Font-Bold="true" ForeColor="Red" Visible="false"
                                        TabIndex="780" />
                                </div>
                                <br />
                                <br />
                                <!--Question 9: Multiple Sclerosis Subtype (Tab Index start 790)-->
                                9.
                    <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel"
                        TabIndex="790">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" TabIndex="800"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideQuestion9()">
                                    </asp:RadioButtonList>
                                    <!--Question 9 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9"
                                        TabIndex="810" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 9: MS Subtype selection is required."></asp:RequiredFieldValidator>
                                    <!-- Question 9DateTran -->
                                    <asp:Panel ID="pnlQ9DateTran" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <MSSR:MonthYearSelector ID="mysQ9DateTran" runat="server"></MSSR:MonthYearSelector>
                                            <!--Question 9DateTran Required Validator-->
                                            <asp:Panel ID="pnlQ9DateTranError" runat="server">
                                                <asp:Label ID="lblQ9DateTranError" runat="server" Font-Bold="true" ForeColor="Red"
                                                    TabIndex="625" />
                                            </asp:Panel>
                                        </div>
                                    </asp:Panel>
                                </div>
                                <br />

                                <!--Question 10: MS Service-Connection Status (Tab Index start 850)-->
                                10.
                    <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel"
                        TabIndex="850">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" TabIndex="860"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave">
                                    </asp:RadioButtonList>
                                    <!--Question 10 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10"
                                        TabIndex="870" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 10: Service Connected Status selection is required."></asp:RequiredFieldValidator>
                                </div>
                                <br />
                                <!--Question 11: Current MS or NMO Disability (Tab Index start 880)-->
                                11.
                    <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel"
                        TabIndex="880">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                <!-- Bound in populateMedicationListsAndInitialSymptoms -->
                                <div class="questionsmid">
                                    <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Vertical" TabIndex="890"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                        ValidationGroup="OnSave" OnClick="ShowHideQuestion11()">
                                    </asp:RadioButtonList>
                                    <!--Question 11 Required Validator-->
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11"
                                        TabIndex="900" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Question 11: 'Current MS or NMO Disability' is required"></asp:RequiredFieldValidator>
                                    <!-- Question 11_6A -->
                                    <asp:Panel ID="pnlQ11_6A" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <asp:Label ID="LabelForQ11_6A" runat="server" AssociatedControlID="mysQ11_6A" SkinID="DataLabel"
                                                TabIndex="910" />
                                            <br />
                                            <MSSR:MonthYearSelector ID="mysQ11_6A" runat="server"></MSSR:MonthYearSelector>
                                        </div>
                                    </asp:Panel>

                                    <!-- Question 11_8 -->
                                    <asp:Panel ID="pnlQ11_8" runat="server">
                                        <br />
                                        <div style="padding: 5px; padding-left: 25px;">
                                            <asp:Label ID="LabelForQ11_8" runat="server" AssociatedControlID="mysQ11_8" SkinID="DataLabel"
                                                TabIndex="930">
                                            </asp:Label>
                                            <br />
                                            <MSSR:MonthYearSelector ID="mysQ11_8" runat="server"></MSSR:MonthYearSelector>
                                        </div>
                                    </asp:Panel>
                                    <br />
                                </div>
                                <br />
                                <!--Question 12: Number of relapses* over the past twelve months (Tab Index start 950)-->
                                12.
                    <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="txtQ12" SkinID="DataLabel"
                        TabIndex="950">
                    </asp:Label>
                                <span class="requiredField">*</span><br />
                                &nbsp;
                    <div class="questionsmid">
                        <asp:TextBox ID="txtQ12" runat="server" MaxLength="4" Width="50px" TabIndex="960"
                            Text="0"></asp:TextBox>&nbsp;*relapse = worsening neurological symptoms for
                    > 24hrs that stabilize or resolve
                    <br />
                        <div style="padding-left: 20px; padding-top: 10px">
                         
                                 <MSSR:MonthYearSelector ID="mysQ12A" runat="server"></MSSR:MonthYearSelector></div>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTrial1Time" runat="server"
                            ControlToValidate="txtQ12" ValidationGroup="OnSave" TabIndex="970" Display="Dynamic"
                            ErrorMessage="* Question 12: Number of relapses entry is required."></asp:RequiredFieldValidator>
                        <asp:RangeValidator ID="rvtxtQ12" runat="server" ControlToValidate="txtQ12" ErrorMessage="Question 12: Number of relapses must be greater than or equal to 0"
                            TabIndex="980" MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave"
                            Type="Integer" Display="Dynamic">
                        </asp:RangeValidator>
                        <br />
                    </div>
                                <br />
                              
                            </div>
                            <fieldset style="border: none;">
                                <legend>&nbsp;<asp:Label ID="LabelForQ13" runat="server" Font-Bold="true" />&nbsp;&nbsp;</legend>
                                <!-- Medications -->
                                <div style="padding-left: 10px;">
                                    13. MS or NMO medications (for baseline, be sure to document ALL medications)
                            <br />
                                    <br />
                                    <!-- Non-Interferon Group Meds -->
                                    <div style="border: 1px solid #e8e8ec">
                                        <div style="padding-bottom: 10px; height: 20px; width: 100%; background-color: #1f2d54">
                                            <div style="padding-left: 10px; padding-top: 5px">
                                                <label style="color: white" title="List of Current Medications.">
                                                    Regular Medications:</label>
                                            </div>
                                        </div>

                                        <div style="padding-top: 10px; padding-left: 10px">
                                            <asp:Repeater ID="rptMedication" runat="server" OnItemDataBound="rptMedication_ItemDataBound">
                                                <ItemTemplate>
                                                    <MSSR:MedicationSelection ID="MedicationSelection1" StartTabIndex='<%# MedTabIndexer %>'
                                                        runat="server" />
                                                    <br />
                                                </ItemTemplate>
                                            </asp:Repeater>
                                        </div>                              
                                 
                                    <!-- Interferon Group Meds -->
                                    <%--  --%>
                                 
                                        

                                        <!-- Interferon Group Question (IG) -->
                                        <div style="padding-left: 10px; padding-top: 10px">
                                            <div style="padding-left: 5px">
                                                <asp:Label ID="LabelForQIG" runat="server" Font-Bold="false" AssociatedControlID="rblQIG"
                                                    SkinID="DataLabel" TabIndex="2000">
                                                </asp:Label>
                                                <br />
                                                <asp:RadioButtonList ID="rblQIG" runat="server" RepeatDirection="Vertical" TabIndex="2010"
                                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass=""
                                                    ValidationGroup="OnSave" OnClick="ShowHideQuestionQIG()">
                                                </asp:RadioButtonList>
                                                <!--Question IG Object Data Source-->
                                                <asp:ObjectDataSource ID="ObjectDataSourceQIG" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                                    TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode"
                                                            Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenQIG" Direction="Input" Name="questionNumber"
                                                            Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                            </div>
                                            <!--Question IG : Question Number-->
                                            <asp:HiddenField ID="HiddenQIG" runat="server" Visible="false" Value="IG" />
                                            <br />
                                            <!-- Positive Date Text for QIG -->
                                            <asp:Panel ID="pnlQIDPositive" runat="server">
                                                <div style="padding: 5px; padding-left: 25px;">
                                                    <MSSR:MonthYearSelector ID="mysQIDPositive" runat="server"></MSSR:MonthYearSelector>
                                                </div>
                                                <br />
                                            </asp:Panel>
                                            <!-- Negative Date Text for QIG -->
                                            <asp:Panel ID="pnlQIDNegative" runat="server">
                                                <div style="padding: 5px; padding-left: 25px;">
                                                    <MSSR:MonthYearSelector ID="mysQIDNegative" runat="server"></MSSR:MonthYearSelector>
                                                </div>
                                                <br />
                                            </asp:Panel>

                                            <!-- SJC -->
                                            <asp:Panel ID="pnlSJC" runat="server" Style="margin-left: 12px;">
                                                <asp:Label ID="LabelForQSJC" runat="server" AssociatedControlID="rblQSJC" SkinID="DataLabel">
                                                </asp:Label>
                                                <br />
                                                <asp:RadioButtonList ID="rblQSJC" runat="server" RepeatDirection="Vertical" 
                                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID"
                                                    CssClass="" ValidationGroup="OnSave" OnClick="ShowHideQuestionQSJC()">
                                                </asp:RadioButtonList>
                                                <!--Question SJC Object Data Source-->
                                                <asp:ObjectDataSource ID="ObjectDataSourceQSJC" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                                    TypeName="VeteransAffairs.Registries.BusinessManager.MSSR.MSSRInstrumentsManager">
                                                    <SelectParameters>
                                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode"
                                                            Type="String" />
                                                        <asp:ControlParameter ControlID="HiddenQSJC" Direction="Input" Name="questionNumber"
                                                            Type="String" />
                                                    </SelectParameters>
                                                </asp:ObjectDataSource>
                                                <!--Question SJC : Question Number-->
                                                <asp:HiddenField ID="HiddenQSJC" runat="server" Visible="false" Value="SJC" />
                                                <br />
                                                <!-- Positive Date Text for QSJC -->
                                                <asp:Panel ID="pnlQSJCPositive" runat="server">
                                                    <div style="padding: 5px; padding-left: 25px;">
                                                        <MSSR:MonthYearSelector ID="mysQSJCPositive" runat="server"></MSSR:MonthYearSelector>
                                                    </div>
                                                    <br />
                                                </asp:Panel>
                                                <!-- Negative Date Text for QSJC -->
                                                <asp:Panel ID="pnlQSJCNegative" runat="server">
                                                    <div style="padding: 5px; padding-left: 25px;">
                                                        <MSSR:MonthYearSelector ID="mysQSJCNegative" runat="server"></MSSR:MonthYearSelector>
                                                    </div>
                                                    <br />
                                                </asp:Panel>
                                            </asp:Panel>

                                            <!-- SJC End -->

                                            <asp:Repeater ID="rptInterferonGroupMedication" runat="server" OnItemDataBound="rptInterferonGroupMedication_ItemDataBound">
                                                <ItemTemplate>
                                                    <MSSR:MedicationSelection ID="MedicationSelection1" StartTabIndex='<%# MedTabIndexer2 %>'
                                                        runat="server" />
                                                    <br />
                                                </ItemTemplate>
                                            </asp:Repeater>
                                        </div>
                                    </div>
                                    <br />
                                    <div style="border: 1px solid #e8e8ec">
                                        <div style="padding-bottom: 10px; height: 20px; width: 100%; background-color: #1f2d54">
                                            <div style="padding-left: 10px; padding-top: 5px">
                                                <label style="color: white" title="List of Current Medications.">
                                                    Other Medication:</label>
                                            </div>
                                        </div>
                                        <br />
                                        <asp:Repeater ID="rptOtherMedication" runat="server" OnItemDataBound="rptOtherMedication_ItemDataBound">
                                            <ItemTemplate>
                                                <MSSR:MedicationSelection ID="MedicationSelection1" StartTabIndex='<%# MedTabIndexer2 %>'
                                                    runat="server" />
                                                <br />
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </div>
                                    <br />
                                    <!-- Corticosteroids -->
                                    <div style="border: 1px solid #e8e8ec">
                                        <div style="padding-bottom: 10px; height: 20px; width: 100%; background-color: #1f2d54">
                                            <div style="padding-left: 10px; padding-top: 5px">
                                                <label style="color: white" title="List of Current Medications.">
                                                    Corticosteroids Medication:</label>
                                            </div>
                                        </div>
                                        <br />
                                        <MSSR:CorticosteroidsMedicationSelection ID="ctrlCorticosteroidsSelection" StartTabIndex="3000"
                                            runat="server" />
                                        <br />
                                    </div>
                                </div>
                            </fieldset>
                            <br />
                            <hr />
                            <asp:Panel ID="pnlNotification" runat="server" Visible="false" BorderStyle="Double"
                                Font-Bold="true">
                                <div style="width: 97%; margin-left: auto; margin-right: auto; background-color: #F1F1F1; border: 1px solid #999999; padding: 15px;">
                                    <asp:Label ID="LabelNotificationTitle" runat="server"> </asp:Label>
                                    <br />
                                    <br />
                                    <asp:Label ID="LabelNotificationMessage" runat="server" SkinID="DataLabel" Text=""></asp:Label>
                                    <br />
                                    <br />
                                    <asp:Label ID="LabelDetailedError" runat="server" SkinID="DataLabel" Text=""></asp:Label>
                                </div>
                            </asp:Panel>
                            <br />
                            <!-- 10 minutes -->
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="600000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" CausesValidation="true"
                                Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click" ValidationGroup="OnSaveDraft"
                                TabIndex="4000" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note"
                                Width="180px" OnClick="btnSubmit_Click" ValidationGroup="OnSave" TabIndex="4010" />
                            <asp:Button ID="btnCancelSurvey" runat="server" ToolTip="Warning: Clicking Cancel will close the window."
                                TabIndex="4020" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                            <br />
                            <br />
                            <hr />
                            <br />
                            <!-- Preview Area -->
                            <div style="width: 99%; margin-left: auto; margin-right: auto; background-color: #F1F1F1; border: 1px solid #999999; padding: 5px;">
                                <asp:Panel ID="pnlNotePreview" runat="server">
                                    Note Preview:<br />
                                    <table style="width: 99%;">
                                        <tr>
                                            <td style="vertical-align: top; width: 75px;">
                                                <asp:Button ID="btnUpdateNotePreview" runat="server" Text="Update" ToolTip="Update Note Summary Preview"
                                                    TabIndex="4030" OnClick="btnUpdateNotePreview_Click" />
                                            </td>
                                            <td style="vertical-align: top;">
                                                <asp:TextBox ID="txtNotePreview" runat="server" TextMode="MultiLine" ReadOnly="true"
                                                    Rows="6" Width="100%" TabIndex="4040"></asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                                <asp:Panel ID="pnlHealthFactorPreview" runat="server">
                                    Health Factors Preview:<br />
                                    <table style="width: 99%;">
                                        <tr>
                                            <td style="vertical-align: top; width: 75px;">
                                                <asp:Button ID="btnUpdateHealthFactors" runat="server" Text="Update" ToolTip="Update Health Factor Preview"
                                                    TabIndex="4050" OnClick="btnUpdateHealthFactors_Click" />
                                            </td>
                                            <td style="vertical-align: top;">
                                                <asp:TextBox ID="txtHealthFactors" runat="server" TextMode="MultiLine" ReadOnly="true"
                                                    Rows="6" Width="100%" TabIndex="4060"></asp:TextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                                <br />
                            </div>
                        </div>
                    </div>
                </div>
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>

</asp:Content>
