﻿using System;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using System.Globalization;
using System.Web;

public partial class MSSR_Instruments_Default : BaseMSSRInstrumentPage {
    #region Variable Declarations

    private string _inSiteCode;
    private string _inDUZ;
    private string _inDFN;

    private string _inServerIP;
    private string _inServerPort;

    private int _inMSSREvaluationNoteId;
    private int _inMSSRFollowUpNoteId;

    #endregion

    #region Protected Methods

    //private string SerializSessionItems(string sessionValue)
    //{
    //    if (string.IsNullOrEmpty(sessionValue))
    //    {
    //        return new System.Web.Script.Serialization.JavaScriptSerializer().Serialize(sessionValue);		 
    //    }
    //    else
    //    {
    //        return new System.Web.Script.Serialization.JavaScriptSerializer().Serialize("");	
    //    }
    //}
   
    protected void Page_Load(object sender, EventArgs e) {

        string userName = HttpContext.Current.User.Identity.Name;

        if (!Helpers.UserHasMssrProfile(userName))
        {
            Logging.WriteLogToFile("WARNING:: MSSR Instrument Default aspx page. No User Profile Available for " + userName);
            Response.Redirect("Warning.aspx?err=prferr");
        }
        if (!IsPostBack) {
            PanelPatientConfirm.Visible = true;
            PanelInstrumentList.Visible = false;

            //RTC: 152800
            //Session["ConfirmedSSN"] = null;

            if (Request.QueryString["useSession"] != "true")
            {
                //Get parameters from querystring 
                Session["SiteCode"] = Helpers.SerializSessionItemsObj(Request.QueryString["q9gtw0"]);
                Session["DUZ"] = Helpers.SerializSessionItemsObj(Request.QueryString["yiicf"]);
                Session["DFN"] = Helpers.SerializSessionItemsObj(Request.QueryString["xqi4z"]);
                Session["ServerIP"] = Helpers.SerializSessionItemsObj(Request.QueryString["jbPI0202"]);
                Session["ServerPort"] = Helpers.SerializSessionItemsObj(Request.QueryString["27trp"]);
                Session["MSSREvaluationNoteId"] = Helpers.SerializSessionItemsObj(Request.QueryString["5Sfty21"]);
                Session["MSSRFollowUpNoteId"] = Helpers.SerializSessionItemsObj(Request.QueryString["45vlw93"]);
            }
            Helpers.ExtractCPRSVariables(this, out _inSiteCode, out _inDUZ, out _inDFN, out _inServerIP, out _inServerPort, out _inMSSREvaluationNoteId, out _inMSSRFollowUpNoteId);

            MSSRServiceTO _MSSRServiceTO = Helpers.BuildMSSRServiceTO(_inSiteCode, _inDUZ, _inDFN, _inServerIP, _inServerPort, _inMSSREvaluationNoteId, _inMSSRFollowUpNoteId);

            AddtoSessionMSSRServiceTo(_MSSRServiceTO);

            base.BaseMSSRInstrumentPage_Load(sender, e);

            if (_mssrInstrumentManager.MssrServiceTo != null)
                LabelPatient.Text = _mssrInstrumentManager.MssrServiceTo.PatientName;

            PanelInstrumentList.Visible = true;
            try {
                if (_mssrInstrumentManager.MssrServiceTo != null) {
                    // _mssrInstrumentManager.GetActiveInstrumentList() - RTK - new database driven call to get instrument titles for list
                    
                }
            }
            catch (Exception _ex)
            {
                //Logging.WriteLogToFile("Failure in Instruments Default : " + _ex.Message);
                Exception _mssrlogerror = HandleMSSRException(_ex, "MSSR_Instruments/Default.aspx", "100006", "GridViewInstruments-DataBind()");
            }
        } else {
            MSSRServiceTO _MSSRServiceTO;

            try {
                _MSSRServiceTO = (MSSRServiceTO)Session["MSSRServiceTO"];
                _mssrInstrumentManager.MssrServiceTo = _MSSRServiceTO;
            }
            catch (Exception _ex2)
            {
                //Logging.WriteLogToFile("Failure in Default setting _mssrInstrumentManager.MssrServiceTo: " + _ex2.Message);
                Exception _mssrlogerror = HandleMSSRException(_ex2, "MSSR_Instruments/Default.aspx", "100006", "MSSRServiceTO-Session");
            }
        }
    }

    protected int ConfirmPatient(string sNum) {
        string error = String.Empty;

        int ret = 2; //Default to generic error

        string formattedsnum = sNum.Replace("-", "");

        try {
            if (formattedsnum == _mssrInstrumentManager.MssrServiceTo.PatientSoN)
            {
                if (LabelPatient.Text != _mssrInstrumentManager.MssrServiceTo.PatientName) {
                    ret = 11;
                } else {
                    AddtoSessionSSN(formattedsnum);

                    PatientManager pManager = new PatientManager();
                    string patICN = pManager.GetPatientICNBySnum(formattedsnum);

                    if (!string.IsNullOrEmpty(patICN)) {

                        int patientICN;
                        Int32.TryParse(patICN, out patientICN);

                        checkAndAddPatientToMssr(patientICN);

                        return 0;
                    } else {
                        Survey_Patient surveyPatient = new Survey_Patient();
                        surveyPatient.SetAsChangeTrackingRoot(EntityState.New, true);
                        surveyPatient.PATIENT_ICN = _mssrInstrumentManager.MssrServiceTo.PatientICN;

                        if (String.IsNullOrEmpty(surveyPatient.PATIENT_ICN)) {
                            error = "Patient's record cannot be added to the Registries database because the ICN identifier is blank; contact your Registries Administrator for assistance.";
                            DisplayErrorMessage(error);
                            return 1;
                        } else {

                            int patientICN;
                            Int32.TryParse(surveyPatient.PATIENT_ICN, out patientICN);

                            checkAndAddPatientToMssr(patientICN);

                            try {
                                surveyPatient.STD_INSTITUTION_ID = Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientLocationId);
                            } catch (Exception e) {

                                Logging.WriteLogToFile("Failure in default ConfirmPatient setting std inst id: " + e.Message);
                                //Invalid value. Ignore error and leave the STD_INSTITUTION_ID field blank
                            }
                            surveyPatient.Snum = _mssrInstrumentManager.MssrServiceTo.PatientSoN;
                            try {
                                surveyPatient.BIRTH_DATE = Convert.ToDateTime(_mssrInstrumentManager.MssrServiceTo.PatientDOB.Insert(4, "-").Insert(7, "-"));
                            } catch (Exception e) {

                                Logging.WriteLogToFile("Failure in default ConfirmPatient setting birthdate: " + e.Message);
                                //Invalid value. Ignore error and leave the BIRTH_DATE field blank
                            }
                            fillPatientNameFields(ref surveyPatient, _mssrInstrumentManager.MssrServiceTo.PatientName);
                            surveyPatient.GENDER = _mssrInstrumentManager.MssrServiceTo.PatientGender;
                            surveyPatient.STA6N = _mssrInstrumentManager.MssrServiceTo.STA6N;
                            surveyPatient.DFN = _mssrInstrumentManager.MssrServiceTo.PatientDFN;

                            if (!pManager.AddSurveyPatient(surveyPatient)) {
                                error = "Unable to add Patient record to the Registries database; contact your Registries Administrator for assistance.";
                                DisplayErrorMessage(error);

                                ret = 1;
                            } else {
                                ret = 0;
                            }
                        }
                    }
                }
            } else {
                //Make sure there is no application context corruption
                if (Helpers.DeSerializSessionItems(Session["ConfirmedSSN"]) != null)
                {
                    if (Helpers.DeSerializSessionItems(Session["ConfirmedSSN"]) != formattedsnum)
                    {
                        ret = 11;
                    }
                } else {
                    if (LabelPatient.Text != _mssrInstrumentManager.MssrServiceTo.PatientName) {
                        ret = 11;
                    } else {
                        //provide message that ssn is not correct - verify correct patient is selected in CPRS
                        error = "The SSN entered does not match the patient that you had selected in CPRS.  Please re-confirm the SSN.";
                        DisplayErrorMessage(error);

                        ret = 1;
                    }
                }
            }
        } catch (Exception ex) {

            //Logging.WriteLogToFile("Failure in default ConfirmPatient: " + ex.Message);
            //Keep default error code
            Exception _mssrlogerror = HandleMSSRException(ex, "MSSR_Instruments/Default.aspx", "100006", "ConfirmPatient()");
        }

        return ret;
    }

    private void checkAndAddPatientToMssr(int patientICN)
    {
        // check to see if patient is in MSSR Registry
        if (patientICN > 0)
        {
            MSSR_PATIENT_DEM mssrPatient = MSSRPatientManager.GetPatientByPatientICN(patientICN);
            if (mssrPatient == null)
            {
                // insert new patient into database.
                try
                {

                    decimal pAge = 0;
                    string fName = null;
                    string lName = null;

                    DateTime? pDOB = null;
                    DateTime? pDOD = null;
                    CultureInfo provider = CultureInfo.InvariantCulture;

                    Decimal.TryParse(_mssrInstrumentManager.MssrServiceTo.PatientAge, out pAge);

                    // format dates
                    if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientDOB))
                    {
                        try
                        {
                            pDOB = DateTime.ParseExact(_mssrInstrumentManager.MssrServiceTo.PatientDOB, "yyyyMMdd", provider);
                        }
                        catch (Exception ex)
                        {
                            Logging.WriteLogToFile("Failure in default setting pDOB: " + ex.Message);

                            // fail silently - do not populate variable
                        }
                    }

                    if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientDOD))
                    {
                        try
                        {
                            pDOD = DateTime.ParseExact(_mssrInstrumentManager.MssrServiceTo.PatientDOD, "yyyyMMdd", provider);
                        }
                        catch (Exception ex)
                        {
                            Logging.WriteLogToFile("Failure in default setting pDOD: " + ex.Message);
                            // fail silently - do not populate variable
                        }
                    }

                    // parse names
                    if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientName))
                    {
                        string[] names = _mssrInstrumentManager.MssrServiceTo.PatientName.Split(',');
                        fName = names[1].Trim().ToUpper();
                        lName = names[0].Trim().ToUpper();
                    }

                    mssrPatient = new MSSR_PATIENT_DEM()
                    {
                        Age = (pAge > 0) ? (decimal?)pAge : null,
                        City = _mssrInstrumentManager.MssrServiceTo.PatientCity,
                        DateOfBirth = pDOB,
                        DateOfDeath = pDOD,
                        Ethnicity = _mssrInstrumentManager.MssrServiceTo.PatientEthnicity,
                        Gender = (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientGender)) ? (char?)_mssrInstrumentManager.MssrServiceTo.PatientGender.ToUpper()[0] : null,
                        MaritalStatus = _mssrInstrumentManager.MssrServiceTo.PatientMaritalStatus,
                        PatientFirstName = fName,
                        PatientICN = Convert.ToInt32(_mssrInstrumentManager.MssrServiceTo.PatientICN),
                        PatientLastName = lName,
                        PatientName = _mssrInstrumentManager.MssrServiceTo.PatientName,
                        PatientSID = null,
                        PatientSSN = _mssrInstrumentManager.MssrServiceTo.PatientSoN,
                        Race = _mssrInstrumentManager.MssrServiceTo.PatientRace,
                        Region = _mssrInstrumentManager.MssrServiceTo.PatientRegion, // always 0 now, not being set in service
                        Religion = _mssrInstrumentManager.MssrServiceTo.PatientReligion,
                        State = _mssrInstrumentManager.MssrServiceTo.PatientState
                    };

                    // insert into CRS db (MSSR)
                    using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                    {
                        ctx.MSSR_PATIENT_DEMs.InsertOnSubmit(mssrPatient);
                        ctx.SubmitChanges();
                    }
                    //Insert into MSSRE table
                    int result = 0;
                    using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                    {
                        result = ctx.SP_InsertDemData(_mssrInstrumentManager.MssrServiceTo.PatientICN.Trim());
                    }

                    Logging.WriteLogToFile("Default.aspx checkAndAddPatientToMssr(paitentIcn) Added: " + patientICN);
                }
                catch (Exception ex)
                {
                    Logging.WriteLogToFile("Failure in Default.aspx checkAndAddPatientToMssr(paitentIcn: " + ex.Message);
                    // TODO: Log Error.
                }
            }
            else
            {
                // Update existing record
                try
                {
                    // update record
                    using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
                    {
                        MSSR_PATIENT_DEM mssrPatient2 = ctx.MSSR_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == patientICN);//MSSRPatientManager.GetPatientByPatientICN(patientICN);

                        decimal pAge = 0;
                        string fName = null;
                        string lName = null;

                        DateTime? pDOB = null;
                        DateTime? pDOD = null;
                        CultureInfo provider = CultureInfo.InvariantCulture;

                        Decimal.TryParse(_mssrInstrumentManager.MssrServiceTo.PatientAge, out pAge);

                        // format dates
                        if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientDOB))
                        {
                            try
                            {
                                pDOB = DateTime.ParseExact(_mssrInstrumentManager.MssrServiceTo.PatientDOB, "yyyyMMdd", provider);
                            }
                            catch (Exception ex)
                            {
                                Logging.WriteLogToFile("Failure in default setting pDOB: " + ex.Message);

                                // fail silently - do not populate variable
                            }
                        }

                        if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientDOD))
                        {
                            try
                            {
                                pDOD = DateTime.ParseExact(_mssrInstrumentManager.MssrServiceTo.PatientDOD, "yyyyMMdd", provider);
                            }
                            catch (Exception ex)
                            {
                                Logging.WriteLogToFile("Failure in default setting pDOD: " + ex.Message);
                                // fail silently - do not populate variable
                            }
                        }

                        // parse names
                        if (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientName))
                        {
                            string[] names = _mssrInstrumentManager.MssrServiceTo.PatientName.Split(',');
                            fName = names[1].Trim().ToUpper();
                            lName = names[0].Trim().ToUpper();
                        }

                        mssrPatient2.Age = (pAge > 0) ? (decimal?)pAge : null;
                        mssrPatient2.City = _mssrInstrumentManager.MssrServiceTo.PatientCity;
                        mssrPatient2.DateOfBirth = pDOB;
                        mssrPatient2.DateOfDeath = pDOD;
                        //mssrPatient2.Ethnicity = _mssrInstrumentManager.MssrServiceTo.PatientEthnicity;
                        mssrPatient2.Gender = (!String.IsNullOrEmpty(_mssrInstrumentManager.MssrServiceTo.PatientGender)) ? (char?)_mssrInstrumentManager.MssrServiceTo.PatientGender.ToUpper()[0] : null;
                        mssrPatient2.MaritalStatus = _mssrInstrumentManager.MssrServiceTo.PatientMaritalStatus;
                        mssrPatient2.PatientFirstName = fName;
                        mssrPatient2.PatientLastName = lName;
                        mssrPatient2.PatientName = _mssrInstrumentManager.MssrServiceTo.PatientName;
                        //mssrPatient2.Race = _mssrInstrumentManager.MssrServiceTo.PatientRace;
                        mssrPatient2.Region = _mssrInstrumentManager.MssrServiceTo.PatientRegion;
                        mssrPatient2.State = _mssrInstrumentManager.MssrServiceTo.PatientState;

                        ctx.SubmitChanges();                        
                    }

                    Logging.WriteLogToFile("Default.aspx checkAndAddPatientToMssr(paitentIcn) Updated: " + patientICN);
                }
                catch (Exception ex)
                {
                    Logging.WriteLogToFile("Failure in Default.aspx checkAndAddPatientToMssr(paitentIcn: " + ex.Message);
                    // TODO: Log Error.
                }
            }


        }
    }

    /// <summary>
    /// Fired upon clicking the continue button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnStartAssessment_Click(object sender, EventArgs e) {
        try {
            Page.Validate();

            if (Page.IsValid) {
                int errCode = ConfirmPatient(TextBoxSSNConfirm.Text.Trim());
                switch (errCode) {
                    case 0:
                        // only one instrument for mssr - msat
                        _mssrInstrumentManager.MssrServiceTo.SelectedInstrumentType =
                            (from i in _mssrInstrumentManager.GetActiveInstrumentList()
                             select i).FirstOrDefault();

                        AddtoSessionMSSRServiceTo(_mssrInstrumentManager.MssrServiceTo);

                        //Retrieve status of comprehensive survey
                        string status = String.Empty;
                        SURVEY survey = null;

                        //var surveys = _mssrInstrumentManager.SelectByPatientICNAndSurveyType(_mssrInstrumentManager.MssrServiceTo.PatientICN, 30, false).ToList();

                        //if (surveys.Count > 0) {
                        //    survey = surveys.First();
                        //    if (survey.SURVEY_STATUS != null) {
                        //        status = survey.SURVEY_STATUS.ToLower();
                        //    }
                        //}

                        if (status == "completed") {
                            if (survey != null) {
                                Session["survey"] = Helpers.SerializeSurvey(survey);//.Serialize<SURVEY>();
                                Session["ViewOnly"] = true;
                            }

                            Response.Redirect("MSAssessmentNoteSummary.aspx", false);
                        } else {
                            Response.Redirect("ProgressNoteSetup.aspx", false);
                        }

                        break;
                    case 1:
                        break; // Corresponds to popping an alert 
                    default:
                        //Display error message to user
                        Response.Redirect(string.Format("Warning.aspx?err={0}", errCode), false);
                        break;
                }
            } else {
                string errMsg = "";

                foreach (IValidator aValidator in this.Validators) {
                    if (!aValidator.IsValid) {
                        errMsg = aValidator.ErrorMessage;
                    }
                }

                if (errMsg != "")
                    ShowAlert(errMsg);
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in default btnStartAssessment_Click: " + ex.Message);
            //Keep default error code
            Exception _mssrlogerror = HandleMSSRException(ex, "MSSR_Instruments/Default.aspx", "100006", "GridViewInstruments_RowCommand()");
        }
    }

    protected void GridViewInstruments_RowCommand(object sender, GridViewCommandEventArgs e) {
        
    }

    protected void ShowAlert(string message) {
        try {
            string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
            ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in default ShowAlert: " + ex.Message);
            //Keep default error code
            Exception _mssrlogerror = HandleMSSRException(ex, "MSSR_Instruments/Default.aspx", "100006", "ShowALert()");
        }
    }

    #endregion

    #region Private Methods

    private void DisplayErrorMessage(string sErrorMessage) {
        try {
            if (!LabelWarningNotificationMessage.Visible) {
                LabelWarningNotificationMessage.Visible = true;
                LabelWarningNotificationMessage.Text = sErrorMessage;

                StringBuilder oErrorScript = new StringBuilder();
                string sScript1 = @"<script type=""text/javascript"" language=""JavaScript"">";
                string sScript2a = @" alert('";
                string sScript2b = @"')";
                string sScript3 = @"</script>";
                oErrorScript.AppendLine(sScript1);
                oErrorScript.Append(sScript2a);


                oErrorScript.Append(sErrorMessage.Replace("'", "\\'"));

                oErrorScript.AppendLine(sScript2b);
                oErrorScript.AppendLine(sScript3);

                ClientScript.RegisterStartupScript(this.GetType(), "AlertMessage", oErrorScript.ToString());

                return;
            } else {
                LabelWarningNotificationMessage.Visible = false;
            }
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in default DisplayErrorMessage: " + ex.Message);
            //Keep default error code
            Exception _mssrlogerror = HandleMSSRException(ex, "MSSR_Instruments/Default.aspx", "100006", "DisplayErrorMessage()");
        }
    }

    private void fillPatientNameFields(ref Survey_Patient surveyPatient, string fullName) {
        string name;
        string firstName = "";
        string middleName = "";
        string lastName = "";
        int commaPosition;
        int spacePosition;

        try {
            name = fullName.Trim();
            commaPosition = name.IndexOf(",");
            if (commaPosition < 0)
                commaPosition = name.Length;

            lastName = name.Substring(0, commaPosition);

            try {
                name = fullName.Substring(commaPosition + 1).Trim();

                spacePosition = name.IndexOf(" ");
                if (spacePosition < 0)
                    spacePosition = name.Length;

                firstName = name.Substring(0, spacePosition).Trim();
                middleName = name.Substring(spacePosition + 1).Trim();
            } catch {
                //Ignore error
            }

            surveyPatient.FIRST_NAME = firstName;
            surveyPatient.MIDDLE_NAME = middleName;
            surveyPatient.LAST_NAME = lastName;
        }
        catch (Exception ex)
        {
            //Logging.WriteLogToFile("Failure in default fillPatientNameFields: " + ex.Message);
            //Keep default error code
            Exception _mssrlogerror = HandleMSSRException(ex, "MSSR_Instruments/Default.aspx", "100006", "fillPatientNameFields()");
        }
    }

    #endregion
}