﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class MSSR_Instruments_DataEntryWizard : System.Web.UI.Page {
    protected void Page_Load(object sender, EventArgs e) {
        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        setBreadCrumb();
    }

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb() {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "<a href=\"Default.aspx\" style=\"color:#FFFFFF;\" title=\"Return to MSSR Registry Instrument Home\">MSSR Instruments</a> > Filter Results";
    }

    /// <summary>
    /// Event fired when assessment type radio button is changed.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblAssessmentType_SelectedIndexChanged(object sender, EventArgs e) {
        switch (rblAssessmentType.SelectedValue.ToLower()) {
            case "baseline":
                pnlAnnual.Visible = pnlInterim.Visible = pnlMedicationOnly.Visible = false;
                pnlBaseline.Visible = true;
                break;
            case "annual":
                pnlBaseline.Visible = pnlInterim.Visible = pnlMedicationOnly.Visible = false;
                pnlAnnual.Visible = true;
                break;
            case "interim":
                pnlAnnual.Visible = pnlBaseline.Visible = pnlMedicationOnly.Visible = false;
                pnlInterim.Visible = true;
                break;
            case "medicationonly":
                pnlAnnual.Visible = pnlInterim.Visible = pnlBaseline.Visible = false;
                pnlMedicationOnly.Visible = true;
                break;
            default:
                break;
        }
    }

    /// <summary>
    /// Fired when Baseline Checkbox for the year a patient reached EDMUS Score of 6.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineYearPatientReachedEdmus6_CheckedChanged(object sender, EventArgs e) {
        pnlBaselinePatientEdmus6Date.Enabled = chkBoxBaselineYearPatientReachedEdmus6.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for the year a patient reached EDMUS Score of 8.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineYearPatientReachedEdmus8_CheckedChanged(object sender, EventArgs e) {
        pnlBaselinePatientEdmus8Date.Enabled = chkBoxBaselineYearPatientReachedEdmus8.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for showing Expanded MS Medication History is checked
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineExpandedMSMedicationHistory_CheckedChanged(object sender, EventArgs e) {
        pnlBaselineExpandedMSMedicationHistory.Visible = chkBoxBaselineExpandedMSMedicationHistory.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Neutralizing Interferon Antibody status is checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineNeutralizingInterferonAntibody_CheckedChanged(object sender, EventArgs e) {
        pnlBaselineNeutralizingInterferonAntibody.Visible = chkBoxBaselineNeutralizingInterferonAntibody.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Other DMT Medications checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineOtherDMTMedications_CheckedChanged(object sender, EventArgs e) {
        cblBaselineOtherDMTMedications.Enabled = chkBoxBaselineOtherDMTMedications.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Corticosteroids checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineCorticosteroids_CheckedChanged(object sender, EventArgs e) {
        cblBaselineCorticosteroids.Enabled = chkBoxBaselineCorticosteroids.Checked;
    }
}
