﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;

public partial class MSSR_Instruments_DataEntryTabular : BaseMSSRInstrumentPage {

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    //VeteransAffairs.Registries.BusinessManager.TBI.InstrumentType instrumentType = new VeteransAffairs.Registries.BusinessManager.TBI.InstrumentType();

    protected int _surveyTypeId = 30; // Database Id for Instrument

    //SURVEY _survey;   // the root object in the Survey set
    //SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    #region Public Methods

    /// <summary>
    /// Default Constructor
    /// </summary>
    public MSSR_Instruments_DataEntryTabular() {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Page_Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        setBreadCrumb();

        MSSRServiceTO _mssrServiceTo;

        try {
            _mssrServiceTo = (MSSRServiceTO)Session["MSSRServiceTO"];
            _mssrInstrumentManager.MssrServiceTo = _mssrServiceTo;

            string instTitle = _mssrInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            //LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            //LabelInstrumentTitle.Text = instTitle;
            //Page.Title = "TBI Instruments - " + instTitle;

            if (_mssrInstrumentManager.MssrServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = _mssrInstrumentManager.MssrServiceTo.UserName;
                lblGender.Text = _mssrInstrumentManager.MssrServiceTo.PatientGender;

                //LabelPatient.Text = _tbiInstrumentManager.TbiServiceTo.PatientName;
                //LabelSSN.Text = _tbiInstrumentManager.TbiServiceTo.PatientSSN;
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleMSSRException(ex, "DataEntryTabular.aspx", "100027", "SESSIOENDED");

            //Logging.WriteLogToFile("Failure in DataEntryTabular PageLoad: " + ex.Message);

            Response.Redirect("Warning.aspx?err=2", false);
        }

        QuestionList = GetAllQuestionsForSurvey();
        
        #region Set Labels and Questions

        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");

        #endregion
    }

    /// <summary>
    /// Event fired when assessment type radio button is changed.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblAssessmentType_SelectedIndexChanged(object sender, EventArgs e) {
        StringBuilder healthFactorString = new StringBuilder(); // to store string of heath factors.
        string selectedItem = rblAssessmentType.SelectedItem.Text.ToLower();

        if (selectedItem.Contains("medications only")) {
            healthFactorString.Append("MSCOE.MEDICATIONS ONLY ASSESSMENT"); // appending assessment type
            pnlAnnual.Visible = pnlInterim.Visible = pnlBaseline.Visible = false;
            pnlMedicationOnly.Visible = true;

        } else if (selectedItem.Contains("annual assessment")) {
            healthFactorString.Append("MSCOE.ANNUAL ASSESSMENT"); // appending assessment type
            pnlBaseline.Visible = pnlInterim.Visible = pnlMedicationOnly.Visible = false;
            pnlAnnual.Visible = true;

        } else if (selectedItem.Contains("interim assessment")) {
            healthFactorString.Append("MSCOE.INTERIM ASSESSMENT"); // appending assessment type
            pnlAnnual.Visible = pnlBaseline.Visible = pnlMedicationOnly.Visible = false;
            pnlInterim.Visible = true;

        } else if (selectedItem.Contains("baseline assessment")) {
            healthFactorString.Append("MSCOE.BASELINE ASSESSMENT"); // appending assessment type
            pnlAnnual.Visible = pnlInterim.Visible = pnlMedicationOnly.Visible = false;
            pnlBaseline.Visible = true;

        } 

        txtHealthFactors.Text = healthFactorString.ToString();
    }

    /// <summary>
    /// Fired when Baseline Checkbox for the year a patient reached EDMUS Score of 6.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineYearPatientReachedEdmus6_CheckedChanged(object sender, EventArgs e) {
        pnlBaselinePatientEdmus6Date.Enabled = chkBoxBaselineYearPatientReachedEdmus6.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for the year a patient reached EDMUS Score of 8.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineYearPatientReachedEdmus8_CheckedChanged(object sender, EventArgs e) {
        pnlBaselinePatientEdmus8Date.Enabled = chkBoxBaselineYearPatientReachedEdmus8.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for showing Expanded MS Medication History is checked
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineExpandedMSMedicationHistory_CheckedChanged(object sender, EventArgs e) {
        pnlBaselineExpandedMSMedicationHistory.Visible = chkBoxBaselineExpandedMSMedicationHistory.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Neutralizing Interferon Antibody status is checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineNeutralizingInterferonAntibody_CheckedChanged(object sender, EventArgs e) {
        pnlBaselineNeutralizingInterferonAntibody.Visible = chkBoxBaselineNeutralizingInterferonAntibody.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Other DMT Medications checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineOtherDMTMedications_CheckedChanged(object sender, EventArgs e) {
        cblBaselineOtherDMTMedications.Enabled = chkBoxBaselineOtherDMTMedications.Checked;
    }

    /// <summary>
    /// Fired when Baseline Checkbox for Corticosteroids checked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxBaselineCorticosteroids_CheckedChanged(object sender, EventArgs e) {
        cblBaselineCorticosteroids.Enabled = chkBoxBaselineCorticosteroids.Checked;
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Update Note Preview clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpdateNotePreview_Click(object sender, EventArgs e) {
        processAssessment();
    }

    /// <summary>
    /// Update Health Factors clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnUpdateHealthFactors_Click(object sender, EventArgs e) {
        processAssessment();
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb() {
        //Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        //LabelBreadCrumb.Text = "<a href=\"Default.aspx\" style=\"color:#FFFFFF;\" title=\"Return to MSSR Registry Instrument Home\">MSSR Instruments</a> > Filter Results";
    }

    /// <summary>
    /// processAssessment: contains logic to parse the selected values and provide a note summary and health factor summary.
    /// </summary>
    /// <returns>SURVEY object of all saved data.</returns>
    private SURVEY processAssessment() {
        
        #region Variable Declaration

        SURVEY survey = new SURVEY();
        SURVEY_RESULT _surveyResult = new SURVEY_RESULT();
        StringBuilder healthFactorString = new StringBuilder(); // to store string of heath factors. (comma separated values)
        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

        string selectedItem = rblAssessmentType.SelectedItem.Text.ToLower();

        #endregion

        #region Health Factor Creation

        if (selectedItem.Contains("baseline")) {
            
            #region Process Baseline Assessment

            healthFactorString.Append("MSCOE.BASELINE ASSESSMENT"); // appending assessment type

            #region Determine Interview Type - MSCOE.INTERVIEW.FACE TO FACE, MSCOE.INTERVIEW.TELEPHONE, MSCOE.INTERVIEW.VIDEO CONFERENCE

            if (rblBaselineQ2.SelectedItem != null) {
                string interviewTypeHF = getInterviewTypeHealthFactor(rblBaselineQ2.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(interviewTypeHF)) {
                    interviewTypeHF = ", " + interviewTypeHF;
                }
                healthFactorString.Append(interviewTypeHF);
            }
            
            #endregion

            #region Determine Race as defined by patient - MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE / MSCOE.RACE.ASIAN / MSCOE.RACE.BLACK/AFRICAN AMERICAN / MSCOE.RACE.OTHER / MSCOE.RACE.PACIFIC ISLANDER / MSCOE.RACE.WHITE

            if (rblBaselineQ3.SelectedItem != null) {
                string raceHF = getRaceHealthFactor(rblBaselineQ3.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(raceHF)) {
                    raceHF = ", " + raceHF;
                }
                healthFactorString.Append(raceHF);
            }

            #endregion

            #region Determine Ethnicity as defined by patient - MSCOE.ETHNICITY.HISPANIC / MSCOE.ETHNICITY.NON HISPANIC

            if (rblBaselineQ4.SelectedItem != null) {
                string ethnicityHF = getEthnicityHealthFactor(rblBaselineQ4.SelectedItem.Text.ToLower());
                if (!String.IsNullOrEmpty(ethnicityHF)) {
                    ethnicityHF = ", " + ethnicityHF;
                }
                healthFactorString.Append(ethnicityHF);
            }

            #endregion

            //#region Determine Ethnicity as defined by patient - MSCOE.ETHNICITY.HISPANIC / MSCOE.ETHNICITY.NON HISPANIC

            //if (rblBaselineQ3.SelectedItem != null) {
            //    string ethnicityHF = getEthnicityHealthFactor(rblBaselineQ3.SelectedItem.Text.ToLower());
            //    if (!String.IsNullOrEmpty(ethnicityHF)) {
            //        ethnicityHF = ", " + ethnicityHF;
            //    }
            //    healthFactorString.Append(ethnicityHF);
            //}

            //#endregion

            #endregion

        } else if (selectedItem.Contains("annual")) {
            
            #region Process Annual Assessment

            healthFactorString.Append("MSCOE.ANNUAL ASSESSMENT"); // appending assessment type

            #endregion

        } else if (selectedItem.Contains("interim")) {
            
            #region Process Interim Assessment

            healthFactorString.Append("MSCOE.INTERIM ASSESSMENT"); // appending assessment type

            #endregion

        } else if (selectedItem.Contains("medication")) {
            
            #region Process Medication Only (Ad hoc) Assessment

            healthFactorString.Append("MSCOE.MEDICATIONS ONLY ASSESSMENT"); // appending assessment type

            #endregion

        }

        txtHealthFactors.Text = healthFactorString.ToString();

        #endregion

        #region Survey Result Creation

        // Question 1
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 1 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblAssessmentType.SelectedValue);
            _surveyResult.RESULT_TEXT = rblAssessmentType.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        } catch (Exception surveyEx) {

            //Logging.WriteLogToFile("Failure in DataEntryTabular ProcessAssessment Q1: " + surveyEx.Message);

            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSSR_Instruments/DataEntryTabular.aspx", "100027", "processAssessment() - Question 1");
        }

        // Question 2
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 2 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblBaselineQ2.SelectedValue);
            _surveyResult.RESULT_TEXT = rblBaselineQ2.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            //Logging.WriteLogToFile("Failure in DataEntryTabular ProcessAssessment Q2: " + surveyEx.Message);
            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSSR_Instruments/DataEntryTabular.aspx", "100027", "processAssessment() - Question 2");
        }

        // Question 3
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 3 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblBaselineQ3.SelectedValue);
            _surveyResult.RESULT_TEXT = rblBaselineQ3.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            //Logging.WriteLogToFile("Failure in DataEntryTabular ProcessAssessment Q3: " + surveyEx.Message);

            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSSR_Instruments/DataEntryTabular.aspx", "100027", "processAssessment() - Question 3");
        }

        // Question 4
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question 4 choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblBaselineQ4.SelectedValue);
            _surveyResult.RESULT_TEXT = rblBaselineQ4.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            //Logging.WriteLogToFile("Failure in DataEntryTabular ProcessAssessment Q4: " + surveyEx.Message);

            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSSR_Instruments/DataEntryTabular.aspx", "100027", "processAssessment() - Question 4");
        }

        // Question HF - store health factors
        STD_QUESTION questionHF = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "HF");
        _surveyResult = new SURVEY_RESULT();

        try {
            // Add Question HF choice
            _surveyResult.STD_QUESTION_CHOICE_ID = questionHF.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = healthFactorString.ToString();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            //Logging.WriteLogToFile("Failure in DataEntryTabular ProcessAssessment HF: " + surveyEx.Message);

            Exception _tbilogerror = HandleMSSRException(surveyEx, "MSSR_Instruments/DataEntryTabular.aspx", "100027", "processAssessment() - Question HF");
        }

        #endregion

        return survey;
    }

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _mssrInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    #region Process Assessment Health Factor Sections

    /// <summary>
    /// Returns the Health Factor String for Interview Type
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getInterviewTypeHealthFactor(string selectedText) {
        if (selectedText.Contains("telephone")) {
            return "MSCOE.INTERVIEW.TELEPHONE";
        } else if (selectedText.Contains("video")) {
            return "MSCOE.INTERVIEW.VIDEO CONFERENCE";
        } else if (selectedText.Contains("in person")) {
            return "MSCOE.INTERVIEW.FACE TO FACE";
        } else {
            return "";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Race
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getRaceHealthFactor(string selectedText) {
        if (selectedText.Contains("white")) {
            return "MSCOE.RACE.WHITE";
        } else if (selectedText.Contains("black")) {
            return "MSCOE.RACE.BLACK/AFRICAN AMERICAN";
        } else if (selectedText.Contains("pacific islander")) {
            return "MSCOE.RACE.PACIFIC ISLANDER";
        } else if (selectedText.Contains("alaska native")) {
            return "MSCOE.RACE.AMERICAN INDIAN/ALASKA NATIVE";
        } else if (selectedText.Contains("asian")) {
            return "MSCOE.RACE.ASIAN";
        } else if (selectedText.Contains("other")) {
            return "MSCOE.RACE.OTHER";
        } else {
            return "";
        }
    }

    /// <summary>
    /// Returns the Health Factor String for Ethnicity
    /// </summary>
    /// <param name="selectedText"></param>
    /// <returns></returns>
    private string getEthnicityHealthFactor(string selectedText) {
        if (selectedText.Contains("not hispanic")) {
            return "MSCOE.ETHNICITY.NON HISPANIC";
        } else if (selectedText.Contains("hispanic")) {
            return "MSCOE.ETHNICITY.HISPANIC";
        } else {
            return "";
        }
    }

    #endregion

    #endregion
}