﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Linq.Dynamic;
using System.Web.UI.WebControls;
using MSSR.Security;
using VeteransAffairs.Registries.BusinessManager;
using System.Web;
using System.Text;
using AntiXssEnc = Microsoft.Security.Application;




public partial class InprocessSurveys : BasePage
{
    #region Member Variables

   
    private string Location = "";
    //private bool displayOnlyInProcessSurveys = false;
    //private string inprocessSurveys = string.Empty;
    //private readonly string surveyStatus = "inprocess";
    private bool foundRequestVar = false;
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
    protected readonly string exportDestination = "Export/ExportAssessmentToExcel.aspx?";
    #endregion

    #region Public Overrides

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string MenuItemName()
    {
        return "Assessments";
    }

    public override string AppObjectCode()
    {
        return "MSSR ASSESSMENTS";
    }

    #endregion

    #region Protected Methods

  
    protected void Page_Load(object sender, EventArgs e) {

        try {
            var master = this.Master as RegistryMaster;
            if (master != null)
            {
                master.SetDirtyFlag(false);
            }
        } catch (Exception ex) {
            Logging.WriteLogToFile("Failure in Assessments Page_Load: " + ex.Message);
        }

        grdMSAssessments.PageSize = (ddlPageSize.SelectedItem.Value == "-1" ? int.MaxValue : int.Parse(ddlPageSize.SelectedItem.Value));
        if (!IsPostBack) {

            pnlPagingControls.Visible = false;
            populateFacilityDropdownList();
            grdMSAssessments.DataSource = null;
            grdMSAssessments.DataBind();
            
            if (!String.IsNullOrEmpty(Request.QueryString["Location"]))
            {
                Location = Request.QueryString["Location"];
                foundRequestVar = true;
            }           
        }

        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        setBreadCrumb();

        filterData();
    }

   
    protected override void OnPreRender(EventArgs e)
    {
        if (foundRequestVar)
        {
            //Location filter
            if (!String.IsNullOrEmpty(Location))
            {
                ddlFacility.SelectedIndex = -1;
                foreach (ListItem li in ddlFacility.Items)
                {
                    if (li.Text.ToLower().Contains(Location.ToLower()))
                    {
                        li.Selected = true;
                        break;
                    }
                }
            }
        }
        filterData(); // call filter with passed variables.
        base.OnPreRender(e);
    }

    
    protected void btnGo_Click(object sender, EventArgs e)
    {
        HiddenFieldCurrentPageNumber.Value = "0";
        filterData();
    }

    
    protected void btnClear_Click(object sender, EventArgs e)
    {
        txtPatientName.Text = "";
        txtPatientICN.Text = "";
        ddlFacility.SelectedIndex = 0;  

        filterData();
    }

    
    protected void lnkBtnToggleFilters_OnClick(object sender, EventArgs e)
    {
        if (pnlFilterArea.Visible)
        {
            pnlFilterArea.Visible = false;
            lnkBtnToggleFilters.Text = "Show";
        }
        else
        {
            pnlFilterArea.Visible = true;
            lnkBtnToggleFilters.Text = "Hide";
        }
    }

    /// <summary>
    /// Button click to export grid to Excel.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void imgBtnExportToExcel_Click(object sender, System.Web.UI.ImageClickEventArgs e)
    {
        string sortExpression = HiddenFieldSortExpression.Value; // p8
        string sortDirection = HiddenFieldSortDirection.Value; // p9

        // filters - txtPatientName, txtPatientICN, ddlFacility, ddlDiagnosis, ddlCurrentEdmusScore, ddlInterviewCompletedBy, rblRelapses
        string patientName = txtPatientName.Text; // p1
        string patientICN = txtPatientICN.Text; // p2
        string selectedFacility = ddlFacility.SelectedValue; // p3
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.Append("p1=" + Server.UrlEncode(patientName));
        sbUrl.Append("&p2=" + Server.UrlEncode(patientICN));
        sbUrl.Append("&p3=" + Server.UrlEncode(selectedFacility));
        sbUrl.Append("&p8=" + Server.UrlEncode(sortExpression));
        sbUrl.Append("&p9=" + Server.UrlEncode(sortDirection));
      
            string destinationUrl = string.Concat(exportDestination, sbUrl.ToString());
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(AntiXssEnc.Encoder.UrlEncode(destinationUrl));
                Server.Transfer(destinationUrl, false);
            }    

    }


    /// <summary>
    /// Fired when columns are sorted.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSAssessments_Sorting(object sender, GridViewSortEventArgs e) {

        String PatientName = "";
        String PatientICN = "";        
        int Sta3n = 0;
       
        if (!(ddlFacility.SelectedValue == null)) {
            if (ddlFacility.SelectedValue.ToLower() != "all")
                Sta3n = VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(ddlFacility.SelectedValue);
        }       

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {

            var pats = from hf in db.vwGetAllInprocessSurveys
                       select new MssrInprocessSurveyDisplay()
                       {
                           PatientName = hf.PatientName,
                           PatientICN = hf.patient_ICN,
                           Sta3n = hf.stationnumber,
                           SURVEYS_ID = hf.SURVEYS_ID,
                           PATIENT_ID = hf.PATIENT_ID,
                           SURVEY_DATE = hf.SURVEY_DATE,
                           SURVEY_STATUS = hf.SURVEY_STATUS,
                           CREATEDBY = hf.FULL_NAME,
                           Station = hf.NAME
                       };

            pats = pats.OrderByDescending(P => P.SURVEY_DATE);           

            if (!String.IsNullOrEmpty(PatientName)) {
                pats = pats.AsQueryable().Where(eg => eg.PatientName.Contains(PatientName));
            }
            
            if (!String.IsNullOrEmpty(PatientICN)) {
                pats = pats.AsQueryable().Where(eg => eg.PatientICN == PatientICN);                
            }

            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));
            SortDirection direction = e.SortDirection;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value)) {
                if (e.SortExpression == HiddenFieldSortExpression.Value) {
                    if (HiddenFieldSortDirection.Value == "ASC") {
                        HiddenFieldSortDirection.Value = "DESC";
                        direction = SortDirection.Descending;
                    } else {
                        HiddenFieldSortDirection.Value = "ASC";
                        direction = SortDirection.Ascending;
                    }
                } else {
                    HiddenFieldSortDirection.Value = "ASC";
                    direction = SortDirection.Ascending;
                }
            } else {
                HiddenFieldSortDirection.Value = (e.SortDirection == SortDirection.Ascending) ? "ASC" : "DESC";
            }

            var pats2 = pats.OrderBy(e.SortExpression + " " + HiddenFieldSortDirection.Value);
            HiddenFieldSortExpression.Value = e.SortExpression;

            int totalRecords = pats2.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSAssessments.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSAssessments.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSAssessments.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSAssessments.PageSize)) + ")";

         
            grdMSAssessments.RowDataBound += new GridViewRowEventHandler(this.grdMSAssessments_RowDataBound);

            grdMSAssessments.DataSource = pats2.Skip(Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSAssessments.PageSize).Take(grdMSAssessments.PageSize);
            grdMSAssessments.DataBind();

            setEnabledStatusOfPagingControls();

            pnlPagingControls.Visible = true;
        }
    }

    /// <summary>
    /// Fired on row data bound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSAssessments_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        CultureInfo provider = CultureInfo.InvariantCulture;

        foreach (GridViewRow row in grdMSAssessments.Rows)
        {
            if (row.RowType == DataControlRowType.DataRow)
            {
                if (row.RowType == DataControlRowType.Header)
                {
                    e.Row.CssClass = "locked";
                }
            }
        }
    }

    /// <summary>
    /// Fired on row created - to create merged cells at top of table.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSAssessments_RowCreated(object sender, GridViewRowEventArgs e)
    {
        
    }

    /// <summary>
    /// Returns patient name for the given ICN
    /// </summary>
    /// <param name="patientIcn"></param>
    /// <returns></returns>
    protected string GetPatientName(object patientIcn)
    {
        if (patientIcn != null)
        {
            int patIcn = Convert.ToInt32(patientIcn);
            using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
            {
                MSSR_PATIENT_DEM pat = ctx.MSSR_PATIENT_DEMs.FirstOrDefault(P => P.PatientICN == patIcn);

                if (pat != null)
                {
                    return pat.PatientName;
                }
            }
        }
        return "";
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Filter and query performed for data matching filters.
    /// </summary>
    private void filterData()
    {
        
        int Sta3n = 0;
        String PatientName = "";
        String PatientICN = "";
       
        if (!string.IsNullOrEmpty(ddlFacility.SelectedValue))
        {
            if (ddlFacility.SelectedValue.ToLower() != "all")
                Sta3n = VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(ddlFacility.SelectedValue);
        }
        else
        {
            Sta3n = -1;
        }

        PatientName = txtPatientName.Text;
        PatientICN = txtPatientICN.Text;    
        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext())
        {
                     
            var pats = from hf in db.vwGetAllInprocessSurveys
                       select new MssrInprocessSurveyDisplay()
                       {
                           PatientName = hf.PatientName,
                           PatientICN = hf.patient_ICN,
                           Sta3n = hf.stationnumber,                           
                           SURVEYS_ID = hf.SURVEYS_ID,
                           PATIENT_ID = hf.PATIENT_ID,
                           SURVEY_DATE = hf.SURVEY_DATE,
                           SURVEY_STATUS = hf.SURVEY_STATUS,
                           CREATEDBY = hf.FULL_NAME,
                           Station = hf.NAME
                       };


            pats = pats.OrderByDescending(P => P.SURVEY_DATE);
            if (!String.IsNullOrEmpty(PatientName))
            {
                pats = pats.AsQueryable().Where(eg => eg.PatientName.Contains(PatientName));
            }

            if (!String.IsNullOrEmpty(PatientICN))
            {                
                    pats = pats.AsQueryable().Where(eg => eg.PatientICN == PatientICN);                
            }

            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            int totalRecords = pats.Count();
            HiddenFieldTotalRecords.Value = totalRecords.ToString();

            int pageCount = Convert.ToInt32(Math.Ceiling(Convert.ToDecimal(totalRecords) / Convert.ToDecimal(grdMSAssessments.PageSize)));
            HiddenFieldPageCount.Value = pageCount.ToString();

            pnlRecordCount.Visible = true;

            if (!String.IsNullOrEmpty(HiddenFieldSortDirection.Value) && !String.IsNullOrEmpty(HiddenFieldSortExpression.Value))
            {
                pats = pats.OrderBy(HiddenFieldSortExpression.Value + " " + HiddenFieldSortDirection.Value);
            }

            grdMSAssessments.DataSource = pats.Skip(Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSAssessments.PageSize).Take(grdMSAssessments.PageSize);
            grdMSAssessments.DataBind();

            int currentRecord = (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) * grdMSAssessments.PageSize);

            lblPageStatus.Text = "Page " + (Convert.ToInt32(HiddenFieldCurrentPageNumber.Value) + 1) + " of " + HiddenFieldPageCount.Value + ".";
            lblRecordCount.Text = totalRecords + "  (Showing Records " + (currentRecord + 1) + " - " + ((currentRecord + grdMSAssessments.PageSize) > totalRecords ? totalRecords : (currentRecord + grdMSAssessments.PageSize)) + ")";
        }

        setEnabledStatusOfPagingControls();

        pnlPagingControls.Visible = true;
    }

  

    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    private void setBreadCrumb()
    {
        Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
        LabelBreadCrumb.Text = "MSSR Inprocess Assessments";
    }

    /// <summary>
    /// Determines based on the current users role whether
    /// or not the data they see on this screen needs to be filtered down
    /// </summary>
    /// <returns></returns>
    private bool shouldLimitResults()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY))
        {
            return true;
        }
        else
        {
            return false;
        }

    }

    /// <summary>
    /// Returns a list of allowed station ids for users who need
    /// the data on this page to be filtered down
    /// </summary>
    /// <returns></returns>
    private List<string> allowedStations()
    {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    
    private void populateFacilityDropdownList()
    {
        ddlFacility.Items.Clear();
        List<string> limitedStationsList = null;
        if (shouldLimitResults())
            limitedStationsList = allowedStations();

        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            //Get distinct list of station IDs that the current status table has results for
            var distinctStations = from stn in ctx.MSSR_HF_Condenseds
                                   group stn by stn.Sta3n into g
                                   select new { Key = g.Key, Count = g.Count() };
            //Loop through results, and build list to query institution table
            List<string> distinctStationsList = new List<string>();
            foreach (object currItem in distinctStations)
            {
                if (currItem != null)
                {
                    Type t = currItem.GetType();
                    System.Reflection.PropertyInfo pKey = t.GetProperty("Key");
                    string keyValue = pKey.GetValue(currItem, null).ToString();
                    if (limitedStationsList == null || limitedStationsList.Contains(keyValue))
                    {
                        distinctStationsList.Add(keyValue);
                    }
                }
            }

            using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
            {
                var institutions = (from inst in bctx.STD_INSTITUTIONs
                                    where distinctStationsList.Contains(inst.STATIONNUMBER)
                                    orderby inst.VISTANAME
                                    select inst);

                //Get all institution information
                foreach (VeteransAffairs.Registries.Business.STD_INSTITUTION inst in institutions)
                {
                    if (inst.STATIONNUMBER != null)
                        ddlFacility.Items.Add(new ListItem(inst.VISTANAME + " (" + inst.STATIONNUMBER + ")", inst.STATIONNUMBER.ToString()));
                }

                // Insert 'All' option first
                if (!shouldLimitResults())
                {
                    ddlFacility.Items.Insert(0, new ListItem("Any Location", "All"));
                    lblFacFiltered.Visible = false;

                }
                else
                {
                    lblFacFiltered.Visible = true;
                }
            }
        }
    }


    
    /*private string[] getEdmusRangeOptions(int lower, int higher)
    {
        string[] rangeValues = { "1", "2", "3", "4", "5", "6A", "6B", "7", "8", "9" };

        List<string> edmusRangeOptions = new List<string>();
        for (int count = lower; count <= higher; count++)
        {
            edmusRangeOptions.Add(rangeValues[count].ToLower());
        }

        return edmusRangeOptions.ToArray();
    }
    */
    #endregion

    #region Paging Control Methods

  
    protected void btnFirstPage_Click(object sender, EventArgs e)
    {
        HiddenFieldCurrentPageNumber.Value = "0";
        filterData();
    }

    
    protected void btnPrevPage_Click(object sender, EventArgs e)
    {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber > 0)
        {
            currentPageNumber = currentPageNumber - 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

   
    protected void btnNextPage_Click(object sender, EventArgs e)
    {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        if (currentPageNumber < Convert.ToInt32(HiddenFieldPageCount.Value))
        {
            currentPageNumber = currentPageNumber + 1;
            HiddenFieldCurrentPageNumber.Value = currentPageNumber.ToString();
            filterData();
        }
    }

    
    protected void btnLastPage_Click(object sender, EventArgs e)
    {
        int lastPage = Convert.ToInt32(HiddenFieldPageCount.Value);
        lastPage = lastPage - 1;
        HiddenFieldCurrentPageNumber.Value = lastPage.ToString();
        filterData();
    }

   
    private void setEnabledStatusOfPagingControls()
    {
        int currentPageNumber = Convert.ToInt32(HiddenFieldCurrentPageNumber.Value);
        int lastPageNumber = Convert.ToInt32(HiddenFieldPageCount.Value) - 1;

        if (currentPageNumber == 0 && lastPageNumber > 0)
        {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        }
        else if (currentPageNumber == 0 && lastPageNumber == 0)
        {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        }
        else if (currentPageNumber == 1 && lastPageNumber == 1)
        {
            btnFirstPage.Enabled = false;
            btnPrevPage.Enabled = false;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        }
        else if (currentPageNumber > 0 && currentPageNumber < lastPageNumber)
        {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = true;
            btnLastPage.Enabled = true;
        }
        else if (currentPageNumber > 0 && currentPageNumber == lastPageNumber)
        {
            btnFirstPage.Enabled = true;
            btnPrevPage.Enabled = true;
            btnNextPage.Enabled = false;
            btnLastPage.Enabled = false;
        }
    }

    #endregion
}