﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MSSR.Security;
using MSSREnh;
using Telerik.Web.UI;
using VeteransAffairs.Registries.BusinessManager;

public partial class HealthCareResources : BasePage
{
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    { 
        //only adminstrators
        if (!IsUserAdmin())
        {
            Logging.WriteLogToFile("WARNING - NOT Authorized. Healthcare Resouces aspx - Not authorized. Redirecting to error page.");
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        if (!Page.IsPostBack)
        {
            SetBreadCrumb();
            PopulateFacilityDropdownList();
            PopulateMedsDropdownList();

            PopulateRdgrdPatDem(null,null,null, null,null, null);
            PopulateReportSummaryChart(null,null, null,null,null, null);
        }
    }

    private void PopulateRdgrdPatDem(DateTime? startDate, DateTime? endDate, int? stationId, int? relpase, string medName, string medNameAdditional)
    {
        var rMgr = new ReportViewManager();
        rdgrdPatDem.DataSource = rMgr.GetManagerResourcesDetails(startDate, endDate, stationId, relpase, medName, medNameAdditional);
        rdgrdPatDem.DataBind();

    }

    private bool IsUserAdmin()
    {
        bool isUserAdmin = false;
        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            isUserAdmin = true;
        }
        return isUserAdmin;
    }

    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Manage Health Care Resources";
    }

    public override string AppObjectCode()
    {
        return "Manage Health Care Resources";
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = " Manage Health Care Resources ";
        }
    }

    private void PopulateFacilityDropdownList()
    {
        ddlFacility.Items.Clear();
        List<string> limitedStationsList = null;
        if (ShouldLimitResults())
            limitedStationsList = AllowedStations();

        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            //Get distinct list of station IDs that the current status table has results for
            var distinctStations = from stn in ctx.MSSR_CURRENT_STATUS
                                   group stn by stn.Sta3n into g
                                   select new { Key = g.Key, Count = g.Count() };
            //Loop through results, and build list to query institution table
            List<string> distinctStationsList = new List<string>();
            foreach (object currItem in distinctStations)
            {
                if (currItem != null)
                {
                    Type t = currItem.GetType();
                    System.Reflection.PropertyInfo pKey = t.GetProperty("Key");
                    string keyValue = pKey.GetValue(currItem, null).ToString();
                    if (limitedStationsList == null || limitedStationsList.Contains(keyValue))
                    {
                        distinctStationsList.Add(keyValue);
                    }
                }
            }

            using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
            {
                var institutions = (from inst in bctx.STD_INSTITUTIONs
                                    where distinctStationsList.Contains(inst.STATIONNUMBER)
                                    orderby inst.VISTANAME
                                    select inst);

                //Get all institution information
                foreach (VeteransAffairs.Registries.Business.STD_INSTITUTION inst in institutions)
                {
                    if (inst.STATIONNUMBER != null)
                        ddlFacility.Items.Add(new RadComboBoxItem(inst.VISTANAME + " (" + inst.STATIONNUMBER + ")", inst.STATIONNUMBER.ToString()));
                }

                // Insert 'All' option first
                if (!ShouldLimitResults())
                {
                    ddlFacility.Items.Insert(0, new RadComboBoxItem("Any Location", "All"));
                    lblFacFiltered.Visible = false;

                }
                else
                {
                    lblFacFiltered.Visible = true;
                }
            }
        }
    }
    
    private bool ShouldLimitResults()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY))
        {
            return true;
        }
        else
        {
            return false;
        }

    }

    private List<string> AllowedStations()
    {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    private void PopulateMedsDropdownList()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            var results = from meds in ctx.MSSR_MEDICATIONs
                          select meds;

            List<ListItem> liList = new List<ListItem>();
            ListItem liItem = null;
            foreach (MSSR_MEDICATION currMed in (results.ToList()))
            {
                liItem = new ListItem();
                liItem.Value = currMed.ID.ToString();
                liItem.Text = currMed.MEDICATION;
                liList.Add(liItem);
            }

            //Manually add Corticosteroids to the drop down,
            //these items are not dynamic so should not need added to
            //without a coding change anyway
            liItem = new ListItem();
            liItem.Text = "Dexamethasone IV (Decadron)";
            liItem.Value = "100000";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone IV (Solumedrol)";
            liItem.Value = "100001";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Methylprednisolone PO (Medrol)";
            liItem.Value = "100002";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "Prednisone PO";
            liItem.Value = "100003";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "CORTICOSTEROIDS (PREDNISONE) (DEXAMETHASONE)";
            liItem.Value = "PREDNISONE (DEXAMETHASONE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "GLATIRAMER ACETATE";
            liItem.Value = "GLATIRAMER (ACETATE)";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "TERIFLUNOMIDE";
            liItem.Value = "TERIFLUNOMIDE";
            liList.Add(liItem);

            liItem = new ListItem();
            liItem.Text = "NO MEDICATION";
            liItem.Value = "NO MEDICATION";
            liList.Add(liItem);

            liList.Sort((a, b) => string.Compare(a.Text, b.Text));

            ddlMeds.DataSource = liList;
            ddlMeds.DataBind();
            ddlMeds.Items.Insert(0, new RadComboBoxItem("Any Medication", "All"));
        }
    }

    protected void btnGo_Click(object sender, EventArgs e)
    {
        DateTime? startDate = null;
        DateTime? endDate = null;
        int? stationId = null;
        int? relapse = null;
        string medName = null;

        if (rdpStartDate.SelectedDate.HasValue)
        {
            startDate = rdpStartDate.SelectedDate.Value;
        }
        if (rdpEndDate.SelectedDate.HasValue)
        {
            endDate = rdpEndDate.SelectedDate.Value;
        }
        if (!string.IsNullOrEmpty(ddlFacility.SelectedValue))
        {
            stationId = Int32.Parse(ddlFacility.SelectedValue);
        }


        string tempMed = ddlMeds.SelectedValue;
        string tempMedAdditional = string.Empty;
        if (ddlMeds.SelectedIndex != -1)
        {
            medName = ddlMeds.SelectedValue;
        }

        if (!string.IsNullOrEmpty(medName))
        {
            if (tempMed.Contains('(') && tempMed.Contains(')'))
            {
                tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
            }
        }

        PopulateRdgrdPatDem(startDate, endDate, stationId, null, tempMed.Trim(), tempMedAdditional.Trim());
        PopulateReportSummaryChart(startDate, endDate, stationId, relapse, tempMed.Trim(), tempMedAdditional.Trim());

    }

    private void PopulateReportSummaryChart(DateTime? startDate, DateTime? endDate, int? stationId, int? relpase, string medName, string medNameAdditional)
    {

        var rMgr = new ReportViewManager();

        chtHrResourcesSummary.DataSource = rMgr.GetManagerResourcesSummary(startDate, endDate, stationId, relpase, medName, medNameAdditional);
        chtHrResourcesSummary.DataBind();


      
    }
}