﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="HealthCareResources.aspx.cs" Inherits="HealthCareResources" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:radscriptmanager runat="server" id="rdScriptManagerAddPatient" />
    <telerik:radajaxmanager id="radajaxmanagermsat" runat="server" updatepanelsrendermode="Inline" />
    <telerik:radskinmanager runat="server" id="rdSkinptManagerAddPatient" />
    <fieldset>
        <legend>Manage Health Care Resources </legend>
        <div>
            <div style="width: 10%; float: left">Facility</div>
            <div style="float: left">
                <telerik:radcombobox runat="server" tooltip="facitlity" cssclass="telselect" id="ddlFacility" emptymessage="-- Select Station --" />
                <asp:Label ID="lblFacFiltered" Visible="false" runat="server" Font-Size="XX-Small" TabIndex="106"
                    Text="(Facility list has been filtered based on your role.)"></asp:Label>
            </div>
        </div>
        <div style="padding-top: 5px; clear: left">
            <div style="width: 10%; float: left">Visit Date:</div>
            <div style="width: 15%; float: left">
                <telerik:raddatepicker id="rdpStartDate" tooltip="Start Date" mindate="1/1/1900" runat="server" />
            </div>
            <div style="width: 15%; float: left">
                <telerik:raddatepicker id="rdpEndDate" tooltip="End Date" mindate="1/1/1900" runat="server" />
            </div>
        </div>
        <div style="clear: left; padding-top: 5px;">
            <div style="width: 10%; float: left">Medicatiion:</div>
            <div style="width: 10%; float: left">
                <telerik:radcombobox runat="server" cssclass="telselect" id="ddlMeds" emptymessage="-- Select Medication --" />
            </div>
        </div>
        <div style="clear: left">
            <telerik:radbutton id="btnGo" height="25px" runat="server" text="View Results" enabled="true" tooltip="View Results" tabindex="200" onclick="btnGo_Click" />
        </div>

        <fieldset>
            
            <telerik:radhtmlchart runat="server" id="chtHrResourcesSummary" height="425px" transitions="false" 
                skin="Vista">
                <ChartTitle Text="Manage Health Care Resources"/>
                        <PlotArea>
                            <Series>
                                <telerik:ColumnSeries Name="Values" DataFieldY="value">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Manage Health Care Resources<br /> #=dataItem.sourcecolumn#</div>"></TooltipsAppearance>
                                </telerik:ColumnSeries>
                            </Series>
                            <XAxis Name="sourcecolumn" DataLabelsField="sourcecolumn" >
                                <LabelsAppearance ></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="Values" />
                            </YAxis>
                        </PlotArea>
                    </telerik:radhtmlchart>
            <telerik:radgrid id="rdgrdPatDem" runat="server" allowpaging="True" allowsorting="True" grouppanelposition="Top" tooltip="List of Completed Surveys"
                allowmultirowselection="false" pagesize="20">
                <SortingSettings SortedBackColor="#ffffff" />
                <SelectedItemStyle BackColor="#FFE1A4"></SelectedItemStyle>
                <MasterTableView  AllowNaturalSort="true" AllowMultiColumnSorting="true" AllowPaging="True" AllowSorting="True"
                    AutoGenerateColumns="false" ShowHeadersWhenNoRecords="true" CssClass=""
                    PagerStyle-AlwaysVisible="true" TabIndex="0">
                <Columns>
                    <telerik:GridBoundColumn DataField="PatientICN" DataType="System.String"
                            HeaderText="Patient ICN"  />
                    <telerik:GridBoundColumn DataField="PatientFirstName" DataType="System.String"
                            HeaderText="First Name"   />
                    <telerik:GridBoundColumn DataField="PatientLastName" DataType="System.String"
                            HeaderText="Last Name"  />
                    <telerik:GridBoundColumn DataField="Age" DataType="System.Decimal"
                            HeaderText="Age"  />
                    <telerik:GridBoundColumn DataField="Gender" DataType="System.String"
                            HeaderText="Gender"  />
                    <telerik:GridBoundColumn DataField="Race" DataType="System.String"
                            HeaderText="Race"  /> 
                    <telerik:GridBoundColumn DataField="Ethnicity" DataType="System.String"
                            HeaderText="Ethnicity"  /> 
                    <telerik:GridBoundColumn DataField="VISTANAME" DataType="System.String"
                            HeaderText="Facility"  /> 
                    <telerik:GridBoundColumn DataField="RxEverAll" DataType="System.String"
                            HeaderText="Meds"  /> 
                </Columns>
                 </MasterTableView>
             <PagerStyle Mode="NumericPages" Position="Bottom" />
            </telerik:radgrid>
        </fieldset>
    </fieldset>
</asp:Content>

