﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="FeeInpatient.aspx.cs" Inherits="FeeInpatient" Title="MSSR: FeeInpatient" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <style type="text/css">
        .filterPanel
        {
            width: 99%;
            border: 2px solid #333333;
            background-color: #F7F7F7;
        }
        /*
        .filterPanel td 
        {
        	padding-bottom:7px;
        }
        */</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <%--<asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <Triggers>
            <asp:PostBackTrigger ControlID="imgBtnExportToExcel" />
        </Triggers>
        <ContentTemplate>
            <asp:UpdateProgress ID="UpdateProgress1" runat="server">
                <ProgressTemplate>
                    <div style="padding: 5px;">
                        <img src="images/ajax-loader.gif" alt="Loading Image" />
                        Loading, Please Wait ...
                    </div>
                </ProgressTemplate>
            </asp:UpdateProgress>--%>
            <!-- Hidden Variables for Paging -->
            <asp:HiddenField ID="HiddenFieldCurrentPageNumber" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldPageCount" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldTotalRecords" runat="server" Value="0" Visible="false" />
            <asp:HiddenField ID="HiddenFieldSortExpression" runat="server" Value="" Visible="false" />
            <asp:HiddenField ID="HiddenFieldSortDirection" runat="server" Value="" Visible="false" />
            <div class="excludeSaveWarnings" style="background-color: #333333; color: #FFFFFF; width: 99%; font-size: 10.5pt;
                font-weight: bold; border: 2px solid #333333; border-bottom: 1px solid #333333;">
                &nbsp; Filters
                <asp:Button ID="lnkBtnToggleFilters" runat="server" Text="Hide" ToolTip="Click to show/hide filters."
                    OnClick="lnkBtnToggleFilters_OnClick" TabIndex="101" />
            </div>
            <asp:Panel ID="pnlFilterArea" runat="server" CssClass="filterPanel">
                <div class="excludeSaveWarnings">
                <table style="width: 100%; padding: 5px;">
                    <tr>
                     
                        <td style="width: 25%;">
                            <asp:Label ID="LabelForPatientName" runat="server" AssociatedControlID="txtPatientName" TabIndex="103" 
                                CssClass="FilterLabel">
                                Patient Name
                            </asp:Label>:
                            <br />
                            <asp:TextBox ReadOnly="true" ID="txtPatientName"  runat="server" ToolTip="Patient Name" TabIndex="104"></asp:TextBox>
                        </td>
                        <td style="width: 25%;">
                            <asp:Label ID="LabelForPatientICN" runat="server" AssociatedControlID="txtPatientICN" TabIndex="105" 
                                CssClass="FilterLabel">
                                Patient ICN
                            </asp:Label>:
                            <br />
                            <asp:TextBox ReadOnly="true" ID="txtPatientICN"  runat="server" ToolTip="Patient ICN" TabIndex="106"></asp:TextBox>
                        </td>
                        <td style="width: 25%;">
                            <asp:Label ID="LabelVendorInvoiceDateFrom" runat="server" AssociatedControlID="calVendorInvoiceDateFrom" TabIndex="108" 
                                CssClass="FilterLabel">
                                Treatment Date (mm/dd/yyyy)
                            </asp:Label>:
                            <br/>
                            (From):&nbsp; <asp:TextBox ID="calVendorInvoiceDateFrom" size="10" MaxLength="10" runat="server" TabIndex="109" 
                                ToolTip="Fee Inpatient Treatment Date (From)"  />  
                               <asp:CompareValidator ID="validateDateFrom" runat="server" 
                                ControlToValidate="calVendorInvoiceDateFrom" Type="Date" Operator="DataTypeCheck"
                                ErrorMessage="Please enter a valid date"
                                />                                                       
                            <br/>

                            (To):&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <asp:TextBox ID="calVendorInvoiceDateTo" size="10" MaxLength="10" runat="server" TabIndex="109"
                                 ToolTip="Fee Inpatient Treatment Date (To)"  />
                            <asp:CompareValidator ID="validateDateTo" runat="server" 
                                ControlToValidate="calVendorInvoiceDateTo" Type="Date" Operator="DataTypeCheck"
                                ErrorMessage="Please enter a valid date"
                                />                                                             
                            <br/>
                        </td>
                        <td style="width: 25%;">
                            <asp:Label ID="LabelForProcedure" runat="server" AssociatedControlID="txtProcedure" TabIndex="110" 
                                CssClass="FilterLabel">
                                Diagnosis / Procedure
                            </asp:Label>:
                            <br />
                            <asp:TextBox ID="txtProcedure" runat="server" ToolTip="Diagnosis  / Procedure" 
                                TabIndex="111">
                            </asp:TextBox>
                        </td>
                    </tr>
                </table>
             
                <table style="width: 100%; padding: 5px;">
                    <tr>
                        <td colspan="100%">
                            <asp:Button ID="btnGo" Height="25px" runat="server" Text="View Results" Enabled="true"
                                OnClick="btnGo_Click" ToolTip="View Results" TabIndex="120" />
                            <asp:Button ID="btnClear" Height="25px" runat="server" Text="Reset" Enabled="true"
                                OnClick="btnClear_Click" ToolTip="Clear Filters" TabIndex="121" />
                        </td>
                    </tr>
                </table>
                </div>
            </asp:Panel>
            <br />
            <!-- FeeInpatient Grid -->
            <asp:GridView ID="grdMSInpatient" CellPadding="5" Width="99.5%" EmptyDataText="Currently, showing no data. Please select filters from above and click the 'View Results' button."
                AllowSorting="true" OnSorting="grdMSInpatient_Sorting" runat="server" Height="2px"
                Font-Size="Smaller" BorderWidth="2" BorderStyle="Solid" BorderColor="#CCCCCC"
                OnRowDataBound="grdMSInpatient_RowDataBound" OnRowCreated="grdMSInpatient_RowCreated"
                AutoGenerateColumns="false" ageSize="10" TabIndex="122">
                <HeaderStyle CssClass="FrozenHeader" />
                <AlternatingRowStyle BackColor="#F4F4F4" />

             <Columns>
                    <asp:TemplateField HeaderText="Name" SortExpression="PatientName" AccessibleHeaderText="Patient Name">
                        <ItemTemplate>
                            <a href="PatientDetails.aspx?patientIcn=<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientICN"))) %>" title="Click to see patient details">
                                <%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PatientName")))%></a>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="PatientICN" HeaderText="PatientICN" SortExpression="PatientICN"
                        AccessibleHeaderText="PatientICN" />
                    <asp:BoundField DataField="Sta3n" HeaderText="Facility" SortExpression="Sta3n" AccessibleHeaderText="Facility Name" />                    

                    <asp:BoundField DataField="Ethnicity" HeaderText="Ethnicity" SortExpression="Ethnicity"
                        AccessibleHeaderText="Ethnicity" />
                    <asp:BoundField DataField="Race" HeaderText="Race" SortExpression="Race" AccessibleHeaderText="Race" />
          
                 
            <asp:BoundField DataField="FeeInpatInvoiceSID" HeaderText="FeeInpatInvoiceSID" SortExpression="FeeInpatInvoiceSID" AccessibleHeaderText="FeeInpatInvoiceSID" />
            <asp:BoundField DataField="Diagnosis" HeaderText="Diagnosis" SortExpression="Diagnosis" AccessibleHeaderText="Diagnosis" />
            <asp:BoundField DataField="Procedure" HeaderText="Procedure" SortExpression="Procedure" AccessibleHeaderText="Procedure" />
            <asp:BoundField DataField="TreatmentFromDate" HeaderText="TreatmentFromDate" SortExpression="TreatmentFromDate" AccessibleHeaderText="TreatmentFromDate" />
            <asp:BoundField DataField="TreatmentToDate" HeaderText="TreatmentToDate" SortExpression="TreatmentToDate" AccessibleHeaderText="TreatmentToDate" />               
                            

            <asp:BoundField DataField="ClaimedAmount" HeaderText="ClaimedAmount" SortExpression="ClaimedAmount" AccessibleHeaderText="ClaimedAmount" />
            <asp:BoundField DataField="AmountPaid" HeaderText="AmountPaid" SortExpression="AmountPaid" AccessibleHeaderText="AmountPaid" />
            <asp:BoundField DataField="VendorInvoiceDate" HeaderText="VendorInvoiceDate" SortExpression="VendorInvoiceDate" AccessibleHeaderText="VendorInvoiceDate" />

              </Columns>

            </asp:GridView>
            <br />
            <asp:Panel ID="pnlPagingControls" runat="server">
                <div class="excludeSaveWarnings">
                    <table>
                        <tr>
                            <td style="vertical-align:middle;">
                                <asp:Button ID="btnFirstPage" runat="server" Text="<<" ToolTip="First Page of Results"
                                    OnClick="btnFirstPage_Click" TabIndex="1000" />
                                <asp:Button ID="btnPrevPage" runat="server" Text="<" ToolTip="Previous Page of Results"
                                    OnClick="btnPrevPage_Click" TabIndex="1001" />
                                <asp:Button ID="btnNextPage" runat="server" Text=">" ToolTip="Next Page of Results"
                                    OnClick="btnNextPage_Click" TabIndex="1002" />
                                <asp:Button ID="btnLastPage" runat="server" Text=">>" ToolTip="Last Page of Results"
                                    OnClick="btnLastPage_Click" TabIndex="1003" />
                                <asp:Label ID="lblPageStatus" runat="server" TabIndex="1004" />
                            </td>
                            <td style="width:15px; font-size:1px;">
                                &nbsp;
                            </td>
                            <td style="vertical-align:middle;">
                                <asp:Label ID="LabelForResultsPerPage" runat="server" AssociatedControlID="ddlPageSize" TabIndex="1005">
                                    Results per page
                                </asp:Label>:
                                <asp:DropDownList runat="server" ID="ddlPageSize" AutoPostBack="true" TabIndex="1006">
                                    <asp:ListItem Text="10" Value="10"></asp:ListItem>
                                    <asp:ListItem Text="25" Value="25"></asp:ListItem>
                                    <asp:ListItem Text="50" Value="50"></asp:ListItem>
                                    <asp:ListItem Text="100" Value="100"></asp:ListItem>
                                    <asp:ListItem Text="500" Value="500"></asp:ListItem>
                                    <asp:ListItem Text="1000" Value="1000"></asp:ListItem>
                                </asp:DropDownList>
                            </td>
                            <td style="width:15px; font-size:1px;">
                                &nbsp;
                            </td>
                            <td style="vertical-align:middle;">
                                <asp:ImageButton ID="imgBtnExportToExcel" runat="server" AlternateText="Export Grid to Excel" TabIndex="1007"
                                    ToolTip="Export Grid to Excel" ImageUrl="~/images/export-icon.gif" onclick="imgBtnExportToExcel_Click" />
                            </td>
                        </tr>
                    </table>    
                </div>
            </asp:Panel>
            
            <br />
            <asp:Panel ID="pnlRecordCount" runat="server" Visible="false">
                <asp:Label ID="LabelForRecordCount" runat="server" AssociatedControlID="lblRecordCount" TabIndex="1008">
                    Record Total
                </asp:Label>:
                <asp:Label ID="lblRecordCount" runat="server" Text="lblRecordCount" TabIndex="1009"
                    ToolTip="Record Count in Search Results"></asp:Label>
            </asp:Panel>
        <%--</ContentTemplate>
    </asp:UpdatePanel>--%>
</asp:Content>