﻿using System;
using System.Globalization;
using System.Linq;
using System.Linq.Dynamic;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Export_ExportPatientToExcel : System.Web.UI.Page {

    #region Member Variables

    protected string nameSoSeN; // p1
    protected string selectedFacility; // p2
    protected string selectedDiagnosis; // p3
    protected string selectedSource; // p4
    protected string assessmentDue; // p5
    protected string selectedGender; // p6
    protected string msScore1; // p7
    protected string msScore2; // p8
    protected string relapses; // p9
    protected string onNotOn; // p10
    protected string medsCurrentEver; // p11
    protected string selectedMedication; // p12
    protected string sortExpression; // p13
    protected string sortDirection; // p14

    #endregion

    #region Override Methods

    public override void VerifyRenderingInServerForm(Control control) { }

    #endregion

    #region Protected Methods

    /// <summary>
    /// Default Page_Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        try {

            nameSoSeN = Server.UrlDecode(Request.QueryString.Get("p1"));
            selectedFacility = Server.UrlDecode(Request.QueryString.Get("p2"));
            selectedDiagnosis = Server.UrlDecode(Request.QueryString.Get("p3"));
            selectedSource = Server.UrlDecode(Request.QueryString.Get("p4"));
            assessmentDue = Server.UrlDecode(Request.QueryString.Get("p5"));
            selectedGender = Server.UrlDecode(Request.QueryString.Get("p6"));
            msScore1 = Server.UrlDecode(Request.QueryString.Get("p7"));
            msScore2 = Server.UrlDecode(Request.QueryString.Get("p8"));
            relapses = Server.UrlDecode(Request.QueryString.Get("p9"));
            onNotOn = Server.UrlDecode(Request.QueryString.Get("p10"));
            medsCurrentEver = Server.UrlDecode(Request.QueryString.Get("p11"));
            selectedMedication = Server.UrlDecode(Request.QueryString.Get("p12"));
            sortExpression = Server.UrlDecode(Request.QueryString.Get("p13"));
            sortDirection = Server.UrlDecode(Request.QueryString.Get("p14"));

            filterData();

            // write response to excel
            Response.Clear();
            Response.Charset = "";
            Response.ContentType = "application/vnd.ms-excel";
            Response.AppendHeader("content-disposition", "attachment; filename=MSSR_PatientExport.xls");
            System.IO.StringWriter sw = new System.IO.StringWriter();
            System.Web.UI.HtmlTextWriter hw = new System.Web.UI.HtmlTextWriter(sw);
            grdMSPatients.RenderControl(hw);
            Response.Write(sw.ToString());
            Response.End();

        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in ExportPatientToExcel PageLoad: " + ex.Message);
            throw ex;
            //throw new Exception("Unable to parse variables");
        }
    }

    /// <summary>
    /// Fired on row data bound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSPatients_RowDataBound(object sender, GridViewRowEventArgs e) {
        CultureInfo provider = CultureInfo.InvariantCulture;

        foreach (GridViewRow row in grdMSPatients.Rows) {
            if (row.RowType == DataControlRowType.DataRow) {
                if (row.RowType == DataControlRowType.Header) {
                    e.Row.CssClass = "locked";
                }
            }
        }
    }

    /// <summary>
    /// Fired on row created - to create merged cells at top of table.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdMSPatients_RowCreated(object sender, GridViewRowEventArgs e) {
        if (e.Row.RowType == DataControlRowType.Header) {
            #region Object creation

            //Creating a gridview object            
            GridView objGridView = (GridView)sender;

            //Creating a gridview row object
            GridViewRow objgridviewrow = new GridViewRow(1, 0, DataControlRowType.Header, DataControlRowState.Insert);

            //Creating a table cell object
            TableCell objtablecell = new TableCell();
            #endregion

            #region Merge cells
            //Add a blank cell at the first two cell headers(i.e. User Id & Name)
            //This can be achieved by making the colspan property of the table cell object as 2
            // and the text property of the table cell object will be blank
            //Henceforth, add the table cell object to the grid view row object
            AddMergedCells(objgridviewrow, objtablecell, 5, "PATIENT");
            AddMergedCells(objgridviewrow, objtablecell, 8, "MS ASSESSMENT");
            AddMergedCells(objgridviewrow, objtablecell, 1, "MS/NMO MEDS");

            objGridView.Controls[0].Controls.AddAt(0, objgridviewrow);
            #endregion
        }
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Filter and query performed for data matching filters.
    /// </summary>
    private void filterData() {
        #region Gather Request Variables

        // (Legacy)

        //Get stuff from  lists in Main
        int Sta3n = 0;
        String NameOrSoSen = "";
        String Diagnosis = "All";
        String Source = "All";
        String Gender = "All";
        //String AssessmentType = "All";
        String AssessmentDue = "All";
        int MSScore1 = 0;
        int MSScore2 = 10;

        String Relapses = "All";
        String MedSource = "All";
        String Meds = "All";
        string MedsAdditional = string.Empty;
        String CurrentEver = "All";
        String OnNotOn = "Any";

        if (!string.IsNullOrEmpty(selectedFacility)) {
            if (selectedFacility.ToLower() != "all")
                Sta3n = VeteransAffairs.Registries.Business.Utilities.Helpers.ExtractSta3n(selectedFacility);
        } else {
            Sta3n = -1;
        }

        NameOrSoSen = nameSoSeN;

        if (!(selectedDiagnosis == null))
            Diagnosis = selectedDiagnosis;
        if (!(selectedSource == null))
            Source = selectedSource;
        if (!(selectedGender == null))
            Gender = selectedGender;
        //AssessmentType = Request.QueryString["AssessmentType"];
        if (!(assessmentDue == null))
            AssessmentDue = assessmentDue;
        if (!(msScore1 == null))
            MSScore1 = Convert.ToInt32(msScore1);
        if (!(msScore2 == null))
            MSScore2 = Convert.ToInt32(msScore2);
        if (!(relapses == null))
            Relapses = relapses;
        //if (!(Request.QueryString["MedSource"] == null))
        //    MedSource = Request.QueryString["MedSource"];
        if (!(selectedMedication == null)) {
            //If medication name is followed by another name in parenthesis
            //remove that name, and only use the first one for the linq query
            string tempMedAdditional = string.Empty;
            string tempMed = selectedMedication;
            if (tempMed.Contains('(') && tempMed.Contains(')')) {
                tempMedAdditional = tempMed.Substring(tempMed.LastIndexOf('(') + 1, (tempMed.LastIndexOf(')')) - (tempMed.LastIndexOf('(') + 1));
                tempMed = tempMed.Substring(0, tempMed.IndexOf('('));
            }
            Meds = tempMed.Trim();
            Meds = MapMedicationNamesForSearch(Meds);
            MedsAdditional = tempMedAdditional.Trim();
        }
        if (!(medsCurrentEver == null))
            CurrentEver = medsCurrentEver;
        if (!(onNotOn == null))
            OnNotOn = onNotOn;

        #endregion

        using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext()) {
            var pats = from eg in db.MSSR_CURRENT_STATUS
                       orderby eg.MSSR_PATIENT_DEM.PatientName
                       select new {
                           eg.MSSR_PATIENT_DEM.PatientName,
                           NameSSN = eg.MSSR_PATIENT_DEM.PatientName + " (" + eg.MSSR_PATIENT_DEM.PatientSSN.Substring(eg.MSSR_PATIENT_DEM.PatientSSN.Length - 4) + ")",
                           eg.PatientSID,
                           eg.PatientICN,
                           eg.Sta3n,
                           eg.MSSR_PATIENT_DEM.PatientSSN,
                           eg.MSSR_PATIENT_DEM.Age,
                           eg.MSSR_PATIENT_DEM.Gender,
                           eg.BaselineAssessDate,
                           eg.LastAssessDate,
                           eg.LastAssessType,
                           eg.LastSymptomYear,
                           eg.LastMSSubType,
                           eg.LastRelapses,
                           eg.LastEdumsScore,
                           eg.PreviousEdmusScore,
                           RxAll = (CurrentEver == "Ever" ? eg.RxEverAll : eg.RxAll),
                           eg.MSDiagnosis,
                           eg.MSSR_PATIENT_DEM.Race,
                           eg.MSSR_PATIENT_DEM.Ethnicity,
                           RaceEthnicity = (eg.MSSR_PATIENT_DEM.Ethnicity != null && eg.MSSR_PATIENT_DEM.Race != null ?
                                               eg.MSSR_PATIENT_DEM.Race + " " + ((eg.MSSR_PATIENT_DEM.Ethnicity.ToLower() == "h") ? "(H)" : "(NH)") :
                                                    eg.MSSR_PATIENT_DEM.Ethnicity != null ?
                                                     "UNK " + eg.MSSR_PATIENT_DEM.Ethnicity :
                                                      eg.MSSR_PATIENT_DEM.Race),
                           MSScore1 = (eg.PreviousEdmusScore == null ? 99 : (eg.PreviousEdmusScore.Contains("6") ? 6 : Convert.ToInt32(eg.PreviousEdmusScore)))
                       };

            if (Sta3n > 0 || Sta3n == -1)
                pats = pats.AsQueryable().Where(eg => eg.Sta3n.Equals(Sta3n));

            if (!String.IsNullOrEmpty(NameOrSoSen)) {
                pats = pats.AsQueryable().Where(eg => eg.NameSSN.Contains(NameOrSoSen));
            }

            if (Diagnosis != "All") {
                if (Diagnosis == "RRMS" || Diagnosis == "SPMS" || Diagnosis == "PPMS" || Diagnosis == "PRMS")
                    pats = pats.AsQueryable().Where(eg => eg.LastMSSubType.Equals(Diagnosis));
                else
                    pats = pats.AsQueryable().Where(eg => eg.MSDiagnosis.Equals(Diagnosis));
            }

            /*if(Source != "All")
                        pats = pats.AsQueryable().Where(eg => eg.LastAssessType.Equals(Source));*/
            if (Gender != "All")
                pats = pats.AsQueryable().Where(eg => eg.Gender.Equals(Gender));

            if (AssessmentDue == "Now")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate <= DateTime.Today.AddMonths(-12));
            else if (AssessmentDue == "1")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                          && eg.LastAssessDate <= DateTime.Today.AddMonths(-11));
            else if (AssessmentDue == "2")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-10));
            else if (AssessmentDue == "3")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-9));
            else if (AssessmentDue == "6")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-12)
                                                        && eg.LastAssessDate <= DateTime.Today.AddMonths(-6));
            else if (AssessmentDue == "6Plus")
                pats = pats.AsQueryable().Where(eg => eg.LastAssessDate >= DateTime.Today.AddMonths(-6));

            if (OnNotOn == "On") {
                //Select patients who are on a medication if "All" is 
                //selected in the medications drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll != null);
                //Select patients who are on a medication that equals the medication
                //drop down selelection or the meds additional in () if available...
                else if (Meds != null) {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds) || eg.RxAll.Contains(MedsAdditional));
                    else
                        pats = pats.AsQueryable().Where(eg => eg.RxAll.Contains(Meds));
                }
            } else if (OnNotOn == "NotOn") {
                //Select all patients who are not on any medication if 
                //"All" is selected in the medication drop down list...
                if (Meds == "All")
                    pats = pats.AsQueryable().Where(eg => eg.RxAll == null);
                //Select patients who are not on any medications, or who are
                // on medications not including the select in the medication drop down list...
                else if (Meds != null) {
                    if (!string.IsNullOrEmpty(MedsAdditional))
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) && (!eg.RxAll.Contains(MedsAdditional)) || eg.RxAll == null);
                    else
                        pats = pats.AsQueryable().Where(eg => (!eg.RxAll.Contains(Meds)) || eg.RxAll == null);
                }
            }
          
            if (!(MSScore1 == 0 && MSScore2 == 10)) {
                pats = pats.AsQueryable().Where(eg => eg.MSScore1 >= MSScore1 && eg.MSScore1 <= MSScore2
                                           && eg.MSScore1 != 99);

            }

            if (Relapses != "All") {
                if (Relapses == "0" || Relapses == "1")
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses == Convert.ToInt32(Relapses));
                else
                    pats = pats.AsQueryable().Where(eg => eg.LastRelapses > 1);
            }

            if (!String.IsNullOrEmpty(sortDirection) && !String.IsNullOrEmpty(sortExpression)) {

                pats = pats.OrderBy(p => p.PatientName);
                //pats = pats.OrderBy(GetSortExpression(sortExpression,sortDirection));
                /* Removed: looking into better alternative implementation....*/
            }

            grdMSPatients.DataSource = pats;
            grdMSPatients.DataBind();
        }
    }

    /// <summary>
    /// Takes in a medication name and then handles those that have
    /// special mapping needed for searching.
    /// This handles naming inconsistencies in the legacy data.
    /// </summary>
    /// <param name="inputName"></param>
    /// <returns></returns>
    private string MapMedicationNamesForSearch(string inputName) {
        if (inputName.Equals("Dimethyl Fumerate")) {
            return "Dimethyl Fum";
        }
        return inputName;
    }

    #endregion

    #region Static Methods

    /// <summary>
    /// Function : AddMergedCells
    /// Purpose: Adds merged cell in the header
    /// </summary>
    /// <param name="objgridviewrow"></param>
    /// <param name="objtablecell"></param>
    /// <param name="colspan"></param>
    /// <param name="celltext"></param>
    private static void AddMergedCells(GridViewRow objgridviewrow, TableCell objtablecell, int colspan, string celltext) {
        objtablecell = new TableCell();
        objtablecell.Text = celltext;
        objtablecell.ColumnSpan = colspan;
        //objtablecell.BackColor = Color.FromName("#F4F4F4");
        objtablecell.BackColor = System.Drawing.Color.GhostWhite;
        objtablecell.Font.Bold = true;
        objtablecell.HorizontalAlign = HorizontalAlign.Center;
        objtablecell.Font.Size = 10;
        objgridviewrow.Cells.Add(objtablecell);
        //objgridviewrow.BackColor.Equals("#F4F4F4");
    }

    //private string GetSortExpression(string pSortDirections)
    //{
    //    string sortDirection = pSortDirections.ToUpper() == "DESC" ? " DESC" : " ASC";
    //    return sortDirection;
    //}
    #endregion
}