﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.BusinessManager;
using System.Collections.Generic;
using System.Reflection;
using MSSR.Security;

public partial class DefaultReporting : BasePage
{

    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

    protected void Page_Load(object sender, EventArgs e)
    {
        // Call setBreadCrumb() to set the "BreadCrumb" trail in the top of the content pane.
        //setBreadCrumb();

        populateReportCharts();
    }

    #region Public Overrides

    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Reporting";
    }

    public override string AppObjectCode()
    {
        return "MSSR DEFAULT REPORTING";
    }

    #endregion
    /// <summary>
    /// setBreadCrumb: Finds the LabelBreadCrumb control in the MasterPage.  Once found, the label is set with the desired text. 
    /// This text may also contain concatenated strings and links.
    /// </summary>
    //private void setBreadCrumb()
    //{
    //    Label LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");
    //    LabelBreadCrumb.Text = "MSSR Reporting";
    //}

    /// <summary>
    /// Determines based on the current users role whether
    /// or not the data they see on this screen needs to be filtered down
    /// </summary>
    /// <returns></returns>
    private bool shouldLimitResults()
    {
        int[] currentUserRoles = _user.GetRoles();
        if (currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_ADMINISTRATOR) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL) ||
            currentUserRoles.Contains((int)MssrRoleCode.MSSR_LOCAL_READONLY))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /// <summary>
    /// Returns a list of allowed station ids for users who need
    /// the data on this page to be filtered down
    /// </summary>
    /// <returns></returns>
    private List<string> allowedStations()
    {
        int[] institutionIDs = _user.GetInstitutions();
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where institutionIDs.Contains(inst.ID)
                                select inst.STATIONNUMBER);

            return institutions.ToList();
        }

    }

    private void PopulatePharmcyChart()
    {
       
        ////Show this chart only if the user is an Administrator
        if (!_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            cht_PharmacyAverageCostByYear.Visible = false;
            fldstavgcstprpnt.Visible = false;
        }
        else
            using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext())
            {
                //Get all entires where the previous edmus score is not null
                var pharData = from stn in db.MSSRE_PHARMACY_RPTs                                
                               select new { Key = stn.Years, Count = (int?)stn.TotCost };
                if (pharData.Count() > 0)
                {
                    cht_PharmacyAverageCostByYear.DataSource = pharData;
                    cht_PharmacyAverageCostByYear.DataBind();
                }
                else
                {
                    cht_PharmacyAverageCostByYearStatus.Text = "No Records Available for Pharmacy Average Cost By Year Graph.";
                    cht_PharmacyAverageCostByYearStatus.Visible = true;
                    cht_PharmacyAverageCostByYear.Visible = false;
                }
                
            }
    }
    private void PopulateProstheticChart()
    {
        ////Show this chart only if the user is an Administrator
        if (!_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            cht_Prosthetics.Visible = false;
            fldstprstassignd.Visible = false;
        }
        else
            using (MSSRDataClassesDataContext db = new MSSRDataClassesDataContext())
            {
                //Get all entires 
                var prosData = from stn in db.VW_PROSTHETICS_PIEs                               
                               select new { Prosthetic = stn.Prosthetic, TotalCount = (int?)stn.TotalCount };

                if (prosData.Count() > 0)
	            {
                    cht_Prosthetics.DataSource = prosData.ToList();
                    cht_Prosthetics.DataBind();		 
	            }
                else
	            {
                    lblcht_ProstheticsStatus.Text = "No Records Available for Prosthetic Chart.";
                    lblcht_ProstheticsStatus.Visible = true;

	            }
                

                
            }
    }
    /// <summary>
    /// Builds the list of data to be bound to the "MS Patients With Assessments by Facility" chart
    /// and then binds the data to it.
    /// </summary>
    /// <param name="ctx"></param>
    /// <param name="limitedStationsList"></param>
    private void PopulatePatientsWithAssessmentsByFacilty(MSSRDataClassesDataContext ctx, List<string> limitedStationsList)
    {
        
        //Get distinct list of station IDs that the current status table has results for
        var distinctStations = from stn in ctx.MSSR_CURRENT_STATUS
                               group stn by stn.Sta3n into g
                               select new { Key = g.Key, Count = g.Count() };
        //Loop through results, and build list to query institution table
        List<string> distinctStationsList = new List<string>();
        List<MSAssessmentNumberObject> distinctStationsObjs = new List<MSAssessmentNumberObject>();
        List<MSAssessmentNumberObject> chartBindList = new List<MSAssessmentNumberObject>();
        MSAssessmentNumberObject tempItem = null;
        foreach (object currItem in distinctStations)
        {
            if (currItem != null)
            {
                Type t = currItem.GetType();
                PropertyInfo pKey = t.GetProperty("Key");
                string keyValue = pKey.GetValue(currItem, null).ToString();
                if (limitedStationsList == null || limitedStationsList.Contains(keyValue))
                {
                    distinctStationsList.Add(keyValue);
                    PropertyInfo cKey = t.GetProperty("Count");
                    tempItem = new MSAssessmentNumberObject(keyValue, cKey.GetValue(currItem, null).ToString());
                    distinctStationsObjs.Add(tempItem);
                }
            }
        }
        using (VeteransAffairs.Registries.Business.RegistriesLinqDataContext bctx = new VeteransAffairs.Registries.Business.RegistriesLinqDataContext())
        {
            //Get all institution information for the specified station numbers
            var institutions = (from inst in bctx.STD_INSTITUTIONs
                                where distinctStationsList.Contains(inst.STATIONNUMBER) 
                                select inst);

            tempItem = null;
            foreach (MSAssessmentNumberObject currItem in distinctStationsObjs)
            {
                tempItem = new MSAssessmentNumberObject();
                tempItem.Facility = institutions.Where(inst => inst.STATIONNUMBER == currItem.Facility).Select(instItem => instItem.VISTANAME).FirstOrDefault();
                tempItem.Count = currItem.Count;
                chartBindList.Add(tempItem);
            }
        }

        if (chartBindList.Count() > 0)
        {
            chPatsBySta3n.DataSource = chartBindList.OrderBy(L => L.Facility);
            chPatsBySta3n.DataBind();
        }
        else
        {
            lblchPatsBySta3nStatus.Text = "No Records Available for MS Patients With Assessments by Facility Graph. ";
            lblchPatsBySta3nStatus.Visible = true;
            chPatsBySta3n.Visible = false;
        }
       

        

    }

    /// <summary>
    /// Builds the list of data to be bound to the "MS Assessments Completed by Facility" chart
    /// and then binds the data to it.
    /// </summary>
    /// <param name="ctx"></param>
    /// <param name="limitedStationsList"></param>
    private void PopulateMSAssessmentsByFacilty(MSSRDataClassesDataContext ctx, List<string> limitedStationsList)
    {
        //Get distinct list of station IDs that the current status table has results for
        
        try
        {
            bool checkStations = true;
            if (limitedStationsList == null)
            {
                checkStations = true;
                limitedStationsList = new List<string>();
            }
            else
            {
                checkStations = false;
            }


            var distinctStations2 = from pntWthAssments in ctx.vwMSSR_HF_Condenseds
                                    where checkStations == true || limitedStationsList.Contains(pntWthAssments.Facility.ToString())  
                                    select new { pntWthAssments.Count, pntWthAssments.Name};
            

            if (distinctStations2.Count() > 0 )
            {
                chtAssessmentsBySta3n.DataSource = distinctStations2;
                chtAssessmentsBySta3n.DataBind();
            }
            else
            {
                lblchtAssessmentsBySta3nStatus.Text = "No Records Available for MS Assessments Completed by Facility Chart.";
                lblchtAssessmentsBySta3nStatus.Visible = true;
                chtAssessmentsBySta3n.Visible = false;
            }


        }
        catch (Exception)
        {
            Logging.WriteLogToFile("MSSR: Error loading - Assessments Completed by Facility Chart."); ;
        }
        //chtAssessmentsBySta3n.DataSource = chartBindList;
        //chtAssessmentsBySta3n.DataBind();
    }

    /// <summary>
    /// Builds the list of data to be bound to the "Previous EDMUS Disability Score Recorded on Assessment" chart
    /// and the binds the data do it.
    /// </summary>
    /// <param name="ctx"></param>
    /// <param name="limitedStationsList"></param>
    private void PopulateLastEdmus(MSSRDataClassesDataContext ctx, List<string> limitedStationsList)
    {
        //Setup controlled conditional to determine whether or not
        //to filter based on the limited stations list.
        bool checkStations = true;
        if (limitedStationsList == null)
        {
            checkStations = true;
            limitedStationsList = new List<string>();
        }
        else
        {
            checkStations = false;
        }

        //Get all entires where the previous edmus score is not null
        var distinctStations = (from stn in ctx.MSSR_CURRENT_STATUS
                                where stn.LastEdumsScore != null
                               where checkStations == true || limitedStationsList.Contains(stn.Sta3n.ToString())
                                group stn by stn.LastEdumsScore into g //group stn by stn.LastEdumsScore into g
                               select new { Key = g.Key, Count = g.Count() }).OrderBy(a => a.Key == "10" ? 2 : 1).ThenBy(a =>a.Key);
        if (distinctStations.Count() > 0)
        {
            chtEDMUSScore.DataSource = distinctStations;
            chtEDMUSScore.DataBind();
        }
        else
        {
            lblchtEDMUSScoreStatus.Text = "No Records Available for EDMUS Score Graph.";
            lblchtEDMUSScoreStatus.Visible = true;
            chtEDMUSScore.Visible = false;
        }
        
    }

    //private int GetSortOrder(string p)
    //{
    //    int sortOrder = Int32.Parse(p.Substring(0));
    //    return sortOrder;
    //}

   

    /// <summary>
    /// Builds the list of data to be bound to the "Current VA Medications for MS Patients" chart
    /// and the binds the data do it.
    /// </summary>
    /// <param name="ctx"></param>
    /// <param name="limitedStationsList"></param>
    private void PopulateCurrentMedications(MSSRDataClassesDataContext ctx, List<string> limitedStationsList)
    {
        //Setup controlled conditional to determine whether or not
        //to filter based on the limited stations list.
        bool checkStations = true;
        if (limitedStationsList == null)
        {
            checkStations = true;
            limitedStationsList = new List<string>();
        }
        else
        {
            checkStations = false;
        }

        //Get initial list and medication data
        var Rx1 = (from eg in ctx.VW_MSSR_CURRENT_MEDs
                   where checkStations == true || limitedStationsList.Contains(eg.Sta3n.ToString())
                   select new
                   {
                       Rx = eg.MedName, //getMed(eg.Rx1), //getMed(eg.Rx1), //eg.RxAlleg.MedName
                       Stn = eg.Sta3n
                   }).ToList();

        //Group the results
        var Rx2 = from rx in Rx1
                  group rx by new { rx.Rx }
                      into gg
                      select new
                      {
                          Rx = gg.Key.Rx,
                          numRx = gg.Count()
                      };

        List<MedicationObject> medList = new List<MedicationObject>();

        foreach (var v in Rx2)
        {
            MedicationObject mo = new MedicationObject() { Rx = v.Rx, numRx = v.numRx };

            if (mo.Rx.Contains("NO MED FOUND"))
            {
                mo.Rx = "NO MEDICATION";
            }
            medList.Add(mo);
        }

        if (medList.Count() > 0)
        {
            //chtMeds.DataSource = medList;
            //chtMeds.DataBind();

            BarChartCurrentVAMed.DataSource = medList.OrderBy(M => M.Rx);
            BarChartCurrentVAMed.DataBind();
        }
        else
        {
            lblBarChartCurrentVAMedStatus.Text = "No Records Available for Current VA Meds Graph.";
            lblBarChartCurrentVAMedStatus.Visible = true;
            //lblchtMedsStatus.Text = "No Records Available for Current VA Meds Graph.";
            //lblchtMedsStatus.Visible = true;
            BarChartCurrentVAMed.Visible = false;
            //chtMeds.Visible = false;
        }
        
    }

    private void PopulateInprocessSureveysByFacilityChart(MSSRDataClassesDataContext ctx, List<string> limitedStationsList) 
    {
        try
        {
            bool checkStations = true;
            if (limitedStationsList == null)
            {
                checkStations = true;
                limitedStationsList = new List<string>();
            }
            else
            {
                checkStations = false;
            }
         
            var inprocessSurveysByFacility = (from inp in ctx.vwGetCountOfInProcessSurveysByFacilities
                                                where checkStations == true || limitedStationsList.Contains(inp.STATIONNUMBER)
                                                select inp).ToList();

            if (inprocessSurveysByFacility.Count() > 0)
            {
                RChartInProcessSurveysByFacility.DataSource = inprocessSurveysByFacility.OrderBy(I => I.NAME);
                RChartInProcessSurveysByFacility.DataBind();
            }
            else
            {
                lblRChartInProcessSurveysByFacilityStatus.Text = "No Records Available for Surveys By Facility Graph.";
                lblRChartInProcessSurveysByFacilityStatus.Visible = true;
                RChartInProcessSurveysByFacility.Visible = false;
            }
            
            
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("MSSR: Error loading  - Inprocess Sureveys By Facility Chart.");
        }
    }

    /// <summary>
    /// Method to use LINQ context and populate charts for reporting
    /// </summary>
    private void populateReportCharts()
    {
        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {

            #region No Data Annotation

            //TextAnnotation annotation = new TextAnnotation();
            //annotation.X = 32;
            //annotation.Y = 22;
            //annotation.Text = "Currently, No data for this report.";

            #endregion

            //Check to see if limiting of stations is required
            //If so, get the list of approved stations for viewing to pass in
            List<string> limitedStationsList = null;
            if (shouldLimitResults())
            {
                limitedStationsList = allowedStations();
            }

            PopulatePatientsWithAssessmentsByFacilty(ctx, limitedStationsList);

            PopulateMSAssessmentsByFacilty(ctx, limitedStationsList);

            PopulateLastEdmus(ctx, limitedStationsList);

            PopulateCurrentMedications(ctx, limitedStationsList);

            PopulateInprocessSureveysByFacilityChart(ctx, limitedStationsList);

            PopulatePharmcyChart();

            PopulateProstheticChart();

            
        }
    }

    //protected string getMed(string Med)
    //{
    //    // NOTE: TODO - from Dr. Wallin - show all meds (5/8)

    //    if (String.IsNullOrEmpty(Med) || Med == "")
    //        return "NO MED FOUND";
    //    //else if (Med.Contains("INTERFERON BETA-1A"))
    //    //   return "INTERFERON BETA-1A";
    //    //else if (Med.ToUpper().Contains("INTERFERON BETA-1B"))
    //    //   return "INTERFERON BETA-1B";
    //    else if (Med.ToUpper().Contains("AZATHIOPRINE"))
    //        return "AZATHIOPRINE";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA 1A (AVONEX)"))
    //        return "INTERFERON BETA-1A (AVONEX)";
    //    else if (Med.ToUpper().Contains("PEGINTERFERON BETA-1A INJ 125MCG PEN"))
    //        return "INTERFERON BETA-1A (AVONEX)";
    //    else if (Med.ToUpper().Contains("PEGINTERFERON BETA-1A 125MCG/0.5ML PEN"))
    //        return "INTERFERON BETA-1A (AVONEX)";
    //    else if (Med.ToUpper().Contains("PEGINTERFERON BETA-1A PEN STARTER KIT"))
    //        return "INTERFERON BETA-1A (REBIF)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1A INJ 30MCG POWDER/VIAL"))
    //        return "INTERFERON BETA-1A (AVONEX)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1A") && Med.ToUpper().Contains("AVONEX"))
    //        return "INTERFERON BETA-1A (AVONEX)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA 1A (REBIF)"))
    //        return "INTERFERON BETA-1A (REBIF)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1A") && Med.ToUpper().Contains("REBIF"))
    //        return "INTERFERON BETA-1A (REBIF)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA 1B (BETASERON)"))
    //        return "INTERFERON BETA-1B (BETASERON)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1B (250MCG) 0.3MG/VIL"))
    //        return "INTERFERON BETA-1B (BETASERON)";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1B") && Med.ToUpper().Contains("BETASERON"))
    //        return "INTERFERON BETA-1B (BETASERON)";
    //    else if (Med.ToUpper().Contains("METHOTREXATE"))
    //        return "METHOTREXATE";
    //    else if (Med.ToUpper().Contains("MITOXANTRONE"))
    //        return "MITOXANTRONE";
    //    else if (Med.ToUpper().Contains("MYCOPHENOLATE MOFETIL"))
    //        return "MYCOPHENOLATE MOFETIL";
    //    else if (Med.ToUpper().Contains("MYCOPHENOLATE (GOLDEN STATE) 250MG CAP"))
    //        return "MYCOPHENOLATE MOFETIL";
    //    else if (Med.ToUpper().Contains("NATALIZUMAB"))
    //        return "NATALIZUMAB";
    //    else if (Med.ToUpper().Contains("RITUXIMAB"))
    //        return "RITUXIMAB";
    //    else if (Med.ToUpper().Contains("RITUXAN"))
    //        return "RITUXIMAB";
    //    else if (Med.ToUpper().Contains("TERIFLUNOMIDE"))
    //        return "TERIFLUNOMIDE";
    //    else if (Med.ToUpper().Contains("PREDNISONE"))
    //        return "CORTICOSTEROIDS";
    //    else if (Med.ToUpper().Contains("DEXAMETHASONE"))
    //        return "CORTICOSTEROIDS";
    //    else if (Med.ToUpper().Contains("GLATIRAMER"))
    //        return "GLATIRAMER ACETATE";
    //    else if (Med.ToUpper().Contains("COPAXONE"))
    //        return "GLATIRAMER ACETATE";
    //    else if (Med.ToUpper().Contains("FINGOLIMOD"))
    //        return "FINGOLIMOD";
    //    else if (Med.ToUpper().Contains("DIMETHYL"))
    //        return "DIMETHYL FUMARATE";
    //    else if (Med.ToUpper().Contains("TECFIDERA"))
    //        return "DIMETHYL FUMARATE";
    //    else if (Med.ToUpper().Contains("FUMARATE"))
    //        return "DIMETHYL FUMARATE"; 
    //    else if (Med.ToUpper().Contains("DEXAMETHASONE"))
    //        return "DEXAMETHASONE";
        
    //    else if (Med.ToUpper().Contains("CYCLOPHOSPHAMIDE"))
    //        return "CYCLOPHOSPHAMIDE";
    //    else if (Med.ToUpper().Contains("DACLIZUMAB"))
    //        return "DACLIZUMAB";
    //    else if (Med.ToUpper().Contains("INTERFERON BETA-1B,RECOMBINANT 0.3MG/VIL"))
    //        return "INTERFERON BETA-1B (BETASERON)";
    //    else
    //        return Med;
    //}

    protected void chPats_DataBound(object sender, EventArgs e)
    {
        //string xvalue = string.Empty;
        //int Sta3n = 0;

        //foreach (Telerik.Charting.ChartSeries sr in chPatsBySta3n.Series)
        //{
        //    //sr.
        //}


        //foreach (System.Web.UI.DataVisualization.Charting.Series sr in chPatsBySta3n.Series) {
        //    foreach (DataPoint point in sr.Points) {
        //        xvalue = point.AxisLabel;

        //        if (xvalue.Contains("512"))
        //            Sta3n = 512;
        //        else if (xvalue.Contains("648"))
        //            Sta3n = 648;
        //        else if (xvalue.Contains("650"))
        //            Sta3n = 650;
        //        else if (xvalue.Contains("663"))
        //            Sta3n = 663;
        //        else if (xvalue.Contains("688"))
        //            Sta3n = 688;

        //        point.Url = "CurrentStatus.aspx?Facility=" + Sta3n;
        //    }
        //}
    }

    //protected void chtMeds_ItemDataBound(object sender, Telerik.Charting.ChartItemDataBoundEventArgs e)
    //{
    //    string xvalue = string.Empty;
    //    string Meds = String.Empty;

    //    xvalue = e.SeriesItem.Label.TextBlock.Text;

    //    if (xvalue.Contains("NO MED FOUND"))
    //    {
    //        Meds = "All Others";
    //    }
    //    else if (xvalue.Contains("OTHER DMT"))
    //    {
    //        Meds = "OTHER DMT";
    //    }
    //    else if (xvalue.Contains("FINGOLIMOD"))
    //    {
    //        Meds = "FINGOLIMOD";
    //    }
    //    else if (xvalue.Contains("DIMETHLYL FUMERATE"))
    //    {
    //        Meds = "DIMETHLYL FUMARATE";
    //    }
    //    else if (xvalue.Contains("GLATIRAMER"))
    //    {
    //        Meds = "GLATIRAMER";
    //    }
    //    else if (xvalue.Contains("INTERFERON BETA-1A"))
    //    {
    //        Meds = "INTERFERON BETA-1A";
    //    }
    //    else if (xvalue.Contains("INTERFERON BETA-1B"))
    //    {
    //        Meds = "INTERFERON BETA-1B";
    //    }
    //    else if (xvalue.Contains("NATALIZUMAB"))
    //    {
    //        Meds = "NATALIZUMAB";
    //    }

    //    e.SeriesItem.Label.TextBlock.Text = Meds;
    //    e.SeriesItem.ActiveRegion.Tooltip = Meds;

    //    //foreach (System.Web.UI.DataVisualization.Charting.Series sr in chtMeds.Series) {
    //    //    foreach (DataPoint point in sr.Points) {
    //    //        xvalue = point.AxisLabel;
    //    //        Meds = "All";
    //    //        if (xvalue.Contains("NO MED FOUND"))
    //    //            Meds = "NONE";
    //    //        else if (xvalue.Contains("OTHER DMT"))
    //    //            Meds = "OTHER DMT";
    //    //        else if (xvalue.Contains("FINGOLIMOD"))
    //    //            Meds = "FINGOLIMOD";
    //    //        else if (xvalue.Contains("DIMETHYL FUMERATE"))
    //    //            Meds = "DIMETHYL FUMERATE";
    //    //        else if (xvalue.Contains("GLATIRAMER"))
    //    //            Meds = "GLATIRAMER";
    //    //        else if (xvalue.Contains("INTERFERON BETA-1A"))
    //    //            Meds = "INTERFERON BETA-1A";
    //    //        else if (xvalue.Contains("INTERFERON BETA-1B"))
    //    //            Meds = "INTERFERON BETA-1B";
    //    //        else if (xvalue.Contains("NATALIZUMAB"))
    //    //            Meds = "NATALIZUMAB";

    //    //        point.Url = "CurrentStatus.aspx?Meds=" + Meds;
    //    //    }
    //    //}
    //}

    /// <summary>
    /// MedicationObject internal class used for charting.
    /// </summary>
    private class MedicationObject
    {
        public string Rx { get; set; }
        public int numRx { get; set; }

        public MedicationObject()
        {
        }
    }

    /// <summary>
    /// MSAssessmentNumberObject internal class used for charting.
    /// </summary>
    private class MSAssessmentNumberObject
    {
        public string Facility { get; set; }
        public string Count { get; set; }
        public MSAssessmentNumberObject() { }
        public MSAssessmentNumberObject(string facility, string count)
        {
            this.Facility = facility;
            this.Count = count;
        }
    }
   
}
