﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="DefaultReporting.aspx.cs" Inherits="DefaultReporting" Title="MSSR: Reporting" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Charting" Assembly="Telerik.Web.UI" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server" ScriptMode="Release">
    </asp:ScriptManager>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">
        <script language="javascript" type="text/javascript">
            function OnPatientWithAssessmentByFacClicked(sender, args) {
                window.location = "Patients.aspx?Location=" + args._category;
            }

            function OnAssessmentByFacClicked(sender, args) {
                //alert('Value clicked: ' + args._category);
                window.location = "Assessments.aspx?Location=" + args._category;
            }

            function OnEDMUSScoreClicked(sender, args) {
                //alert('Value clicked: ' + args._value);
                window.location = "Patients.aspx?EDMUSMin=" + args._category + "&EDMUSMax=" + args._category;
            }
            function OnPharmacyAverageCostClicked(sender, args) {
                //alert('Pharmacy.aspx?Year=' + args._category);
                //window.location = "Pharmacy.aspx?Year=" + args._category;
            }


            function OnMedsClicked(sender, args) {
                //alert('Value clicked: ' + args._category);
                var tempCategory = args._category;
                if (tempCategory == "NO MEDICATION")
                    tempCategory = "NO MEDICATION";
                window.location = "Patients.aspx?MedName=" + tempCategory;
            }
            function OnProsthetics_Clicked(sender, args) {
                //alert('Value clicked: ' + args._category);
                var tempCategory = args._category;
                window.location = "Prosthetics.aspx?MedName=" + tempCategory;
            }

            function OnInProcessClicked(sender, args) {
                window.location = "InprocessSurveys.aspx?Location=" + args._category;
            }

        </script>
    </telerik:RadCodeBlock>

    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <fieldset>
            <legend style="font-weight:700">MS Patients With Assessments by Facility</legend>
            <div>

                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                     <asp:Label ID="lblchPatsBySta3nStatus" Visible="false" runat="server" />
                    <!-- MS Patients With Assessments by Facility -->
                    <telerik:RadHtmlChart runat="server" ID="chPatsBySta3n" Height="425px" Transitions="false" F
                        Skin="Vista" OnDataBound="chPats_DataBound" OnClientSeriesClicked="OnPatientWithAssessmentByFacClicked">
                        <ChartTitle Text="MS Patients With Assessments by Facility">                                                       
                            
                        </ChartTitle>
                        <PlotArea>
                            <Series>
                                <telerik:BarSeries DataFieldY="Count">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Patients <br />with Assessments:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                </telerik:BarSeries>
                            </Series>
                            <XAxis DataLabelsField="Facility" Name="Facility">
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: MS Patients With Assessments by Facility -->
                </div>
            </div>
        </fieldset>
        <fieldset>
            <legend>MS Assessments Completed by Facility</legend>
            <div>
                <asp:Label ID="lblchtAssessmentsBySta3nStatus" Visible="false" runat="server" />
                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                    <!-- MS Assessments Completed by Facility -->
                    <telerik:RadHtmlChart runat="server" ID="chtAssessmentsBySta3n" Height="425px" Transitions="false"
                        Skin="Vista" OnClientSeriesClicked="OnAssessmentByFacClicked">
                        <ChartTitle Text="MS Assessments Completed by Facility">
                            
                        </ChartTitle>
                        <PlotArea>
                            <Series>
                                <telerik:BarSeries DataFieldY="Count">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Assessments<br />Completed at Facility:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                </telerik:BarSeries>
                            </Series>
                            <XAxis DataLabelsField="Name" Name="Name">
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="# of Assessments" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: MS Assessments Completed by Facility -->

                </div>
            </div>
        </fieldset>
        <fieldset>
            <legend>Current EDMUS Disability Score Recorded on Assessment</legend>
            <div>
                <asp:Label ID="lblchtEDMUSScoreStatus" Visible="false" runat="server" />
                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                    <!-- Last EDMUS Disability Score Recorded on Assessment / Only Previous has values ... -->
                    <telerik:RadHtmlChart runat="server" ID="chtEDMUSScore" Width="550px" Height="425px" Transitions="false"
                        Skin="Vista" OnClientSeriesClicked="OnEDMUSScoreClicked">
                        <ChartTitle Text="Current EDMUS Disability Score Recorded on Assessment">
                            
                        </ChartTitle>
                        <PlotArea>
                            <Series>
                                <telerik:ColumnSeries Name="# of Patients" DataFieldY="Count">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Number of Patients:<br /> #=dataItem.Count#</div>"></TooltipsAppearance>
                                </telerik:ColumnSeries>
                            </Series>
                            <XAxis DataLabelsField="Key">
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>     
                                <MajorGridLines Visible="false"></MajorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="Current EDMUS Score" />
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: Last EDMUS Disability Score Recorded on Assessment -->
                </div>
            </div>
        </fieldset>
        <%--<fieldset>
            <legend>Current VA Medications for MS Patients</legend>
            <div>
                <asp:Label ID="lblchtMedsStatus" Visible="false" runat="server" />
                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                    <!-- Current VA Medications for MS Patients -->
                    <telerik:RadHtmlChart runat="server" ID="chtMeds" Width="550px" Height="425px" Skin="Vista" Transitions="false"
                        OnClientSeriesClicked="OnMedsClicked">
                        <ChartTitle Text="Current VA Medications for MS Patients">
                        </ChartTitle>
                        <Legend>
                            <Appearance BackgroundColor="White" Position="Right" Visible="false"></Appearance>
                        </Legend>
                        <PlotArea>
                            <Series>
                                <telerik:PieSeries StartAngle="180" Name="# of Patients" NameField="Rx" DataFieldY="numRx">
                                    <LabelsAppearance Position="Circle" DataFormatString="{0}" DataField="Rx" Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'> #=dataItem.Rx# <br /> #=dataItem.numRx#</div>"></TooltipsAppearance>
                                </telerik:PieSeries>
                            </Series>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: Current VA Medications for MS Patients -->
                </div>
            </div>
        </fieldset>--%>
       
        <fieldset>
            <legend>Current VA Medications for MS Patients</legend>
            <div>
                <asp:Label ID="lblBarChartCurrentVAMedStatus" Visible="false" runat="server" />
                <div style="width: 70%; padding-left: 7%; padding-top: 3%">
                    <!-- Current VA Medications for MS Patients -->
                    <telerik:RadHtmlChart runat="server" ID="BarChartCurrentVAMed" Height="425px" Transitions="false"
                        Skin="Vista" OnClientSeriesClicked="OnMedsClicked">
                        <ChartTitle Text="Current VA Medications for MS Patients">
                        </ChartTitle>
                        <PlotArea>
                            <Series>
                                <telerik:BarSeries DataFieldY="numRx">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Current VA Medications for MS Patients<br /> #=dataItem.numRx#</div>"></TooltipsAppearance>
                                </telerik:BarSeries>
                            </Series>
                            <XAxis DataLabelsField="Rx" Name="Rx">
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="# of Patients" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: Current VA Medications for MS Patients -->
                </div>
            </div>
        </fieldset>
         <fieldset id="fldstprstassignd" runat="server">
            <legend>Prosthectics Assigned to All Patients</legend>
            <div>
                <asp:Label ID="lblcht_ProstheticsStatus" Visible="false" runat="server" />
                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                    <!-- Prosthetics Pie chart -->
                    <telerik:RadHtmlChart runat="server" ID="cht_Prosthetics" Width="550px" Height="425px" Skin="Vista" Transitions="false"
                        OnClientSeriesClicked="OnProsthetics_Clicked">
                        <ChartTitle Text="Prosthectics Assigned to All Patients">
                        </ChartTitle>
                        <Legend>
                            <Appearance BackgroundColor="White" Position="Right" Visible="false"></Appearance>
                        </Legend>
                        <PlotArea>
                            <Series>
                                <telerik:PieSeries StartAngle="180" Name="# of Prosthetics" NameField="Prosthetic" DataFieldY="TotalCount">
                                    <LabelsAppearance Position="Circle" DataFormatString="{0}" DataField="Prosthetic" Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'> #=dataItem.Prosthetic# <br /> #=dataItem.TotalCount#</div>"></TooltipsAppearance>
                                </telerik:PieSeries>
                            </Series>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: Prosthetics Pie chart -->
                </div>
            </div>
        </fieldset>
        <fieldset>
            <legend>In-Process MS Assessments by Facility</legend>
            <div style="width: 100%">
                
                <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                    <asp:Label id="lblRChartInProcessSurveysByFacilityStatus" Visible="false"  runat="server" />
                    <!-- Current VA Medications for MS Patients -->
                    <telerik:RadHtmlChart runat="server" ID="RChartInProcessSurveysByFacility" Height="425px" Transitions="false"
                        Skin="Vista" OnClientSeriesClicked="OnInProcessClicked">
                        <ChartTitle Text="In-Process MS Assessments by Facility">
                        </ChartTitle>
                        <PlotArea>
                            <Series>
                                <telerik:BarSeries DataFieldY="CountOfInprocess">
                                    <LabelsAppearance Visible="true">
                                    </LabelsAppearance>
                                    <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>In-Process MS Assessments by Facility<br /> #=dataItem.CountOfInprocess#</div>"></TooltipsAppearance>
                                </telerik:BarSeries>
                            </Series>
                            <XAxis DataLabelsField="NAME" Name="NAME">
                                <LabelsAppearance RotationAngle="0"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <MajorGridLines Visible="false"></MajorGridLines>
                            </XAxis>
                            <YAxis>
                                <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                                <MinorGridLines Visible="false"></MinorGridLines>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="# of Inprocess Surveys" />
                            </YAxis>
                        </PlotArea>
                    </telerik:RadHtmlChart>
                    <!-- End: Current VA Medications for MS Patients -->

                </div>
            </div>
        </fieldset>
        <fieldset id="fldstavgcstprpnt" runat="server">
            <legend>Pharmacy (Average Cost per Patient)</legend>
            <div style="width: 70%; padding-left: 7%; margin-left: 7%; padding-top: 3%;">
                <asp:Label id="cht_PharmacyAverageCostByYearStatus" Visible="false"  runat="server" />
                <!-- Pharmacy Average Cost Report ... -->
                <telerik:RadHtmlChart runat="server" ID="cht_PharmacyAverageCostByYear" Height="425px" Transitions="false"
                    Skin="Vista" OnClientSeriesClicked="OnPharmacyAverageCostClicked">
                    <ChartTitle Text="Pharmacy (Average Cost per Patient)">
                    </ChartTitle>
                    <PlotArea>
                        <Series>
                            <telerik:ColumnSeries DataFieldY="Count">
                                <LabelsAppearance Visible="true" DataFormatString="${0}">
                                </LabelsAppearance>
                                <TooltipsAppearance ClientTemplate="<div style=\'padding:10px;\'>Average Cost:<br />$#=dataItem.Count#</div>"></TooltipsAppearance>
                            </telerik:ColumnSeries>
                        </Series>
                        <XAxis DataLabelsField="Key">
                            <LabelsAppearance DataFormatString="{0}"></LabelsAppearance>
                            <MinorGridLines Visible="false"></MinorGridLines>
                            <MajorGridLines Visible="false"></MajorGridLines>
                            <TitleAppearance Position="Center" RotationAngle="0" Text="Year" />
                        </XAxis>
                        <YAxis>
                            <LabelsAppearance DataFormatString="${0}"></LabelsAppearance>
                            <MinorGridLines Visible="false"></MinorGridLines>
                            <TitleAppearance Position="Center" RotationAngle="0" Text="Average Cost per Patient" />
                        </YAxis>
                    </PlotArea>
                </telerik:RadHtmlChart>
                <!-- End: Average Cost -->
            </div>
        </fieldset>
    </telerik:RadCodeBlock>
</asp:Content>
