﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using MSSR.Security;

/// <summary>
/// Summary description for MenuBuilder
/// </summary>
public static class MenuBuilder
{

    /// <summary>
    /// Builds left menu based on top menu location and pages accessible by user
    /// </summary>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    public static void BuildDynamicNavigationItems(string currentURL, Menu horizontalMenu, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList)
    {
        //menu items that need name manipulated after breadcrumb is built
        MenuItem menuItemNewMSSR = new MenuItem();
        int numNewItems = 0;
        MenuItem menuItemInProcessMSSR = new MenuItem();
        int numInProcess = 0;

        switch (pageTopMenuItem)
        {
            case "Patients":

                // TODO: Add Subnav here ... 
                leftMenu.Items.Add(new MenuItem("Patients", "MSSR PATIENTS", "", "Patients.aspx"));
                leftMenu.Items.Add(new MenuItem("Assessments", "MSSR ASSESSMENTS", "", "Assessments.aspx"));   
                leftMenu.Items.Add(new MenuItem("DATA EXPORT", "DATA EXPORT", "", "DataElementsExport.aspx"));// DataElementsExport.aspx

                //leftMenu.Items.Add(new MenuItem("", "TBI PATIENTS", "", "Patients.aspx"));
                //leftMenu.Items.Add(new MenuItem("TBI Patients", "TBI PATIENTS", "", "Patients.aspx"));
                //leftMenu.Items.Add(new MenuItem("Polytrauma Patients", "TBI POLY TRAUMA PATIENTS", "", "PolyTraumaPatients.aspx"));

                break;
            case "Reporting":

                //leftMenu.Items.Add(new MenuItem("Custom", "MSSR CUSTOM REPORTING", "", "AdhocReporting.aspx"));
                leftMenu.Items.Add(new MenuItem("Default", "MSSR DEFAULT REPORTING", "", "DefaultReporting.aspx"));
                leftMenu.Items.Add(new MenuItem("Manage Health Care Resources", "Manage Health Care Resources", "HealthCareResources.aspx" ));

                break;
            case "Administration":

                // TODO: ADD MSSR PAGES
                leftMenu.Items.Add(new MenuItem("Users", "MSSR ADMIN LIST USERS", "", "AdminListUsers.aspx"));
                leftMenu.Items.Add(new MenuItem("Medications", "MSSR ADMIN EDIT MEDICATIONS", "", "AdminAddEditMedications.aspx"));
                leftMenu.Items.Add(new MenuItem("Add New Patient", "MSSR ADD NEW PATIENT", "", "AddPatient.aspx"));
                leftMenu.Items.Add(new MenuItem("New Patients", "MSSR NEW PATIENTS LIST", "", "NewPatients.aspx"));
                leftMenu.Items.Add(new MenuItem("Role Matrix", "MSSR ADMIN USER ROLE", "", "AdminEditUsersRoles.aspx"));
                leftMenu.Items.Add(new MenuItem("System Availability", "MSSR SYSTEM AVAILABILITY", "", "AdminSystemAvailability.aspx"));

                break;

            //case "DataElementsExport":

            //    leftMenu.Items.Add(new MenuItem("Patients", "MSSR PATIENTS", "", "Patients.aspx"));
            //    leftMenu.Items.Add(new MenuItem("Assessments", "MSSR ASSESSMENTS", "", "Assessments.aspx"));
            //    leftMenu.Items.Add(new MenuItem("Data Export", "DATA EXPORT", "", "DataElementsExport.aspx"));
            //    break;                                                            

            default:

                leftMenu.Items.Add(new MenuItem("Top Menu Not Registered"));
                break;

        }

        //Disable all menu items
        foreach (MenuItem item in leftMenu.Items)
            ChangeMenuState(item, false);

        //Enable selection for the accessible items only
        for (int i = 0; i < accessiblePageList.GetLength(0); i++)
            ChangeMenuState(leftMenu.FindItem(accessiblePageList[i]), true);

        //SetMenuItemHighlight(leftMenu.Items, pageLeftMenuItem);

        BuildBreadCrumbDynamic(currentURL, pageTopMenuItem, leftMenu, pageLeftMenuItem, breadCrumb, accessiblePageList);

        menuItemNewMSSR.Text += (numNewItems > 0 ? " (" + numNewItems.ToString() + ")" : "");
        menuItemInProcessMSSR.Text += (numInProcess > 0 ? " (" + numInProcess.ToString() + ")" : "");

    }

    /// <summary>
    /// Builds bread crumb based item in selected menu
    /// </summary>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    public static void BuildBreadCrumbDynamic(string currentURL, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList)
    {

        MenuItem currentMenuItem = null;

        //if (leftMenu.Items.Count > 0)
        //{
        //    currentMenuItem = leftMenu.Items[0];
        //}
        foreach (MenuItem item in leftMenu.Items)
        {
            currentMenuItem = SeachItemAndChildrenByURL(item, currentURL);
            if (currentMenuItem != null) break;
        }

        if (currentMenuItem == null)
        {
            currentMenuItem = leftMenu.FindItem(pageLeftMenuItem);
        }


        if (currentMenuItem != null)
        {
            if (currentMenuItem.Selectable)
            {
                currentMenuItem.Selected = true;
            }

            //initialize breadcrumb with currently selected menu item
            string breadCrumbPath = currentMenuItem.Text;

            //add to path all parents of selected menu item
            while (currentMenuItem.Parent != null)
            {
                //set current menutree location to parent
                currentMenuItem = currentMenuItem.Parent;

                breadCrumbPath = currentMenuItem.Text + " > " + breadCrumbPath;
            }

            //add top menu to beginning of breadcrumb
            breadCrumbPath = pageTopMenuItem + " > " + breadCrumbPath;

            breadCrumb.Text = breadCrumbPath;
        }
    }

    public static MenuItem SeachItemAndChildrenByURL(MenuItem item, string URL)
    {
        MenuItem foundItem = null;

        string[] pathElems = HttpContext.Current.Request.Url.PathAndQuery.Split(new char[] { '/' });
        string pageName =
        pathElems[pathElems.Length - 1];

        //foreach (MenuItem elem in menu)
        //{
        if (item.NavigateUrl == pageName)
            return item;

        if (item.ChildItems.Count > 0)
        {
            foreach (MenuItem subitem in item.ChildItems)
            {
                foundItem = SeachItemAndChildrenByURL(subitem, pageName);
                if (foundItem != null)
                    return foundItem;
            }
        }

        return null;

    }

    /// <summary>
    /// Changes menu state recursively
    /// </summary>
    /// <param name="item"></param>
    /// <param name="flag"></param>
    private static void ChangeMenuState(MenuItem item, bool flag)
    {
        if (item != null)
        {
            if (flag == false) item.Selectable = flag;
            if (flag == true && item.ChildItems.Count == 0) item.Selectable = flag;
            if (item.ChildItems.Count > 0)
                foreach (MenuItem subitem in item.ChildItems)
                    ChangeMenuState(subitem, flag);
        }
    }

    /// <summary>
    /// Search and highlight appropriate menu item
    /// </summary>
    /// <param name="menu">Collection of Menu Items</param>
    /// <param name="value">Item to Search For</param>
    //private static void SetMenuItemHighlight(MenuItemCollection menu, string value)
    //{
    //    foreach (MenuItem elem in menu)
    //    {
    //        if (elem.Value == value)
    //        {
    //            if (elem.Selectable)
    //            {
    //                elem.Selected = true;
    //                break;
    //            }
    //        }

    //        if (elem.ChildItems.Count > 0)
    //            SetMenuItemHighlight(elem.ChildItems, value);
    //    }
    //}

    public static string GetDefaultPageForUserRole()
    {
        UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            return ("Patients.aspx");
        }
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_EDITOR))
        //{
        //    return ("Referrals.aspx?id=1");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_READ_ONLY))
        //{
        //    return ("Referrals.aspx?id=1");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_EDITOR))
        //{
        //    return ("PolyTraumaEntries.aspx");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_READ_ONLY))
        //{
        //    return ("PolyTraumaEntries.aspx");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_NATIONAL))
        //{
        //    return ("DefaultReporting.aspx");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_STATION))
        //{
        //    return ("DefaultReporting.aspx");
        //}
        //else if (_user.GetRoles().Contains((int)RoleCode.TBI_REPORTING_USER_VISN))
        //{
        //    return ("DefaultReporting.aspx");
        //}
        else
        {
            return ("Patients.aspx");
        }

    }

    /// <summary>
    /// This function sets the properties for my tasks menu item
    /// based on the user role.
    /// </summary>
    //public static void SetMyTasksLink(Menu horizontalMenu)
    //{
    //    string defaultPage = MenuBuilder.GetDefaultPageForUserRole();

    //    if (defaultPage == "") defaultPage = "Default.aspx";

    //    MenuItem myTaskMenuItem = horizontalMenu.FindItem("My Tasks");

    //    if (defaultPage == "DefaultReporting.aspx")
    //    {
    //        myTaskMenuItem.NavigateUrl = "";
    //        myTaskMenuItem.Selectable = false;
    //    }
    //    else
    //    {
    //        myTaskMenuItem.NavigateUrl = defaultPage;
    //    }
    //}

    /// <summary>
    /// This function sets the properties for patient menu item
    /// based on the user role.
    /// </summary>
    public static void SetPatientLink(Menu horizontalMenu)
    {
        UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;

        string patientMenuPage = "Patients.aspx";

        if (_user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR))
        {
            patientMenuPage = "Patients.aspx";
        }
        //else if (_user.GetRoles().Contains((int)MssrRoleCode.TBI_POLYTRAUMA_EDITOR)
        //            ||
        //        _user.GetRoles().Contains((int)RoleCode.TBI_POLYTRAUMA_READ_ONLY)) {
        //    patientMenuPage = "PolyTraumaPatients.aspx";
        //}

        MenuItem patientsMenuItem = horizontalMenu.FindItem("Patients");

        if (patientsMenuItem != null)
        {
            patientsMenuItem.NavigateUrl = patientMenuPage;
        }

        if (patientMenuPage == "")
        {
            //patientsMenuItem.Selectable = false;
        }
    }
}