﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using VeteransAffairs.Registries.BusinessManager;
using MSSR.Security;

/// <summary>
/// Summary description for SurveyEditUserManager
/// </summary>
public class SurveyEditUserManager
{
	
    public bool IsUserAuthozizedToEditSurvey(UserAccountManager user)
    {
        bool isUserAuthorized = false;
        if (IsUserInSurveyEditRole(user) && IsUserRoleHasAccessToSurveyEditPage())
        {
            isUserAuthorized = true;
        }
        return isUserAuthorized;   
    }
    public bool IsUserAuthozizedAddNewPatient(UserAccountManager user)
    {
        bool isUserAuthorized = false;
        if (IsUserInSurveyEditRole(user) && IsUserRoleHasAccessToSurveyEditPage())
        {
            isUserAuthorized = true;
        }
        return isUserAuthorized;
    }
    private bool IsUserInSurveyEditRole(UserAccountManager user)
    {
        bool isUserInSurveyEditRole = false;
        if (user.GetRoles().Contains((int)MssrRoleCode.MSSR_SYSTEM_ADMINISTRATOR) && user.GetRoles().Contains((int)MssrRoleCode.MSSR_MSAT_VIEW_AND_EDIT))
        {
            isUserInSurveyEditRole = true;
        }
        return isUserInSurveyEditRole;
    }
    private bool IsUserRoleHasAccessToSurveyEditPage()
    {
        bool isRoleHasAccessToSurveyEditPage = false;
        string[] pagesAccessibleByUser = ((UserAccountManager)HttpContext.Current.User).GetPagesByCode();
        if (pagesAccessibleByUser.Contains("MSSR SURVEY EDIT"))
        {
            isRoleHasAccessToSurveyEditPage = true;
        }
        return isRoleHasAccessToSurveyEditPage;    
    }  

}