﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Transactions;
using Microsoft.SqlServer.Server;
using VeteransAffairs.Registries.BusinessManager;

namespace MSSREnh
{
    /// <summary>
    /// Summary description for PatientViewManager
    /// </summary>
    public class PatientViewManager: BaseViewManager
    {
        public PatientViewManager(UserAccountManager currentUser)
            : base(currentUser) { }
	
        public string AddPatientToMssr(AddPatientRequest addPatientRequest, string user)
        {
            string erroMessage = string.Empty;
            if (user != null)
            {
                try
                {
                    using (var scope = new TransactionScope())
                    {
                        DataAccessManager.AddNewPatientToSurveyPatient(addPatientRequest.PatientIcn, addPatientRequest.Station, addPatientRequest.PatientSsn, addPatientRequest.FirstName,
                            addPatientRequest.MiddleName, addPatientRequest.LastName, addPatientRequest.DateofBirth, addPatientRequest.Gender, addPatientRequest.Sta6N,
                            addPatientRequest.Dfn, DateTime.Now, DateTime.Now, CurrentUser.UserName, CurrentUser.UserName);

                        DataAccessManager.AddNewPatientToPatientDems(addPatientRequest.PatientSsn, addPatientRequest.PatientSid, addPatientRequest.PatientIcn, addPatientRequest.FirstName,
                            addPatientRequest.LastName, addPatientRequest.PatientFullName, addPatientRequest.Age, addPatientRequest.DateofBirth, addPatientRequest.DateofDeath,
                            addPatientRequest.City, addPatientRequest.State, addPatientRequest.Gender, addPatientRequest.MaritalStatus, addPatientRequest.Religion,
                            addPatientRequest.Region, addPatientRequest.Race, addPatientRequest.Ethnicity, DateTime.Now, CurrentUser.UserName, addPatientRequest.Station, addPatientRequest.StationName);

                        DataAccessManager.AddNewPatientToMssrePatientDems(addPatientRequest.PatientSsn, addPatientRequest.PatientSid, addPatientRequest.PatientIcn,
                            addPatientRequest.FirstName, addPatientRequest.LastName, addPatientRequest.PatientFullName, addPatientRequest.Age, addPatientRequest.DateofBirth,
                            addPatientRequest.DateofDeath, addPatientRequest.CauseOfDeath, addPatientRequest.City, addPatientRequest.State, addPatientRequest.Gender,
                            addPatientRequest.MaritalStatus, addPatientRequest.Religion, addPatientRequest.Region, addPatientRequest.Race, addPatientRequest.Ethnicity,
                            DateTime.Now, CurrentUser.UserName);

                        scope.Complete();
                    }
                }
                catch (TransactionAbortedException ex)
                {
                    erroMessage = ex.Message;
                    Logging.WriteLogToFile(ex.Message);
                }
            }
           
            return erroMessage;
        }

        public SearchAndLoadPatientIcnAndDetails_Result FindPatientByPatientSsn(string patientSsn)
        {
            return DataAccessManager.FindNewPatientDetails(patientSsn);
        }
        public bool IsPatientExistInMssr(string patientSsn, string patientIcn)
        {
            return DataAccessManager.CheckIfPatientExistsInMssr(patientSsn, patientIcn).Any();
        }

        public IEnumerable<MSSR_PATIENT_DEM> GetNewPatients()
        {
            return DataAccessManager.GetListOfNewPatients();
        }
    }
}