﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Configuration;
using MSSREnh;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.MSSR;

/// <summary>
/// Summary description for Helpers
/// </summary>
public static class Helpers
{
    private static string[] _countries = new string[] { 
         "Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", 
         "Angola", "Anguilla", "Antarctica", "Antigua And Barbuda", "Argentina", 
         "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan",
		   "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus",
		   "Belgium", "Belize", "Benin", "Bermuda", "Bhutan",
		   "Bolivia", "Bosnia Hercegovina", "Botswana", "Bouvet Island", "Brazil",
		   "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Byelorussian SSR",
		   "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands",
		   "Central African Republic", "Chad", "Chile", "China", "Christmas Island",
		    "Colombia", "Comoros", "Congo", "Cook Islands",
		   "Costa Rica", "Cote D'Ivoire", "Croatia", "Cuba", "Cyprus",
		   "Czech Republic", "Czechoslovakia", "Denmark", "Djibouti", "Dominica",
		   "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador",
		   "England", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia",
		   "Falkland Islands", "Faroe Islands", "Fiji", "Finland", "France",
		   "Gabon", "Gambia", "Georgia", "Germany", "Ghana",
		   "Gibraltar", "Great Britain", "Greece", "Greenland", "Grenada",
		   "Guadeloupe", "Guam", "Guatemela", "Guernsey", "Guiana",
		   "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard Islands",
		   "Honduras", "Hong Kong", "Hungary", "Iceland", "India",
		   "Indonesia", "Iran", "Iraq", "Ireland", "Isle Of Man",
		   "Israel", "Italy", "Jamaica", "Japan", "Jersey",
		   "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, South",
		   "Korea, North", "Kuwait", "Kyrgyzstan", "Lao People's Dem. Rep.", "Latvia",
		   "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein",
		   "Lithuania", "Luxembourg", "Macau", "Macedonia", "Madagascar",
		   "Malawi", "Malaysia", "Maldives", "Mali", "Malta",
		   "Mariana Islands", "Marshall Islands", "Martinique", "Mauritania", "Mauritius",
		   "Mayotte", "Mexico", "Micronesia", "Moldova", "Monaco",
		   "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar",
		   "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles",
		   "Neutral Zone", "New Caledonia", "New Zealand", "Nicaragua", "Niger",
		   "Nigeria", "Niue", "Norfolk Island", "Northern Ireland", "Norway",
		   "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea",
		   "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland",
		   "Polynesia", "Portugal", "Puerto Rico", "Qatar", "Reunion",
		   "Romania", "Russian Federation", "Rwanda", "Saint Helena", "Saint Kitts",
		   "Saint Lucia", "Saint Pierre", "Saint Vincent", "Samoa", "San Marino",
		   "Sao Tome and Principe", "Saudi Arabia", "Scotland", "Senegal", "Seychelles",
		   "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands",
		   "Somalia", "South Africa", "South Georgia", "Spain", "Sri Lanka",
		   "Sudan", "Suriname", "Svalbard", "Swaziland", "Sweden",
		   "Switzerland", "Syrian Arab Republic", "Taiwan", "Tajikista", "Tanzania",
		   "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago",
		   "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu",
		   "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States",
		   "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City State", "Venezuela",
		   "Vietnam", "Virgin Islands", "Wales", "Western Sahara", "Yemen",
		   "Yugoslavia", "Zaire", "Zambia", "Zimbabwe"};

    /// <summary>
    /// Returns an array with all countries
    /// </summary>     
    public static StringCollection GetCountries()
    {
        StringCollection countries = new StringCollection();
        countries.AddRange(_countries);
        return countries;
    }
    /// <summary>
    /// Returns sorted list of all countries
    /// </summary>
    /// <param name="insertEmpty"></param>
    /// <returns></returns>
    public static SortedList GetCountries(bool insertEmpty)
    {
        SortedList countries = new SortedList();
        if (insertEmpty)
            countries.Add("", "Please select one...");
        foreach (String country in _countries)
            countries.Add(country, country);
        return countries;
    }
    /// <summary>
    /// highlights controls on selection 
    /// </summary>
    /// <param name="container"></param>
    /// <param name="className"></param>
    public static void SetInputControlsHighlight(Control container, string className)
    {
        foreach (Control ctl in container.Controls)
        {
            if (ctl is TextBox || ctl is DropDownList ||
                ctl is ListBox || ctl is CheckBox || ctl is RadioButton ||
                ctl is RadioButtonList || ctl is CheckBoxList)
            {
                WebControl wctl = ctl as WebControl;
                if (wctl != null)
                {
                    wctl.Attributes.Add("onfocus", string.Format("this.className = '{0}';", className));
                    wctl.Attributes.Add("onblur", "this.className = '';");
                }
            }
            else
            {
                if (ctl.Controls.Count > 0)
                    SetInputControlsHighlight(ctl, className);
            }
        }
    }

    public static Boolean isInteger(string valueToCheck)
    {
        long _tempInt;

        try
        {
            _tempInt = Convert.ToInt64(valueToCheck);
            return true;
        }
        catch
        {
            return false;
        }

    }

    public static Boolean isString(string valueToCheck)
    {
        string _tempString;

        try
        {
            _tempString = valueToCheck.ToString();
            return true;
        }
        catch
        {
            return false;
        }

    }

    public static string getYearFromMonthYear(string monthYear)
    {
        // MonthYear format is either just a 
        string s = monthYear;

        if (monthYear != null)
        {
            if (monthYear.Length > 4)
            {
                if (monthYear.Contains('/'))
                {
                    s = monthYear.Split('/')[1];
                }
                else
                {
                    Logging.WriteLogToFile("ERROR in getYearFromMonthYear - input: " + monthYear + " is greater than 4 characters but doesnt have a forward slash");
                }
            }
            else
            {
                s = monthYear;
            }
        }

        return s;
    }

    public static string GetConfigEntry(string key)
    {
        string Val = string.Empty;
        if (WebConfigurationManager.AppSettings.Count > 0)
            Val = WebConfigurationManager.AppSettings.Get(key);

        return Val;
    }

    public static string GetDBConfigEntry(string key)
    {
        RegistriesLinqDataContext dc = new RegistriesLinqDataContext();

        var setting = (from s in dc.CRS_SETTINGSs
                       where s.NAME == key
                       select s.VALUE).SingleOrDefault();

        if (setting == null)
            setting = "";

        return setting;
    }
    public static int getIntFromString(string inString)
    {
        int returnInt = 0;

        int tempInt;
        bool result = int.TryParse(inString, out tempInt);
        if (result)
        {
            returnInt = tempInt;
        }

        return returnInt;
    }

    public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
    {
        return string.IsNullOrEmpty(GetStringFromSessionVariable(sessionVariable));
    }

    public static string GetStringFromSessionVariable(object sessionVariable)
    {
        string result = string.Empty;

        if (sessionVariable != null)
        {
            result = sessionVariable.ToString();
        }

        return result;
    }
    

    public static int? getNullableIntFromString(string inString)
    {
        int? returnInt = null;

        int tempInt;
        bool result = int.TryParse(inString, out tempInt);
        if (result)
        {
            returnInt = tempInt;
        }

        return returnInt;
    }

    public static string getStringFromNullableInt(int? inInt)
    {
        string returnString = "";

        if (inInt.HasValue)
        {
            returnString = inInt.ToString();
        }

        return returnString;
    }

    public static DateTime? getNullableDateFromString(string inString)
    {
        DateTime? returnDate = null;

        DateTime tempDate;
        bool result = DateTime.TryParse(inString, out tempDate);
        if (result)
        {
            returnDate = tempDate;
        }

        return returnDate;
    }

    public static Char? getNullableCharFromString(string inString)
    {
        Char? returnChar = null;

        Char tempChar;
        bool result = Char.TryParse(inString, out tempChar);
        if (result)
        {
            returnChar = tempChar;
        }

        return returnChar;
    }

    public static string getNullableStringFromString(string inString)
    {
        string returnString = null;

        if (!String.IsNullOrEmpty(inString))
        {
            returnString = inString;
        }

        return returnString;
    }

    public static string getShortDateStringFromNullableDate(DateTime? inDate)
    {
        string returnString = "";

        if (inDate.HasValue)
        {
            returnString = Convert.ToDateTime(inDate).ToShortDateString();

        }

        return returnString;
    }

    public static MSSRServiceTO BuildMSSRServiceTO(string _inSiteCode, string _inDUZ, string _inDFN, string _inServerIP, string _inServerPort, int _inEvaluationNoteId, int _inFollowUpNoteId)
    {
        MSSRServiceTO result = new MSSRServiceTO();
        result.siteCode = _inSiteCode;
        result.DUZ = _inDUZ;
        result.DFN = _inDFN;
        result.CprsSentMSSREvaluationNoteId = _inEvaluationNoteId;
        result.CprsSentMSSRFollowUpNoteId = _inFollowUpNoteId;
        result.ServerIP = _inServerIP;
        result.ServerPort = _inServerPort;
        return result;
    }

    public static void ExtractCPRSVariables(Page page, out string _inSiteCode, out string _inDUZ, out string _inDFN, out string _inServerIP, out string _inServerPort, out int _inEvaluationNoteId, out int _inFollowUpNoteId)
    {
        _inSiteCode = Helpers.DeSerializSessionItems(page.Session["SiteCode"]);
        _inDUZ = Helpers.DeSerializSessionItems(page.Session["DUZ"]);
        _inDFN = Helpers.DeSerializSessionItems(page.Session["DFN"]);
        _inServerIP = Helpers.DeSerializSessionItems(page.Session["ServerIP"]);
        _inServerPort = Helpers.DeSerializSessionItems(page.Session["ServerPort"]);

        int.TryParse(Helpers.DeSerializSessionItems(page.Session["MSSREvaluationNoteId"]), out _inEvaluationNoteId);
        int.TryParse(Helpers.DeSerializSessionItems(page.Session["MSSRFollowUpNoteId"]), out _inFollowUpNoteId);

        if (string.IsNullOrEmpty(_inDUZ)
            || string.IsNullOrEmpty(_inDFN)
            || string.IsNullOrEmpty(_inSiteCode)
            || string.IsNullOrEmpty(_inServerIP)
            || string.IsNullOrEmpty(_inServerPort))
        {
            string sError = "PatientInstrumentsMain.Page_Load(): WarningRedirect: null or missing query string values: ";
            if (Helpers.IsSessionVariableNullOrEmpty(page.Session["DUZ"]))
                sError += "DUZ;";
            if (Helpers.IsSessionVariableNullOrEmpty(page.Session["DFN"]))
                sError += "DFN;";
            if (Helpers.IsSessionVariableNullOrEmpty(page.Session["SiteCode"]))
                sError += "SiteCode;";
            if (Helpers.IsSessionVariableNullOrEmpty(page.Session["ServerIP"]))
                sError += "ServerIP";
            if (Helpers.IsSessionVariableNullOrEmpty(page.Session["ServerPort"]))
                sError += "ServerPort";

            //if any value is not passed in then the page was called incorrectly, display error message to user
            page.Response.Redirect("Warning.aspx?err=7", false);
        }
    }

    public static bool IsDestinationUrlLocal(string pDestinationUrl, string currentHost)
    {
        bool isValidUrl = false;
        string localHost = string.Concat("https://", currentHost, "/");
        string newUrl = string.Concat(localHost, pDestinationUrl);
        Uri destinationUrl;
        Uri.TryCreate(newUrl, UriKind.Absolute, out destinationUrl);
        if (destinationUrl != null && currentHost == destinationUrl.Host)
        {
            isValidUrl = true;
        }
        return isValidUrl;
    }
    public static bool UserHasMssrProfile(string loginUserName)
    {
        bool doesUserHasPermission = false;
        var dc = new RegistriesLinqDataContext();
        doesUserHasPermission = (from u in dc.USERs select u).Any(usr => usr.USERNAME == loginUserName && usr.INACTIVE_FLAG == false);
        return doesUserHasPermission;
    }

    public static SessionItem SerializSessionItemsObj(string sessionValue)
    {
        SessionItem sessionSer = new SessionItem();
        if (!string.IsNullOrEmpty(sessionValue))
        {
            sessionSer.serializedValue = sessionValue;
            sessionSer.deSerializedValue = sessionValue;
        }
        return sessionSer;
    }
    public static string DeSerializSessionItems(object sessionValue)
    {
        string desserizalizerValue = null;
        SessionItem item;       
        try
        {
            item = (SessionItem)sessionValue;
        }
        catch (Exception)
        {
            return null;
        }
        if (item != null)
        {
            desserizalizerValue = item.deSerializedValue;
        }
        return desserizalizerValue;
    }
    public static SerializeSurvey SerializeSurvey(SURVEY survey)
    {
        SerializeSurvey sessionSer = new SerializeSurvey();
        if (survey != null)
        {
            sessionSer.SerializedSurvey = survey;
            sessionSer.DeserializedSurvey = survey;
        }

        return sessionSer;
    }
    public static SURVEY DeSerializSurvey(object sessionValue)
    {
        SURVEY desserizalizerSurvey = null;
        SerializeSurvey item;
        try
        {
            item = (SerializeSurvey)sessionValue;
        }
        catch (Exception)
        {
            return null;
        }
        if (item != null)
        {
            desserizalizerSurvey = item.DeserializedSurvey;
        }
        return desserizalizerSurvey;
    }
    public static SerializePatientMedications SerializePatientMedications(List<MssrPatientMedication> patMeds)
    {
        SerializePatientMedications sessionPatMed = new SerializePatientMedications();
        if (patMeds != null)
        {
            sessionPatMed.SerializedPatientMedication = patMeds;
            sessionPatMed.DeserializedPatientMedication = patMeds;
        }

        return sessionPatMed;
    }
    public static List<MssrPatientMedication> DeSerializPatientMedications(object sessionValue)
    {
        List<MssrPatientMedication> desserizalizerPatMed = null;
        SerializePatientMedications item;
        try
        {
            item = (SerializePatientMedications)sessionValue;
        }
        catch (Exception)
        {
            return null;
        }
        if (item != null)
        {
            desserizalizerPatMed = item.DeserializedPatientMedication;
        }
        return desserizalizerPatMed;
    }

    public static IEnumerable<Station> GetStations(string baseStation)
    {
        List<Station> result = new List<Station>();
        if (null == baseStation)
        {
            baseStation = "";
        }
        else if (baseStation.Length > 3)
        {
            baseStation = baseStation.Substring(0, 3);
        }


        using (MSSRDataClassesDataContext ctx = new MSSRDataClassesDataContext())
        {
            List<vaGetInstitutionsResult> iList = ctx.vaGetInstitutions(baseStation, string.Empty).ToList();
            if (iList != null)
            {
                foreach (vaGetInstitutionsResult i in iList)
                {
                    result.Add(new Station(i.stationnumber, string.Format("{0} ({1})", i.name, i.stationnumber)));
                }
            }
        }


        return result;
    }


    public static List<STD_STATE> GetStates()
    {
        var mssrInstrumentManager = new MSSRInstrumentsManager();
        List<STD_STATE> states = mssrInstrumentManager.GetStates();
        return states;
    }

    public static string GetRace(string selectedValue)
    {
        string retRace = string.Empty;
        if (selectedValue.Equals("American Indian or Alaskan Native", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "American Indian or Alaskan Native";
        }
        else if (selectedValue.Equals("Asian", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "Asian";
        }
        else if (selectedValue.Equals("Black or African American", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "Black or African American";
        }
        else if (selectedValue.Equals("Native Hawaiian or other Pacific Islander", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "Native Hawaiian or other Pacific Islander";
        }
        else if (selectedValue.Equals("White", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "White";  
        }
        else if (selectedValue.Equals("Other", StringComparison.OrdinalIgnoreCase))
        {
            retRace = "Other";
        }
        return retRace;
    }

    public static string GetEthnicity(string selectedValue)
    {
        string retEthnicity = string.Empty;
        if (selectedValue.Equals("Hispanic", StringComparison.OrdinalIgnoreCase))
        {
            retEthnicity = "Hispanic";
        }
        else if (selectedValue.Equals("Not Hispanic", StringComparison.OrdinalIgnoreCase))
        {
            retEthnicity = "Not Hispanic";
        }
        return retEthnicity;
    }

    public static string GetGender(string selectedValue)
    {
        string retGender = string.Empty;
        if (selectedValue.Equals("Male", StringComparison.OrdinalIgnoreCase))
        {
            retGender = "Male";
        }
        else if (selectedValue.Equals("Female", StringComparison.OrdinalIgnoreCase))
        {
            retGender = "Female";
        }
        return retGender;
    }
}
