﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminListUsers.aspx.cs" Inherits="AdminListUsers"
    Title="MSSR: Admin List Users" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <div class="excludeSaveWarnings">
        <p>
            <br />
            <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
            <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100"></asp:TextBox>
            &nbsp;
            <asp:Button ID="ButtonSearch" runat="server" Text=" Search " />
            &nbsp;
            <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
        </p>
    </div>
    <p>
        <asp:GridView ID="GridViewUsers" runat="server" DataKeyNames="USER_ID" DataSourceID="ObjectDataSourceUsers" AutoGenerateColumns="False"
            AllowPaging="True" AllowSorting="True" Caption="Users" EmptyDataText="No Users">
            <Columns>
                <asp:BoundField DataField="USER_ID" HeaderText="Id" ItemStyle-Width="18px" SortExpression="USER_ID">
                    <ItemStyle Width="18px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="USERNAME" HeaderText="NT Username" ItemStyle-Width="150px" SortExpression="USERNAME">
                    <ItemStyle Width="150px"></ItemStyle>
                </asp:BoundField>
                <asp:BoundField DataField="FULL_NAME" HeaderText="Name" ItemStyle-Width="250px" SortExpression="LAST_NAME">
                    <ItemStyle Width="250px"></ItemStyle>
                </asp:BoundField>
                <asp:HyperLinkField DataNavigateUrlFields="USER_ID" NavigateUrl="~/AdminEditUsers.aspx" ItemStyle-HorizontalAlign="Center"
                    HeaderStyle-HorizontalAlign="Center" ItemStyle-Width="35px" DataNavigateUrlFormatString="AdminEditUsers.aspx?id={0}" AccessibleHeaderText="Edit"
                    Text=" Edit ">
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center" Width="35px"></ItemStyle>
                </asp:HyperLinkField>
                <asp:HyperLinkField DataNavigateUrlFields="USER_ID" NavigateUrl="~/AdminEditUsersRoles.aspx" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText="Edit Roles"
                    HeaderStyle-HorizontalAlign="Center" ItemStyle-Width="70px" DataNavigateUrlFormatString="AdminEditUsersRoles.aspx?id={0}"
                    Text=" Edit Roles ">
                    <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center" Width="70px"></ItemStyle>
                </asp:HyperLinkField>
                <asp:CommandField ShowDeleteButton="true" DeleteText="Remove" ItemStyle-Width="50px" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText="Remove">
                    <ItemStyle HorizontalAlign="Center" Width="50px"></ItemStyle>
                </asp:CommandField>
            </Columns>
        </asp:GridView>
        <br />
        <asp:Button ID="ButtonAddUser" runat="server" Text="  Add User  " PostBackUrl="~/AdminEditUsers.aspx" />
        <asp:ObjectDataSource ID="ObjectDataSourceUsers" runat="server" SelectMethod="SelectListRegistryUsers" SelectCountMethod="SelectListRegistryUsersCount"
            StartRowIndexParameterName="startRow" MaximumRowsParameterName="maxRows" SortParameterName="sort" EnablePaging="True"
            TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager" DeleteMethod="RemoveUserFromRegistry">
            <DeleteParameters>
                <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" Name="RegistryCode" PropertyName="Value" Type="String" />
            </DeleteParameters>
            <SelectParameters>
                <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" Name="RegistryCode" PropertyName="Value" Type="String" />
                <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue="" Name="searchCriteria" PropertyName="Text" Type="String" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />
    </p>
</asp:Content>
