﻿<%@ Page Title="MSSR: Role Administration" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminEditUsersRoles.aspx.cs" Inherits="AdminEditUsersRoles" MaintainScrollPositionOnPostback="true" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<% @Import Namespace="VeteransAffairs.Registries.Business"%>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style2
        {
            width: 150px;
        }
        .style3
        {
            width: 20px;
        }
        .style4
        {
            width: 100%;
        }
        .style5
        {
        }
        .style6
        {
            width: 23px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    
    <script type = "text/javascript">
        $(document).ready(function()
        {
        
            if ($('#<%= CheckBoxRoleLocalAdmin.ClientID  %>').is(':checked'))
            {
                $('#<%= ListBoxVISNsLocalAdmin.ClientID %>').removeAttr('disabled');
            }
            else 
            {
                $('#<%= ListBoxVISNsLocalAdmin.ClientID %>').attr('disabled', 'disabled');
                $('#<%= ListBoxVISNsLocalAdmin.ClientID %> option:selected').attr('selected', false);
            }


            if ($('#<%= CheckBoxRoleLocal.ClientID %>').is(':checked'))
            {
                $('#<%= ListBoxVISNsLocal.ClientID %>').removeAttr('disabled');
            }
            else
            {
                $('#<%= ListBoxVISNsLocal.ClientID %>').attr('disabled', 'disabled');
                $('#<%= ListBoxVISNsLocal.ClientID %> option:selected').attr('selected', false);
            }


            if ($('#<%= CheckBoxRoleLocalReadonly.ClientID  %>').is(':checked'))
            {
                $('#<%= ListBoxVISNsLocalReadonly.ClientID %>').removeAttr('disabled');
            }
            else
            {
                $('#<%= ListBoxVISNsLocalReadonly.ClientID %>').attr('disabled', 'disabled');
                $('#<%= ListBoxVISNsLocalReadonly.ClientID %> option:selected').attr('selected', false);
            }

            
            $('#<%= CheckBoxRoleLocalAdmin.ClientID  %>').click(function()
            {

                if ($(this).is(':checked'))
                {
                    $('#<%= ListBoxVISNsLocalAdmin.ClientID %>').removeAttr('disabled');
                }
                else
                {
                    $('#<%= ListBoxVISNsLocalAdmin.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ListBoxVISNsLocalAdmin.ClientID %> option:selected').attr('selected', false);
                    
                }
            });


            $('#<%= CheckBoxRoleLocal.ClientID  %>').click(function()
            {

                if ($(this).is(':checked'))
                {
                    $('#<%= ListBoxVISNsLocal.ClientID %>').removeAttr('disabled');
                }
                else
                {
                    $('#<%= ListBoxVISNsLocal.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ListBoxVISNsLocal.ClientID %> option:selected').attr('selected', false);
                }
            });


            $('#<%= CheckBoxRoleLocalReadonly.ClientID  %>').click(function()
            {

                if ($(this).is(':checked'))
                {
                    $('#<%= ListBoxVISNsLocalReadonly.ClientID %>').removeAttr('disabled');
                }
                else
                {
                    $('#<%= ListBoxVISNsLocalReadonly.ClientID %>').attr('disabled', 'disabled');
                    $('#<%= ListBoxVISNsLocalReadonly.ClientID %> option:selected').attr('selected', false);
                }
            });


            if ($('#<%= CheckBoxRoleLocalAdmin.ClientID  %>').is(':checked'))
            {
                $('tr.child td span').attr('disabled', 'disabled');
                $('tr.child td input:checkbox').attr('disabled', 'disabled');
                $('tr.child td select').attr('disabled', 'disabled');

                $('tr.child td input:checkbox').attr('checked', false);
                $('tr.child td option:selected').attr('selected', false);

            }
            else
            {
                $('tr.child td span').removeAttr('disabled');
                $('tr.child td input:checkbox').removeAttr('disabled');
                //$('tr.child td select').removeAttr('disabled');
            }

        });     
    
   </script>   
        <asp:Panel ID="PanelObjectContent" runat="server">
            <br /><uc1:ErrorList ID="ErrorList1" runat="server" />
        <asp:Panel ID="PanelListUserRoles" runat="server" GroupingText="User / Roles&nbsp;&nbsp;" Width="95%">
                <div class = "excludeSaveWarnings">
                <br />
                <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
                                
                <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="100"></asp:TextBox>
                &nbsp;
                <asp:Button ID="ButtonSearch" runat="server" Text=" Search " />
                &nbsp;
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
                    onclick="ButtonClear_Click" />
                <br />
                </div> 
                <br />
                <asp:GridView ID="GridViewUserRoles" runat="server" DataKeyNames="USER_ROLE_ID"
                    DataSourceID="ObjectDataSourceUsersRoles" AutoGenerateColumns="False" 
                    AllowPaging="True"
                    AllowSorting="True" Caption="Users" EmptyDataText="No User Roles">
                    <Columns>
                        <asp:HyperLinkField DataNavigateUrlFields="USER_ID" SortExpression="USER_ID" NavigateUrl="~/AdminEditUsersRoles.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                            DataNavigateUrlFormatString="AdminEditUsersRoles.aspx?id={0}"
                            DataTextField="USER_ID" HeaderText="ID">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                        </asp:HyperLinkField>
                        <asp:TemplateField HeaderText="NT Username" SortExpression="USER.USERNAME">
                           <ItemTemplate>                                     
                               <asp:Label ID="LabelUserName"  runat="server"  Text='<%# ((USER_ROLE)Container.DataItem).USER.USERNAME %>'></asp:Label>                             
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="Full Name" SortExpression="USER.FULL_NAME">
                           <ItemTemplate>                                
                               <asp:Label ID="LabelFullName" runat="server" Text='<%#((USER_ROLE)Container.DataItem).USER.FULL_NAME %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="Role" SortExpression="STD_ROLE.NAME">
                           <ItemTemplate>                                
                               <asp:Label ID="LabelRoleName" runat="server" Text='<%# ((USER_ROLE)Container.DataItem).STD_ROLE.NAME %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                        <asp:TemplateField HeaderText="VISN / Station / Division" SortExpression="STD_INSTITUTION.VISN_ID">
                           <ItemTemplate>                                
                              <asp:Label ID="LabelVISNName" runat="server" Text='<%# ((USER_ROLE)Container.DataItem).STD_INSTITUTION.FullVISNName %>'></asp:Label>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Left" />
                            <ItemStyle HorizontalAlign="Left" />
                        </asp:TemplateField>
                        
                    </Columns>
                </asp:GridView>
                <br />
                <asp:Button ID="ButtonDownloadToExcel" runat="server" onclick="ButtonDownloadToExcel_Click" 
                    Text="Download To Excel" />
                <br />
                <br />
                <asp:ObjectDataSource ID="ObjectDataSourceUsersRoles" runat="server" 
                    SelectMethod="SelectListUsersVISNs" 
                    SelectCountMethod="SelectListUsersVISNsCount"
                    StartRowIndexParameterName="startRow" 
                    MaximumRowsParameterName="maxRows" 
                    SortParameterName="sort"
                    EnablePaging="True"  
                    TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager" 
                    DeleteMethod="RemoveUserFromRegistry">
                    <DeleteParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                    </DeleteParameters>
                    <SelectParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                        <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue=""
                            Name="searchCriteria" PropertyName="Text" Type="String" />
                        <asp:Parameter Name="sort" Type="String" />
                        <asp:Parameter Name="startRow" Type="Int32" />
                        <asp:Parameter Name="maxRows" Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
        </asp:Panel>
        <asp:Panel ID="PanelRoleInformation" runat="server" GroupingText="Edit User Role Information" 
            Width="65%">
            <br />
            <asp:Panel ID="PanelUserProfile" runat="server" GroupingText="&nbsp;User Profile&nbsp;&nbsp;" 
            Width="98%">
                <table border="0" width="100%" >
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelUsername" runat="server" 
                                AssociatedControlID="LabelUsername" SkinID="DataLabel">NT Username:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelUsername" runat="server"  Text="Username" 
                                SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            <hr />
                        </td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelFullName" runat="server" 
                                AssociatedControlID="LabelFullName" SkinID="DataLabel">Full Name:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelFullName" runat="server"  Text="Full Name" 
                                SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelEmployeeNumber" runat="server" 
                                AssociatedControlID="LabelEmployeeNumber" SkinID="DataLabel">Employee Number:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelEmployeeNumber" runat="server"  
                                Text="Employee Number:" SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                    <tr>
                        <td class="style2">
                            <asp:Label ID="LabelforLabelJobTitle" runat="server" 
                                AssociatedControlID="LabelJobTitle" SkinID="DataLabel">Job Title:</asp:Label>
                                </td>
                        <td>
                            <asp:Label ID="LabelJobTitle" runat="server"  
                                Text="Job Title:" SkinID="DataLabel"></asp:Label>
                        </td>
                        <td class="style3">
                            &nbsp;</td>
                    </tr>
                </table>
                <asp:HiddenField ID="HiddenFieldUserID" runat="server" />
                <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
            </asp:Panel>
            <table class="style4" >
                <tr>
                    <td class="style6">
                        <asp:Label ID="LabelRolesHeader" runat="server">Roles</asp:Label>
                                </td>
                    <td>
                        &nbsp;</td>
                </tr>
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleAdministrator" runat="server" 
                            Text="MSSR SYSTEM ADMINISTRATOR" />
                    </td>
                </tr>
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleSurveyViewEdit" runat="server" 
                            Text="MSSR MSAT VIEW AND EDIT" />
                    </td>
                </tr>
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleNational" runat="server" 
                            Text="MSSR NATIONAL" />
                    </td>
                </tr>
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleNationalReadOnly" runat="server" 
                            Text="MSSR NATIONAL READONLY" />
                    </td>
                </tr>
                <!-- MSSR_LOCAL_ADMINISTRATOR -->
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleLocalAdmin" runat="server" Text="MSSR LOCAL ADMINISTRATOR" 
                            AutoPostBack="false" />
                    </td>
                </tr>
                <tr>
                    <td class="style6">
                        &nbsp;</td>
                    <td>
                        <asp:Label ID="LabelforListBoxVISNsLocalAdmin" runat="server" AssociatedControlID="ListBoxVISNsLocalAdmin">VISN Access:</asp:Label>
                                <br />
                        <asp:ListBox ID="ListBoxVISNsLocalAdmin" runat="server" Rows="20" SelectionMode="Multiple" Enabled="true"
                            DataSourceID="ObjectDataSourceVISNStationOnlyList" DataTextField="FullVISNName" DataValueField="ID">
                        </asp:ListBox>
                    </td>
                </tr>
                <!-- MSSR_LOCAL -->
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleLocal" runat="server" 
                            Text="MSSR LOCAL" AutoPostBack="false" 
                             />
                    </td>
                </tr>
                <tr>
                    <td class="style6">
                        &nbsp;</td>
                    <td>
                        <asp:Label ID="LabelforListBoxVISNsLocal" runat="server" AssociatedControlID="ListBoxVISNsLocal">VISN Access:</asp:Label>
                                <br />
                        <asp:ListBox ID="ListBoxVISNsLocal" runat="server" Rows="20" SelectionMode="Multiple" Enabled="true"
                            DataSourceID="ObjectDataSourceVISNStationOnlyList" DataTextField="FullVISNName" DataValueField="ID">
                        </asp:ListBox>
                    </td>
                </tr>
                <!-- MSSR_LOCAL_READONLY -->
                <tr>
                    <td class="style5" colspan="2">
                        <asp:CheckBox ID="CheckBoxRoleLocalReadonly" runat="server" Text="MSSR LOCAL READONLY" AutoPostBack="false" />
                    </td>
                </tr>
                <tr>
                    <td class="style6">
                        &nbsp;</td>
                    <td>
                        <asp:Label ID="LabelforListBoxVISNsLocalReadonly" runat="server" AssociatedControlID="ListBoxVISNsLocalReadonly">VISN Access:</asp:Label>
                                <br />
                        <asp:ListBox ID="ListBoxVISNsLocalReadonly" runat="server" Rows="20" SelectionMode="Multiple" Enabled="true"
                            DataSourceID="ObjectDataSourceVISNStationOnlyList" DataTextField="FullVISNName" DataValueField="ID">
                        </asp:ListBox>
                    </td>
                </tr>
            </table>
            <br />
            <asp:CheckBoxList ID="CheckBoxListUserRoles" runat="server" 
                RepeatDirection="Vertical" RepeatColumns="0" RepeatLayout="Table"
                        DataSourceID="" DataTextField="NAME" 
                        DataValueField="ID" Visible="False">
            </asp:CheckBoxList>
            <br />
            <br />
            <asp:Button ID="ButtonSave" runat="server" onclick="ButtonSave_Click" 
                Text="  Save  " />
            &nbsp;&nbsp;
            <asp:Button ID="ButtonClose" runat="server" onclick="ButtonClose_Click" 
                SkinID="CloseButton" Text="Cancel" UseSubmitBehavior = "false" />
            <br />
            <asp:ObjectDataSource ID="ObjectDataRegistryRoles" runat="server" 
                    SelectMethod="SelectActiveByRegistryCode" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.RoleManager"> 
                    <SelectParameters>
                        <asp:ControlParameter ControlID="HiddenFieldRegistryName" DefaultValue="0" 
                            Name="RegistryCode" PropertyName="Value" Type="String" />
                    </SelectParameters>
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataRegistryVISNs" runat="server" 
                    SelectMethod="GetVISNStationDivisionList" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataSourceVISNOnlyList" runat="server" 
                    SelectMethod="GetVISNOnlyList" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataSourceVISNStationOnlyList" runat="server" 
                    SelectMethod="GetVISNStationOnlyList" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataRegistryVISNsPolyTrauma" runat="server" 
                    SelectMethod="GetPolyTraumaVAMCAdminList" 
                    TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists"> 
            </asp:ObjectDataSource>
      
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false">
            You do not have access to the user id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false">
            No record found for the user ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>
    
    <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />      

</asp:Content>
