﻿<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminEditUsers.aspx.cs" Inherits="AdminEditUsers"
    Title="MSSR: Admin Edit User" %>

<%@ Register Src="controls/ErrorList.ascx" TagName="ErrorList" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:ValidationSummary ID="ValidationSummaryAdminEditUsers" runat="server" TabIndex="1" ValidationGroup="OnSave" HeaderText="The page has the following data errors:"
        DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="True" />
    <asp:Panel ID="PanelObjectContent" runat="server">
        <br />
        <uc1:ErrorList ID="ErrorList1" runat="server" />
        <asp:Panel ID="PanelNewUserSearchID" runat="server" GroupingText="Search NT Username" Width="95%">
            <br />
            <asp:Label ID="LabelSearchInstructions" runat="server">
            To add a new user, first search if the NT username exists in the Registries application:
            </asp:Label>
            <br />
            <br />
            <div class="excludeSaveWarnings">
                <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Search:</asp:Label>
                <asp:TextBox ID="TextBoxSearchCriteria" runat="server" TabIndex="2" Width="100">
                </asp:TextBox>
                &nbsp;
                <asp:Button ID="ButtonSearch" runat="server" Text=" Search " OnClick="ButtonSearch_Click" />
                &nbsp;
                <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
            </div>
            <br />
            <br />
            <asp:Label ID="LabelUsernameExists" runat="server" Visible="false">
                You cannot add a new account with this NT username.<br />
                The following account has the NT username.  If you want to grant this account access to your registry click the "Add" button below.
                <br />
                <br />
            </asp:Label>
            <asp:GridView ID="GridViewUsers" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" Caption="Users"
                DataKeyNames="USER_ID" DataSourceID="" EmptyDataText="No Users" Visible="false" Width="90%">
                <Columns>
                    <asp:BoundField DataField="USER_ID" HeaderText="Id" SortExpression="USER_ID" />
                    <asp:BoundField DataField="USERNAME" HeaderText="NT Username" SortExpression="USERNAME" />
                    <asp:BoundField DataField="FULL_NAME" HeaderText="Name" SortExpression="LAST_NAME" />
                    <asp:BoundField DataField="EMAIL_ADDRESS" HeaderText="Email" SortExpression="EMAIL_ADDRESS" />
                </Columns>
            </asp:GridView>
            <br />
            <asp:Button ID="ButtonAddUser" runat="server" Text="  Add  " Visible="false" OnClick="ButtonAddUser_Click" />
            <asp:Label ID="LabelUsernameIsInRegistry" runat="server" Visible="false">
                You cannot add this NT username.  An account with the NT username above is already a member of the registry.
                <br />
                <br />
            </asp:Label>
            <asp:Button ID="ButtonViewEditUser" runat="server" Text=" View / Edit User Account " Visible="false" OnClick="ButtonViewEditUser_Click" />
            <br />
            <asp:ObjectDataSource ID="ObjectDataSourceUsers" runat="server" SelectMethod="SelectByUsername" TypeName="VeteransAffairs.Registries.BusinessManager.UsersManager">
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxSearchCriteria" DefaultValue="" Name="Username" PropertyName="Text" Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </asp:Panel>
        <asp:Panel ID="PanelUserInformation" runat="server" GroupingText="Edit User Account Information" Width="65%">
            <br />
            <asp:Label ID="LabelforTextBoxUsername" runat="server" AssociatedControlID="TextBoxUsername">NT Username:</asp:Label>
            <asp:TextBox ID="TextBoxUsername" runat="server" TabIndex="3" MaxLength="30" Width="145px" />
            <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxUsername" runat="server" ValidationGroup="OnSave" ControlToValidate="TextBoxUsername"
                ErrorMessage="Username is required" TabIndex="4" SetFocusOnError="true">
            </asp:RequiredFieldValidator>
            <br />
            <hr style="width: 1" />
            <asp:Label ID="LabelforTextBoxFullName" runat="server" AssociatedControlID="TextBoxFullName">Full Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxFullName" runat="server" TabIndex="5" MaxLength="100" Text="" Width="400px" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxFirstName" runat="server" AssociatedControlID="TextBoxFirstName">First Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxFirstName" runat="server" TabIndex="6" MaxLength="30" Text="" Width="145px" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxMiddleName" runat="server" AssociatedControlID="TextBoxMiddleName">Middle Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxMiddleName" runat="server" MaxLength="30" Text="" Width="145px" TabIndex="7" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxLastName" runat="server" AssociatedControlID="TextBoxLastName">Last Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxLastName" runat="server" MaxLength="40" Text="" Width="200px" TabIndex="8" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxMaidenName" runat="server" AssociatedControlID="TextBoxMaidenName">Maiden Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxMaidenName" runat="server" TabIndex="9" MaxLength="40" Text="" Width="200px" />
            <br />
            <hr style="width: 1" />
            <asp:Label ID="LabelforTextBoxEmployeeNumber" runat="server" AssociatedControlID="TextBoxEmployeeNumber">Employee Number:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxEmployeeNumber" runat="server" TabIndex="10" MaxLength="50" Text="" Width="200px" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxJobTitle" runat="server" AssociatedControlID="TextBoxJobTitle">Job Title:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxJobTitle" runat="server" TabIndex="11" MaxLength="80" Text="" Width="400px" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxEmailAddress" runat="server" AssociatedControlID="TextBoxEmailAddress">Email Address:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxEmailAddress" runat="server" TabIndex="12" MaxLength="128" Text="" Width="500px" />
            <asp:RegularExpressionValidator ID="UserEMailValidator" runat="server" TabIndex="13" SetFocusOnError="true" ControlToValidate="TextBoxEmailAddress"
                ErrorMessage="Invalid e-mail" ValidationExpression="^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$" ValidationGroup="OnSave">
            </asp:RegularExpressionValidator>
            <br />
            <hr style="width: 1" />
            <asp:Label ID="LabelforTextBoxTelephone" runat="server" AssociatedControlID="TextBoxTelephone">Telephone:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxTelephone" runat="server" TabIndex="14" MaxLength="30" Text="" Width="145px" />
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxFax" runat="server" AssociatedControlID="TextBoxFax">Fax:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxFax" runat="server" TabIndex="15" MaxLength="30" Text="" Width="145px" />
            <br />
            <br />
            <hr style="width: 1" />
            <asp:Label ID="LabelCreatedByCaption" runat="server" AssociatedControlID="LabelCreatedBy" SkinID="DataLabel">Created By:</asp:Label>
            <asp:Label ID="LabelCreatedBy" runat="server" SkinID="DataLabel"></asp:Label>
            <asp:Label ID="LabelCreatedOnCaption" runat="server" AssociatedControlID="LabelCreatedOn" SkinID="DataLabel">&nbsp;&nbsp; Created On:</asp:Label>
            <asp:Label ID="LabelCreatedOn" runat="server" SkinID="DataLabel"></asp:Label>
            <br />
            <asp:Label ID="LabelUpdatedByCaption" runat="server" AssociatedControlID="LabelUpdatedBy" SkinID="DataLabel">Updated By:</asp:Label>
            <asp:Label ID="LabelUpdatedBy" runat="server" SkinID="DataLabel"></asp:Label>
            <asp:Label ID="LabelUpdatedOnCaption" runat="server" AssociatedControlID="LabelUpdatedOn" SkinID="DataLabel">&nbsp;&nbsp; Updated On:</asp:Label>
            <asp:Label ID="LabelUpdatedOn" runat="server" Text=""></asp:Label>
            <br />
            <asp:HiddenField ID="HiddenFieldUserID" runat="server" />
            <asp:HiddenField ID="HiddenFieldInsertingNewUser" runat="server" />
            <asp:HiddenField ID="HiddenFieldSelectedUsername" runat="server" />
            <asp:HiddenField ID="HiddenFieldBreadCrumbBaseText" runat="server" />
            &nbsp;</asp:Panel>
        <br />
        <asp:Button ID="ButtonSave" runat="server" TabIndex="16" ValidationGroup="OnSave" OnClick="ButtonSave_Click" Text="  Save  " />
        &nbsp;&nbsp;
        <asp:Button ID="ButtonClose" runat="server" OnClick="ButtonClose_Click" TabIndex="17" SkinID="CloseButton" Text="Cancel" UseSubmitBehavior="false" />
        <br />
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false">
        You do not have access to the user id supplied.
        <br />
        <br />
        Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false">
        No record found for the user ID supplied.
        <br />
        <br />
        If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you
        have supplied a correct id.
    </asp:Panel>
</asp:Content>
